DROP TABLE IF EXISTS `{db_prefix}geo_mapping`;
CREATE TABLE IF NOT EXISTS `{db_prefix}geo_mapping` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `Format_key` varchar(255) NOT NULL,
  `Place_ID` varchar(188) DEFAULT NULL,
  `Lat` double NOT NULL,
  `Lng` double NOT NULL,
  `Target` enum('region','city') NOT NULL DEFAULT 'city',
  `Verified` enum('1','0') NOT NULL DEFAULT '1',
  PRIMARY KEY (`ID`),
  KEY `Format_key` (`Format_key`),
  KEY `Verified` (`Verified`)
) ENGINE=InnoDB CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_switzerland', 'ChIJYW1Zb-9kjEcRFXvLDxG1Vlw', 46.818188, 8.227512, 'region', '1'),
('countries_switzerland_aargau', 'ChIJK32y9fMXkEcRfc5XB_gNGvg', 47.3876664, 8.2554295, 'region', '1'),
('countries_switzerland_appenzell_ausserrhoden', 'ChIJ979wCHEfm0cRD6-ER66wR4E', 47.366481, 9.3000916, 'region', '1'),
('countries_switzerland_appenzell_innerrhoden', 'ChIJh1Ha4mQXm0cRT4yedLMmXbA', 47.3161925, 9.4316573, 'region', '1'),
('countries_switzerland_basel_city', 'ChIJZW5Lc163kUcR_qJqDx28q3Y', 47.5619253, 7.592768, 'region', '1'),
('countries_switzerland_basel_landschaft', 'ChIJNQdrO_i1kUcRE3lb88jFOqw', 47.4418122, 7.7644002, 'region', '1'),
('countries_switzerland_bern', 'ChIJdxs61MA5jkcRmmVXBP5fVcs', 46.9479739, 7.4474468, 'region', '1'),
('countries_switzerland_fribourg', 'ChIJL31ajc1ujkcRLsM3ufbR5bs', 46.8064773, 7.1619719, 'region', '1'),
('countries_switzerland_geneva', 'ChIJ6-LQkwZljEcRObwLezWVtqA', 46.2043907, 6.1431577, 'region', '1'),
('countries_switzerland_glarus', 'ChIJUch2OooxhUcRskRR7dNUM4I', 47.0411232, 9.0679, 'region', '1'),
('countries_switzerland_grisons', 'ChIJGwykPoKRhEcRENgYQIj_AAE', 46.6569871, 9.5780257, 'region', '1'),
('countries_switzerland_jura', 'ChIJtV6GwMXkkUcRkNgYQIj_AAE', 47.3444474, 7.1430608, 'region', '1'),
('countries_switzerland_lucerne', 'ChIJeXNUeSr6j0cRr1KZQNEq8K4', 47.0501682, 8.3093072, 'region', '1'),
('countries_switzerland_neuchatel', 'ChIJm81S1RkKjkcRBGS2VWjDXCM', 46.9899874, 6.9292732, 'region', '1'),
('countries_switzerland_nidwalden', 'ChIJ58I7cff1j0cRYNcYQIj_AAE', 46.9267016, 8.3849982, 'region', '1'),
('countries_switzerland_obwalden', 'ChIJ7zEf3Ufyj0cRO9o02ufd0UM', 46.877858, 8.251249, 'region', '1'),
('countries_switzerland_saint_gallen', 'ChIJVdgzdikem0cRFGH-HwhQIpo', 47.4244818, 9.3767173, 'region', '1'),
('countries_switzerland_schaffhausen', 'ChIJDWW3FV5_kEcR50s-cJii498', 47.6958897, 8.6380489, 'region', '1'),
('countries_switzerland_schwyz', 'ChIJ7VS9qRtNhUcRdtxWrRvoCfE', 47.0207138, 8.6529884, 'region', '1'),
('countries_switzerland_solothurn', 'ChIJR3O5lfDXkUcRqRONVOYOqZY', 47.2088348, 7.532291, 'region', '1'),
('countries_switzerland_thurgau', 'ChIJQXF3xLXrmkcR3143PnN4ED4', 47.6037856, 9.0557371, 'region', '1'),
('countries_switzerland_ticino', 'ChIJg946LtqXhUcRuN5YORraPgw', 46.331734, 8.8004529, 'region', '1'),
('countries_switzerland_uri', 'ChIJh70oMINDhUcR16HLniPoKFA', 46.7738629, 8.6025153, 'region', '1'),
('countries_switzerland_valais', 'ChIJF5p_6psij0cRYNgYQIj_AAE', 46.1904614, 7.5449226, 'region', '1'),
('countries_switzerland_vaud', 'ChIJtZALbaItjEcRUNgYQIj_AAE', 46.5613135, 6.536765, 'region', '1'),
('countries_switzerland_zug', 'ChIJ8-RGYCmrmkcREOrjxwO_UKk', 47.1661672, 8.5154946, 'region', '1'),
('countries_switzerland_zurich', 'ChIJGaK-SZcLkEcRA9wf5_GNbuY', 47.3768866, 8.541694, 'region', '1'),
('countries_switzerland_aargau_aarau', 'ChIJcV4cFuw7kEcRH3-Zl_pIS88', 47.390434, 8.0457015, 'city', '1'),
('countries_switzerland_aargau_aarburg', 'ChIJ07Vy1jIukEcRCBE0NrhaIIY', 47.3205914, 7.9066923, 'city', '1'),
('countries_switzerland_thurgau_engwang', 'ChIJHeE7P__ymkcR-rcwHAaNC7w', 47.60004, 9.05287, 'city', '0'),
('countries_switzerland_aargau_alikon', 'ChIJ49hbkrwDkEcRc9aPyAgpwKU', 47.1990598, 8.3593899, 'city', '1'),
('countries_switzerland_aargau_ammerswil', 'ChIJgU5a7fQWkEcRnIuA_mNFPBc', 47.3694701, 8.2069648, 'city', '1'),
('countries_switzerland_aargau_anglikon', 'ChIJG6DbNDgRkEcRIuadECslLQQ', 47.36505, 8.26223, 'city', '1'),
('countries_switzerland_aargau_aristau', 'ChIJ85KQh3AFkEcRYHkZQIj_AAQ', 47.2941874, 8.3599148, 'city', '1'),
('countries_switzerland_aargau_arni', 'ChIJtQxh0coIkEcRXOAjt6R50lg', 47.31856, 8.42034, 'city', '1'),
('countries_switzerland_aargau_attelwil', 'ChIJP6sAYvIjkEcR79Q8veJdtvc', 47.2598028, 8.043949, 'city', '1'),
('countries_switzerland_aargau_auenstein', 'ChIJgSfOJUI-kEcRxWU4Q0HkojA', 47.4166971, 8.1362613, 'city', '1'),
('countries_switzerland_aargau_auw', 'ChIJ44Ly-oMDkEcROAmAl6zHznY', 47.2116473, 8.3643384, 'city', '1'),
('countries_switzerland_aargau_baden', 'ChIJ7Y326MZskEcRQFdiJY87Iys', 47.47288, 8.30809, 'city', '1'),
('countries_switzerland_aargau_bad_zurzach', 'ChIJiyPedttokEcRflNekvVW6yI', 47.5877895, 8.2933248, 'city', '1'),
('countries_switzerland_aargau_baldingen', 'ChIJoWjQLrFukEcR4ByI-KCc1z4', 47.55505, 8.31702, 'city', '1'),
('countries_switzerland_thurgau_engishofen', 'ChIJMfNAGzD7mkcRzxIk7ufyZzs', 47.5576302, 9.251877, 'city', '0'),
('countries_switzerland_aargau_beinwil_freiamt', 'ChIJvVDxnZoEkEcRAROSVK6b5us', 47.2300917, 8.3429977, 'city', '1'),
('countries_switzerland_aargau_bellikon', 'ChIJcTkqrggSkEcRoLDcY0r-vXw', 47.3891984, 8.3440277, 'city', '1'),
('countries_switzerland_aargau_benzenschwil', 'ChIJucKYT1gEkEcRH2Ef6T9sdyo', 47.2479093, 8.3648949, 'city', '1'),
('countries_switzerland_aargau_bergdietikon', 'ChIJbY1n48QNkEcRFDRmewhPR8I', 47.3934257, 8.390457, 'city', '1'),
('countries_switzerland_aargau_berikon', 'ChIJcdR3fkUOkEcRhQxzoTiXFLI', 47.352, 8.37021, 'city', '1'),
('countries_switzerland_aargau_bettwil', 'ChIJSWj70ooakEcRtLvAGmvfq9Y', 47.2903281, 8.2693321, 'city', '1'),
('countries_switzerland_aargau_biberstein', 'ChIJkwB_3ck-kEcRa5Ol5TXi7DM', 47.4137159, 8.0813767, 'city', '1'),
('countries_switzerland_aargau_birmenstorf', 'ChIJIdPyd7sUkEcRtUEjaQI1JIc', 47.4595188, 8.2498947, 'city', '1'),
('countries_switzerland_aargau_birr', 'ChIJ24dKiw4VkEcRo8LE1w6m24Q', 47.4363544, 8.2059141, 'city', '1'),
('countries_switzerland_aargau_birrhard', 'ChIJ6-W6yvMUkEcRLMYWTY7C10A', 47.432565, 8.2440188, 'city', '1'),
('countries_switzerland_aargau_birrwil', 'ChIJIZgUPrkZkEcRGWTY3k1R_EA', 47.2887342, 8.1982023, 'city', '1'),
('countries_switzerland_thurgau_donzhausen', 'ChIJHwYpwKz6mkcReOS-nH1ZJxk', 47.55414, 9.19619, 'city', '0'),
('countries_switzerland_thurgau_burglen', 'ChIJ34Pnlt5GhUcRz1EsjSbheRo', 46.8761523, 8.6644631, 'city', '0'),
('countries_switzerland_aargau_boniswil', 'ChIJF0I0WYQXkEcRHf8sGi0N-YE', 47.3175046, 8.1871583, 'city', '1'),
('countries_switzerland_aargau_boswil', 'ChIJZfshXKYakEcRwHkZQIj_AAQ', 47.3008078, 8.3128941, 'city', '1'),
('countries_switzerland_aargau_bottenwil', 'ChIJh5dJgFgkkEcRtfWk_iqYidU', 47.2857941, 8.0065335, 'city', '1'),
('countries_switzerland_thurgau_buchackern', 'ChIJLw1HhyflmkcRkBoTkJtsox4', 47.5390745, 9.2320417, 'city', '0'),
('countries_switzerland_aargau_bremgarten', 'ChIJUXMxRtIRkEcR7JqSDwxjeRg', 47.3491774, 8.3397905, 'city', '1'),
('countries_switzerland_aargau_brittnau', 'ChIJS_xZh1YvkEcR5KOLWpnuhMk', 47.2597136, 7.9469694, 'city', '1'),
('countries_switzerland_aargau_brugg', 'ChIJC3w19LtqkEcRLpIYBC8hXGo', 47.4867355, 8.2109103, 'city', '1'),
('countries_switzerland_aargau_brunegg', 'ChIJvTx7UE0UkEcRyXmPCxM5oqo', 47.4189511, 8.2169852, 'city', '1'),
('countries_switzerland_aargau_buchs', 'ChIJC9RYMRA8kEcR7uerEGUXALQ', 47.3910649, 8.0798273, 'city', '1'),
('countries_switzerland_thurgau_bonau', 'ChIJ52PFCovymkcRN6G9ci2RHv4', 47.5825, 9.04434, 'city', '0'),
('countries_switzerland_aargau_burg', 'ChIJUVEhO8wekEcRlA0cynjbgNM', 47.236301, 8.1798479, 'city', '1'),
('countries_switzerland_thurgau_balterswil', 'ChIJVYjZgxyVmkcRUWFHSqxHECY', 47.449971, 8.9299885, 'city', '1'),
('countries_switzerland_aargau_buttwil', 'ChIJb2q7HtEakEcReH0-HGcf0qs', 47.267992, 8.3108014, 'city', '1'),
('countries_switzerland_aargau_dattwil', 'ChIJLe_ZHFATkEcRAwpFoa_kLpw', 47.4550943, 8.287015, 'city', '1'),
('countries_switzerland_solothurn_woeschnau', 'ChIJ5WrNObc7kEcR2aexL1vYK3U', 47.3758233, 8.02418, 'city', '1'),
('countries_switzerland_aargau_dietwil', 'ChIJJVdkgOQBkEcRpsnsd_uF_ks', 47.1488021, 8.3920498, 'city', '1'),
('countries_switzerland_aargau_dintikon', 'ChIJReahUu8WkEcRiibKZVz2Ti8', 47.3644751, 8.2280787, 'city', '1'),
('countries_switzerland_aargau_dottikon', 'ChIJFSlQxK8WkEcROUwQcUVHOp8', 47.3830192, 8.2430405, 'city', '1'),
('countries_switzerland_aargau_effingen', 'ChIJ37AnwrxAkEcRReU3ysm8GcM', 47.4886223, 8.10427, 'city', '1'),
('countries_switzerland_aargau_eggenwil', 'ChIJP-u73OQRkEcRvfSuuNJ43rA', 47.3702231, 8.3401721, 'city', '1'),
('countries_switzerland_aargau_egliswil', 'ChIJmTxWQqsXkEcRUHgZQIj_AAQ', 47.3492167, 8.1879722, 'city', '1'),
('countries_switzerland_aargau_ehrendingen', 'ChIJwcRiPQdtkEcRY3-OzyDG-wY', 47.4972188, 8.342054, 'city', '1'),
('countries_switzerland_aargau_eiken', 'ChIJ4TNFU4VIkEcRiq9S2CtjP-0', 47.5331075, 7.9871358, 'city', '1'),
('countries_switzerland_aargau_elfingen', 'ChIJzal6sdNAkEcRUEkZQIj_AAQ', 47.5084111, 8.0994405, 'city', '1'),
('countries_switzerland_aargau_endingen', 'ChIJXWZX6fVrkEcRkr4OpJ0pVSM', 47.5380994, 8.2903426, 'city', '1'),
('countries_switzerland_aargau_ennetbaden', 'ChIJ21oA291skEcRdrInfKTe_1o', 47.4795038, 8.3143249, 'city', '1'),
('countries_switzerland_solothurn_winistorf', 'ChIJOZNQJzQqjkcRbvE9mKqiJbQ', 47.1565838, 7.6342647, 'city', '1'),
('countries_switzerland_aargau_etzgen', 'ChIJySErjfVDkEcREEwZQIj_AAQ', 47.5704441, 8.1111217, 'city', '1'),
('countries_switzerland_aargau_fahrwangen', 'ChIJHcRJlhAakEcR2GzoH3xTw2w', 47.2946906, 8.2420267, 'city', '1'),
('countries_switzerland_solothurn_wangen', 'ChIJWZgaee_JmkcRMVgkKujytdU', 47.1863572, 8.8975312, 'city', '0'),
('countries_switzerland_aargau_fisibach', 'ChIJqd9dOt5xkEcR6U9aP3nZrpg', 47.5615687, 8.4090582, 'city', '1'),
('countries_switzerland_aargau_fislisbach', 'ChIJa-qABG0TkEcRJGWrSNV4hKw', 47.4387543, 8.2919671, 'city', '1'),
('countries_switzerland_aargau_freienwil', 'ChIJ77eBavVskEcRMBhU9gUzwv0', 47.5035705, 8.3280246, 'city', '1'),
('countries_switzerland_aargau_frick', 'ChIJMXZaq75HkEcRAAEZt1qh1p0', 47.5085197, 8.0186727, 'city', '1'),
('countries_switzerland_solothurn_untererlinsbach', 'ChIJjeX7stI7kEcRsm4Kt1JK1YE', 47.3956232, 8.0161791, 'city', '0'),
('countries_switzerland_aargau_gansingen', 'ChIJC-e5X2pBkEcRIksitP8r-pA', 47.5432404, 8.133845, 'city', '1'),
('countries_switzerland_aargau_gebenstorf', 'ChIJcz4onTxrkEcRo1fsm5dud2Q', 47.4842267, 8.2419897, 'city', '1'),
('countries_switzerland_aargau_geltwil', 'ChIJp228f5oEkEcR5MaXMk6h88U', 47.2492718, 8.3222253, 'city', '1'),
('countries_switzerland_aargau_gipf_oberfrick', 'ChIJs-d64f5HkEcRA2BATz40jGg', 47.4981196, 8.0033184, 'city', '1'),
('countries_switzerland_solothurn_tscheppach', 'ChIJeVL1QF0mjkcR_UoI9RqmjZA', 47.1475099, 7.4799353, 'city', '0'),
('countries_switzerland_aargau_goeslikon', 'ChIJr638U5cRkEcRkSOave5E0VQ', 47.3722258, 8.3072911, 'city', '1'),
('countries_switzerland_aargau_gontenschwil', 'ChIJ5YtNwWQYkEcRz4DYbtBUNYQ', 47.2801607, 8.1447557, 'city', '1'),
('countries_switzerland_solothurn_stuesslingen', 'ChIJ5Spky6cwkEcRiz5OFTUJ5Sc', 47.393752, 7.9706516, 'city', '1'),
('countries_switzerland_aargau_habsburg', 'ChIJ1XBjh1AVkEcRhjn7XqXkGXo', 47.4626153, 8.1860531, 'city', '1'),
('countries_switzerland_solothurn_starrkirch', 'ChIJ82kLhDwwkEcRRqbatsQnc6Q', 47.3464105, 7.92635, 'city', '1'),
('countries_switzerland_aargau_hallwil', 'ChIJk_AEcJAXkEcRm-VJHMfIh4Q', 47.3299656, 8.1743906, 'city', '1'),
('countries_switzerland_aargau_hellikon', 'ChIJGX1KZupJkEcRy0eJTL90LGA', 47.5099292, 7.9241818, 'city', '1'),
('countries_switzerland_aargau_hendschiken', 'ChIJnUIkAoQWkEcRlw7_EjH9VdA', 47.38572, 8.21933, 'city', '1'),
('countries_switzerland_aargau_hermetschwil_staffeln', 'ChIJz1vSA9YPkEcRfm8kQ9s_3Oo', 47.3307554, 8.3411019, 'city', '1'),
('countries_switzerland_solothurn_seewen_so', 'ChIJA2sUGdbIkUcRWT6KFVYZ_No', 47.4365858, 7.6603489, 'city', '0'),
('countries_switzerland_aargau_herznach', 'ChIJNfXPAIU4kEcR_ZE72E5FEw8', 47.4742674, 8.0507173, 'city', '1'),
('countries_switzerland_aargau_hettenschwil', 'ChIJeQRMSW5CkEcR_Y7-kB2EHK4', 47.57653, 8.199194, 'city', '1'),
('countries_switzerland_aargau_hilfikon', 'ChIJ1a5scsoQkEcRwT2v2JmsrUQ', 47.3331334, 8.2465197, 'city', '1'),
('countries_switzerland_aargau_hirschthal', 'ChIJ5_OT60ojkEcRTc00FkBHWEs', 47.3188006, 8.0527123, 'city', '1'),
('countries_switzerland_aargau_holziken', 'ChIJ8yHE964kkEcRtOrozScRjco', 47.3215574, 8.0376896, 'city', '1'),
('countries_switzerland_aargau_hornussen', 'ChIJUY9cFQ1HkEcR_f0x_nXcIIE', 47.4998388, 8.0646316, 'city', '1'),
('countries_switzerland_aargau_hottwil', 'ChIJR6iZKYVBkEcRPQbXtH5bfaY', 47.5475852, 8.161276, 'city', '1'),
('countries_switzerland_aargau_hunzenschwil', 'ChIJ7VPLZ8E9kEcRwHcvG2o6YMg', 47.3864912, 8.1226224, 'city', '1'),
('countries_switzerland_aargau_islisberg', 'ChIJwXtCf8wIkEcRmqomZqX4Ovw', 47.3231894, 8.4393759, 'city', '1'),
('countries_switzerland_aargau_jonen', 'ChIJS0Ec_V4PkEcRLDDPHHClS-Y', 47.2969656, 8.3943149, 'city', '1'),
('countries_switzerland_aargau_kaiseraugst', 'ChIJvdzXMLa1kUcRuzQTc4jN524', 47.5380277, 7.7289624, 'city', '1'),
('countries_switzerland_aargau_kaiserstuhl', 'ChIJeSHz8M1xkEcR0eJr8UXOWzA', 47.5675585, 8.4182689, 'city', '1'),
('countries_switzerland_aargau_kaisten', 'ChIJO4TdL0NGkEcRgNvV74QBxGc', 47.54033, 8.04439, 'city', '1'),
('countries_switzerland_aargau_kallern', 'ChIJG24AVngQkEcRtKu3M4wIdMk', 47.3121376, 8.2941481, 'city', '1'),
('countries_switzerland_aargau_killwangen', 'ChIJoTXe-I4SkEcR5L6oY6I-Tmw', 47.4326177, 8.3484353, 'city', '1'),
('countries_switzerland_aargau_kirchleerau', 'ChIJbWuwTqUjkEcRJyXNZ7-mUZU', 47.27383, 8.06632, 'city', '1'),
('countries_switzerland_solothurn_schonenwerd', 'ChIJDaffjrI7kEcRl3RhkCplaoo', 47.3736954, 8.0023269, 'city', '1'),
('countries_switzerland_aargau_klingnau', 'ChIJ---uXkxokEcRIH0ZQIj_AAQ', 47.5810229, 8.2489572, 'city', '1'),
('countries_switzerland_aargau_koblenz', 'ChIJWYbW8T9okEcRIznqNVCimnA', 47.60954, 8.23842, 'city', '1'),
('countries_switzerland_solothurn_sankt_pantaleon', 'ChIJyyEtXnnJkUcRO6W87MxJe-Q', 47.46177, 7.69036, 'city', '1'),
('countries_switzerland_aargau_kunten', 'ChIJF3aG5SISkEcRlGHo2rQm-SI', 47.3895991, 8.3303512, 'city', '1'),
('countries_switzerland_aargau_kuttigen', 'ChIJy-NQims5kEcRgIeCOtrnDwI', 47.4175999, 8.0472144, 'city', '1'),
('countries_switzerland_aargau_laufenburg', 'ChIJ3_TAMtVFkEcRuKQ0C4S2XaU', 47.5596648, 8.0582758, 'city', '1'),
('countries_switzerland_aargau_leibstadt', 'ChIJW0bu5FVCkEcRQ5IiD9_ovMc', 47.5899397, 8.173178, 'city', '1'),
('countries_switzerland_aargau_lenzburg', 'ChIJG--Udg0WkEcRSMIh9jf9k3I', 47.3904443, 8.1721545, 'city', '1'),
('countries_switzerland_aargau_leuggern', 'ChIJLybFTGNCkEcRv_Bu0EVyDjc', 47.5810513, 8.2152586, 'city', '1'),
('countries_switzerland_aargau_leutwil', 'ChIJt-WbwTEYkEcRXwFEegY21Ts', 47.3100762, 8.1736563, 'city', '1'),
('countries_switzerland_aargau_lupfig', 'ChIJm0a_ixEVkEcRPkMhhMcCVnA', 47.4409386, 8.2044259, 'city', '1'),
('countries_switzerland_aargau_magden', 'ChIJGQZZSrVKkEcRpaUk8Z4bCN8', 47.5266505, 7.814835, 'city', '1'),
('countries_switzerland_aargau_mandach', 'ChIJ146BMx1CkEcRnlJ-zUXbt7o', 47.5467341, 8.1858144, 'city', '1'),
('countries_switzerland_aargau_meisterschwanden', 'ChIJc_rVvPUZkEcRKQSdZpShFtU', 47.294895, 8.229098, 'city', '1'),
('countries_switzerland_aargau_mellikon', 'ChIJJbVtiPNukEcRcH0ZQIj_AAQ', 47.5681243, 8.3521038, 'city', '1'),
('countries_switzerland_aargau_mellingen', 'ChIJV5NGSngTkEcRMqvD3uY8W0s', 47.4179544, 8.2727454, 'city', '1'),
('countries_switzerland_aargau_menziken', 'ChIJI_6ZdzQZkEcRrnWBRxZtAQ8', 47.2403152, 8.1875302, 'city', '1'),
('countries_switzerland_aargau_merenschwand', 'ChIJhXjut1IEkEcR-Nb7CCCnORs', 47.2594048, 8.3749207, 'city', '1'),
('countries_switzerland_aargau_mettau', 'ChIJecf9EeVDkEcRpMMSCXC8KI0', 47.5638457, 8.1271002, 'city', '1'),
('countries_switzerland_solothurn_ruettenen', 'ChIJu0Lw6izYkUcRi6_K8HN9AP0', 47.2311852, 7.531701, 'city', '1'),
('countries_switzerland_solothurn_rueti', 'ChIJS2KYD4y3mkcRYGQKXP1OeEo', 47.2566995, 8.854421, 'city', '0'),
('countries_switzerland_aargau_moosleerau', 'ChIJPXX__7UjkEcRo5y5YbdKot4', 47.2697, 8.0647511, 'city', '1'),
('countries_switzerland_solothurn_obergosgen', 'ChIJuevEFGIwkEcRtyfngSUMioc', 47.3645336, 7.9512558, 'city', '1'),
('countries_switzerland_solothurn_nuglar', 'ChIJL9X4K4PJkUcRsBIZQIj_AAQ', 47.4713115, 7.6928374, 'city', '1'),
('countries_switzerland_solothurn_niedergosgen', 'ChIJiR9noW86kEcRxVd8YcXPrz8', 47.3729363, 7.9922617, 'city', '1'),
('countries_switzerland_aargau_muhen', 'ChIJ9-yGh7k8kEcRm2fHrn1AI_Q', 47.3323843, 8.0555306, 'city', '1'),
('countries_switzerland_solothurn_mumliswil', 'ChIJNVP4--TRkUcR6Ygq0V-S3Ag', 47.3404622, 7.7044391, 'city', '1'),
('countries_switzerland_aargau_mumpf', 'ChIJS8k_1WNJkEcR0HoZQIj_AAQ', 47.5461315, 7.9196279, 'city', '1'),
('countries_switzerland_aargau_murgenthal', 'ChIJi5ldJsoukEcR4mQrEeTVeIw', 47.2765988, 7.8451321, 'city', '1'),
('countries_switzerland_aargau_muri', 'ChIJfxq15TsFkEcRLtBREZRiicc', 47.2735792, 8.3415566, 'city', '1'),
('countries_switzerland_aargau_nesselnbach', 'ChIJSwHS5dkTkEcRD-VdFfytkPQ', 47.38909, 8.29158, 'city', '1'),
('countries_switzerland_aargau_neuenhof', 'ChIJ3zMaiNsSkEcRb90egmK7fyY', 47.4494044, 8.3274948, 'city', '1'),
('countries_switzerland_aargau_niederlenz', 'ChIJ0Toa1OQVkEcRhH00Qjo1cVE', 47.4015698, 8.1761165, 'city', '1'),
('countries_switzerland_aargau_niederrohrdorf', 'ChIJMS4qeagTkEcRCji5cRbsPFM', 47.42442, 8.30441, 'city', '1'),
('countries_switzerland_solothurn_muehledorf', 'ChIJVfAYIXgmjkcRRmdjw1s0N58', 47.13545, 7.477, 'city', '0'),
('countries_switzerland_aargau_nussbaumen', 'ChIJ9eXltZ5skEcRXm2lQiIZ18A', 47.4881621, 8.2873925, 'city', '1'),
('countries_switzerland_aargau_oberentfelden', 'ChIJVS4PonA7kEcRRxgPB5a08Y8', 47.3564731, 8.0467514, 'city', '1'),
('countries_switzerland_aargau_oberflachs', 'ChIJVbC5FAA_kEcRAEoZQIj_AAQ', 47.4409849, 8.1296349, 'city', '1'),
('countries_switzerland_aargau_oberhof', 'ChIJN2iNBrU5kEcRKHMUBhb4rDA', 47.4517766, 8.0059742, 'city', '1'),
('countries_switzerland_solothurn_metzerlen', 'ChIJMSvm6A3BkUcRoBIZQIj_AAQ', 47.46586, 7.46494, 'city', '0'),
('countries_switzerland_aargau_oberkulm', 'ChIJQbnIuJ4ikEcROb7DOS9ZNds', 47.299952, 8.1238534, 'city', '1'),
('countries_switzerland_aargau_oberlunkhofen', 'ChIJjw6172gPkEcRTDmzRXkqxyA', 47.3113276, 8.3900972, 'city', '1'),
('countries_switzerland_aargau_obermumpf', 'ChIJuYoNLwtJkEcRzZ0grafTXQ4', 47.5299957, 7.9363006, 'city', '1'),
('countries_switzerland_aargau_oberrohrdorf', 'ChIJycUkUc9skEcRcXc_SEMaZw8', 47.423424, 8.3155322, 'city', '1'),
('countries_switzerland_aargau_obersiggenthal', 'ChIJ-bMrI4JrkEcR2Mas0249sYk', 47.4869944, 8.2918057, 'city', '1'),
('countries_switzerland_aargau_oberwil_lieli', 'ChIJeby8bwIPkEcRSMAZ5ZZkRNE', 47.3360982, 8.386898, 'city', '1'),
('countries_switzerland_aargau_oeschgen', 'ChIJu6u7mzJGkEcR4EwZQIj_AAQ', 47.5190933, 8.017178, 'city', '1'),
('countries_switzerland_aargau_oftringen', 'ChIJ02aNofYvkEcR3q7gczKcrWs', 47.3129528, 7.9198655, 'city', '1'),
('countries_switzerland_aargau_othmarsingen', 'ChIJm5WVwDIUkEcRVw2K1eP5_xk', 47.4011262, 8.2153079, 'city', '1'),
('countries_switzerland_aargau_reinach', 'ChIJ5Skhnj0ZkEcRCw1y7BpBORc', 47.2580272, 8.179928, 'city', '1'),
('countries_switzerland_aargau_reitnau', 'ChIJGzBVoPojkEcRrI2TdiInLCc', 47.2504784, 8.0452323, 'city', '1'),
('countries_switzerland_aargau_rekingen', 'ChIJW10Gw91ukEcRYPpc6RaNZuk', 47.56982, 8.32183, 'city', '1'),
('countries_switzerland_aargau_remetschwil', 'ChIJIRR-dkESkEcRAcenRI7XKVM', 47.4083745, 8.3266242, 'city', '1'),
('countries_switzerland_aargau_remigen', 'ChIJ5bw65ixAkEcRVMzCpe7p87s', 47.5157684, 8.1893084, 'city', '1'),
('countries_switzerland_aargau_rheinfelden', 'ChIJUbiGjeq0kUcRdsPMeH6B9PQ', 47.55219, 7.7922914, 'city', '1'),
('countries_switzerland_aargau_rietheim', 'ChIJzbMwR19okEcRFdsle6s2Ze4', 47.6006299, 8.2786232, 'city', '1'),
('countries_switzerland_solothurn_mariastein', 'ChIJMSvm6A3BkUcRoBIZQIj_AAQ', 47.46586, 7.46494, 'city', '1'),
('countries_switzerland_aargau_riniken', 'ChIJ010OHSFAkEcRIEoZQIj_AAQ', 47.4939966, 8.1889919, 'city', '1'),
('countries_switzerland_solothurn_lueterswil', 'ChIJGULLRxgkjkcRjZLtWwFE-eM', 47.1208945, 7.438119, 'city', '1'),
('countries_switzerland_aargau_rothrist', 'ChIJSxRravoukEcRzLS0jirFnAY', 47.302214, 7.8774496, 'city', '1'),
('countries_switzerland_aargau_rottenschwil', 'ChIJUyon4JAPkEcR3eVxOo_xty0', 47.3137172, 8.3620383, 'city', '1'),
('countries_switzerland_solothurn_lueterkofen', 'ChIJu_PdJTUmjkcRsBEZQIj_AAQ', 47.1637394, 7.5106239, 'city', '1'),
('countries_switzerland_solothurn_luesslingen', 'ChIJucIoX5EnjkcRoBEZQIj_AAQ', 47.1902643, 7.5011947, 'city', '1'),
('countries_switzerland_solothurn_kuettigkofen', 'ChIJ37aUfSYmjkcRqARfcbuktZM', 47.15039, 7.51541, 'city', '0'),
('countries_switzerland_aargau_rupperswil', 'ChIJu5vMUHE-kEcRsyugQEF3eZ4', 47.4051347, 8.1290407, 'city', '1'),
('countries_switzerland_aargau_safenwil', 'ChIJo_oWYiQlkEcR6kVxWwTax9c', 47.3212415, 7.9870207, 'city', '1'),
('countries_switzerland_aargau_sarmenstorf', 'ChIJh7Z7LqEQkEcRFcAcXrRDv54', 47.310589, 8.251219, 'city', '1'),
('countries_switzerland_aargau_schafisheim', 'ChIJHx2BSpM9kEcR8yN5GaTvHzc', 47.3773199, 8.1427231, 'city', '1'),
('countries_switzerland_aargau_scherz', 'ChIJqTIkvGgVkEcR9hAfOoVIi3M', 47.4464569, 8.1846352, 'city', '1'),
('countries_switzerland_solothurn_kleinlutzel', 'ChIJi4OsKhLCkUcR6iZHghxqLyM', 47.4254097, 7.4185133, 'city', '1'),
('countries_switzerland_aargau_schlossrued', 'ChIJ1yEz8fsikEcRoEsZQIj_AAQ', 47.2907084, 8.0890873, 'city', '1'),
('countries_switzerland_aargau_schneisingen', 'ChIJoyci079tkEcRkBjSpVloRYw', 47.5199173, 8.361593, 'city', '1'),
('countries_switzerland_solothurn_hueniken', 'ChIJjaGPJQ4qjkcRsfN6rJ2tsTg', 47.1848142, 7.6374872, 'city', '1'),
('countries_switzerland_aargau_schupfart', 'ChIJ7-pfg0hIkEcREHsZQIj_AAQ', 47.5134984, 7.9653934, 'city', '1'),
('countries_switzerland_aargau_schwaderloch', 'ChIJtU8TtaNDkEcRUP_tuiHJ4rI', 47.5859912, 8.1444247, 'city', '1'),
('countries_switzerland_aargau_seengen', 'ChIJvaulJGwXkEcRIHkZQIj_AAQ', 47.3267872, 8.2054516, 'city', '1'),
('countries_switzerland_aargau_seon', 'ChIJRVovw9EXkEcRMHkZQIj_AAQ', 47.3481098, 8.1588699, 'city', '1'),
('countries_switzerland_solothurn_hofstetten', 'ChIJubAlZZqWmkcRyOuzj7ZLC2Y', 47.4731074, 8.8538246, 'city', '0'),
('countries_switzerland_aargau_siglistorf', 'ChIJYQ2s3ghukEcRwE8ZQIj_AAQ', 47.5451227, 8.379834, 'city', '1'),
('countries_switzerland_aargau_sins', 'ChIJ3QkUODUCkEcRSJTDB_8SjuY', 47.1914437, 8.3956737, 'city', '1'),
('countries_switzerland_aargau_sisseln', 'ChIJa1HcO7hIkEcR-ikpMp4sglQ', 47.5532793, 7.9895639, 'city', '1'),
('countries_switzerland_aargau_spreitenbach', 'ChIJ67O2338NkEcRIRULEE5yRT0', 47.4221702, 8.3638854, 'city', '1'),
('countries_switzerland_aargau_staffelbach', 'ChIJZ6HoZ3gjkEcRmQnLJ8tuWrw', 47.2837189, 8.0423865, 'city', '1'),
('countries_switzerland_aargau_staufen', 'ChIJlRzomvU9kEcR3ZZGi9JxEIE', 47.3836889, 8.1681976, 'city', '1'),
('countries_switzerland_aargau_stein', 'ChIJD4OaKRhJkEcRIHsZQIj_AAQ', 47.544055, 7.9551774, 'city', '1'),
('countries_switzerland_aargau_stetten', 'ChIJ9fva6swTkEcR1jWTsvb_zU4', 47.3999805, 8.3073777, 'city', '1'),
('countries_switzerland_aargau_stilli', 'ChIJrTpqEXlqkEcRQj-3Ap2Ba44', 47.5175453, 8.2309034, 'city', '1'),
('countries_switzerland_aargau_strengelbach', 'ChIJv4EaEnAvkEcRuLWUJ8ZA1NU', 47.2790777, 7.9290323, 'city', '1'),
('countries_switzerland_aargau_suhr', 'ChIJW3mmHEQ8kEcRk-zQHdc_6Zo', 47.370902, 8.0795037, 'city', '1'),
('countries_switzerland_aargau_sulz', 'ChIJEdck-btGkEcR6HPkeOLc9jE', 47.5343627, 8.0957858, 'city', '1'),
('countries_switzerland_solothurn_hessigkofen', 'ChIJn2cK0WEmjkcRA-3m7ArVA90', 47.1413, 7.46606, 'city', '0'),
('countries_switzerland_aargau_tegerfelden', 'ChIJuTtHZkhpkEcRrC4skMisQ_Q', 47.5611603, 8.2866172, 'city', '1'),
('countries_switzerland_aargau_teufenthal', 'ChIJ-1kLbEg9kEcRFQSS-ra8-ws', 47.329831, 8.1147283, 'city', '1'),
('countries_switzerland_aargau_thalheim', 'ChIJh58hS94-kEcR95o0zxyoDSY', 47.438287, 8.1035688, 'city', '1'),
('countries_switzerland_aargau_turgi', 'ChIJFfDiCBNrkEcRHYvh7XB8yQw', 47.4887974, 8.2547897, 'city', '1'),
('countries_switzerland_aargau_ueken', 'ChIJ9aKLm2JHkEcR2MJy_1Ow2Us', 47.4825893, 8.0525308, 'city', '1'),
('countries_switzerland_aargau_uerkheim', 'ChIJH8mvXukkkEcRmYywkgdhVxQ', 47.3050217, 8.0249072, 'city', '1'),
('countries_switzerland_aargau_umiken', 'ChIJEfEUcKhqkEcR-9LiD_JRO7Y', 47.4830247, 8.1910126, 'city', '1'),
('countries_switzerland_aargau_unterendingen', 'ChIJ-fqsdFZpkEcRx_IHET-4mTw', 47.5468696, 8.2893399, 'city', '1'),
('countries_switzerland_aargau_unterentfelden', 'ChIJc3TOPYM7kEcRnefV72uqqJs', 47.3673267, 8.0444396, 'city', '1'),
('countries_switzerland_aargau_unterkulm', 'ChIJG8K6zLYikEcR8lRn-TnrTfA', 47.3131283, 8.1137093, 'city', '1'),
('countries_switzerland_aargau_unterlunkhofen', 'ChIJ7Yx5kAoPkEcRQy_BJW2dhmk', 47.321382, 8.3811843, 'city', '1'),
('countries_switzerland_aargau_untersiggenthal', 'ChIJyZq3l6drkEcRZRMA6YIXy3c', 47.4978612, 8.2638309, 'city', '1'),
('countries_switzerland_aargau_veltheim', 'ChIJ29ne7Us-kEcRXeOKiiGAU80', 47.4365773, 8.1476781, 'city', '1'),
('countries_switzerland_aargau_villigen', 'ChIJUVqhlMNBkEcRVcB2dv6V12o', 47.5262164, 8.2147881, 'city', '1'),
('countries_switzerland_aargau_villmergen', 'ChIJ_xyLNtIWkEcRXxA5EGClCjk', 47.3475212, 8.2446497, 'city', '1'),
('countries_switzerland_aargau_villnachern', 'ChIJCdrlnfY_kEcRV8E1gb-rpFU', 47.469412, 8.1631666, 'city', '1'),
('countries_switzerland_solothurn_heinrichswil', 'ChIJjbCZvDQqjkcRETRfPn-28Cw', 47.15695, 7.63596, 'city', '1'),
('countries_switzerland_solothurn_hauenstein', 'ChIJv4GHnX8xkEcR340pyMtvZc8', 47.37794, 7.87245, 'city', '0'),
('countries_switzerland_aargau_vordemwald', 'ChIJo5-gWyQvkEcRIbMrSWNp3ks', 47.2760602, 7.9017632, 'city', '1'),
('countries_switzerland_solothurn_hagendorf', 'ChIJUe8TenEykEcRquodyCLxkMI', 47.3331438, 7.843562, 'city', '1'),
('countries_switzerland_solothurn_haerkingen', 'ChIJEwi61bUtkEcR6ZbJbqOWibY', 47.3073359, 7.8189943, 'city', '1'),
('countries_switzerland_aargau_wallbach', 'ChIJW5zv6OVLkEcRDP6vhbne3XM', 47.5591058, 7.9042193, 'city', '1'),
('countries_switzerland_aargau_waltenschwil', 'ChIJV_1Da1sQkEcR47-QUWR7vUw', 47.3347266, 8.3006497, 'city', '1'),
('countries_switzerland_aargau_wegenstetten', 'ChIJ5Yl8RtdJkEcRcy7iaYPyhpA', 47.5000892, 7.9339832, 'city', '1'),
('countries_switzerland_aargau_wettingen', 'ChIJ8U4sqjFtkEcRbyc1iL_xGGM', 47.4659503, 8.3265988, 'city', '1'),
('countries_switzerland_aargau_widen', 'ChIJF9-pcAUOkEcRO8c88z7ARpg', 47.3680474, 8.3630648, 'city', '1'),
('countries_switzerland_aargau_wil', 'ChIJLycq0s1DkEcROUuuIa2BLHk', 47.5606389, 8.1523217, 'city', '1'),
('countries_switzerland_aargau_windisch', 'ChIJFcqmDchqkEcRKORULcxQmv8', 47.4789604, 8.2159655, 'city', '1'),
('countries_switzerland_aargau_wislikofen', 'ChIJX_wzA2lukEcRM3Sw_UXvaB8', 47.5580898, 8.3617539, 'city', '1'),
('countries_switzerland_aargau_wittnau', 'ChIJZQq-0eU3kEcRJJ2p0XfDloY', 47.4800318, 7.9760149, 'city', '1'),
('countries_switzerland_solothurn_guensberg', 'ChIJrby3IlzXkUcRcTfIXE9Bhx4', 47.2565066, 7.5762305, 'city', '1'),
('countries_switzerland_aargau_wohlen', 'ChIJdTB1Zg8RkEcRNv1gB2SpnDs', 47.3493653, 8.2768762, 'city', '1'),
('countries_switzerland_aargau_wohlenschwil', 'ChIJsYsEaHAUkEcRivghMaJZnnw', 47.4125559, 8.2569192, 'city', '1'),
('countries_switzerland_solothurn_gossliwil', 'ChIJa1bQe6UmjkcRYBEZQIj_AAQ', 47.1374, 7.43445, 'city', '0'),
('countries_switzerland_solothurn_feldbrunnen', 'ChIJ6XbEZJHXkUcRniV6lJUG-LU', 47.2206165, 7.5555367, 'city', '1'),
('countries_switzerland_aargau_zeihen', 'ChIJvT9jHlE_kEcRtDMjqmjhht8', 47.4758911, 8.0836687, 'city', '1'),
('countries_switzerland_aargau_zeiningen', 'ChIJS2uSOqVLkEcRUHsZQIj_AAQ', 47.5432658, 7.8721205, 'city', '1'),
('countries_switzerland_aargau_zetzwil', 'ChIJF19ynUMYkEcRJcKlWWupXXg', 47.2862147, 8.14964, 'city', '1'),
('countries_switzerland_aargau_zofingen', 'ChIJ6Zfv6AolkEcR9yVrCJ54qdI', 47.2888449, 7.9447619, 'city', '1'),
('countries_switzerland_aargau_zufikon', 'ChIJfXfsziQOkEcRP1eJD8POMTQ', 47.3455892, 8.3577623, 'city', '1'),
('countries_switzerland_aargau_zuzgen', 'ChIJbQD2HSlKkEcRPQU74E4VVdY', 47.5259235, 7.9003293, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_buhler', 'ChIJMRAh5FQfm0cRs_H0jXSimUg', 47.3730767, 9.4245108, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_gais', 'ChIJGUVtHoEYm0cRC7fU483hiB4', 47.3621531, 9.4524457, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_grub', 'ChIJt4r5OngZm0cRkXt4L3icrEE', 47.447864, 9.509459, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_heiden', 'ChIJ29mLpQIam0cRi_oUP8XGRFw', 47.4440576, 9.5319772, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_herisau', 'ChIJ7cE3cy7emkcRGbnaUHXOaTU', 47.3857009, 9.2798472, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_hundwil', 'ChIJe69Ck6Igm0cRosNkVmLRrwo', 47.3658642, 9.3207148, 'city', '1'),
('countries_switzerland_solothurn_daniken', 'ChIJS0KBBZg6kEcRJsFcuVzO1D8', 47.3548887, 7.9821872, 'city', '1'),
('countries_switzerland_solothurn_busserach', 'ChIJq9DDPwHFkUcRsu19q6yWgrw', 47.391439, 7.5399922, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_rehetobel', 'ChIJDTFhHnMZm0cRTP3qCXHwHdw', 47.4260992, 9.4829689, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_reute', 'ChIJ07smvnoXm0cRRG7YgDedED0', 47.419751, 9.5760652, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_schonengrund', 'ChIJSSzRH7vemkcRzw_e-QsJaqY', 47.3260986, 9.226432, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_schwellbrunn', 'ChIJhw3L8I7emkcR5yifa2392wQ', 47.3542872, 9.2489271, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_speicher', 'ChIJlbYsC9Iem0cRs8_4ZswbFVI', 47.4117837, 9.4416911, 'city', '1'),
('countries_switzerland_solothurn_bruegglen', 'ChIJtUMl3RQmjkcRVhhjm_ihLLo', 47.1428457, 7.4963628, 'city', '0'),
('countries_switzerland_appenzell_ausserrhoden_stein', 'ChIJVVnhgxwgm0cRTbITZa-d718', 47.3744573, 9.3448602, 'city', '1'),
('countries_switzerland_solothurn_bleichenberg', 'ChIJ49wDDSUojkcR4ulH3Mawx04', 47.191667, 7.563889, 'city', '0'),
('countries_switzerland_appenzell_ausserrhoden_trogen', 'ChIJoarLJI0Ym0cRvzxOAEpx0h0', 47.4078753, 9.4647144, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_urnasch', 'ChIJCcRVZ8bYmkcRHUFLc4nHSBk', 47.3170588, 9.2826442, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_waldstatt', 'ChIJTZKGWqXfmkcR0E0ZQIj_AAQ', 47.357042, 9.2852256, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_walzenhausen', 'ChIJq30p4ykRm0cRqeya02rGXPM', 47.4513643, 9.6023288, 'city', '1'),
('countries_switzerland_solothurn_bibern_so', 'ChIJmbX6zZImjkcRzS37M7hYvkM', 47.14586, 7.45716, 'city', '0'),
('countries_switzerland_appenzell_ausserrhoden_wolfhalden', 'ChIJ556cUrIQm0cR0PcD8M0dPKI', 47.45371, 9.55054, 'city', '1'),
('countries_switzerland_solothurn_barschwil', 'ChIJi36jp0LDkUcRvYAoUFE8fW8', 47.3823812, 7.4722402, 'city', '1'),
('countries_switzerland_solothurn_baettwil', 'ChIJ31gxE87AkUcRCfkR8WjnPIw', 47.4901324, 7.5105407, 'city', '1'),
('countries_switzerland_appenzell_innerrhoden_gonten', 'ChIJZaAMJOogm0cRJd1v2_PuIq8', 47.3267921, 9.3446023, 'city', '1'),
('countries_switzerland_solothurn_ammansegg', 'ChIJQYFRA3gojkcRaV_ybow9O3k', 47.1746363, 7.5333456, 'city', '1'),
('countries_switzerland_schwyz_wilen_bei_wollerau', 'ChIJS76ucH-xmkcRg-tGeWTjZKY', 47.1973117, 8.733397, 'city', '0'),
('countries_switzerland_schwyz_stoos', 'ChIJeaejw3VPhUcRBclwgE9doeM', 46.9797573, 8.6669493, 'city', '0'),
('countries_switzerland_appenzell_innerrhoden_oberegg_district', 'ChIJn7RFS2YXm0cRJQSu70eO8K8', 47.4228209, 9.5498523, 'city', '1'),
('countries_switzerland_appenzell_innerrhoden_schwende_district', 'ChIJTdMeFBckm0cRGsyB7DfXEMQ', 47.3244509, 9.4158834, 'city', '1'),
('countries_switzerland_appenzell_innerrhoden_weissbad', 'ChIJxyyL-5Mjm0cR742FG9WqJa0', 47.310552, 9.435555, 'city', '1'),
('countries_switzerland_basel_city_basel', 'ChIJTzBpJ8dJkEcRkIpt83DrHDY', 47.5595986, 7.5885761, 'city', '1'),
('countries_switzerland_basel_city_bettingen', 'ChIJF13_rzy3kUcRCk9JQ7WA1iA', 47.5709866, 7.6651414, 'city', '1'),
('countries_switzerland_basel_city_riehen', 'ChIJQ66LeEe3kUcROQ8lGAmPXx8', 47.5848274, 7.6499111, 'city', '1'),
('countries_switzerland_basel_landschaft_aesch', 'ChIJiYWlGTTGkUcRlYoGtZwny8A', 47.4672734, 7.5979344, 'city', '1'),
('countries_switzerland_basel_landschaft_allschwil', 'ChIJj_CRCc64kUcR_AflXFW8AuM', 47.5528925, 7.5433615, 'city', '1'),
('countries_switzerland_basel_landschaft_anwil', 'ChIJTbNjBao3kEcRQpC4EvUfzjg', 47.4505604, 7.9409359, 'city', '1'),
('countries_switzerland_basel_landschaft_arboldswil', 'ChIJE7zxe27MkUcRvH8pjld2iRo', 47.41588, 7.71721, 'city', '1'),
('countries_switzerland_basel_landschaft_arisdorf', 'ChIJd5MOJXe1kUcRtuNFGdY74t4', 47.5129592, 7.7652075, 'city', '1'),
('countries_switzerland_basel_landschaft_arlesheim', 'ChIJqbjXRxfIkUcRCwA3hnvK4R4', 47.499576, 7.6192212, 'city', '1'),
('countries_switzerland_basel_landschaft_augst', 'ChIJEWWi6de1kUcRXexjeO3Gi9w', 47.53389, 7.72135, 'city', '1'),
('countries_switzerland_basel_landschaft_bennwil', 'ChIJETsZaDEzkEcRcBwZQIj_AAQ', 47.4037697, 7.7804805, 'city', '1'),
('countries_switzerland_basel_landschaft_biel_benken', 'ChIJ3UloyVLHkUcRsCUNGyNkHXQ', 47.506272, 7.5255321, 'city', '1'),
('countries_switzerland_basel_landschaft_binningen', 'ChIJA-6Eqey4kUcRPZuf4cw286A', 47.5378697, 7.5709878, 'city', '1'),
('countries_switzerland_basel_landschaft_birsfelden', 'ChIJjW70MX-3kUcRQBgZQIj_AAQ', 47.5516505, 7.6272499, 'city', '1'),
('countries_switzerland_basel_landschaft_blauen', 'ChIJp1_Pjr3GkUcRnjQTsO-3hGI', 47.4501556, 7.5187797, 'city', '1'),
('countries_switzerland_schwyz_seewen', 'ChIJA2sUGdbIkUcRWT6KFVYZ_No', 47.4365858, 7.6603489, 'city', '1'),
('countries_switzerland_basel_landschaft_bottmingen', 'ChIJyXK2UXy4kUcRPOY92DrIQzY', 47.5233885, 7.5723451, 'city', '1'),
('countries_switzerland_basel_landschaft_bretzwil', 'ChIJAQaaXPLOkUcRENgZtYgv30c', 47.3978882, 7.652801, 'city', '1'),
('countries_switzerland_basel_landschaft_brislach', 'ChIJDTN7lNLFkUcR7GIUUEJZPtY', 47.41885, 7.5427693, 'city', '1'),
('countries_switzerland_basel_landschaft_bubendorf', 'ChIJ3RvZf6bLkUcRX7zQHhIqEiY', 47.4489146, 7.7360721, 'city', '1'),
('countries_switzerland_basel_landschaft_buckten', 'ChIJEU46_YszkEcRsBoZQIj_AAQ', 47.4101428, 7.8446974, 'city', '1'),
('countries_switzerland_basel_landschaft_burg_im_leimental', 'ChIJxetOB5LBkUcRVnVSys4UdM8', 47.4576124, 7.438715, 'city', '1'),
('countries_switzerland_basel_landschaft_buus', 'ChIJJ4Bzp29KkEcRQiKpJp56UyI', 47.5054627, 7.8645192, 'city', '1'),
('countries_switzerland_basel_landschaft_diegten', 'ChIJod1TgmEzkEcRzgFlxP3TfUM', 47.413336, 7.8112119, 'city', '1'),
('countries_switzerland_basel_landschaft_diepflingen', 'ChIJGTsUAFg0kEcRmXoJrPn27_g', 47.446398, 7.8373698, 'city', '1'),
('countries_switzerland_basel_landschaft_dittingen', 'ChIJR-rut6rGkUcRYSMw2bMkNlI', 47.4408378, 7.4975373, 'city', '1'),
('countries_switzerland_basel_landschaft_duggingen', 'ChIJMePtoKLIkUcRK3SHqaI07uE', 47.4527468, 7.6050304, 'city', '1'),
('countries_switzerland_basel_landschaft_eptingen', 'ChIJQQw5JQEzkEcRRIHkLbKlStw', 47.3854855, 7.8203957, 'city', '1'),
('countries_switzerland_basel_landschaft_ettingen', 'ChIJN74TR_3GkUcRYBgZQIj_AAQ', 47.4819119, 7.5448507, 'city', '1'),
('countries_switzerland_basel_landschaft_frenkendorf', 'ChIJxcivSPzJkUcRFqiix6hkAiM', 47.5035123, 7.7131296, 'city', '1'),
('countries_switzerland_schwyz_schubelbach', 'ChIJx7LapVLKmkcRqwRiAbx-ZJ8', 47.173891, 8.9282867, 'city', '1'),
('countries_switzerland_basel_landschaft_gelterkinden', 'ChIJPbCteqg1kEcRxUqSvQn7kRE', 47.4656125, 7.8560314, 'city', '1'),
('countries_switzerland_basel_landschaft_giebenach', 'ChIJsVnvhpW1kUcRMn1gj32tdBU', 47.5231661, 7.7449933, 'city', '1'),
('countries_switzerland_basel_landschaft_grellingen', 'ChIJTTHyrAXGkUcRHdvLIoJxuNI', 47.4409994, 7.5905459, 'city', '1'),
('countries_switzerland_schwyz_schindellegi', 'ChIJo77S0UeymkcRvQaUhaoIaPA', 47.1748077, 8.7127887, 'city', '0'),
('countries_switzerland_basel_landschaft_hersberg', 'ChIJ6ToFAKPKkUcRo0q4Xxq3WIE', 47.4922007, 7.7833916, 'city', '1'),
('countries_switzerland_basel_landschaft_itingen', 'ChIJo5eKUs7KkUcRdgR0wD1DONE', 47.4671523, 7.7851197, 'city', '1'),
('countries_switzerland_schwyz_ibach', 'ChIJVz6kSzFOhUcRHeredUAei-o', 47.011067, 8.644372, 'city', '1'),
('countries_switzerland_basel_landschaft_lampenberg', 'ChIJ71AZ5GPLkUcROjhczPiqdVA', 47.42523, 7.75871, 'city', '1'),
('countries_switzerland_basel_landschaft_langenbruck', 'ChIJW8krPbgykEcRLloPS4i0E4g', 47.3483495, 7.7686817, 'city', '1'),
('countries_switzerland_schwyz_egg', 'ChIJ8z2jSz6lmkcRVFJqG5AFwMI', 47.2995246, 8.6903921, 'city', '0'),
('countries_switzerland_basel_landschaft_laufen', 'ChIJvckXywvEkUcRFeFIh9Cq6EI', 47.4204213, 7.5004874, 'city', '1'),
('countries_switzerland_basel_landschaft_lausen', 'ChIJbYM8juPKkUcRxG3A_vCdt1Y', 47.4729163, 7.7593955, 'city', '1'),
('countries_switzerland_basel_landschaft_lauwil', 'ChIJ-Qgce4DOkUcRDOOopFiK54A', 47.3901548, 7.675683, 'city', '1'),
('countries_switzerland_basel_landschaft_liedertswil', 'ChIJAZLcmVHMkUcR82__GkMeW5I', 47.391511, 7.7185492, 'city', '1'),
('countries_switzerland_basel_landschaft_liesberg', 'ChIJ6eZzJI3CkUcR7fJ0TZHuSow', 47.4037488, 7.4290857, 'city', '1'),
('countries_switzerland_schwyz_buttikon', 'ChIJ23wp81bJmkcRlv7j5Kb3YEc', 47.1743387, 8.9529904, 'city', '0'),
('countries_switzerland_basel_landschaft_liestal', 'ChIJeVL1HxLKkUcRpN6KXwcOstY', 47.4866143, 7.7334272, 'city', '1'),
('countries_switzerland_basel_landschaft_lupsingen', 'ChIJm9K_lWDJkUcR1ANKb99_lh8', 47.4467057, 7.6953567, 'city', '1'),
('countries_switzerland_basel_landschaft_maisprach', 'ChIJU7Mm7OVKkEcRW3LearsjD9w', 47.5238529, 7.8468307, 'city', '1'),
('countries_switzerland_schwyz_brunnen', 'ChIJCz6RzjtQhUcRxIUjrVvykI0', 46.9993073, 8.6093822, 'city', '0'),
('countries_switzerland_basel_landschaft_muttenz', 'ChIJszaqKcu3kUcRmmvSsuRNDt8', 47.5279292, 7.6476369, 'city', '1'),
('countries_switzerland_basel_landschaft_nenzlingen', 'ChIJ2wtycGXGkUcRXmShnLwhPbM', 47.447616, 7.5619487, 'city', '1'),
('countries_switzerland_basel_landschaft_nusshof', 'ChIJTZGRCFW1kUcR46qW54I9cOA', 47.4917533, 7.8043541, 'city', '1'),
('countries_switzerland_basel_landschaft_oberdorf', 'ChIJiwgrhuXMkUcRsGl7_6wLJeg', 47.3936614, 7.7492826, 'city', '1'),
('countries_switzerland_basel_landschaft_oberwil', 'ChIJrWxJ8p64kUcReGFF_5M4_fU', 47.5159745, 7.5582003, 'city', '1'),
('countries_switzerland_basel_landschaft_oltingen', 'ChIJJwRuC-A2kEcR8DnvtIk8afo', 47.4330669, 7.9353781, 'city', '1'),
('countries_switzerland_basel_landschaft_ormalingen', 'ChIJY7kMzME1kEcRXWTi3gyE1qQ', 47.4687391, 7.8761325, 'city', '1'),
('countries_switzerland_basel_landschaft_pfeffingen', 'ChIJNZO8EUDGkUcRxXZnoi9H3GU', 47.4586328, 7.5900291, 'city', '1'),
('countries_switzerland_basel_landschaft_pratteln', 'ChIJWdRcURe2kUcRMLEICsjA8lA', 47.5183198, 7.6919889, 'city', '1'),
('countries_switzerland_basel_landschaft_ramlinsburg', 'ChIJXfAQNBbLkUcR3svehkpLzFQ', 47.44893, 7.76449, 'city', '1'),
('countries_switzerland_basel_landschaft_reigoldswil', 'ChIJQV47FSXMkUcRj3c4aEY3Fis', 47.3977342, 7.69204, 'city', '1'),
('countries_switzerland_basel_landschaft_reinach', 'ChIJj9tStOzHkUcRapz-c-lB16E', 47.4906819, 7.5894365, 'city', '1'),
('countries_switzerland_basel_landschaft_roggenburg', 'ChIJx8lSim3pkUcRJrgRpqc7lng', 47.4341769, 7.3407316, 'city', '1'),
('countries_switzerland_schaffhausen_wilchingen_osterfingen', 'ChIJk0L0SKF7kEcRZdsy0WFS3Lk', 47.6628275, 8.4876811, 'city', '0'),
('countries_switzerland_basel_landschaft_rothenfluh', 'ChIJ90hvEUI2kEcRIstmy89qHvc', 47.4611393, 7.9132149, 'city', '1'),
('countries_switzerland_schaffhausen_thayngen_bibern', 'ChIJFwe1TY1_mkcR948etgSpcEo', 47.77294, 8.67837, 'city', '0'),
('countries_switzerland_schaffhausen_rudlingen', 'ChIJlyS1nKJ3kEcROHOipePqhoQ', 47.5788217, 8.5719689, 'city', '1'),
('countries_switzerland_basel_landschaft_seltisberg', 'ChIJccEGPsvLkUcRl6Jk99NbjlU', 47.4597027, 7.7174137, 'city', '1'),
('countries_switzerland_basel_landschaft_sissach', 'ChIJSzvCxSc1kEcRuiE9Qj7AOXI', 47.4643945, 7.810661, 'city', '1'),
('countries_switzerland_basel_landschaft_tecknau', 'ChIJOW_8YbM2kEcRXdiUjFi8tiY', 47.4485139, 7.8857915, 'city', '1'),
('countries_switzerland_basel_landschaft_tenniken', 'ChIJLyB0CZM0kEcRDlvKt3RdQjg', 47.43708, 7.81173, 'city', '1'),
('countries_switzerland_basel_landschaft_therwil', 'ChIJW0dMrwvHkUcRqWnP1oliwBk', 47.4990611, 7.5532808, 'city', '1'),
('countries_switzerland_schaffhausen_neuhausen', 'ChIJecC10NJ4kEcRvXNmVLyrWCE', 47.6837423, 8.6126098, 'city', '1'),
('countries_switzerland_basel_landschaft_titterten', 'ChIJLeRJEkPMkUcRB4zoo8CY5GE', 47.4018846, 7.7174678, 'city', '1'),
('countries_switzerland_basel_landschaft_wahlen', 'ChIJ6w0MCWHEkUcRksbBQ_egYMo', 47.4012701, 7.5156451, 'city', '1'),
('countries_switzerland_basel_landschaft_waldenburg', 'ChIJeYue9hrNkUcRyKn_Q4Jmnzw', 47.3815278, 7.7469396, 'city', '1'),
('countries_switzerland_basel_landschaft_wenslingen', 'ChIJ42eSQ402kEcREBwZQIj_AAQ', 47.44028, 7.90822, 'city', '1'),
('countries_switzerland_basel_landschaft_wintersingen', 'ChIJCziVc1g1kEcRK0spkSLMJeM', 47.49451, 7.82369, 'city', '1'),
('countries_switzerland_basel_landschaft_wittinsburg', 'ChIJtZmdNH00kEcR5q97sqbk7iM', 47.4246342, 7.8409937, 'city', '1'),
('countries_switzerland_basel_landschaft_zeglingen', 'ChIJEUl72NA2kEcR3lzE1p3ePE8', 47.4175307, 7.9042312, 'city', '1'),
('countries_switzerland_basel_landschaft_ziefen', 'ChIJT4r5Dt3LkUcRqSggoYkYh4M', 47.4314838, 7.7055069, 'city', '1'),
('countries_switzerland_basel_landschaft_zunzgen', 'ChIJP8NkLHM1kEcRNhC1-tOvrwY', 47.4517957, 7.8077705, 'city', '1'),
('countries_switzerland_basel_landschaft_zwingen', 'ChIJFSz93SDEkUcRoBkZQIj_AAQ', 47.4371566, 7.5308866, 'city', '1'),
('countries_switzerland_bern_aarberg', 'ChIJ93q2nusXjkcRd39xA5VP-oo', 47.0420553, 7.2751012, 'city', '1'),
('countries_switzerland_bern_aarwangen', 'ChIJQQD3phArkEcR1fNB3X-M6d0', 47.2377902, 7.7708422, 'city', '1'),
('countries_switzerland_bern_adelboden', 'ChIJKd2EgEQCj0cRC5Hie-j8pg0', 46.4930889, 7.5595123, 'city', '1'),
('countries_switzerland_bern_aefligen', 'ChIJ2Qm8fuMujkcRE4c1d_l7MgE', 47.0954889, 7.5576032, 'city', '1'),
('countries_switzerland_bern_aegerten', 'ChIJVZMBdOgYjkcRfnMsxB8hxbA', 47.1215095, 7.2886279, 'city', '1'),
('countries_switzerland_schaffhausen_loehningen', 'ChIJt_rwMp5-kEcRcB0ZQIj_AAQ', 47.7003, 8.55296, 'city', '1'),
('countries_switzerland_bern_aeschiried', 'ChIJg1M1jC2vj0cRyVFiLbRc350', 46.6456, 7.7246, 'city', '1'),
('countries_switzerland_schaffhausen_gachlingen', 'ChIJZ5byRl58kEcRMrLVqMyzMSg', 47.7027587, 8.4981479, 'city', '1'),
('countries_switzerland_schaffhausen_buettenhardt', 'ChIJARzknQaAkEcRp7Ekf6rtMxc', 47.7569931, 8.6532631, 'city', '1'),
('countries_switzerland_bern_affoltern_im_emmental', 'ChIJX5H5V_jSj0cRoB2n4ztPqic', 47.0654106, 7.734066, 'city', '1'),
('countries_switzerland_saint_gallen_zueberwangen', 'ChIJH7i0jUDpmkcRjxGr4sa1LZ8', 47.4658487, 9.0843586, 'city', '0'),
('countries_switzerland_bern_alchenstorf', 'ChIJRb-9Lo4rjkcRAmeHBgzEAjE', 47.1240604, 7.6439405, 'city', '1'),
('countries_switzerland_saint_gallen_zuckenriet', 'ChIJQRbGGVfvmkcRbBsSCPBJcqQ', 47.4845071, 9.1613138, 'city', '0'),
('countries_switzerland_saint_gallen_wolfertswil', 'ChIJ4_UKHL7dmkcReOLjkQKCTXQ', 47.3738511, 9.200308, 'city', '0'),
('countries_switzerland_bern_amsoldingen', 'ChIJcbFOOlZNjkcRPApZ-ZvaVfw', 46.7280309, 7.58392, 'city', '1'),
('countries_switzerland_bern_arch', 'ChIJQ0zIyiohjkcRb4jKyJ2Jpq8', 47.1674084, 7.4280921, 'city', '1'),
('countries_switzerland_bern_arni', 'ChIJ6x5NtD7Lj0cRfbHihxVt-cM', 46.9341939, 7.6512446, 'city', '1'),
('countries_switzerland_bern_attiswil', 'ChIJYTKIMerWkUcRHN7D9ZL6sjo', 47.2471427, 7.6131632, 'city', '1'),
('countries_switzerland_bern_auswil', 'ChIJIy0hGvHWj0cRVn3lt2UQVIg', 47.136092, 7.8320796, 'city', '1'),
('countries_switzerland_bern_axalp', 'ChIJGaPDChWXj0cRWuuM20bxkwE', 46.72001, 8.0383, 'city', '1'),
('countries_switzerland_bern_ballmoos', 'ChIJOwjh87A6jkcRMOYYQIj_AAQ', 47.0408652, 7.4731656, 'city', '1'),
('countries_switzerland_bern_bangerten', 'ChIJ9VTpFdYkjkcRlleujsROyyo', 47.0557338, 7.4480232, 'city', '1'),
('countries_switzerland_bern_bannwil', 'ChIJLSCTkywrkEcR6KZQlZGm_7A', 47.2402164, 7.7374783, 'city', '1'),
('countries_switzerland_saint_gallen_weite', 'ChIJFfKyEwkzm0cRVOujruL7-uc', 47.0910143, 9.4962989, 'city', '0'),
('countries_switzerland_saint_gallen_walenstadtberg', 'ChIJJ3SHADoqm0cR76WlRJQcrhs', 47.13631, 9.286, 'city', '0'),
('countries_switzerland_saint_gallen_vilters', 'ChIJZ78UYLnNhEcR85Fy2fk3YcI', 47.0299988, 9.4484028, 'city', '0'),
('countries_switzerland_bern_beatenberg', 'ChIJZ8R9S7S6j0cRW9g7Oi1yoNo', 46.7035407, 7.8095511, 'city', '1'),
('countries_switzerland_saint_gallen_valens', 'ChIJ3dkeFq7OhEcRDHBZiRqJCYA', 46.9688945, 9.4801771, 'city', '0'),
('countries_switzerland_bern_bellmund', 'ChIJ09lAA3MZjkcRSAhy4vv-_qc', 47.1088182, 7.2463631, 'city', '1'),
('countries_switzerland_bern_belp', 'ChIJJVzq6bY3jkcRBYDjlE9oiEo', 46.912222, 7.499167, 'city', '1'),
('countries_switzerland_bern_belprahon', 'ChIJWemgu9fdkUcRMFk9kP6QQow', 47.2841783, 7.4048428, 'city', '1'),
('countries_switzerland_bern_berken', 'ChIJAVDT0hjVkUcR9Z2sTUS1rew', 47.2255539, 7.709627, 'city', '1'),
('countries_switzerland_bern_bern', 'ChIJdxs61MA5jkcRmmVXBP5fVcs', 46.9479739, 7.4474468, 'city', '1'),
('countries_switzerland_saint_gallen_vaettis', 'ChIJJaWWy_vLhEcRa1eDUs690EA', 46.983332, 9.4999971, 'city', '1'),
('countries_switzerland_bern_bettenhausen', 'ChIJ2yILcLQqjkcRCdo21agSpFM', 47.1726372, 7.7153465, 'city', '1'),
('countries_switzerland_saint_gallen_unterwasser', 'ChIJAzveZlAom0cRuAiwjaKgzVs', 47.1971653, 9.3086091, 'city', '0'),
('countries_switzerland_bern_biel_bienne', 'ChIJz-y6XNAejkcRHnBB0EOX3FA', 47.1367785, 7.2467909, 'city', '1'),
('countries_switzerland_bern_biglen', 'ChIJleLHENw0jkcRWyU31sOSa90', 46.9285176, 7.6284495, 'city', '1'),
('countries_switzerland_bern_bleienbach', 'ChIJpYwh3GLVj0cRRtCXqB98JsM', 47.1852853, 7.7568546, 'city', '1'),
('countries_switzerland_saint_gallen_unterterzen', 'ChIJnyE3y4Iqm0cR63-HM9WTOco', 47.1132054, 9.2515678, 'city', '0'),
('countries_switzerland_bern_blumenstein', 'ChIJOeSw8PRNjkcRkdKG2PReB1g', 46.7410999, 7.5204564, 'city', '1'),
('countries_switzerland_saint_gallen_unterrindal', 'ChIJr_eDc9PpmkcRQCPosi5A4nU', 47.40922, 9.08942, 'city', '0'),
('countries_switzerland_bern_bolligen', 'ChIJX-2Q0M8wjkcRoYb7iLYFPxE', 46.9756207, 7.4971458, 'city', '1'),
('countries_switzerland_bern_bollodingen', 'ChIJsZAReLYqjkcR7dW7FkNrvm0', 47.1678323, 7.709967, 'city', '1'),
('countries_switzerland_bern_boltigen', 'ChIJ8UZH7nlXjkcR8WxIT5akROs', 46.6288878, 7.3902137, 'city', '1'),
('countries_switzerland_bern_bowil', 'ChIJSWKKNHDKj0cRMm9E6F86PIU', 46.8930355, 7.6949307, 'city', '1'),
('countries_switzerland_saint_gallen_ulisbach', 'ChIJc42f5y_bmkcRkz800Y6aQyo', 47.2914755, 9.1230212, 'city', '0'),
('countries_switzerland_bern_brenzikofen', 'ChIJ8Y-P2UxLjkcRmQtSBdzIW_g', 46.8175961, 7.6171385, 'city', '1'),
('countries_switzerland_bern_brienz', 'ChIJ4c8eGRuXj0cRiANL4WQFxXk', 46.7541541, 8.0316899, 'city', '1'),
('countries_switzerland_bern_brienzwiler', 'ChIJ8SyUqBSRj0cRStMGO3pMwis', 46.7516401, 8.1007474, 'city', '1'),
('countries_switzerland_bern_brugg', 'ChIJb2s6T9gYjkcRIPwYQIj_AAQ', 47.1237068, 7.2812588, 'city', '1'),
('countries_switzerland_saint_gallen_uetliburg', 'ChIJzVWL8qEJkEcRILng_v2ccPg', 47.3495, 8.49205, 'city', '0'),
('countries_switzerland_saint_gallen_tuebach', 'ChIJhWOIlXAcm0cRLat9jn_zi3k', 47.4867194, 9.4522869, 'city', '1'),
('countries_switzerland_saint_gallen_tscherlach', 'ChIJheqkLJErm0cRsB8ZQIj_AAQ', 47.11936, 9.33344, 'city', '0'),
('countries_switzerland_saint_gallen_trubbach', 'ChIJZyqIvSEzm0cRoIyz3q5WZas', 47.0744276, 9.4787014, 'city', '0'),
('countries_switzerland_bern_burgdorf', 'ChIJaQ9EyXUtjkcRkR2QHCxIh8U', 47.0559357, 7.6272243, 'city', '1'),
('countries_switzerland_bern_burgistein', 'ChIJHyukw71OjkcR-TI5791AvqM', 46.791124, 7.500544, 'city', '1'),
('countries_switzerland_bern_burglauenen', 'ChIJl4vV58WYj0cR8eJmPKT_Vzs', 46.6357, 7.97556, 'city', '1'),
('countries_switzerland_saint_gallen_st_margrethenberg', 'ChIJu7R4--DLhEcRY-A0bCA4FQ8', 46.97804, 9.51272, 'city', '0'),
('countries_switzerland_bern_busswil_bei_melchnau', 'ChIJiULTeeQpkEcRG4sXtbrIOik', 47.1858372, 7.8316284, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_switzerland_saint_gallen_sonnental', 'ChIJoxRFBgShmkcRlRCwlXW5fZw', 47.3958923, 8.6043715, 'city', '0'),
('countries_switzerland_bern_champoz', 'ChIJ7d-jCKjhkUcRtbUaO9RQbB0', 47.255475, 7.2985724, 'city', '1'),
('countries_switzerland_bern_corcelles', 'ChIJ-UCWOP7bkUcRQQUSEZ_tfrA', 47.2853874, 7.4551839, 'city', '1'),
('countries_switzerland_bern_cormoret', 'ChIJ95MC7N8DjkcRGzKqN4GzPuQ', 47.1750829, 7.0564843, 'city', '1'),
('countries_switzerland_saint_gallen_schwarzenbach', 'ChIJ94FylrfpmkcRMgHmPzGQ7Lk', 47.4423658, 9.0764333, 'city', '0'),
('countries_switzerland_bern_court', 'ChIJlQkxPnjgkUcRWjwYRT4imZw', 47.2395861, 7.3368922, 'city', '1'),
('countries_switzerland_bern_courtelary', 'ChIJ67F4qMgDjkcRJ1WPFCBhb3k', 47.1783274, 7.0729547, 'city', '1'),
('countries_switzerland_saint_gallen_schanis', 'ChIJi860LgfOmkcR2FcrioiNbUk', 47.1604116, 9.0459705, 'city', '1'),
('countries_switzerland_bern_darligen', 'ChIJ06-mTUmkj0cRk4iabZ2GXps', 46.6618804, 7.8082081, 'city', '1'),
('countries_switzerland_bern_darstetten', 'ChIJPcx8GvdTjkcRISJNhJtSr_Q', 46.6591694, 7.4932504, 'city', '1'),
('countries_switzerland_saint_gallen_sax', NULL, 0, 0, 'city', '0'),
('countries_switzerland_bern_diemerswil', 'ChIJe4Rqlw47jkcR0ovhQTf91H4', 47.01946, 7.4280154, 'city', '1'),
('countries_switzerland_bern_diemtigen', 'ChIJX7RbBGtVjkcRSh1EIQ8LsmI', 46.6588931, 7.5767583, 'city', '1'),
('countries_switzerland_saint_gallen_sankt_peterzell', 'ChIJS8wItRPcmkcRFWH42Ltn_5g', 47.3176632, 9.1746211, 'city', '1'),
('countries_switzerland_bern_diesse', 'ChIJeesf1tEEjkcR6Y2IZDBI0i4', 47.1133137, 7.1164945, 'city', '1'),
('countries_switzerland_saint_gallen_sankt_margrethen', 'ChIJh2nQHxYRm0cRMziHmuZYeCQ', 47.4496088, 9.6376089, 'city', '1'),
('countries_switzerland_bern_dotzigen', 'ChIJTS-tYSMijkcRpf9PoiJrpdU', 47.1205168, 7.3416822, 'city', '1'),
('countries_switzerland_bern_durrenroth', 'ChIJyRmduV7Rj0cR4F_0EaDrH2A', 47.0886138, 7.7916239, 'city', '1'),
('countries_switzerland_bern_eggiwil', 'ChIJ4yV2f_G3j0cRyKTNoaVAFaA', 46.8750854, 7.7957834, 'city', '1'),
('countries_switzerland_saint_gallen_sankt_gallenkappel', 'ChIJZ_UAt6LImkcRDBi1KQAouOY', 47.2447103, 8.9664312, 'city', '0'),
('countries_switzerland_saint_gallen_salez', 'ChIJp_J7LcI6m0cRkUmEQzjEnRU', 47.237082, 9.5010767, 'city', '1'),
('countries_switzerland_bern_epsach', 'ChIJN_GlVvkZjkcRsP68s-Ub6s8', 47.0694755, 7.2195126, 'city', '1'),
('countries_switzerland_bern_eriswil', 'ChIJYxIIeI7Qj0cRQAMZQIj_AAQ', 47.079899, 7.850674, 'city', '1'),
('countries_switzerland_bern_eriz', 'ChIJ-ZDG2gq6j0cRBsT9rb-abLs', 46.7882169, 7.7775067, 'city', '1'),
('countries_switzerland_bern_erlach', 'ChIJuwKBe8QPjkcRgi62GgNfK1Y', 47.0434885, 7.0968065, 'city', '1'),
('countries_switzerland_bern_erlenbach_im_simmental', 'ChIJ7Y4Kw2JTjkcRPULb7aNOEH8', 46.6605558, 7.552996, 'city', '1'),
('countries_switzerland_bern_ersigen', 'ChIJndfgND0sjkcRcfP1Og6rRDU', 47.0949236, 7.5961581, 'city', '1'),
('countries_switzerland_bern_eschert', 'ChIJX5_8hmXekUcRo20UmWGEp3A', 47.2755622, 7.3992276, 'city', '1'),
('countries_switzerland_bern_etzelkofen', 'ChIJ_9uvxwwljkcR89mW0iy3VYg', 47.0842441, 7.4787431, 'city', '1'),
('countries_switzerland_bern_evilard', 'ChIJb8pedwgcjkcRHLV9_l_HCEo', 47.149734, 7.2388908, 'city', '1'),
('countries_switzerland_bern_fahrni', 'ChIJm2CjG3uzj0cRwxch9_SnZxI', 46.7971023, 7.6695808, 'city', '1'),
('countries_switzerland_saint_gallen_ruthi', 'ChIJjbnIaJs8m0cRcp3XYE67hSU', 47.2936044, 9.5376332, 'city', '1'),
('countries_switzerland_bern_farnern', 'ChIJ89A9FrfWkUcRjNbwaH-a29A', 47.26645, 7.62193, 'city', '1'),
('countries_switzerland_bern_faulensee', 'ChIJ54FbtfOuj0cRYhCURiXofX4', 46.675302, 7.702422, 'city', '1'),
('countries_switzerland_saint_gallen_rossrueti', 'ChIJlXl81_zrmkcRMA-f_rDbshk', 47.4752813, 9.0606881, 'city', '0'),
('countries_switzerland_bern_feutersoey', 'ChIJ28N2fUjujkcRZunLYFxSU5Y', 46.4179151, 7.270661, 'city', '1'),
('countries_switzerland_bern_finsterhennen', 'ChIJQRsvYhgRjkcRkOUYQIj_AAQ', 47.0263567, 7.1785058, 'city', '1'),
('countries_switzerland_bern_forst', 'ChIJy1IOW-ZNjkcRZ7V8XuuanX0', 46.75, 7.516667, 'city', '1'),
('countries_switzerland_bern_fraubrunnen', 'ChIJffmaiQwvjkcRmBG6rPnTQGk', 47.0862376, 7.5268739, 'city', '1'),
('countries_switzerland_bern_frauenkappelen', 'ChIJO1RNEfE-jkcRiDbDcK4u2_A', 46.954311, 7.3383456, 'city', '1'),
('countries_switzerland_bern_freimettigen', 'ChIJG1hyZLRKjkcRwoa0DQKHoJ0', 46.8679525, 7.6273384, 'city', '1'),
('countries_switzerland_bern_frieswil', 'ChIJQf0HYBwWjkcRZbST1WaE5fY', 46.99489, 7.28546, 'city', '1'),
('countries_switzerland_bern_frutigen', 'ChIJZd--Tt6pj0cRQa1208g6K0c', 46.5897805, 7.646887, 'city', '1'),
('countries_switzerland_bern_gadmen', 'ChIJhQHPGpJihUcRRbaEiSHkTes', 46.7206794, 8.3176745, 'city', '1'),
('countries_switzerland_bern_gals', 'ChIJbTYxKuUOjkcRcIByPZW-9Ug', 47.0281883, 7.050374, 'city', '1'),
('countries_switzerland_saint_gallen_rapperswil', 'ChIJq8IYFsi3mkcR2YC6rTh-2_k', 47.2266239, 8.8184374, 'city', '1'),
('countries_switzerland_bern_gampelen', 'ChIJdQwL5YoOjkcRa2dQZUTHamk', 47.014664, 7.0578947, 'city', '1'),
('countries_switzerland_saint_gallen_plons', 'ChIJcRdE27bShEcR6z30u4nY4Jw', 47.0562, 9.39947, 'city', '0'),
('countries_switzerland_bern_gerzensee', 'ChIJzxaNMdNLjkcRaRgXf-GUeFQ', 46.8388568, 7.5444555, 'city', '1'),
('countries_switzerland_saint_gallen_oberstetten', 'ChIJGXqXRg_pmkcRDF3F_BY6Y8g', 47.4483744, 9.0911172, 'city', '1'),
('countries_switzerland_saint_gallen_oberschan', 'ChIJBxxmkVYym0cRfxSaO2s1bN8', 47.09929, 9.47517, 'city', '0'),
('countries_switzerland_bern_golaten', 'ChIJ6-JXJXwWjkcRvZmF-9HN-PM', 46.9860817, 7.2429887, 'city', '1'),
('countries_switzerland_bern_goldern', 'ChIJLx9LJeuOj0cRz6oWrqVUWTU', 46.7500962, 8.1763261, 'city', '1'),
('countries_switzerland_bern_goldiwil', 'ChIJ1a9UQRuyj0cRXBx8VrRr288', 46.733329, 7.68333, 'city', '1'),
('countries_switzerland_bern_goldswil', 'ChIJBRqSMWqZUxQRAL4CTPEaEZw', 46.6863481, 7.8632049, 'city', '1'),
('countries_switzerland_bern_gondiswil', 'ChIJ48ILKqLXj0cRAIJptEIl1vU', 47.1457854, 7.8721739, 'city', '1'),
('countries_switzerland_bern_graben', 'ChIJZacf3zHVkUcRVL5aqKWzIRw', 47.2233663, 7.7249653, 'city', '1'),
('countries_switzerland_bern_grafenried', 'ChIJtfM0PokvjkcRaGfE0pwOm6A', 47.0787027, 7.5107286, 'city', '1'),
('countries_switzerland_bern_grandval', 'ChIJxeq8PpzekUcRkPoYQIj_AAQ', 47.283506, 7.4252746, 'city', '1'),
('countries_switzerland_bern_grindelwald', 'ChIJF5LHGKuej0cRZS-XQg9cqr8', 46.624164, 8.0413962, 'city', '1'),
('countries_switzerland_bern_grossaffoltern', 'ChIJcRSTztkijkcRQsH-rh40rTk', 47.06623, 7.3608, 'city', '1'),
('countries_switzerland_saint_gallen_oberrindal', 'ChIJt06L8RjomkcRVvbf2LUzLuQ', 47.4077917, 9.118196, 'city', '0'),
('countries_switzerland_saint_gallen_niederuzwil', 'ChIJk6uI7YXomkcRMxyrwiGWaJ8', 47.4445793, 9.1412359, 'city', '0'),
('countries_switzerland_saint_gallen_niederburen', 'ChIJvcvZaX3mmkcReZUOZgb--Fg', 47.4659823, 9.2032496, 'city', '1'),
('countries_switzerland_saint_gallen_necker', 'ChIJqX6S_XjZmkcR1nm2CyvD5pU', 47.277918, 9.2059816, 'city', '0'),
('countries_switzerland_bern_gsteigwiler', 'ChIJD7HD2ZKjj0cRFo1jhEeK4JQ', 46.6551888, 7.8732786, 'city', '1'),
('countries_switzerland_bern_guggisberg', 'ChIJq2CjhuVajkcRkXqOpmDKzxU', 46.7673098, 7.3289988, 'city', '1'),
('countries_switzerland_saint_gallen_murg', 'ChIJd_mQq2-TmkcRAI2bgvspaiU', 47.5061724, 8.941069, 'city', '0'),
('countries_switzerland_saint_gallen_muhlruti', 'ChIJ5_nS8gDBmkcRQkg1rUMYzBs', 47.3707538, 8.9851668, 'city', '0'),
('countries_switzerland_bern_gunten', 'ChIJmRyUJhquj0cR5NP6Uk1Q3Zc', 46.71331, 7.7022, 'city', '1'),
('countries_switzerland_bern_gurzelen', 'ChIJYbh6bcpNjkcR8bi5SHBbLlc', 46.7798387, 7.5336675, 'city', '1'),
('countries_switzerland_bern_gutenburg', 'ChIJ5-ZL4ffVj0cRedyYrP0TyTg', 47.183333, 7.8, 'city', '1'),
('countries_switzerland_bern_guttannen', 'ChIJUf3uYmiGj0cRACmaNTamh2E', 46.6552082, 8.2892297, 'city', '1'),
('countries_switzerland_bern_gwatt', 'ChIJz_mNX2Gtj0cRdhXu1IKdkeM', 46.723, 7.623, 'city', '1'),
('countries_switzerland_saint_gallen_morschwil', 'ChIJmWd9YcEem0cRfbGPWZsaDcs', 47.4683334, 9.4238877, 'city', '1'),
('countries_switzerland_bern_habkern', 'ChIJCZlo_4i8j0cRk3sLmdLkjAw', 46.7271574, 7.8649048, 'city', '1'),
('countries_switzerland_saint_gallen_mols', 'ChIJ6ybs5Fcqm0cR5qQvJu9sf6M', 47.11255, 9.27914, 'city', '0'),
('countries_switzerland_saint_gallen_marbach_sg', 'ChIJD5V1crAXm0cROfecaB_0qKg', 47.392076, 9.568968, 'city', '0'),
('countries_switzerland_bern_hagneck', 'ChIJIe8Hl5AQjkcRUPwYQIj_AAQ', 47.05672, 7.1857, 'city', '1'),
('countries_switzerland_bern_hasliberg', 'ChIJLx9LJeuOj0cRz6oWrqVUWTU', 46.7500962, 8.1763261, 'city', '1'),
('countries_switzerland_bern_heiligenschwendi', 'ChIJzYXjazGyj0cRghU4Cn5IV4k', 46.7501941, 7.6863827, 'city', '1'),
('countries_switzerland_bern_heimberg', 'ChIJibEE6rZMjkcRBXJBkwUHz_E', 46.7842257, 7.6054974, 'city', '1'),
('countries_switzerland_bern_heimenhausen', 'ChIJE2pWYBPVkUcRIAQZQIj_AAQ', 47.2099552, 7.7001195, 'city', '1'),
('countries_switzerland_saint_gallen_lutisburg', 'ChIJ5Wz0LZfCmkcRFEzm4iZppEs', 47.394966, 9.0813971, 'city', '1'),
('countries_switzerland_saint_gallen_luetisburg_station', 'ChIJrSJ5UF3CmkcR8Z15l5Telb0', 47.38433, 9.07255, 'city', '0'),
('countries_switzerland_bern_heimiswil', 'ChIJRcaPTjctjkcRLLHunpTmB5k', 47.0647717, 7.6590987, 'city', '1'),
('countries_switzerland_bern_herbligen', 'ChIJ77yi4DZLjkcRAPgYQIj_AAQ', 46.8280355, 7.6060916, 'city', '1'),
('countries_switzerland_bern_hermrigen', 'ChIJW1IKFcAZjkcRHZWxLFo_iBU', 47.0813816, 7.2439053, 'city', '1'),
('countries_switzerland_saint_gallen_luechingen', 'ChIJuQCiFJUXm0cRvZx6UPWVOps', 47.3866111, 9.5527175, 'city', '0'),
('countries_switzerland_bern_herzogenbuchsee', 'ChIJo7Mv3FnVkUcRtCPqYeXrZRs', 47.189468, 7.7077698, 'city', '1'),
('countries_switzerland_saint_gallen_loemmenschwil', 'ChIJzT7NFGPimkcREHew9N-SAHc', 47.4967895, 9.3536283, 'city', '0'),
('countries_switzerland_saint_gallen_lienz', NULL, 0, 0, 'city', '0'),
('countries_switzerland_bern_hilterfingen', 'ChIJC5EaKGayj0cRTpjrp8skCWU', 46.7439605, 7.6472306, 'city', '1'),
('countries_switzerland_bern_hindelbank', 'ChIJLytboysujkcRl1OT-hFGico', 47.0454556, 7.5401137, 'city', '1'),
('countries_switzerland_saint_gallen_krummenau', 'ChIJ0-DSSHzXmkcR1xQ6tQ5JLfY', 47.2262651, 9.1988648, 'city', '1'),
('countries_switzerland_saint_gallen_kriessern', 'ChIJTxh1uhwWm0cRygklIJxJXdU', 47.364755, 9.6082499, 'city', '0'),
('countries_switzerland_bern_homberg', 'ChIJl8lihsGzj0cReC4YCxDNiig', 46.7731573, 7.6794276, 'city', '1'),
('countries_switzerland_saint_gallen_honegg', 'ChIJY5yKdj34j0cRJnm3NpMQU7c', 46.9962335, 8.4044536, 'city', '1'),
('countries_switzerland_saint_gallen_hinterforst', 'ChIJO9PhclA9m0cR14mBRxI9Lv0', 47.35852, 9.5319, 'city', '0'),
('countries_switzerland_bern_huttwil', 'ChIJg2lSiiPXj0cRRRIaFfB4MzU', 47.1133544, 7.8514819, 'city', '1'),
('countries_switzerland_bern_iffwil', 'ChIJvwUWsEEljkcR0OYYQIj_AAQ', 47.0641662, 7.4783324, 'city', '1'),
('countries_switzerland_bern_inkwil', 'ChIJ9bOqQITVkUcRRGXUKp1DOnI', 47.2019138, 7.6692352, 'city', '1'),
('countries_switzerland_saint_gallen_henau', 'ChIJ-brxpIromkcRB7G-dN87yro', 47.4453738, 9.142239, 'city', '0'),
('countries_switzerland_bern_innertkirchen', 'ChIJy-gEsqaIj0cRVe-jixYr9GE', 46.7051766, 8.227401, 'city', '1'),
('countries_switzerland_bern_ins', 'ChIJIWci0wUOjkcREB6QIwtB32g', 47.0060765, 7.1056172, 'city', '1'),
('countries_switzerland_bern_interlaken', 'ChIJBRqSMWqZUxQRAL4CTPEaEZw', 46.6863481, 7.8632049, 'city', '1'),
('countries_switzerland_bern_ipsach', 'ChIJvaYSZWMZjkcRQoSI20W4i9Q', 47.1143109, 7.232491, 'city', '1'),
('countries_switzerland_bern_iseltwald', 'ChIJW8ckF1S9j0cRavmlpJ_8_to', 46.7115858, 7.9642999, 'city', '1'),
('countries_switzerland_bern_ittigen', 'ChIJcYrgLpowjkcR14NRKjzxRXA', 46.9761433, 7.4818936, 'city', '1'),
('countries_switzerland_bern_jaberg', 'ChIJ1WR5rIRLjkcROAG_Yc7WSQU', 46.8178857, 7.5695571, 'city', '1'),
('countries_switzerland_bern_jegenstorf', 'ChIJ5yeEZFcljkcR3-3KudxIhM8', 47.0500303, 7.5069284, 'city', '1'),
('countries_switzerland_bern_jens', 'ChIJMz-EmlQYjkcRcPwYQIj_AAQ', 47.0978169, 7.2637382, 'city', '1'),
('countries_switzerland_bern_kallnach', 'ChIJLwSvFOIWjkcR9KQ-3CMvtXM', 47.0183474, 7.2354559, 'city', '1'),
('countries_switzerland_saint_gallen_haggenschwil', 'ChIJk2XqhWfimkcRMeVPzn_1nns', 47.4939507, 9.3433245, 'city', '1'),
('countries_switzerland_bern_kandergrund', 'ChIJn5dwKKgHj0cRYG6jX9nUZXs', 46.5566132, 7.6609058, 'city', '1'),
('countries_switzerland_bern_kandersteg', 'ChIJHwOyTmAPj0cR8lNjymZ9Rm4', 46.4947325, 7.6744357, 'city', '1'),
('countries_switzerland_bern_kappelen', 'ChIJE5DQGjsYjkcR9SF4z-H2TVM', 47.0612319, 7.2668353, 'city', '1'),
('countries_switzerland_bern_kaufdorf', 'ChIJfRKphxBJjkcRsP8YQIj_AAQ', 46.8380493, 7.4988722, 'city', '1'),
('countries_switzerland_bern_kehrsatz', 'ChIJMWW5juw3jkcR3L6tlpnSDmc', 46.9104003, 7.4711496, 'city', '1'),
('countries_switzerland_bern_kernenried', 'ChIJA_RDjrMvjkcR9IqSA4aN8Kc', 47.0733519, 7.5507107, 'city', '1'),
('countries_switzerland_bern_kiesen', 'ChIJxXXygm1LjkcRObZ9tq2y9JI', 46.8193506, 7.5823568, 'city', '1'),
('countries_switzerland_bern_kirchberg', 'ChIJRfvkoJ0ujkcRWuv_XMXuOVk', 47.0864542, 7.5838976, 'city', '1'),
('countries_switzerland_bern_kirchdorf', 'ChIJzyLxtpJLjkcRMIn0R1ctZ1k', 46.8206819, 7.5480086, 'city', '1'),
('countries_switzerland_bern_kirchenthurnen', 'ChIJRa0j4kZJjkcREUCDFUMpEn8', 46.8235991, 7.5018166, 'city', '1'),
('countries_switzerland_bern_kirchlindach', 'ChIJjSEBYLg7jkcRsoCxkOdJutU', 46.9997652, 7.4140521, 'city', '1'),
('countries_switzerland_bern_kleindietwil', 'ChIJmVklYCzUj0cRwRaWcRi_m3Y', 47.14628, 7.7899719, 'city', '1'),
('countries_switzerland_bern_konolfingen', 'ChIJ54OZYaRKjkcRg53FKGl2qQA', 46.8794597, 7.6208263, 'city', '1'),
('countries_switzerland_bern_koppigen', 'ChIJL_kPbl0pjkcROEXhQWZdI_g', 47.133724, 7.6017869, 'city', '1'),
('countries_switzerland_saint_gallen_haag_rheintal', 'ChIJASe64gowm0cRNGG3mRoV26c', 47.21147, 9.49135, 'city', '0'),
('countries_switzerland_bern_krattigen', 'ChIJNS2Jnkavj0cRrUs8OcqORow', 46.6611155, 7.7282129, 'city', '1'),
('countries_switzerland_bern_krauchthal', 'ChIJt9y8rYQxjkcRlq5vDDFEO9c', 47.0101968, 7.5669015, 'city', '1'),
('countries_switzerland_bern_kriechenwil', 'ChIJv0IJrzNrjkcR5qD5YVESgSw', 46.9117651, 7.2277918, 'city', '1'),
('countries_switzerland_saint_gallen_gretschins', 'ChIJ_7EqU6ozm0cRYoS2p3B0h2Y', 47.0976, 9.4855, 'city', '0'),
('countries_switzerland_bern_lamboing', 'ChIJLfVcPBUbjkcRgdfEI_mCYXg', 47.1173739, 7.1362656, 'city', '1'),
('countries_switzerland_bern_landiswil', 'ChIJV6dvOF_Lj0cRMPgYQIj_AAQ', 46.9582, 7.68004, 'city', '1'),
('countries_switzerland_bern_langenthal', 'ChIJCThQskgqkEcR09TUKuSWrHU', 47.2120786, 7.7905623, 'city', '1'),
('countries_switzerland_saint_gallen_gaehwil', 'ChIJ95mRe8_BmkcRFrnuI04i5-o', 47.39742, 9.00179, 'city', '0'),
('countries_switzerland_saint_gallen_fruemsen', 'ChIJc6xjSC4lm0cRYDX2gca2WpM', 47.24509, 9.47345, 'city', '0'),
('countries_switzerland_bern_lauenen', 'ChIJpWUgyfDvjkcRBl9hXBfAnFg', 46.4243976, 7.3223569, 'city', '1'),
('countries_switzerland_bern_laupen', 'ChIJIc2tKkgVjkcRO_bAa0sPHKs', 46.9035653, 7.2386901, 'city', '1'),
('countries_switzerland_bern_lauperswil', 'ChIJR_tjnBzMj0cRn72xM7eFm1U', 46.9667076, 7.7498972, 'city', '1'),
('countries_switzerland_bern_lauterbrunnen', 'ChIJx2UROwegj0cRMSyQVbstOQU', 46.5935058, 7.9090981, 'city', '1'),
('countries_switzerland_saint_gallen_fontnas', 'ChIJF-vUcQYzm0cRZh8PeunAeQY', 47.0904873, 9.4896553, 'city', '0'),
('countries_switzerland_bern_la_neuveville', 'ChIJDSthN1cFjkcRAKjpdkaOnIY', 47.0632023, 7.0912628, 'city', '1'),
('countries_switzerland_saint_gallen_flums_hochwiese', 'ChIJ2-srit4sm0cR7BSxaKkNZGg', 47.08218, 9.37356, 'city', '0'),
('countries_switzerland_bern_leimiswil', 'ChIJoRGC_KzVj0cRt70SOMmNkNc', 47.1494713, 7.7643456, 'city', '1'),
('countries_switzerland_bern_leissigen', 'ChIJfbthIPGlj0cRGylRcwpcokk', 46.6540346, 7.7723916, 'city', '1'),
('countries_switzerland_bern_lengnau', 'ChIJNy0-sFogjkcRylpChQkNx0U', 47.18076, 7.3692807, 'city', '1'),
('countries_switzerland_saint_gallen_flumserberg_bergheim', 'ChIJD9sudmwrm0cR5A9tAgQDtt8', 47.09466, 9.31317, 'city', '0'),
('countries_switzerland_bern_leuzigen', 'ChIJGULKjQMnjkcRkOAYQIj_AAQ', 47.175305, 7.4600662, 'city', '1'),
('countries_switzerland_saint_gallen_dreien', 'ChIJCUdFU4PBmkcRDe_UWQAafC8', 47.3736258, 9.0175734, 'city', '0'),
('countries_switzerland_saint_gallen_ennetbuehl', 'ChIJz8MJDd7ZmkcR1Cc1CYEVplo', 47.24011, 9.2108799, 'city', '0'),
('countries_switzerland_saint_gallen_dietschwil', 'ChIJi7uEg27qmkcR_llltXw0x6g', 47.42185, 9.01581, 'city', '0'),
('countries_switzerland_bern_liebefeld', 'ChIJO7f8EVU4jkcRzZwuj9AEAHk', 46.933331, 7.416668, 'city', '1'),
('countries_switzerland_bern_ligerz', 'ChIJFXmS5rAajkcRGwLV58Zfk18', 47.0851233, 7.1368597, 'city', '1'),
('countries_switzerland_bern_limpach', 'ChIJaQwZfe0ljkcRrw4s1NiSEEg', 47.1086972, 7.4941475, 'city', '1'),
('countries_switzerland_bern_linden', 'ChIJx2nQ4K61j0cR3TFqNIPRO9w', 46.8478265, 7.6778153, 'city', '1'),
('countries_switzerland_saint_gallen_buetschwil', 'ChIJOdy0Ia3DmkcRMMiAIlX6iNk', 47.3625195, 9.0735291, 'city', '1'),
('countries_switzerland_bern_lotzwil', 'ChIJ9cx4wAoqkEcRP8XbO2rGKn4', 47.1896436, 7.7916592, 'city', '1'),
('countries_switzerland_saint_gallen_bichwil', 'ChIJs4QI5XLomkcREZ376PYDO2A', 47.42102, 9.13529, 'city', '0'),
('countries_switzerland_bern_lutschental', 'ChIJ2cI23qGYj0cREPUYQIj_AAQ', 46.6382294, 7.9491468, 'city', '1'),
('countries_switzerland_bern_lutzelfluh', 'ChIJf2plqg_Nj0cRKkBd2xOICqc', 47.0081826, 7.6865903, 'city', '1'),
('countries_switzerland_bern_lyss', 'ChIJR1F-jZgijkcRt7yRQghlW08', 47.0746504, 7.3077022, 'city', '1'),
('countries_switzerland_bern_lyssach', 'ChIJA1uim20ujkcRrRr4IjnUSRM', 47.0655239, 7.5819234, 'city', '1'),
('countries_switzerland_bern_madiswil', 'ChIJe54mLAvWj0cRcKz-3ZchIwo', 47.16543, 7.79856, 'city', '1'),
('countries_switzerland_bern_magglingen', 'ChIJ43dYY_YbjkcR-qwE73Xw9Vw', 47.14139, 7.216402, 'city', '1'),
('countries_switzerland_saint_gallen_berschis', 'ChIJQ5Hjd4csm0cR8l4bimq3QYk', 47.1059727, 9.3465229, 'city', '0'),
('countries_switzerland_saint_gallen_bernhardzell', 'ChIJU2-IIRjimkcRmieMuYguUy4', 47.4719119, 9.3365009, 'city', '0'),
('countries_switzerland_bern_matten_bei_interlaken', 'ChIJizUjcX6jj0cRiiqYsrs8Quo', 46.6806354, 7.8666365, 'city', '1'),
('countries_switzerland_bern_mattstetten', 'ChIJU23HjWgwjkcRQZ45oh2BcWw', 47.0299711, 7.5136601, 'city', '1'),
('countries_switzerland_bern_meikirch', 'ChIJ3e8bckI8jkcRSDXTg2Ec_bQ', 47.0095483, 7.3641994, 'city', '1'),
('countries_switzerland_bern_meinisberg', 'ChIJhcHs6sYhjkcR_Krvmng1Nnw', 47.1596325, 7.3479735, 'city', '1'),
('countries_switzerland_bern_meiringen', 'ChIJqWE1G7-Pj0cRSwKc0wZ0F3w', 46.7251614, 8.1909081, 'city', '1'),
('countries_switzerland_bern_melchnau', 'ChIJHQAzqivWj0cRUNkYQIj_AAQ', 47.1822492, 7.8515746, 'city', '1'),
('countries_switzerland_bern_merligen', 'ChIJOy68eLevj0cRsJFvZ1v3WE0', 46.697026, 7.738692, 'city', '1'),
('countries_switzerland_bern_mirchel', 'ChIJUd9PCLDKj0cRUPgYQIj_AAQ', 46.8955, 7.6473238, 'city', '1'),
('countries_switzerland_bern_mittelhaeusern', 'ChIJU3tMCTlHjkcR7J5u2uBK5xs', 46.8764694, 7.3681121, 'city', '1'),
('countries_switzerland_saint_gallen_bazenheid', 'ChIJgaaJfd3pmkcRAzOAe4zwDag', 47.4126975, 9.0685947, 'city', '0'),
('countries_switzerland_saint_gallen_azmoos', 'ChIJdwi3Fh4zm0cRdIeOJi0eBCY', 47.0803655, 9.4773649, 'city', '0'),
('countries_switzerland_saint_gallen_arnegg', 'ChIJiccQFjLhmkcR_wPkE1zZm7g', 47.4433126, 9.255587, 'city', '0'),
('countries_switzerland_bern_moosseedorf', 'ChIJLwIXhXgwjkcRY9RD55xjVLI', 47.0145991, 7.4845784, 'city', '1'),
('countries_switzerland_bern_moutier', 'ChIJETRlVaHgkUcROU_gIvv-wn4', 47.2782749, 7.3716656, 'city', '1'),
('countries_switzerland_saint_gallen_alt_sankt_johann', 'ChIJ982LrjMom0cRnMg7fzCkc_I', 47.1972495, 9.3082874, 'city', '1'),
('countries_switzerland_saint_gallen_altstatten', 'ChIJIT1A0OgXm0cRJzLWhT88a3c', 47.3774633, 9.5469133, 'city', '1'),
('countries_switzerland_saint_gallen_algetshausen', 'ChIJFzgfvf7omkcRsd6V_6_RJoU', 47.4454551, 9.1085266, 'city', '0'),
('countries_switzerland_saint_gallen_abtwil', 'ChIJdbIvTkQCkEcRUHkZQIj_AAQ', 47.1745465, 8.3547163, 'city', '1'),
('countries_switzerland_obwalden_stalden', 'ChIJ2VFG4DBAj0cRiMeOTvoZ5YM', 46.2331036, 7.8706705, 'city', '0'),
('countries_switzerland_bern_muhlethurnen', 'ChIJ8TLQrU5JjkcRlDOny4EWLcQ', 46.8133458, 7.5075323, 'city', '1'),
('countries_switzerland_obwalden_kaegiswil', 'ChIJuxEPsoPxj0cRovSzxKMUyvM', 46.9225562, 8.263263, 'city', '0'),
('countries_switzerland_obwalden_flueli', 'ChIJjZ1_pQjzj0cRzb_6Zuury7A', 46.8720321, 8.2689076, 'city', '0'),
('countries_switzerland_bern_muri_bei_bern', 'ChIJeRpXcAU3jkcRLOe9-54qMJQ', 46.9350521, 7.4984728, 'city', '1'),
('countries_switzerland_bern_neuenegg', 'ChIJCcjErYk_jkcRdqzRisSwXj4', 46.8947644, 7.3037454, 'city', '1'),
('countries_switzerland_obwalden_burglen', 'ChIJ34Pnlt5GhUcRz1EsjSbheRo', 46.8761523, 8.6644631, 'city', '1'),
('countries_switzerland_obwalden_alpnach_dorf', 'ChIJrQp2I6fxj0cRiVPw6FBJ5fw', 46.9380412, 8.2701754, 'city', '0'),
('countries_switzerland_bern_niederbipp', 'ChIJ3ajV_YDTkUcRAp4I9derDpY', 47.2716158, 7.6907179, 'city', '1'),
('countries_switzerland_obwalden_alpnachstad', 'ChIJrQp2I6fxj0cRiVPw6FBJ5fw', 46.9380412, 8.2701754, 'city', '0'),
('countries_switzerland_bern_niedermuhlern', 'ChIJU_rk5F1IjkcRMWNh5R3HsQM', 46.8614201, 7.465354, 'city', '1'),
('countries_switzerland_nidwalden_wirzweli', 'ChIJYXcqInr2j0cRwfXOGJ05xIg', 46.9136359, 8.3675104, 'city', '0'),
('countries_switzerland_bern_niederscherli', 'ChIJ_bGe5GtHjkcRWdA1vOkamvc', 46.883334, 7.383338, 'city', '1'),
('countries_switzerland_bern_niederstocken', 'ChIJw4ZH_spSjkcR504zpZVDxiw', 46.7106272, 7.5729645, 'city', '1'),
('countries_switzerland_nidwalden_wil', 'ChIJe88HocLrmkcRGxgF6PS_ziM', 47.4635617, 9.0479097, 'city', '0'),
('countries_switzerland_bern_nods', 'ChIJrXQC2qoFjkcRHrgX4P38sjE', 47.1130756, 7.0813145, 'city', '1'),
('countries_switzerland_bern_noflen', 'ChIJXdXin_ZLjkcRetxV6HDa8ms', 46.8075487, 7.5421557, 'city', '1'),
('countries_switzerland_bern_oberbalm', 'ChIJqeO7xalHjkcRIzuvGrVrFWA', 46.8737526, 7.4029961, 'city', '1'),
('countries_switzerland_bern_oberbipp', 'ChIJITFOSmHUkUcR9tJKeJQWluk', 47.2620667, 7.6598349, 'city', '1'),
('countries_switzerland_bern_oberburg', 'ChIJTR_M7YAtjkcRgVC4Ei7c2m8', 47.0392994, 7.625715, 'city', '1'),
('countries_switzerland_bern_oberdiessbach', 'ChIJQUkfZylLjkcRdZ8QO78z7xU', 46.8396631, 7.6187351, 'city', '1'),
('countries_switzerland_nidwalden_riedhostet', 'ChIJgQ_Sdxn2j0cRKHJ8h088nzM', 46.9215697, 8.3984861, 'city', '0'),
('countries_switzerland_bern_oberhofen', 'ChIJ05EDKQqyj0cRY9T4eGElm2A', 46.7315725, 7.6692035, 'city', '1'),
('countries_switzerland_nidwalden_obbuergen', 'ChIJ-_UnpN75j0cRZ7_uybejSJs', 46.977594, 8.3374207, 'city', '0'),
('countries_switzerland_nidwalden_kehrsiten', 'ChIJ-_UnpN75j0cRZ7_uybejSJs', 46.977594, 8.3374207, 'city', '0'),
('countries_switzerland_nidwalden_inner_buerg', 'ChIJh4xmH-w9jkcRE-HZANT6IoU', 46.9961738, 7.306362, 'city', '0'),
('countries_switzerland_bern_oberscherli', 'ChIJJwsAEpFHjkcR8BjurxoyOX8', 46.88327, 7.4175, 'city', '1'),
('countries_switzerland_bern_obersteckholz', 'ChIJBap3gZIpkEcRC50GDTRte0w', 47.199536, 7.8183107, 'city', '1'),
('countries_switzerland_bern_oberstocken', 'ChIJBTpcbo5SjkcRI_nvMpbM7iw', 46.7175196, 7.5538454, 'city', '1'),
('countries_switzerland_bern_oberthal', 'ChIJZyFUbOHKj0cR0G-FlSqOt1g', 46.9168794, 7.6711111, 'city', '1'),
('countries_switzerland_bern_ochlenberg', 'ChIJXdI-MSHVj0cRHjDqVGbUN5Q', 47.1499919, 7.7361769, 'city', '1'),
('countries_switzerland_bern_oeschenbach', 'ChIJr4ZVP4DUj0cRZXGIzTl6AYw', 47.1145361, 7.7528802, 'city', '1'),
('countries_switzerland_nidwalden_fuerigen', 'ChIJs-BifkX3j0cR4sxq6eaG5uI', 46.981538, 8.3496381, 'city', '0'),
('countries_switzerland_bern_oppligen', 'ChIJ6V4A1kJLjkcRPoSfYbZU5FU', 46.8213089, 7.5991781, 'city', '1'),
('countries_switzerland_bern_orpund', 'ChIJWY8YPkofjkcR0PwYQIj_AAQ', 47.1390318, 7.3068847, 'city', '1'),
('countries_switzerland_bern_ortschwaben', 'ChIJ_YTu-us7jkcRbDGot6QUB-k', 46.9903878, 7.4008972, 'city', '1'),
('countries_switzerland_bern_orvin', 'ChIJsTKt_IAcjkcRc_El5aewpds', 47.1605487, 7.2134713, 'city', '1'),
('countries_switzerland_nidwalden_buren_nid_dem_bach', 'ChIJGR492ir2j0cRmQLwsG6UH44', 46.9584499, 8.3865692, 'city', '0'),
('countries_switzerland_bern_ostermundigen', 'ChIJ3cfsFzk3jkcR8N8YQIj_AAQ', 46.9577083, 7.4873069, 'city', '1'),
('countries_switzerland_bern_perrefitte', 'ChIJS-x6fqLgkUcRAOFeX3TV2fk', 47.2747542, 7.3419142, 'city', '1'),
('countries_switzerland_bern_pieterlen', 'ChIJtTZeBIAfjkcRv61NEkDP4fc', 47.1750981, 7.338602, 'city', '1'),
('countries_switzerland_bern_plagne', 'ChIJI5P8pbIfjkcRYJNgcwBYqUw', 47.1884206, 7.2873336, 'city', '1'),
('countries_switzerland_bern_pohlern', 'ChIJu-s7ixRSjkcRwrFMbKTde6U', 46.7233788, 7.5406963, 'city', '1'),
('countries_switzerland_neuchatel_thielle', 'ChIJI4vOLCHPjUcRshIrNjv-UcA', 46.754488, 6.5985146, 'city', '0'),
('countries_switzerland_bern_port', 'ChIJi83_9RwZjkcRfRU3okteqTg', 47.1165264, 7.2551381, 'city', '1'),
('countries_switzerland_neuchatel_saint_sulpice', 'ChIJtWLDCocwjEcRBNSwEKEmmJw', 46.510114, 6.5581951, 'city', '0'),
('countries_switzerland_bern_radelfingen', 'ChIJBR00khQWjkcRpwtpk76yyaM', 47.0216132, 7.2724685, 'city', '1'),
('countries_switzerland_neuchatel_noiraigue', 'ChIJEQn-GeLnjUcR-r8XtbZBrtI', 46.9552211, 6.7222016, 'city', '0'),
('countries_switzerland_neuchatel_neuchatel', 'ChIJm81S1RkKjkcRBGS2VWjDXCM', 46.9899874, 6.9292732, 'city', '0'),
('countries_switzerland_bern_rapperswil', 'ChIJ7UfBda4kjkcRkNYYQIj_AAQ', 47.0637909, 7.4105763, 'city', '1'),
('countries_switzerland_bern_reconvilier', 'ChIJBcQSnG7ikUcR2JiEGFNX44M', 47.2347446, 7.2259167, 'city', '1'),
('countries_switzerland_neuchatel_motiers', 'ChIJE-RJEI_BjUcREHMZQIj_AAQ', 46.9111044, 6.6113106, 'city', '0'),
('countries_switzerland_bern_reisiswil', 'ChIJl_vE3zDWj0cRf7lchk-K4jc', 47.1642665, 7.8447021, 'city', '1'),
('countries_switzerland_bern_renan', 'ChIJ2Wcnt5v9jUcRsYQ7Fn22ziY', 47.1266021, 6.9284973, 'city', '1'),
('countries_switzerland_bern_reutigen', 'ChIJERdFYiGtj0cR3IeWSmWbT3Y', 46.6942792, 7.6202063, 'city', '1'),
('countries_switzerland_bern_riedtwil', 'ChIJjzrO0y8rjkcRG3t2NmbJAIM', 47.14198, 7.69734, 'city', '1'),
('countries_switzerland_neuchatel_montezillon', 'ChIJkamwRjnhjUcR80v9XRaSqqc', 46.9869, 6.83719, 'city', '0'),
('countries_switzerland_bern_riggisberg', 'ChIJt9CQaQNPjkcR-7MEOxprr_g', 46.8101394, 7.4783583, 'city', '1'),
('countries_switzerland_bern_ringgenberg', 'ChIJ4SHLyEqjj0cRKAl-0LwFeLg', 46.7009118, 7.8939117, 'city', '1'),
('countries_switzerland_neuchatel_lignieres', 'ChIJ_etSao8FjkcRCyGsWuxVZg4', 47.0820348, 7.0661626, 'city', '1'),
('countries_switzerland_bern_roches', 'ChIJwfjTrvHdkUcRl9P-GhkPy2I', 47.3007952, 7.3840216, 'city', '1'),
('countries_switzerland_bern_roggwil', 'ChIJgWR70MQrkEcRkNkYQIj_AAQ', 47.2405859, 7.8235104, 'city', '1'),
('countries_switzerland_bern_rohrbach', 'ChIJJbgHDKPWj0cRvUhb86ywf6U', 47.1359115, 7.8125333, 'city', '1'),
('countries_switzerland_bern_rohrbachgraben', 'ChIJMd-UeqPWj0cRErI1GWfRQfM', 47.1212329, 7.8029185, 'city', '1'),
('countries_switzerland_bern_romont', 'ChIJfUZo0YkfjkcRCgUYKdY37Gk', 47.1889747, 7.3392264, 'city', '1'),
('countries_switzerland_neuchatel_le_prevoux', 'ChIJz7UneiLvjUcRmG7O_QCyBSA', 47.0375438, 6.701418, 'city', '0'),
('countries_switzerland_bern_rubigen', 'ChIJiyPXPAE2jkcRtgFga2ar-v4', 46.8999997, 7.5432453, 'city', '1'),
('countries_switzerland_neuchatel_le_paquier', 'ChIJDztmgc6JjkcRHNkFNG4JE6c', 46.5936084, 7.0554305, 'city', '0'),
('countries_switzerland_neuchatel_le_cret_du_locle', 'ChIJ-exnDD_ljUcRGmUzUQnj_nw', 47.0757301, 6.7743303, 'city', '0'),
('countries_switzerland_neuchatel_le_cret', 'ChIJPYNi_v99jkcR9iUoPJPjcPo', 46.616668, 6.916662, 'city', '1'),
('countries_switzerland_neuchatel_le_cerneux_pequignot', 'ChIJe6uGkjXpjUcR3wwGQnjNuls', 47.01691, 6.66616, 'city', '1'),
('countries_switzerland_neuchatel_le_brouillet', 'ChIJG689rKrqjUcRssOs3MIe2LE', 46.9503521, 6.5346052, 'city', '0'),
('countries_switzerland_neuchatel_les_vieux_pres', 'ChIJG54k3wEIjkcRTZMWkxsPprk', 47.07913, 6.936456, 'city', '0'),
('countries_switzerland_neuchatel_les_verrieres', 'ChIJcbaYYga_jUcRV6PEo1iIVDc', 46.9051166, 6.4844577, 'city', '1'),
('countries_switzerland_neuchatel_les_sagnettes', 'ChIJC6cJEdvBjUcRo33UBzyVs-s', 46.93862, 6.5932507, 'city', '0'),
('countries_switzerland_neuchatel_les_bayards', 'ChIJy0Pz7fK_jUcRTTM4WGMtCFs', 46.916466, 6.5166392, 'city', '0'),
('countries_switzerland_bern_rumisberg', 'ChIJoWkZ1LPWkUcRWn3BpCpzTrU', 47.2634772, 7.6421566, 'city', '1'),
('countries_switzerland_bern_ruppoldsried', 'ChIJJ2aNeHwjjkcRaLLrgsVAk6A', 47.0879903, 7.4253212, 'city', '1'),
('countries_switzerland_bern_saanen', 'ChIJOzRSFDvxjkcRkFj77Eo0XTc', 46.4897184, 7.2616785, 'city', '1'),
('countries_switzerland_neuchatel_la_cote_aux_fees', 'ChIJsfXjkLe4jUcR4WT33LaJK-Q', 46.8675625, 6.4904954, 'city', '1'),
('countries_switzerland_bern_safnern', 'ChIJRS-m50QfjkcRbKENXIagdlI', 47.1500237, 7.3234488, 'city', '1'),
('countries_switzerland_bern_saicourt', 'ChIJjTM0S8XikUcR8AozK2loLzA', 47.2427682, 7.2060415, 'city', '1'),
('countries_switzerland_neuchatel_la_brevine', 'ChIJWU3qdJTqjUcRCSS-LxJtcos', 46.98035, 6.60687, 'city', '1'),
('countries_switzerland_bern_sangernboden', 'ChIJF_bwbQNbjkcRV_T1Fbg3SYg', 46.7135, 7.353, 'city', '1'),
('countries_switzerland_neuchatel_fretereules', 'ChIJO4QQIqfnjUcRrjzt1zpjEqc', 46.9620626, 6.7659395, 'city', '1'),
('countries_switzerland_bern_schalunen', 'ChIJg0ptMkEvjkcRfiXDd_65_wI', 47.1091324, 7.5260989, 'city', '1'),
('countries_switzerland_bern_schangnau', 'ChIJX3FuLwC5j0cRv73mweF1S0M', 46.826807, 7.85924, 'city', '1'),
('countries_switzerland_bern_scharnachtal', 'ChIJD1ZZoi4Gj0cRkEtlM_UIvM0', 46.6254387, 7.6940529, 'city', '1'),
('countries_switzerland_bern_schattenhalb', 'ChIJEWGmARaQj0cRo3fchbSS6WE', 46.7185473, 8.1911357, 'city', '1'),
('countries_switzerland_bern_scheunen', 'ChIJm1i1RhgljkcRN2Ha6GVUQvk', 47.06836, 7.45716, 'city', '1'),
('countries_switzerland_bern_scheuren', 'ChIJIc4Vz6cYjkcRc7bTxY07Jkk', 47.13287, 7.3174056, 'city', '1'),
('countries_switzerland_neuchatel_fleurier', 'ChIJD13gCATBjUcREDxBZ_D0Rcs', 46.9023107, 6.5808426, 'city', '0'),
('countries_switzerland_bern_schlosswil', 'ChIJgdjDMBA1jkcRpe8TokA8PlQ', 46.9095388, 7.6086403, 'city', '1'),
('countries_switzerland_bern_schonbuhl', 'ChIJ3Ys7JmwwjkcRQdNH4zB7Dzk', 47.0205678, 7.499724, 'city', '1'),
('countries_switzerland_neuchatel_fenin', 'ChIJbaQB1HbijUcR9gIqqzgAJy8', 47.0317386, 6.9269888, 'city', '1'),
('countries_switzerland_neuchatel_couvet', 'ChIJwfYTTB_CjUcRyvpqjUKPa8w', 46.9262933, 6.6324944, 'city', '0'),
('countries_switzerland_bern_schwadernau', 'ChIJCQOfeccYjkcRgfSbQTS363o', 47.1280643, 7.303005, 'city', '1'),
('countries_switzerland_bern_schwanden', 'ChIJOW2lSlw7jkcRWaFzxEkz2nw', 47.036275, 7.401979, 'city', '1'),
('countries_switzerland_bern_schwanden_bei_brienz', 'ChIJdfVXKxuXj0cR2cZIObqX_o0', 46.7593911, 8.0558753, 'city', '1'),
('countries_switzerland_bern_schwanden_im_emmental', 'ChIJk26y2OXMj0cR_QTaxKdQul8', 46.98669, 7.69416, 'city', '1'),
('countries_switzerland_neuchatel_cormondreche', 'ChIJnSmu33ThjUcR4G8ZQIj_AAQ', 46.98504, 6.8723478, 'city', '1'),
('countries_switzerland_neuchatel_corcelles', 'ChIJ-UCWOP7bkUcRQQUSEZ_tfrA', 47.2853874, 7.4551839, 'city', '0'),
('countries_switzerland_bern_schwarzenegg', 'ChIJC_DIzFWxj0cRCvLBWADfhF8', 46.7952004, 7.7105025, 'city', '1'),
('countries_switzerland_bern_schwendibach', 'ChIJeRF8BK-zj0cRexXj4cyYt20', 46.7751149, 7.6632737, 'city', '1'),
('countries_switzerland_bern_seeberg', 'ChIJUdncRDsrjkcRzHXNiFtkXeo', 47.1560606, 7.6611548, 'city', '1'),
('countries_switzerland_bern_seedorf', 'ChIJXYP-ZQw9jkcR-zqFTLt9zVM', 47.0355495, 7.3124338, 'city', '1'),
('countries_switzerland_bern_seewil', 'ChIJxa10-lE7jkcRTuo89gBwyew', 47.0476445, 7.4086054, 'city', '1'),
('countries_switzerland_neuchatel_colombier', 'ChIJSw99vvjgjUcRK1QWzrkjIUw', 46.9668714, 6.8589727, 'city', '0'),
('countries_switzerland_bern_signau', 'ChIJCZpAw9TLj0cRxA9jIS7_elw', 46.9206256, 7.7256207, 'city', '1'),
('countries_switzerland_bern_sigriswil', 'ChIJi6bFiyWwj0cRKt1vUyCddtk', 46.7168545, 7.7132831, 'city', '1'),
('countries_switzerland_bern_siselen', 'ChIJR5f-4NwQjkcRfwFA-44FF2I', 47.03219, 7.18979, 'city', '1'),
('countries_switzerland_bern_sonvilier', 'ChIJO1hCk4v9jUcRETzemgmzdTw', 47.1390891, 6.9647878, 'city', '1'),
('countries_switzerland_neuchatel_chez_le_bart', 'ChIJ48tp1c3djUcRcL_XvpwgKEE', 46.90116, 6.78589, 'city', '0'),
('countries_switzerland_bern_sorvilier', 'ChIJcVkC0jbgkUcROzOzXt6INYQ', 47.239516, 7.3060745, 'city', '1'),
('countries_switzerland_neuchatel_chezard_saint_martin', 'ChIJM-Y8kVL9jUcRgw6eeeX6kdc', 47.0624261, 6.9175754, 'city', '1'),
('countries_switzerland_bern_spiez', 'ChIJZVNBI9atj0cRkU1L-Qk5jj0', 46.6884826, 7.6791524, 'city', '1'),
('countries_switzerland_neuchatel_chaumont_de_pury', 'ChIJ59djn7wJjkcRY3akhYOzI2I', 47.02731, 6.9572, 'city', '0'),
('countries_switzerland_bern_steffisburg', 'ChIJiaOtO2uzj0cRywKIFWFcLr4', 46.7788438, 7.6347832, 'city', '1'),
('countries_switzerland_bern_stettlen', 'ChIJJwzVIdI2jkcRSjwL1mupBcc', 46.9583702, 7.5251633, 'city', '1'),
('countries_switzerland_bern_studen', 'ChIJJx9jAZMYjkcRs7ecQNqnZw8', 47.1115805, 7.3026302, 'city', '1'),
('countries_switzerland_neuchatel_champ_du_moulin', 'ChIJ8yRevwvnjUcRg_bMsiSvFDY', 46.95931, 6.77185, 'city', '0'),
('countries_switzerland_bern_sumiswald', 'ChIJz_RuLMfRj0cRgLXma1Mh69Y', 47.0284465, 7.7446642, 'city', '1'),
('countries_switzerland_neuchatel_chambrelien', 'ChIJ_ZKT0TThjUcRqCGxzI5nOKc', 46.9782646, 6.8099317, 'city', '0'),
('countries_switzerland_neuchatel_buttes', 'ChIJF041otrAjUcRMTNK4bGwG8U', 46.8882668, 6.552494, 'city', '0'),
('countries_switzerland_neuchatel_bole', 'ChIJm_UX8N7gjUcRoG8ZQIj_AAQ', 46.96729, 6.84128, 'city', '1'),
('countries_switzerland_bern_tavannes', 'ChIJabdo5X0djkcRC32UATGZkIM', 47.2200764, 7.198526, 'city', '1'),
('countries_switzerland_bern_teuffenthal', 'ChIJjxU8V3Cxj0cR2L34Mona0a4', 46.7756857, 7.7193129, 'city', '1'),
('countries_switzerland_bern_thierachern', 'ChIJu3EmNA1NjkcRLqIDorWjV1Q', 46.7518275, 7.5726852, 'city', '1'),
('countries_switzerland_neuchatel_auvernier', 'ChIJQZXierbhjUcRXqq9TLChIbo', 46.9775749, 6.8769195, 'city', '0'),
('countries_switzerland_neuchatel_areuse', 'ChIJd7KTNjbnjUcRUGTCS7HCoso', 46.9449295, 6.6947317, 'city', '0'),
('countries_switzerland_bern_thun', 'ChIJA7esSI6yj0cRnFcjZWN76oA', 46.7579868, 7.6279881, 'city', '1'),
('countries_switzerland_bern_thunstetten', 'ChIJhVb7OJUqkEcRr8BaQs7v9uk', 47.216206, 7.7485408, 'city', '1'),
('countries_switzerland_bern_toffen', 'ChIJGZBT5qxJjkcRyjqN9kg_iGI', 46.8589438, 7.4909549, 'city', '1'),
('countries_switzerland_bern_tramelan', 'ChIJwRK1GH4CjkcR-dne3-DqoqE', 47.2235029, 7.102975, 'city', '1'),
('countries_switzerland_bern_treiten', 'ChIJ02AXiQwRjkcRjZ0LAhQJYtY', 47.0100997, 7.1594435, 'city', '1'),
('countries_switzerland_bern_trimstein', 'ChIJ9WIJ2pY1jkcRUPkYQIj_AAQ', 46.9041563, 7.5771922, 'city', '1'),
('countries_switzerland_bern_trub', 'ChIJB0B6XXfGj0cRQFl0XUSfRNM', 46.9395372, 7.8775131, 'city', '1'),
('countries_switzerland_bern_trubschachen', 'ChIJ30kryiPGj0cRt3YBAA6lY44', 46.9231499, 7.8444901, 'city', '1'),
('countries_switzerland_bern_tschingel', 'ChIJuUhtjhCQj0cRHIgqOkAKYms', 46.7036635, 8.1405365, 'city', '1'),
('countries_switzerland_bern_tschugg', 'ChIJdckZUkUOjkcRAPk1hUhdz-c', 47.0259262, 7.0782281, 'city', '1'),
('countries_switzerland_bern_tuescherz', 'ChIJaUvana8bjkcR1iATxx5Q1jU', 47.1182329, 7.1974419, 'city', '1'),
('countries_switzerland_bern_turbach', 'ChIJmYWBpIjwjkcR-8MPwJg-vU8', 46.478319, 7.331211, 'city', '1'),
('countries_switzerland_lucerne_winkel', 'ChIJfxCVqJ51kEcR4NAYQIj_AAQ', 47.4921213, 8.5554248, 'city', '0'),
('countries_switzerland_bern_uebeschi', 'ChIJZ3Mw1HhNjkcRorqvm8hT0vw', 46.7381333, 7.5549643, 'city', '1'),
('countries_switzerland_bern_uetendorf', 'ChIJl_9qgOZMjkcRTWQLoJ4gg3c', 46.774323, 7.5716075, 'city', '1'),
('countries_switzerland_bern_uettligen', 'ChIJc3ogE_c7jkcRaTmf_XCoDQk', 46.9872635, 7.3856989, 'city', '1'),
('countries_switzerland_bern_unterseen', 'ChIJ2VWL5eekj0cRIuoSx4_c4Oo', 46.6852116, 7.8481574, 'city', '1'),
('countries_switzerland_bern_untersteckholz', 'ChIJTbgParcpkEcRNNPayRaZnjM', 47.2074358, 7.8440321, 'city', '1'),
('countries_switzerland_bern_ursenbach', 'ChIJx0E4yULUj0cRgjUfUM64LGA', 47.1366438, 7.7724146, 'city', '1'),
('countries_switzerland_bern_uttigen', 'ChIJs-HjcYVMjkcRiGv9w3v7dh4', 46.794386, 7.5737132, 'city', '1'),
('countries_switzerland_bern_utzenstorf', 'ChIJR_i39SspjkcRDdaiHOyo2Uw', 47.1281667, 7.5588034, 'city', '1'),
('countries_switzerland_bern_utzigen', 'ChIJB1i26gE0jkcR8XfpLAnlIyU', 46.9608352, 7.5648335, 'city', '1'),
('countries_switzerland_bern_vauffelin', 'ChIJ4xViU1IejkcRUOUYQIj_AAQ', 47.1876743, 7.3000893, 'city', '1'),
('countries_switzerland_bern_vechigen', 'ChIJ3VDkugE0jkcRuuhHwHU3Y2c', 46.9470299, 7.5614952, 'city', '1'),
('countries_switzerland_bern_vielbringen', 'ChIJgXcSvnc2jkcRW-L6tZ1qlK0', 46.91541, 7.54933, 'city', '1'),
('countries_switzerland_bern_villeret', 'ChIJ4UtCEkoBjkcRWk2g8mc3RZw', 47.1582786, 7.0188916, 'city', '1'),
('countries_switzerland_bern_vinelz', 'ChIJgahXtyoOjkcRnV54qPoHPFw', 47.0356521, 7.1093429, 'city', '1'),
('countries_switzerland_lucerne_wilihof', 'ChIJSegP158hkEcRWD2FW9Uhb0U', 47.22611, 8.06456, 'city', '0'),
('countries_switzerland_bern_wachseldorn', 'ChIJob_IKZW2j0cRbQh35CcoJs8', 46.8177318, 7.7249508, 'city', '1'),
('countries_switzerland_lucerne_wiggen', 'ChIJYdRtHsahj0cRgQMvzvqWqbE', 46.6054335, 7.9215399, 'city', '0'),
('countries_switzerland_bern_walkringen', 'ChIJX-KbEp40jkcRwsP8AOi3I2k', 46.9479693, 7.620415, 'city', '1'),
('countries_switzerland_bern_walperswil', 'ChIJbbd-slAXjkcRkzfd7rX6MFw', 47.0599447, 7.2266273, 'city', '1'),
('countries_switzerland_bern_walterswil', 'ChIJTfMtkQ7Uj0cRNAoeoA5qqPk', 47.1133159, 7.7788101, 'city', '1'),
('countries_switzerland_bern_wangenried', 'ChIJKdX3nbDVkUcR1ihan40oLaA', 47.2186469, 7.6566918, 'city', '1'),
('countries_switzerland_bern_wangen_an_der_aare', 'ChIJp613mTPUkUcRP3oWPFn7Aqw', 47.23458, 7.6556331, 'city', '1'),
('countries_switzerland_bern_wanzwil', 'ChIJcbeepmXVkUcRxDMNOu28kr8', 47.2002301, 7.6930119, 'city', '1'),
('countries_switzerland_lucerne_urswil', 'ChIJZ7WF0Ff9j0cRiqothHvG7C4', 47.1496708, 8.2936386, 'city', '0'),
('countries_switzerland_bern_wattenwil', 'ChIJSUehPzhOjkcRSoXHILsgtnM', 46.7699018, 7.509795, 'city', '1'),
('countries_switzerland_lucerne_st_niklausen', 'ChIJY1MvFCj6j0cR6YUwDzrBAVY', 47.01912, 8.33921, 'city', '0'),
('countries_switzerland_bern_wengi', 'ChIJaWGUDWUjjkcRjRGNEWN68fA', 47.0834179, 7.3998035, 'city', '1'),
('countries_switzerland_bern_wichtrach', 'ChIJb3jw8FNKjkcRUhZqHrt2RRw', 46.84971, 7.57598, 'city', '1'),
('countries_switzerland_bern_wiedlisbach', 'ChIJUcMNACHUkUcROE3aQA64X94', 47.2512653, 7.6453444, 'city', '1'),
('countries_switzerland_bern_wilderswil', 'ChIJR6MWTPKjj0cR7kL8WuaYKAM', 46.6652174, 7.8689183, 'city', '1'),
('countries_switzerland_lucerne_st_erhard', 'ChIJ4R7CWhUgkEcRtNxNhB510Yw', 47.18345, 8.0770501, 'city', '0'),
('countries_switzerland_bern_wileroltigen', 'ChIJpYufRS4UjkcRSubo9ural5I', 46.9703542, 7.2402337, 'city', '1'),
('countries_switzerland_bern_willadingen', 'ChIJVQxUaGIpjkcR7rD5k1OJ0jU', 47.1454228, 7.614634, 'city', '1'),
('countries_switzerland_bern_wimmis', 'ChIJuzYZL1qsj0cRmkdWV57gxFU', 46.6761167, 7.6386272, 'city', '1'),
('countries_switzerland_bern_wohlen', 'ChIJUalF1ic8jkcRYNBXdJaqX2M', 46.9704283, 7.3658552, 'city', '1'),
('countries_switzerland_lucerne_soerenberg', 'ChIJOeqgow-Vj0cRtv2cVr_01SE', 46.8232565, 8.0318306, 'city', '0'),
('countries_switzerland_bern_wolfisberg', 'ChIJzyu9VnLUkUcRQwhl-boQh8U', 47.2727601, 7.6612678, 'city', '1'),
('countries_switzerland_bern_worb', 'ChIJJYDT3C40jkcR9ib0KCP7-UA', 46.9301102, 7.5635394, 'city', '1'),
('countries_switzerland_bern_worben', 'ChIJVfRH410YjkcRClwBbibgjSM', 47.098021, 7.2903553, 'city', '1'),
('countries_switzerland_bern_wynau', 'ChIJeSq6YowrkEcRRnNnhwBmHZY', 47.2571395, 7.8210167, 'city', '1'),
('countries_switzerland_bern_wynigen', 'ChIJh3UqYaUsjkcRSp8Qf9W5GvU', 47.1061701, 7.6678894, 'city', '1'),
('countries_switzerland_bern_wyssachen', 'ChIJkW50o-LQj0cRn6lsfhXrKe4', 47.0787116, 7.8284601, 'city', '1'),
('countries_switzerland_bern_zauggenried', 'ChIJwTkFjFIujkcR55pZDvaNjLk', 47.0731529, 7.5410209, 'city', '1'),
('countries_switzerland_lucerne_schwarzenbach', 'ChIJ94FylrfpmkcRMgHmPzGQ7Lk', 47.4423658, 9.0764333, 'city', '0'),
('countries_switzerland_lucerne_schuepfheim', 'ChIJMc4ngD3Cj0cReP7seGHEpq4', 46.9519892, 8.0163553, 'city', '1'),
('countries_switzerland_lucerne_schoetz', 'ChIJY17G0KjYj0cRi6Wps6kDdb8', 47.1707206, 7.9892294, 'city', '1'),
('countries_switzerland_bern_zollikofen', 'ChIJy7wd_Gk6jkcRGCkSmNJAxRM', 46.9982563, 7.4513399, 'city', '1'),
('countries_switzerland_lucerne_schachen', 'ChIJgfVDnnvmj0cRt04ULF7LnqM', 47.0360071, 8.1448783, 'city', '0'),
('countries_switzerland_bern_zweisimmen', 'ChIJEY5BytP5jkcREBttdfUcTU8', 46.5540893, 7.3720628, 'city', '1'),
('countries_switzerland_bern_zwieselberg', 'ChIJNbvvqxKtj0cRhOzhBuC8Amc', 46.7084405, 7.6172365, 'city', '1'),
('countries_switzerland_lucerne_sankt_urban', NULL, 0, 0, 'city', '0'),
('countries_switzerland_fribourg_albeuve', 'ChIJ473nArmOjkcRB5nvpubxtC4', 46.517776, 7.056384, 'city', '1'),
('countries_switzerland_fribourg_alterswil', 'ChIJM3m-E2BCjkcRNDBH8GogmQU', 46.7948597, 7.2603813, 'city', '1'),
('countries_switzerland_fribourg_arconciel', 'ChIJdXy4tOVljkcROhAZoGxT_RM', 46.7462, 7.12375, 'city', '1'),
('countries_switzerland_fribourg_attalens', 'ChIJWwqQRrqDjkcRQ56FdxA3vLY', 46.5103309, 6.8485685, 'city', '1'),
('countries_switzerland_fribourg_auboranges', 'ChIJbRO4ZogqjEcRsSXFsozlL2w', 46.5822239, 6.8052223, 'city', '1'),
('countries_switzerland_fribourg_aumont', 'ChIJa0bQ4WvYjUcRA01mHU6IxLs', 46.8, 6.850004, 'city', '1'),
('countries_switzerland_fribourg_autafond', 'ChIJdelWdDlujkcRTzyj90fOjyY', 46.81359, 7.07797, 'city', '1'),
('countries_switzerland_fribourg_autavaux', 'ChIJTW0kwFvfjUcRyZbfzptgUCc', 46.865283, 6.877226, 'city', '1'),
('countries_switzerland_fribourg_autigny', 'ChIJ_4syPsN6jkcR_cHHgLMqugk', 46.7366852, 7.0210704, 'city', '1'),
('countries_switzerland_lucerne_rohrmatt', 'ChIJzeUuKaI1j0cRcG8ZQIj_AAQ', 46.0207133, 7.749117, 'city', '0'),
('countries_switzerland_lucerne_roemerswil', 'ChIJK81mbQ4dkEcRCWJdO7LglRY', 47.1697587, 8.2446583, 'city', '1'),
('countries_switzerland_lucerne_rigi_kaltbad', 'ChIJCaT8OBNWhUcR0pM2ZoEZcPY', 47.04431, 8.46694, 'city', '0'),
('countries_switzerland_fribourg_belfaux', 'ChIJtzWBOntujkcRq8oT8RUbX64', 46.8221516, 7.1043531, 'city', '1'),
('countries_switzerland_fribourg_berlens', 'ChIJfTIczPV7jkcRgU8bzv-iDsQ', 46.693889, 6.953611, 'city', '1'),
('countries_switzerland_fribourg_besencens', 'ChIJe8O49P6AjkcRXzvbt4y2NP0', 46.583333, 6.866661, 'city', '1'),
('countries_switzerland_lucerne_rickenbach_lu', 'ChIJ1ZII6hgfkEcRu3772n40ptI', 47.2191, 8.15361, 'city', '0'),
('countries_switzerland_fribourg_blessens', 'ChIJC7cTfwaAjkcRcmQObGnO3Ok', 46.61667, 6.833331, 'city', '1'),
('countries_switzerland_lucerne_reussbuehl', 'ChIJVz54z7bkj0cRZMWJoDLWb78', 47.0507712, 8.2648094, 'city', '0'),
('countries_switzerland_lucerne_rengg', 'ChIJz9hL037oj0cRwYp86_-pYX8', 47.0038, 8.0908, 'city', '0'),
('countries_switzerland_fribourg_bossonnens', 'ChIJOzCjTzOCjkcRRUVP2EuenoQ', 46.5258557, 6.8523447, 'city', '1'),
('countries_switzerland_fribourg_botterens', 'ChIJwUgA4exhjkcR99-GLANDCbM', 46.6168996, 7.1122067, 'city', '1'),
('countries_switzerland_fribourg_bouloz', 'ChIJ09RDPZ2AjkcRgtQggr4lbww', 46.616673, 6.883332, 'city', '1'),
('countries_switzerland_lucerne_obernau', 'ChIJUxmJXNT6j0cRoo9L0XD-glo', 47.03084, 8.2515, 'city', '0'),
('countries_switzerland_lucerne_reidermoos', 'ChIJZ0VmVyYkkEcRDpw93ZMJqNY', 47.2520609, 7.9904332, 'city', '0'),
('countries_switzerland_fribourg_broc', 'ChIJfa6rk_1hjkcR4ZNDbRjyfQg', 46.6042074, 7.0974945, 'city', '1'),
('countries_switzerland_lucerne_niederwil', 'ChIJscX6pnsRkEcRMzBy2KAApk0', 47.3773998, 8.2952607, 'city', '0'),
('countries_switzerland_lucerne_mueswangen', 'ChIJRxbISGobkEcRqnTKpyqzzsM', 47.2382972, 8.288827, 'city', '1'),
('countries_switzerland_fribourg_bulle', 'ChIJ9-H49IdijkcRGR0_knHVzA0', 46.6154512, 7.0577268, 'city', '1'),
('countries_switzerland_lucerne_littau', 'ChIJVz54z7bkj0cRZMWJoDLWb78', 47.0507712, 8.2648094, 'city', '0'),
('countries_switzerland_lucerne_langnau', 'ChIJcTPUKDHPj0cREzOY7y0h7R8', 46.9378622, 7.7906824, 'city', '0'),
('countries_switzerland_lucerne_kaltbach', 'ChIJAROUtHogkEcR39BImMdk-Eo', 47.1757268, 8.0617268, 'city', '0'),
('countries_switzerland_lucerne_hofstatt', 'ChIJ47wjazvaj0cRoVq8BbPFde0', 47.0852779, 7.914591, 'city', '0'),
('countries_switzerland_lucerne_herlisberg', 'ChIJ432yrE4ckEcRTqLbDWMCBjQ', 47.1979286, 8.2304571, 'city', '0'),
('countries_switzerland_lucerne_hellbuehl', 'ChIJYZyNnHDkj0cRaWq2P8GNx9w', 47.07058, 8.19928, 'city', '0'),
('countries_switzerland_lucerne_haemikon', 'ChIJAUUSe2UbkEcRyV1rGz7NP28', 47.237607, 8.2757751, 'city', '1'),
('countries_switzerland_fribourg_chavannes_les_forts', 'ChIJpTq0v11-jkcRbcruPwa891c', 46.650001, 6.899998, 'city', '1'),
('countries_switzerland_fribourg_chavannes_sous_orsonnens', 'ChIJLcAn2lN6jkcR8O0XRkjN0E4', 46.733331, 6.983331, 'city', '1'),
('countries_switzerland_fribourg_cheiry', 'ChIJ14wbSLjXjUcRzxL17f-RdcI', 46.7512379, 6.8368752, 'city', '1'),
('countries_switzerland_lucerne_fluehli', 'ChIJuwNk5VOVj0cROdTEnLKxJvU', 46.8830365, 8.0162606, 'city', '1'),
('countries_switzerland_lucerne_emmenbruecke', 'ChIJF9Y9qb78j0cRUSXaxMLXcDU', 47.0772338, 8.275637, 'city', '0'),
('countries_switzerland_fribourg_cheyres', 'ChIJV-mhUoLZjUcRHyMSLeEwJZ0', 46.8167597, 6.7892688, 'city', '1'),
('countries_switzerland_fribourg_cordast', 'ChIJh8bKg2JsjkcRoaseDPZganY', 46.873892, 7.151396, 'city', '1'),
('countries_switzerland_fribourg_corjolens', 'ChIJxcrW-N9vjkcRVB_6YeCCLS4', 46.783332, 7.049997, 'city', '1'),
('countries_switzerland_lucerne_eigenthal', 'ChIJkb5SGW_lj0cRHz6_-PyBW7E', 47.01001, 8.21015, 'city', '0'),
('countries_switzerland_lucerne_ebnet', 'ChIJ49JXNjnxj0cRodZS5L4qexM', 46.936527, 8.298714, 'city', '1'),
('countries_switzerland_fribourg_corminboeuf', 'ChIJ7S4DkVRujkcRUPIYQIj_AAQ', 46.8111587, 7.1058977, 'city', '1'),
('countries_switzerland_lucerne_daiwil', 'ChIJFehHoJvej0cR29rGezutoGk', 47.096665, 8.0125632, 'city', '1'),
('countries_switzerland_fribourg_corserey', 'ChIJl1Z1s5xwjkcRW6kZyiT7SS4', 46.77434, 6.99234, 'city', '1'),
('countries_switzerland_fribourg_cottens', 'ChIJo7Os8a16jkcRgPIYQIj_AAQ', 46.7531574, 7.032901, 'city', '1'),
('countries_switzerland_fribourg_courgevaux', 'ChIJNVFyA0VtjkcRGetgY-SElqY', 46.9079196, 7.111429, 'city', '1'),
('countries_switzerland_lucerne_bueron', 'ChIJmR0DQsUhkEcRkAgZQIj_AAQ', 47.2138484, 8.094528, 'city', '1'),
('countries_switzerland_fribourg_cournillens', 'ChIJKfH_csVtjkcRlpGUWmf8mwM', 46.850004, 7.100008, 'city', '1'),
('countries_switzerland_fribourg_courtaman', 'ChIJUW7yYVdsjkcRgiNGguQweOs', 46.872, 7.13, 'city', '1'),
('countries_switzerland_fribourg_courtepin', 'ChIJCS2_A0VsjkcRrMtkV2Z1vzQ', 46.8653104, 7.1238213, 'city', '1'),
('countries_switzerland_lucerne_baldegg', 'ChIJg5cYLPsckEcRcNv-Oj8hfJI', 47.2003118, 8.2599523, 'city', '0'),
('countries_switzerland_lucerne_altbueron', 'ChIJFwBHrRAokEcRdaFTrj9X2GE', 47.1823166, 7.8811574, 'city', '1'),
('countries_switzerland_fribourg_cressier', 'ChIJNzqkxehsjkcRzjNlz293-f0', 46.8988241, 7.1400445, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_switzerland_jura_soyhieres', 'ChIJQ6mUOCjokUcRwj3ZJh4oBM0', 47.3904978, 7.3690995, 'city', '1'),
('countries_switzerland_fribourg_cugy', 'ChIJ97bqYMx3jkcRiMtpF9hnFhM', 46.8147442, 6.8916487, 'city', '1'),
('countries_switzerland_jura_saignelegier', 'ChIJixqmcc7_kUcRZAlQ_e_Pb4s', 47.2561774, 6.9964022, 'city', '1'),
('countries_switzerland_fribourg_domdidier', 'ChIJf8ByxcdzjkcRIc25mNMDOjk', 46.8670616, 7.0135403, 'city', '1'),
('countries_switzerland_fribourg_dompierre', 'ChIJ-QEabORzjkcR9xCx8ssKUJM', 46.8520859, 6.9907525, 'city', '1'),
('countries_switzerland_jura_reclere', 'ChIJ8RSJRhMDkkcROXM-kf3BJa8', 47.3755288, 6.9230349, 'city', '1'),
('countries_switzerland_fribourg_dudingen', 'ChIJo9VBC8RrjkcRgPsF-qKSAFo', 46.8464198, 7.1910179, 'city', '1'),
('countries_switzerland_fribourg_echarlens', 'ChIJ67Wa7rRjjkcRXmZVpAJegP0', 46.645485, 7.076872, 'city', '1'),
('countries_switzerland_fribourg_ecublens', 'ChIJKYvzR6YqjEcRIaDnJ7T_aLA', 46.6100401, 6.8085792, 'city', '1'),
('countries_switzerland_fribourg_ecuvillens', 'ChIJe5a4PHdljkcRcIm_BMeSUEY', 46.750004, 7.083334, 'city', '1'),
('countries_switzerland_fribourg_enney', 'ChIJSZL9Tn-JjkcR-Iw84S1ChzA', 46.566664, 7.083325, 'city', '1'),
('countries_switzerland_fribourg_epagny', 'ChIJ8YPM5fKJjkcRCTbUV2z5Law', 46.5882978, 7.0847379, 'city', '1'),
('countries_switzerland_fribourg_ependes', 'ChIJWVoY959ojkcRj1oEn4WfEXQ', 46.7537683, 7.1459803, 'city', '1'),
('countries_switzerland_fribourg_esmonts', 'ChIJZUTM5JJ_jkcR0vef1WpEOEc', 46.641952, 6.844437, 'city', '1'),
('countries_switzerland_jura_montavon', 'ChIJa_IMgnzlkUcRbVq0npFXuHA', 47.3730803, 7.2357007, 'city', '0'),
('countries_switzerland_fribourg_estavayer_le_gibloux', 'ChIJ-wxLTS17jkcRnDy_-wwcivc', 46.716671, 7.03333, 'city', '1'),
('countries_switzerland_jura_miecourt', 'ChIJ-Tkro7HxkUcRVOZp6s39HX8', 47.42751, 7.1737199, 'city', '1'),
('countries_switzerland_fribourg_farvagny', 'ChIJ7SQy7xlljkcRSBukqcHDsqA', 46.7210719, 7.0648956, 'city', '1'),
('countries_switzerland_fribourg_farvagny_le_grand', 'ChIJ_-vat-NkjkcRtOaajH6LTf8', 46.7208446, 7.0648066, 'city', '1'),
('countries_switzerland_fribourg_farvagny_le_petit', 'ChIJXRBSjgRljkcROYjmkrKkQIg', 46.7288715, 7.0734191, 'city', '1'),
('countries_switzerland_fribourg_ferpicloz', 'ChIJGR8ygyRmjkcR4PIYQIj_AAQ', 46.7477952, 7.1646769, 'city', '1'),
('countries_switzerland_jura_le_bemont', 'ChIJBSAXHLv_kUcRitVLJi1BD7I', 47.2641535, 7.0135675, 'city', '1'),
('countries_switzerland_jura_fregiecourt', 'ChIJzabIOSjwkUcRlLtG0Vx9aOU', 47.4125399, 7.1976976, 'city', '1'),
('countries_switzerland_jura_courtetelle', 'ChIJY2wL51rmkUcRzI2qvbLAjlk', 47.3427221, 7.3171201, 'city', '1'),
('countries_switzerland_fribourg_font', 'ChIJvUu25UnZjUcRPAiuf1XQPY0', 46.83641, 6.8228778, 'city', '1'),
('countries_switzerland_fribourg_forel', 'ChIJGbzB8ol1jkcRzAi1J08yrJA', 46.876114, 6.888342, 'city', '1'),
('countries_switzerland_fribourg_formangueires', 'ChIJt9xJiY9ujkcRIpL1mlvB19I', 46.827222, 7.116953, 'city', '1'),
('countries_switzerland_jura_courtemaiche', 'ChIJyd_DVwX2kUcRYHJM8W2qm78', 47.4595353, 7.0474127, 'city', '1'),
('countries_switzerland_fribourg_frasses', 'ChIJS1Emn6LYjUcR_tmI6bSC4zo', 46.833342, 6.866667, 'city', '1'),
('countries_switzerland_fribourg_fribourg', 'ChIJL31ajc1ujkcRLsM3ufbR5bs', 46.8064773, 7.1619719, 'city', '1'),
('countries_switzerland_jura_courcelon', 'ChIJqbhPY1HdkUcRKQ9_PyqXB7A', 47.3627302, 7.3930019, 'city', '0'),
('countries_switzerland_fribourg_gempenach', 'ChIJjc2kTY8UjkcReMsi4alHRgE', 46.9405839, 7.1974772, 'city', '1'),
('countries_switzerland_fribourg_giffers', 'ChIJe5kFZwBojkcRA8ky-kLWRX8', 46.7615548, 7.2100289, 'city', '1'),
('countries_switzerland_fribourg_gillarens', 'ChIJNVUZWjOAjkcRyQ7gRPngElE', 46.58334, 6.833326, 'city', '1'),
('countries_switzerland_fribourg_givisiez', 'ChIJb0ZwJepujkcR1mHGt6iWhgE', 46.8128615, 7.1316578, 'city', '1'),
('countries_switzerland_fribourg_gletterens', 'ChIJ7Q7D_zt1jkcR9qSWdn3DO-U', 46.8949432, 6.9371559, 'city', '1'),
('countries_switzerland_jura_chatillon', 'ChIJjUAdrgnnkUcRWflMqhCABVo', 47.331096, 7.3457297, 'city', '0'),
('countries_switzerland_fribourg_grandvillard', 'ChIJLxm5qPOLjkcRAHOh7bVU3N4', 46.540928, 7.0861428, 'city', '1'),
('countries_switzerland_fribourg_granges_de_vesin', 'ChIJoSbg0IrYjUcRBpSDQ7-SsCY', 46.816669, 6.850006, 'city', '1'),
('countries_switzerland_fribourg_granges_paccot', 'ChIJj3soobJujkcRPpRYrRZVd1s', 46.8222963, 7.1509438, 'city', '1'),
('countries_switzerland_fribourg_granges_veveyse', 'ChIJHz8Hc2uCjkcRG3q0pLxMX9M', 46.5246606, 6.8294732, 'city', '1'),
('countries_switzerland_jura_boecourt', 'ChIJWcAdg2vlkUcRuLRg61ZOI_I', 47.34802, 7.2143604, 'city', '1'),
('countries_switzerland_fribourg_grattavache', 'ChIJmW7rt0uHjkcRhWuRbe2F-sw', 46.599999, 6.916666, 'city', '1'),
('countries_switzerland_fribourg_greng', 'ChIJHbxfdKwSjkcRnnOlX7pnDiI', 46.9135672, 7.0889418, 'city', '1'),
('countries_switzerland_fribourg_grenilles', 'ChIJlSBNQiVljkcR0YKcV4_kExI', 46.733335, 7.050004, 'city', '1'),
('countries_switzerland_fribourg_grolley', 'ChIJcdlyXwNujkcR68PGq2DLX1s', 46.8328352, 7.0671904, 'city', '1'),
('countries_switzerland_fribourg_gruyeres', 'ChIJQeMzPY-JjkcRkrogkJcb0T0', 46.5777555, 7.0624775, 'city', '1'),
('countries_switzerland_jura_beurnevesin', 'ChIJC3lHAojzkUcRI1idZ6b7gpE', 47.4928252, 7.1365267, 'city', '1'),
('countries_switzerland_fribourg_guschelmuth', 'ChIJB4xgOvFsjkcRTM5zXV4z5oA', 46.88056, 7.13606, 'city', '1'),
('countries_switzerland_fribourg_hauterive', 'ChIJ4aoyZodvjkcRfq5HdvPs0Sw', 46.7610132, 7.0961217, 'city', '1'),
('countries_switzerland_fribourg_hauteville', 'ChIJPWqj0kdhjkcRwnRan3UE0U0', 46.6703036, 7.1101245, 'city', '1'),
('countries_switzerland_fribourg_heitenried', 'ChIJexafmn1BjkcRUJ3c1D0NR9w', 46.8262854, 7.3006121, 'city', '1'),
('countries_switzerland_fribourg_im_fang', 'ChIJ55mUEX9fjkcRs0MH5GiSIks', 46.59964, 7.23743, 'city', '1'),
('countries_switzerland_fribourg_jaun', 'ChIJ6VfNMzZfjkcRlkf73X4cndk', 46.6103237, 7.2861429, 'city', '1'),
('countries_switzerland_grisons_zillis', 'ChIJ9SdGdc7shEcRkzImR3LhRMM', 46.6346229, 9.4447995, 'city', '1'),
('countries_switzerland_fribourg_kerzers', 'ChIJ1TT7RFURjkcRg_5j5lAMyFg', 46.97489, 7.1954365, 'city', '1'),
('countries_switzerland_grisons_wolfgang', 'ChIJGWLcTWimhEcRCUeHfDNipVY', 46.8401387, 9.8586604, 'city', '0'),
('countries_switzerland_fribourg_kleingurmels', 'ChIJqSTaRW5rjkcRl-pesyFaYIc', 46.883332, 7.183344, 'city', '1'),
('countries_switzerland_fribourg_la_corbaz', 'ChIJ0RnTPipsjkcRisPGHc558kg', 46.838892, 7.11472, 'city', '1'),
('countries_switzerland_fribourg_la_joux', 'ChIJocE1auh9jkcRQGRrcYKm-6o', 46.633341, 6.933334, 'city', '1'),
('countries_switzerland_fribourg_la_roche', 'ChIJ2fGtRSdnjkcRWK35-mNoZP8', 46.6970359, 7.1383057, 'city', '1'),
('countries_switzerland_grisons_waltensburg', 'ChIJW9xaqakhhUcR1HGap2ZSjNA', 46.7767213, 9.1170754, 'city', '0'),
('countries_switzerland_grisons_waldhaus', 'ChIJi-O8w2TchEcRUBVoprUgau0', 46.8249003, 9.2859483, 'city', '0'),
('countries_switzerland_fribourg_lentigny', 'ChIJjwsS-H9wjkcRzNYhE9ePXL8', 46.766671, 7.000003, 'city', '1'),
('countries_switzerland_fribourg_les_friques', 'ChIJf32HZp50jkcRlX-Nskh9HXc', 46.900001, 6.983338, 'city', '1'),
('countries_switzerland_grisons_vulpera', 'ChIJ80MApwtHg0cRoHwA-SsI8MU', 46.7874053, 10.2826041, 'city', '0'),
('countries_switzerland_grisons_vrin', 'ChIJmy1NqywdhUcRYP8ZNwYhto8', 46.6550038, 9.0988945, 'city', '1'),
('countries_switzerland_grisons_vna', 'ChIJDT2J6L03g0cRi8s0_HF3qTc', 46.8431, 10.3628, 'city', '1'),
('countries_switzerland_grisons_vicosoprano', 'ChIJk4_jfmR8hEcRkEv7MvArq1o', 46.351022, 9.6220808, 'city', '0'),
('countries_switzerland_grisons_vella', 'ChIJ2Wq1hqjhhEcRkLtoKiUMvF8', 46.7179729, 9.173978, 'city', '0'),
('countries_switzerland_grisons_vals_platz', 'ChIJd57k2KvkhEcRFyFA19rXC2M', 46.6165574, 9.1814769, 'city', '0'),
('countries_switzerland_fribourg_le_mouret', 'ChIJyVemVEtmjkcR5b4-J8fnpe0', 46.7475846, 7.1777862, 'city', '1'),
('countries_switzerland_fribourg_liebistorf', 'ChIJG2pqwktrjkcRrmVTlP-K8xg', 46.90639, 7.192777, 'city', '1'),
('countries_switzerland_fribourg_lossy', 'ChIJ8cHBHn5ujkcRKLkIkfmLePk', 46.833891, 7.108616, 'city', '1'),
('countries_switzerland_fribourg_lovens', 'ChIJrw1iCnZwjkcRa8C7yXSjQhE', 46.766671, 7.016668, 'city', '1'),
('countries_switzerland_fribourg_lugnorre', 'ChIJsWjXfnENjkcR8x-JxkQq4Ns', 46.9497233, 7.0740212, 'city', '1'),
('countries_switzerland_fribourg_lully', 'ChIJk6OmkOnYjUcRY39ynQGhuws', 46.8334425, 6.8444462, 'city', '1'),
('countries_switzerland_fribourg_lurtigen', 'ChIJGRWDLFwTjkcRAeNy_lU7cIU', 46.9288209, 7.1728285, 'city', '1'),
('countries_switzerland_fribourg_lussy', 'ChIJC3Wve9t7jkcR_QLSXOOiX3U', 46.716668, 6.950002, 'city', '1'),
('countries_switzerland_grisons_valchava', 'ChIJrcIvOiMXg0cROdpc14-Crcg', 46.6013739, 10.4068685, 'city', '0'),
('countries_switzerland_grisons_tomils', 'ChIJW9Ab_MHBhEcRD1THtYgSqGI', 46.7618203, 9.4427537, 'city', '1'),
('countries_switzerland_fribourg_marly', 'ChIJkf0amr9ojkcR9alJgU_rF2M', 46.7782221, 7.1567605, 'city', '1'),
('countries_switzerland_fribourg_marsens', 'ChIJXZbzWhFjjkcRdyYh-kBPQh0', 46.6558757, 7.0644164, 'city', '1'),
('countries_switzerland_fribourg_massonnens', 'ChIJ24u5toN7jkcRLAXXtuLPgIY', 46.6983064, 6.9758491, 'city', '1'),
('countries_switzerland_fribourg_matran', 'ChIJK3fkbwpvjkcRueMxINnMr4E', 46.785386, 7.0958855, 'city', '1'),
('countries_switzerland_fribourg_maules', 'ChIJ9zi4ZRN9jkcRpxNtAGdUjnY', 46.633336, 6.983338, 'city', '1'),
('countries_switzerland_grisons_tiefencastel', 'ChIJj8X5GgOUhEcRMr944ZNPrdE', 46.6618506, 9.5771616, 'city', '0'),
('countries_switzerland_fribourg_meyriez', 'ChIJtQp-J7oSjkcR4pAxcQzCwa8', 46.9229256, 7.1083284, 'city', '1'),
('countries_switzerland_grisons_thal', 'ChIJs_QLFIMam0cRRuA4Pghlsx8', 47.4672487, 9.5662899, 'city', '0'),
('countries_switzerland_fribourg_middes', 'ChIJFf8x_f55jkcRgHbjr6CgFOI', 46.766666, 6.950007, 'city', '1'),
('countries_switzerland_grisons_tavanasa', 'ChIJWQMdShIfhUcRKeqDvdnj9oQ', 46.7540917, 9.0623319, 'city', '0'),
('countries_switzerland_grisons_tartar', 'ChIJj_6woTzqhEcRc-OeP-lXsec', 46.71864, 9.41805, 'city', '0'),
('countries_switzerland_grisons_surrein', 'ChIJDaY5Kk8ShUcR9jGXh4bvay8', 46.6749034, 8.7813549, 'city', '0'),
('countries_switzerland_fribourg_montbovon', 'ChIJ69-G_0-OjkcRZeYRO4KrGn8', 46.483332, 7.033329, 'city', '1'),
('countries_switzerland_fribourg_montbrelloz', 'ChIJ9cnefP51jkcRATBUf_5EEgw', 46.853617, 6.886671, 'city', '1'),
('countries_switzerland_fribourg_montet', 'ChIJsRsznUHVjUcR-Nq7XpcBeYU', 46.6437072, 6.8153915, 'city', '1'),
('countries_switzerland_grisons_surava', 'ChIJA8YGPMSWhEcRC6i_LgGzpNg', 46.6655067, 9.6120926, 'city', '1'),
('countries_switzerland_fribourg_montevraz', 'ChIJ_bzF7rJnjkcR8AT_MY1rTlQ', 46.7281, 7.17718, 'city', '1'),
('countries_switzerland_grisons_sues', NULL, 0, 0, 'city', '0'),
('countries_switzerland_grisons_summaprada', 'ChIJwRKRu07qhEcRNxImcyMLCWc', 46.7136773, 9.4341335, 'city', '0'),
('countries_switzerland_fribourg_morlon', 'ChIJ3xTY6hZijkcR81khPOYsges', 46.6249096, 7.0849233, 'city', '1'),
('countries_switzerland_fribourg_mossel', 'ChIJ96J0F0KAjkcR_LgZpZCu-og', 46.600007, 6.850001, 'city', '1'),
('countries_switzerland_grisons_st_moritz', 'ChIJexrAbQeChEcRJXjJPr3bnyc', 46.4907973, 9.8355079, 'city', '1'),
('countries_switzerland_fribourg_muntelier', 'ChIJ2aH9JuMSjkcRernsc2LivdM', 46.9352585, 7.1236051, 'city', '1'),
('countries_switzerland_fribourg_murist', 'ChIJW18Rf8XZjUcR8r2udJ0Hqlg', 46.7903128, 6.806841, 'city', '1'),
('countries_switzerland_fribourg_nant', 'ChIJQ92OF30SjkcRacUtu3CKWzU', 46.9555519, 7.1029612, 'city', '1'),
('countries_switzerland_fribourg_neirivue', 'ChIJcRYTuE2JjkcRCcVnezD3LeM', 46.533336, 7.066663, 'city', '1'),
('countries_switzerland_fribourg_neyruz', 'ChIJo278eu1vjkcRX2sHLmPylh8', 46.7685914, 7.0658652, 'city', '1'),
('countries_switzerland_fribourg_nierlet_les_bois', 'ChIJJ7K4hdtxjkcR7kJGiBfYDKw', 46.81667, 7.050005, 'city', '1'),
('countries_switzerland_grisons_strada', 'ChIJdWek6i3ehEcRKQ5tGdZ_gec', 46.77591, 9.18537, 'city', '0'),
('countries_switzerland_fribourg_nuvilly', 'ChIJ8Sxi1CTYjUcRkOsYQIj_AAQ', 46.7823407, 6.8330755, 'city', '1'),
('countries_switzerland_fribourg_oberschrot', 'ChIJsc_H4t5cjkcRUQMLwN60c2M', 46.7381514, 7.2663873, 'city', '1'),
('countries_switzerland_fribourg_onnens', 'ChIJVwpfEBZwjkcR6jfS48BsfrE', 46.783337, 7.033339, 'city', '1'),
('countries_switzerland_fribourg_orsonnens', 'ChIJ0wF0PxB7jkcRXBEGAt45qbA', 46.716665, 7.000004, 'city', '1'),
('countries_switzerland_grisons_stierva', 'ChIJ66dxS3iUhEcRPshCl422INI', 46.6635481, 9.5421051, 'city', '0'),
('countries_switzerland_fribourg_plaffeien', 'ChIJR7ZNFjVDjkcRz3LpelACNRc', 46.7365103, 7.2923293, 'city', '1'),
('countries_switzerland_fribourg_plasselb', 'ChIJeY1tw5tdjkcRsAFHyDh16Sc', 46.7353048, 7.2504665, 'city', '1'),
('countries_switzerland_fribourg_ponthaux', 'ChIJA2m5pu5xjkcRXhOFpmyTLH4', 46.81518, 7.04141, 'city', '1'),
('countries_switzerland_fribourg_pont_la_ville', 'ChIJJcTtzxlkjkcRozkj0rlcQy8', 46.6991414, 7.1107699, 'city', '1'),
('countries_switzerland_fribourg_porsel', 'ChIJ4xzFVPWAjkcRJDpfk5XxYf0', 46.600002, 6.866668, 'city', '1'),
('countries_switzerland_grisons_stels', 'ChIJu4-XcNuzhEcRax0z9p0yUP0', 46.965811, 9.714594, 'city', '1'),
('countries_switzerland_fribourg_posat', 'ChIJlSBNQiVljkcRGi4JTu8pUzY', 46.733335, 7.050004, 'city', '1'),
('countries_switzerland_fribourg_posieux', 'ChIJTYshvXtvjkcRAvTaIphNCOM', 46.76667, 7.100008, 'city', '1'),
('countries_switzerland_grisons_stampa', 'ChIJ5f8x0p98hEcRUKI35iZg_38', 46.3434001, 9.5906236, 'city', '0'),
('countries_switzerland_fribourg_prez_vers_siviriez', 'ChIJozVnxc5_jkcRZKYc0nKoOlo', 46.63334, 6.866667, 'city', '1'),
('countries_switzerland_grisons_spluegen', 'ChIJ_bztaj3xhEcRQzcwM9itGg8', 46.5528268, 9.3233581, 'city', '1'),
('countries_switzerland_fribourg_progens', 'ChIJ9-5f2S6HjkcR2IzPQxttiEY', 46.583339, 6.916658, 'city', '1'),
('countries_switzerland_fribourg_promasens', 'ChIJLbd8754qjEcRcdJF-BGy-SY', 46.600001, 6.816669, 'city', '1'),
('countries_switzerland_fribourg_rechthalten', 'ChIJkQf2YrlCjkcR3mR6fo2aQxo', 46.7678316, 7.2406632, 'city', '1'),
('countries_switzerland_fribourg_remaufens', 'ChIJZ4DKOeeDjkcRf5Xf4Y2gjnU', 46.5310802, 6.8783, 'city', '1'),
('countries_switzerland_fribourg_riaz', 'ChIJ-cdel-dijkcRy5-0WhZc9bo', 46.6415102, 7.0623693, 'city', '1'),
('countries_switzerland_grisons_sils_segl_maria', 'ChIJ_fiaKkeAhEcRBfUdrV1V5jw', 46.43218, 9.76529, 'city', '0'),
('countries_switzerland_fribourg_romanens', 'ChIJ_dnyC6t9jkcRpae4dqfJQ9g', 46.65, 6.966659, 'city', '1'),
('countries_switzerland_fribourg_romont', 'ChIJHfnFZLV-jkcRE-0FYXLiV4E', 46.691887, 6.9118086, 'city', '1'),
('countries_switzerland_grisons_segnas', 'ChIJfRjHx8IThUcRpEN482F-9wA', 46.6971783, 8.8110715, 'city', '0'),
('countries_switzerland_fribourg_rossens', 'ChIJK_qeUzVkjkcRxCBgy_bmqMk', 46.7205552, 7.1041753, 'city', '1'),
('countries_switzerland_fribourg_rue', 'ChIJd60hVhOAjkcRRTJd4lK0Zgk', 46.6222539, 6.8250784, 'city', '1'),
('countries_switzerland_fribourg_rueyres', 'ChIJGeMtRrJ9jkcR4pk6W_u4WQY', 46.64928, 6.95688, 'city', '1'),
('countries_switzerland_grisons_seewis_schmitten', 'ChIJ_7OTJ7W1hEcR2Kd56mszkUU', 46.98642, 9.64004, 'city', '0'),
('countries_switzerland_grisons_seewis_im_praetigau', 'ChIJi995m5e0hEcRopb17nxd5-g', 46.9905027, 9.6372642, 'city', '0'),
('countries_switzerland_fribourg_saint_aubin', 'ChIJKxPgKX5zjkcRKqrB7Cpx0G8', 46.8897484, 6.9806203, 'city', '1'),
('countries_switzerland_grisons_seewis', 'ChIJi995m5e0hEcRopb17nxd5-g', 46.9905027, 9.6372642, 'city', '1'),
('countries_switzerland_grisons_schleuis', 'ChIJA147otjdhEcRQkD0n4SnBLM', 46.7884878, 9.2264769, 'city', '1'),
('countries_switzerland_fribourg_schmitten', 'ChIJKWlo03BqjkcRNqPsfX7XEVk', 46.85552, 7.24859, 'city', '1'),
('countries_switzerland_grisons_scanfs', 'ChIJMeD6-yBkg0cRZggXkxL6-3Y', 46.6114275, 9.9829535, 'city', '1'),
('countries_switzerland_grisons_savognin', 'ChIJwUQGaSiQhEcRog63-0x1O5I', 46.5973658, 9.5969599, 'city', '0'),
('countries_switzerland_fribourg_semsales', 'ChIJGVW29WOGjkcREZXTBoYsmlE', 46.57386, 6.92926, 'city', '1'),
('countries_switzerland_grisons_sarn', 'ChIJex7ArJrphEcRzGCQ1EDpXiQ', 46.7200511, 9.408912, 'city', '0'),
('countries_switzerland_fribourg_siviriez', 'ChIJ_XsOq1F-jkcRsgcjlNJnuvs', 46.6585092, 6.877722, 'city', '1'),
('countries_switzerland_fribourg_sommentier', 'ChIJKehnpwt-jkcR84z9YSUY3J8', 46.633337, 6.916671, 'city', '1'),
('countries_switzerland_fribourg_sorens', 'ChIJ94GPekRjjkcRspWMimypPEA', 46.6691888, 7.0586245, 'city', '1'),
('countries_switzerland_grisons_san_carlo', 'ChIJD9ltHoeeg0cRRNuEPUwQEmY', 46.3416266, 10.0600307, 'city', '0'),
('countries_switzerland_grisons_san_bernardino', 'ChIJEfqLC3H4hEcRe7jb3lFU0eU', 46.46262, 9.19196, 'city', '0'),
('countries_switzerland_grisons_santa_maria', 'ChIJ0ZwRhlUXg0cR6A8T5nDu47Q', 46.6020161, 10.4249076, 'city', '1'),
('countries_switzerland_fribourg_tafers', 'ChIJ_zQP5L9pjkcRkPYqPozHbf8', 46.815327, 7.21575, 'city', '1'),
('countries_switzerland_grisons_salux', 'ChIJEZMoBHmRhEcRGTiz5RN1DxM', 46.6246211, 9.5756662, 'city', '0'),
('countries_switzerland_fribourg_tentlingen', 'ChIJO-v22W1ojkcR_ap-OX_7ZzY', 46.7688786, 7.1987844, 'city', '1'),
('countries_switzerland_grisons_saas_im_praettigau', 'ChIJG28MC06uhEcR6Ngq6X6iYRY', 46.916667, 9.8, 'city', '1'),
('countries_switzerland_fribourg_treyvaux', 'ChIJpQuW0l9mjkcR1xMjAUrYvm8', 46.7272477, 7.1373388, 'city', '1'),
('countries_switzerland_fribourg_ueberstorf', 'ChIJGdDZjuRAjkcRfsw1vzzYNUE', 46.8647695, 7.3117323, 'city', '1'),
('countries_switzerland_fribourg_ulmiz', 'ChIJM0QzKL4UjkcRlX37U4jr6S8', 46.9325848, 7.2009646, 'city', '1'),
('countries_switzerland_fribourg_ursy', 'ChIJ-yrgC99_jkcRAXNdWYjLbKg', 46.6344043, 6.83538, 'city', '1'),
('countries_switzerland_fribourg_vallon', 'ChIJbzXZ3l50jkcRMOwYQIj_AAQ', 46.8850375, 6.9534422, 'city', '1'),
('countries_switzerland_fribourg_vauderens', 'ChIJ2717i3SAjkcRMfBOYUmfUcw', 46.616667, 6.850003, 'city', '1'),
('countries_switzerland_fribourg_vaulruz', 'ChIJbfqiDlt9jkcR-5zWOTplImc', 46.620589, 6.9891773, 'city', '1'),
('countries_switzerland_fribourg_vesin', 'ChIJLdo-aXbYjUcREphYfkxSdTY', 46.800004, 6.866667, 'city', '1'),
('countries_switzerland_fribourg_villaraboud', 'ChIJX1i9cJB-jkcRh5pxrnIE1jQ', 46.666667, 6.916663, 'city', '1'),
('countries_switzerland_fribourg_villarbeney', 'ChIJeRp6X4lhjkcRpndTD5AfI6s', 46.628892, 7.108614, 'city', '1'),
('countries_switzerland_fribourg_villarepos', 'ChIJVeuoR3ltjkcRcA0ZQIj_AAQ', 46.8832682, 7.0718558, 'city', '1'),
('countries_switzerland_fribourg_villargiroud', 'ChIJ5XwyNG97jkcRaOROmozgVmI', 46.700005, 6.999996, 'city', '1'),
('countries_switzerland_fribourg_villariaz', 'ChIJI-2gjiZ8jkcRBoYOzFJhHf0', 46.66667, 6.933336, 'city', '1'),
('countries_switzerland_grisons_rodels', 'ChIJ_wj4a27qhEcRYcRg0KflMUw', 46.7353373, 9.4446744, 'city', '1'),
('countries_switzerland_fribourg_villarlod', 'ChIJuzgTOkl7jkcRr4jKU0lKlJ4', 46.702778, 7.022228, 'city', '1'),
('countries_switzerland_grisons_ramosch', 'ChIJT0zqt3Y3g0cRNfFrD8vY0J0', 46.8345584, 10.382398, 'city', '0'),
('countries_switzerland_fribourg_villarsiviriaux', 'ChIJz4oidkV7jkcRbHSGHelwhlY', 46.700005, 7.016666, 'city', '1'),
('countries_switzerland_fribourg_villars_sous_mont', 'ChIJcRYTuE2JjkcRnpt4NnUgXU0', 46.533336, 7.066663, 'city', '1'),
('countries_switzerland_grisons_pusserein', 'ChIJQ86szJCzhEcRp6QVTqnv5wI', 46.98644, 9.70855, 'city', '0'),
('countries_switzerland_fribourg_villarvolard', 'ChIJDaVawKBhjkcRSpr_a_wOsb4', 46.6459991, 7.1071065, 'city', '1'),
('countries_switzerland_fribourg_villaz_saint_pierre', 'ChIJSb7Jvdp7jkcRjrHSU4gXsRk', 46.7209743, 6.961234, 'city', '1'),
('countries_switzerland_fribourg_villeneuve', 'ChIJt00oQmN4jkcRplBF0qFMcj8', 46.7464845, 6.868663, 'city', '1'),
('countries_switzerland_fribourg_vuadens', 'ChIJ12uB4QWIjkcRPS-hb05313g', 46.6180319, 7.0250012, 'city', '1'),
('countries_switzerland_fribourg_vuarmarens', 'ChIJkdgo3WHVjUcRfgbL3bnpOfw', 46.64452, 6.82696, 'city', '1'),
('countries_switzerland_fribourg_vuippens', 'ChIJETFOnaRjjkcR8ybA5DFR0J4', 46.66, 7.075, 'city', '1'),
('countries_switzerland_fribourg_vuisternens_devant_romont', 'ChIJW5qFTM19jkcRkMo4HC38L84', 46.6557858, 6.9299774, 'city', '1'),
('countries_switzerland_fribourg_vuisternens_en_ogoz', 'ChIJmZSAxJVkjkcRYeIZqzmwcV4', 46.7072449, 7.0527766, 'city', '1'),
('countries_switzerland_grisons_promontogno', 'ChIJDS91269khEcRKhh2x-URK-I', 46.3388066, 9.5572625, 'city', '0'),
('countries_switzerland_fribourg_wallenried', 'ChIJFfqIbwdtjkcRkD1yuP0qtYU', 46.8735747, 7.1157994, 'city', '1'),
('countries_switzerland_grisons_pratval', 'ChIJC47Ow2fqhEcRHnGCJG7Aylw', 46.7317233, 9.4457044, 'city', '0'),
('countries_switzerland_grisons_pragg_jenaz', 'ChIJV8uzyWyxhEcRAgcxxGciLi8', 46.9396094, 9.7064554, 'city', '0'),
('countries_switzerland_fribourg_zumholz', 'ChIJ-SO3TDdDjkcRWuPyK_zW9k8', 46.7539659, 7.292338, 'city', '1'),
('countries_switzerland_geneva_aire_la_ville', 'ChIJ47LkPyR9jEcR0Ce68ov_EwY', 46.1905583, 6.0428984, 'city', '1'),
('countries_switzerland_grisons_praez', 'ChIJ09b_0PzphEcR416YjxdulUg', 46.7427, 9.4052, 'city', '0'),
('countries_switzerland_geneva_athenaz_avusy', 'ChIJuyk8rI99jEcRguqGzsUEvBA', 46.1444638, 6.0122909, 'city', '1'),
('countries_switzerland_geneva_avully', 'ChIJFf9Zo3h9jEcRCYsppQzpgp8', 46.1696093, 6.0013782, 'city', '1'),
('countries_switzerland_geneva_bardonnex', 'ChIJGQbaJLB7jEcR5tk478MkDB0', 46.1503619, 6.1052649, 'city', '1'),
('countries_switzerland_geneva_bellevue', 'ChIJv8v11TVkjEcRsHMZQIj_AAQ', 46.2557621, 6.1471443, 'city', '1'),
('countries_switzerland_geneva_bernex', 'ChIJcXtdhZJ8jEcRHkB0eZ0Y6OY', 46.1771419, 6.0764849, 'city', '1'),
('countries_switzerland_geneva_carouge', 'ChIJS_5XCd56jEcR0HMZQIj_AAQ', 46.1829674, 6.1378539, 'city', '1'),
('countries_switzerland_geneva_cartigny', 'ChIJJ7amKw19jEcR5gde-0YI3AI', 46.1741622, 6.0195753, 'city', '1'),
('countries_switzerland_grisons_pignieu', 'ChIJ8SWiubSShEcRfyG0zr6JGzk', 46.6136788, 9.4381171, 'city', '1'),
('countries_switzerland_grisons_paspels', 'ChIJEQRopdDBhEcR8CYZQIj_AAQ', 46.7495493, 9.4422872, 'city', '0'),
('countries_switzerland_grisons_parsonz', 'ChIJXZo2Xf2NhEcRxUc4vY1_0vk', 46.5974706, 9.5731025, 'city', '0'),
('countries_switzerland_geneva_chancy', 'ChIJO61KWUKHjEcRb4VEjtfXJz4', 46.1494996, 5.9727228, 'city', '1'),
('countries_switzerland_grisons_pany', 'ChIJBxBGIyeuhEcRglU4YIO32I8', 46.92779, 9.77068, 'city', '0'),
('countries_switzerland_grisons_obervaz', 'ChIJqfrljnSVhEcRPJJHUId8iBo', 46.72594, 9.55765, 'city', '1'),
('countries_switzerland_grisons_obersaxen', 'ChIJi-F9pEQehUcRycMROxq9jJU', 46.7488642, 9.1000399, 'city', '0'),
('countries_switzerland_geneva_choulex', 'ChIJOeWSbKVvjEcRnDgFRxeEOmk', 46.2233187, 6.2244344, 'city', '1'),
('countries_switzerland_grisons_mulegns', 'ChIJrTnSjCmPhEcRXZ8PGo-WOIA', 46.5241285, 9.6204795, 'city', '0'),
('countries_switzerland_geneva_collonge_bellerive', 'ChIJSUBEEYxljEcRnYrh6iRJItI', 46.2514024, 6.2022904, 'city', '1'),
('countries_switzerland_geneva_cologny', 'ChIJ11VQx29ljEcRt756is3eeOY', 46.224552, 6.1827372, 'city', '1'),
('countries_switzerland_grisons_muestair', 'ChIJ_7wjDdcZg0cRw6O9vaXm2oY', 46.6261772, 10.445857, 'city', '1'),
('countries_switzerland_geneva_confignon', 'ChIJHQdhDJ58jEcR__tlesKN1RQ', 46.1740305, 6.0835592, 'city', '1'),
('countries_switzerland_geneva_corsier', 'ChIJ9WkSRKxojEcRx-KdJwlRCfo', 46.2626576, 6.2250271, 'city', '1'),
('countries_switzerland_geneva_dardagny', 'ChIJBzNWUOWHjEcRor0zrzbaDxI', 46.1947347, 5.9949263, 'city', '1'),
('countries_switzerland_geneva_geneva', 'ChIJ6-LQkwZljEcRObwLezWVtqA', 46.2043907, 6.1431577, 'city', '1'),
('countries_switzerland_geneva_genthod', 'ChIJj9n1NdNljEcRzVTvSyi7N-w', 46.2644048, 6.1546616, 'city', '1'),
('countries_switzerland_grisons_monstein', 'ChIJ0_0IPaKYhEcRoqxwg6C_IVk', 46.713056, 9.769444, 'city', '1'),
('countries_switzerland_geneva_gy', 'ChIJa_Sf9LtujEcRfLoyMrP2EvM', 46.2495945, 6.2547728, 'city', '1'),
('countries_switzerland_geneva_hermance', 'ChIJr9O1mu1ojEcRRa8iyu3ONbw', 46.3006983, 6.2449688, 'city', '1'),
('countries_switzerland_geneva_jussy', 'ChIJJ2cUzJtujEcRvdYo-BLwClg', 46.2347656, 6.2652187, 'city', '1'),
('countries_switzerland_geneva_lancy', 'ChIJh4s-Tzl7jEcRONiaQQd7cS4', 46.1885168, 6.1144546, 'city', '1'),
('countries_switzerland_grisons_meierhof', 'ChIJB08bAsmomkcRk8cvjImvTDY', 47.2611631, 8.5967166, 'city', '0'),
('countries_switzerland_grisons_lunden', NULL, 0, 0, 'city', '0'),
('countries_switzerland_grisons_maloja_district', 'ChIJA3ICJCWJhEcRif5O_eZKRQ8', 46.4734417, 9.9040345, 'city', '0'),
('countries_switzerland_grisons_lumbrein', 'ChIJ44TNlTrihEcRkv7xTZOsAvw', 46.6832997, 9.1359177, 'city', '1'),
('countries_switzerland_grisons_lue', 'ChIJCRCo5YsWg0cRsxWwx1wJUwc', 46.6236316, 10.3686811, 'city', '1'),
('countries_switzerland_grisons_li_curt', 'ChIJx8KmUbaeg0cRA0dm-HaCL4Q', 46.31119, 10.063199, 'city', '0'),
('countries_switzerland_grisons_le_prese', 'ChIJaz7ZGiaZg0cRjb3McUmC5jQ', 46.292854, 10.0781738, 'city', '0'),
('countries_switzerland_geneva_meinier', 'ChIJ4aiPyxxvjEcRwuyN1Senw-U', 46.2467593, 6.2343577, 'city', '1'),
('countries_switzerland_geneva_meyrin', 'ChIJqyoJ0nZjjEcR5dqtvaztCd0', 46.2283204, 6.070988, 'city', '1'),
('countries_switzerland_geneva_onex', 'ChIJM1H8lER7jEcR8ReANchNzhM', 46.183541, 6.1002345, 'city', '1'),
('countries_switzerland_grisons_lenzerheide', 'ChIJecNs_4KVhEcRtcPP3GmDSus', 46.7260018, 9.5577484, 'city', '0'),
('countries_switzerland_grisons_lenz', 'ChIJ-9EbJzyUhEcRTiKiViORo8w', 46.6858661, 9.5632732, 'city', '1'),
('countries_switzerland_geneva_plan_les_ouates', 'ChIJa3TRmQh7jEcRcdO2vnPbreY', 46.1668075, 6.1145793, 'city', '1'),
('countries_switzerland_geneva_presinge', 'ChIJbaWFwG5ujEcRoJF2WzU1Ntg', 46.218603, 6.2535283, 'city', '1'),
('countries_switzerland_geneva_puplinge', 'ChIJQcKeIjVujEcRZSNGSzjGTFI', 46.2105553, 6.2317139, 'city', '1'),
('countries_switzerland_geneva_russin', 'ChIJAUFGT1p9jEcRoHUZQIj_AAQ', 46.1880652, 6.0135719, 'city', '1'),
('countries_switzerland_geneva_satigny', 'ChIJe_63-MZijEcRAC2kiT_hLVE', 46.215764, 6.0332425, 'city', '1'),
('countries_switzerland_grisons_lavin', 'ChIJTaZFlVVDg0cRC2Ssh638ccw', 46.7679834, 10.1107044, 'city', '0'),
('countries_switzerland_geneva_soral', 'ChIJhw_180h8jEcRckWXoHHFUYQ', 46.1444245, 6.043746, 'city', '1'),
('countries_switzerland_grisons_kueblis', 'ChIJ2WcQ0FOuhEcRFC-AWapZ4K8', 46.9144002, 9.7784561, 'city', '1'),
('countries_switzerland_geneva_troinex', 'ChIJV3ZbK2B6jEcRhj5t18oI6UE', 46.1640891, 6.1450701, 'city', '1'),
('countries_switzerland_geneva_vernier', 'ChIJ6YIYrENjjEcRjGr9aR97GYE', 46.2122638, 6.1052686, 'city', '1'),
('countries_switzerland_geneva_versoix', 'ChIJfahUxuxmjEcR3xYbDBl_g6U', 46.2876938, 6.1657813, 'city', '1'),
('countries_switzerland_grisons_klosters_serneus', 'ChIJ597WZAtYg0cRwzydndb23Wk', 46.8699029, 9.8828697, 'city', '1'),
('countries_switzerland_geneva_vessy', 'ChIJ16AsTJN6jEcRigVJgAVUhc4', 46.1723065, 6.1585823, 'city', '1'),
('countries_switzerland_geneva_veyrier', 'ChIJ_0G7uZZ6jEcRko5dJOF8L1Q', 46.1660489, 6.178397, 'city', '1'),
('countries_switzerland_grisons_klosters_platz', 'ChIJ597WZAtYg0cRwzydndb23Wk', 46.8699029, 9.8828697, 'city', '0'),
('countries_switzerland_glarus_bilten', 'ChIJH74p08rNmkcRsStfq7GvG8w', 47.15253, 9.02622, 'city', '1'),
('countries_switzerland_grisons_klosters_dorf', 'ChIJ597WZAtYg0cRwzydndb23Wk', 46.8699029, 9.8828697, 'city', '0'),
('countries_switzerland_glarus_diesbach', 'ChIJc3_OcJYlhUcR59p9Ssfzgac', 46.916667, 9.05, 'city', '1'),
('countries_switzerland_glarus_elm', 'ChIJo2EJTZInhUcRQWNXorl79HQ', 46.9197957, 9.1723405, 'city', '1'),
('countries_switzerland_glarus_engi', 'ChIJT5i4zIUphUcRok52M30bepc', 46.9821094, 9.1532227, 'city', '1'),
('countries_switzerland_glarus_ennenda', 'ChIJwZw0YukshUcRFFIlJCRLFag', 47.0338781, 9.0775529, 'city', '1'),
('countries_switzerland_glarus_filzbach', 'ChIJ4zKkJnTTmkcRV6KHtyGcLN4', 47.12104, 9.1301699, 'city', '1'),
('countries_switzerland_glarus_glarus', 'ChIJUch2OooxhUcRskRR7dNUM4I', 47.0411232, 9.0679, 'city', '1'),
('countries_switzerland_glarus_haslen', 'ChIJr2xzKBAvhUcRXHL0cxl4A6w', 46.9808737, 9.0558843, 'city', '1'),
('countries_switzerland_glarus_leuggelbach', 'ChIJpZARDAcvhUcRdvquV4_o4t8', 46.966667, 9.0499999, 'city', '1'),
('countries_switzerland_grisons_guarda', 'ChIJQ-_r5o5Eg0cRaWldWgQsGJ0', 46.7756707, 10.1528726, 'city', '0'),
('countries_switzerland_grisons_gruesch', 'ChIJ0eIy1Je2hEcRmG-fm6tg4co', 46.9806104, 9.6503565, 'city', '1'),
('countries_switzerland_grisons_glaris', 'ChIJUch2OooxhUcRskRR7dNUM4I', 47.0411232, 9.0679, 'city', '0'),
('countries_switzerland_glarus_mollis', 'ChIJk1p6UC0thUcRYW_1nh2Uj9A', 47.0940067, 9.0754485, 'city', '1'),
('countries_switzerland_glarus_muhlehorn', 'ChIJ7QGflPTUmkcRA0hrWr4cJ_w', 47.1171625, 9.1728977, 'city', '1'),
('countries_switzerland_grisons_fuldera', 'ChIJSbvkjuoWg0cRyeGf8hS7rpw', 46.6097264, 10.3705831, 'city', '0'),
('countries_switzerland_glarus_netstal', 'ChIJhzi8RWMthUcRzN5b15OTwXc', 47.0633697, 9.0550398, 'city', '1'),
('countries_switzerland_glarus_niederurnen', 'ChIJ_R35IQvNmkcR81NAcbEouW4', 47.125507, 9.0531505, 'city', '1'),
('countries_switzerland_glarus_oberurnen', 'ChIJrwieLkDNmkcRkxHabIEWoDw', 47.1159405, 9.0590745, 'city', '1'),
('countries_switzerland_glarus_obstalden', 'ChIJYR6xvoPUmkcRf4pD1SBqFt4', 47.1171651, 9.1507461, 'city', '1'),
('countries_switzerland_grisons_fuerstenaubruck', 'ChIJrad1vl7qhEcREH0yYLV_Oow', 46.7209001, 9.4468071, 'city', '0'),
('countries_switzerland_grisons_fuerstenau', 'ChIJrad1vl7qhEcREH0yYLV_Oow', 46.7209001, 9.4468071, 'city', '1'),
('countries_switzerland_grisons_ftan', 'ChIJm2Y2YlhGg0cRg6jTc5AOKFE', 46.7936912, 10.246801, 'city', '0'),
('countries_switzerland_grisons_fex', 'ChIJP7jhfXKAhEcRY9NSC15FaEo', 46.41766, 9.76017, 'city', '1'),
('countries_switzerland_grisons_domat', 'ChIJ6bsanU_BhEcR8bEjWP3xidU', 46.8336355, 9.4473545, 'city', '1'),
('countries_switzerland_grisons_digg', NULL, 0, 0, 'city', '0'),
('countries_switzerland_grisons_davos_wiesen', 'ChIJQS9wPQ2YhEcRo5QxABStGG4', 46.7046823, 9.715258, 'city', '0'),
('countries_switzerland_grisons_andeer', 'ChIJI4bF34XyhEcRxOY7Mnzt1Ng', 46.6034023, 9.4263657, 'city', '1'),
('countries_switzerland_grisons_davos_platz', 'ChIJnaVk3xChhEcR2JYt34kGM9A', 46.8027453, 9.8359701, 'city', '0'),
('countries_switzerland_grisons_arosa', 'ChIJ3T5UiFW8hEcRKMrhXh0MT1I', 46.7823704, 9.6799111, 'city', '1'),
('countries_switzerland_grisons_bever', 'ChIJrZDParRig0cRPBVxSaEbdnY', 46.5522859, 9.8895129, 'city', '1'),
('countries_switzerland_grisons_davos_dorf', 'ChIJnaVk3xChhEcR2JYt34kGM9A', 46.8027453, 9.8359701, 'city', '0'),
('countries_switzerland_grisons_bonaduz', 'ChIJZeNjkP7ChEcRvaBP7yGNDCw', 46.8117055, 9.4000143, 'city', '1'),
('countries_switzerland_grisons_curaglia', 'ChIJw6Ce1cQPhUcR2w8_Any5604', 46.6514314, 8.8516064, 'city', '0'),
('countries_switzerland_grisons_cunter', 'ChIJI2FiCqSRhEcRGAnts0ooKmc', 46.607274, 9.5916708, 'city', '0'),
('countries_switzerland_grisons_brienz', 'ChIJwz_TLaWWhEcRfJMSdrqVznw', 46.66741, 9.59336, 'city', '1'),
('countries_switzerland_grisons_brusio', 'ChIJVSQxZn2Yg0cRoS3k021n41Q', 46.2581118, 10.1262977, 'city', '1'),
('countries_switzerland_grisons_calfreisen', 'ChIJdXeVrQK5hEcRO6OAQw86kK4', 46.8414239, 9.5944387, 'city', '1'),
('countries_switzerland_grisons_cama', 'ChIJeYopqRtFhEcRoJBQJ6KNBy4', 46.2724015, 9.1695593, 'city', '1'),
('countries_switzerland_grisons_cumbel', 'ChIJFUeFx8TghEcR04YfsA5QKQw', 46.7257143, 9.1919698, 'city', '0'),
('countries_switzerland_grisons_castaneda', 'ChIJYy8GmQtPhEcR8k4A7Ih4vak', 46.2570919, 9.1389106, 'city', '1'),
('countries_switzerland_grisons_castasegna', 'ChIJMUQ2FYpkhEcR7mRo-cuym44', 46.3333, 9.5140999, 'city', '1'),
('countries_switzerland_grisons_castiel', 'ChIJlUBFFwq5hEcRR6QNLGw6TD0', 46.8397283, 9.6053271, 'city', '1'),
('countries_switzerland_grisons_castrisch', 'ChIJf7QVMfDdhEcRflxUgNPiglo', 46.7762431, 9.2313794, 'city', '1'),
('countries_switzerland_grisons_cazis', 'ChIJRUC5cAjqhEcR-n3ju1edzUk', 46.7207797, 9.4301515, 'city', '1'),
('countries_switzerland_grisons_conters', 'ChIJcwXgjaWvhEcRr0UOAEgeppM', 46.90164, 9.79853, 'city', '1'),
('countries_switzerland_grisons_chur', 'ChIJVVv3inbHhEcRMB8B16Z4Tys', 46.8507835, 9.5319859, 'city', '1'),
('countries_switzerland_grisons_churwalden', 'ChIJwwyxzXS_hEcRbkqTo6KuCTQ', 46.7809052, 9.5434284, 'city', '1'),
('countries_switzerland_grisons_compatsch', 'ChIJXU-keD41g0cRcwgz_Bu2ge8', 46.96028, 10.40523, 'city', '0'),
('countries_switzerland_grisons_cinuos_chel', 'ChIJWYjA3Vxmg0cRs5rLla0Pyqc', 46.6409523, 10.0226046, 'city', '0'),
('countries_switzerland_grisons_clavadel', 'ChIJbeTdxWOhhEcRRTYoGrkxlx8', 46.76755, 9.81502, 'city', '1'),
('countries_switzerland_grisons_cierfs', 'ChIJ28lYr6gVg0cRcuU-V9ZI5W4', 46.6276392, 10.3328622, 'city', '0'),
('countries_switzerland_grisons_cresta', 'ChIJ8Qy32tWLhEcRaBfUCATkLyo', 46.47225, 9.51361, 'city', '1'),
('countries_switzerland_grisons_celerina', 'ChIJeeOzB759g0cRHEJvdYrIkiE', 46.5123333, 9.8589518, 'city', '1'),
('countries_switzerland_grisons_campfer', 'ChIJHct6qAF-g0cRMzBxU0UB2tI', 46.47848, 9.81143, 'city', '0'),
('countries_switzerland_grisons_camischolas', 'ChIJ-aFS8VUShUcRbwfV7LJjNv0', 46.6795378, 8.7655068, 'city', '0'),
('countries_switzerland_grisons_dalin', 'ChIJWScpqfbphEcR1vfXV3MpD90', 46.73511, 9.40431, 'city', '1'),
('countries_switzerland_grisons_danis', 'ChIJha1KvBUfhUcR0DX6gpSHjoo', 46.75502, 9.05491, 'city', '1'),
('countries_switzerland_grisons_dardin', 'ChIJb1aiSD8fhUcRKIc3f2FMCho', 46.757798, 9.048786, 'city', '1'),
('countries_switzerland_grisons_davos', 'ChIJnaVk3xChhEcR2JYt34kGM9A', 46.8027453, 9.8359701, 'city', '1'),
('countries_switzerland_grisons_breil', 'ChIJbU85KnsfhUcRmSHcSUxkoao', 46.7695626, 9.0613759, 'city', '1'),
('countries_switzerland_grisons_borgonovo', 'ChIJCVlJjZx8hEcRPCCZEKEut9k', 46.3477208, 9.6041429, 'city', '0'),
('countries_switzerland_grisons_bivio', 'ChIJb8VQNPyGhEcRo5tdvNgpmwU', 46.4677669, 9.6504508, 'city', '0'),
('countries_switzerland_grisons_disentis', 'ChIJJY_xZTgRhUcRtLVfdeKwSYo', 46.7051127, 8.8523754, 'city', '1'),
('countries_switzerland_grisons_ardez', 'ChIJ99WgFh9Eg0cRM7kffTzSB6Q', 46.7749013, 10.2017095, 'city', '0'),
('countries_switzerland_grisons_donat', 'ChIJ0TzCDlaKhEcRsdqfiv9SRgs', 46.466667, 9.466667, 'city', '1'),
('countries_switzerland_grisons_falera', 'ChIJfTAfPdvehEcROvWtdCfE-FY', 46.8012412, 9.2304912, 'city', '1'),
('countries_switzerland_grisons_fanas', 'ChIJVVFQj2q0hEcRlidgo-mMsm0', 46.9847508, 9.6664169, 'city', '1'),
('countries_switzerland_grisons_feldis', 'ChIJrycp_XzBhEcR0yNGYaBHDuQ', 46.79406, 9.43264, 'city', '1'),
('countries_switzerland_grisons_felsberg', 'ChIJW4h1x4fGhEcR_ecZlxToDME', 46.8452376, 9.4712304, 'city', '1'),
('countries_switzerland_grisons_alvaschein', 'ChIJiVy6moqUhEcRMHzG5gNLPg8', 46.67476, 9.5508601, 'city', '0'),
('countries_switzerland_grisons_fideris', 'ChIJERdNARKwhEcREqobYH4-gTM', 46.91472, 9.74111, 'city', '1'),
('countries_switzerland_grisons_filisur', 'ChIJ-95Sq46ZhEcRB5ExOqu4sFg', 46.6734153, 9.686377, 'city', '1'),
('countries_switzerland_grisons_flerden', 'ChIJ-TSiqtHrhEcRvETb0oaRspU', 46.70306, 9.4085, 'city', '1'),
('countries_switzerland_grisons_flims', 'ChIJw1rJi4jbhEcRokh6y0CRQlE', 46.8366348, 9.2846923, 'city', '1'),
('countries_switzerland_grisons_flond', 'ChIJfUDinQ7ghEcRCAPgXBUtPNk', 46.7672804, 9.1654368, 'city', '1'),
('countries_switzerland_grisons_frauenkirch', 'ChIJid6Cs8SjhEcR7Ww5olR5rI4', 46.7673762, 9.7975634, 'city', '1'),
('countries_switzerland_grisons_alvaneu', 'ChIJD3Z1-w-XhEcRu-9_plQj3oE', 46.67868, 9.64591, 'city', '1'),
('countries_switzerland_grisons_almens', 'ChIJ-yNr_Z7qhEcRvTNoqD55RUo', 46.7375722, 9.4558414, 'city', '1'),
('countries_switzerland_glarus_ziegelbrucke', 'ChIJ32hgZXzSmkcRVJjAn3E8IyE', 47.1339, 9.0613, 'city', '1'),
('countries_switzerland_grisons_furna', 'ChIJa1BjjDOxhEcRVXpmqdFMG-U', 46.9370607, 9.6787277, 'city', '1'),
('countries_switzerland_glarus_sool', 'ChIJa_6-IvkrhUcRtEvh8ViFL8A', 47.0004139, 9.0858542, 'city', '1'),
('countries_switzerland_grisons_grono', 'ChIJF3nQzGFPhEcR5J1CFruH9-E', 46.2477371, 9.1461813, 'city', '1'),
('countries_switzerland_glarus_schwandi', 'ChIJX5yb6AUohUcRNq6TY0dzAGE', 47.0055283, 9.06716, 'city', '0'),
('countries_switzerland_glarus_schwanden', 'ChIJK5JOYNsuhUcR29q7EL-4w8w', 46.9941626, 9.0739145, 'city', '0'),
('countries_switzerland_grisons_haldenstein', 'ChIJ17jK0zfGhEcRaG-ghm20WR0', 46.8786697, 9.5261007, 'city', '1'),
('countries_switzerland_grisons_igis', 'ChIJXRKtS93JhEcRKxUgXTF7wRs', 46.9508571, 9.5778776, 'city', '1'),
('countries_switzerland_grisons_ilanz', 'ChIJ1VOa7iLehEcRPQ43Uen2uGI', 46.77421, 9.20474, 'city', '1'),
('countries_switzerland_grisons_jenaz', 'ChIJcyzsQQixhEcRJaOHJNHPFCI', 46.928685, 9.7194467, 'city', '1'),
('countries_switzerland_grisons_jenins', 'ChIJL1aNjGLKhEcRSnibzRxc4Ms', 47.0005004, 9.5577461, 'city', '1'),
('countries_switzerland_glarus_ruti', 'ChIJS2KYD4y3mkcRYGQKXP1OeEo', 47.2566995, 8.854421, 'city', '0'),
('countries_switzerland_glarus_nafels', 'ChIJX-N2lLnSmkcRb766pAPtdaY', 47.0993576, 9.0677737, 'city', '1'),
('countries_switzerland_glarus_mitloedi', 'ChIJtQ8UkSYshUcRG1tmQtpcsyQ', 47.0106005, 9.0799644, 'city', '0'),
('countries_switzerland_grisons_laax', 'ChIJpdWEzjfchEcR5uhTig5n90M', 46.8091625, 9.2607783, 'city', '1'),
('countries_switzerland_grisons_lain', 'ChIJLSoBz-KUhEcRierbNSu9o8U', 46.698284, 9.53058, 'city', '1'),
('countries_switzerland_grisons_landquart', 'ChIJgR1LSt3JhEcREk-mpzC_5mY', 46.9681937, 9.5626299, 'city', '1'),
('countries_switzerland_grisons_langwies', 'ChIJxSEKzD-7hEcRnlmGfNfqW1k', 46.8205376, 9.7121025, 'city', '1'),
('countries_switzerland_grisons_latsch', 'ChIJf9c_SOWbhEcRLLVKQEJLidM', 46.633611, 9.751944, 'city', '1'),
('countries_switzerland_glarus_matt', 'ChIJCcrhpMIphUcRv6hg95u12mg', 46.9578717, 9.1715862, 'city', '0'),
('countries_switzerland_grisons_la_punt_chamues_ch', 'ChIJQXTC9atkg0cRTSW2BxHNehQ', 46.5789952, 9.925413, 'city', '1'),
('countries_switzerland_grisons_leggia', 'ChIJc1sIRLtFhEcRDL2uJ9UOFSc', 46.2629426, 9.1630854, 'city', '1'),
('countries_switzerland_glarus_luchsingen', 'ChIJ36P2qMAvhUcRfqgpEpRYLpY', 46.9672905, 9.036789, 'city', '0'),
('countries_switzerland_glarus_linthal', 'ChIJ_aepc6wkhUcRwSuczTTwbbc', 46.9218287, 8.9996438, 'city', '0'),
('countries_switzerland_glarus_braunwald', 'ChIJIQY_3wgwhUcRk0AKOOYgRGA', 46.9393043, 8.9981219, 'city', '0'),
('countries_switzerland_grisons_lohn', 'ChIJecWXsmDshEcRwUY2n9kZPAA', 46.6510793, 9.4271108, 'city', '1'),
('countries_switzerland_grisons_lostallo', 'ChIJ-5kzM7dahEcRn1vuZfUVjzE', 46.31233, 9.1956818, 'city', '1'),
('countries_switzerland_glarus_betschwanden', 'ChIJF_xbwo8vhUcRQNbeqVyXIgo', 46.9453009, 9.024266, 'city', '0'),
('countries_switzerland_geneva_vesenaz', 'ChIJB2SfQXxvjEcRqqCei3C8hlg', 46.23936, 6.19754, 'city', '0'),
('countries_switzerland_geneva_vandoeuvres', 'ChIJRyW7PpFvjEcRCfW8wrND6wE', 46.2213459, 6.202417, 'city', '1'),
('countries_switzerland_grisons_luven', 'ChIJJ-hGLZfghEcR0CQZQIj_AAQ', 46.7612113, 9.1988877, 'city', '1'),
('countries_switzerland_grisons_luzein', 'ChIJNxNmjPGxhEcRyN5grxK-lB0', 46.9280868, 9.7711121, 'city', '1'),
('countries_switzerland_grisons_madulain', 'ChIJE7p1FHljg0cRL7hG-mkIPO4', 46.5864909, 9.9384813, 'city', '1'),
('countries_switzerland_grisons_maienfeld', 'ChIJU7fkSfzKhEcROLzfgUWZdIo', 47.00571, 9.530813, 'city', '1'),
('countries_switzerland_grisons_maladers', 'ChIJPaV7u5W4hEcRp3fo8w6qMs4', 46.8350477, 9.5609123, 'city', '1'),
('countries_switzerland_grisons_malans', 'ChIJY4Vdt23KhEcRpzEY_4CjI5w', 46.9816699, 9.5758945, 'city', '1'),
('countries_switzerland_grisons_malix', 'ChIJEQue4Fe_hEcRIRyExO7_Zng', 46.8153289, 9.5318714, 'city', '1'),
('countries_switzerland_geneva_thonex', 'ChIJjb8U5eBvjEcR92s-m2j7vAc', 46.1928374, 6.202767, 'city', '1'),
('countries_switzerland_grisons_masein', 'ChIJh5Jx5rbrhEcRnEx6JeOyvWw', 46.7020829, 9.4265286, 'city', '1'),
('countries_switzerland_grisons_mastrils', 'ChIJO835fnHJhEcRFnyzgXdW0bQ', 46.96628, 9.54229, 'city', '1'),
('countries_switzerland_geneva_sezegnin', 'ChIJ59ivqO19jEcRu-5iGFUgecg', 46.1446225, 6.0077763, 'city', '0'),
('countries_switzerland_grisons_mesocco', 'ChIJKbaGycdXhEcR0TsZInhffTE', 46.3920008, 9.2327479, 'city', '1'),
('countries_switzerland_grisons_molinis', 'ChIJmzCE3cG7hEcRXEvMeCqNbMo', 46.8267755, 9.6553027, 'city', '1'),
('countries_switzerland_grisons_mon', 'ChIJV5I07MaThEcRpxcHJrZpomU', 46.633333, 9.5500001, 'city', '1'),
('countries_switzerland_grisons_morissen', 'ChIJcQ41--LghEcRpfoDed5Mino', 46.7299999, 9.1805299, 'city', '1'),
('countries_switzerland_geneva_pinchat', 'ChIJ_0G7uZZ6jEcRko5dJOF8L1Q', 46.1660489, 6.178397, 'city', '0'),
('countries_switzerland_geneva_petit_lancy', 'ChIJUxG-0Ul7jEcRTcyH1nLaT5g', 46.1923106, 6.1155847, 'city', '0'),
('countries_switzerland_grisons_nufenen', 'ChIJO984zQj6hEcRcAh8hf8ZXdM', 46.5394932, 9.2433569, 'city', '1'),
('countries_switzerland_geneva_perly_certoux', 'ChIJQ_K10IB7jEcRrFe6Eci0JhI', 46.1553483, 6.0945809, 'city', '0'),
('countries_switzerland_geneva_le_lignon', 'ChIJW6U-5lVjjEcRCRiL4EGedfQ', 46.2040741, 6.0959812, 'city', '0'),
('countries_switzerland_grisons_parpan', 'ChIJYbOWwra_hEcR2IfCiovmAFM', 46.7600325, 9.5577416, 'city', '1'),
('countries_switzerland_geneva_le_grand_saconnex', 'ChIJc0Rjd4dkjEcR396N5t6UTo0', 46.2331904, 6.1231633, 'city', '1'),
('countries_switzerland_geneva_les_avanchets', 'ChIJt5uyDplkjEcRUnn2EMgTdng', 46.221991, 6.108208, 'city', '0'),
('countries_switzerland_grisons_passugg', 'ChIJT-ib9qO4hEcReiI8jI3cu5w', 46.8306, 9.54638, 'city', '1'),
('countries_switzerland_grisons_peist', 'ChIJqcofZ7q7hEcRX-wuMbX_ntY', 46.8324494, 9.6722157, 'city', '1'),
('countries_switzerland_grisons_pontresina', 'ChIJ_8bI8QV5g0cRiXGf4duJgJc', 46.4929957, 9.9024964, 'city', '1'),
('countries_switzerland_grisons_poschiavo', 'ChIJ1QQwIJCeg0cRpt_rx3f0wL4', 46.3239301, 10.0573467, 'city', '1'),
('countries_switzerland_grisons_praden', 'ChIJzW3kG8W4hEcRjSydr6Gn1F4', 46.8243562, 9.5811466, 'city', '1'),
('countries_switzerland_geneva_les_acacias', 'ChIJd1_xKCh7jEcRRVQRn_MDBxs', 46.1900897, 6.1387569, 'city', '0'),
('countries_switzerland_geneva_la_plaine', 'ChIJjar-I4iHjEcR5IFRgk5l8Ms', 46.1775919, 6.000887, 'city', '0'),
('countries_switzerland_geneva_la_croix_de_rozon', 'ChIJ420Y2Eh6jEcRbG_VEkudWZ0', 46.1451351, 6.1363954, 'city', '0'),
('countries_switzerland_geneva_landecy', 'ChIJs_Isa0t6jEcR6Yhzvfdx0nE', 46.1444076, 6.1298295, 'city', '0'),
('countries_switzerland_geneva_grand_lancy', 'ChIJh4s-Tzl7jEcRONiaQQd7cS4', 46.1885168, 6.1144546, 'city', '0'),
('countries_switzerland_grisons_rabius', 'ChIJeYlOU7oZhUcRE6vgWUWmpeg', 46.7342377, 8.9588146, 'city', '1'),
('countries_switzerland_grisons_reams', 'ChIJz6buv5mRhEcRHUp0l_8d1PQ', 46.60927, 9.5817, 'city', '1'),
('countries_switzerland_grisons_riein', 'ChIJ5dCZdTjnhEcRig81APlY_5g', 46.7447291, 9.2330593, 'city', '1'),
('countries_switzerland_geneva_conches', 'ChIJcRWIWK96jEcRMrYRMKJyQFU', 46.186351, 6.1755179, 'city', '1'),
('countries_switzerland_grisons_rona', 'ChIJrXrzSEyFhEcRiqAge8-29CA', 46.5831572, 9.616736, 'city', '1'),
('countries_switzerland_grisons_rossa', 'ChIJz8HpELpWhEcR-DZEE9wur_Q', 46.3726884, 9.1257621, 'city', '1'),
('countries_switzerland_grisons_rothenbrunnen', 'ChIJ9d5inNPDhEcRaJnrfMD9VBc', 46.7682466, 9.4272835, 'city', '1'),
('countries_switzerland_grisons_roveredo', 'ChIJca1g1PlFhEcROZ2FJ79nR0o', 46.2343502, 9.1288093, 'city', '1'),
('countries_switzerland_grisons_rueras', 'ChIJ07YCYOUShUcRLQ31QOcDXns', 46.6749772, 8.7502117, 'city', '1'),
('countries_switzerland_grisons_rueun', 'ChIJ3Rbl3OXfhEcR33QDLZZDuTo', 46.7788792, 9.1502667, 'city', '1'),
('countries_switzerland_grisons_ruschein', 'ChIJY-8XzQXfhEcRUgxQsn5Jp_g', 46.78567, 9.19226, 'city', '1'),
('countries_switzerland_geneva_collex', 'ChIJK1oEu6hmjEcR2Hd8X9daJKM', 46.2715983, 6.125981, 'city', '1'),
('countries_switzerland_grisons_sagogn', 'ChIJw2mj78jdhEcRptYVhdBstz8', 46.7923608, 9.25738, 'city', '1'),
('countries_switzerland_geneva_cointrin', 'ChIJN5MjroBkjEcRMKa4TvKpEeU', 46.2369794, 6.1090888, 'city', '0'),
('countries_switzerland_grisons_samedan', 'ChIJRzKtGBx9g0cRroWqdqR-U_I', 46.5339944, 9.8729339, 'city', '1'),
('countries_switzerland_grisons_samnaun', 'ChIJixacVH01g0cRlaafV4fvyhI', 46.9497817, 10.3686809, 'city', '1'),
('countries_switzerland_grisons_sankt_peter', 'ChIJYfulodu7hEcR4HWNoWGfsSM', 46.83306, 9.64668, 'city', '1'),
('countries_switzerland_grisons_santa_maria_in_calanca', 'ChIJNziluHZPhEcRzPQHzT51Px4', 46.2632451, 9.1438447, 'city', '1'),
('countries_switzerland_geneva_chene_bourg', 'ChIJFW7Tf-RvjEcR23NXiu9RlPA', 46.19735, 6.19731, 'city', '1'),
('countries_switzerland_geneva_chene_bougeries', 'ChIJ7WIAGR5wjEcR5cH94ACogiI', 46.1983939, 6.1851258, 'city', '1'),
('countries_switzerland_grisons_san_vittore', 'ChIJj5DB1ihPhEcRDfjZ64MMANk', 46.2382814, 9.1081578, 'city', '1'),
('countries_switzerland_geneva_chatelaine', 'ChIJx4PGJrtkjEcRbUdE3c5nbrk', 46.2116722, 6.1099342, 'city', '0'),
('countries_switzerland_geneva_chambesy', 'ChIJNZiWr6pljEcRcHUZQIj_AAQ', 46.2420331, 6.1435559, 'city', '1'),
('countries_switzerland_geneva_certoux', 'ChIJQ_K10IB7jEcRrFe6Eci0JhI', 46.1553483, 6.0945809, 'city', '0'),
('countries_switzerland_grisons_scharans', 'ChIJHSwWofDqhEcR0TstFQAnrsI', 46.7169311, 9.4595783, 'city', '1'),
('countries_switzerland_grisons_schiers', 'ChIJlZhfnVOyhEcR7-By6u2GRGU', 46.9696936, 9.6884858, 'city', '1'),
('countries_switzerland_geneva_celigny', 'ChIJFzua2PdnjEcR3ra6yW9jlNE', 46.3504128, 6.1952524, 'city', '1'),
('countries_switzerland_grisons_schmitten', 'ChIJXdSf9YKXhEcRuYrXJPWv9_s', 46.6879611, 9.6733109, 'city', '1'),
('countries_switzerland_grisons_scuol', 'ChIJAXPFR5pHg0cRWZHnSaTdLlM', 46.7968716, 10.2977381, 'city', '1'),
('countries_switzerland_grisons_sedrun', 'ChIJU9rNU1IShUcR_dPX8ykFsyE', 46.6799595, 8.7745548, 'city', '1'),
('countries_switzerland_geneva_anieres', 'ChIJN0FKbbhojEcRIeedt6ct8hk', 46.2777904, 6.2240679, 'city', '1'),
('countries_switzerland_geneva_aire', 'ChIJVcEzBVR7jEcRG_UJkb9vHnU', 46.1976836, 6.0977723, 'city', '1'),
('countries_switzerland_fribourg_zenauva', 'ChIJ47IziLZnjkcRPZDej-ZobwA', 46.733333, 7.183334, 'city', '1'),
('countries_switzerland_grisons_sent', 'ChIJOb-aLRo4g0cRs1MHNxUs8bA', 46.8168332, 10.3377292, 'city', '1'),
('countries_switzerland_grisons_siat', 'ChIJt55hvL_fhEcRiFDYumFFbUo', 46.7911095, 9.1632467, 'city', '1'),
('countries_switzerland_grisons_sils_im_domleschg', 'ChIJL4ePGTzrhEcRTFkoNaS6H2M', 46.7019286, 9.4555982, 'city', '1'),
('countries_switzerland_fribourg_wunnewil', 'ChIJH2WkcFpAjkcRZvpdvv3nL9Q', 46.8746919, 7.2757147, 'city', '0'),
('countries_switzerland_grisons_silvaplana', 'ChIJLQ57RcGBhEcRbEqVfKmKGj0', 46.4599864, 9.7955009, 'city', '1'),
('countries_switzerland_grisons_soazza', 'ChIJka8KDzdahEcRJv8KYjOja9w', 46.3649349, 9.2243119, 'city', '1'),
('countries_switzerland_fribourg_wallenbuch', 'ChIJ-azSR-AUjkcRbTnes6I8_2k', 46.929725, 7.224722, 'city', '1'),
('countries_switzerland_fribourg_vuissens', 'ChIJqbb9ntHWjUcRYOwYQIj_AAQ', 46.7370399, 6.764964, 'city', '0'),
('countries_switzerland_fribourg_villars_sur_glane', 'ChIJz855fjJkjkcRS2g0zNTRCug', 46.7931801, 7.1237822, 'city', '1'),
('countries_switzerland_fribourg_villarsel_le_gibloux', 'ChIJd1inoTt7jkcRU_e9XEIdmoA', 46.71437, 7.01704, 'city', '0'),
('countries_switzerland_fribourg_villarimboud', 'ChIJX4V_oTB6jkcRqhV4zasl90E', 46.7394735, 6.9624772, 'city', '0'),
('countries_switzerland_fribourg_torny_le_grand', 'ChIJ99fJvadwjkcRAHNFVycOoq4', 46.7707453, 6.965778, 'city', '0');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_switzerland_grisons_surcasti', 'ChIJ-4E0GGfhhEcRZ2YbaDFB9vc', 46.69629, 9.176826, 'city', '1'),
('countries_switzerland_grisons_surcuolm', 'ChIJSYbxXBLghEcRr0RnpOfhvnw', 46.7583935, 9.1436613, 'city', '1'),
('countries_switzerland_fribourg_tatroz', 'ChIJufaVcsGDjkcRvfvMILapsgs', 46.5262301, 6.8680862, 'city', '0'),
('countries_switzerland_grisons_tamins', 'ChIJK_WyEvnEhEcRWf_vgp_YdJw', 46.8280926, 9.4063148, 'city', '1'),
('countries_switzerland_grisons_tarasp', 'ChIJ_ehBe95Ag0cRcCCIwfCKmXI', 46.7758856, 10.2584949, 'city', '1'),
('countries_switzerland_fribourg_sugiez', 'ChIJbSTu9GMSjkcRKytFKz8a3mc', 46.96186, 7.11292, 'city', '0'),
('countries_switzerland_grisons_tenna', 'ChIJD0GrrQXohEcRpzpzCbWuYY0', 46.7465998, 9.3386146, 'city', '1'),
('countries_switzerland_fribourg_st_silvester', 'ChIJGaFh0vNnjkcR4MMmSqOPdx0', 46.7404313, 7.220526, 'city', '1'),
('countries_switzerland_grisons_thusis', 'ChIJY6qnjKXrhEcRvHI_riDLdzs', 46.6960141, 9.439494, 'city', '1'),
('countries_switzerland_fribourg_st_martin_fr', 'ChIJlXpwGOGAjkcRhO6Ll7rptIY', 46.5767192, 6.8688219, 'city', '0'),
('countries_switzerland_grisons_tinzen', 'ChIJO_EcACWQhEcR1PoZ27BWA6w', 46.5831951, 9.6167789, 'city', '1'),
('countries_switzerland_fribourg_st_antoni', 'ChIJn3hPJihCjkcRyr547vOYS-Y', 46.8220782, 7.2612084, 'city', '1'),
('countries_switzerland_grisons_trimmis', 'ChIJjZPZR_m3hEcRTf8L1BdMZps', 46.9009, 9.56155, 'city', '1'),
('countries_switzerland_grisons_trin', 'ChIJn4nsjzTbhEcR9ojL5d5TV04', 46.8283045, 9.3624372, 'city', '1'),
('countries_switzerland_grisons_trun', 'ChIJ57UTl7EZhUcRnXde9J2xvKg', 46.7431522, 8.991023, 'city', '1'),
('countries_switzerland_grisons_tschappina', 'ChIJMxKXglvphEcR1Y1skVL1fQE', 46.6862386, 9.383685, 'city', '1'),
('countries_switzerland_grisons_tschiertschen', 'ChIJA-LQVza5hEcRrU7z3dZtSvI', 46.81777, 9.60671, 'city', '1'),
('countries_switzerland_grisons_untervaz', 'ChIJF7RU3_PIhEcRpMiGWB7oUfM', 46.9275438, 9.5351588, 'city', '1'),
('countries_switzerland_grisons_urmein', 'ChIJO3_2oVnphEcR5_BCFxhckEE', 46.6915129, 9.401246, 'city', '1'),
('countries_switzerland_grisons_valbella', 'ChIJBx8kOcy_hEcRF8U5BE3owEA', 46.749885, 9.555946, 'city', '1'),
('countries_switzerland_fribourg_sevaz', 'ChIJCfDPpKbYjUcRa5otmPtFLgY', 46.8381596, 6.8756059, 'city', '1'),
('countries_switzerland_grisons_valendas', 'ChIJ26iscHTdhEcR59knrQjI_GU', 46.7880731, 9.282727, 'city', '1'),
('countries_switzerland_fribourg_seiry', 'ChIJJ-abLlTYjUcRBPktlnuO-z4', 46.8130159, 6.8307614, 'city', '0'),
('countries_switzerland_grisons_valzeina', 'ChIJ85gakWy2hEcRY8GKRvGRenY', 46.9497033, 9.6029117, 'city', '1'),
('countries_switzerland_grisons_verdabbio', 'ChIJrTY8VvdEhEcRoDGV4jfRPmQ', 46.2681611, 9.1566234, 'city', '1'),
('countries_switzerland_grisons_versam', 'ChIJ88DXUdXchEcRTvDv4MkG_xo', 46.7919488, 9.3378412, 'city', '1'),
('countries_switzerland_fribourg_schwarzsee', 'ChIJlYHIdaRejkcRCi_aY4az3Ls', 46.6659091, 7.2807275, 'city', '0'),
('countries_switzerland_fribourg_sankt_ursen', 'ChIJ3QdjbS1ojkcRIAQmZyXfSAI', 46.7900124, 7.2181088, 'city', '1'),
('countries_switzerland_fribourg_salvenach', 'ChIJZZ5iWDUTjkcRIDYZQIj_AAQ', 46.9112996, 7.1512083, 'city', '0'),
('countries_switzerland_fribourg_sales', 'ChIJPyo4Tm19jkcRN4vuruspQ6s', 46.63538, 6.97461, 'city', '1'),
('countries_switzerland_fribourg_rueyres_st_laurent', 'ChIJIQu7rDJ7jkcRdJZ9QBjrVJw', 46.71567, 7.03303, 'city', '0'),
('countries_switzerland_fribourg_rueyres_les_pres', 'ChIJc2F3CtB1jkcR_wRc4Ru4Vvc', 46.8597435, 6.9165522, 'city', '0'),
('countries_switzerland_grisons_zernez', 'ChIJ12n9lyNog0cRXykHVmJ9g20', 46.7004905, 10.0949083, 'city', '1'),
('countries_switzerland_fribourg_rose', 'ChIJ7wWGnRprkEcR399DPKKhmek', 47.4904133, 8.2553457, 'city', '0'),
('countries_switzerland_grisons_zizers', 'ChIJ0fOr89DJhEcRjrP0kill4Iw', 46.93653, 9.56552, 'city', '1'),
('countries_switzerland_grisons_zuoz', 'ChIJ_cszmMlkg0cRtV4mmOsdLaw', 46.6029209, 9.9599933, 'city', '1'),
('countries_switzerland_jura_alle', 'ChIJ3TeKACfxkUcRorOFfr4G-b0', 47.4260575, 7.1278409, 'city', '1'),
('countries_switzerland_jura_asuel', 'ChIJj4RIBOHvkUcRnIFO1LcWowY', 47.4021808, 7.2107314, 'city', '1'),
('countries_switzerland_jura_bassecourt', 'ChIJeWXlRFTkkUcRh_kDAjCafP8', 47.3389072, 7.2427009, 'city', '1'),
('countries_switzerland_fribourg_ried', 'ChIJH01kTH8UjkcRLcdR8Ekulr4', 46.9557914, 7.1856344, 'city', '1'),
('countries_switzerland_jura_boncourt', 'ChIJkctuRRcekkcRY-ThL6W4R60', 47.4960637, 7.0157468, 'city', '1'),
('countries_switzerland_jura_bonfol', 'ChIJZWnLA8PzkUcRHwoepS8hiUI', 47.4770783, 7.1515189, 'city', '1'),
('countries_switzerland_jura_bourrignon', 'ChIJP_80_HLvkUcRifzoYcFcGe0', 47.3967887, 7.244786, 'city', '1'),
('countries_switzerland_jura_bressaucourt', 'ChIJudNUSz74kUcRiK7JAB5S87k', 47.3875532, 7.0366039, 'city', '1'),
('countries_switzerland_jura_bure', 'ChIJ7TF5zKMdkkcRD8KKsF7D01M', 47.44242, 7.00681, 'city', '1'),
('countries_switzerland_jura_charmoille', 'ChIJyYBvkyjukUcRzIz9K4zauP8', 47.4230647, 7.2039915, 'city', '1'),
('countries_switzerland_fribourg_pringy', 'ChIJnfU98ZaJjkcRAk52LgM0OoY', 46.581038, 7.0723943, 'city', '0'),
('countries_switzerland_jura_chevenez', 'ChIJ4VM4rLICkkcRM4MOK-Nwxdo', 47.3915866, 6.9988494, 'city', '1'),
('countries_switzerland_jura_coeuve', 'ChIJg4gh1pX2kUcREIIZQIj_AAQ', 47.4524094, 7.0998247, 'city', '1'),
('countries_switzerland_jura_corban', 'ChIJDzLj-6fckUcRs2CLpBpe_YY', 47.3463044, 7.4762419, 'city', '1'),
('countries_switzerland_jura_cornol', 'ChIJLTQaPV7wkUcRQoZhWqIg9UE', 47.4070106, 7.1617073, 'city', '1'),
('countries_switzerland_fribourg_prez_vers_noreaz', 'ChIJjz_lhl1wjkcRO4Adr7W68XM', 46.7851897, 7.0135143, 'city', '1'),
('countries_switzerland_jura_courchapoix', 'ChIJ2b8Sc7_ckUcR79KwJmLbrKU', 47.3487188, 7.4558423, 'city', '1'),
('countries_switzerland_jura_courchavon', 'ChIJY9vwJEr2kUcR0Hwgk7UMqC4', 47.441062, 7.055765, 'city', '1'),
('countries_switzerland_jura_courfaivre', 'ChIJ8UTHgynkkUcRGQwwTYpF4No', 47.3343724, 7.2850322, 'city', '1'),
('countries_switzerland_jura_courgenay', 'ChIJD0uUm8DwkUcRdOFO9EtL4Rg', 47.4031793, 7.1268158, 'city', '1'),
('countries_switzerland_jura_courrendlin', 'ChIJy8NOIoHnkUcRBAyDuhsqbj8', 47.3393271, 7.3734637, 'city', '1'),
('countries_switzerland_jura_courroux', 'ChIJKYeQLSzdkUcRkKqOk-BkB8M', 47.3618071, 7.3745285, 'city', '1'),
('countries_switzerland_jura_courtedoux', 'ChIJ54AxEpT3kUcRcn2HhD75WbU', 47.4091952, 7.0421663, 'city', '1'),
('countries_switzerland_fribourg_praz', 'ChIJ09b_0PzphEcR416YjxdulUg', 46.7427, 9.4052, 'city', '1'),
('countries_switzerland_fribourg_portalban', 'ChIJJy8vvNJ0jkcRDC4A64cF8aI', 46.917889, 6.9560023, 'city', '1'),
('countries_switzerland_jura_damvant', 'ChIJ_8pLRJEEkkcRbOQLkhmMWJ8', 47.37246, 6.89688, 'city', '1'),
('countries_switzerland_jura_delemont', 'ChIJ1XrBwybmkUcRXbjjLhn1hcE', 47.365837, 7.3451555, 'city', '1'),
('countries_switzerland_jura_develier', 'ChIJSaVP_OTlkUcR6hyaqtb4UJo', 47.3581278, 7.2962254, 'city', '1'),
('countries_switzerland_jura_epauvillers', 'ChIJY7eRFcj7kUcRF6LCFAjLHFA', 47.3348637, 7.1151173, 'city', '1'),
('countries_switzerland_jura_epiquerez', 'ChIJy0n49xT5kUcRwxTJT0pkdHc', 47.3285871, 7.0564205, 'city', '1'),
('countries_switzerland_jura_fahy', 'ChIJFdi9tJQckkcRcdOq6yKTRoo', 47.4180013, 6.9502286, 'city', '1'),
('countries_switzerland_jura_fontenais', 'ChIJs_zdmG_3kUcRhCmqh7zI8BY', 47.4022014, 7.0803088, 'city', '1'),
('countries_switzerland_jura_glovelier', 'ChIJLYMpBirlkUcR8Cu0oEb7800', 47.3345052, 7.2047156, 'city', '1'),
('countries_switzerland_jura_grandfontaine', 'ChIJiy-lA1ADkkcRcDn6M0zDXXA', 47.3906667, 6.9387278, 'city', '1'),
('countries_switzerland_jura_lajoux', 'ChIJ6ckWu-j8kUcRmNleR62KI60', 47.278876, 7.1380556, 'city', '1'),
('countries_switzerland_jura_les_bois', 'ChIJf7su1Yj-jUcRZzo-fWHF9t4', 47.1774878, 6.9052937, 'city', '1'),
('countries_switzerland_jura_les_breuleux', 'ChIJiTXPClwAjkcRyFLhnN0Lkgk', 47.2122224, 7.0040336, 'city', '1'),
('countries_switzerland_jura_les_enfers', 'ChIJZ6g0A-b-kUcRMNTjat0TEcI', 47.2886168, 7.0480782, 'city', '1'),
('countries_switzerland_jura_les_genevez', 'ChIJCdCNaA_9kUcR700hUHCBx3w', 47.256641, 7.1297166, 'city', '1'),
('countries_switzerland_jura_les_pommerats', 'ChIJ3Y1uNYf_kUcRSX4RHgKrQI4', 47.2715231, 6.9853144, 'city', '1'),
('countries_switzerland_fribourg_pensier', 'ChIJ_QXouRhsjkcRWvYMenRNRFs', 46.842896, 7.1373751, 'city', '0'),
('countries_switzerland_jura_le_noirmont', 'ChIJ5bAdnMf_jUcR-fJ8OswhNGM', 47.2256223, 6.9572116, 'city', '1'),
('countries_switzerland_jura_lugnez', 'ChIJvWT0DTj0kUcR0IIZQIj_AAQ', 47.4843773, 7.098556, 'city', '1'),
('countries_switzerland_jura_mervelier', 'ChIJ8xLMWz7bkUcRTQ2mWc_Jem0', 47.3437446, 7.5000358, 'city', '1'),
('countries_switzerland_jura_mettembert', 'ChIJcW4fa-nokUcRuqo2Z7VjzYk', 47.3979703, 7.3226055, 'city', '1'),
('countries_switzerland_fribourg_noreaz', 'ChIJOzQmVTNwjkcRsPMYQIj_AAQ', 46.8036084, 7.026921, 'city', '1'),
('countries_switzerland_fribourg_motier', 'ChIJE-RJEI_BjUcREHMZQIj_AAQ', 46.9111044, 6.6113106, 'city', '0'),
('countries_switzerland_jura_montfaucon', 'ChIJL1Hh0F_-kUcRyzg9XJ3JY7Q', 47.2816984, 7.0510901, 'city', '1'),
('countries_switzerland_jura_montignez', 'ChIJI248i7_1kUcRAJ0q2o_xejc', 47.4872574, 7.0589961, 'city', '1'),
('countries_switzerland_jura_montmelon', 'ChIJTQThucX6kUcRtQzh5noddWc', 47.3546586, 7.1819354, 'city', '1'),
('countries_switzerland_jura_montsevelier', 'ChIJZYtu2MrEkUcRqIElWRAMH9M', 47.3608005, 7.5080797, 'city', '1'),
('countries_switzerland_jura_movelier', 'ChIJ06JEXtfokUcRCoDWM2UDgIc', 47.4091934, 7.3172083, 'city', '1'),
('countries_switzerland_jura_muriaux', 'ChIJkU43PR0AjkcRBAAXb_ROF_4', 47.2459518, 6.9781347, 'city', '1'),
('countries_switzerland_jura_pleigne', 'ChIJ8eVdjS_vkUcRO28Iidn3PbU', 47.4072829, 7.2898015, 'city', '1'),
('countries_switzerland_jura_pleujouse', 'ChIJB36rnNDvkUcRqMEx7rfQ30w', 47.4112455, 7.2074577, 'city', '1'),
('countries_switzerland_jura_porrentruy', 'ChIJk0wQNgT3kUcR4q-miSkRnyA', 47.416647, 7.0765657, 'city', '1'),
('countries_switzerland_jura_rebeuvelier', 'ChIJATcJuqjdkUcRWjgA0NsnEZQ', 47.3245762, 7.4152297, 'city', '1'),
('countries_switzerland_jura_rocourt', 'ChIJcVKf2CgDkkcRogEJ_2CgyRc', 47.3904377, 6.957167, 'city', '1'),
('countries_switzerland_jura_rossemaison', 'ChIJU_fFfbDnkUcR0IYZQIj_AAQ', 47.3463644, 7.3428683, 'city', '1'),
('countries_switzerland_fribourg_morens', 'ChIJdViuC3F2jkcRlxn0icy9v5M', 46.8436085, 6.9065226, 'city', '0'),
('countries_switzerland_jura_saint_brais', 'ChIJ3UR5V4r7kUcRUIEZQIj_AAQ', 47.3054088, 7.1126063, 'city', '1'),
('countries_switzerland_jura_saint_ursanne', 'ChIJcU-F2F36kUcRjBiJKH2bq-U', 47.3642815, 7.1542802, 'city', '1'),
('countries_switzerland_jura_saulcy', 'ChIJcVI17qD8kUcRnmZwfAwaBtY', 47.3019644, 7.1538537, 'city', '1'),
('countries_switzerland_jura_soubey', 'ChIJL1yfktL-kUcRx46nNbbnOZs', 47.3085725, 7.0482648, 'city', '1'),
('countries_switzerland_jura_soulce', 'ChIJTwSa3QvkkUcRQeoHxkRXNf4', 47.3036769, 7.2699252, 'city', '1'),
('countries_switzerland_fribourg_morat', 'ChIJkUAFOPwSjkcRac00us6ORZk', 46.9292211, 7.120184, 'city', '1'),
('countries_switzerland_jura_undervelier', 'ChIJa9It8oHkkUcRrS_Y15foMpA', 47.3032006, 7.2245072, 'city', '1'),
('countries_switzerland_jura_vendlincourt', 'ChIJBQnesELxkUcRWmvxYmUh82Y', 47.4511089, 7.1472475, 'city', '1'),
('countries_switzerland_jura_vermes', 'ChIJd1athX7bkUcRY1LTKYvB8vc', 47.3290048, 7.4751167, 'city', '1'),
('countries_switzerland_jura_vicques', 'ChIJC6DY39rckUcR5w3tF24D0iA', 47.3485514, 7.4110656, 'city', '1'),
('countries_switzerland_lucerne_adligenswil', 'ChIJN5tAOq7-j0cREl01_ImPP6k', 47.071186, 8.3647405, 'city', '1'),
('countries_switzerland_lucerne_aesch', 'ChIJOYZhE7gbkEcR8AUZQIj_AAQ', 47.2559244, 8.2411615, 'city', '1'),
('countries_switzerland_lucerne_alberswil', 'ChIJ6WCgq8zYj0cRMAoZQIj_AAQ', 47.1510987, 8.0020094, 'city', '1'),
('countries_switzerland_fribourg_montet_glane', 'ChIJsRsznUHVjUcR-Nq7XpcBeYU', 46.6437072, 6.8153915, 'city', '0'),
('countries_switzerland_lucerne_altishofen', 'ChIJaf2yhggnkEcRGXXgO_CmvEQ', 47.2022847, 7.9669609, 'city', '1'),
('countries_switzerland_lucerne_altwis', 'ChIJRwuBMoUbkEcRYKhQqyQvKe0', 47.2381254, 8.2514874, 'city', '1'),
('countries_switzerland_lucerne_ballwil', 'ChIJq30uN3wCkEcR4ImOdG58YoE', 47.1528227, 8.3172322, 'city', '1'),
('countries_switzerland_lucerne_buchrain', 'ChIJb3K3mDL8j0cRpnUJ3JYv1VI', 47.0963829, 8.3477709, 'city', '1'),
('countries_switzerland_lucerne_buchs', 'ChIJA1xSAN4gkEcRkBVpLRSQsnQ', 47.201945, 8.033343, 'city', '1'),
('countries_switzerland_fribourg_montagny_la_ville', 'ChIJNbZs0BBxjkcRX9XWdvgeq_4', 46.8174635, 6.9951169, 'city', '0'),
('countries_switzerland_lucerne_buttisholz', 'ChIJe3Axp5rgj0cRmnzTbej8I0c', 47.1144651, 8.0943572, 'city', '1'),
('countries_switzerland_lucerne_dagmersellen', 'ChIJ_TgbFucmkEcRp3uVgsGCohE', 47.2128386, 7.9893353, 'city', '1'),
('countries_switzerland_fribourg_moleson', 'ChIJF6yk6MCIjkcRZwdss9R0BF0', 46.5487879, 7.0171018, 'city', '0'),
('countries_switzerland_lucerne_dierikon', 'ChIJeUaPg5z-j0cRIL4kAhGrE1M', 47.0972269, 8.3668411, 'city', '1'),
('countries_switzerland_lucerne_doppleschwand', 'ChIJDVxN0FXdj0cRYAUZQIj_AAQ', 47.0186765, 8.0556121, 'city', '1'),
('countries_switzerland_lucerne_ebersecken', 'ChIJB2QNzYgnkEcRgAoZQIj_AAQ', 47.1831943, 7.9314653, 'city', '1'),
('countries_switzerland_lucerne_ebikon', 'ChIJY9_vYGz8j0cRwa_7h9F2lgI', 47.0813181, 8.3407402, 'city', '1'),
('countries_switzerland_fribourg_misery', 'ChIJSS540uxtjkcR9zDeXa9dP74', 46.8641022, 7.0848245, 'city', '1'),
('countries_switzerland_lucerne_egolzwil', 'ChIJM0j2qU4nkEcR5pgMW8sZFDU', 47.1847143, 8.0071833, 'city', '1'),
('countries_switzerland_lucerne_eich', 'ChIJkcDcLuHhj0cRsAgZQIj_AAQ', 47.1534138, 8.1666942, 'city', '1'),
('countries_switzerland_fribourg_mezieres', 'ChIJX-ncy6krjEcRYEOI565b9zA', 46.5955273, 6.7702883, 'city', '1'),
('countries_switzerland_lucerne_emmen', 'ChIJF9Y9qb78j0cRUSXaxMLXcDU', 47.0772338, 8.275637, 'city', '1'),
('countries_switzerland_fribourg_menieres', 'ChIJ2TbJye13jkcRFQ6Cnl8kGpU', 46.78349, 6.8806092, 'city', '1'),
('countries_switzerland_lucerne_entlebuch', 'ChIJnbwTPd7oj0cRWYnpoYI2rQg', 46.9917412, 8.0647494, 'city', '1'),
('countries_switzerland_lucerne_ermensee', 'ChIJ_0fsJfQbkEcRza26-WMPVXI', 47.2275544, 8.2413701, 'city', '1'),
('countries_switzerland_lucerne_eschenbach', 'ChIJ0xTbrhL9j0cRIHnlg4FyOeo', 47.1327643, 8.319947, 'city', '1'),
('countries_switzerland_lucerne_escholzmatt', 'ChIJ86Wp4C3Bj0cRNzEoac_bXYw', 46.9145256, 7.9349386, 'city', '1'),
('countries_switzerland_lucerne_ettiswil', 'ChIJRwkh_3Lfj0cRD3cgYUZPoDM', 47.1501373, 8.0191817, 'city', '1'),
('countries_switzerland_lucerne_finsterwald', 'ChIJL5MVSOToj0cRAAsj_qfzsiE', 46.9727794, 8.1044535, 'city', '1'),
('countries_switzerland_lucerne_fischbach', 'ChIJW_DN7yPYj0cR6QoDL-NuYNQ', 47.1575788, 7.9070421, 'city', '1'),
('countries_switzerland_fribourg_mannens', 'ChIJX6V00MhwjkcRfNGDRXP8CSU', 46.7937846, 6.9689322, 'city', '1'),
('countries_switzerland_lucerne_geiss', 'ChIJeze-Ygnej0cRbiWwda4WXkQ', 47.090548, 8.055841, 'city', '1'),
('countries_switzerland_lucerne_gelfingen', 'ChIJVew3MJEckEcR1R0u6CKVBhI', 47.2148578, 8.265497, 'city', '1'),
('countries_switzerland_lucerne_gettnau', 'ChIJF0DlkN3Yj0cRwGM8DjVUogM', 47.1413003, 7.9725332, 'city', '1'),
('countries_switzerland_lucerne_geuensee', 'ChIJicB-4ikgkEcR5F2b9Qe9XQU', 47.1984194, 8.1084178, 'city', '1'),
('countries_switzerland_lucerne_gisikon', 'ChIJD82g6Dr-j0cRtkrkZXbi_PU', 47.1276261, 8.4012374, 'city', '1'),
('countries_switzerland_lucerne_greppen', 'ChIJn7IsCbH4j0cRHuwU0u8A1G4', 47.0539198, 8.430628, 'city', '1'),
('countries_switzerland_lucerne_grossdietwil', 'ChIJJeZ8iebXj0cRqGuorfY-gPs', 47.1714237, 7.8856797, 'city', '1'),
('countries_switzerland_lucerne_grosswangen', 'ChIJY899i6Tfj0cRtu71CV-L4m0', 47.1338759, 8.0477719, 'city', '1'),
('countries_switzerland_lucerne_gunzwil', 'ChIJB-y3J-0ekEcRGGgVlvtbF4w', 47.2115842, 8.17818, 'city', '1'),
('countries_switzerland_fribourg_magnedens', 'ChIJ3dTKcAtljkcRQ7IULCtZx1M', 46.74275, 7.08127, 'city', '0'),
('countries_switzerland_lucerne_hasle', 'ChIJe3p_pnTpj0cRttGiXN9Ruks', 46.9800466, 8.0538414, 'city', '1'),
('countries_switzerland_lucerne_hergiswil', 'ChIJU9tghXvwj0cR4cbCFwbJPLg', 46.9905821, 8.3083735, 'city', '1'),
('countries_switzerland_fribourg_le_paquier_montbarry', 'ChIJDztmgc6JjkcRHNkFNG4JE6c', 46.5936084, 7.0554305, 'city', '0'),
('countries_switzerland_lucerne_hildisrieden', 'ChIJlcQLf3zij0cR8AgZQIj_AAQ', 47.1507878, 8.2284761, 'city', '1'),
('countries_switzerland_lucerne_hitzkirch', 'ChIJmw07yoockEcReHpb4Gc6Y98', 47.2249542, 8.2632896, 'city', '1'),
('countries_switzerland_lucerne_hochdorf', 'ChIJbSYU3EodkEcRlnjFOF8WvJ0', 47.1665813, 8.2920671, 'city', '1'),
('countries_switzerland_fribourg_le_laquier', 'ChIJDztmgc6JjkcRHNkFNG4JE6c', 46.5936084, 7.0554305, 'city', '1'),
('countries_switzerland_lucerne_hohenrain', 'ChIJ6bNn4CYDkEcRI3C1gHGBqzk', 47.18086, 8.3177, 'city', '1'),
('countries_switzerland_lucerne_honau', 'ChIJWQBBmCT-j0cRL6o613wCcN4', 47.1306454, 8.4063308, 'city', '1'),
('countries_switzerland_lucerne_horw', 'ChIJ26-sJyr6j0cR7ZCl19JLO_s', 47.0184461, 8.3079399, 'city', '1'),
('countries_switzerland_lucerne_inwil', 'ChIJjQw84eD9j0cRIcgd0rJ9630', 47.1223061, 8.3506794, 'city', '1'),
('countries_switzerland_lucerne_kastanienbaum', 'ChIJzxTcKPX5j0cRurLJ-AcLuDY', 47.007778, 8.339722, 'city', '1'),
('countries_switzerland_lucerne_knutwil', 'ChIJYTgeMkwgkEcRSKpADtdk-xY', 47.1995882, 8.0718749, 'city', '1'),
('countries_switzerland_lucerne_kottwil', 'ChIJjTHqTX_fj0cR_kcPJDBeU0o', 47.161944, 8.045282, 'city', '1'),
('countries_switzerland_lucerne_kriens', 'ChIJqxs_GMf6j0cRFfAW9ZiOBb8', 47.0341978, 8.2772552, 'city', '1'),
('countries_switzerland_fribourg_le_cret_pres_semsales', 'ChIJPYNi_v99jkcR9iUoPJPjcPo', 46.616668, 6.916662, 'city', '0'),
('countries_switzerland_lucerne_lieli', 'ChIJ--C-ATMDkEcR1WLoNU-leZw', 47.2, 8.3, 'city', '1'),
('countries_switzerland_fribourg_le_chatelard_pres_romont', 'ChIJY6wJtYl8jkcRZ8G9Irdzdb0', 46.6774396, 6.9779856, 'city', '0'),
('countries_switzerland_lucerne_lucerne', 'ChIJeXNUeSr6j0cRr1KZQNEq8K4', 47.0501682, 8.3093072, 'city', '1'),
('countries_switzerland_lucerne_luthern', 'ChIJ6TcVaPfaj0cRWovMoRw64F0', 47.0591501, 7.9159924, 'city', '1'),
('countries_switzerland_lucerne_malters', 'ChIJm7gb6kXkj0cRgseYvtd0FY4', 47.0369701, 8.1838992, 'city', '1'),
('countries_switzerland_lucerne_marbach', 'ChIJvXVSj6W4j0cRXVxECEJlllI', 46.854006, 7.8999603, 'city', '1'),
('countries_switzerland_lucerne_mauensee', 'ChIJOcSEynEgkEcRIAkZQIj_AAQ', 47.1667405, 8.071189, 'city', '1'),
('countries_switzerland_lucerne_meggen', 'ChIJYzQgQkf5j0cRsGfQt3XvAug', 47.0458287, 8.3724158, 'city', '1'),
('countries_switzerland_lucerne_meierskappel', 'ChIJVfzHZo3_j0cR_DGWM4WVc1E', 47.1244436, 8.4432688, 'city', '1'),
('countries_switzerland_lucerne_menzberg', 'ChIJ8cAurO_cj0cRLQ50wmtuvpw', 47.040556, 7.997222, 'city', '1'),
('countries_switzerland_lucerne_menznau', 'ChIJMa99vt7dj0cR6A49ee9S3UY', 47.0831969, 8.0388779, 'city', '1'),
('countries_switzerland_lucerne_mosen', 'ChIJ7f9se-8bkEcRCXyVOX72UUs', 47.2442209, 8.2266274, 'city', '1'),
('countries_switzerland_fribourg_le_bry', 'ChIJfVVY9V1kjkcRMx24Q5257h8', 46.7032, 7.08349, 'city', '0'),
('countries_switzerland_lucerne_nebikon', 'ChIJh2BrxBQnkEcRMAsZQIj_AAQ', 47.1933568, 7.9753668, 'city', '1'),
('countries_switzerland_lucerne_neudorf', 'ChIJ_X9WW90dkEcR0SGl_f6-Sww', 47.1768919, 8.2090818, 'city', '1'),
('countries_switzerland_lucerne_neuenkirch', 'ChIJ7dle1Mfjj0cRzr5flXGQLXY', 47.1008169, 8.2027053, 'city', '1'),
('countries_switzerland_lucerne_nottwil', 'ChIJN-HZF7Phj0cRDKZRaec7sRg', 47.1358124, 8.1359149, 'city', '1'),
('countries_switzerland_lucerne_oberkirch', 'ChIJfe4_wD3gj0cR8Tb4PQTMfZo', 47.1599235, 8.1156346, 'city', '1'),
('countries_switzerland_fribourg_les_sciernes_d_albeuve', 'ChIJP1oIlPmOjkcRlyVujHHh7RE', 46.4969466, 7.0349617, 'city', '0'),
('countries_switzerland_lucerne_ohmstal', 'ChIJx0g6lGLYj0cRXKfqTy20TQA', 47.1625583, 7.94984, 'city', '1'),
('countries_switzerland_lucerne_perlen', 'ChIJT3d9uNb9j0cR2zHyC7UjyL4', 47.11068, 8.36224, 'city', '1'),
('countries_switzerland_lucerne_pfaffnau', 'ChIJ4Xu9TPcokEcRUt2s2JII5vE', 47.2268257, 7.8961115, 'city', '1'),
('countries_switzerland_lucerne_pfeffikon', 'ChIJHYQ55dkYkEcREp1S8fwo36c', 47.2468436, 8.1763366, 'city', '1'),
('countries_switzerland_lucerne_reiden', 'ChIJ53aDrWUmkEcRXYzy7VF_MK4', 47.2472798, 7.9713408, 'city', '1'),
('countries_switzerland_fribourg_les_paccots', 'ChIJKfKOLcmFjkcRyn5QQ32GSGw', 46.52236, 6.94745, 'city', '0'),
('countries_switzerland_lucerne_retschwil', 'ChIJ2_eab_4ckEcRhcNAOtEvZ5I', 47.1929145, 8.2535638, 'city', '1'),
('countries_switzerland_fribourg_lechelles', 'ChIJdS__M4JxjkcRjbljaI7Sshc', 46.82891, 7.01603, 'city', '0'),
('countries_switzerland_lucerne_richenthal', 'ChIJFWuNI0omkEcRp06jo4FRRrA', 47.217492, 7.943889, 'city', '1'),
('countries_switzerland_fribourg_la_tour_de_treme', 'ChIJpZ6xyXdijkcRcZHqX6Tu6Sc', 46.608333, 7.06667, 'city', '1'),
('countries_switzerland_fribourg_kleinboesingen', 'ChIJ1_lKMSNrjkcRstGEXgbYNUQ', 46.89422, 7.20508, 'city', '1'),
('countries_switzerland_fribourg_jeuss', 'ChIJJ09_QKhsjkcRuCiTC_5H344', 46.9039721, 7.1625714, 'city', '0'),
('countries_switzerland_lucerne_roggliswil', 'ChIJTZFK11kokEcRgAsZQIj_AAQ', 47.2118201, 7.886204, 'city', '1'),
('countries_switzerland_lucerne_romoos', 'ChIJg-sh2ifDj0cR98eBl3rj7uM', 47.0110686, 8.0276847, 'city', '1'),
('countries_switzerland_lucerne_root', 'ChIJJ6NF0GX-j0cRPJEL133H7FE', 47.1149422, 8.3900853, 'city', '1'),
('countries_switzerland_lucerne_rothenburg', 'ChIJN2Y2GMr8j0cRb9x1smBysl4', 47.0936155, 8.2716874, 'city', '1'),
('countries_switzerland_lucerne_ruswil', 'ChIJ3THaYczmj0cR4oPK4G3L_us', 47.0840593, 8.1262881, 'city', '1'),
('countries_switzerland_fribourg_gumefens', 'ChIJeUdmgYRjjkcRo3pDj_dxBVQ', 46.6767042, 7.0757631, 'city', '0'),
('countries_switzerland_fribourg_grangettes_pres_romont', 'ChIJBeOA2mZ8jkcRFhF7vG6TiqQ', 46.6785451, 6.9619199, 'city', '0'),
('countries_switzerland_lucerne_schenkon', 'ChIJ-YJ_NMYfkEcRbV1ehkRU1eA', 47.1788688, 8.1303709, 'city', '1'),
('countries_switzerland_lucerne_schlierbach', 'ChIJE95pMVkfkEcRjTCwt97uRxQ', 47.2238629, 8.1112457, 'city', '1'),
('countries_switzerland_fribourg_grandsivaz', 'ChIJp7TDCL9wjkcRYzHlYs8CXLk', 46.7857213, 6.9776814, 'city', '0'),
('countries_switzerland_lucerne_schongau', 'ChIJ2TbNBQEbkEcRfFGZB8DhaIM', 47.26784, 8.26384, 'city', '1'),
('countries_switzerland_fribourg_galmiz', 'ChIJp_seOgoTjkcRNhvXhRXJiUY', 46.9489963, 7.1578548, 'city', '0'),
('countries_switzerland_fribourg_fraschels', 'ChIJl2nQILIWjkcRUwo8v8-zzSg', 46.9978982, 7.2082472, 'city', '1'),
('countries_switzerland_lucerne_schwarzenberg', 'ChIJBXNpaZPlj0cRddubqhJBQ8s', 47.0139898, 8.1730817, 'city', '1'),
('countries_switzerland_lucerne_sempach', 'ChIJm7wC3xbij0cRFe5iZQuYL68', 47.1341481, 8.1933634, 'city', '1'),
('countries_switzerland_lucerne_sigigen', 'ChIJIx1MSMDmj0cRExgxBST5ygE', 47.0635073, 8.1352953, 'city', '1'),
('countries_switzerland_fribourg_flamatt', 'ChIJH2WkcFpAjkcRZvpdvv3nL9Q', 46.8746919, 7.2757147, 'city', '1'),
('countries_switzerland_fribourg_fiaugeres', 'ChIJ-YiYwuCAjkcRoXylUuOZlKw', 46.583334, 6.883335, 'city', '1'),
('countries_switzerland_fribourg_fetigny', 'ChIJ4_d7dgp3jkcR6tezGWYoG6s', 46.7988384, 6.9164261, 'city', '1'),
('countries_switzerland_lucerne_sursee', 'ChIJT1Bk1PAfkEcRY7P5f5mGklc', 47.1714819, 8.1111312, 'city', '1'),
('countries_switzerland_lucerne_triengen', 'ChIJf5e86YYhkEcRvRCNMGK4KuE', 47.2354436, 8.0761619, 'city', '1'),
('countries_switzerland_lucerne_udligenswil', 'ChIJt18Us_r-j0cRLkGiHZdQEJA', 47.0905768, 8.4016959, 'city', '1'),
('countries_switzerland_lucerne_uffikon', 'ChIJnRJVKyohkEcRONGRy77rQgU', 47.210274, 8.017503, 'city', '1'),
('countries_switzerland_lucerne_ufhusen', 'ChIJE2UDjPfZj0cRn_sk8GCHKoY', 47.1170905, 7.8939976, 'city', '1'),
('countries_switzerland_lucerne_vitznau', 'ChIJpeGcTQZXhUcRODMrr43-cqA', 47.0102021, 8.4833558, 'city', '1'),
('countries_switzerland_lucerne_wauwil', 'ChIJrwcRU7ggkEcRkU4_KbYR3gM', 47.1862897, 8.0237036, 'city', '1'),
('countries_switzerland_lucerne_weggis', 'ChIJ0YAh-Y_4j0cRcAgZQIj_AAQ', 47.0338792, 8.425278, 'city', '1'),
('countries_switzerland_lucerne_werthenstein', 'ChIJn4Xmvhvnj0cRtUsaE68Wekg', 47.0483679, 8.1000315, 'city', '1'),
('countries_switzerland_fribourg_estavayer_le_lac', 'ChIJa0M19MzYjUcRgUhjNXwvzuc', 46.8496401, 6.8450608, 'city', '0'),
('countries_switzerland_lucerne_wikon', 'ChIJiRAsiDMkkEcRFgLTekqfqFM', 47.2668051, 7.9632813, 'city', '1'),
('countries_switzerland_fribourg_estavannens_dessus', 'ChIJMUOO3cyLjkcRvhsENOaXiDg', 46.56504, 7.10305, 'city', '0'),
('countries_switzerland_lucerne_willisau', 'ChIJLT_4tQHcj0cRIGwPrOxsZSQ', 47.1211466, 7.9925886, 'city', '1'),
('countries_switzerland_lucerne_winikon', 'ChIJDzDOvUEhkEcRgvyf7sTbCcI', 47.2379863, 8.0498313, 'city', '1'),
('countries_switzerland_lucerne_wolhusen', 'ChIJIWEepAXdj0cRonLtxLKNurE', 47.0586361, 8.0731633, 'city', '1'),
('countries_switzerland_lucerne_zell', 'ChIJKdHB7UrYj0cR7vto301FEk8', 47.1365613, 7.9276622, 'city', '1'),
('countries_switzerland_fribourg_donatyre', 'ChIJ815B3fRyjkcR3ABqBZN81g4', 46.883333, 7.05, 'city', '0'),
('countries_switzerland_fribourg_delley', 'ChIJC1xxR7h0jkcRUJGfXHn40ys', 46.9133633, 6.9676921, 'city', '1'),
('countries_switzerland_neuchatel_bevaix', 'ChIJqys2hBjejUcRkkDoI-a7oPg', 46.9307449, 6.8151887, 'city', '1'),
('countries_switzerland_fribourg_cresuz', 'ChIJf7C6OclhjkcRfCS8sTBm0MQ', 46.6212325, 7.1419918, 'city', '1'),
('countries_switzerland_neuchatel_boudevilliers', 'ChIJQ4uunEfijUcRHUy-coLvkT8', 47.0256734, 6.8891632, 'city', '1'),
('countries_switzerland_neuchatel_boudry', 'ChIJ8_k_HbTgjUcRWXcgcT6N_bI', 46.9542921, 6.8478409, 'city', '1'),
('countries_switzerland_neuchatel_brot_plamboz', 'ChIJTSD2PjnmjUcRvAapJ2j6Hs8', 46.9928425, 6.7533864, 'city', '1'),
('countries_switzerland_fribourg_cousset', 'ChIJPWudjDpxjkcRWE2ODJQIttg', 46.81832, 6.97728, 'city', '0'),
('countries_switzerland_neuchatel_cernier', 'ChIJMy4GzNHijUcRf0_g4iITJ6U', 47.0589492, 6.9006774, 'city', '1'),
('countries_switzerland_fribourg_courtion', 'ChIJR2YoagpyjkcRBYlIVAuvBL4', 46.8564791, 7.0666772, 'city', '1'),
('countries_switzerland_fribourg_courlevon', 'ChIJn_5vIxdtjkcR0DQZQIj_AAQ', 46.8911083, 7.1117581, 'city', '0'),
('countries_switzerland_fribourg_corpataux', 'ChIJA6XYP5hljkcRKaI-KNz5uhw', 46.7423637, 7.0964131, 'city', '1'),
('countries_switzerland_fribourg_cormerod', 'ChIJ1WhCN5BtjkcRVeuosB7Vkbg', 46.866667, 7.083338, 'city', '1'),
('countries_switzerland_fribourg_cormagens', 'ChIJ9VMZaQpyjkcRl_MtG25ThwA', 46.8346031, 7.1347229, 'city', '0'),
('countries_switzerland_neuchatel_coffrane', 'ChIJ-WfqPmDhjUcRwAzxmRmFQ-4', 47.0106037, 6.8622915, 'city', '1'),
('countries_switzerland_fribourg_chesopelloz', 'ChIJK9NTEFJujkcRrmUJG3N4zaE', 46.8069899, 7.0776978, 'city', '1'),
('countries_switzerland_fribourg_chenens', 'ChIJVaHp9fF6jkcRELF_jxrDPT0', 46.7409687, 7.0015049, 'city', '1'),
('countries_switzerland_fribourg_chatillon', 'ChIJjUAdrgnnkUcRWflMqhCABVo', 47.331096, 7.3457297, 'city', '1'),
('countries_switzerland_neuchatel_cornaux', 'ChIJIRl-3tQIjkcR0TWpO9lOyEc', 47.0380132, 7.0213496, 'city', '1'),
('countries_switzerland_neuchatel_cortaillod', 'ChIJtWCtinvgjUcR76IMZ4n6w50', 46.9431271, 6.8467863, 'city', '1'),
('countries_switzerland_neuchatel_cressier', 'ChIJB3Q4iTAPjkcRytSYunY8fGQ', 47.050861, 7.0373624, 'city', '1'),
('countries_switzerland_neuchatel_dombresson', 'ChIJQVHKnf8HjkcRkJk5qxxLn-g', 47.0709663, 6.9549699, 'city', '1'),
('countries_switzerland_neuchatel_enges', 'ChIJXbr2uqgIjkcRiOFBYKHz0yE', 47.0566208, 7.012101, 'city', '1'),
('countries_switzerland_neuchatel_engollon', 'ChIJT6FX_XjijUcRSo9VCzX4yAU', 47.0377644, 6.9206999, 'city', '1'),
('countries_switzerland_fribourg_chatel_sur_montsalvens', 'ChIJY6PmN8ZhjkcRmBWA4ggum0M', 46.6135683, 7.1275144, 'city', '1'),
('countries_switzerland_fribourg_chatel_saint_denis', 'ChIJRwG6UMqFjkcRhBDJnHXS_Qc', 46.5269159, 6.9010895, 'city', '1'),
('countries_switzerland_neuchatel_fontainemelon', 'ChIJi656gR3jjUcR5crqoVg8T1s', 47.0564305, 6.89055, 'city', '1'),
('countries_switzerland_neuchatel_fontaines', 'ChIJyV8ERF7ijUcRltqrT8GyZi8', 47.0426174, 6.9008183, 'city', '1'),
('countries_switzerland_neuchatel_fresens', 'ChIJ33cNqB7djUcRXvsGt7wP1i4', 46.88845, 6.74714, 'city', '1'),
('countries_switzerland_fribourg_charmey', 'ChIJ-zWKAYpfjkcRfjFAOBc6cFU', 46.6175845, 7.1654493, 'city', '1'),
('countries_switzerland_neuchatel_gorgier', 'ChIJl2tlHejdjUcR9PPXNtqb18k', 46.9037505, 6.7809412, 'city', '1'),
('countries_switzerland_neuchatel_hauterive', 'ChIJ5S2mEGMJjkcR34qVdHhGHrs', 47.0156428, 6.9725091, 'city', '1'),
('countries_switzerland_fribourg_chables', 'ChIJJbOgKQ3ZjUcRfqt4G0N_FMY', 46.8256195, 6.8077879, 'city', '1'),
('countries_switzerland_neuchatel_la_chatagne', 'ChIJr1VfD37pjUcRjrH5wr4uuAA', 46.9863192, 6.6382525, 'city', '1'),
('countries_switzerland_neuchatel_la_chaux_de_fonds', 'ChIJBVcKvSKhj0cRTjeCh6tilkI', 47.1034892, 6.8327838, 'city', '1'),
('countries_switzerland_neuchatel_la_chaux_du_milieu', 'ChIJl9RbjM7ojUcR-RVZ4a5Aa60', 47.0131911, 6.7036477, 'city', '1'),
('countries_switzerland_fribourg_cerniat', 'ChIJlcIesVNnjkcR2TZSgY6BpSk', 46.6343672, 7.1594527, 'city', '0'),
('countries_switzerland_neuchatel_la_sagne', 'ChIJOYThhEXkjUcRVjGcBjP6Scs', 47.0393833, 6.7996172, 'city', '1'),
('countries_switzerland_fribourg_bussy', 'ChIJPWB1LBJ2jkcRw0wyKZLupXk', 46.8347441, 6.8883729, 'city', '1'),
('countries_switzerland_neuchatel_les_brenets', 'ChIJbTP8DJfvjUcRfyAB6OXVsaI', 47.0680788, 6.7047551, 'city', '1'),
('countries_switzerland_neuchatel_les_geneveys_sur_coffrane', 'ChIJRTH8u-_jjUcRzr_es1UDz9c', 47.01735, 6.85254, 'city', '1'),
('countries_switzerland_neuchatel_les_hauts_geneveys', 'ChIJE04HYAbjjUcRU4qstbFhjJ4', 47.0475296, 6.8723416, 'city', '1'),
('countries_switzerland_neuchatel_les_planchettes', 'ChIJ9yxAgbz6jUcRSymRHOAIcCM', 47.1064515, 6.7702862, 'city', '1'),
('countries_switzerland_neuchatel_les_ponts_de_martel', 'ChIJdR5zgJjojUcRVarzlNE99o0', 46.999113, 6.7335548, 'city', '1'),
('countries_switzerland_fribourg_buechslen', 'ChIJ6cI4_Z0UjkcRNYjfApx2uus', 46.9450966, 7.1799138, 'city', '1'),
('countries_switzerland_fribourg_bruenisried', 'ChIJp7cJ_i5DjkcR1CDmWdXsMkQ', 46.759019, 7.278788, 'city', '1'),
('countries_switzerland_fribourg_bourguillon', 'ChIJa5QIHh9pjkcRMQkQLsb_yeY', 46.798975, 7.1744273, 'city', '0'),
('countries_switzerland_fribourg_bosingen', 'ChIJ0YvLYpRqjkcREIgI3CtBt8Y', 46.8929791, 7.2283389, 'city', '1'),
('countries_switzerland_fribourg_bonnefontaine', 'ChIJaxK6FcJnjkcRPO19G7IjX8Y', 46.7406052, 7.2003891, 'city', '0'),
('countries_switzerland_fribourg_bollion', 'ChIJG7GE2f_YjUcRCVRJ26cHwfk', 46.8177, 6.8269, 'city', '0'),
('countries_switzerland_neuchatel_le_landeron', 'ChIJ-SIHTEUPjkcRABv4DI84hHE', 47.0581255, 7.0730626, 'city', '1'),
('countries_switzerland_neuchatel_le_locle', 'ChIJbfOSW3nljUcR6B4l48b5KI0', 47.0577195, 6.7487354, 'city', '1'),
('countries_switzerland_fribourg_billens', 'ChIJh5Ymjid_jkcRKN5kjRI1G-w', 46.6903425, 6.8994397, 'city', '1'),
('countries_switzerland_fribourg_bas_vully', 'ChIJK2XrTm4SjkcR9avfO9MO87A', 46.9618756, 7.1128985, 'city', '0'),
('countries_switzerland_neuchatel_marin', 'ChIJgyv-o1oJjkcRLHHGFaLQFZM', 47.0092921, 7.0005596, 'city', '1'),
('countries_switzerland_neuchatel_marin_epagnier', 'ChIJt4RhN0UJjkcR9dxtPHTvIRY', 47.0091808, 7.0015896, 'city', '1'),
('countries_switzerland_neuchatel_montalchez', 'ChIJ5f_N6_3cjUcRwQFH8wXdbxA', 46.89776, 6.7465358, 'city', '1'),
('countries_switzerland_fribourg_barbereche', 'ChIJYYJDPW5sjkcRgDQZQIj_AAQ', 46.8442449, 7.135263, 'city', '1'),
('countries_switzerland_neuchatel_montmollin', 'ChIJM1XXNEThjUcRc5X0_YU7gNU', 46.9929482, 6.846884, 'city', '1'),
('countries_switzerland_fribourg_avry_sur_matran', 'ChIJFR2SpsdvjkcRqu4_94ZXtCk', 46.7882048, 7.0702972, 'city', '0'),
('countries_switzerland_fribourg_avry_devant_pont', 'ChIJXYEsBIhjjkcR-S1dE_as3NY', 46.683338, 7.083329, 'city', '1'),
('countries_switzerland_neuchatel_peseux', 'ChIJVyaR2pPhjUcRMHAZQIj_AAQ', 46.9880679, 6.8908413, 'city', '1'),
('countries_switzerland_neuchatel_rochefort', 'ChIJ_ZKT0TThjUcRqCGxzI5nOKc', 46.9782646, 6.8099317, 'city', '1'),
('countries_switzerland_neuchatel_saint_aubin_sauges', 'ChIJQf2xHrbdjUcR56r68S1jjRs', 46.8929533, 6.7705679, 'city', '1'),
('countries_switzerland_neuchatel_saint_blaise', 'ChIJt8wBej0JjkcR3Bo1jm3XwOc', 47.013611, 6.9849397, 'city', '1'),
('countries_switzerland_fribourg_agriswil', 'ChIJi8RjVnsUjkcRh6mGQtaXfvw', 46.9542125, 7.1970573, 'city', '0'),
('countries_switzerland_neuchatel_savagnier', 'ChIJZRgETk4IjkcRknAZTp05Sls', 47.0509433, 6.9561116, 'city', '1'),
('countries_switzerland_bern_zweilutschinen', 'ChIJCYDiaBSij0cRPoyaffrsihQ', 46.6318906, 7.9124686, 'city', '0'),
('countries_switzerland_neuchatel_travers', 'ChIJ24Lwhi7ojUcR4sFkdSRZ9P4', 46.9402343, 6.6760358, 'city', '1'),
('countries_switzerland_neuchatel_valangin', 'ChIJs2kKKhnijUcR4NeGBKuuEdQ', 47.016063, 6.906469, 'city', '1'),
('countries_switzerland_neuchatel_vaumarcus', 'ChIJXR1VNW3cjUcRl8UkRqVJY4E', 46.8781484, 6.7550836, 'city', '1'),
('countries_switzerland_neuchatel_villiers', 'ChIJAROqEDkGjkcRhoQE1psdkYY', 47.074493, 6.9713574, 'city', '1'),
('countries_switzerland_nidwalden_beckenried', 'ChIJ8Qlsx69ZhUcR_sUv6P0NFNo', 46.9704961, 8.4657007, 'city', '1'),
('countries_switzerland_nidwalden_buochs', 'ChIJaUkelOD3j0cRcAH7ZwagW9g', 46.9735985, 8.420352, 'city', '1'),
('countries_switzerland_bern_zollbruck', 'ChIJk7yO-TzMj0cR1Tc9vFJst0c', 46.9751272, 7.7415871, 'city', '1'),
('countries_switzerland_nidwalden_dallenwil', 'ChIJ2eclrRr2j0cR5Lc1cxpzTQQ', 46.933509, 8.3905918, 'city', '1'),
('countries_switzerland_nidwalden_emmetten', 'ChIJvaCywRhahUcRRj2CfiltdvE', 46.9567523, 8.5134155, 'city', '1'),
('countries_switzerland_nidwalden_ennetburgen', 'ChIJ1xSnLxD4j0cRUax8gY1upkc', 46.9851573, 8.413513, 'city', '1'),
('countries_switzerland_nidwalden_ennetmoos', 'ChIJ87FBsizxj0cRYNsYQIj_AAQ', 46.9569067, 8.3387923, 'city', '1'),
('countries_switzerland_nidwalden_erlen', 'ChIJFSkDrtP6mkcRvjDoESh1IVU', 47.5518448, 9.2265297, 'city', '1'),
('countries_switzerland_bern_zimmerwald', 'ChIJozWmXz1IjkcR233H9OYOJS0', 46.8816986, 7.4718342, 'city', '0'),
('countries_switzerland_nidwalden_hergiswil', 'ChIJU9tghXvwj0cR4cbCFwbJPLg', 46.9905821, 8.3083735, 'city', '1'),
('countries_switzerland_bern_zaziwil', 'ChIJ8QcJy77Kj0cREPD070Ot7WE', 46.9018575, 7.6614969, 'city', '1'),
('countries_switzerland_bern_worblaufen', 'ChIJcYrgLpowjkcR14NRKjzxRXA', 46.9761433, 7.4818936, 'city', '0'),
('countries_switzerland_nidwalden_niederwil', 'ChIJscX6pnsRkEcRMzBy2KAApk0', 47.3773998, 8.2952607, 'city', '1'),
('countries_switzerland_bern_wohlen_bei_bern', 'ChIJUalF1ic8jkcRYNBXdJaqX2M', 46.9704283, 7.3658552, 'city', '0'),
('countries_switzerland_nidwalden_oberdorf', 'ChIJGR492ir2j0cRmQLwsG6UH44', 46.9584499, 8.3865692, 'city', '1'),
('countries_switzerland_bern_wiler', 'ChIJk_7e8wAOj0cRzFhpu-UQ7H0', 46.4022173, 7.7827556, 'city', '0'),
('countries_switzerland_nidwalden_stans', 'ChIJSxW_FQb3j0cRkNsYQIj_AAQ', 46.9571926, 8.3659672, 'city', '1'),
('countries_switzerland_nidwalden_stansstad', 'ChIJ-_UnpN75j0cRZ7_uybejSJs', 46.977594, 8.3374207, 'city', '1'),
('countries_switzerland_bern_wengen', 'ChIJYdRtHsahj0cRgQMvzvqWqbE', 46.6054335, 7.9215399, 'city', '1'),
('countries_switzerland_bern_weissenburg', 'ChIJPcx8GvdTjkcRISJNhJtSr_Q', 46.6591694, 7.4932504, 'city', '0'),
('countries_switzerland_nidwalden_wolfenschiessen', 'ChIJZ0MlOZJfhUcRu8BvMAp93vQ', 46.9081639, 8.3959084, 'city', '1'),
('countries_switzerland_obwalden_alpnach', 'ChIJrQp2I6fxj0cRiVPw6FBJ5fw', 46.9380412, 8.2701754, 'city', '1'),
('countries_switzerland_bern_wasen', 'ChIJf7kLUfvRj0cRQu7GOScYFzM', 47.033333, 7.783333, 'city', '0'),
('countries_switzerland_bern_wahlendorf', 'ChIJ92effrM9jkcRCjrnkSUQ2BM', 47.00402, 7.33659, 'city', '0'),
('countries_switzerland_bern_wabern', 'ChIJXV0U9i04jkcRtsIWne_5p7s', 46.9290164, 7.4489732, 'city', '0'),
('countries_switzerland_obwalden_engelberg', 'ChIJFR_5naZghUcRlKF1cq1gV5Y', 46.8200266, 8.4069918, 'city', '1'),
('countries_switzerland_bern_urtenen', 'ChIJ3Ys7JmwwjkcRQdNH4zB7Dzk', 47.0205678, 7.499724, 'city', '0'),
('countries_switzerland_obwalden_giswil', 'ChIJaYi-zSCTj0cRydG4ZxILjSE', 46.838212, 8.1872814, 'city', '1'),
('countries_switzerland_bern_twann', 'ChIJsQbgt-gajkcRcMHZvU5lNto', 47.0949036, 7.1566044, 'city', '1'),
('countries_switzerland_obwalden_kerns', 'ChIJR_0e3K_0j0cRI5Ubhh7MyWw', 46.9022606, 8.2763586, 'city', '1'),
('countries_switzerland_obwalden_lungern', 'ChIJdfLSQW2Sj0cRsiyvJZPYF3s', 46.7858188, 8.159704, 'city', '1'),
('countries_switzerland_obwalden_melchsee_frutt', 'ChIJ99JJ_AmMj0cR9dEbeGFdCRI', 46.77385, 8.26838, 'city', '1'),
('countries_switzerland_obwalden_melchtal', 'ChIJDdFkUlSLj0cRa-cTiLQR0-A', 46.834079, 8.2892318, 'city', '1'),
('countries_switzerland_obwalden_ramersberg', 'ChIJowGSn2ryj0cRYhD-qYeJAjw', 46.8974442, 8.2329791, 'city', '1'),
('countries_switzerland_obwalden_sachseln', 'ChIJbTzaTibyj0cRoTaS7zwm4Rw', 46.8671605, 8.2393778, 'city', '1'),
('countries_switzerland_obwalden_sarnen', 'ChIJ9ewLGbDtj0cRFTQTk30zIEk', 46.8959313, 8.2456758, 'city', '1'),
('countries_switzerland_bern_thorishaus', 'ChIJf2AYzK1AjkcRmXAe9yt5PpE', 46.8926843, 7.3524749, 'city', '0'),
('countries_switzerland_bern_thoerigen', 'ChIJM9NqGT7Vj0cRItLG67GtvqA', 47.1733519, 7.7280908, 'city', '1'),
('countries_switzerland_bern_tauffelen', 'ChIJqy33TZ4QjkcRslvTGYsaTBc', 47.0669686, 7.2001588, 'city', '1'),
('countries_switzerland_bern_taegertschi', 'ChIJ99K9fIhKjkcRjZwRi3h1wOk', 46.8756333, 7.585386, 'city', '1'),
('countries_switzerland_bern_sutz', 'ChIJcUcN8y0ajkcRITe0mBayXmY', 47.0986576, 7.2161472, 'city', '1'),
('countries_switzerland_saint_gallen_amden', 'ChIJwzCPge7TmkcRSCRkT1RUwDw', 47.1491923, 9.1401481, 'city', '1'),
('countries_switzerland_saint_gallen_andwil', 'ChIJqSyxlDfhmkcRkorJSbfkJN4', 47.4392496, 9.2708089, 'city', '1'),
('countries_switzerland_saint_gallen_au', 'ChIJaUsowqQWm0cRIACBEiCC6jM', 47.431055, 9.6343097, 'city', '1'),
('countries_switzerland_bern_sudern', NULL, 0, 0, 'city', '0'),
('countries_switzerland_bern_sundlauenen', 'ChIJSwSdZXKlj0cR7ewNhtpNoio', 46.6854621, 7.791055, 'city', '0'),
('countries_switzerland_saint_gallen_bad_ragaz', 'ChIJkVZ4dIHLhEcRig5K0zvwlbY', 47.0034141, 9.5011062, 'city', '1'),
('countries_switzerland_saint_gallen_balgach', 'ChIJbUgH5mcWm0cRKxUbh06GSOI', 47.4067767, 9.6059622, 'city', '1'),
('countries_switzerland_bern_suberg', 'ChIJsdhOXMwijkcRuqTRVBYBjMA', 47.06034, 7.33777, 'city', '0'),
('countries_switzerland_saint_gallen_benken', 'ChIJmYhtkOnOmkcR0jwE2cGQCXQ', 47.1984261, 9.0051169, 'city', '1'),
('countries_switzerland_saint_gallen_berg', 'ChIJB1gmUJHImkcRd0tXzfAC8po', 47.241667, 8.958333, 'city', '1'),
('countries_switzerland_saint_gallen_berneck', 'ChIJm7xiRcQWm0cRvvlj-uXRQGI', 47.4255058, 9.6135168, 'city', '1'),
('countries_switzerland_bern_stechelberg', 'ChIJS1bxLLsKj0cRYHRwOL_h4JQ', 46.5495444, 7.9015269, 'city', '0'),
('countries_switzerland_bern_spiegel_be', 'ChIJk7yuokg4jkcR_Ep7-PD4Wyo', 46.925, 7.431667, 'city', '0'),
('countries_switzerland_bern_souboz', 'ChIJ5XGhQWDhkUcR-Q6mGTymgfI', 47.2740298, 7.2431239, 'city', '0'),
('countries_switzerland_saint_gallen_bronschhofen', 'ChIJEXkUy_DrmkcRk3OaSL_r3A0', 47.4782696, 9.0352242, 'city', '1'),
('countries_switzerland_saint_gallen_brunnadern', 'ChIJd7tG4Z_cmkcR67lbY-Ywo4g', 47.3364927, 9.1304843, 'city', '1'),
('countries_switzerland_bern_sornetan', 'ChIJA6ke0AjjkUcRbXQ31qYuiYA', 47.2742004, 7.2159, 'city', '0'),
('countries_switzerland_saint_gallen_degersheim', 'ChIJ4_UKHL7dmkcReOLjkQKCTXQ', 47.3738511, 9.200308, 'city', '1'),
('countries_switzerland_saint_gallen_diepoldsau', 'ChIJjbRWEi8Um0cRkc3DITBBBwA', 47.385988, 9.6547802, 'city', '1'),
('countries_switzerland_saint_gallen_dietfurt', 'ChIJu5r6YQzDmkcRkluqYb4COEk', 47.34729, 9.07955, 'city', '1'),
('countries_switzerland_bern_sonceboz', 'ChIJ3fOqVBYdjkcRggxaNcSzQYU', 47.1957402, 7.1786494, 'city', '1'),
('countries_switzerland_bern_seftigen', 'ChIJN0hlEDNJjkcRupPgwiSps3M', 46.8318401, 7.5054926, 'city', '0'),
('countries_switzerland_saint_gallen_ebnat_kappel', 'ChIJtea3ZofQmkcR9p2ePKi7-sc', 47.265485, 9.1235471, 'city', '1'),
('countries_switzerland_saint_gallen_eggersriet', 'ChIJD2ZYomEZm0cRxHASlSmzfa4', 47.4426685, 9.4719247, 'city', '1'),
('countries_switzerland_saint_gallen_eichberg', 'ChIJLV_qETk9m0cRm0jw7p-cCbo', 47.3428013, 9.5319606, 'city', '1'),
('countries_switzerland_saint_gallen_engelburg', 'ChIJ9cCztuDhmkcRG95xAI4C530', 47.44285, 9.34425, 'city', '1'),
('countries_switzerland_bern_schwarzenburg', 'ChIJKZ4-hx1EjkcRN4UkyKk9HrI', 46.8184541, 7.3411203, 'city', '0'),
('countries_switzerland_saint_gallen_ermenswil', 'ChIJi3AE5-a3mkcR8xUuW9rpfF8', 47.2447773, 8.8849972, 'city', '1'),
('countries_switzerland_saint_gallen_ernetschwil', 'ChIJi64gxZHFmkcRIib5iTuvy9Q', 47.237183, 8.9999686, 'city', '1'),
('countries_switzerland_saint_gallen_eschenbach', 'ChIJs0g-YRPImkcRIQritnAWE3s', 47.2406093, 8.9220805, 'city', '1'),
('countries_switzerland_saint_gallen_flawil', 'ChIJA_UTep7nmkcRuijYoar73wU', 47.4133707, 9.1870297, 'city', '1'),
('countries_switzerland_saint_gallen_flums', 'ChIJjx37sHcpm0cRGPQWRqv_96Q', 47.0916461, 9.3425546, 'city', '1'),
('countries_switzerland_bern_schwarzenbach_huttwil', 'ChIJcQiJ4DLRj0cRlROIDubtHvE', 47.10228, 7.82375, 'city', '0'),
('countries_switzerland_bern_schupfen', 'ChIJ7ymFu708jkcRPrkgQ23ymgQ', 47.037219, 7.37617, 'city', '1'),
('countries_switzerland_bern_schupbach', 'ChIJryNxJtjLj0cReAbWwVvkOh8', 46.9237331, 7.7399289, 'city', '0'),
('countries_switzerland_bern_schonried', 'ChIJa_FL-DrxjkcRUaKjj1806WU', 46.504167, 7.289444, 'city', '1'),
('countries_switzerland_bern_schliern', 'ChIJGQzjDmQ4jkcRnKNnnGPHFHY', 46.91008, 7.4150876, 'city', '0'),
('countries_switzerland_saint_gallen_gams', 'ChIJy_cCeo0vm0cR2rYapNrUawo', 47.2039131, 9.4413218, 'city', '1'),
('countries_switzerland_saint_gallen_ganterschwil', 'ChIJ13WBaPPCmkcRHXllKSCt22c', 47.3810888, 9.0895852, 'city', '1'),
('countries_switzerland_saint_gallen_gebertingen', 'ChIJw0Ny6PfFmkcRxPCHnXCqkjI', 47.25267, 9.0066599, 'city', '1'),
('countries_switzerland_saint_gallen_goldach', 'ChIJYyymo40bm0cR7GAcIaOwyek', 47.4788311, 9.4700004, 'city', '1'),
('countries_switzerland_saint_gallen_goldingen', 'ChIJQ6zQtELGmkcRzTSKrVp3vjA', 47.2629383, 8.9663634, 'city', '1'),
('countries_switzerland_saint_gallen_gommiswald', 'ChIJjStguYHFmkcRn_cmt-DIuww', 47.2351911, 9.0220567, 'city', '1'),
('countries_switzerland_saint_gallen_gossau', 'ChIJX4EgYSjhmkcRTSHbd0MrcxM', 47.4155608, 9.248852, 'city', '1'),
('countries_switzerland_saint_gallen_grabs', 'ChIJRV_TQ_Aum0cRiy7_JEopXao', 47.1825657, 9.4440433, 'city', '1'),
('countries_switzerland_bern_sariswil', 'ChIJO9Qk08w9jkcRhfAw3nP5Lfg', 46.9920371, 7.3360253, 'city', '0'),
('countries_switzerland_saint_gallen_grub_sg', 'ChIJaXrJpSgam0cRd_MC39TIe_8', 47.4524984, 9.5133296, 'city', '1'),
('countries_switzerland_bern_sankt_stephan', 'ChIJm5WNQvj7jkcRyNDJ9mv5aac', 46.50595, 7.40205, 'city', '1'),
('countries_switzerland_bern_saint_imier', 'ChIJCZb31s0AjkcRTrYPr35Ap9I', 47.1522207, 6.9962252, 'city', '1'),
('countries_switzerland_saint_gallen_heerbrugg', 'ChIJJbg9_ZQWm0cRobr7jCzVzpA', 47.41667, 9.616673, 'city', '1'),
('countries_switzerland_saint_gallen_hemberg', 'ChIJyzLZu8HbmkcR8DbbSx40x_o', 47.3004487, 9.1760617, 'city', '1'),
('countries_switzerland_bern_saanenmoeser', 'ChIJJ8Q-Tyr3jkcR3oIgJDzMD5w', 46.5177335, 7.3094927, 'city', '0'),
('countries_switzerland_saint_gallen_hoffeld', 'ChIJ0VagWwfdmkcRjfWK-9Jv_Oo', 47.3626532, 9.1749868, 'city', '1'),
('countries_switzerland_bern_ruschegg', 'ChIJcUUY3lBFjkcRsVAwuyVlpPM', 46.7812793, 7.4056793, 'city', '1'),
('countries_switzerland_saint_gallen_horn', 'ChIJddl3IFsbm0cRTjQoEIBjWXs', 47.4949526, 9.4627045, 'city', '1'),
('countries_switzerland_saint_gallen_jona', 'ChIJfbU_tOi2mkcR1anBjdgOhtw', 47.2223076, 8.8327118, 'city', '1'),
('countries_switzerland_saint_gallen_jonschwil', 'ChIJ10_LLrfpmkcRp4uaDruiZmA', 47.4245451, 9.08619, 'city', '1'),
('countries_switzerland_saint_gallen_kaltbrunn', 'ChIJAeo4MLHPmkcRTMS8PfERC4M', 47.2133136, 9.0250732, 'city', '1'),
('countries_switzerland_saint_gallen_kirchberg', 'ChIJxW57qRHqmkcRs00oSgIlaho', 47.4113533, 9.0401819, 'city', '1'),
('countries_switzerland_bern_ruetschelen', 'ChIJC7gKFpnVj0cRbqF7J7Qq-nQ', 47.17234, 7.77311, 'city', '1'),
('countries_switzerland_saint_gallen_krinau', 'ChIJSfstEnvEmkcRY5tedBU7J7c', 47.3173506, 9.0497485, 'city', '1'),
('countries_switzerland_bern_rueti_bei_riggisberg', 'ChIJ42bTHbZPjkcR5Yc49e1GR3c', 46.78173, 7.45441, 'city', '1'),
('countries_switzerland_saint_gallen_lenggenwil', 'ChIJ__N8fLLomkcRCjMjsBe5-HI', 47.47472, 9.14962, 'city', '1'),
('countries_switzerland_saint_gallen_libingen', 'ChIJbcdEsQDEmkcRZq2nH_0pDiw', 47.32869, 9.0228801, 'city', '1'),
('countries_switzerland_saint_gallen_lichtensteig', 'ChIJdRqIEFjDmkcRcGY9XGnLNJ0', 47.3239036, 9.0876844, 'city', '1'),
('countries_switzerland_bern_rueti', 'ChIJS2KYD4y3mkcRYGQKXP1OeEo', 47.2566995, 8.854421, 'city', '1'),
('countries_switzerland_bern_ruemligen', 'ChIJl5B8oDxJjkcRlaNCH1_5mts', 46.8303609, 7.4950501, 'city', '1'),
('countries_switzerland_bern_rueggisberg', 'ChIJY2jb4wBGjkcRUsdU1hrw0cQ', 46.821399, 7.4385592, 'city', '1'),
('countries_switzerland_bern_ruefenacht', 'ChIJS9j2LPU2jkcRUjRBXp3sies', 46.92968, 7.53121, 'city', '1'),
('countries_switzerland_bern_rueegsbach', 'ChIJe1ZAQK_Sj0cRWdqW1RB2ZJA', 47.0182296, 7.6606271, 'city', '0'),
('countries_switzerland_saint_gallen_maseltrangen', 'ChIJN6Lq0z_OmkcR3ZP9mzZSedI', 47.19, 9.049167, 'city', '1'),
('countries_switzerland_saint_gallen_mels', 'ChIJnaPj7TbShEcRNvXGKfPSM80', 47.0478375, 9.4224018, 'city', '1'),
('countries_switzerland_saint_gallen_mogelsberg', 'ChIJWYoo2_jcmkcRRYeYjgwbmsM', 47.3625957, 9.1341197, 'city', '1'),
('countries_switzerland_bern_rueegsauschachen', 'ChIJ4XveobcyjkcRxxrkTd4Mblc', 47.01918, 7.66336, 'city', '1'),
('countries_switzerland_saint_gallen_montlingen', 'ChIJB68VFbg9m0cRkMmSiFHXkoY', 47.3341624, 9.5848066, 'city', '1'),
('countries_switzerland_bern_rueegsau', 'ChIJe1ZAQK_Sj0cRWdqW1RB2ZJA', 47.0182296, 7.6606271, 'city', '1'),
('countries_switzerland_saint_gallen_mosnang', 'ChIJtYX9XFvBmkcRhniTewteEfo', 47.3626894, 9.0399285, 'city', '1'),
('countries_switzerland_saint_gallen_mueselbach', 'ChIJ674aKBzCmkcRdN81i_TMsCw', 47.3922739, 9.0412438, 'city', '1'),
('countries_switzerland_bern_rueedisbach', 'ChIJQVpszlIrjkcR1Hcl-DxcWD8', 47.1201338, 7.7001211, 'city', '0'),
('countries_switzerland_saint_gallen_muolen', 'ChIJAaa4eBrjmkcRIE8ZQIj_AAQ', 47.52143, 9.32501, 'city', '1'),
('countries_switzerland_bern_ruedtligen', 'ChIJERdFYiGtj0cR3IeWSmWbT3Y', 46.6942792, 7.6202063, 'city', '0'),
('countries_switzerland_saint_gallen_nassen', 'ChIJjRr6YjHdmkcRL-leuEWh4nA', 47.3730972, 9.1359933, 'city', '1'),
('countries_switzerland_bern_ruderswil', 'ChIJiW51A0PMj0cR_Rghp7-zkVU', 46.9834237, 7.7232395, 'city', '1'),
('countries_switzerland_saint_gallen_nesslau', 'ChIJt5Xfiz_XmkcRl9eJemFoo_U', 47.216667, 9.2, 'city', '1'),
('countries_switzerland_saint_gallen_neu_sankt_johann', 'ChIJy-w6fFrXmkcRoKkFNNDq6Es', 47.22978, 9.19435, 'city', '1'),
('countries_switzerland_bern_rothenbach', 'ChIJTyvsT2u2j0cRTa4lTcHUlzw', 46.8542235, 7.741505, 'city', '1'),
('countries_switzerland_saint_gallen_niederhelfenschwil', 'ChIJjYNnWv_lmkcRi29ZNmPhOOI', 47.4759334, 9.1867441, 'city', '1'),
('countries_switzerland_bern_rosshaeusern', 'ChIJ0bEWX9g_jkcR-vss5Ny2qc8', 46.9321245, 7.2755014, 'city', '0');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_switzerland_saint_gallen_oberhelfenschwil', 'ChIJT38pqDXDmkcR6pR98T5p7n4', 47.3540918, 9.1129175, 'city', '1'),
('countries_switzerland_saint_gallen_oberriet', 'ChIJfd4sLKY9m0cRDQC3QQWfYNs', 47.3199075, 9.5644269, 'city', '1'),
('countries_switzerland_bern_rizenbach', 'ChIJ_Th7Gf4UjkcRk9zaRn1J5PA', 46.9429549, 7.2295432, 'city', '0'),
('countries_switzerland_bern_riffenmatt', 'ChIJ24_DJOpEjkcRDsYjzjC9oMs', 46.7657411, 7.3525803, 'city', '0'),
('countries_switzerland_bern_richigen', 'ChIJU0RsObE1jkcRvKl05woeBho', 46.9179338, 7.5822028, 'city', '0'),
('countries_switzerland_saint_gallen_oberterzen', 'ChIJB-jwj5Eqm0cRX7WkVPUeujc', 47.102403, 9.255855, 'city', '1'),
('countries_switzerland_saint_gallen_oberuzwil', 'ChIJwf6ukLbpmkcRdeexQGwSQkk', 47.4298412, 9.1232808, 'city', '1'),
('countries_switzerland_bern_reichenbach', 'ChIJD1ZZoi4Gj0cRkEtlM_UIvM0', 46.6254387, 7.6940529, 'city', '0'),
('countries_switzerland_saint_gallen_quarten', 'ChIJnyE3y4Iqm0cR63-HM9WTOco', 47.1132054, 9.2515678, 'city', '1'),
('countries_switzerland_bern_ranfluh', 'ChIJT8kRJ3Khj0cRV8xxK5VNlnU', 46.6203687, 7.8956913, 'city', '0'),
('countries_switzerland_saint_gallen_rebstein', 'ChIJV8JcBVIWm0cRCyX3C7-LCHE', 47.3977266, 9.58271, 'city', '1'),
('countries_switzerland_saint_gallen_rheineck', 'ChIJe5KO_PEQm0cRG_cmG2Pz4Go', 47.4670483, 9.585971, 'city', '1'),
('countries_switzerland_saint_gallen_ricken', 'ChIJ1REo753FmkcRTMq3aM5nOYw', 47.263056, 9.044167, 'city', '1'),
('countries_switzerland_saint_gallen_rorschach', 'ChIJA-8RSKMbm0cRlbFiQObBrrI', 47.4788825, 9.4916808, 'city', '1'),
('countries_switzerland_saint_gallen_rorschacherberg', 'ChIJOWcULwEbm0cREiRzsuqtubE', 47.4688795, 9.4869146, 'city', '1'),
('countries_switzerland_bern_ramsei', 'ChIJ1RxUPwfNj0cR7_v3asxWm9I', 46.99702, 7.71083, 'city', '0'),
('countries_switzerland_saint_gallen_rufi', 'ChIJpecBlBHOmkcRAKH4mwtaoJQ', 47.1811841, 9.0508609, 'city', '1'),
('countries_switzerland_bern_rain', 'ChIJUflQf7fij0cRbaKiIU3kHkI', 47.12766, 8.25356, 'city', '1'),
('countries_switzerland_bern_preles', 'ChIJBZ7oas0ajkcRORlpiDwr8TY', 47.0994968, 7.130459, 'city', '1'),
('countries_switzerland_bern_pontenet', 'ChIJ4eOMjIfhkUcRJhT8nRnGR0E', 47.2414781, 7.2553614, 'city', '0'),
('countries_switzerland_bern_pery', 'ChIJQ_K10IB7jEcRrFe6Eci0JhI', 46.1553483, 6.0945809, 'city', '1'),
('countries_switzerland_bern_oschwand', 'ChIJ2eKB2GEyjkcRC9iTgU_4a4U', 47.02222, 7.62683, 'city', '0'),
('countries_switzerland_saint_gallen_sargans', 'ChIJaxDaeTPNhEcR_hYD_Bl0OQM', 47.0478519, 9.4406105, 'city', '1'),
('countries_switzerland_bern_oey', 'ChIJCw9ZEK2sj0cRInueQnycJpw', 46.6599454, 7.5789638, 'city', '1'),
('countries_switzerland_bern_oberwil', 'ChIJrWxJ8p64kUcReGFF_5M4_fU', 47.5159745, 7.5582003, 'city', '0'),
('countries_switzerland_saint_gallen_schmerikon', 'ChIJN1UQSOXImkcR9s_g2e17S9Q', 47.2261376, 8.9482314, 'city', '1'),
('countries_switzerland_bern_oberried', 'ChIJj8tkC269j0cRvNLEushNFfQ', 46.7337573, 7.9564805, 'city', '1'),
('countries_switzerland_saint_gallen_sennwald', 'ChIJ58elZkYlm0cR6fEYRWTAZA0', 47.2612316, 9.5042435, 'city', '1'),
('countries_switzerland_saint_gallen_sevelen', 'ChIJtQu_SRAym0cRHFiHYqibFp4', 47.1218764, 9.486948, 'city', '1'),
('countries_switzerland_bern_oberonz', 'ChIJCSMNDJUqjkcR-tB2karpvlY', 47.1794238, 7.6944206, 'city', '1'),
('countries_switzerland_saint_gallen_staad', 'ChIJh1KrK1wam0cRJipvuyffnMg', 47.48053, 9.53303, 'city', '1'),
('countries_switzerland_saint_gallen_stein', 'ChIJHfOrfqnXmkcRdq8a_mB-rRk', 47.1983643, 9.2271952, 'city', '1'),
('countries_switzerland_saint_gallen_steinach', 'ChIJ_e1FdKUcm0cR-7nBMedYcK8', 47.50321, 9.44208, 'city', '1'),
('countries_switzerland_saint_gallen_st_gallen', 'ChIJVdgzdikem0cRFGH-HwhQIpo', 47.4244818, 9.3767173, 'city', '1'),
('countries_switzerland_bern_oberoesch', 'ChIJEWjoyRosjkcRMco7vYXGwlo', 47.1083162, 7.6093672, 'city', '1'),
('countries_switzerland_saint_gallen_thal', 'ChIJs_QLFIMam0cRRuA4Pghlsx8', 47.4672487, 9.5662899, 'city', '1'),
('countries_switzerland_bern_oberhuenigen', 'ChIJgV829WC1j0cR1viUbA7iB60', 46.8799521, 7.6580949, 'city', '1'),
('countries_switzerland_bern_oberfrittenbach', 'ChIJ8QosEtDOj0cRHkXN1K7SDFY', 46.958487, 7.788132, 'city', '0'),
('countries_switzerland_bern_niederwangen', 'ChIJn8p_9844jkcRRlL-AGZyoOA', 46.925556, 7.373889, 'city', '0'),
('countries_switzerland_bern_niederried', 'ChIJu9Jq6yW9j0cRYf4HOa73xTw', 46.71665, 7.92819, 'city', '1'),
('countries_switzerland_bern_niederoenz', 'ChIJf8aADpsqjkcRj-qsDHj8RZE', 47.1858406, 7.6942785, 'city', '1'),
('countries_switzerland_saint_gallen_untereggen', 'ChIJ9ypYwv8bm0cRlCWZjegMC5E', 47.4529863, 9.4499172, 'city', '1'),
('countries_switzerland_bern_niederhuenigen', 'ChIJ0yfeOl21j0cRWqOwDGvLcI8', 46.8773026, 7.6384848, 'city', '1'),
('countries_switzerland_bern_nidau', 'ChIJiep2boMZjkcRMby135B8Slk', 47.0935327, 7.2328515, 'city', '0'),
('countries_switzerland_bern_neuhaus', 'ChIJ69chTgKlj0cRUHwfPwfogWw', 46.6815697, 7.8146122, 'city', '0'),
('countries_switzerland_saint_gallen_uznach', 'ChIJM-P6KTPPmkcRZBydEgqD444', 47.2243722, 8.9841417, 'city', '1'),
('countries_switzerland_saint_gallen_uzwil', 'ChIJ-brxpIromkcRB7G-dN87yro', 47.4453738, 9.142239, 'city', '1'),
('countries_switzerland_bern_murzelen', 'ChIJqZ5FQd89jkcR2SviLUKO65Y', 46.98174, 7.31467, 'city', '0'),
('countries_switzerland_bern_munsingen', 'ChIJEzM5RRJKjkcRUwRMy7EHFFw', 46.8746813, 7.5627528, 'city', '1'),
('countries_switzerland_bern_munchenbuchsee', 'ChIJ4UWin-Q6jkcRx1Ep9tijktM', 47.021621, 7.450367, 'city', '1'),
('countries_switzerland_saint_gallen_wagen', 'ChIJkx4pkde3mkcRWQGibRYRWc8', 47.231038, 8.886397, 'city', '1'),
('countries_switzerland_saint_gallen_waldkirch', 'ChIJx1zfX97jmkcRvEzxeFjpHo0', 47.4684527, 9.2848801, 'city', '1'),
('countries_switzerland_saint_gallen_walenstadt', 'ChIJa8zKKpErm0cRtwHIzbDdQVA', 47.12398, 9.31603, 'city', '1'),
('countries_switzerland_bern_muhleberg', 'ChIJ3TLtv4EVjkcR8PBt6crk360', 46.9548447, 7.2624798, 'city', '1'),
('countries_switzerland_saint_gallen_wangs', 'ChIJZ78UYLnNhEcR85Fy2fk3YcI', 47.0299988, 9.4484028, 'city', '1'),
('countries_switzerland_saint_gallen_wattwil', 'ChIJ6et8otzEmkcRCWTT9ZcVGkU', 47.3031293, 9.0880638, 'city', '1'),
('countries_switzerland_saint_gallen_weesen', 'ChIJTX1Zk03SmkcR_Jju3cPMc1c', 47.1362592, 9.1052748, 'city', '1'),
('countries_switzerland_saint_gallen_weisstannen', 'ChIJOy5Oo9XThEcRwwfxl6R3yc4', 46.990556, 9.344444, 'city', '1'),
('countries_switzerland_bern_muentschemier', 'ChIJVVX02YARjkcRXZILpLDwufA', 46.9954572, 7.146079, 'city', '1'),
('countries_switzerland_saint_gallen_werdenberg', 'ChIJQxkzKNExm0cRDhtlc5Q9rJE', 47.168333, 9.463056, 'city', '1'),
('countries_switzerland_saint_gallen_widnau', 'ChIJ_xZBDZsWm0cRApQrKceHpnU', 47.4055145, 9.6375563, 'city', '1'),
('countries_switzerland_saint_gallen_wil', 'ChIJe88HocLrmkcRGxgF6PS_ziM', 47.4635617, 9.0479097, 'city', '1'),
('countries_switzerland_saint_gallen_wildhaus', 'ChIJB2JwErwom0cRQLHXQSzelWA', 47.2033339, 9.350492, 'city', '1'),
('countries_switzerland_saint_gallen_wittenbach', 'ChIJQxuEcOcdm0cRaYFex4vLyB0', 47.4598793, 9.3899899, 'city', '1'),
('countries_switzerland_bern_muenchringen', 'ChIJrSxnddkvjkcRRsrZtF3ObK0', 47.0461789, 7.5206904, 'city', '1'),
('countries_switzerland_bern_muenchenwiler', 'ChIJIRdAvdZsjkcRVAWTWn8PYK0', 46.9119937, 7.1260193, 'city', '0'),
('countries_switzerland_bern_muelenen', 'ChIJ2UHpYDapj0cRbzcoIrHaKDQ', 46.638506, 7.690773, 'city', '1'),
('countries_switzerland_saint_gallen_zuzwil', 'ChIJw2E8xy_pmkcRB1CItO-7FKI', 47.4750195, 9.111498, 'city', '1'),
('countries_switzerland_schaffhausen_bargen', 'ChIJ8du8iPyAkEcRp-W2iHK3M98', 47.7918763, 8.610205, 'city', '1'),
('countries_switzerland_schaffhausen_beggingen', 'ChIJlZZnTPh9kEcRkZi7Y_VXRSk', 47.7667072, 8.536764, 'city', '1'),
('countries_switzerland_schaffhausen_beringen', 'ChIJ2dwNyvyGmkcRuwaoTlz3aag', 47.6979625, 8.5736822, 'city', '1'),
('countries_switzerland_schaffhausen_buch', 'ChIJmeW6OA6HmkcRp9peFw_3wlw', 47.7180896, 8.7850713, 'city', '1'),
('countries_switzerland_schaffhausen_buchberg', 'ChIJ3YAwBaR3kEcRaXNYyiC8yn8', 47.5732503, 8.5627138, 'city', '1'),
('countries_switzerland_bern_muelchi', 'ChIJx9KtDrwljkcREOcYQIj_AAQ', 47.100968, 7.4772582, 'city', '1'),
('countries_switzerland_bern_muehledorf', 'ChIJVfAYIXgmjkcRRmdjw1s0N58', 47.13545, 7.477, 'city', '0'),
('countries_switzerland_schaffhausen_guntmadingen', 'ChIJVSSpEkt5kEcRYB0ZQIj_AAQ', 47.6858104, 8.5570314, 'city', '1'),
('countries_switzerland_schaffhausen_hallau', 'ChIJ0Q-HRk1jkEcRZHLje9eJQ-8', 47.6967786, 8.4574122, 'city', '1'),
('countries_switzerland_schaffhausen_hemishofen', 'ChIJF65DMB6GmkcR9ZDB1rK9y8I', 47.6768604, 8.8319084, 'city', '1'),
('countries_switzerland_schaffhausen_hemmental', 'ChIJ2wp9o2p-kEcRRMfqwfAQex0', 47.7334559, 8.5871553, 'city', '1'),
('countries_switzerland_schaffhausen_hofen', 'ChIJz2fjvY9_mkcRU7n-hrNzIEc', 47.7827356, 8.6769021, 'city', '1'),
('countries_switzerland_bern_morigen', 'ChIJjbiDnRkajkcR_Lqcbgxs3tM', 47.0854744, 7.2122756, 'city', '1'),
('countries_switzerland_schaffhausen_lohn', 'ChIJMeP6oPt_mkcRyju99NTj4gg', 47.7564818, 8.6706968, 'city', '1'),
('countries_switzerland_schaffhausen_merishausen', 'ChIJuyB9FNV_kEcRooCAanixQLI', 47.7606448, 8.6094638, 'city', '1'),
('countries_switzerland_bern_mont_soleil', 'ChIJqUZTA88AjkcR0bV4yw2fo3I', 47.1653, 6.98887, 'city', '0'),
('countries_switzerland_schaffhausen_neunkirch', 'ChIJ6eQ3Cnp8kEcR-LbmJT6toLQ', 47.6895225, 8.5004357, 'city', '1'),
('countries_switzerland_schaffhausen_oberhallau', 'ChIJGUUrYpN8kEcRW9YbFYJgHB8', 47.7056562, 8.4772173, 'city', '1'),
('countries_switzerland_schaffhausen_ramsen', 'ChIJQ5ae-bWHmkcRyKnaWSts9F8', 47.7069923, 8.8122279, 'city', '1'),
('countries_switzerland_bern_mont_crosin', 'ChIJxUFmwFQCjkcRbln2P1koSV8', 47.191111, 7.100278, 'city', '0'),
('countries_switzerland_schaffhausen_schaffhausen', 'ChIJDWW3FV5_kEcR50s-cJii498', 47.6958897, 8.6380489, 'city', '1'),
('countries_switzerland_schaffhausen_schleitheim', 'ChIJS50ckZ99kEcR21_ZAnUvcxs', 47.75009, 8.4868, 'city', '1'),
('countries_switzerland_schaffhausen_siblingen', 'ChIJ5ynQhDh8kEcRryLa3nElIVM', 47.7142798, 8.5199404, 'city', '1'),
('countries_switzerland_schaffhausen_stein_am_rhein', 'ChIJg-yExMyImkcRd7mW-tdDjOM', 47.6558193, 8.8579556, 'city', '1'),
('countries_switzerland_schaffhausen_stetten', 'ChIJqcO3X_V_kEcR5LWyxhs5N1M', 47.740257, 8.6628263, 'city', '1'),
('countries_switzerland_schaffhausen_thayngen', 'ChIJ_Sdz1oGAmkcRVC3LL0s4vTQ', 47.7476886, 8.7106201, 'city', '1'),
('countries_switzerland_schaffhausen_trasadingen', 'ChIJKVBlD8lkkEcRUE0ZQIj_AAQ', 47.6687, 8.42996, 'city', '1'),
('countries_switzerland_schaffhausen_wilchingen', 'ChIJXSzL5At7kEcRRvrA6uTj3S8', 47.66738, 8.46977, 'city', '1'),
('countries_switzerland_bern_monible', 'ChIJQUIPExHjkUcRuATT2KAYcw4', 47.27619, 7.20014, 'city', '0'),
('countries_switzerland_schwyz_alpthal', 'ChIJv8OFpRVMhUcRtPESQW3NXrc', 47.0710311, 8.715872, 'city', '1'),
('countries_switzerland_schwyz_altendorf', 'ChIJXWJXRIe2mkcRw1iEZCUYvKQ', 47.1914822, 8.8299043, 'city', '1'),
('countries_switzerland_schwyz_arth', 'ChIJJdQTrhlUhUcRojl2JtzTifQ', 47.06244, 8.5227308, 'city', '1'),
('countries_switzerland_schwyz_bennau', 'ChIJj80reA-zmkcRrCVojdmKLJg', 47.14833, 8.729719, 'city', '1'),
('countries_switzerland_bern_milken', 'ChIJbSLQDPlDjkcR9vKs0oT8QI8', 46.816667, 7.333333, 'city', '0'),
('countries_switzerland_bern_matten', 'ChIJizUjcX6jj0cRiiqYsrs8Quo', 46.6806354, 7.8666365, 'city', '0'),
('countries_switzerland_bern_mamishaus', 'ChIJDz27XTJEjkcR03u8wLTPZY8', 46.809543, 7.3791531, 'city', '0'),
('countries_switzerland_schwyz_einsiedeln', 'ChIJn5-RB0OzmkcR-zmZ5e0-VbE', 47.127353, 8.7451537, 'city', '1'),
('countries_switzerland_schwyz_euthal', 'ChIJFU6UVs9KhUcRtHaKApjDFdY', 47.1, 8.81667, 'city', '1'),
('countries_switzerland_schwyz_feusisberg', 'ChIJVQhdlLCzmkcRNUtSWpKn73Q', 47.1869781, 8.7469796, 'city', '1'),
('countries_switzerland_schwyz_freienbach', 'ChIJmddScVqxmkcRYGrYHA--85o', 47.2064107, 8.7565933, 'city', '1'),
('countries_switzerland_schwyz_galgenen', 'ChIJZ8fl_ADKmkcR6giBjjgBXjU', 47.1806828, 8.875679, 'city', '1'),
('countries_switzerland_schwyz_gersau', 'ChIJY0ypaDlXhUcR8OjmrXN44pg', 46.9918509, 8.5253552, 'city', '1'),
('countries_switzerland_schwyz_goldau', 'ChIJqfFk5lZRhUcRWhf618fGpQw', 47.048056, 8.549722, 'city', '1'),
('countries_switzerland_schwyz_gross', 'ChIJocJk9LS0mkcRTHIspwQfdho', 47.115, 8.775, 'city', '1'),
('countries_switzerland_bern_malleray', 'ChIJ-3XE1IzhkUcRGOVxuAQsubk', 47.238447, 7.2711449, 'city', '1'),
('countries_switzerland_schwyz_illgau', 'ChIJH5q12c1IhUcRQzf1alwNiVk', 46.9878459, 8.7250152, 'city', '1'),
('countries_switzerland_schwyz_immensee', 'ChIJYXoU0YFVhUcR8pt0ddBhsfM', 47.09675, 8.46299, 'city', '1'),
('countries_switzerland_schwyz_ingenbohl', 'ChIJ4dL6rkdQhUcRzsXfHtQgcw4', 46.9993722, 8.6096206, 'city', '1'),
('countries_switzerland_schwyz_innerthal', 'ChIJFcnUMTfLmkcR-HmHnBeDOLs', 47.1058989, 8.9188341, 'city', '1'),
('countries_switzerland_schwyz_kussnacht', 'ChIJW4UYk2j_j0cRn7lrsxjbuwY', 47.0843237, 8.4431621, 'city', '1'),
('countries_switzerland_schwyz_lachen', 'ChIJ1xzoXxK2mkcRVZenli4PvKY', 47.1934652, 8.8532083, 'city', '1'),
('countries_switzerland_schwyz_lauerz', 'ChIJMyRrbgtRhUcRAN8YQIj_AAQ', 47.03492, 8.58059, 'city', '1'),
('countries_switzerland_schwyz_merlischachen', 'ChIJA19ECiz_j0cRyeJIh7Ai7b8', 47.06586, 8.40831, 'city', '1'),
('countries_switzerland_schwyz_morschach', 'ChIJJ3sWo1VFhUcRUumytby7Yv8', 46.980165, 8.6175219, 'city', '1'),
('countries_switzerland_schwyz_muotathal', 'ChIJya7M3_43hUcRvA6ypHfdDM0', 46.9740171, 8.7622473, 'city', '1'),
('countries_switzerland_schwyz_nuolen', 'ChIJ--XbIeHJmkcRZZn7bkarKGQ', 47.199995, 8.883339, 'city', '1'),
('countries_switzerland_schwyz_oberarth', 'ChIJ3Tz4OQJUhUcREzcCaadWA-M', 47.0543, 8.536, 'city', '1'),
('countries_switzerland_schwyz_oberiberg', 'ChIJa4Ww6H9JhUcRH89gJZqbGaM', 47.0398727, 8.7820284, 'city', '1'),
('countries_switzerland_schwyz_reichenburg', 'ChIJWwhuDBLMmkcRXda236byHF8', 47.169773, 8.975433, 'city', '1'),
('countries_switzerland_schwyz_rothenthurm', 'ChIJmZ1CKWpNhUcR4pHQeK_Qbl4', 47.1029154, 8.6749618, 'city', '1'),
('countries_switzerland_schwyz_sattel', 'ChIJo1BvmGNShUcRIEMhbPqHjVs', 47.0831444, 8.6371165, 'city', '1'),
('countries_switzerland_bern_luescherz', 'ChIJXfoCEFwQjkcR5VlY8A_ywzI', 47.046686, 7.1515859, 'city', '1'),
('countries_switzerland_bern_lorraine', 'ChIJpZAxNu05jkcR2MJUtX0nJnc', 46.959023, 7.4435355, 'city', '0'),
('countries_switzerland_schwyz_schwyz', 'ChIJ7VS9qRtNhUcRdtxWrRvoCfE', 47.0207138, 8.6529884, 'city', '1'),
('countries_switzerland_bern_lobsigen', 'ChIJXYP-ZQw9jkcR-zqFTLt9zVM', 47.0355495, 7.3124338, 'city', '0'),
('countries_switzerland_schwyz_siebnen', 'ChIJkWEx9iLKmkcRBovuTS9EXps', 47.1744948, 8.897176, 'city', '1'),
('countries_switzerland_schwyz_steinen', 'ChIJ94PWqiZShUcRaIf1exaYWDs', 47.0495934, 8.613134, 'city', '1'),
('countries_switzerland_schwyz_steinerberg', 'ChIJE01D-MhThUcR2M6G85EBBcs', 47.0554331, 8.5865747, 'city', '1'),
('countries_switzerland_bern_le_fuet', 'ChIJgVv8pLjikUcRF-sCbwHhdCk', 47.2433, 7.18158, 'city', '0'),
('countries_switzerland_schwyz_studen', 'ChIJhTTuRn41hUcRnK8OA0hG24A', 47.0733277, 8.8381244, 'city', '1'),
('countries_switzerland_schwyz_trachslau', 'ChIJNZvACsBMhUcRrYZsjbz-VyQ', 47.098142, 8.725546, 'city', '1'),
('countries_switzerland_schwyz_tuggen', 'ChIJ-XFHJg3JmkcRWbeFqB8saQk', 47.2026436, 8.9423674, 'city', '1'),
('countries_switzerland_schwyz_unteriberg', 'ChIJa31qGwZKhUcR6lzhBYfOLqg', 47.0593246, 8.8019535, 'city', '1'),
('countries_switzerland_schwyz_vorderthal', 'ChIJYzAJkN_KmkcRsPfbPc6JeGc', 47.1207465, 8.9009568, 'city', '1'),
('countries_switzerland_schwyz_wangen', 'ChIJWZgaee_JmkcRMVgkKujytdU', 47.1863572, 8.8975312, 'city', '1'),
('countries_switzerland_bern_le_cerneux_veusil', 'ChIJEX34aZ8AjkcRSBKLddabvnY', 47.1801531, 6.9650665, 'city', '0'),
('countries_switzerland_schwyz_willerzell', 'ChIJs5Wii8K0mkcR8CgADDC7t_0', 47.129988, 8.793352, 'city', '1'),
('countries_switzerland_schwyz_wollerau', 'ChIJ39ACmSWymkcRepeJXISZX2o', 47.19717, 8.71338, 'city', '1'),
('countries_switzerland_solothurn_aedermannsdorf', 'ChIJ2T2rpI3QkUcRq_QROvC3Yo0', 47.3049231, 7.6101281, 'city', '1'),
('countries_switzerland_solothurn_aeschi', 'ChIJZxhKQWEqjkcRVpskcInGKwk', 47.1792344, 7.66213, 'city', '1'),
('countries_switzerland_solothurn_aetigkofen', 'ChIJCVwBIXgmjkcRpyepRF5Lln0', 47.1256, 7.46644, 'city', '1'),
('countries_switzerland_solothurn_aetingen', 'ChIJtSegAwcmjkcR1MKpx7F2YPU', 47.13237, 7.50601, 'city', '1'),
('countries_switzerland_bern_les_reussilles', 'ChIJbwKCiAoCjkcRvUOQNrK-lxs', 47.2293253, 7.087264, 'city', '0'),
('countries_switzerland_bern_lenk', 'ChIJ2R7TDtT8jkcRIlk6GRVxpfU', 46.4571943, 7.4429104, 'city', '1'),
('countries_switzerland_solothurn_balm_bei_messen', 'ChIJkYBp-WgkjkcRMIdqT_Z2V9c', 47.103639, 7.431191, 'city', '1'),
('countries_switzerland_solothurn_balsthal', 'ChIJ4UqrMFLSkUcRSg6etwV7_TQ', 47.3095856, 7.6883283, 'city', '1'),
('countries_switzerland_bern_la_tanne', 'ChIJ0XsSN1MdjkcRNA7Xo0KQI78', 47.2199857, 7.1600072, 'city', '0'),
('countries_switzerland_solothurn_beinwil', 'ChIJ7RcEk_zPkUcRF8UdGxKF_-4', 47.3626529, 7.5881875, 'city', '1'),
('countries_switzerland_solothurn_bellach', 'ChIJNU9v_XLYkUcRrnQ3IdK7w_k', 47.2130237, 7.5002095, 'city', '1'),
('countries_switzerland_solothurn_bettlach', 'ChIJU6nZF6EgjkcRhvw0mJs_lnI', 47.2026836, 7.4241066, 'city', '1'),
('countries_switzerland_solothurn_biberist', 'ChIJR98jHzwojkcRmVzVv1PKb38', 47.1818339, 7.5577799, 'city', '1'),
('countries_switzerland_bern_la_heutte', 'ChIJfYHvF7cdjkcRoOQYQIj_AAQ', 47.1902134, 7.2266479, 'city', '1'),
('countries_switzerland_solothurn_biezwil', 'ChIJC1p0WfUjjkcR5xwpuSu2_3s', 47.1138493, 7.4172105, 'city', '1'),
('countries_switzerland_solothurn_bolken', 'ChIJo-l9CIoqjkcRq1aClFBA8b8', 47.1932873, 7.6631946, 'city', '1'),
('countries_switzerland_solothurn_boningen', 'ChIJS-6ZUGEukEcRnjww7XV86c0', 47.306647, 7.8563888, 'city', '1'),
('countries_switzerland_solothurn_breitenbach', 'ChIJ08g1vLPFkUcRXGMNuIgbp6g', 47.4078254, 7.5438767, 'city', '1'),
('countries_switzerland_bern_la_ferriere', 'ChIJBw8m3Db8jUcRkOQYQIj_AAQ', 47.1418557, 6.8931182, 'city', '1'),
('countries_switzerland_solothurn_brunnenthal', 'ChIJbc6qRwYljkcRb1r8P5MEblU', 47.0866466, 7.468138, 'city', '1'),
('countries_switzerland_solothurn_buchegg', 'ChIJp83lm3EmjkcR-wzKjLOQOIE', 47.1361486, 7.4770152, 'city', '1'),
('countries_switzerland_bern_latterbach', 'ChIJQywDTzFTjkcRYzpGC4eGAyA', 46.6699378, 7.5714565, 'city', '1'),
('countries_switzerland_bern_lanzenhaeusern', 'ChIJ99JfXcpGjkcRL32Tu3kL_Cg', 46.844863, 7.3523805, 'city', '1'),
('countries_switzerland_solothurn_deitingen', 'ChIJHb_Jb23WkUcRPbxG5kIkOvA', 47.21378, 7.62088, 'city', '1'),
('countries_switzerland_solothurn_derendingen', 'ChIJT44IEdopjkcR8BMZQIj_AAQ', 47.1952433, 7.5855931, 'city', '1'),
('countries_switzerland_solothurn_dornach', 'ChIJTZ_6LVvIkUcRFnMtkAG6HOU', 47.4790491, 7.6170412, 'city', '1'),
('countries_switzerland_solothurn_dulliken', 'ChIJX8xQ6AswkEcRzdpZAtI33Bo', 47.3492274, 7.944903, 'city', '1'),
('countries_switzerland_solothurn_egerkingen', 'ChIJMT1POHMtkEcR9QIc-hUv0_g', 47.3214014, 7.7936947, 'city', '1'),
('countries_switzerland_solothurn_erlinsbach', 'ChIJ3yvrUR86kEcR8Ar7Iww_nmQ', 47.3982991, 8.008368, 'city', '1'),
('countries_switzerland_solothurn_erschwil', 'ChIJXd56ljvFkUcRz5iMjESKJCY', 47.3732135, 7.5411714, 'city', '1'),
('countries_switzerland_solothurn_etziken', 'ChIJC41uXA4qjkcRZoY5fgxJv9c', 47.1876571, 7.6484106, 'city', '1'),
('countries_switzerland_solothurn_fehren', 'ChIJ0cfQ64PFkUcRt6L_BOA4jPY', 47.3964567, 7.5791849, 'city', '1'),
('countries_switzerland_bern_langnau', 'ChIJcTPUKDHPj0cREzOY7y0h7R8', 46.9378622, 7.7906824, 'city', '1'),
('countries_switzerland_solothurn_flueh', 'ChIJV0AogCzBkUcRqdvoQTVZAMg', 47.4769723, 7.5117799, 'city', '1'),
('countries_switzerland_solothurn_flumenthal', 'ChIJrYaHPrLXkUcRi4VyAtbnQ_U', 47.2354685, 7.5978716, 'city', '1'),
('countries_switzerland_solothurn_fulenbach', 'ChIJLVYCHCQskEcRSXmkS5di2JY', 47.277499, 7.8363651, 'city', '1'),
('countries_switzerland_solothurn_gempen', 'ChIJDcl3I6zJkUcRwQiG4bNETwM', 47.475503, 7.6588368, 'city', '1'),
('countries_switzerland_solothurn_gerlafingen', 'ChIJRym_rk0ojkcRdXXE3swDKOo', 47.1707295, 7.5731416, 'city', '1'),
('countries_switzerland_bern_laetti', 'ChIJq4Ff1SQ7jkcR_W59MK1E-WE', 47.0392518, 7.4307744, 'city', '0'),
('countries_switzerland_solothurn_grenchen', 'ChIJmTHiMoTfkUcRPZSHSF_zxo8', 47.1922876, 7.3958907, 'city', '1'),
('countries_switzerland_solothurn_gretzenbach', 'ChIJ-SZIVuQ6kEcRmXAet0qC__U', 47.3603017, 7.9951019, 'city', '1'),
('countries_switzerland_solothurn_grindel', 'ChIJRwsz-pXEkUcR9gwYHM3T5mE', 47.3816819, 7.5018167, 'city', '1'),
('countries_switzerland_bern_kraeiligen', 'ChIJE4RxYJAojkcRHFnWieAazIo', 47.1501984, 7.5322398, 'city', '0'),
('countries_switzerland_solothurn_gunzgen', 'ChIJ7UpKr8UtkEcR7ELm29W8UcY', 47.3134764, 7.8438305, 'city', '1'),
('countries_switzerland_bern_kiental', 'ChIJa8b2M2qoj0cRULpv7Rl-hmI', 46.587988, 7.723818, 'city', '1'),
('countries_switzerland_bern_kaltacker', 'ChIJTytX2dgsjkcRl4kCM8IEbV4', 47.0768221, 7.6722048, 'city', '0'),
('countries_switzerland_solothurn_halten', 'ChIJzbaiNo8pjkcRGju-4ltYiNc', 47.1703736, 7.6035786, 'city', '1'),
('countries_switzerland_bern_innerberg', 'ChIJh4xmH-w9jkcRE-HZANT6IoU', 46.9961738, 7.306362, 'city', '1'),
('countries_switzerland_bern_hunibach', 'ChIJC5EaKGayj0cRTpjrp8skCWU', 46.7439605, 7.6472306, 'city', '0'),
('countries_switzerland_solothurn_herbetswil', 'ChIJGyZ8fqHQkUcRaA2JTMEXNCQ', 47.2957401, 7.5922803, 'city', '1'),
('countries_switzerland_bern_horboden', 'ChIJd5H0s8lUjkcRS8kmtLSxJu8', 46.6322, 7.56108, 'city', '0'),
('countries_switzerland_solothurn_himmelried', 'ChIJ-949-lfPkUcRcBcZQIj_AAQ', 47.42219, 7.59808, 'city', '1'),
('countries_switzerland_solothurn_hochwald', 'ChIJz--yQeHIkUcRgBIZQIj_AAQ', 47.4574646, 7.6431883, 'city', '1'),
('countries_switzerland_bern_hondrich', 'ChIJUdQ6cJuuj0cRGtboWSEdu0E', 46.6724309, 7.6805735, 'city', '0'),
('countries_switzerland_solothurn_holderbank', 'ChIJXXVcOLLSkUcRXJ2DhbAcG7w', 47.3324218, 7.752904, 'city', '1'),
('countries_switzerland_solothurn_horriwil', 'ChIJ9Yk2_BsqjkcRFJi3QMW4VqI', 47.1818497, 7.6220212, 'city', '1'),
('countries_switzerland_solothurn_hubersdorf', 'ChIJw0pd9f3WkUcRPivqDh5btrs', 47.2433149, 7.5885493, 'city', '1'),
('countries_switzerland_bern_hohfluh', 'ChIJLx9LJeuOj0cRz6oWrqVUWTU', 46.7500962, 8.1763261, 'city', '0'),
('countries_switzerland_solothurn_ifenthal', 'ChIJv4GHnX8xkEcR340pyMtvZc8', 47.37794, 7.87245, 'city', '1'),
('countries_switzerland_solothurn_kappel', 'ChIJu9gEEAwukEcRaUDY48AyJ5g', 47.3236397, 7.8463216, 'city', '1'),
('countries_switzerland_solothurn_kestenholz', 'ChIJnXN3hroskEcROklzjYLMit4', 47.2822798, 7.7525681, 'city', '1'),
('countries_switzerland_solothurn_kienberg', 'ChIJxXo1dnA3kEcRUdlKQLe_nI8', 47.4396888, 7.96617, 'city', '1'),
('countries_switzerland_bern_hinterkappelen', 'ChIJUalF1ic8jkcRYNBXdJaqX2M', 46.9704283, 7.3658552, 'city', '0'),
('countries_switzerland_solothurn_kriegstetten', 'ChIJI3T2X5QpjkcR5stOHbycHy0', 47.1746615, 7.5980626, 'city', '1'),
('countries_switzerland_bern_hinterfultigen', 'ChIJlZxPi2dGjkcR55ZB2kYACQc', 46.83845, 7.40028, 'city', '0'),
('countries_switzerland_solothurn_langendorf', 'ChIJqYKQTxXYkUcR0jixNieLRnQ', 47.2216911, 7.514949, 'city', '1'),
('countries_switzerland_solothurn_laupersdorf', 'ChIJBySrOn_RkUcRsBAZQIj_AAQ', 47.3118615, 7.6520415, 'city', '1'),
('countries_switzerland_solothurn_lommiswil', 'ChIJhZbx85PYkUcRT3u0-ZPhY9g', 47.2252887, 7.4724793, 'city', '1'),
('countries_switzerland_solothurn_lostorf', 'ChIJ8aT-MOgwkEcRMaNgSioYiIg', 47.3842634, 7.9489303, 'city', '1'),
('countries_switzerland_bern_heubach', 'ChIJcUUY3lBFjkcRsVAwuyVlpPM', 46.7812793, 7.4056793, 'city', '0'),
('countries_switzerland_bern_hettiswil', 'ChIJlWBdTMIxjkcRR1V1QbUQ-H0', 47.0315861, 7.5584236, 'city', '0'),
('countries_switzerland_bern_herrenschwanden', 'ChIJNVPz2NY7jkcR8124pal5WFk', 46.9782263, 7.4177845, 'city', '0'),
('countries_switzerland_solothurn_luterbach', 'ChIJl1keMzTWkUcRtAThLFc32j4', 47.2159256, 7.5875125, 'city', '1'),
('countries_switzerland_bern_helgisried', 'ChIJmyoeRv5FjkcRWmQIoFOoFQs', 46.8160149, 7.4273876, 'city', '0'),
('countries_switzerland_solothurn_matzendorf', 'ChIJpaxBFQHRkUcRg3qcDA9sUdY', 47.3072865, 7.6284177, 'city', '1'),
('countries_switzerland_solothurn_meltingen', 'ChIJFTLU9I7PkUcROVAiDumDhJc', 47.3880797, 7.589463, 'city', '1'),
('countries_switzerland_solothurn_messen', 'ChIJMwwuyFUkjkcR0BEZQIj_AAQ', 47.0917018, 7.447381, 'city', '1'),
('countries_switzerland_bern_heimisbach', 'ChIJMU9KyebNj0cRnJjj32_nLQA', 47.0078, 7.74937, 'city', '0'),
('countries_switzerland_bern_heimenschwand', 'ChIJkSDJskG0j0cRPtpSpYUDALA', 46.8285368, 7.6954614, 'city', '0'),
('countries_switzerland_bern_hasle', 'ChIJe3p_pnTpj0cRttGiXN9Ruks', 46.9800466, 8.0538414, 'city', '0'),
('countries_switzerland_solothurn_nennigkofen', 'ChIJs3NrrLwnjkcRpkQbZbBCBVg', 47.1875806, 7.4943821, 'city', '1'),
('countries_switzerland_solothurn_neuendorf', 'ChIJ8xxvA1QskEcR3WsYmvgwidw', 47.2982329, 7.7963378, 'city', '1'),
('countries_switzerland_solothurn_niederbuchsiten', 'ChIJxa0Tk-4skEcRqYzLes9gyDs', 47.2970819, 7.7713269, 'city', '1'),
('countries_switzerland_bern_haeutligen', 'ChIJ866bGOhKjkcRXDCtuuSCrfM', 46.8574434, 7.6054411, 'city', '1'),
('countries_switzerland_bern_haeusernmoos', 'ChIJgYbEE7w3jkcRkG_xhC_zgRI', 46.9169546, 7.4858668, 'city', '0'),
('countries_switzerland_solothurn_nunningen', 'ChIJk6XTdqfPkUcRtzrje2ixORw', 47.3934555, 7.619469, 'city', '1'),
('countries_switzerland_solothurn_oberbuchsiten', 'ChIJsUHhXdHSkUcR0n6n_oFNECI', 47.3093912, 7.7658565, 'city', '1'),
('countries_switzerland_solothurn_oberdorf', 'ChIJmzfxDE_YkUcRFwKQmJvCby0', 47.2306972, 7.5014054, 'city', '1'),
('countries_switzerland_solothurn_obergerlafingen', 'ChIJ_2oHrqcpjkcRUnyw40-w9FI', 47.1614, 7.58404, 'city', '1'),
('countries_switzerland_bern_gysenstein', 'ChIJqdT1p3g1jkcR9r_dOsJ3emA', 46.8901783, 7.5914805, 'city', '0'),
('countries_switzerland_solothurn_oberramsern', 'ChIJ_3M5VDMkjkcRABIZQIj_AAQ', 47.1143047, 7.4625737, 'city', '1'),
('countries_switzerland_solothurn_oberwil', 'ChIJrWxJ8p64kUcReGFF_5M4_fU', 47.5159745, 7.5582003, 'city', '1'),
('countries_switzerland_solothurn_oekingen', 'ChIJz70T5_IpjkcRYb3lwNO9aK4', 47.1795032, 7.6042776, 'city', '1'),
('countries_switzerland_solothurn_oensingen', 'ChIJF7vIJUHTkUcRcOVWNvXy6hQ', 47.2902794, 7.7158736, 'city', '1'),
('countries_switzerland_solothurn_olten', 'ChIJIWhFWiwwkEcRsU0fs5l9A8A', 47.3499624, 7.9037034, 'city', '1'),
('countries_switzerland_solothurn_recherswil', 'ChIJz_MrIYMpjkcR2NLyRH-Ot-w', 47.1624829, 7.5937492, 'city', '1'),
('countries_switzerland_solothurn_riedholz', 'ChIJ8QDHAqPXkUcRG0keSysg6XY', 47.2301841, 7.5653554, 'city', '1'),
('countries_switzerland_solothurn_rodersdorf', 'ChIJLW74ZEvAkUcRwBIZQIj_AAQ', 47.4803913, 7.4566086, 'city', '1'),
('countries_switzerland_solothurn_rohr', 'ChIJqZYUFUs3kEcRxzec67HNPPU', 47.4096336, 7.9547519, 'city', '1'),
('countries_switzerland_bern_gurbrue', 'ChIJ1XjJRkEUjkcRSUATbKNvDWU', 46.9645548, 7.2139233, 'city', '1'),
('countries_switzerland_bern_gummenen', 'ChIJIRfhRggVjkcR_yFxhjUCY80', 46.94485, 7.24385, 'city', '1'),
('countries_switzerland_bern_gumligen', 'ChIJeRpXcAU3jkcRLOe9-54qMJQ', 46.9350521, 7.4984728, 'city', '0'),
('countries_switzerland_solothurn_schnottwil', 'ChIJgXBgnJUjjkcRZPbyJqk0u60', 47.1110436, 7.3908496, 'city', '1'),
('countries_switzerland_bern_gsteig', 'ChIJoWxQ_OXujkcRhyEjEO3Ur6U', 46.3852631, 7.267346, 'city', '1'),
('countries_switzerland_bern_gstaad', 'ChIJhYExcK_xjkcRVtVU8TrP36Y', 46.4717588, 7.2865728, 'city', '0'),
('countries_switzerland_solothurn_selzach', 'ChIJccr9bLLYkUcRF1zLpK4bSfg', 47.2048271, 7.4542951, 'city', '1'),
('countries_switzerland_solothurn_solothurn', 'ChIJR3O5lfDXkUcRqRONVOYOqZY', 47.2088348, 7.532291, 'city', '1'),
('countries_switzerland_bern_grund', 'ChIJXWpgPxBFj0cRYpZnTweSdbQ', 46.1229266, 7.9365532, 'city', '0'),
('countries_switzerland_solothurn_steinhof', 'ChIJ3ycmh-cqjkcR0BQZQIj_AAQ', 47.1614217, 7.6870653, 'city', '1'),
('countries_switzerland_bern_gruenenmatt', 'ChIJEdo-_qPNj0cRyURZPi5qtyQ', 47.0078145, 7.7235891, 'city', '0'),
('countries_switzerland_solothurn_subingen', 'ChIJdc8nvAfWkUcRkX3pbjnM-qQ', 47.195658, 7.6140497, 'city', '1'),
('countries_switzerland_solothurn_trimbach', 'ChIJWb6eE0ExkEcRpcAwTHnBnS4', 47.3639385, 7.9040922, 'city', '1'),
('countries_switzerland_bern_gruenen', 'ChIJISHww8A5jkcREGAqYO8eR-E', 46.948933, 7.4443008, 'city', '1'),
('countries_switzerland_bern_gross_hochstetten', 'ChIJwSx5ETE1jkcRvAaEHpUZiQg', 46.9067025, 7.638022, 'city', '1'),
('countries_switzerland_solothurn_unterramsern', 'ChIJdziAaM4ljkcRNtqo8M62A94', 47.1190943, 7.4822579, 'city', '1'),
('countries_switzerland_bern_grasswil', 'ChIJmSznwQUrjkcRd8m_b_JCG_Q', 47.14525, 7.66676, 'city', '0'),
('countries_switzerland_solothurn_welschenrohr', 'ChIJXyDcHGXZkUcRNtyr35zmI3g', 47.28078, 7.5278296, 'city', '1'),
('countries_switzerland_bern_gohl', 'ChIJkS_Zfj3Pj0cR4EhI8v0I7-o', 46.9723011, 7.823258, 'city', '0'),
('countries_switzerland_solothurn_winznau', 'ChIJS9ICpFcwkEcRus-TraMEpMQ', 47.3646619, 7.9337108, 'city', '1'),
('countries_switzerland_solothurn_wisen', 'ChIJZZWmIUIxkEcRoBMZQIj_AAQ', 47.3929646, 7.8869345, 'city', '1'),
('countries_switzerland_solothurn_witterswil', 'ChIJDfhrBzvHkUcRpMqNqqtIc_0', 47.4859888, 7.5226262, 'city', '1'),
('countries_switzerland_bern_gimmiz', 'ChIJ-VePEGgXjkcRkX0H1TFSq28', 47.05536, 7.23463, 'city', '0'),
('countries_switzerland_solothurn_wolfwil', 'ChIJ7YrnonsskEcRKZgAtTQwVXU', 47.2694021, 7.7955511, 'city', '1'),
('countries_switzerland_solothurn_zuchwil', 'ChIJD14MgODXkUcRPFvkZLeTcHg', 47.203546, 7.5579858, 'city', '1'),
('countries_switzerland_solothurn_zullwil', 'ChIJhTnlJZnPkUcRtPIk09VER7E', 47.3911661, 7.5998324, 'city', '1'),
('countries_switzerland_thurgau_aadorf', 'ChIJMdIBoIiTmkcRsFEZQIj_AAQ', 47.4884348, 8.9035411, 'city', '1'),
('countries_switzerland_thurgau_affeltrangen', 'ChIJ1xmaz1TsmkcRHuJK8W5-Fts', 47.5269436, 9.030771, 'city', '1'),
('countries_switzerland_thurgau_alterswilen', 'ChIJuYG5fCLxmkcR8sjQDhcknkQ', 47.616667, 9.15, 'city', '1'),
('countries_switzerland_thurgau_altishausen', 'ChIJL7Z9EfHwmkcRpNxxpkhAXl8', 47.601244, 9.170644, 'city', '1'),
('countries_switzerland_thurgau_altnau', 'ChIJecZTOMn7mkcRruhZrinp3X4', 47.6106454, 9.2573197, 'city', '1'),
('countries_switzerland_thurgau_amlikon', 'ChIJ2QevEHrymkcRdouRbbqLSeA', 47.569722, 9.0560809, 'city', '1'),
('countries_switzerland_thurgau_amriswil', 'ChIJuZ721Kz8mkcRwFAZQIj_AAQ', 47.5449717, 9.3002409, 'city', '1'),
('countries_switzerland_thurgau_andhausen', 'ChIJVUKICGzwmkcRNTWWwfcxOsw', 47.5784995, 9.1778125, 'city', '1'),
('countries_switzerland_thurgau_arbon', 'ChIJz-AsGEsDm0cR9Zxn2Toib2M', 47.5140905, 9.4268301, 'city', '1'),
('countries_switzerland_bern_gerolfingen', NULL, 0, 0, 'city', '0'),
('countries_switzerland_thurgau_basadingen', 'ChIJ3YcsPR6EmkcRrEH_Gl7y03Y', 47.666667, 8.75, 'city', '1'),
('countries_switzerland_thurgau_berg', 'ChIJS4THg0LwmkcRI-MJ1NL49ns', 47.5796808, 9.1671277, 'city', '1'),
('countries_switzerland_thurgau_berlingen', 'ChIJj-Ts9TSLmkcRSNJOOMwCCYY', 47.6741319, 9.0192378, 'city', '1'),
('countries_switzerland_thurgau_bettwiesen', 'ChIJ_cXo2YjsmkcRL4d4cE_5DaQ', 47.4958846, 9.0255851, 'city', '1'),
('countries_switzerland_thurgau_bichelsee', 'ChIJbT0xAiKVmkcRa4dx-IK3AnE', 47.45, 8.933333, 'city', '1'),
('countries_switzerland_thurgau_biessenhofen', 'ChIJ9xBo-srkmkcRElQv-SPLFXI', 47.54544, 9.25877, 'city', '1'),
('countries_switzerland_thurgau_birwinken', 'ChIJcWGMJ_T6mkcRnVks-AZtNXc', 47.5776679, 9.2064886, 'city', '1'),
('countries_switzerland_thurgau_bischofszell', 'ChIJb-gERDjkmkcRugU5C4TSegk', 47.4927034, 9.2436496, 'city', '1'),
('countries_switzerland_thurgau_bissegg', 'ChIJuW3PLH_ymkcRsZmX3mZdpO0', 47.566667, 9.05, 'city', '1'),
('countries_switzerland_bern_gasel', 'ChIJ0XxBJYE4jkcRuYSU-wAGOMQ', 46.901229, 7.402833, 'city', '1'),
('countries_switzerland_thurgau_bottighofen', 'ChIJMz_-MVb3mkcRzwoemixBcf4', 47.6356004, 9.2095187, 'city', '1'),
('countries_switzerland_thurgau_braunau', 'ChIJR_K5gx_smkcRxTUn6oEWYOs', 47.5027707, 9.0722417, 'city', '1'),
('countries_switzerland_bern_gambach', 'ChIJy76yvKVFjkcRNECg4nqjHvc', 46.7765827, 7.3801934, 'city', '0'),
('countries_switzerland_thurgau_buhwil', 'ChIJPU6qPpDvmkcRV90HIigFCqA', 47.527169, 9.165989, 'city', '1'),
('countries_switzerland_bern_frinvillier', 'ChIJcUK9lJEejkcRkkDMYkEXBTY', 47.169073, 7.2568416, 'city', '0'),
('countries_switzerland_thurgau_bussnang', 'ChIJc188G_ztmkcRInRFGE_lGNw', 47.5574575, 9.0830063, 'city', '1'),
('countries_switzerland_thurgau_dettighofen', 'ChIJaQVz-E2MmkcRD95vruqJeGs', 47.616664, 8.948536, 'city', '1'),
('countries_switzerland_thurgau_diessenhofen', 'ChIJ8bV1hKSGmkcRFFDrGwNsPNM', 47.6895309, 8.7494398, 'city', '1'),
('countries_switzerland_bern_felsenau', 'ChIJDQqsbiE6jkcRkolog2KxEdg', 46.9729483, 7.4407539, 'city', '0'),
('countries_switzerland_thurgau_dozwil', 'ChIJ0yr9Vov8mkcRhmYyYJDq19c', 47.5759808, 9.3199786, 'city', '1'),
('countries_switzerland_thurgau_dussnang', 'ChIJY7aGQKHqmkcRRWCRO7qbKSA', 47.416662, 8.966668, 'city', '1'),
('countries_switzerland_thurgau_egnach', 'ChIJXaoge1X9mkcRRqcV6gFKDQg', 47.5287304, 9.3698905, 'city', '1'),
('countries_switzerland_thurgau_ellighausen', 'ChIJI0wQ7hTxmkcR-ikZYpz0Iu8', 47.613889, 9.135556, 'city', '1'),
('countries_switzerland_bern_fankhaus', 'ChIJn2r79kXEj0cRqCl6OLp7pWE', 46.96644, 7.90796, 'city', '0'),
('countries_switzerland_bern_enggistein', 'ChIJVcpnS1c0jkcRNgy1XYbYlKo', 46.93211, 7.59689, 'city', '0'),
('countries_switzerland_bern_emmenmatt', 'ChIJR_tjnBzMj0cRn72xM7eFm1U', 46.9667076, 7.7498972, 'city', '0'),
('countries_switzerland_bern_emdthal', 'ChIJq-NDMLeuj0cR2iVwzYOqXkY', 46.65273, 7.68672, 'city', '0'),
('countries_switzerland_thurgau_erlen', 'ChIJFSkDrtP6mkcRvjDoESh1IVU', 47.5518448, 9.2265297, 'city', '1'),
('countries_switzerland_thurgau_ermatingen', 'ChIJrRVwG2v0mkcRxqt4z726CmE', 47.669301, 9.0799371, 'city', '1'),
('countries_switzerland_thurgau_eschenz', 'ChIJmbfBoRuPmkcRl_Uj12_84rU', 47.648154, 8.8733916, 'city', '1'),
('countries_switzerland_thurgau_eschikofen', 'ChIJdelAdbHymkcR6COV6061TS4', 47.5805, 9.0065001, 'city', '1'),
('countries_switzerland_thurgau_eschlikon', 'ChIJe8Hzy9KUmkcRD22u8zOeVmk', 47.463985, 8.9667384, 'city', '1'),
('countries_switzerland_bern_einigen', 'ChIJqfRHDJmtj0cRaJEoULjId5U', 46.70923, 7.64521, 'city', '0'),
('countries_switzerland_bern_dieterswil', 'ChIJgY_BQ8okjkcRuxDTeA6wWE8', 47.0552906, 7.4257551, 'city', '1'),
('countries_switzerland_thurgau_felben', 'ChIJfbq-GI6NmkcROIQRrOddZJQ', 47.583333, 8.933333, 'city', '1'),
('countries_switzerland_thurgau_fischingen', 'ChIJNyF14anqmkcRHpnEnv3JItM', 47.4152394, 8.9692231, 'city', '1'),
('countries_switzerland_thurgau_frasnacht', 'ChIJt4LEoDcdm0cRUw2Vm2JcWq8', 47.5274, 9.4058, 'city', '1'),
('countries_switzerland_thurgau_frauenfeld', 'ChIJ1RbEeiuSmkcRx41zSozq1as', 47.5535997, 8.8987541, 'city', '1'),
('countries_switzerland_bern_diessbach', 'ChIJIfFDy08ijkcRaisWr0zv0Z4', 47.1079225, 7.3617601, 'city', '1'),
('countries_switzerland_thurgau_fruthwilen', 'ChIJ1RqRuoz0mkcRW3qGJI_BELQ', 47.661717, 9.067197, 'city', '1'),
('countries_switzerland_thurgau_gachnang', 'ChIJp6-KE66RmkcRtWd3SPaC3NQ', 47.5389694, 8.8529088, 'city', '1'),
('countries_switzerland_thurgau_gerlikon', 'ChIJbZg6WXiRmkcRoNnv1gzXFZo', 47.537, 8.877, 'city', '1'),
('countries_switzerland_bern_detligen', 'ChIJ47v9vxUWjkcR4HVobgv3fSI', 47.0017758, 7.2725302, 'city', '1'),
('countries_switzerland_thurgau_gottlieben', 'ChIJK6hQGZ32mkcRvTebS6ONa_c', 47.6635399, 9.1348964, 'city', '1'),
('countries_switzerland_bern_deisswil', 'ChIJK5rO-No6jkcRrJNpOkbdWgw', 47.0344955, 7.4557248, 'city', '1'),
('countries_switzerland_bern_cremines', 'ChIJVR4f9P_bkUcRsQyVuhzf9Mw', 47.2833568, 7.4397343, 'city', '1'),
('countries_switzerland_bern_cortebert', 'ChIJJUC9I_0CjkcRlR1lV-qZRNE', 47.1906661, 7.1070771, 'city', '1'),
('countries_switzerland_bern_corgemont', 'ChIJRRxArygDjkcRKymRpK4ow30', 47.1938407, 7.1416277, 'city', '1'),
('countries_switzerland_bern_butzberg', 'ChIJhVb7OJUqkEcRr8BaQs7v9uk', 47.216206, 7.7485408, 'city', '0'),
('countries_switzerland_bern_busswil', 'ChIJV9tdCX4ijkcRUOAYQIj_AAQ', 47.0994015, 7.3211978, 'city', '1'),
('countries_switzerland_thurgau_herdern', 'ChIJH4Yok9KNmkcRRvrGPX3TpmE', 47.6049437, 8.9099908, 'city', '1'),
('countries_switzerland_thurgau_hohentannen', 'ChIJBYoua_7kmkcREFEZQIj_AAQ', 47.5076615, 9.2249248, 'city', '1'),
('countries_switzerland_thurgau_homburg', 'ChIJkWrsYo2MmkcRsxoTXLLeJx0', 47.6346352, 9.0057345, 'city', '1'),
('countries_switzerland_bern_buren_an_der_aare', 'ChIJY9G3G4IhjkcRFDkXyphD8fU', 47.1395743, 7.3747968, 'city', '1'),
('countries_switzerland_thurgau_hugelshofen', 'ChIJz7uSVp3xmkcRIFTuyS8Tq6E', 47.59875, 9.116497, 'city', '1'),
('countries_switzerland_bern_bumpliz', 'ChIJYwp2fN84jkcRTBdnKlhMphk', 46.940063, 7.3902924, 'city', '0'),
('countries_switzerland_bern_bueren_zum_hof', 'ChIJB-Ah-mIvjkcRkORsf5xxlhE', 47.09575, 7.5138388, 'city', '1'),
('countries_switzerland_bern_buehl_b_aarberg', 'ChIJZdoArdkZjkcRcfXUN8rdbJs', 47.0706726, 7.2444978, 'city', '1'),
('countries_switzerland_thurgau_illighausen', 'ChIJ9wsp_Hb6mkcRu3EYn2rChN4', 47.604167, 9.208056, 'city', '1'),
('countries_switzerland_thurgau_islikon', 'ChIJzb90hauRmkcRdnYE6Y1R1Bo', 47.545641, 8.8437189, 'city', '1'),
('countries_switzerland_bern_bueetigen', 'ChIJ06-AW2YijkcRdI3-vPxFE2Y', 47.1059985, 7.3403328, 'city', '1'),
('countries_switzerland_bern_bruttelen', 'ChIJF48CGKkRjkcRsr_m-kqeWv0', 47.0218657, 7.1478802, 'city', '1'),
('countries_switzerland_thurgau_kesswil', 'ChIJmz5yb238mkcRa7IMpsrAF_o', 47.5935362, 9.3177304, 'city', '1'),
('countries_switzerland_bern_bremgarten', 'ChIJUXMxRtIRkEcR7JqSDwxjeRg', 47.3491774, 8.3397905, 'city', '0'),
('countries_switzerland_bern_bonigen', 'ChIJVVk3PeSij0cR9UzwvPDJWHw', 46.6859659, 7.8932422, 'city', '1'),
('countries_switzerland_thurgau_kreuzlingen', 'ChIJbaYMOi73mkcR8ta5PmLku_I', 47.6447397, 9.1707858, 'city', '1'),
('countries_switzerland_thurgau_landschlacht', 'ChIJp5SxQSj6mkcRIXYjHQ4OPMA', 47.62639, 9.25075, 'city', '1'),
('countries_switzerland_thurgau_langrickenbach', 'ChIJZcHfrVP6mkcROw_9mLussvQ', 47.5934886, 9.2472569, 'city', '1'),
('countries_switzerland_bern_boll', 'ChIJDfLPJ7s2jkcRwzE42nM0N5Q', 46.9541076, 7.5486699, 'city', '0'),
('countries_switzerland_bern_bleiken', 'ChIJXXM85Li0j0cRISHltf-pc-M', 46.81367, 7.6406329, 'city', '1'),
('countries_switzerland_bern_bigenthal', 'ChIJX-KbEp40jkcRwsP8AOi3I2k', 46.9479693, 7.620415, 'city', '0'),
('countries_switzerland_thurgau_lengwil', 'ChIJ8R2URZ_wmkcRs-zj1j8qsA0', 47.6185527, 9.1931347, 'city', '1'),
('countries_switzerland_bern_bevilard', 'ChIJ__Tklr3hkUcRchhRNJrH4f0', 47.23717, 7.2866, 'city', '0'),
('countries_switzerland_thurgau_lommis', 'ChIJZQshi8_smkcRu3rEfd676es', 47.5174443, 8.9946912, 'city', '1'),
('countries_switzerland_thurgau_lustdorf', 'ChIJu9qhbbWSmkcRBUEY8DSDQoA', 47.55083, 8.987215, 'city', '1'),
('countries_switzerland_thurgau_mammern', 'ChIJWwtMGx2MmkcRoFQZQIj_AAQ', 47.64574, 8.91628, 'city', '1'),
('countries_switzerland_bern_bettelried', 'ChIJ29wz0Lb5jkcRSp89QdqB25A', 46.54142, 7.38806, 'city', '0'),
('countries_switzerland_bern_belpberg', 'ChIJHfLdH5NJjkcRQP8YQIj_AAQ', 46.8685813, 7.5215215, 'city', '0'),
('countries_switzerland_bern_bellelay', 'ChIJjTM0S8XikUcR8AozK2loLzA', 47.2427682, 7.2060415, 'city', '0'),
('countries_switzerland_thurgau_matzingen', 'ChIJOdfeQAmTmkcRCxKYNXHULTo', 47.5195701, 8.934055, 'city', '1'),
('countries_switzerland_bern_batterkinden', 'ChIJnS932bMojkcR0NLpaXHDXdY', 47.1306664, 7.5397929, 'city', '1'),
('countries_switzerland_thurgau_mettlen', 'ChIJFzbmr_numkcRGh6nnUw-SxM', 47.516661, 9.11667, 'city', '1'),
('countries_switzerland_bern_bariswil', 'ChIJ-9DZYUwwjkcR9NIYAHzMzbg', 47.0189933, 7.5276657, 'city', '1'),
('countries_switzerland_bern_bargen_be', 'ChIJhU5B46YXjkcRTkzSD2L5ZgI', 47.0384592, 7.2631049, 'city', '1'),
('countries_switzerland_bern_barau', 'ChIJAcn6NcHIj0cRwdnGChTde0k', 46.9329751, 7.8111086, 'city', '1'),
('countries_switzerland_bern_aspi', 'ChIJq6qa_6H7j0cRQ5DVniCY32s', 47.0496759, 8.3073022, 'city', '0'),
('countries_switzerland_bern_ammerzwil', 'ChIJgU5a7fQWkEcRnIuA_mNFPBc', 47.3694701, 8.2069648, 'city', '0'),
('countries_switzerland_bern_allmendingen', 'ChIJMyRxNlA2jkcRy-Ccd6O6Bl0', 46.91469, 7.52432, 'city', '1'),
('countries_switzerland_bern_alchenflueh', 'ChIJqR2u0_UujkcRMoTnqtse5hs', 47.0858277, 7.574401, 'city', '1'),
('countries_switzerland_bern_albligen', 'ChIJKZ4-hx1EjkcRN4UkyKk9HrI', 46.8184541, 7.3411203, 'city', '0'),
('countries_switzerland_thurgau_oberneunforn', 'ChIJywQWoBiFmkcR2cu1d9x44nA', 47.6064964, 8.7678328, 'city', '1'),
('countries_switzerland_bern_aeschlen_ob_gunten', 'ChIJkxfhEx2uj0cRNWXgAuII9qI', 46.71971, 7.6992657, 'city', '0'),
('countries_switzerland_thurgau_ottoberg', 'ChIJlfKuhTvymkcR1uCDnXs4up0', 47.5871241, 9.0838121, 'city', '1'),
('countries_switzerland_thurgau_pfyn', 'ChIJ3R6Q7QmNmkcR5_SCxoEB--A', 47.5958782, 8.9545792, 'city', '1'),
('countries_switzerland_thurgau_raperswilen', 'ChIJp6kAo3_zmkcRPO5-oowCzh8', 47.6323676, 9.0426243, 'city', '1'),
('countries_switzerland_bern_aeschlen', 'ChIJuVeNm9u0j0cRgz0szoTCFa8', 46.8369713, 7.6418895, 'city', '1'),
('countries_switzerland_thurgau_riedt', 'ChIJ-fDhszblmkcR5nPGCfvHnjM', 47.545487, 9.21606, 'city', '1'),
('countries_switzerland_thurgau_roggwil', 'ChIJf33FkXQdm0cRLZvwi3emnlY', 47.5001595, 9.3959168, 'city', '1'),
('countries_switzerland_thurgau_romanshorn', 'ChIJkdUKqWj9mkcRuRNx1k7WhB8', 47.5657078, 9.3771959, 'city', '1'),
('countries_switzerland_bern_aeschi_b_spiez', 'ChIJAWkFwMeoj0cR9uHElDnpD_4', 46.6582768, 7.6963226, 'city', '1'),
('countries_switzerland_thurgau_salenstein', 'ChIJ38vGXJP0mkcRAgYZdagu3dQ', 47.6689605, 9.058747, 'city', '1'),
('countries_switzerland_thurgau_salmsach', 'ChIJbTu5g2f9mkcR6eqy7_KEqTw', 47.5547407, 9.370913, 'city', '1'),
('countries_switzerland_thurgau_schlattingen', 'ChIJ3YcsPR6EmkcRw4CPS1nJD0M', 47.666667, 8.75, 'city', '1'),
('countries_switzerland_thurgau_schlatt_bei_diessenhofen', 'ChIJsX-lv96DmkcR0j18Ftl-4CE', 47.6613462, 8.7029709, 'city', '1'),
('countries_switzerland_bern_aeschau', 'ChIJjzDm2aHJj0cRzDgHTsHcdgk', 46.90911, 7.76195, 'city', '0'),
('countries_switzerland_basel_landschaft_thuernen', 'ChIJwSbCPvs0kEcRABwZQIj_AAQ', 47.4560149, 7.8290735, 'city', '1'),
('countries_switzerland_basel_landschaft_schonenbuch', 'ChIJo-OdNkC_kUcR264JbWnk9X4', 47.5372246, 7.5020252, 'city', '1'),
('countries_switzerland_basel_landschaft_runenberg', 'ChIJ2U_cyR40kEcRTXdoAWe1tIk', 47.4327804, 7.883887, 'city', '1'),
('countries_switzerland_basel_landschaft_ruemlingen', 'ChIJpSRvFRM0kEcRsBsZQIj_AAQ', 47.4250763, 7.8479118, 'city', '1'),
('countries_switzerland_basel_landschaft_roschenz', 'ChIJJ59jYNHDkUcRTdxN1ZyQdVA', 47.4247907, 7.4758944, 'city', '1'),
('countries_switzerland_thurgau_sirnach', 'ChIJS1KU_A7rmkcRADc30WzaGsU', 47.4618426, 8.9968358, 'city', '1'),
('countries_switzerland_thurgau_sommeri', 'ChIJ06PBc2_7mkcRcFup9Top-5g', 47.5674728, 9.2893559, 'city', '1'),
('countries_switzerland_basel_landschaft_munchenstein', 'ChIJuYrT-vi3kUcRWde8OOYmQaY', 47.5226485, 7.6150661, 'city', '1'),
('countries_switzerland_basel_landschaft_liesberg_dorf', 'ChIJ6eZzJI3CkUcR7fJ0TZHuSow', 47.4037488, 7.4290857, 'city', '0'),
('countries_switzerland_thurgau_steckborn', 'ChIJ93zt8nGLmkcREFUZQIj_AAQ', 47.6680452, 8.9822824, 'city', '1'),
('countries_switzerland_thurgau_stettfurt', 'ChIJeX1igBiTmkcR3ZAPBAn5MEM', 47.5242016, 8.9549695, 'city', '1'),
('countries_switzerland_basel_landschaft_laufelfingen', 'ChIJe0eM9dwzkEcR-xguHzEv6tA', 47.3950432, 7.8558408, 'city', '1'),
('countries_switzerland_basel_landschaft_kaenerkinden', 'ChIJUYWFr4YzkEcRWAdRLHwtqG8', 47.4121609, 7.8372211, 'city', '1'),
('countries_switzerland_thurgau_sulgen', 'ChIJ69XBh0TlmkcR8aop0UyQ9cY', 47.53911, 9.18488, 'city', '1'),
('countries_switzerland_basel_landschaft_holstein', 'ChIJs6MzVl1vjkcRUSlGNU7eas0', 46.7687808, 7.1158135, 'city', '0'),
('countries_switzerland_thurgau_thundorf', 'ChIJCwnRAcaSmkcRlMtegQTsQhg', 47.5457033, 8.9634761, 'city', '1'),
('countries_switzerland_thurgau_tobel', 'ChIJy_RcV1fsmkcRfZAYOB0IMWg', 47.516667, 9.033333, 'city', '1'),
('countries_switzerland_thurgau_triboltingen', 'ChIJ0cAotSL0mkcR-SX9g9tNvdk', 47.66, 9.111, 'city', '1'),
('countries_switzerland_basel_landschaft_haefelfingen', 'ChIJ1d4Bl_gzkEcRaXV5aIW7wY8', 47.4150792, 7.8659947, 'city', '1'),
('countries_switzerland_basel_landschaft_fullinsdorf', 'ChIJr0Q-n_K1kUcR8BkZQIj_AAQ', 47.5055922, 7.7298829, 'city', '1'),
('countries_switzerland_thurgau_uttwil', 'ChIJNSWZHFX8mkcR2TxZkdy69y0', 47.5834988, 9.3404976, 'city', '1'),
('countries_switzerland_thurgau_wagenhausen', 'ChIJc8I4I_mFmkcRReUOPeYh_zI', 47.6529179, 8.8403094, 'city', '1'),
('countries_switzerland_basel_landschaft_boeckten', 'ChIJcbz4xBY1kEcRwt9nilNL6FY', 47.4626895, 7.8361995, 'city', '1'),
('countries_switzerland_appenzell_innerrhoden_jakobsbad', 'ChIJAQCQrL4gm0cR-OzaRqKxNuI', 47.3196482, 9.3281301, 'city', '1'),
('countries_switzerland_thurgau_weinfelden', 'ChIJDy71meDxmkcRUxXeMYkSaEM', 47.5660299, 9.1084456, 'city', '1'),
('countries_switzerland_appenzell_innerrhoden_haslen', 'ChIJr2xzKBAvhUcRXHL0cxl4A6w', 46.9808737, 9.0558843, 'city', '0'),
('countries_switzerland_appenzell_innerrhoden_gontenbad', 'ChIJjz9JJAUhm0cRVJK5VOYPzng', 47.3317377, 9.3724697, 'city', '0'),
('countries_switzerland_thurgau_wetzikon', 'ChIJ7ckX3yTtmkcR5IfK0eMa7JM', 47.537775, 9.000835, 'city', '1'),
('countries_switzerland_thurgau_wigoltingen', 'ChIJxd768FXymkcRHI1PSPNnmjk', 47.5976062, 9.0313547, 'city', '1'),
('countries_switzerland_thurgau_wilen', 'ChIJTzgXqErqmkcRKRx00b2vplg', 47.4515396, 9.0343854, 'city', '1'),
('countries_switzerland_appenzell_innerrhoden_bruelisau', 'ChIJOcy2cYYjm0cRMidofZc0VTQ', 47.3218142, 9.431127, 'city', '0'),
('countries_switzerland_appenzell_innerrhoden_appenzell', 'ChIJrdbkC34hm0cR72ra0-Xy0xM', 47.334932, 9.406594, 'city', '1'),
('countries_switzerland_thurgau_wittenwil', 'ChIJ3c1J-IKTmkcR5Ae4-cC8VdM', 47.503, 8.9226, 'city', '1'),
('countries_switzerland_thurgau_wuppenau', 'ChIJWwCF5iDvmkcRT9dr4-pmmtk', 47.4957832, 9.1074591, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_wienacht_tobel', 'ChIJuZ2h6T8am0cRGNMtyJU5ti4', 47.46499, 9.53006, 'city', '0'),
('countries_switzerland_appenzell_ausserrhoden_teufen_ar', 'ChIJ4Ukwy3Yfm0cRyaiqmOuO_74', 47.390742, 9.3892463, 'city', '0'),
('countries_switzerland_ticino_acquarossa', 'ChIJG_TU_oqphUcRy3jUIAvXfmE', 46.4545833, 8.939771, 'city', '1'),
('countries_switzerland_ticino_agarone', 'ChIJk5W9tXq1hUcR2p_fXElg4-I', 46.17766, 8.90609, 'city', '1'),
('countries_switzerland_ticino_agno', 'ChIJY3RZTUYthEcR_5fUjMNXzPk', 45.9969839, 8.8993906, 'city', '1'),
('countries_switzerland_ticino_agra', 'ChIJgZhDVvoshEcRLX02qrdCBG4', 45.9686348, 8.9145642, 'city', '1'),
('countries_switzerland_ticino_airolo', 'ChIJmTKswgh0hUcRr6_cmOreBbw', 46.5286074, 8.6123746, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_speicherschwendi', 'ChIJueIUD84em0cRIgdnTJ6NM_k', 47.42512, 9.43654, 'city', '0'),
('countries_switzerland_ticino_anzonico', 'ChIJ80YPiO6ohUcRFdzfEcjRJ9k', 46.431655, 8.8612342, 'city', '1'),
('countries_switzerland_ticino_aquila', 'ChIJ8XxgP80AhUcReQZHLVPiQyU', 46.5027636, 8.950367, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_switzerland_ticino_aranno', 'ChIJE1QFQF_NhUcR9Xlh2OCDVRI', 46.0174791, 8.8702203, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_niederteufen', 'ChIJ4Ukwy3Yfm0cRyaiqmOuO_74', 47.390742, 9.3892463, 'city', '0'),
('countries_switzerland_ticino_arogno', 'ChIJw7DaROkuhEcRExhRZ13OBPg', 45.9588493, 8.9871695, 'city', '1'),
('countries_switzerland_appenzell_ausserrhoden_lustmuehle', 'ChIJg0lv_-ofm0cR63b3rxQ6CEs', 47.3989697, 9.3570982, 'city', '1'),
('countries_switzerland_ticino_arzo', 'ChIJgdsatSEqhEcRIPag27ibUCA', 45.87608, 8.94096, 'city', '1'),
('countries_switzerland_ticino_ascona', 'ChIJyQzCAn3IhUcRG-QFHE0S8go', 46.1615793, 8.7750131, 'city', '1'),
('countries_switzerland_ticino_astano', 'ChIJuyrRVgzShUcRfdZvX-STXg4', 46.0122589, 8.8158937, 'city', '1'),
('countries_switzerland_ticino_aurigeno', 'ChIJJZXp9xe5hUcRoJ15nzsi0Yc', 46.233333, 8.7, 'city', '1'),
('countries_switzerland_ticino_avegno', 'ChIJ47edhIu3hUcRzZ_fDTBcDX0', 46.2028357, 8.7481907, 'city', '1'),
('countries_switzerland_ticino_balerna', 'ChIJyxDV1G33hEcRnJ7FLkOY4Gw', 45.8484251, 9.0077495, 'city', '1'),
('countries_switzerland_aargau_wurenlos', 'ChIJtW9m1EENkEcRj7EelrKkoWQ', 47.4416652, 8.363131, 'city', '1'),
('countries_switzerland_aargau_wurenlingen', 'ChIJIzeO9strkEcRgDIZQIj_AAQ', 47.533865, 8.2545695, 'city', '1'),
('countries_switzerland_ticino_bedano', 'ChIJ2VaypyczhEcRBhz-9XOSDfU', 46.0512195, 8.9191376, 'city', '1'),
('countries_switzerland_ticino_bedretto', 'ChIJkzdWO0-ChUcR3EI3a_wkuxk', 46.4850706, 8.4046556, 'city', '1'),
('countries_switzerland_ticino_bellinzona', 'ChIJO_dm_spLhEcRFEwEhX2JD_4', 46.1946216, 9.0244124, 'city', '1'),
('countries_switzerland_ticino_berzona', 'ChIJeat0eYa2hUcR3IGFcRnd1G0', 46.216667, 8.85, 'city', '1'),
('countries_switzerland_ticino_besazio', 'ChIJ_Siyae4phEcR4tBjRigsBsA', 45.872479, 8.9529468, 'city', '1'),
('countries_switzerland_ticino_biasca', 'ChIJZ2XpdOGshUcR77Z-ikI3cbg', 46.3580008, 8.9704651, 'city', '1'),
('countries_switzerland_ticino_bidogno', 'ChIJf6PUI_4zhEcRMuXx9XUR2bU', 46.0787959, 9.0004293, 'city', '1'),
('countries_switzerland_ticino_bignasco', 'ChIJEdv-9uWXhUcRLhx9C4gOURc', 46.3382079, 8.6088572, 'city', '1'),
('countries_switzerland_ticino_bigorio', 'ChIJ03f6lZ8zhEcRW2OnI9ydrrs', 46.0701003, 8.9569958, 'city', '1'),
('countries_switzerland_ticino_bioggio', 'ChIJuU0O_1YthEcRvVQOCoAcNCQ', 46.0170212, 8.9133067, 'city', '1'),
('countries_switzerland_ticino_bironico', 'ChIJH9HAvcc0hEcRU13ZMwSP-0M', 46.1145497, 8.9346296, 'city', '1'),
('countries_switzerland_ticino_bissone', 'ChIJJzqmBCAshEcR-Bv7b9tVK84', 45.9531322, 8.9651123, 'city', '1'),
('countries_switzerland_ticino_bodio', 'ChIJWcmkPReshUcROGRrfZFtHtY', 46.3783133, 8.9107251, 'city', '1'),
('countries_switzerland_aargau_woelflinswil', 'ChIJweHBez04kEcRP_-CKrIA7Rk', 47.4610461, 7.998045, 'city', '1'),
('countries_switzerland_aargau_wildegg', 'ChIJrekwmJMVkEcR0HgZQIj_AAQ', 47.4155165, 8.1819783, 'city', '0'),
('countries_switzerland_ticino_breno', 'ChIJKcCt0WvNhUcRpZM0a5cDeww', 46.0333269, 8.8701626, 'city', '1'),
('countries_switzerland_ticino_brione', 'ChIJD8HDBPe6hUcRbQZs2zQ0u94', 46.296966, 8.7904801, 'city', '1'),
('countries_switzerland_ticino_brione_sopra_minusio', 'ChIJP3WCiTi2hUcR9o0-vYNiRRE', 46.1828879, 8.814573, 'city', '1'),
('countries_switzerland_ticino_brissago', 'ChIJrzYu6mbGhUcRGVreoWNo--U', 46.1200438, 8.7112657, 'city', '1'),
('countries_switzerland_ticino_broglio', 'ChIJuwq89FaihUcR0faUpPIAywE', 46.383333, 8.666667, 'city', '1'),
('countries_switzerland_ticino_brusino_arsizio', 'ChIJ8cGVWewrhEcRsW5trnbeY_M', 45.9243521, 8.9349974, 'city', '1'),
('countries_switzerland_ticino_bruzella', 'ChIJ--wealomhEcRULWwFIxecKQ', 45.8816279, 9.0365533, 'city', '1'),
('countries_switzerland_ticino_cabbio', 'ChIJgQDXnTsmhEcR38RPRc7w_Yk', 45.8983756, 9.0453339, 'city', '1'),
('countries_switzerland_ticino_cademario', 'ChIJfRyySFPNhUcRD5b760vxYXk', 46.0223497, 8.8859188, 'city', '1'),
('countries_switzerland_ticino_cadempino', 'ChIJz4dg8fIyhEcRxDgTOb2kPJg', 46.033961, 8.9348574, 'city', '1'),
('countries_switzerland_ticino_cadenazzo', 'ChIJZZIzS0c1hEcR62PFsrEoo1M', 46.1518916, 8.9465573, 'city', '1'),
('countries_switzerland_aargau_waldhaeusern', 'ChIJAyOCjD4QkEcR65ZmzLxvw7c', 47.327, 8.315, 'city', '1'),
('countries_switzerland_ticino_cagiallo', 'ChIJLweN_sEzhEcRn2x1zg3OFUs', 46.066667, 8.983333, 'city', '1'),
('countries_switzerland_ticino_camignolo', 'ChIJaaNlUpE0hEcR0ROCZ3ogcds', 46.106737, 8.9346003, 'city', '1'),
('countries_switzerland_ticino_camorino', 'ChIJ-wlGeYY1hEcRMY7nrTuP3jg', 46.1636142, 9.0052405, 'city', '1'),
('countries_switzerland_ticino_caneggio', 'ChIJ6Wx6GSfxhEcR_sjheaHGBow', 45.872082, 9.0317166, 'city', '1'),
('countries_switzerland_ticino_canobbio', 'ChIJXTHWq0AyhEcR1D_N48hwOps', 46.0363628, 8.9636069, 'city', '1'),
('countries_switzerland_ticino_capolago', 'ChIJv2pPMCAphEcRD8-tMTIDABk', 45.902667, 8.9784787, 'city', '1'),
('countries_switzerland_aargau_walde', 'ChIJZ_UAt6LImkcRDBi1KQAouOY', 47.2447103, 8.9664312, 'city', '1'),
('countries_switzerland_aargau_vogelsang_ag', 'ChIJm_6fdvUgjkcRNfByk8oT5As', 47.1889883, 7.387849, 'city', '0'),
('countries_switzerland_aargau_vogelsang', 'ChIJsRKDKeHhj0cRmqvKACOeybc', 47.161223, 8.1778566, 'city', '0'),
('countries_switzerland_aargau_tennwil', 'ChIJ4Yk6mfwZkEcRJ6yBp5lW_h4', 47.3067267, 8.2215858, 'city', '1'),
('countries_switzerland_ticino_caslano', 'ChIJb9wHg9IshEcRuylq5d4eVbc', 45.9734019, 8.8803597, 'city', '1'),
('countries_switzerland_ticino_cassina', 'ChIJ1dw9LjEthEcRvOKEj6_87O4', 45.9920211, 8.8917109, 'city', '1'),
('countries_switzerland_aargau_taegerig', 'ChIJA94NyucTkEcRP7m8Wdztfp4', 47.403857, 8.2786916, 'city', '1'),
('countries_switzerland_aargau_siggenthal_station', 'ChIJNy6grk1qkEcRm5NaXCQ4BGA', 47.5191346, 8.2416803, 'city', '0'),
('countries_switzerland_ticino_castel_san_pietro', 'ChIJZdoiLuvwhEcRqt346rPI5dk', 45.8631731, 9.0065607, 'city', '1'),
('countries_switzerland_ticino_castione', 'ChIJR5dIwPxLhEcRMK9onVWidj8', 46.2148507, 9.0463112, 'city', '1'),
('countries_switzerland_ticino_castro', 'ChIJyxEJvvuphUcRF2qKTP1Q3-o', 46.4696719, 8.9319006, 'city', '1'),
('countries_switzerland_ticino_cavagnago', 'ChIJWbXNnSWphUcR-1TkLbtczz4', 46.4133529, 8.881097, 'city', '1'),
('countries_switzerland_aargau_schoftland', 'ChIJ3QqGc0EjkEcRwEsZQIj_AAQ', 47.30471, 8.05136, 'city', '1'),
('countries_switzerland_ticino_cavigliano', 'ChIJUWVuhna4hUcRsfXoTiiS7_8', 46.185243, 8.7204319, 'city', '1'),
('countries_switzerland_ticino_cerentino', 'ChIJQTH2k_CWhUcRwaGXUJIrhkk', 46.3050755, 8.5469886, 'city', '1'),
('countries_switzerland_ticino_cevio', 'ChIJI8xgCdGXhUcRmmvz3jRs5bU', 46.3177065, 8.6023079, 'city', '1'),
('countries_switzerland_ticino_chiasso', 'ChIJRT7X08qChkcR5oLNUtL2mAc', 45.8366999, 9.0246111, 'city', '1'),
('countries_switzerland_ticino_chiggiogna', 'ChIJx5lH5eqnhUcRzxfZI0JlD5A', 46.4675, 8.821, 'city', '1'),
('countries_switzerland_ticino_chironico', 'ChIJ757Mm4qmhUcRj_QMdN94CuI', 46.4221504, 8.8436177, 'city', '1'),
('countries_switzerland_aargau_schinznach_dorf', 'ChIJj4bd0RE_kEcRr51FGr4Y34I', 47.4474737, 8.1427966, 'city', '1'),
('countries_switzerland_aargau_schinznach_bad', 'ChIJZd4zvN8_kEcRn7x6-dI8euI', 47.4504862, 8.1684054, 'city', '1'),
('countries_switzerland_ticino_cimo', 'ChIJ6yGAD0wthEcRaysM-uaHEeo', 46.00208, 8.89025, 'city', '1'),
('countries_switzerland_ticino_claro', 'ChIJgwUgo09MhEcRyRnv1rh0-SM', 46.25298, 9.02308, 'city', '1'),
('countries_switzerland_ticino_coglio', 'ChIJp14NNwe8hUcRbICL1uso7Uk', 46.268731, 8.684703, 'city', '1'),
('countries_switzerland_ticino_coldrerio', 'ChIJfRtKZoGChkcR2nmwvnM7bzc', 45.8565898, 8.9885757, 'city', '1'),
('countries_switzerland_ticino_comano', 'ChIJlYzuq1oyhEcRfda3Ps1CJE8', 46.03637, 8.9547861, 'city', '1'),
('countries_switzerland_ticino_comologno', 'ChIJl2dcn_C_hUcRtqEC6D9-taA', 46.2, 8.583333, 'city', '1'),
('countries_switzerland_aargau_rumikon', 'ChIJdx66ekZukEcRgKWo6JFB0vg', 47.5661658, 8.3774017, 'city', '1'),
('countries_switzerland_aargau_ruetihof', 'ChIJ5TZBd50UkEcRxrJDZF1_wUI', 47.4372804, 8.2683749, 'city', '0'),
('countries_switzerland_ticino_corzoneso', 'ChIJqQ0-iCiqhUcRIBEPaDitBN4', 46.446389, 8.934444, 'city', '1'),
('countries_switzerland_ticino_crana', 'ChIJ3e_BF6S_hUcRoRIZxXKIfSk', 46.216667, 8.616667, 'city', '1'),
('countries_switzerland_aargau_ruefenach', 'ChIJtyw7Wo9qkEcRXeXrJjmANUI', 47.5087096, 8.2067115, 'city', '1'),
('countries_switzerland_ticino_cugnasco', 'ChIJrQHY7Fy1hUcR2vW3cDye_5Y', 46.1757927, 8.9221883, 'city', '1'),
('countries_switzerland_aargau_rudolfstetten', 'ChIJ2XDa02QOkEcRUDcMyzmHvDY', 47.3690655, 8.3807414, 'city', '1'),
('countries_switzerland_ticino_cureglia', 'ChIJm7H1b_YyhEcREQRYmCFdVs8', 46.0371189, 8.945431, 'city', '1'),
('countries_switzerland_ticino_curio', 'ChIJ-wc9cJXShUcRZyDVi1JITr0', 46.0022036, 8.8627718, 'city', '1'),
('countries_switzerland_aargau_rombach', 'ChIJ1TFJedg7kEcRi7x8BJjjfYM', 47.403278, 8.0330005, 'city', '0'),
('countries_switzerland_ticino_dangio', 'ChIJeT8e_ckAhUcRd1TpgtHq4-w', 46.4942208, 8.9530676, 'city', '1'),
('countries_switzerland_aargau_riken', 'ChIJ5eDPxKIukEcRU3B7GNEHvSA', 47.2766219, 7.8498216, 'city', '0'),
('countries_switzerland_ticino_dongio', 'ChIJIx6dZsqrhUcRt7ZL_OL_V68', 46.433333, 8.95, 'city', '1'),
('countries_switzerland_ticino_faido', 'ChIJj2p1HX2nhUcROiuHxt_c1y8', 46.4782177, 8.8009636, 'city', '1'),
('countries_switzerland_ticino_fescoggia', 'ChIJv2NQ_2vNhUcRKJbouB7EWfs', 46.0335537, 8.8621607, 'city', '1'),
('countries_switzerland_aargau_oberruti', 'ChIJ7-W7GZIBkEcRGEw2nbGJyyE', 47.1659772, 8.3944487, 'city', '1'),
('countries_switzerland_aargau_oberhofen_bei_etzgen', 'ChIJeR9T7uJDkEcRaI7pyA1IHiY', 47.5545954, 8.1333139, 'city', '0'),
('countries_switzerland_ticino_frasco', 'ChIJob8VaoWvhUcR9Mcrfb-AN44', 46.34029, 8.80201, 'city', '1'),
('countries_switzerland_ticino_genestrerio', 'ChIJmwLYA3OChkcRLVX3OE9WSU4', 45.8548852, 8.9608488, 'city', '1'),
('countries_switzerland_aargau_niederwil_ag', 'ChIJscX6pnsRkEcRMzBy2KAApk0', 47.3773998, 8.2952607, 'city', '0'),
('countries_switzerland_aargau_muhlau', 'ChIJSzekyw8EkEcRHRIjPZekA-w', 47.2299401, 8.388647, 'city', '1'),
('countries_switzerland_ticino_giornico', 'ChIJ5dZsH9OuhUcRIQFlQsE47Sc', 46.4019229, 8.8772098, 'city', '1'),
('countries_switzerland_ticino_giubiasco', 'ChIJNWur7WVKhEcRNeez7WcLiXc', 46.172106, 9.0103933, 'city', '1'),
('countries_switzerland_ticino_giumaglio', 'ChIJw9hvTQ-8hUcRGeHyrTeYHlM', 46.273889, 8.681944, 'city', '1'),
('countries_switzerland_ticino_gnosca', 'ChIJ8R0ODoJMhEcRjHPdnsZldqg', 46.2330492, 9.022594, 'city', '1'),
('countries_switzerland_ticino_golino', 'ChIJ9X1R94PHhUcRTod1AuLcMBc', 46.178765, 8.7115777, 'city', '1'),
('countries_switzerland_ticino_gordevio', 'ChIJTwMsQ7a5hUcR0I77EoZki6M', 46.2254006, 8.7421263, 'city', '1'),
('countries_switzerland_ticino_gordola', 'ChIJUXSUOuW1hUcRSJxXrzWsYLI', 46.1809063, 8.8608089, 'city', '1'),
('countries_switzerland_ticino_gorduno', 'ChIJHeIZwmtLhEcRNsidLo_7sWY', 46.216555, 9.0345622, 'city', '1'),
('countries_switzerland_ticino_grancia', 'ChIJIY69N1QshEcRiQheNqZWPxU', 45.9684104, 8.9279925, 'city', '1'),
('countries_switzerland_ticino_gravesano', 'ChIJNRcFGsMyhEcRRL1GsDjHnHo', 46.0409737, 8.9233052, 'city', '1'),
('countries_switzerland_ticino_gudo', 'ChIJ6RFM4LFKhEcR63O1cjC8cNk', 46.174232, 8.9489996, 'city', '1'),
('countries_switzerland_ticino_indemini', 'ChIJQf6MPQnMhUcRBTpEtS6X-2o', 46.0944392, 8.825708, 'city', '1'),
('countries_switzerland_aargau_muenchwilen', 'ChIJ1WRfPGbrmkcRIlqXydOljBk', 47.4777116, 8.9976291, 'city', '1'),
('countries_switzerland_ticino_intragna', 'ChIJdYq7barHhUcR65A4QuuX3Og', 46.177875, 8.700964, 'city', '1'),
('countries_switzerland_aargau_muelligen', 'ChIJVc2vv8QUkEcR9lJzOxkYrAA', 47.4576006, 8.2407016, 'city', '1'),
('countries_switzerland_ticino_isone', 'ChIJO9UP46w1hEcRckYOvVpBjTM', 46.1292959, 8.9860855, 'city', '1'),
('countries_switzerland_ticino_lamone', 'ChIJw-GXWeQyhEcRgDoZQIj_AAQ', 46.0449437, 8.9332835, 'city', '1'),
('countries_switzerland_ticino_largario', 'ChIJjfDXBEoHhUcRuUVOibyKI2o', 46.494444, 8.941111, 'city', '1'),
('countries_switzerland_ticino_lavertezzo', 'ChIJS9h5FHOxhUcR24M4JFGiVjM', 46.2597497, 8.8394488, 'city', '1'),
('countries_switzerland_ticino_lavorgo', 'ChIJ8ViHNIGohUcRs-j1tq1UiJc', 46.441389, 8.840278, 'city', '1'),
('countries_switzerland_ticino_leontica', 'ChIJZdg6ae2phUcRGXHFHHUdBYA', 46.459167, 8.9225, 'city', '1'),
('countries_switzerland_ticino_ligornetto', 'ChIJj1z8T-cphEcRtUqX18-sv8U', 45.8627987, 8.9516366, 'city', '1'),
('countries_switzerland_ticino_linescio', 'ChIJq-szmbSXhUcRYI4GB31Q1xo', 46.3082261, 8.5836449, 'city', '1'),
('countries_switzerland_ticino_locarno', 'ChIJIyho3_zJhUcRmjrqL5kHkf8', 46.1669988, 8.7942643, 'city', '1'),
('countries_switzerland_ticino_loco', 'ChIJP9XWI7O4hUcR3FY8A59qDmk', 46.2, 8.666667, 'city', '1'),
('countries_switzerland_ticino_lodano', 'ChIJE6-Ui0y5hUcRTnB_LWPv6Zg', 46.25, 8.683333, 'city', '1'),
('countries_switzerland_aargau_muehlethal', 'ChIJIfaRFBolkEcRr6uzl2BUvlk', 47.302774, 7.979168, 'city', '1'),
('countries_switzerland_ticino_lopagno', 'ChIJ0VnCRpUzhEcR0RJJ0I7iRNM', 46.068333, 8.977222, 'city', '1'),
('countries_switzerland_ticino_losone', 'ChIJDXd51OPHhUcRIrk3nRTwb7Q', 46.1688136, 8.7608755, 'city', '1'),
('countries_switzerland_ticino_ludiano', 'ChIJjeBJWb-rhUcRNlmUubBaN68', 46.4195681, 8.9718525, 'city', '1'),
('countries_switzerland_aargau_moriken', 'ChIJrekwmJMVkEcR0HgZQIj_AAQ', 47.4155165, 8.1819783, 'city', '1'),
('countries_switzerland_ticino_lugano', 'ChIJ8RFCavcthEcR4PihLiEEjO8', 46.0036778, 8.951052, 'city', '1'),
('countries_switzerland_ticino_lumino', 'ChIJKVuMz7lOhEcRguwCJuhk56c', 46.2305658, 9.0660027, 'city', '1'),
('countries_switzerland_aargau_mohlin', 'ChIJgy9JpXFLkEcR0LjrjWH9pkE', 47.5591304, 7.8442531, 'city', '1'),
('countries_switzerland_aargau_moenthal', 'ChIJScZGzAJBkEcRmuxpqfS6qKk', 47.5170805, 8.1446086, 'city', '1'),
('countries_switzerland_ticino_maggia', 'ChIJdfPU96y-hUcRevF37SCjJdI', 46.2458376, 8.7056556, 'city', '1'),
('countries_switzerland_ticino_magliaso', 'ChIJjyxnMCkthEcRtaYTuStLbqg', 45.9834646, 8.8886323, 'city', '1'),
('countries_switzerland_ticino_malvaglia', 'ChIJp8DebcNUhEcRCvAXDR8ql2k', 46.41102, 8.98118, 'city', '1'),
('countries_switzerland_ticino_manno', 'ChIJh6My970yhEcR3LMIP6YMRAU', 46.0342979, 8.9194112, 'city', '1'),
('countries_switzerland_ticino_maroggia', 'ChIJLZ8CV60uhEcRf30ZM2B2-zs', 45.9340548, 8.9710806, 'city', '1'),
('countries_switzerland_ticino_marolta', 'ChIJ4ddyl18HhUcR1hDMzhopbYU', 46.478333, 8.919722, 'city', '1'),
('countries_switzerland_ticino_massagno', 'ChIJ8yilpYYthEcRwE7iaovLkOI', 46.0129713, 8.9418624, 'city', '1'),
('countries_switzerland_ticino_medeglia', 'ChIJSUBBzh01hEcRhgmmNGpoanY', 46.1151133, 8.9692938, 'city', '1'),
('countries_switzerland_ticino_melano', 'ChIJg3zpDCUphEcRzcs14IThJ8w', 45.9237392, 8.9842102, 'city', '1'),
('countries_switzerland_ticino_melide', 'ChIJA_3ROTkshEcRcQGWnQU8omk', 45.9537588, 8.9467526, 'city', '1'),
('countries_switzerland_ticino_mendrisio', 'ChIJ0dlZL68phEcRI1hFLy16yhs', 45.8713339, 8.9841329, 'city', '1'),
('countries_switzerland_ticino_menzonio', 'ChIJs5SSVr6ihUcRdQhKHrRgvM0', 46.361111, 8.640278, 'city', '1'),
('countries_switzerland_ticino_mergoscia', 'ChIJ37YF7ny2hUcRIMPMRNFP-LA', 46.2086286, 8.844509, 'city', '1'),
('countries_switzerland_ticino_meride', 'ChIJWxXCL9YrhEcRWvX27DabLXk', 45.8903631, 8.9539165, 'city', '1'),
('countries_switzerland_aargau_maegenwil', 'ChIJhaTOEEIUkEcRm9TOepcSScA', 47.4120437, 8.2356098, 'city', '1'),
('countries_switzerland_ticino_miglieglia', 'ChIJtdfoBHjNhUcRcyMIAwZDWqE', 46.0237995, 8.8567138, 'city', '1'),
('countries_switzerland_ticino_minusio', 'ChIJhbdaFC-2hUcRqX5FBxWuSg0', 46.1764501, 8.8130107, 'city', '1'),
('countries_switzerland_ticino_moghegno', 'ChIJCZZURy65hUcR9dtSOMsVHzc', 46.233333, 8.683333, 'city', '1'),
('countries_switzerland_ticino_moleno', 'ChIJWYNUcDKzhUcRKXZbCa43IPo', 46.2679927, 8.9947347, 'city', '1'),
('countries_switzerland_ticino_molinazzo_di_monteggio', 'ChIJ9Zj6Ak_ShUcRIJ38M1fh6CI', 45.99083, 8.82092, 'city', '1'),
('countries_switzerland_aargau_kolliken', 'ChIJ9yowETQ7kEcR6YArKERcZ3s', 47.3360247, 8.0243041, 'city', '1'),
('countries_switzerland_ticino_monte_carasso', 'ChIJLZNd9x9LhEcRmfj4eKHNODU', 46.1890073, 8.9980977, 'city', '1'),
('countries_switzerland_ticino_morbio_inferiore', 'ChIJp_FIIK6ChkcRDH-kQuLW8lw', 45.8487988, 9.0163811, 'city', '1'),
('countries_switzerland_ticino_morbio_superiore', 'ChIJ_RFG7-cnhEcRHA13SNCcju4', 45.8604864, 9.0214305, 'city', '1'),
('countries_switzerland_ticino_morcote', 'ChIJvRd6WX8rhEcR5AQ1kf50pZo', 45.9278156, 8.9078997, 'city', '1'),
('countries_switzerland_ticino_mugena', 'ChIJ_08f8CPNhUcRD1Oftx92Duw', 46.05, 8.883333, 'city', '1'),
('countries_switzerland_ticino_muralto', 'ChIJqTwp-S7IhUcRnRFZyGmWNFM', 46.1729618, 8.8056081, 'city', '1'),
('countries_switzerland_ticino_muzzano', 'ChIJLUYqC20thEcR5x_Ae3j81No', 45.9977794, 8.9197977, 'city', '1'),
('countries_switzerland_ticino_neggio', 'ChIJrTImuc3ShUcRWJ_ALtj_HVc', 45.9870685, 8.8791559, 'city', '1'),
('countries_switzerland_ticino_novaggio', 'ChIJg5ds35DShUcRzbNP6rYJM1g', 46.0093597, 8.8559217, 'city', '1'),
('countries_switzerland_ticino_novazzano', 'ChIJqwuCF5L3hEcRMyOK_3JUI_E', 45.8415698, 8.9770149, 'city', '1'),
('countries_switzerland_aargau_kleindoettingen', 'ChIJ16koZ-5pkEcREIELDO1Er1Y', 47.5708388, 8.2463587, 'city', '0'),
('countries_switzerland_aargau_hertenstein', 'ChIJjVrb3_n4j0cRJBcv_MxL-vc', 47.0268664, 8.402521, 'city', '0'),
('countries_switzerland_ticino_olivone', 'ChIJXcoLK7YGhUcRAUN757Eh9Xg', 46.533333, 8.95, 'city', '1'),
('countries_switzerland_aargau_hausen', 'ChIJa_IFvLKpmkcR4n1YIl7XImU', 47.243851, 8.5337973, 'city', '1'),
('countries_switzerland_ticino_origlio', 'ChIJ3-h30v8yhEcRIq2LclI8IJg', 46.0513367, 8.9499982, 'city', '1'),
('countries_switzerland_ticino_orselina', 'ChIJbwGPPNK3hUcRNrdhrQmB-Q8', 46.1789419, 8.7989377, 'city', '1'),
('countries_switzerland_aargau_hagglingen', 'ChIJ7_sdm_8TkEcREDMZQIj_AAQ', 47.3869008, 8.251313, 'city', '1'),
('countries_switzerland_ticino_palagnedra', 'ChIJX9hdvh7BhUcRlXAZJWKz0jo', 46.1540359, 8.6321672, 'city', '1'),
('countries_switzerland_aargau_graenichen', 'ChIJNZ9l6R09kEcRhlNmspLsd78', 47.3621015, 8.0980292, 'city', '1'),
('countries_switzerland_ticino_paradiso', 'ChIJ56q_k7sthEcRllUEiujBONE', 45.9907174, 8.9452618, 'city', '1'),
('countries_switzerland_aargau_glashuetten', 'ChIJMe0Hn1IpkEcRT2WljFcPpFw', 47.2577279, 7.8453889, 'city', '1'),
('countries_switzerland_ticino_peccia', 'ChIJ8UhKZ2uihUcRA-c5Dvk4I3I', 46.4, 8.65, 'city', '1'),
('countries_switzerland_ticino_pedrinate', 'ChIJBdOIEcqChkcRMVPVm5KOoXY', 45.833333, 9.016667, 'city', '1'),
('countries_switzerland_ticino_personico', 'ChIJ2eWDbIiuhUcRhtlm4M1sPEQ', 46.3711388, 8.9187102, 'city', '1'),
('countries_switzerland_ticino_pianezzo', 'ChIJFWt-gB02hEcRFNsuvZF4RUY', 46.1695122, 9.0298251, 'city', '1'),
('countries_switzerland_aargau_gippingen', 'ChIJS_L00NRpkEcR0GBZQaL4yxY', 47.5872406, 8.2199336, 'city', '0'),
('countries_switzerland_ticino_piotta', 'ChIJD6ZxVrYKhUcRUHmq99NFoi0', 46.51329, 8.67487, 'city', '1'),
('countries_switzerland_ticino_pollegio', 'ChIJi9gullOshUcR5nKrD3SotwY', 46.3645327, 8.9436259, 'city', '1'),
('countries_switzerland_aargau_full', 'ChIJaXGBLbbHjkcRtxT0-dGzQ-M', 46.1385386, 7.1181106, 'city', '0'),
('countries_switzerland_ticino_ponte_capriasca', 'ChIJhYEy0gQ0hEcReH72-LLHmRw', 46.0609216, 8.9479708, 'city', '1'),
('countries_switzerland_ticino_ponte_tresa', 'ChIJL5MMzivThUcR1WEsvepoDrE', 45.9697799, 8.8581667, 'city', '1'),
('countries_switzerland_ticino_porza', 'ChIJz_xtg2YyhEcRSMfuAarFLAs', 46.0275328, 8.954544, 'city', '1'),
('countries_switzerland_ticino_prato', 'ChIJt1Z417yghUcRkY5oMJaKQ-0', 46.4829046, 8.7567273, 'city', '1'),
('countries_switzerland_ticino_preonzo', 'ChIJHRpaEq1MhEcRXvumzVVt3fM', 46.2648111, 9.000497, 'city', '1'),
('countries_switzerland_ticino_prosito', 'ChIJ4ap6eyhNhEcRQpiUWMTncPs', 46.2807004, 8.9856204, 'city', '1'),
('countries_switzerland_aargau_fischbach_goeslikon', 'ChIJr638U5cRkEcRkSOave5E0VQ', 47.3722258, 8.3072911, 'city', '0'),
('countries_switzerland_ticino_pura', 'ChIJzwah59jShUcRlYNwZAxD9PU', 45.9839746, 8.8706472, 'city', '1'),
('countries_switzerland_aargau_erlinsbach_ag', 'ChIJd4zDuvA5kEcRopZ8dLZwVRk', 47.4067819, 8.0111999, 'city', '0'),
('countries_switzerland_aargau_durrenasch', 'ChIJZW2cWB0YkEcR2C6Dnd6NXWo', 47.3214469, 8.1568605, 'city', '1'),
('countries_switzerland_ticino_quinto', 'ChIJUbAJTPEKhUcRjpsM1TZhssE', 46.5099625, 8.6929161, 'city', '1'),
('countries_switzerland_ticino_rancate', 'ChIJ71wsEsQphEcRvYouL9Pjps8', 45.8713054, 8.9687129, 'city', '1'),
('countries_switzerland_ticino_riva_san_vitale', 'ChIJ_SBhRW0phEcRmVU3bLog-oI', 45.9008013, 8.9708066, 'city', '1'),
('countries_switzerland_aargau_densbueren', 'ChIJO313pcI4kEcRMO5NGfJv-i0', 47.4541627, 8.0535125, 'city', '1'),
('countries_switzerland_aargau_busslingen', 'ChIJIRR-dkESkEcRAcenRI7XKVM', 47.4083745, 8.3266242, 'city', '0'),
('countries_switzerland_aargau_buettikon', 'ChIJQZ2brpMQkEcRpGmrFzZ_HCc', 47.32864, 8.2722771, 'city', '1'),
('countries_switzerland_ticino_rodi', 'ChIJPbMURaeghUcRrfQSHTkhVsI', 46.49073, 8.73758, 'city', '1'),
('countries_switzerland_ticino_ronco_sopra_ascona', 'ChIJ2dJ0iCbGhUcRRmuVFqMWixg', 46.1429823, 8.7263745, 'city', '1'),
('countries_switzerland_ticino_roveredo', 'ChIJf2D0MewzhEcR4SstgvwM464', 46.073611, 8.985, 'city', '1'),
('countries_switzerland_ticino_rovio', 'ChIJ7SeI59MuhEcR3uj-KlXFs0A', 45.9362506, 8.9836424, 'city', '1'),
('countries_switzerland_aargau_buenzen', 'ChIJd9MVHBoQkEcRQsbBRIfWf_E', 47.3108608, 8.3241179, 'city', '1'),
('countries_switzerland_ticino_sagno', 'ChIJCSXCrfAnhEcRb-j9cUYKtno', 45.8566349, 9.0390304, 'city', '1'),
('countries_switzerland_aargau_bozen', 'ChIJuRJxO0lHkEcRvrJlyzkhxdA', 47.4948295, 8.0840229, 'city', '1'),
('countries_switzerland_aargau_boezberg', 'ChIJKRZGXI5AkEcRpylRrCaqors', 47.4970603, 8.1546981, 'city', '1'),
('countries_switzerland_aargau_boebikon', 'ChIJkTCmNpBukEcRsHwZQIj_AAQ', 47.5539346, 8.331219, 'city', '1'),
('countries_switzerland_aargau_besenbueren', 'ChIJnTogA-4PkEcRmtnMRdIPQ2s', 47.3119584, 8.3440772, 'city', '1'),
('countries_switzerland_ticino_sant_antonio', 'ChIJ9Yj-ccFJhEcRtoj2RROkw_E', 46.1685557, 9.0857218, 'city', '1'),
('countries_switzerland_ticino_savosa', 'ChIJa4uqaHwyhEcRv-wBXscPnc4', 46.0191268, 8.9424117, 'city', '1'),
('countries_switzerland_aargau_aettenschwil', 'ChIJ8SkkkMwDkEcRiOuMvOUYrLY', 47.18421, 8.37183, 'city', '0'),
('countries_switzerland_aargau_beinwil', 'ChIJvVDxnZoEkEcRAROSVK6b5us', 47.2300917, 8.3429977, 'city', '0'),
('countries_switzerland_ticino_sementina', 'ChIJVWmcvsJKhEcRA3lBrs4CakI', 46.1820276, 8.9924856, 'city', '1'),
('countries_switzerland_ticino_semione', 'ChIJWZh5nnarhUcRZgDQFftkdZM', 46.4075638, 8.9702528, 'city', '1'),
('countries_switzerland_ticino_sessa', 'ChIJmTYScUDShUcRDi-c6RfwZlg', 45.9996604, 8.819031, 'city', '1'),
('countries_switzerland_ticino_sigirino', 'ChIJlWoYdFIzhEcR4vxw1kKfAxE', 46.080154, 8.9202869, 'city', '1'),
('countries_sweden_vastra_gotaland_ytterby', 'ChIJKwYPndSFX0YRChPKhOFHrt8', 59.4285244, 18.3348874, 'city', '1'),
('countries_sweden_vastra_gotaland_vaestra_froelunda', 'ChIJw8DN_MXyT0YRfRssqk8BjRA', 57.6528971, 11.9105525, 'city', '0'),
('countries_switzerland_ticino_sonogno', 'ChIJI8GwZEGlhUcRI-l7LD1jIGQ', 46.3502778, 8.7866579, 'city', '1'),
('countries_switzerland_ticino_sorengo', 'ChIJzwjYJnYthEcRNHdUmAzgfdQ', 45.9978309, 8.938607, 'city', '1'),
('countries_switzerland_ticino_stabio', 'ChIJwZ-5UhyChkcRcUv7RunMVeU', 45.8530292, 8.9366943, 'city', '1'),
('countries_sweden_vastra_gotaland_vaersas', 'ChIJp6lbRYFCXkYRIEBl4rZdQbw', 59.6099005, 16.5448092, 'city', '1'),
('countries_sweden_vastra_gotaland_torslanda', 'ChIJqyN-U1OJT0YRae5bEIPiZ3Y', 57.723152, 11.7676685, 'city', '0'),
('countries_sweden_vastra_gotaland_styrsoe', 'ChIJQ-JvqUeST0YRsGdLG3mQAQ8', 57.6113765, 11.7858357, 'city', '0'),
('countries_switzerland_ticino_tegna', 'ChIJQxskfP-3hUcRCJi1cduwfss', 46.186706, 8.7443382, 'city', '1'),
('countries_sweden_vastra_gotaland_skene', 'ChIJKbkv6GsaUEYRoJhAo3qQAQo', 57.483333, 12.6333331, 'city', '0'),
('countries_switzerland_ticino_tesserete', 'ChIJQQX_Ob0zhEcR-oUrgY0MPJk', 46.066667, 8.966667, 'city', '1'),
('countries_switzerland_ticino_torre', 'ChIJXfjBbK4AhUcRmbQKA_sF3xU', 46.483333, 8.95, 'city', '1'),
('countries_sweden_vastra_gotaland_orby', 'ChIJffhETQ13X0YRtbtLiJNu3bg', 59.2711697, 18.02836, 'city', '0'),
('countries_switzerland_ticino_tremona', 'ChIJKXvi2JMphEcR2EkNa-OYPJM', 45.8792427, 8.9557573, 'city', '1'),
('countries_switzerland_ticino_vacallo', 'ChIJ8yWTeVT2hEcRpii8mwULWJ0', 45.8451832, 9.0317352, 'city', '1'),
('countries_switzerland_ticino_vaglio', 'ChIJV7v2ZaYzhEcR01fTh18sCrU', 46.061111, 8.957222, 'city', '1'),
('countries_sweden_vastra_gotaland_olofstorp', 'ChIJD10DjIVYRUYR4CdAo3qQAQo', 57.8015082, 12.1672431, 'city', '0'),
('countries_switzerland_ticino_vernate', 'ChIJVWOhM8rShUcRzEzRbZ_R8gw', 45.9943426, 8.8868464, 'city', '1'),
('countries_switzerland_ticino_verscio', 'ChIJE9M9E3K4hUcRgGgoruQ-zR0', 46.1842687, 8.7308134, 'city', '1'),
('countries_switzerland_ticino_vezia', 'ChIJKzlCxY4yhEcRjVe9Z1wj9eY', 46.0272487, 8.9371, 'city', '1'),
('countries_sweden_vastra_gotaland_oejersjoe', 'ChIJj7joUSv3T0YRXu5Ki9wFjK4', 57.7025817, 12.1404481, 'city', '0'),
('countries_switzerland_ticino_vico_morcote', 'ChIJ62f-wogrhEcR8oy8LQwLpEU', 45.9297763, 8.9212394, 'city', '1'),
('countries_sweden_vastra_gotaland_nord_koster', 'ChIJS-iNu68kREYRbY7llI7pr2k', 58.8957838, 11.0086378, 'city', '0'),
('countries_sweden_vastra_gotaland_kyrkobyn', 'ChIJecqdt2npT0YR8vlhLnmQASY', 57.5019398, 11.991738, 'city', '1'),
('countries_sweden_vastra_gotaland_kopstadso', 'ChIJ_43Jr3uST0YRYGFLG3mQAQ8', 57.629439, 11.805465, 'city', '0'),
('countries_switzerland_ticino_vogorno', 'ChIJs8LOZJy2hUcRB00HlRXm6OM', 46.2226337, 8.8579681, 'city', '1'),
('countries_sweden_vastra_gotaland_karra', 'ChIJS9k-xPFfRUYRpedmxrz81YM', 57.8000111, 12.0000105, 'city', '0'),
('countries_switzerland_uri_altdorf', 'ChIJCepcX4BDhUcREAwZQIj_AAQ', 46.8821272, 8.6428436, 'city', '1'),
('countries_switzerland_uri_andermatt', 'ChIJcxzply1yhUcRi1HYrd7WjLw', 46.6339116, 8.5935627, 'city', '1'),
('countries_switzerland_uri_attinghausen', 'ChIJE7Mo51xdhUcRZAeqHYg0Pps', 46.8617608, 8.63111, 'city', '1'),
('countries_switzerland_uri_bauen', 'ChIJDTr-H95ahUcR5Q9rwvN1liE', 46.9348014, 8.5797914, 'city', '1'),
('countries_sweden_vastra_gotaland_kallered', 'ChIJvaSgVNTxT0YRo9HA8tTC-9g', 57.608487, 12.0660077, 'city', '0'),
('countries_sweden_vastra_gotaland_hisings_kaerra', 'ChIJmz8bFGj1T0YRyJ00xq05UOc', 57.791151, 11.9984141, 'city', '0'),
('countries_switzerland_uri_erstfeld', 'ChIJBRA4lxNChUcRuAt1XmSsOsc', 46.8228834, 8.6483355, 'city', '1'),
('countries_switzerland_uri_fluelen', 'ChIJ3yQpVZBEhUcR9GuEnsNCyn4', 46.900149, 8.6238894, 'city', '1'),
('countries_switzerland_uri_gurtnellen', 'ChIJZYxn2lFphUcR81RvrNVBGxM', 46.73796, 8.62781, 'city', '1'),
('countries_sweden_vastra_gotaland_hisings_backa', 'ChIJSdhl5en0T0YRgtvJJXmQASY', 57.75, 11.983333, 'city', '0'),
('countries_switzerland_uri_isenthal', 'ChIJs9pqAG1bhUcRld3gasZ12cs', 46.9105925, 8.5619813, 'city', '1'),
('countries_sweden_vastra_gotaland_groto', 'ChIJba-UwaePT0YR4FZLG3mQAQ8', 57.6941667, 11.6833333, 'city', '0'),
('countries_switzerland_uri_realp', 'ChIJYYotnqdwhUcRhh34xJAHuFk', 46.5992257, 8.5026469, 'city', '1'),
('countries_switzerland_uri_schattdorf', 'ChIJM-19X79DhUcRYZpv3VcamHs', 46.8642346, 8.6481594, 'city', '1'),
('countries_switzerland_uri_seedorf', 'ChIJxStM1VJDhUcRlpmuBV7KXSE', 46.88092, 8.61352, 'city', '1'),
('countries_switzerland_uri_seelisberg', 'ChIJQ5G3-pZahUcRuFVpVicszCM', 46.9749886, 8.5853863, 'city', '1'),
('countries_switzerland_uri_silenen', 'ChIJJz4tqSQVhUcRDj1yJsyl_Ag', 46.7917355, 8.6694779, 'city', '1'),
('countries_switzerland_uri_sisikon', 'ChIJzVxis71FhUcR0QBUwpYJ9sg', 46.9498719, 8.6220124, 'city', '1'),
('countries_switzerland_uri_spiringen', 'ChIJga67qpM7hUcRqfTafmZL1c8', 46.8894219, 8.8997777, 'city', '1'),
('countries_sweden_vastra_gotaland_fotoe', 'ChIJiXPnO8KPT0YRAfTKUDGV2wM', 57.6680556, 11.6580556, 'city', '0'),
('countries_switzerland_uri_wassen', 'ChIJazZsGO1uhUcR-HgtEylyqJI', 46.7069939, 8.5999384, 'city', '1'),
('countries_switzerland_valais_agarn', 'ChIJW4C80PYXj0cRsvYhtHOPsjc', 46.2958644, 7.6667211, 'city', '1'),
('countries_switzerland_valais_albinen', 'ChIJLbJ1yzAaj0cRgGgZQIj_AAQ', 46.3418241, 7.633136, 'city', '1'),
('countries_switzerland_valais_aminona', 'ChIJyVurkmUej0cRoEPU9TLgtnY', 46.332575, 7.525632, 'city', '1'),
('countries_sweden_vastra_gotaland_donsoe', 'ChIJhX8PeviST0YRsGFLG3mQAQ8', 57.6016667, 11.8069444, 'city', '0'),
('countries_switzerland_valais_arbaz', 'ChIJQ7ALCznnjkcRrrpg4eji1Qw', 46.2717615, 7.3810394, 'city', '1'),
('countries_switzerland_valais_ardon', 'ChIJO1h97XHDjkcR3zgn98diTfc', 46.2097412, 7.2572286, 'city', '1'),
('countries_sweden_vastra_gotaland_bullaren', 'ChIJ1fI4mbZRREYR7r4o47EjVnw', 58.716667, 11.566667, 'city', '0'),
('countries_switzerland_valais_ausserberg', 'ChIJmWpCZFoTj0cRG2I5tcaTHd0', 46.31444, 7.8507, 'city', '1'),
('countries_switzerland_valais_aven', 'ChIJV4qbBjDDjkcRBVn0aG0RtSc', 46.2368097, 7.2709235, 'city', '1'),
('countries_switzerland_valais_ayent', 'ChIJmXAr6ybhjkcRinO0Xt6ymwA', 46.2765711, 7.4058146, 'city', '1'),
('countries_switzerland_valais_ayer', 'ChIJc1k_Epskj0cRKHR0WP7YVAw', 46.1832742, 7.5967541, 'city', '1'),
('countries_sweden_vastra_gotaland_bramhult', 'ChIJb373BUOgWkYRRMDZf5c3l48', 57.7332682, 13.0168107, 'city', '0'),
('countries_switzerland_valais_bagnes', 'ChIJS_06NYrUjkcRs6zj5Gcv8dU', 46.07173, 7.22404, 'city', '1'),
('countries_switzerland_valais_baltschieder', 'ChIJjXpfQtVsj0cRrCSN8vvzLro', 46.308, 7.86367, 'city', '1'),
('countries_sweden_vastra_gotaland_bohus', 'ChIJkz5atTReRUYRMlyKvXiQASY', 57.8498817, 12.0168595, 'city', '0'),
('countries_switzerland_valais_belalp', 'ChIJ7XXD_HJuj0cRIw-StP24doI', 46.371389, 7.974167, 'city', '1'),
('countries_switzerland_valais_bellwald', 'ChIJZQ8u9YZ7j0cRXcwf_tYQng8', 46.4283572, 8.1578316, 'city', '1'),
('countries_sweden_vastra_gotaland_bjoerkoe', 'ChIJtWPJfEAJX0YRJ0koWNHUU2k', 59.32598, 17.5666859, 'city', '0'),
('countries_switzerland_valais_bettmeralp', 'ChIJWW3FsABwj0cREMtpbPAyT5U', 46.3904991, 8.0618799, 'city', '1'),
('countries_switzerland_valais_birgisch', 'ChIJSbXuXipsj0cRzDvLA7TDnwE', 46.3163296, 7.9559519, 'city', '1'),
('countries_switzerland_valais_bitsch', 'ChIJ7wStwQRvj0cR0GoZQIj_AAQ', 46.3360083, 8.01573, 'city', '1'),
('countries_switzerland_valais_blatten', 'ChIJNc_FhtcMj0cRiMwoqyV296k', 46.4201048, 7.8199932, 'city', '1'),
('countries_switzerland_valais_blignou_ayent', 'ChIJ7yGWoB7ejkcRkGSJfLLW2wo', 46.2725118, 7.3992915, 'city', '1'),
('countries_switzerland_valais_bluche', 'ChIJhXwQqzIej0cR8r9lu0MzEzw', 46.3093274, 7.4958843, 'city', '1'),
('countries_switzerland_valais_botyre_ayent', 'ChIJ889T2x_ejkcRA6_6nIDQKtQ', 46.27607, 7.40445, 'city', '1'),
('countries_switzerland_valais_bovernier', 'ChIJqbsU6prJjkcRI8jarc8DNJs', 46.0804756, 7.0872989, 'city', '1'),
('countries_switzerland_valais_briey_dessus', 'ChIJ36Vjddchj0cRA0lhlC8h9j8', 46.2660777, 7.5290664, 'city', '1'),
('countries_switzerland_valais_brig', 'ChIJrTLvoi1pj0cRdL9-Lc-d8H8', 46.3158992, 7.9878208, 'city', '1'),
('countries_switzerland_valais_brigerbad', 'ChIJdStkJr5rj0cRXiOsC5rTkRo', 46.299722, 7.918056, 'city', '1'),
('countries_sweden_vastra_gotaland_billdal', 'ChIJnyxO8E3sT0YRzKut0DydmuY', 57.5751481, 11.9420489, 'city', '0'),
('countries_sweden_vastra_gotaland_backa', 'ChIJSdhl5en0T0YRgtvJJXmQASY', 57.75, 11.983333, 'city', '0'),
('countries_switzerland_valais_chalais', 'ChIJlwWPLLQhj0cRSxlSmKzotRU', 46.2658436, 7.5089231, 'city', '1'),
('countries_switzerland_valais_chamoson', 'ChIJ4fFssKvGjkcR3vsjQMxJNlQ', 46.2016649, 7.2259937, 'city', '1'),
('countries_sweden_vastra_gotaland_asperoe', 'ChIJwXa55Y6NT0YRMGBLG3mQAQ8', 57.6469444, 11.803611, 'city', '0'),
('countries_switzerland_valais_champsec', 'ChIJKZexhfjRjkcR1KkWGMwquk4', 46.0568687, 7.243475, 'city', '1'),
('countries_switzerland_valais_chandolin', 'ChIJHzbyxmUij0cRzU12cVGODfk', 46.2522028, 7.597252, 'city', '1'),
('countries_sweden_vastra_gotaland_askim', 'ChIJ_WN-lm7tT0YRDF4lW3jj33w', 57.6158441, 11.945608, 'city', '0'),
('countries_switzerland_valais_charrat', 'ChIJaVQslZTIjkcR8NLq0pApU9g', 46.12287, 7.13284, 'city', '1'),
('countries_sweden_vastra_gotaland_alvangen', 'ChIJ-1qc0SxDRUYRjCJKhRbvG38', 57.9591741, 12.1245139, 'city', '0'),
('countries_sweden_vastra_gotaland_algafall', 'ChIJh15e1m9lWkYRezfRf0I-fOg', 57.8177506, 13.9883073, 'city', '1'),
('countries_switzerland_valais_chippis', 'ChIJqTOycmcfj0cR8GwZQIj_AAQ', 46.2795072, 7.5419269, 'city', '1'),
('countries_sweden_vastra_gotaland_alafors', 'ChIJ-fSPuCRcRUYRVxARXOqJO5o', 57.9251336, 12.0891986, 'city', '0'),
('countries_sweden_vastmanland_virsbo_bruk', 'ChIJtU3l2zfZXUYRgN-MsvX-AAo', 59.8730726, 16.0444141, 'city', '0'),
('countries_switzerland_valais_collombey', 'ChIJF-Bqwr2ijkcRg5bS467kRMg', 46.2710282, 6.9459483, 'city', '1'),
('countries_switzerland_valais_collonges', 'ChIJg8khVku4jkcRhbXYBNQ2xeo', 46.169781, 7.033227, 'city', '1'),
('countries_switzerland_valais_conthey', 'ChIJ12N0eljCjkcReWk6cFRLkv0', 46.2244777, 7.303512, 'city', '1'),
('countries_switzerland_valais_crans_montana', 'ChIJczUiOCrgjkcRTsvya2tSwm4', 46.3118579, 7.4823527, 'city', '1'),
('countries_sweden_vastmanland_vasteras', 'ChIJp6lbRYFCXkYRIEBl4rZdQbw', 59.6099005, 16.5448092, 'city', '0'),
('countries_switzerland_valais_daillon', 'ChIJm8dYrjzdjkcRzBs-KQxfW2Q', 46.25467, 7.30361, 'city', '1'),
('countries_sweden_vasternorrland_ornskoldsvik', 'ChIJ27Bwu_REe0YREISM3gZFAwQ', 63.2900474, 18.7166166, 'city', '0'),
('countries_sweden_vasternorrland_jarved', 'ChIJudfjshCofEYR8kd21wdFAyY', 63.2698759, 18.7734748, 'city', '0'),
('countries_switzerland_valais_eggerberg', 'ChIJsyTO9n1rj0cRl8-2trGZXnY', 46.3071455, 7.8810105, 'city', '1'),
('countries_switzerland_valais_eischoll', 'ChIJbQvGmTYUj0cRrqBYJjOeIHg', 46.29327, 7.78062, 'city', '1'),
('countries_switzerland_valais_eisten', 'ChIJT0-zqIFBj0cRQTJGSK2giRw', 46.1974, 7.89508, 'city', '1'),
('countries_switzerland_valais_embd', 'ChIJW-hmQYc_j0cRzJEe_5-YaHc', 46.2182223, 7.830532, 'city', '1'),
('countries_switzerland_valais_erde', 'ChIJoX6ypNDcjkcRYA1vhOOqz2Y', 46.238199, 7.2923297, 'city', '1'),
('countries_switzerland_valais_ergisch', 'ChIJe8tYSvQ9j0cRLO4YErfMX3g', 46.2930165, 7.7137073, 'city', '1'),
('countries_switzerland_valais_ernen', 'ChIJmzwdgOp8j0cR6oMm3pSFgAk', 46.3985001, 8.1457733, 'city', '1'),
('countries_switzerland_valais_erschmatt', 'ChIJZwINq0YXj0cRdBM1oRgcMPY', 46.3215546, 7.6921849, 'city', '1'),
('countries_switzerland_valais_evionnaz', 'ChIJc-y5zoG6jkcRA-aDw0i0j4I', 46.1782231, 7.0223787, 'city', '1'),
('countries_sweden_vasternorrland_harnosand', 'ChIJ03mtNkmDZEYRs0nu2SZWXxQ', 62.6322698, 17.9408714, 'city', '0'),
('countries_sweden_vasternorrland_graningebruk', 'ChIJVbZxYI0mZUYRhGSk7_PIefI', 63.0712679, 16.9396816, 'city', '0'),
('countries_switzerland_valais_ferden', 'ChIJlYhiz8QPj0cRr_9x7BciT9U', 46.3939824, 7.7594746, 'city', '1'),
('countries_switzerland_valais_feschel', 'ChIJ_1dI5Asaj0cRloRX8jLekAE', 46.3217014, 7.671086, 'city', '1'),
('countries_switzerland_valais_fiesch', 'ChIJJ51jChV7j0cRXKh8AVJzRAc', 46.4014491, 8.1333135, 'city', '1'),
('countries_switzerland_valais_fieschertal', 'ChIJH7TIXKN7j0cR1xz37FokQL8', 46.4245787, 8.143049, 'city', '1'),
('countries_switzerland_valais_finhaut', 'ChIJ9U2t49mzjkcRosFzyTeWls8', 46.08337, 6.97688, 'city', '1'),
('countries_sweden_vasternorrland_fagervik', 'ChIJWTfqWKOKZEYRtTqyPRq8V10', 62.5040422, 17.4047473, 'city', '0'),
('countries_sweden_vasternorrland_domsjo', 'ChIJ6xK5q9dXe0YREkh21wdFAyY', 63.2554296, 18.7323284, 'city', '0'),
('countries_switzerland_valais_fully', 'ChIJaXGBLbbHjkcRtxT0-dGzQ-M', 46.1385386, 7.1181106, 'city', '1'),
('countries_sweden_vasternorrland_alno', 'ChIJz-WRuWphZEYRVxfCkzl7B4s', 62.4035166, 17.4604069, 'city', '0'),
('countries_sweden_vasterbotten_ursviken', 'ChIJq4mLr8-SfkYRNrE_WoTwcaU', 64.7072476, 21.173832, 'city', '0'),
('countries_sweden_vasterbotten_skelleftehamn', 'ChIJKZkKTd6MfkYRNqLoaAepy38', 64.6861026, 21.2361263, 'city', '0'),
('countries_sweden_vasterbotten_roebaeck', 'ChIJqcGHKYhbfEYRTrr0pY9qkHI', 63.8085758, 20.1853762, 'city', '0'),
('countries_switzerland_valais_grengiols', 'ChIJyTdDRztlj0cR4TxGcIB4cYA', 46.3723502, 8.0929038, 'city', '1'),
('countries_switzerland_valais_grimentz', 'ChIJVROP7m8kj0cRwYK6RQq1KCs', 46.1805364, 7.5764383, 'city', '1'),
('countries_switzerland_valais_grimisuat', 'ChIJoyZFXgvejkcRYpGk15GxmYE', 46.25837, 7.38235, 'city', '1'),
('countries_sweden_vasterbotten_oerviken', 'ChIJKQhKJxaxb0YR4AERUglFAwo', 63.1074275, 14.4347605, 'city', '0'),
('countries_sweden_vasterbotten_malgomaj', 'ChIJFU80LNS5cEYRUWi3zyHfMjM', 64.7515968, 16.2050092, 'city', '0'),
('countries_sweden_vasterbotten_granoe', 'ChIJ84Pg-3Dze0YRV9xsk3Vb66g', 64.2372797, 19.3416489, 'city', '1'),
('countries_sweden_varmland_sodra_hogsater', 'ChIJ70F4RlLjREYR-nOpQxt7eZM', 58.6502862, 12.0553131, 'city', '0'),
('countries_sweden_varmland_skoghall', 'ChIJWefnp_uxXEYRwGxAo3qQAQo', 59.3246275, 13.4693947, 'city', '0'),
('countries_switzerland_valais_icogne', 'ChIJ8-24C7nhjkcRJPnhNr-zKWI', 46.290802, 7.4381663, 'city', '1'),
('countries_sweden_varmland_hammaro', 'ChIJpbccct2vXEYRltQvm70_OAg', 59.311466, 13.5298543, 'city', '0'),
('countries_switzerland_valais_inden', 'ChIJw0iB5tQbj0cRoaymEKM0dRs', 46.3440334, 7.617709, 'city', '1'),
('countries_sweden_uppsala_spanga', 'ChIJET6MHzaeX0YRnD3nQ8u4r4w', 59.3810033, 17.8999899, 'city', '1'),
('countries_switzerland_valais_kippel', 'ChIJhyvS1OkRj0cR323B3DVuhNI', 46.3993573, 7.7721768, 'city', '1'),
('countries_switzerland_valais_lalden', 'ChIJX0m_EKBrj0cRK06NqGMdf6M', 46.2992864, 7.9033662, 'city', '1'),
('countries_switzerland_valais_lax', 'ChIJ7_0sSSl7j0cRTZAkqV5KBTg', 46.3888552, 8.1200357, 'city', '1'),
('countries_sweden_uppsala_marsta', 'ChIJ-5u9Syy6X0YRAz_4eVoh-Lo', 59.6196463, 17.8555094, 'city', '0'),
('countries_sweden_uppsala_knivsta', 'ChIJ5ZL0JXu4X0YRhJbMDsnzNdQ', 59.7261195, 17.7920363, 'city', '1'),
('countries_sweden_uppsala_hallnas', 'ChIJT9eZE8r3e0YRUHntVAlFAwo', 64.308683, 19.6239562, 'city', '1'),
('countries_sweden_uppsala_graso', 'ChIJ75cR6iFqYEYRpvYjqsWFVLI', 60.4, 18.4166667, 'city', '0'),
('countries_switzerland_valais_lens', 'ChIJM14lf0_gjkcRs203UU18S1Q', 46.2816742, 7.4486411, 'city', '1'),
('countries_switzerland_valais_les_agettes', 'ChIJzQWjJK7ejkcRWxVBtk_NqzM', 46.2086498, 7.376781, 'city', '1'),
('countries_sweden_stockholm_vato', 'ChIJVXCWbyBX9UYRoFwiNPT-AA8', 59.8166667, 18.95, 'city', '0'),
('countries_switzerland_valais_les_giettes', 'ChIJM-bRMXa8jkcRlCPjh2cSblc', 46.227443, 6.973769, 'city', '1'),
('countries_sweden_stockholm_varby', 'ChIJrxZRP_5zX0YREq9d1vP-ACY', 59.2635432, 17.8876479, 'city', '0'),
('countries_sweden_stockholm_vaddo', 'ChIJlflJHAAAYEYRcHEgNPT-AA8', 60, 18.8333333, 'city', '0'),
('countries_sweden_stockholm_uto', 'ChIJawJrfGmL9UYRFXe-MuNXYCE', 58.9361228, 18.2503143, 'city', '0'),
('countries_switzerland_valais_leuk', 'ChIJIddCkKIZj0cRSHOYHn7VESc', 46.3169188, 7.6345834, 'city', '1'),
('countries_switzerland_valais_leukerbad', 'ChIJHy1j8EEbj0cRQZWwxrsQXUo', 46.380024, 7.6288344, 'city', '1'),
('countries_sweden_stockholm_tyreso_strand', 'ChIJ6dP_iP5-X0YRV6UwcSE0oaA', 59.2420766, 18.2827794, 'city', '0'),
('countries_switzerland_valais_leytron', 'ChIJlQVLjEPEjkcRqvZ0pLfLXjI', 46.1866297, 7.2087015, 'city', '1'),
('countries_sweden_stockholm_tumba', 'ChIJX2doWfhtX0YRuj7TeMTbsGA', 59.199859, 17.8309572, 'city', '0'),
('countries_sweden_stockholm_tullinge', 'ChIJ__qFlKJxX0YRNFnP9KfLico', 59.198328, 17.8953001, 'city', '0'),
('countries_switzerland_valais_liddes', 'ChIJp0l8lbAyiUcRSFoJFbr1AQs', 45.9919529, 7.1858196, 'city', '1'),
('countries_sweden_stockholm_trangsund', 'ChIJIxHs4GV5X0YRr3ATA_fQB2w', 59.233333, 18.1333331, 'city', '1'),
('countries_sweden_stockholm_tjocko', 'ChIJF2ihhvNP9UYRuW99qay-9yA', 59.7482322, 19.1313642, 'city', '0'),
('countries_sweden_stockholm_svedmyra', 'ChIJX0gIhX13X0YR12IeeBkdVpo', 59.2745823, 18.0668707, 'city', '0'),
('countries_switzerland_valais_martigny_combe', 'ChIJ9zbv6HO2jkcRAlKOnDGdHvU', 46.083195, 7.0487069, 'city', '1'),
('countries_sweden_stockholm_sundbyberg', 'ChIJe-ywdnqeX0YR3HKHqYkgSFw', 59.3829282, 17.9644707, 'city', '0'),
('countries_sweden_stockholm_stocksund', 'ChIJz5kSFU6cX0YR34vsCfS5b3g', 59.3841662, 18.0478685, 'city', '0'),
('countries_sweden_stockholm_solna', 'ChIJ9bNyL7idX0YRBpNeeT0rX64', 59.3641968, 18.0124231, 'city', '0'),
('countries_switzerland_valais_mase', 'ChIJic7SXVXfjkcRdutFgkHoH_w', 46.1936337, 7.4358076, 'city', '1'),
('countries_switzerland_valais_massongex', 'ChIJR5YX6XO8jkcRZ-zq9zrTW2s', 46.2427101, 6.9879867, 'city', '1'),
('countries_sweden_stockholm_sollentuna', 'ChIJsxdVKNKYX0YR-5lifZtle30', 59.4541218, 17.9242952, 'city', '0'),
('countries_sweden_stockholm_sodertalje', 'ChIJ7-jiVJYSX0YRbBRWGCke3Xw', 59.195363, 17.625689, 'city', '0'),
('countries_sweden_stockholm_skondal', 'ChIJp1eXkgl5X0YRwdyDDNZBmYA', 59.25, 18.1166671, 'city', '0'),
('countries_sweden_stockholm_skogas', 'ChIJmSN8jOZ7X0YRkgyyalWs8Lo', 59.216667, 18.15, 'city', '0'),
('countries_sweden_stockholm_skaerholmen', 'ChIJhfFl15x2X0YRCtXBR2HX36Y', 59.2744378, 17.9019973, 'city', '0'),
('countries_sweden_stockholm_segeltorp', 'ChIJ1TWooL12X0YR0uFR1vP-ACY', 59.2796521, 17.9427538, 'city', '0'),
('countries_sweden_stockholm_saltsjoe_boo', 'ChIJzTYiaJSBX0YRhXGmTm0-tss', 59.3307172, 18.2867058, 'city', '0'),
('countries_sweden_stockholm_rinkeby', 'ChIJ1ezayF6eX0YRL1v7RTsWZXY', 59.388791, 17.9278537, 'city', '0'),
('countries_switzerland_valais_monthey', 'ChIJR-W61sG8jkcRZzRRKKVs2uY', 46.2521873, 6.9469598, 'city', '1'),
('countries_sweden_stockholm_norsborg', 'ChIJLRt8b3NzX0YRcBjzZKS9Xow', 59.24607, 17.8231225, 'city', '0'),
('countries_switzerland_valais_morgins', 'ChIJD4-5k4ujjkcRlAVTQYQeuHM', 46.2382, 6.8519, 'city', '1'),
('countries_sweden_stockholm_nora', 'ChIJQ--Bfv1FXEYRcAspi-Zg89s', 59.5192064, 15.0378667, 'city', '0'),
('countries_switzerland_valais_mund', 'ChIJQQkuxlJsj0cRlgP-MHeXs_s', 46.3163061, 7.9427383, 'city', '1'),
('countries_sweden_stockholm_nacka', 'ChIJI3nEC_iBX0YRTh5pF4GA4jo', 59.3092328, 18.2705343, 'city', '0'),
('countries_switzerland_valais_naters', 'ChIJ3VZmMSduj0cRLY06kLslGDE', 46.3239282, 7.9916569, 'city', '1'),
('countries_switzerland_valais_nax', 'ChIJkbVd5LAgj0cRKSzkrAlnofQ', 46.228419, 7.4283844, 'city', '1'),
('countries_sweden_stockholm_muskoe', 'ChIJAR7GGLFhX0YRDDrDist1-no', 58.9999599, 18.1262047, 'city', '0'),
('countries_switzerland_valais_niedergesteln', 'ChIJs9zDM5ATj0cRjNvptPAMN_g', 46.3137237, 7.7810426, 'city', '1'),
('countries_sweden_stockholm_moja', 'ChIJd_5Qzb5v9UYROOZXB_dyZ2o', 59.4265609, 18.8861369, 'city', '0'),
('countries_switzerland_valais_oberems', 'ChIJaT89FLoXj0cRcqmzDsdj6uQ', 46.281652, 7.6955244, 'city', '1'),
('countries_sweden_stockholm_ljustero', 'ChIJZXmPEEFi9UYRgFMOG_TSG6k', 59.5061429, 18.5969088, 'city', '0'),
('countries_sweden_stockholm_liljeholmen', 'ChIJA8HvvrB3X0YRD3PuLVdpn8U', 59.3093002, 18.0245981, 'city', '0'),
('countries_sweden_stockholm_kista', 'ChIJyVwAVYmeX0YRz9LWK195u_8', 59.4024341, 17.9464824, 'city', '0'),
('countries_sweden_stockholm_johanneshov', 'ChIJa8PrqyZ4X0YRAdgbNfT-ACY', 59.2964153, 18.0755919, 'city', '0'),
('countries_sweden_stockholm_ingmarso', 'ChIJTynf-1xk9UYR0LYgNPT-AA8', 59.4736515, 18.7694402, 'city', '0'),
('countries_switzerland_valais_praz_de_fort', 'ChIJ9xH_qFXLjkcR_kyXRKt70kY', 45.98977, 7.12526, 'city', '1'),
('countries_switzerland_valais_randa', 'ChIJU2Bdh_Y3j0cRoG4ZQIj_AAQ', 46.1011132, 7.7840062, 'city', '1'),
('countries_sweden_stockholm_huddinge', 'ChIJxyVLA3V6X0YROP4YezDuGVQ', 59.2097726, 18.052167, 'city', '0'),
('countries_switzerland_valais_raron', 'ChIJGWLCM5ATj0cRfMtBHNs-yvc', 46.3090067, 7.80016, 'city', '1'),
('countries_sweden_stockholm_herrangen', 'ChIJJRrf_912X0YRB3SRfXMom7g', 59.2737444, 17.9686327, 'city', '0'),
('countries_sweden_stockholm_haesselby_strand', 'ChIJsyPSYV91X0YRSVYeRzhdS8g', 59.360868, 17.8331834, 'city', '0'),
('countries_sweden_stockholm_haesselby', 'ChIJyWJOEsufX0YR0EN6IeMItBk', 59.3662135, 17.8599925, 'city', '0'),
('countries_switzerland_valais_riddes', 'ChIJOYxy3v3EjkcR5gdJYE1S9Rg', 46.1731437, 7.2225149, 'city', '1'),
('countries_sweden_stockholm_gallno', 'ChIJZaAYu2Z79UYR8MYgNPT-AA8', 59.3909374, 18.6477675, 'city', '0'),
('countries_switzerland_valais_riederalp', 'ChIJt2G6h8Rvj0cRB3zahIwtn-g', 46.37658, 8.02565, 'city', '1'),
('countries_sweden_stockholm_furusund', 'ChIJc40ss2hc9UYR0C8hNPT-AA8', 59.6635126, 18.9156633, 'city', '0'),
('countries_switzerland_valais_roumaz_saviese', 'ChIJ0RslBLTdjkcR_z8-eo824Wc', 46.246254, 7.347217, 'city', '1'),
('countries_switzerland_valais_saas_almagell', 'ChIJu-eAU1hFj0cRVVb01xxQL9s', 46.0945114, 7.9575088, 'city', '1'),
('countries_switzerland_valais_saas_balen', 'ChIJIRouQgxEj0cRDOokSePxgjw', 46.1533008, 7.9284545, 'city', '1'),
('countries_sweden_stockholm_flemingsberg', 'ChIJ50NoCY5wX0YRRwDWF1M6JsU', 59.2198142, 17.9466915, 'city', '0'),
('countries_switzerland_valais_saas_grund', 'ChIJXWpgPxBFj0cRYpZnTweSdbQ', 46.1229266, 7.9365532, 'city', '1'),
('countries_switzerland_valais_saillon', 'ChIJe2k2nc3FjkcRUP3SZ25RjMA', 46.1707092, 7.1858418, 'city', '1'),
('countries_switzerland_valais_saint_gingolph', 'ChIJzwO46dedjkcRlRcg1FE1m_Q', 46.390824, 6.8048266, 'city', '1'),
('countries_switzerland_valais_saint_jean', 'ChIJB_WRAIUjj0cRqEfJpR6x89w', 46.1977351, 7.5862859, 'city', '1'),
('countries_switzerland_valais_saint_luc', 'ChIJOSSz8akjj0cRDqhXh9QEVYw', 46.2201053, 7.5979948, 'city', '1'),
('countries_switzerland_valais_saint_martin', 'ChIJqfquOJwnj0cRznX8Y7wzhK0', 46.1732924, 7.4433152, 'city', '1'),
('countries_switzerland_valais_saint_maurice', 'ChIJRV8PgWm5jkcRBeDt2BGIdoE', 46.214941, 7.0047948, 'city', '1'),
('countries_sweden_stockholm_farsta_strand', 'ChIJFZCUCXh5X0YR0kOqv3NKvYQ', 59.2349966, 18.0939904, 'city', '0'),
('countries_switzerland_valais_salgesch', 'ChIJCXPxVdAej0cRiZ1wc1dZMMQ', 46.3117718, 7.5704709, 'city', '1'),
('countries_sweden_stockholm_enskede_gard', 'ChIJeyZLe493X0YRUmlK1vP-ACY', 59.289359, 18.0675618, 'city', '0'),
('countries_switzerland_valais_salvan', 'ChIJPdzsXiexjkcRDDmzWB5WFok', 46.1200551, 7.0202955, 'city', '1'),
('countries_switzerland_valais_sankt_german', 'ChIJ_5_E65EUj0cR-in_gUBTgk8', 46.31243, 7.82185, 'city', '1'),
('countries_sweden_stockholm_enskede_arsta_vantoer', 'ChIJuUXxoCZ4X0YRb19uB8aRpCY', 59.2762834, 18.0385285, 'city', '0'),
('countries_sweden_stockholm_enebyberg', 'ChIJmaLL11OZX0YRyeLyrzTekAA', 59.4324812, 18.0391086, 'city', '0'),
('countries_sweden_stockholm_ekero', 'ChIJDfOnlD4KX0YRyQL1CWcvnvE', 59.359052, 17.6694942, 'city', '0'),
('countries_switzerland_valais_saxon', 'ChIJWS0wH-TFjkcRiF2tbwYv0cM', 46.1513081, 7.1788401, 'city', '1'),
('countries_sweden_stockholm_drottningholm', 'ChIJC-tbJ6V1X0YRLuxEYpbn5f8', 59.3254794, 17.8886966, 'city', '0'),
('countries_switzerland_valais_sembrancher', 'ChIJ9cSfpjfJjkcRHDtNXXzJPBc', 46.076873, 7.1549025, 'city', '1'),
('countries_sweden_stockholm_djursholm', 'ChIJ3d-YiYCbX0YRUaZbQ6YtbHo', 59.3970725, 18.0903005, 'city', '0'),
('countries_switzerland_valais_sierre', 'ChIJ51VcuCAgj0cRTlhNfFM9yhU', 46.2941311, 7.5335362, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_sweden_stockholm_danderyd', 'ChIJW0GnfWacX0YRsPz2Uo6XmYg', 59.4058934, 18.0258329, 'city', '0'),
('countries_switzerland_valais_sion', 'ChIJrxr52IXejkcRyoqHNn2uP_4', 46.2331221, 7.360626, 'city', '1'),
('countries_sweden_stockholm_bromma', 'ChIJgcnKQx6eX0YRS2IdUseNk3k', 59.3397832, 17.9397131, 'city', '0'),
('countries_switzerland_valais_stalden', 'ChIJ2VFG4DBAj0cRiMeOTvoZ5YM', 46.2331036, 7.8706705, 'city', '1'),
('countries_switzerland_valais_staldenried', 'ChIJDzCmGcxBj0cRgegsdOGp4n0', 46.2297939, 7.8831391, 'city', '1'),
('countries_switzerland_valais_steg_gampel', 'ChIJ85HKg1YRj0cRmltrEPVX_BA', 46.3151515, 7.748743, 'city', '1'),
('countries_sweden_stockholm_blidoe', 'ChIJ1Zc-GnNd9UYRACohNPT-AA8', 59.6182513, 18.9095765, 'city', '0'),
('countries_sweden_stockholm_bjorko', 'ChIJtWPJfEAJX0YRJ0koWNHUU2k', 59.32598, 17.5666859, 'city', '0'),
('countries_sweden_stockholm_bergshamra', 'ChIJt132oE6cX0YR1afek7eDhaU', 59.3803526, 18.0327096, 'city', '0'),
('countries_switzerland_valais_termen', 'ChIJw81nEAdmj0cRQBTCN-LuEko', 46.32771, 8.0220699, 'city', '1'),
('countries_sweden_stockholm_barkarby', 'ChIJi8TipAyfX0YRRs9UWDo_adU', 59.4001312, 17.8625102, 'city', '0'),
('countries_switzerland_valais_torgon', 'ChIJARl3YZCYjkcRuBkdXMGhBw4', 46.320278, 6.876389, 'city', '1'),
('countries_switzerland_valais_trient', 'ChIJ-8eFbji0jkcR7Hn7uxVf9Fk', 46.0556748, 6.996041, 'city', '1'),
('countries_switzerland_valais_troistorrents', 'ChIJPfaCb6q8jkcRyBXb1QfUHsM', 46.2312995, 6.9194416, 'city', '1'),
('countries_switzerland_valais_turin_salins', 'ChIJ9ZA79BDcjkcRFINfiK-nx7A', 46.21514, 7.35427, 'city', '1'),
('countries_switzerland_valais_turtmann', 'ChIJ_YFFSgEXj0cRiZyZGMJFymI', 46.3019514, 7.704482, 'city', '1'),
('countries_sweden_stockholm_bandhagen', 'ChIJ58D_HEF3X0YRUmhK1vP-ACY', 59.2678465, 18.0515894, 'city', '0'),
('countries_sweden_stockholm_bagarmossen', 'ChIJpTF7VUV4X0YRQoAJ05gp668', 59.2743878, 18.1338486, 'city', '0'),
('countries_switzerland_valais_unterems', 'ChIJoQ7vGK4Xj0cRQcmBtbaTeQk', 46.2915641, 7.6966705, 'city', '1'),
('countries_switzerland_valais_uvrier', 'ChIJJZ4GZknejkcRHDAput9Dyq8', 46.2532603, 7.4169069, 'city', '1'),
('countries_sweden_stockholm_arsta', 'ChIJW7dcQ4V3X0YR-fd1AI-WJ6M', 59.2985832, 18.0459442, 'city', '0'),
('countries_switzerland_valais_varen', 'ChIJeScc91gZj0cRUIwDQcAqs-Y', 46.3172362, 7.6064545, 'city', '1'),
('countries_sweden_stockholm_arninge', 'ChIJe1nMHvyaX0YR8DyNsvX-AAo', 59.4658303, 18.1292984, 'city', '0'),
('countries_sweden_stockholm_alvsjo', 'ChIJV0zIfQ13X0YRurHvu9tLBbU', 59.2744881, 18.0051297, 'city', '0'),
('countries_switzerland_valais_vercorin', 'ChIJu6L3G8Uhj0cRVF6YHwGP8fM', 46.257222, 7.530556, 'city', '1'),
('countries_switzerland_valais_vernayaz', 'ChIJKwDVCZW3jkcRzds1L6VflxY', 46.13465, 7.03959, 'city', '1'),
('countries_sweden_stockholm_alvik', 'ChIJA4VtYhh2X0YRenYpXbNmoks', 59.3329563, 17.9803452, 'city', '0'),
('countries_sweden_stockholm_adelsoe', 'ChIJGZHaCHIIX0YRJrpWF5gqOZg', 59.3782074, 17.4887955, 'city', '0'),
('countries_sweden_sodermanland_stora_sundby', 'ChIJG67O42SXXkYRWvaZbMGkqCw', 59.2701773, 16.1268046, 'city', '0'),
('countries_switzerland_valais_vex', 'ChIJpQ46OzfZjkcRupQ1rfkh6Wk', 46.2113569, 7.3982929, 'city', '1'),
('countries_switzerland_valais_veyras', 'ChIJ82SLnR0fj0cRmeUZDB4Y1rs', 46.3045233, 7.5389954, 'city', '1'),
('countries_switzerland_valais_veysonnaz', 'ChIJuQDRI4zbjkcRAGmnZNeyXNc', 46.1957548, 7.3379757, 'city', '1'),
('countries_sweden_sodermanland_skoeldinge', 'ChIJCZsF-Qm4XkYRVum_FYAVk1A', 59.0310046, 16.4460913, 'city', '1'),
('countries_switzerland_valais_vionnaz', 'ChIJYf1BqXeYjkcRI5XNk8nCnOM', 46.3103435, 6.90262, 'city', '1'),
('countries_switzerland_valais_visp', 'ChIJeSGraQVrj0cR6BVgUfrYMYU', 46.2947277, 7.8821204, 'city', '1'),
('countries_switzerland_valais_visperterminen', 'ChIJg7P5gwZCj0cROdGuEF38eoU', 46.26013, 7.90302, 'city', '1'),
('countries_switzerland_valais_vissoie', 'ChIJVdzBGqcjj0cRezxCRmRgMEg', 46.2152089, 7.5855942, 'city', '1'),
('countries_sweden_sodermanland_julita', 'ChIJtaKetcu8XkYR3sqcRKbPiRE', 59.1483645, 16.0449411, 'city', '0'),
('countries_switzerland_valais_vouvry', 'ChIJ4QVBO86YjkcRBqE5-35oXMc', 46.3363829, 6.8910112, 'city', '1'),
('countries_switzerland_valais_wiler', 'ChIJk_7e8wAOj0cRzFhpu-UQ7H0', 46.4022173, 7.7827556, 'city', '1'),
('countries_switzerland_valais_zeneggen', 'ChIJcZETlMBqj0cR8bfjc4djt4I', 46.2733289, 7.8667105, 'city', '1'),
('countries_switzerland_valais_zermatt', 'ChIJzeUuKaI1j0cRcG8ZQIj_AAQ', 46.0207133, 7.749117, 'city', '1'),
('countries_switzerland_vaud_aclens', 'ChIJO1WWlCE0jEcRQAxrh6SNYBE', 46.5677921, 6.5099601, 'city', '1'),
('countries_switzerland_vaud_agiez', 'ChIJDxhhNIrJjUcRbe7Ll2v7rtw', 46.720125, 6.5097535, 'city', '1'),
('countries_switzerland_vaud_aigle', 'ChIJM07TkMSXjkcRGNIsmOulNqk', 46.3190253, 6.970566, 'city', '1'),
('countries_switzerland_vaud_allaman', 'ChIJV24Tr7lHjEcRTLFYXsbDi7c', 46.4709528, 6.3957297, 'city', '1'),
('countries_switzerland_vaud_apples', 'ChIJC3ieZJFJjEcRAM7vcMDs2UA', 46.5521915, 6.4289378, 'city', '1'),
('countries_switzerland_vaud_aran', 'ChIJU_nEBswojEcRSllH_5HwFyw', 46.49828, 6.71, 'city', '1'),
('countries_switzerland_vaud_arnex_sur_nyon', 'ChIJISTJ-A1djEcR0FoZQIj_AAQ', 46.3752208, 6.1915674, 'city', '1'),
('countries_switzerland_vaud_arnex_sur_orbe', 'ChIJBRq_PEvKjUcRNtdSwmpX_WI', 46.6938865, 6.5187451, 'city', '1'),
('countries_sweden_skane_stroevelstorp', 'ChIJMzVPh1krUkYR8ERAo3qQAQo', 56.1693511, 12.8353858, 'city', '1'),
('countries_switzerland_vaud_arzier_le_muids', 'ChIJYYl6DfZZjEcRoKCRDQBtgyc', 46.4575812, 6.2100996, 'city', '1'),
('countries_switzerland_vaud_assens', 'ChIJlcEHKJcyjEcRAfFYhRRti3M', 46.6132945, 6.6226762, 'city', '1'),
('countries_switzerland_vaud_aubonne', 'ChIJdTTIVdVHjEcR4EEZQIj_AAQ', 46.4953291, 6.3918325, 'city', '1'),
('countries_switzerland_vaud_avenches', 'ChIJVWNjCLFzjkcRL36owFWIQ88', 46.8806009, 7.0427075, 'city', '1'),
('countries_switzerland_vaud_ballaigues', 'ChIJQbJY0Z62jUcR2BvPvfLr3vg', 46.7296887, 6.4159236, 'city', '1'),
('countries_switzerland_vaud_ballens', 'ChIJdfvyvUBJjEcRzyOdBQNBJs8', 46.5543525, 6.3753084, 'city', '1'),
('countries_switzerland_vaud_bassins', 'ChIJj7YZmmFajEcRHwnu_NiVIAE', 46.4662366, 6.2315413, 'city', '1'),
('countries_switzerland_vaud_baulmes', 'ChIJwyQNCwG4jUcR8Ylj7Da8CLg', 46.7895163, 6.521739, 'city', '1'),
('countries_switzerland_vaud_bavois', 'ChIJOwI-44fLjUcROFVdDZpAa0k', 46.6860182, 6.5653718, 'city', '1'),
('countries_switzerland_vaud_begnins', 'ChIJBUkriSRFjEcR4ZKdDAUKwGs', 46.4408426, 6.2477524, 'city', '1'),
('countries_switzerland_vaud_bellerive', 'ChIJcSrOfc0MjkcRp6HaZdKrZdo', 46.9204141, 7.02158, 'city', '1'),
('countries_switzerland_vaud_belmont_sur_lausanne', 'ChIJG7RZguMujEcRN4pA48GUPE8', 46.5191267, 6.6789123, 'city', '1'),
('countries_switzerland_vaud_belmont_sur_yverdon', 'ChIJ8XBwhk_OjUcRAcjHzoGcvDU', 46.7453758, 6.624103, 'city', '1'),
('countries_switzerland_vaud_bercher', 'ChIJufhtPTPSjUcRMsgVCpC5p-8', 46.6920622, 6.708587, 'city', '1'),
('countries_switzerland_vaud_berolle', 'ChIJp2s73LtOjEcRBJ8CIFMW_Xg', 46.558338, 6.3369412, 'city', '1'),
('countries_switzerland_vaud_bettens', 'ChIJiUM9tTczjEcRjWIQN_m9Qik', 46.6279889, 6.5773317, 'city', '1'),
('countries_switzerland_vaud_bex', 'ChIJc-xuIXO_jkcRa8UTCP3k6ew', 46.2499847, 7.0142664, 'city', '1'),
('countries_sweden_skane_skanoer_med_falsterbo', 'ChIJg6G-kPAOU0YRvRAXhd13XQo', 55.4078231, 12.8467484, 'city', '0'),
('countries_switzerland_vaud_bioley_magnoux', 'ChIJVfIR4wrRjUcRAGMZQIj_AAQ', 46.7269672, 6.7114717, 'city', '1'),
('countries_switzerland_vaud_bioley_orjulaz', 'ChIJt4Vi0tgyjEcRkiI9hJfrdXE', 46.6212, 6.59814, 'city', '1'),
('countries_switzerland_vaud_blonay', 'ChIJu3Egf-eEjkcRYG3QeqMq20k', 46.4647104, 6.8946536, 'city', '1'),
('countries_switzerland_vaud_bofflens', 'ChIJ8dcWcBXKjUcRE3q2PGMD5zI', 46.705068, 6.4982378, 'city', '1'),
('countries_switzerland_vaud_bogis_bossey', 'ChIJCdYt0XhdjEcREFsZQIj_AAQ', 46.352546, 6.1654551, 'city', '1'),
('countries_switzerland_vaud_bonvillars', 'ChIJzyR0BcbEjUcRrYv0DYYh6AY', 46.8392361, 6.6714518, 'city', '1'),
('countries_switzerland_vaud_borex', 'ChIJz11KtQVdjEcRPG8bAcseBas', 46.3786499, 6.1774963, 'city', '1'),
('countries_switzerland_vaud_bottens', 'ChIJgb5zozgtjEcRq85A55SJQOg', 46.6169495, 6.6603021, 'city', '1'),
('countries_switzerland_vaud_bougy_villars', 'ChIJEQ0UchBGjEcRIKi4Q3hReow', 46.47839, 6.35303, 'city', '1'),
('countries_switzerland_vaud_boulens', 'ChIJJckt-ZrTjUcRYOQojgmvFXw', 46.6800404, 6.7195938, 'city', '1'),
('countries_switzerland_vaud_bournens', 'ChIJ439lAW4zjEcRlR56dqnFgzQ', 46.6041957, 6.5636887, 'city', '1'),
('countries_switzerland_vaud_boussens', 'ChIJIbuUWQQzjEcR0EMZQIj_AAQ', 46.6027375, 6.5838525, 'city', '1'),
('countries_switzerland_vaud_bremblens', 'ChIJzYw4lLs2jEcR4gAldIErKfQ', 46.5454875, 6.5186099, 'city', '1'),
('countries_switzerland_vaud_brenles', 'ChIJ85MSXW5_jkcRpWZhIVuxijs', 46.671816, 6.853117, 'city', '1'),
('countries_sweden_skane_roeke', 'ChIJgY-nqDRZUUYRg0Kx8Xofcts', 56.2348845, 13.5209627, 'city', '1'),
('countries_switzerland_vaud_bretigny_sur_morrens', 'ChIJb9GHT3ktjEcRDNAhRifGt24', 46.5980923, 6.641246, 'city', '1'),
('countries_sweden_skane_ramloesa', 'ChIJ-YKj4p8zUkYRYITgmqat7WY', 56.0216112, 12.7429168, 'city', '0'),
('countries_switzerland_vaud_buchillon', 'ChIJ8WJ2lPRHjEcRlkY93VbfhDs', 46.4693789, 6.4200054, 'city', '1'),
('countries_sweden_skane_raa', 'ChIJiczuE1YzUkYRlYkG4XYR-_A', 55.9993601, 12.7401366, 'city', '0'),
('countries_switzerland_vaud_bullet', 'ChIJCWOonVTGjUcRKm-Y7cADj4U', 46.8307957, 6.5543666, 'city', '1'),
('countries_switzerland_vaud_bursinel', 'ChIJC19hEgVEjEcROpJl16_oCOU', 46.443808, 6.3069533, 'city', '1'),
('countries_switzerland_vaud_bursins', 'ChIJo9TvWFZEjEcRqLWx5zb5LEs', 46.452203, 6.2907857, 'city', '1'),
('countries_switzerland_vaud_burtigny', 'ChIJwzU3sSBFjEcRiGmsLHYz81c', 46.4675773, 6.2569481, 'city', '1'),
('countries_sweden_skane_oestra_soennarsloev', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_bussigny_sur_oron', 'ChIJt3oRagaBjkcRuG2nWjnUgzU', 46.56963, 6.86296, 'city', '1'),
('countries_sweden_skane_malmo', 'ChIJ7xnvNhGhU0YR9gdmGbJo3Lo', 55.5790534, 13.0108705, 'city', '0'),
('countries_sweden_skane_limhamn', 'ChIJPfoVWOamU0YRu6Yn39rzdvs', 55.5724415, 12.9147749, 'city', '0'),
('countries_switzerland_vaud_chabrey', 'ChIJMayiUj4LjkcRBv75YRAoT1I', 46.9268456, 6.981517, 'city', '1'),
('countries_sweden_skane_haersloev', NULL, 0, 0, 'city', '0'),
('countries_sweden_skane_huaroed', 'ChIJISM8wFUJVEYRYyRUyxZVytY', 55.8421433, 13.9690448, 'city', '1'),
('countries_switzerland_vaud_chamblon', 'ChIJMxj3rUDPjUcRZp7lhPV1SFc', 46.7782322, 6.6042766, 'city', '1'),
('countries_sweden_skane_aesperoed', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_champagne', 'ChIJa_OXYAbFjUcRKcdGIbifOng', 46.83086, 6.6583, 'city', '1'),
('countries_switzerland_vaud_champtauroz', 'ChIJX1o3VRXXjUcRC0wj1ak1l0Q', 46.7602888, 6.7876222, 'city', '1'),
('countries_switzerland_vaud_champvent', 'ChIJSbehh5jIjUcRuLWT1W4IYfc', 46.7829756, 6.5728678, 'city', '1'),
('countries_sweden_ostergotland_vreta_kloster', 'ChIJX2PiLfxmWUYRhDE6baPt4dg', 58.4810449, 15.5147372, 'city', '0'),
('countries_switzerland_vaud_chapelle_sur_moudon', 'ChIJFe1xRoLTjUcRlkc8d-iKNKQ', 46.6689929, 6.7346379, 'city', '1'),
('countries_switzerland_vaud_chardonne', 'ChIJrVDSxMuCjkcRrDQLtb1qIlg', 46.4769475, 6.8342278, 'city', '1'),
('countries_sweden_orebro_gryt', 'ChIJnSWtJmCNWEYRpiot9PqkJgQ', 58.1871883, 16.8020384, 'city', '1'),
('countries_sweden_orebro_alvesta', 'ChIJcfSG19QrV0YRsI_kQfP-AAQ', 56.8992104, 14.5560006, 'city', '0'),
('countries_sweden_norrbotten_seittenkaari', 'ChIJzyb8t7BC1UURXlMh2uWN-eU', 65.7349339, 23.744574, 'city', '0'),
('countries_sweden_kronoberg_dioe', 'ChIJc1iKjlTNVkYRoPCMsvX-AAo', 56.641232, 14.222439, 'city', '1'),
('countries_sweden_kalmar_vassmoloesa', 'ChIJPU6bNM0yVkYRxL8m4F_vHho', 56.5936863, 16.1599987, 'city', '1'),
('countries_switzerland_vaud_chavannes_le_veyron', 'ChIJr1X0Oo9KjEcRu-g1ugU7khU', 46.6057547, 6.4512676, 'city', '1'),
('countries_switzerland_vaud_chavornay', 'ChIJ2Rc8NQjMjUcRfMCXKyi4eEY', 46.7088129, 6.5707689, 'city', '1'),
('countries_switzerland_vaud_chenaux', 'ChIJ_XpdP-oojEcRF5qsJwVtvfE', 46.4958069, 6.7286641, 'city', '1'),
('countries_sweden_kalmar_nybro', 'ChIJvTMZfcG2V0YRxMRpzcASdIc', 56.745012, 15.907874, 'city', '0'),
('countries_sweden_jonkoping_visingso', 'ChIJgzDes-RGWkYRzD0wAJC32E0', 58.0491787, 14.3431721, 'city', '0'),
('countries_switzerland_vaud_chesalles_sur_moudon', 'ChIJr5rRMorVjUcRsH4ZQIj_AAQ', 46.6758661, 6.8337951, 'city', '1'),
('countries_switzerland_vaud_chesalles_sur_oron', 'ChIJd1yczLKBjkcRSzUPLJ72giw', 46.5768199, 6.8532023, 'city', '1'),
('countries_sweden_jonkoping_norrahammar', 'ChIJ-cFbDsRzWkYRoIFAo3qQAQo', 57.6970541, 14.1095846, 'city', '0'),
('countries_switzerland_vaud_cheseaux_sur_lausanne', 'ChIJ55jYKUUyjEcRHZoRwxaNJxw', 46.585452, 6.6047712, 'city', '1'),
('countries_sweden_jonkoping_jonkoping', 'ChIJLdFbVjGAUEYRbfbC3Fe-AYs', 57.7826137, 14.1617876, 'city', '0'),
('countries_sweden_jonkoping_bolmso', 'ChIJh3dPxCLhUEYR8O4hNPT-AA8', 56.9333333, 13.7333333, 'city', '0'),
('countries_switzerland_vaud_chessel', 'ChIJ48pqhqeZjkcRrxxDAGAITLs', 46.3494222, 6.8943585, 'city', '1'),
('countries_switzerland_vaud_chevilly', 'ChIJcYzoI63KjUcRO_s4SRIMuW0', 46.6425155, 6.4768334, 'city', '1'),
('countries_switzerland_vaud_chevroux', 'ChIJn7EAXWN1jkcRJC-Dvd1FepE', 46.8893493, 6.9079618, 'city', '1'),
('countries_switzerland_vaud_chexbres', 'ChIJ9dgDo6CCjkcRSLcvz4IPMbU', 46.481692, 6.7788078, 'city', '1'),
('countries_switzerland_vaud_chigny', 'ChIJp4G5xac3jEcRsIQZQIj_AAQ', 46.5198495, 6.4770127, 'city', '1'),
('countries_switzerland_vaud_clarens', 'ChIJp9EGWWqbjkcRb5fdgZ8JWNQ', 46.442, 6.894, 'city', '1'),
('countries_switzerland_vaud_clarmont', 'ChIJa1EiHBk2jEcRwIQZQIj_AAQ', 46.5468467, 6.4499056, 'city', '1'),
('countries_switzerland_vaud_coinsins', 'ChIJb8Mihq5EjEcRo1Q9DuI31TE', 46.4245549, 6.2361235, 'city', '1'),
('countries_switzerland_vaud_colombier', 'ChIJQ_l633I2jEcR5TfufKxzwfE', 46.5563035, 6.4728374, 'city', '1'),
('countries_sweden_jonkoping_bjoerkoeby', 'ChIJtWPJfEAJX0YRJ0koWNHUU2k', 59.32598, 17.5666859, 'city', '0'),
('countries_sweden_jamtland_froso', 'ChIJNQ2Hdh62b0YR0UBkDSjBcUw', 63.1958424, 14.5293005, 'city', '0'),
('countries_switzerland_vaud_commugny', 'ChIJaWcV3a5njEcRU3zS1u44Exc', 46.3187046, 6.1774577, 'city', '1'),
('countries_switzerland_vaud_concise', 'ChIJNYYmnmPbjUcRrDazoIAafXo', 46.8543007, 6.7191022, 'city', '1'),
('countries_switzerland_vaud_constantine', 'ChIJK-kN9EpzjkcRx8ptz4wUVP0', 46.9186759, 7.0114287, 'city', '1'),
('countries_switzerland_vaud_coppet', 'ChIJoQttv8NnjEcRDJyFvg2KpDw', 46.3166195, 6.1935705, 'city', '1'),
('countries_switzerland_vaud_corbeyrier', 'ChIJ3abS73CXjkcR2hilLFrVR24', 46.3491052, 6.9598484, 'city', '1'),
('countries_switzerland_vaud_corcelles_le_jorat', 'ChIJ70fI-mErjEcRSInwlLdow9w', 46.6064999, 6.7422889, 'city', '1'),
('countries_sweden_halland_kungsaeter', 'ChIJaWkVQzQjUEYRceEEO6Nw_BI', 57.3075992, 12.5758928, 'city', '1'),
('countries_sweden_halland_kullavik', 'ChIJ59cMQlvsT0YRrrSAN8CevUs', 57.5473883, 11.9430698, 'city', '0'),
('countries_switzerland_vaud_corcelles_sur_chavornay', 'ChIJ-y-Dri_MjUcRv6kqvHaC_Wg', 46.7029453, 6.5996501, 'city', '1'),
('countries_switzerland_vaud_corseaux', 'ChIJW_Wh5DydjkcRPIqUSVjvyok', 46.4702528, 6.8289971, 'city', '1'),
('countries_switzerland_vaud_corsier_sur_vevey', 'ChIJY2GzdHKDjkcRLTuj4UyMVko', 46.4725243, 6.8482854, 'city', '1'),
('countries_switzerland_vaud_cossonay', 'ChIJxbeVeeM0jEcRYTJjNZXBfEk', 46.6135327, 6.5081849, 'city', '1'),
('countries_switzerland_vaud_cottens', 'ChIJ3022Yvk1jEcRZQe4f7jOWeY', 46.5720815, 6.4539944, 'city', '1'),
('countries_switzerland_vaud_cotterd', 'ChIJMQG-3tIMjkcRbQdCAWA5MoQ', 46.920437, 7.0218454, 'city', '1'),
('countries_switzerland_vaud_crassier', 'ChIJIRLJMrtdjEcRCCJtAk50Q5s', 46.3744662, 6.1635803, 'city', '1'),
('countries_switzerland_vaud_cremin', 'ChIJifl1gSTWjUcRFr5Qqqz6sIU', 46.7260507, 6.8430763, 'city', '1'),
('countries_switzerland_vaud_crissier', 'ChIJk-nyxNUzjEcRqeLgtdgx0zg', 46.5518687, 6.5743458, 'city', '1'),
('countries_switzerland_vaud_cronay', 'ChIJudS8GEXQjUcRHVJasSRMIIk', 46.7571978, 6.6968245, 'city', '1'),
('countries_switzerland_vaud_croy', 'ChIJkSnVrAzKjUcRlB7pXyQ2LfU', 46.6940322, 6.4771608, 'city', '1'),
('countries_switzerland_vaud_cuarnens', 'ChIJo-I_JsRKjEcRfB4Gb3jTVVE', 46.6247604, 6.4388657, 'city', '1'),
('countries_switzerland_vaud_cuarny', 'ChIJ_ckx3xDQjUcRJojrRz91QlM', 46.7704322, 6.6893549, 'city', '1'),
('countries_switzerland_vaud_cudrefin', 'ChIJB6NwYY8MjkcRHE9Zxf4U6po', 46.9529982, 7.0231305, 'city', '1'),
('countries_switzerland_vaud_cugy', 'ChIJZ-Lc2p0tjEcRYzf2C-xA-bM', 46.5851396, 6.6402929, 'city', '1'),
('countries_switzerland_vaud_cully', 'ChIJxwJUL4QojEcRKgsb-2yr_zA', 46.4895985, 6.7290888, 'city', '1'),
('countries_switzerland_vaud_curtilles', 'ChIJR8lYcKt4jkcR7Ew4GDCYjZY', 46.699182, 6.8495318, 'city', '1'),
('countries_switzerland_vaud_daillens', 'ChIJ2fCHiqg0jEcRxAglU-Tm3iM', 46.6205182, 6.5485233, 'city', '1'),
('countries_sweden_gotland_kyrkby', 'ChIJER-fLqSMT0YRs7XM3oe7byI', 57.714646, 11.902302, 'city', '0'),
('countries_switzerland_vaud_denens', 'ChIJa1Mi_8U3jEcR4IQZQIj_AAQ', 46.51844, 6.45656, 'city', '1'),
('countries_switzerland_vaud_denges', 'ChIJUcsxANgwjEcR8IQZQIj_AAQ', 46.5248345, 6.5414283, 'city', '1'),
('countries_switzerland_vaud_dizy', 'ChIJMZEN1jE1jEcRvqcRdCSK230', 46.6339032, 6.4956006, 'city', '1'),
('countries_sweden_gotland_faro', 'ChIJqeRdMtbr9kYRV3BJHEveQ4o', 57.9441874, 19.1424789, 'city', '0'),
('countries_switzerland_vaud_dompierre', 'ChIJSUvJE9l4jkcR-B60XIfaifk', 46.7082946, 6.8831226, 'city', '1'),
('countries_switzerland_vaud_donneloye', 'ChIJaVUctqrRjUcRDjz-nOalngc', 46.7429065, 6.7140683, 'city', '1'),
('countries_switzerland_vaud_duillier', 'ChIJG0a_qLRcjEcRVQDA64IIP9I', 46.4095455, 6.2367825, 'city', '1'),
('countries_switzerland_vaud_dully', 'ChIJOwamhQlEjEcRSCJ6v-ns484', 46.4322894, 6.2971136, 'city', '1'),
('countries_switzerland_vaud_echallens', 'ChIJvbUIb0_NjUcRJRKXwPQ9DAU', 46.6410996, 6.6344508, 'city', '1'),
('countries_switzerland_vaud_echandens', 'ChIJrwIUhzExjEcRoYFjiyXflk8', 46.5352022, 6.5418995, 'city', '1'),
('countries_sweden_dalarna_roerbaecksnaes', 'ChIJ1U3V0ry3aUYRPJdFlidTCdw', 61.1288607, 12.8138183, 'city', '0'),
('countries_sweden_dalarna_krylbo', 'ChIJ8QQbQhXjXUYRSjlv33CIick', 60.1309558, 16.2159444, 'city', '0'),
('countries_switzerland_vaud_eclepens', 'ChIJVXC26znLjUcRY6VoRufZFgI', 46.6525234, 6.5296659, 'city', '1'),
('countries_switzerland_vaud_ecoteaux', 'ChIJS357fHiBjkcRAMi8CXUQr4I', 46.5457329, 6.86271, 'city', '1'),
('countries_sweden_dalarna_dala_jarna', 'ChIJu-uqbwlYXUYRsBwRUglFAwo', 60.5495961, 14.3650969, 'city', '0'),
('countries_switzerland_vaud_epalinges', 'ChIJ-b4-hn0ujEcR3qoQmWusjX8', 46.5488573, 6.674199, 'city', '1'),
('countries_sweden_blekinge_lyckeby', 'ChIJy0x8C19rVkYR4doZNfT-ACY', 56.1996223, 15.6506206, 'city', '0'),
('countries_switzerland_vaud_ependes', 'ChIJq8xjL9zOjUcRsGMZQIj_AAQ', 46.7428093, 6.6081451, 'city', '1'),
('countries_sweden_blekinge_hassloe', 'ChIJN7bIvuxxVkYRedVXzmA9FjA', 56.1090944, 15.4625203, 'city', '0'),
('countries_switzerland_vaud_essertes', 'ChIJDwziHBYqjEcR-z300fVHFdM', 46.5623699, 6.7891283, 'city', '1'),
('countries_switzerland_vaud_essertines_sur_rolle', 'ChIJh2WcYJNFjEcRFZCaW9mYNZY', 46.492086, 6.3173032, 'city', '1'),
('countries_switzerland_vaud_essertines_sur_yverdon', 'ChIJu6NkxxLOjUcRUEYZQIj_AAQ', 46.7155103, 6.6394087, 'city', '1'),
('countries_switzerland_vaud_essert_pittet', 'ChIJxUpdKrHOjUcROdzEwnE5tks', 46.7278224, 6.5835259, 'city', '1'),
('countries_switzerland_vaud_essert_sous_champvent', 'ChIJU6iRsJjIjUcRgE1C6_NTy48', 46.7932661, 6.5846138, 'city', '1'),
('countries_switzerland_vaud_etagnieres', 'ChIJKXnAV4syjEcRKRepdq-WVME', 46.5998975, 6.6129185, 'city', '1'),
('countries_switzerland_vaud_eysins', 'ChIJwXsA2CVdjEcRpvxYWA1Fz_0', 46.381576, 6.2088848, 'city', '1'),
('countries_switzerland_vaud_faoug', 'ChIJ6dKRbaZyjkcR8BpNXrPkISI', 46.9082235, 7.0778743, 'city', '1'),
('countries_suriname_distrikt_wanica_koewarasan', 'ChIJ7YFin8XNCY0RXhR3FuMBNPU', 5.777511, -55.2811778, 'city', '0'),
('countries_suriname_distrikt_paramaribo_livorno', 'ChIJKdWWdjjKCY0RuJbBp1l9gyY', 5.7738823, -55.165179, 'city', '0'),
('countries_switzerland_vaud_ferreyres', 'ChIJrx0UJrzKjUcRrbMbBr74UQw', 46.6583354, 6.4856196, 'city', '1'),
('countries_switzerland_vaud_fiez', 'ChIJs207aLHFjUcRXNZTOLTpdO8', 46.826952, 6.6235785, 'city', '1'),
('countries_switzerland_vaud_fontaines_sur_grandson', 'ChIJwwqtxaDGjUcRnKzwAABLgzY', 46.8353261, 6.6197652, 'city', '1'),
('countries_switzerland_vaud_forel', 'ChIJidl2pIUpjEcR8iFFhl44UdM', 46.5404339, 6.7694712, 'city', '1'),
('countries_switzerland_vaud_founex', 'ChIJM8IgA-xnjEcRurW54BoVtXM', 46.3328701, 6.192647, 'city', '1'),
('countries_switzerland_vaud_froideville', 'ChIJdSoFaPssjEcRKh3CV7pj-Wg', 46.601503, 6.6822073, 'city', '1'),
('countries_switzerland_vaud_genolier', 'ChIJF-vJIUNbjEcRhoOSy5vw2Ng', 46.4349956, 6.217922, 'city', '1'),
('countries_switzerland_vaud_giez', 'ChIJsfFFkr_FjUcR0m6YLPQDPJs', 46.81201, 6.6183, 'city', '1'),
('countries_switzerland_vaud_gilly', 'ChIJfeQL7qtFjEcRR6tfXAv-Z78', 46.4576159, 6.2983682, 'city', '1'),
('countries_switzerland_vaud_gimel', 'ChIJDUk9A6RPjEcRpsfzwIe_Ngk', 46.5089236, 6.3070078, 'city', '1'),
('countries_switzerland_vaud_gingins', 'ChIJH18DAq1ejEcRSuPqhgSGABY', 46.4109047, 6.1785861, 'city', '1'),
('countries_switzerland_vaud_givrins', 'ChIJqeWFn3lbjEcRlq1C3FBHIvE', 46.428946, 6.2018779, 'city', '1'),
('countries_switzerland_vaud_gland', 'ChIJG1-D1JFDjEcRchf82JvO1BI', 46.4203001, 6.2698809, 'city', '1'),
('countries_suriname_distrikt_coronie_friendship', 'ChIJUdXT2dU2CI0RsjYpccDhNxA', 3.919305, -56.027783, 'city', '0'),
('countries_switzerland_vaud_gollion', 'ChIJk5m4A0Y0jEcRLSDOpCSgJSs', 46.5852808, 6.5067932, 'city', '1'),
('countries_switzerland_vaud_gossens', 'ChIJETy-9LHRjUcRBWnkJrLjvy4', 46.7400869, 6.701653, 'city', '1'),
('countries_switzerland_vaud_goumoens_la_ville', 'ChIJd7vWluHMjUcRBMVBqneHTtE', 46.6579503, 6.6048861, 'city', '1'),
('countries_switzerland_vaud_goumoens_le_jux', 'ChIJzacPyvTMjUcRgS_5wVA5iZM', 46.6657323, 6.5875268, 'city', '1'),
('countries_switzerland_vaud_grancy', 'ChIJCTvV7IU1jEcRkEQZQIj_AAQ', 46.5920275, 6.4642847, 'city', '1'),
('countries_switzerland_vaud_grandcour', 'ChIJ0xOujLN1jkcRMGAZQIj_AAQ', 46.8718572, 6.9281823, 'city', '1'),
('countries_switzerland_vaud_grandevent', 'ChIJfysaFBzEjUcRPitSGM88mU0', 46.8385716, 6.6067599, 'city', '1'),
('countries_switzerland_vaud_grandson', 'ChIJCeWWWxXFjUcRZyuF25gtAb4', 46.8092091, 6.6457678, 'city', '1'),
('countries_sudan_west_kordofan_state_al_lagowa', 'ChIJy9yLXae85xYRr_OJc7_uGds', 11.40567, 29.13859, 'city', '0'),
('countries_switzerland_vaud_grens', 'ChIJl3tBa-VcjEcRJErvWL3rxQA', 46.3931344, 6.1908042, 'city', '1'),
('countries_switzerland_vaud_gryon', 'ChIJQcdjvgjAjkcRGlK9KG1-Zwo', 46.2778331, 7.0675893, 'city', '1'),
('countries_switzerland_vaud_henniez', 'ChIJfbBmN1t4jkcRsGcEIRusT0o', 46.7422803, 6.883395, 'city', '1'),
('countries_switzerland_vaud_hermenches', 'ChIJZ6LuJ7_UjUcRR38tqrkgBoE', 46.6419622, 6.7602436, 'city', '1'),
('countries_switzerland_vaud_jongny', 'ChIJ3cwhWBmDjkcRYyxU0F2e9ew', 46.4826453, 6.8470796, 'city', '1'),
('countries_sudan_western_darfur_geneina', 'ChIJu480HQ0wMxEROvB0bbAXRoI', 13.447898, 22.4649083, 'city', '0'),
('countries_switzerland_vaud_juriens', 'ChIJGz1qxby1jUcRNDv6jVgxH-Q', 46.6913802, 6.448674, 'city', '1'),
('countries_switzerland_vaud_lausanne', 'ChIJ5aeJzT4pjEcRXu7iysk_F-s', 46.5196535, 6.6322734, 'city', '1'),
('countries_sudan_southern_kordofan_umm_durman', 'ChIJ4621A_OLjhYRj-QaG1PTov8', 15.6475782, 32.4806894, 'city', '0'),
('countries_switzerland_vaud_lavigny', 'ChIJb3SO1AxIjEcRbgwbzfZVP5o', 46.5012496, 6.4044008, 'city', '1'),
('countries_sudan_eastern_darfur_es_sumeih', 'ChIJX3dB19Xu9hYRK6QBS5HF4j8', 12.1833333, 33.5333333, 'city', '0'),
('countries_sudan_central_darfur', NULL, 0, 0, 'city', '0'),
('countries_sudan_central_darfur_babel', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_trinity_palmetto_point_trinity', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_saint_thomas_lowland_jessup', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_saint_thomas_lowland_cotton_ground', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_la_praz', 'ChIJ261YaeG0jUcR0F0ZQIj_AAQ', 46.6674312, 6.4271565, 'city', '1'),
('countries_switzerland_vaud_la_rippe', 'ChIJs5WvSpNejEcRTd7VQtRhdzk', 46.3815158, 6.150842, 'city', '1'),
('countries_st_kitts_and_nevis_saint_peter_basseterre_stapleton', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_la_sarraz', 'ChIJB88v4tvKjUcR7-YHdPzL9X4', 46.6582337, 6.5126843, 'city', '1'),
('countries_switzerland_vaud_la_tour_de_peilz', 'ChIJuQQzGbqcjkcR5MvpBAZtN3U', 46.4533165, 6.8612781, 'city', '1'),
('countries_st_kitts_and_nevis_saint_peter_basseterre_monkey_hill', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_les_avants', 'ChIJySUzqMmajkcRANcIcLVihf0', 46.45322, 6.9428, 'city', '1'),
('countries_st_kitts_and_nevis_saint_paul_charlestown_charlestown', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_saint_paul_capesterre_newton_ground', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_saint_mary_cayon_cayon', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_les_cullayes', 'ChIJa0N84LkrjEcRsF4ZQIj_AAQ', 46.5720997, 6.7543068, 'city', '1'),
('countries_switzerland_vaud_les_diablerets', 'ChIJ5Y4c3mzrjkcRhwSsXm3Oxf8', 46.351389, 7.158056, 'city', '1'),
('countries_st_kitts_and_nevis_saint_john_figtree_beaumont', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_saint_john_capesterre_tabernacle', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_saint_john_capesterre_dieppe_bay_town', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_saint_james_windward_newcastle', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_saint_george_gingerland_gingerland', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_les_tavernes', 'ChIJz0YUCf6BjkcRfLlvJiL-YE8', 46.5543134, 6.8119109, 'city', '1'),
('countries_switzerland_vaud_les_thioleyres', 'ChIJqZzUWPOBjkcRPTayEb6w9bM', 46.5396202, 6.8118613, 'city', '1'),
('countries_switzerland_vaud_leysin', 'ChIJuVcWB2KWjkcRa7GoxcqlE6I', 46.3435634, 7.012033, 'city', '1'),
('countries_switzerland_vaud_le_brassus', 'ChIJ88n-ftdTjEcRNI68rGNhB_s', 46.5818107, 6.2116248, 'city', '1'),
('countries_switzerland_vaud_le_chenit', 'ChIJG5dL77FWjEcR8Iiu2KctCew', 46.6071396, 6.2303963, 'city', '1'),
('countries_switzerland_vaud_le_lieu', 'ChIJbTwSf1qtjUcRhZufodJ-sc4', 46.6473591, 6.2814772, 'city', '1'),
('countries_switzerland_vaud_le_mont_sur_lausanne', 'ChIJx3qZQ-EtjEcRw7uFdIwQMC4', 46.5533123, 6.6339915, 'city', '1'),
('countries_st_kitts_and_nevis_saint_george_basseterre_basseterre', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_saint_anne_sandy_point_sandy_point_town', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_middle_island_old_road_town', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_middle_island_middle_island', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_christ_church_nichola_town_nicola_town', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_le_vaud', 'ChIJR8xDTMBajEcRrCRUvv-DH6Y', 46.4781748, 6.2388488, 'city', '1'),
('countries_switzerland_vaud_lignerolle', 'ChIJE2o1CEK2jUcRT51nDI_fVcM', 46.7399571, 6.4565477, 'city', '1'),
('countries_switzerland_vaud_lonay', 'ChIJ3eqE29M2jEcRAWRXpOSucQE', 46.5266468, 6.5205487, 'city', '1'),
('countries_switzerland_vaud_longirod', 'ChIJRdDpxFBFjEcRqAp2D_o8X4E', 46.4951923, 6.2585349, 'city', '1'),
('countries_switzerland_vaud_lovatens', 'ChIJD3BdPzZ_jkcRMH8ZQIj_AAQ', 46.6917509, 6.8639494, 'city', '1'),
('countries_switzerland_vaud_lucens', 'ChIJQ4h39QXWjUcR6RKzbuFVoXE', 46.7082614, 6.8389176, 'city', '1'),
('countries_switzerland_vaud_luins', 'ChIJf9sg5fREjEcR_LCN5VlhjAE', 46.4428841, 6.2736075, 'city', '1'),
('countries_st_kitts_and_nevis_trinity_palmetto_point', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_lussy_sur_morges', 'ChIJyyDhKuw3jEcRo2AFmdlgM4w', 46.5039593, 6.4501996, 'city', '1'),
('countries_switzerland_vaud_lutry', 'ChIJ0Ue5IDYvjEcRZgtNHvmgs7Q', 46.5088803, 6.6827638, 'city', '1'),
('countries_switzerland_vaud_l_abbaye', 'ChIJWUPD_C1NjEcRvp8b2NDGQkw', 46.6495753, 6.3202576, 'city', '1'),
('countries_st_kitts_and_nevis_saint_thomas_lowland', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_saint_peter_basseterre', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_l_isle', 'ChIJJ-NZW-JKjEcRnf3IriROg-s', 46.6183489, 6.4134809, 'city', '1'),
('countries_st_kitts_and_nevis_saint_paul_charlestown', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_malapalud', 'ChIJ7yYJxqcyjEcRUTmTn7pwnCY', 46.6212631, 6.6418268, 'city', '1'),
('countries_switzerland_vaud_maracon', 'ChIJeWT7YUGBjkcRKhmDDt5TXi4', 46.55129, 6.87208, 'city', '1'),
('countries_switzerland_vaud_marchissy', 'ChIJg82lVKlajEcRnu1cdag8BDg', 46.4878378, 6.2470386, 'city', '1'),
('countries_st_kitts_and_nevis_saint_paul_capesterre', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_martherenges', 'ChIJIV3QF4bUjUcR1T4ds4KjJ7k', 46.66107, 6.75322, 'city', '1'),
('countries_switzerland_vaud_mathod', 'ChIJsT7USdvIjUcREbxGsD3zRRU', 46.7674276, 6.5656279, 'city', '1'),
('countries_switzerland_vaud_mauborget', 'ChIJRVKGdvjDjUcRqzBafvKQwTw', 46.8558419, 6.6163352, 'city', '1'),
('countries_switzerland_vaud_mex', 'ChIJPXwJZ_IzjEcRiWKZdYjeUT8', 46.577693, 6.5525569, 'city', '1'),
('countries_st_kitts_and_nevis_saint_mary_cayon', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_saint_john_figtree', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_mies', 'ChIJx1BZyERmjEcRMFwZQIj_AAQ', 46.3033989, 6.1695935, 'city', '1'),
('countries_switzerland_vaud_missy', 'ChIJu4WZ1m50jkcRKNko3UvJ4HQ', 46.8796692, 6.9691347, 'city', '1'),
('countries_switzerland_vaud_moiry', 'ChIJifMpDUW1jUcR4EQZQIj_AAQ', 46.6488422, 6.4536518, 'city', '1'),
('countries_switzerland_vaud_mollens', 'ChIJgd-OU_lLjEcRmMG3GWO9TOc', 46.5770664, 6.363767, 'city', '1'),
('countries_st_kitts_and_nevis_saint_john_capesterre', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_molondin', 'ChIJJX-50cDQjUcRIGQZQIj_AAQ', 46.7603344, 6.749057, 'city', '1'),
('countries_switzerland_vaud_monnaz', 'ChIJU76ES1c2jEcRCFkZoLemlZA', 46.528668, 6.4790064, 'city', '1'),
('countries_st_kitts_and_nevis_saint_james_windward', NULL, 0, 0, 'city', '0'),
('countries_st_kitts_and_nevis_saint_george_gingerland', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_montaubion_chardonney', 'ChIJp8g4Bz_TjUcRmD8FORtFs88', 46.6480636, 6.7146856, 'city', '1'),
('countries_switzerland_vaud_montcherand', 'ChIJUXsv-JPJjUcReMIGoWATUdg', 46.73381, 6.50864, 'city', '1'),
('countries_switzerland_vaud_montherod', 'ChIJKdXjmq9IjEcRRX7SUUo15KU', 46.4985692, 6.36594, 'city', '1'),
('countries_switzerland_vaud_montmagny', 'ChIJK3RNSUlzjkcRyeVxl4vti88', 46.9262464, 7.0108661, 'city', '1'),
('countries_switzerland_vaud_montpreveyres', 'ChIJgd1AMoErjEcROeepfn7JC78', 46.5821207, 6.7408098, 'city', '1'),
('countries_switzerland_vaud_montreux', 'ChIJzVC2zSCbjkcRRxhtxH96wMw', 46.4312213, 6.9106799, 'city', '1'),
('countries_switzerland_vaud_montricher', 'ChIJA-Di3o9LjEcR84o-SU5cmE8', 46.5997956, 6.3758639, 'city', '1'),
('countries_switzerland_vaud_mont_la_ville', 'ChIJ774-6S5LjEcRwM_WBaxljXw', 46.6465391, 6.4093478, 'city', '1'),
('countries_st_kitts_and_nevis_saint_george_basseterre', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_mont_sur_rolle', 'ChIJyU-AIwtGjEcRx2G9CQtAZrE', 46.4693048, 6.3405436, 'city', '1'),
('countries_switzerland_vaud_morcles', 'ChIJa_NZhCS5jkcRiB0JXdLP4RE', 46.20894, 7.03656, 'city', '1'),
('countries_switzerland_vaud_morges', 'ChIJTT2OphY3jEcRJ2OWHc4YqxA', 46.5088127, 6.4961301, 'city', '1'),
('countries_switzerland_vaud_morrens', 'ChIJ4_HSj30yjEcRExatu-J6pSE', 46.5910697, 6.6256805, 'city', '1'),
('countries_switzerland_vaud_moudon', 'ChIJ8Vh8BK3VjUcRcH8ZQIj_AAQ', 46.6698891, 6.7975224, 'city', '1'),
('countries_switzerland_vaud_mutrux', 'ChIJXapPHsjcjUcR2Bln-_gfEBM', 46.8831429, 6.7274193, 'city', '1'),
('countries_switzerland_vaud_neyruz_sur_moudon', 'ChIJmcug2ijUjUcRjCd6V-kT70M', 46.6971456, 6.7873395, 'city', '1'),
('countries_switzerland_vaud_novalles', 'ChIJW6mmkH_GjUcROMGwW9dXbX0', 46.8283942, 6.5956856, 'city', '1'),
('countries_switzerland_vaud_noville', 'ChIJs68ofN-bjkcRjOanms9nurs', 46.3807941, 6.9002856, 'city', '1'),
('countries_switzerland_vaud_nyon', 'ChIJZwgvdy9DjEcRR69BEhrUt28', 46.3832683, 6.2347852, 'city', '1'),
('countries_switzerland_vaud_ogens', 'ChIJ37nT6WPRjUcRkH8ZQIj_AAQ', 46.7104182, 6.7234914, 'city', '1'),
('countries_switzerland_vaud_oleyres', 'ChIJudregz1yjkcRgEMZQIj_AAQ', 46.8556727, 7.0371866, 'city', '1'),
('countries_switzerland_vaud_ollon', 'ChIJB0L6DPOVjkcRRSWjOavofZw', 46.2957462, 6.9916269, 'city', '1'),
('countries_switzerland_vaud_onnens', 'ChIJEfgIs7fEjUcRwauENdMQpz4', 46.8396549, 6.6866098, 'city', '1'),
('countries_switzerland_vaud_oppens', 'ChIJhSu605PRjUcRszFQWM64Vpg', 46.7139815, 6.691683, 'city', '1'),
('countries_switzerland_vaud_orbe', 'ChIJcf1nP2fJjUcRk4BuHkJxQxk', 46.7293301, 6.5323588, 'city', '1'),
('countries_switzerland_vaud_orges', 'ChIJYa6ZnQvGjUcR-11SqORQoJo', 46.80801, 6.5883556, 'city', '1'),
('countries_switzerland_vaud_orny', 'ChIJFfrCXwXLjUcR-tZYA75hm5Y', 46.6673781, 6.5260641, 'city', '1'),
('countries_switzerland_vaud_oron_la_ville', 'ChIJVc-80sSBjkcR0CBrBHZz6jM', 46.5714166, 6.8278795, 'city', '1'),
('countries_st_kitts_and_nevis_saint_anne_sandy_point', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_orzens', 'ChIJo2kXFenRjUcRO6KqieW32I0', 46.7241277, 6.6839128, 'city', '1'),
('countries_st_kitts_and_nevis_middle_island', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_pailly', 'ChIJ_XQJ-T3SjUcRNMkC87wsA0A', 46.700334, 6.6742913, 'city', '1'),
('countries_st_kitts_and_nevis_christ_church_nichola_town', NULL, 0, 0, 'city', '0'),
('countries_switzerland_vaud_pampigny', 'ChIJnf7rNBZKjEcRtDt3-LiDSTY', 46.580344, 6.4274859, 'city', '1'),
('countries_switzerland_vaud_panex', 'ChIJaf_wBhCWjkcRJ0FLuYQ9DwA', 46.3111971, 7.0132935, 'city', '1'),
('countries_switzerland_vaud_paudex', 'ChIJPagtRGYvjEcRUi_Vz59a0BQ', 46.5051579, 6.6723034, 'city', '1'),
('countries_switzerland_vaud_payerne', 'ChIJVzyOb-92jkcRH-17H3BsUis', 46.8220266, 6.9405663, 'city', '1'),
('countries_switzerland_vaud_peney_le_jorat', 'ChIJU8C341LTjUcRVDTVGib5nrQ', 46.6321479, 6.728431, 'city', '1'),
('countries_switzerland_vaud_penthalaz', 'ChIJ76QgcLg0jEcRs4JcW1sBVbs', 46.6097989, 6.5254402, 'city', '1'),
('countries_switzerland_vaud_penthaz', 'ChIJTQ2I4n00jEcRnAmR8IYA2X4', 46.5993131, 6.5392512, 'city', '1'),
('countries_sri_lanka_western_province_weweldeniya_ihalagama', 'ChIJK1Nc0vEc4zoRNfiiswnYRqM', 7.193133, 80.1583161, 'city', '0'),
('countries_switzerland_vaud_perroy', 'ChIJweaoyEVGjEcRfyLJYLfs6x8', 46.4681574, 6.361877, 'city', '1'),
('countries_switzerland_vaud_peyres_possens', 'ChIJ1TRzKwTTjUcRrnaNNM4jT0I', 46.6633472, 6.7067892, 'city', '1'),
('countries_switzerland_vaud_poliez_pittet', 'ChIJ_4BjztcsjEcRIEcZQIj_AAQ', 46.6274641, 6.6819435, 'city', '1'),
('countries_switzerland_vaud_pompaples', 'ChIJKcwKwADLjUcRDXuw-K9JCtY', 46.6667994, 6.5107091, 'city', '1'),
('countries_switzerland_vaud_pomy', 'ChIJ4RXOY9nPjUcRK2q48wd4aEo', 46.7601259, 6.6679184, 'city', '1'),
('countries_switzerland_vaud_prahins', 'ChIJBVYjDBrRjUcRFSkx032vbxo', 46.7344381, 6.7404251, 'city', '1'),
('countries_switzerland_vaud_prangins', 'ChIJH92weQ9DjEcRiDdEm5LMn9Y', 46.3943352, 6.2492927, 'city', '1'),
('countries_switzerland_vaud_premier', 'ChIJfW2XKsa1jUcR3o3sX9P5nvo', 46.704421, 6.4445824, 'city', '1'),
('countries_sri_lanka_western_province_watinapaha', 'ChIJB5TegZnk4joR0wqI0H-uaM4', 7.1853118, 80.0003875, 'city', '0'),
('countries_sri_lanka_western_province_union_place', 'ChIJo7QyjxVZ4joRmZpx2XpgApU', 6.9229583, 79.8523572, 'city', '0'),
('countries_switzerland_vaud_prilly', 'ChIJLTHw3cExjEcRcHcZQIj_AAQ', 46.5346449, 6.6052401, 'city', '1'),
('countries_switzerland_vaud_provence', 'ChIJIaCYduDCjUcRVzdqh4d9TOY', 46.8902683, 6.7263447, 'city', '1'),
('countries_switzerland_vaud_puidoux', 'ChIJiSUxxyMojEcR5e6K2a246f0', 46.4988452, 6.7691772, 'city', '1'),
('countries_switzerland_vaud_pully', 'ChIJu7SV9g0vjEcRjMt4jgNGldg', 46.5092681, 6.6654949, 'city', '1'),
('countries_switzerland_vaud_rances', 'ChIJewapkVHIjUcREaLawR9zNZk', 46.760201, 6.5299737, 'city', '1'),
('countries_switzerland_vaud_renens', 'ChIJvYzI4Z8xjEcR19vvDaV2kdc', 46.53381, 6.59137, 'city', '1'),
('countries_switzerland_vaud_rennaz', 'ChIJCWRT7o-ZjkcR7Pq6TfuxdWE', 46.3760844, 6.9183892, 'city', '1'),
('countries_switzerland_vaud_reverolle', 'ChIJUehrhdhJjEcRcv9UCuk3GZ0', 46.5413758, 6.4386829, 'city', '1'),
('countries_switzerland_vaud_rivaz', 'ChIJ7-W4vw8ojEcRg65R-mH69hc', 46.4764133, 6.7786131, 'city', '1'),
('countries_switzerland_vaud_roche', 'ChIJ9a7U5cCZjkcR8scthsohII4', 46.3603257, 6.9315046, 'city', '1'),
('countries_switzerland_vaud_rolle', 'ChIJcd1Rdn9GjEcRqh6yW9BxB0E', 46.4612971, 6.3397549, 'city', '1'),
('countries_sri_lanka_western_province_undugoda', 'ChIJzctrO3MO4zoRzbjfpWtD97w', 7.139777, 80.3575128, 'city', '1'),
('countries_switzerland_vaud_romanel_sur_lausanne', 'ChIJwZjEDBkyjEcRdHux-YgBj3Y', 46.5630648, 6.603945, 'city', '1'),
('countries_switzerland_vaud_ropraz', 'ChIJOUa5N0ArjEcRcF8ZQIj_AAQ', 46.6152435, 6.7515109, 'city', '1'),
('countries_switzerland_vaud_rossenges', 'ChIJZYzoMeXUjUcRuULA1wdRmws', 46.652087, 6.7761012, 'city', '1'),
('countries_sri_lanka_western_province_talawatugoda', 'ChIJ8_bpcOxQ4joR4DkKb1GbaBM', 6.8758648, 79.9391936, 'city', '0'),
('countries_switzerland_vaud_rougemont', 'ChIJeVeVBgjzjkcRQbT_YX8YLrk', 46.4891397, 7.2089164, 'city', '1'),
('countries_switzerland_vaud_rovray', 'ChIJ7QUeJgPajUcRTjBxX1H4bho', 46.7847622, 6.7645655, 'city', '1'),
('countries_switzerland_vaud_rueyres', 'ChIJk1nmaiXSjUcRMEcZQIj_AAQ', 46.6937019, 6.6926562, 'city', '1'),
('countries_switzerland_vaud_sainte_croix', 'ChIJtz-JxGS4jUcR5Yiq8ghiyTo', 46.8217968, 6.5022222, 'city', '1'),
('countries_switzerland_vaud_saint_cergue', 'ChIJfyQc5GlZjEcRNlVly2JRVJc', 46.4460412, 6.1581382, 'city', '1'),
('countries_switzerland_vaud_saint_george', 'ChIJ7wYvtqJPjEcRdlLZUsGSXLI', 46.514293, 6.2604696, 'city', '1'),
('countries_switzerland_vaud_saint_livres', 'ChIJQz30HvJIjEcR_NHudn8uLyI', 46.5076838, 6.3875649, 'city', '1'),
('countries_switzerland_vaud_saint_prex', 'ChIJ4Q_qAbU5jEcR2hwTMunmDdw', 46.4829113, 6.4583435, 'city', '1'),
('countries_switzerland_vaud_saint_sulpice', 'ChIJtWLDCocwjEcRBNSwEKEmmJw', 46.510114, 6.5581951, 'city', '1'),
('countries_sri_lanka_western_province_slave_island', 'ChIJB0fswj1Z4joRwcAVqfFFnj0', 6.9257119, 79.8503314, 'city', '0'),
('countries_switzerland_vaud_sarzens', 'ChIJw2sHXVx_jkcRlGhsCNJgRE4', 46.6823, 6.85013, 'city', '1'),
('countries_sri_lanka_western_province_siyambalape', 'ChIJW-NK621W4joRCA-XsRJxBU8', 6.9674112, 79.9892034, 'city', '0'),
('countries_switzerland_vaud_saubraz', 'ChIJv3FWRDhPjEcRFDSulGjjPrU', 46.5143439, 6.3304638, 'city', '1'),
('countries_switzerland_vaud_savigny', 'ChIJe-thQUQpjEcRmIK5UnKkZN4', 46.5383864, 6.7321079, 'city', '1'),
('countries_switzerland_vaud_senarclens', 'ChIJMcQiZaQ1jEcRcEUZQIj_AAQ', 46.6003663, 6.4869682, 'city', '1'),
('countries_switzerland_vaud_sergey', 'ChIJNcyZLdDJjUcRl3UdLAEiv3g', 46.75062, 6.49966, 'city', '1'),
('countries_switzerland_vaud_servion', 'ChIJyT3Vgk8qjEcRpXWJVc4N7nc', 46.57147, 6.77879, 'city', '1'),
('countries_sri_lanka_western_province_ranala', 'ChIJmx4UjW5U4joRXLHt8VELh3M', 6.9153759, 80.0339312, 'city', '0'),
('countries_sri_lanka_western_province_rajagiriya', 'ChIJEZnjLfNZ4joRq_lduw8D6Sg', 6.9094108, 79.8942538, 'city', '0'),
('countries_switzerland_vaud_sottens', 'ChIJD4T5uGPTjUcR67P6mrq5voM', 46.6553889, 6.7421726, 'city', '1'),
('countries_sri_lanka_western_province_raddolugama', 'ChIJ6diiHxfw4joR-ZPDztrgdJM', 7.1406334, 79.9013603, 'city', '0'),
('countries_sri_lanka_western_province_pitipana_north', 'ChIJU7YVD3NS4joRDGIA5ZKfTJk', 6.8239567, 80.0283101, 'city', '0'),
('countries_sri_lanka_western_province_nawana', 'ChIJ_SpYWyFa4joRx2Ot5GFZ-cY', 6.8964191, 79.8884819, 'city', '0'),
('countries_switzerland_vaud_suchy', 'ChIJ6dDiCZfOjUcRtzfbu2mpb_0', 46.7228341, 6.5989617, 'city', '1'),
('countries_switzerland_vaud_sullens', 'ChIJ00HRNp8zjEcRqkQl0x0br4g', 46.5935962, 6.5660091, 'city', '1'),
('countries_sri_lanka_western_province_naranwala', 'ChIJmbiBCDn_4joRyYA0c7Xa9y4', 7.0118957, 80.0241489, 'city', '0'),
('countries_switzerland_vaud_syens', 'ChIJi47Fy93UjUcR8EDTqOMUXYE', 46.645146, 6.778542, 'city', '1'),
('countries_switzerland_vaud_tannay', 'ChIJO9hCmU1mjEcR-QqtyhgmEdU', 46.310046, 6.1735347, 'city', '1'),
('countries_switzerland_vaud_tartegnin', 'ChIJ9YHREcdFjEcRftrh2DIhQwc', 46.466421, 6.3166357, 'city', '1'),
('countries_sri_lanka_western_province_mulleriyawa_north', 'ChIJY1dU9XZX4joRzdrf7zAiwDg', 6.9436128, 79.9290642, 'city', '0'),
('countries_switzerland_vaud_thierrens', 'ChIJ20-l___TjUcRONsdD34WQro', 46.7040793, 6.753842, 'city', '1'),
('countries_switzerland_vaud_tolochenaz', 'ChIJa75U1d85jEcRfWKFBvgYkjk', 46.5047412, 6.4733006, 'city', '1'),
('countries_switzerland_vaud_trey', 'ChIJ6fgRUWJ3jkcR0GAZQIj_AAQ', 46.7701263, 6.9260996, 'city', '1'),
('countries_switzerland_vaud_treycovagnes', 'ChIJu0bzj0DPjUcRAFbEZZVu5A4', 46.7739321, 6.6092062, 'city', '1'),
('countries_sri_lanka_western_province_mirihana', 'ChIJGyOKymha4joRul-2nLQTqW8', 6.8689647, 79.9038774, 'city', '0'),
('countries_switzerland_vaud_ursins', 'ChIJZW8REtjRjUcRW6xIP6brH4k', 46.7349173, 6.6684647, 'city', '1'),
('countries_switzerland_vaud_valeyres_sous_montagny', 'ChIJYRJnOOPFjUcRm871zKkYkJI', 46.7989335, 6.6088389, 'city', '1'),
('countries_switzerland_vaud_valeyres_sous_rances', 'ChIJweLAsQXJjUcR5A5QicsK1m4', 46.7533504, 6.5257891, 'city', '1'),
('countries_switzerland_vaud_valeyres_sous_ursins', 'ChIJOas1gS3OjUcRvXagB8ovn1g', 46.7462973, 6.6555817, 'city', '1'),
('countries_switzerland_vaud_vallamand', 'ChIJdyU7R9gMjkcRspPXZbcZeNk', 46.9317551, 7.0390187, 'city', '1'),
('countries_switzerland_vaud_vallorbe', 'ChIJD-zUtOizjUcRcIh72e0rb7M', 46.7119965, 6.3791102, 'city', '1'),
('countries_switzerland_vaud_vaulion', 'ChIJOUKBQHy0jUcRayQU0FF5eGo', 46.6879021, 6.3889387, 'city', '1'),
('countries_switzerland_vaud_vaux_sur_morges', 'ChIJ-RRdQDg2jEcRAH4ZQIj_AAQ', 46.5355318, 6.4632759, 'city', '1'),
('countries_sri_lanka_western_province_meegoda', 'ChIJp8h4SXlS4joRC93bxMdesJY', 6.8216009, 80.0475301, 'city', '0'),
('countries_sri_lanka_western_province_meda_wadduwa', 'ChIJ-yLESd034joRsUyGREraT3Y', 6.6367278, 79.9423543, 'city', '0'),
('countries_switzerland_vaud_vevey', 'ChIJp34g0TKDjkcRf-yXMrlE6I8', 46.4628333, 6.8419192, 'city', '1'),
('countries_switzerland_vaud_veytaux', 'ChIJTaH_qu2ajkcRvqyT1pRowYk', 46.4207102, 6.9286409, 'city', '1'),
('countries_switzerland_vaud_vich', 'ChIJgQrxj65EjEcRpfXvcSOXwmk', 46.4288507, 6.2504103, 'city', '1'),
('countries_sri_lanka_western_province_mattegoda', 'ChIJDXuAGdZR4joR8EeiaGpdpc4', 6.8135488, 79.9724245, 'city', '0'),
('countries_sri_lanka_western_province_maradana', 'ChIJ8aQuPA5Z4joRqVxohkf-TYE', 6.926997, 79.8639835, 'city', '0'),
('countries_sri_lanka_western_province_mandawala_north', 'ChIJ0U08Rtb_4joRJsWqejwMs_4', 7.0241084, 80.0995833, 'city', '0'),
('countries_switzerland_vaud_villars_burquin', 'ChIJ9_WY7mrEjUcRHO2Z99_9hJU', 46.8472369, 6.6293631, 'city', '1'),
('countries_switzerland_vaud_villars_le_comte', 'ChIJvR9OwobWjUcRPcP6XZk9f5c', 46.7094724, 6.7982451, 'city', '1'),
('countries_switzerland_vaud_villars_le_grand', 'ChIJxTly0UJzjkcRoEMZQIj_AAQ', 46.9082943, 6.9950223, 'city', '1'),
('countries_switzerland_vaud_villars_le_terroir', 'ChIJPz51zGfNjUcRumMQALecMdY', 46.65755, 6.6390489, 'city', '1'),
('countries_switzerland_vaud_villars_mendraz', 'ChIJ1WvgKkPTjUcRsFoZQIj_AAQ', 46.647426, 6.7292355, 'city', '1'),
('countries_switzerland_vaud_villars_sous_champvent', 'ChIJ_3Oph5jIjUcRECfadt1GcRM', 46.78638, 6.58323, 'city', '1'),
('countries_switzerland_vaud_villars_sous_yens', 'ChIJvSOeAh9IjEcRIH4ZQIj_AAQ', 46.5101868, 6.4287151, 'city', '1'),
('countries_sri_lanka_western_province_malwana', 'ChIJyWuX0NZV4joRbhprJp7ERuU', 6.9507844, 80.0157449, 'city', '0'),
('countries_switzerland_vaud_villars_tiercelin', 'ChIJaZLBj7csjEcR4EI7goMCtxk', 46.6256905, 6.70336, 'city', '1'),
('countries_switzerland_vaud_villarzel', 'ChIJ5wedCqR5jkcRAGEZQIj_AAQ', 46.7484013, 6.9129687, 'city', '1'),
('countries_switzerland_vaud_villeneuve', 'ChIJz3p69pOQjkcRLpm-mxAMKto', 46.396608, 6.9287684, 'city', '1'),
('countries_switzerland_vaud_vinzel', 'ChIJVfs95fZEjEcRUJ8V9RBOR4Q', 46.4474998, 6.2794339, 'city', '1'),
('countries_switzerland_vaud_vuarrens', 'ChIJ-y4G5o3NjUcRcTXGjv37HuE', 46.6860883, 6.6472988, 'city', '1'),
('countries_switzerland_vaud_vucherens', 'ChIJG3dgAiorjEcR1F8Lp3Cl3lw', 46.6248916, 6.7799016, 'city', '1'),
('countries_switzerland_vaud_vufflens_la_ville', 'ChIJlZlfuwk0jEcRKbz8lr1G384', 46.5787989, 6.539418, 'city', '1'),
('countries_sri_lanka_western_province_makola_south', 'ChIJPduytsJX4joRUlmPDURo6Cs', 6.9723932, 79.9475487, 'city', '0'),
('countries_switzerland_vaud_vuibroye', 'ChIJDTHrpnEqjEcRjtRQNQkfbCA', 46.5719393, 6.8053351, 'city', '1'),
('countries_switzerland_vaud_vuiteboeuf', 'ChIJyedt4jDGjUcR0lJOYVrKSu8', 46.8077285, 6.5492468, 'city', '1'),
('countries_switzerland_vaud_vulliens', 'ChIJCWs8Bc0qjEcRucixtSMVsQE', 46.622324, 6.7921344, 'city', '1'),
('countries_switzerland_vaud_vullierens', 'ChIJ4XlFXtA1jEcRMEJclleNOuI', 46.5748369, 6.4844452, 'city', '1'),
('countries_switzerland_vaud_yens', 'ChIJdQ2elv9IjEcR1tBhSSRLDh0', 46.5196158, 6.4179173, 'city', '1'),
('countries_switzerland_vaud_yverdon_les_bains', 'ChIJtfOraYHPjUcR-aTcS63BMs4', 46.7784736, 6.641183, 'city', '1'),
('countries_switzerland_vaud_yvonand', 'ChIJr5n09njQjUcRiqRcbXb5WP4', 46.7994765, 6.7455463, 'city', '1'),
('countries_switzerland_vaud_yvorne', 'ChIJw262PJaXjkcRY_1kZNFnq8k', 46.3315011, 6.958395, 'city', '1'),
('countries_sri_lanka_western_province_madapata', 'ChIJgcz673lP4joRMC0eo0NA4ko', 6.7690465, 79.9290642, 'city', '0'),
('countries_switzerland_zug_baar', 'ChIJD5CdDsurmkcRWvqmITv_G1E', 47.1953729, 8.526087, 'city', '1'),
('countries_switzerland_zug_buonas', 'ChIJx0cf8RsAkEcRB_Z2prs-Drg', 47.14221, 8.45593, 'city', '1'),
('countries_switzerland_zug_cham', 'ChIJWdZa4NsAkEcRpHqSeMlyzdE', 47.181225, 8.4592089, 'city', '1'),
('countries_sri_lanka_western_province_kottawa', 'ChIJV0QlPktQ4joRj7mIVJN49dU', 6.8411652, 79.9654324, 'city', '0'),
('countries_sri_lanka_western_province_kolonnawa', 'ChIJUWulXtZZ4joRFyl77GWuxpk', 6.9359707, 79.9161333, 'city', '0'),
('countries_sri_lanka_western_province_kollupitiya', 'ChIJu_-gJkJZ4joR9nX1O7PFE6Q', 6.9128154, 79.8506815, 'city', '0'),
('countries_sri_lanka_western_province_kohuwala', 'ChIJw5Ed2k1a4joRJG0NdWXy7UQ', 6.8624842, 79.8854983, 'city', '0'),
('countries_switzerland_zug_menzingen', 'ChIJUbFmpW-smkcR_M0Aawl__x8', 47.1778831, 8.5912483, 'city', '1'),
('countries_switzerland_zug_morgarten', 'ChIJ_SZcDr1ShUcRcduXaFKuE5M', 47.10507, 8.64062, 'city', '1'),
('countries_switzerland_zug_neuheim', 'ChIJ3TvmoACsmkcRyvp0JXplgV4', 47.204778, 8.5753544, 'city', '1'),
('countries_sri_lanka_western_province_kochchikade', 'ChIJhx5G-RLp4joRceh2GYRucTs', 7.2657063, 79.8591235, 'city', '0');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_sri_lanka_western_province_katubedda', 'ChIJvwRrmThF4joRy-VuDrfdtXE', 6.8014572, 79.8996789, 'city', '0'),
('countries_switzerland_zug_steinhausen', 'ChIJh0VH06YAkEcRcOkYQIj_AAQ', 47.197193, 8.4850173, 'city', '1'),
('countries_sri_lanka_western_province_katana_west', 'ChIJTZbMq7fo4joRDq_AIcqCONE', 7.2480284, 79.8993665, 'city', '0'),
('countries_switzerland_zug_walchwil', 'ChIJWYKSCutUhUcRs5tNAYXZACk', 47.100183, 8.5162335, 'city', '1'),
('countries_switzerland_zug_zug', 'ChIJ8-RGYCmrmkcREOrjxwO_UKk', 47.1661672, 8.5154946, 'city', '1'),
('countries_sri_lanka_western_province_kalutara_north', 'ChIJl9CykwU34joRIsBuIzvQ10A', 6.5981001, 79.9542438, 'city', '0'),
('countries_switzerland_zurich_aathal', 'ChIJcQHwkXa7mkcRhwfOOH_UewY', 47.335333, 8.770695, 'city', '1'),
('countries_switzerland_zurich_adetswil', 'ChIJYdoPMNW4mkcRwUGQEjXzAek', 47.3378619, 8.8528619, 'city', '1'),
('countries_switzerland_zurich_adliswil', 'ChIJRcIZASAIkEcRoL85wGjsr_8', 47.3124347, 8.5270459, 'city', '1'),
('countries_switzerland_zurich_aesch', 'ChIJWxWmmCoPkEcRNKfL3JrKsY0', 47.3368912, 8.4427102, 'city', '1'),
('countries_switzerland_zurich_aeugst_am_albis', 'ChIJv6H1wMEHkEcRWkrtMnjBiMc', 47.2677487, 8.4852115, 'city', '1'),
('countries_switzerland_zurich_affoltern_am_albis', 'ChIJK9KgazsGkEcRlS0cC3WjOsA', 47.2795081, 8.4540083, 'city', '1'),
('countries_switzerland_zurich_agasul', 'ChIJzTug9JOimkcRLqNucHKzWA8', 47.4251019, 8.7436, 'city', '1'),
('countries_switzerland_zurich_allenwinden', 'ChIJG7i7DXSrmkcR3BAXVTyXlDs', 47.1642535, 8.5569483, 'city', '1'),
('countries_switzerland_zurich_altikon', 'ChIJc3aEVrCamkcRIvTwFezAipM', 47.5733567, 8.7809386, 'city', '1'),
('countries_switzerland_zurich_alt_bachs', 'ChIJPQmapShykEcR8NAYQIj_AAQ', 47.5238856, 8.4391773, 'city', '1'),
('countries_sri_lanka_western_province_horana_south', 'ChIJkU8IWkdL4joRvthrtvPqvvA', 6.7229806, 80.0646682, 'city', '0'),
('countries_switzerland_zurich_au', 'ChIJDXJ4iv2umkcR6wHc47eqAQY', 47.2423613, 8.6543917, 'city', '1'),
('countries_sri_lanka_western_province_horampella_north', 'ChIJ_Y7Vrfbk4joRTM6z1sHsFRo', 7.1931192, 79.9801845, 'city', '0'),
('countries_switzerland_zurich_auslikon', 'ChIJqSuOOvS7mkcRPSpZQY2bwME', 47.343333, 8.806667, 'city', '1'),
('countries_sri_lanka_western_province_hokandara_south', 'ChIJ8f_ZvOFQ4joREcfX-qDkODM', 6.872908, 79.9654324, 'city', '0'),
('countries_sri_lanka_western_province_hendala', 'ChIJCaFfJdD34joRPWWscMYY_dI', 6.9956291, 79.8833233, 'city', '0'),
('countries_switzerland_zurich_bassersdorf', 'ChIJAUTztmGfmkcRoM8YQIj_AAQ', 47.4434608, 8.6287132, 'city', '1'),
('countries_switzerland_zurich_bauma', 'ChIJ-2OqsQO_mkcRxRN5-Gne_xE', 47.3672639, 8.8808183, 'city', '1'),
('countries_sri_lanka_western_province_haltota', 'ChIJmVcedMpL4joRMywTN-CfLso', 6.6942555, 80.030861, 'city', '0'),
('countries_switzerland_zurich_benken', 'ChIJHT_mF0CCmkcRIM4YQIj_AAQ', 47.6531308, 8.6535956, 'city', '1'),
('countries_sri_lanka_western_province_gallassa', 'ChIJFX8Ce04x4joRnQ-wOcoboXY', 6.5567488, 79.9933976, 'city', '0'),
('countries_switzerland_zurich_binz', 'ChIJMZZROqymmkcRHWON-GGAyns', 47.356109, 8.626387, 'city', '1'),
('countries_sri_lanka_western_province_dematagoda', 'ChIJ3eHZ1QdZ4joRr5PEhOiCmL8', 6.9352993, 79.8807831, 'city', '0'),
('countries_switzerland_zurich_birmensdorf', 'ChIJrbxjCbUOkEcRU1tuM2WTkb4', 47.35367, 8.43714, 'city', '1'),
('countries_switzerland_zurich_bisikon', 'ChIJLbws9l6imkcReVL2Hjp0Q0A', 47.411625, 8.696372, 'city', '1'),
('countries_switzerland_zurich_bonstetten', 'ChIJbczDmycIkEcRukwhP7_aO9U', 47.31516, 8.4680573, 'city', '1'),
('countries_switzerland_zurich_boppelsen', 'ChIJc40M_ZRykEcRNKM9GYG3dRw', 47.47028, 8.40219, 'city', '1'),
('countries_sri_lanka_western_province_delgoda', 'ChIJP7Cq0lf_4joRqEdIhBhbCCE', 6.987854, 80.0157633, 'city', '0'),
('countries_sri_lanka_western_province_dampe', 'ChIJU3vC3nxP4joRyvAyMlO6-14', 6.7701052, 79.9164717, 'city', '0'),
('countries_sri_lanka_western_province_buthpitiya_north', 'ChIJ3ba702P-4joRcH5POQWSqK8', 7.0546933, 80.0531273, 'city', '0'),
('countries_switzerland_zurich_bubikon', 'ChIJaQ6rjli3mkcR3-8dej3uGNM', 47.2682174, 8.8191356, 'city', '1'),
('countries_switzerland_zurich_buch', 'ChIJN4MhYS5zkEcR6k0zm7oE_Vk', 47.4584851, 8.4410222, 'city', '1'),
('countries_sri_lanka_western_province_borella', 'ChIJ25G5kaJZ4joR_GeKEonHf-M', 6.9121796, 79.8828828, 'city', '0'),
('countries_switzerland_zurich_dachsen', 'ChIJaaaN2KB4kEcRCy6O_BDTqTU', 47.6660626, 8.6160024, 'city', '1'),
('countries_sri_lanka_western_province_boralesgamuwa_south', 'ChIJtaN5tKJa4joRexSHZ2SN5Lw', 6.8409891, 79.9017187, 'city', '0'),
('countries_sri_lanka_western_province_bokundara', 'ChIJm6r6TVRF4joRxA3AZhNEw2k', 6.8164327, 79.9206694, 'city', '0'),
('countries_sri_lanka_western_province_biyagama', 'ChIJQ1yu3XdW4joRaNpFWd2SHVQ', 6.9462153, 79.9892034, 'city', '0'),
('countries_switzerland_zurich_dielsdorf', 'ChIJIVrAGWtzkEcRykCvBgHhBpE', 47.4824169, 8.4535044, 'city', '1'),
('countries_switzerland_zurich_dietikon', 'ChIJOcS8KLALkEcRZWqbTLujKq0', 47.4053885, 8.39977, 'city', '1'),
('countries_switzerland_zurich_dinhard', 'ChIJ1a2fRO6amkcRfiodfYsgIhI', 47.5551167, 8.7695628, 'city', '1'),
('countries_switzerland_zurich_dorf', 'ChIJD0x3reGcmkcRwYNzSXQNido', 47.5728635, 8.6475778, 'city', '1'),
('countries_sri_lanka_western_province_batuwatta_west', 'ChIJX5Vhue_54joRE6PPlXwklA8', 7.0574232, 79.9318453, 'city', '0'),
('countries_sri_lanka_western_province_battaramulla_south', 'ChIJ_-co6VVX4joRoZysGekvSIU', 6.8979941, 79.9222869, 'city', '0'),
('countries_sri_lanka_western_province_battaramulla_north', 'ChIJRys_f1NX4joRjF-k2SCPQr8', 6.9011316, 79.9234678, 'city', '0'),
('countries_switzerland_zurich_effretikon', 'ChIJE5cVc4SimkcRci6eIdkmw_k', 47.4272742, 8.6903376, 'city', '1'),
('countries_switzerland_zurich_egg', 'ChIJ8z2jSz6lmkcRVFJqG5AFwMI', 47.2995246, 8.6903921, 'city', '1'),
('countries_switzerland_zurich_eglisau', 'ChIJWaa_8iV3kEcR0M8YQIj_AAQ', 47.5762223, 8.5219809, 'city', '1'),
('countries_switzerland_zurich_elgg', 'ChIJ93Q3HuqWmkcRVtXiR5tmTO8', 47.4910721, 8.8665461, 'city', '1'),
('countries_switzerland_zurich_ellikon_an_der_thur', 'ChIJi0T6VD-QmkcRIPcYQIj_AAQ', 47.5630455, 8.8246219, 'city', '1'),
('countries_sri_lanka_western_province_bambalapitiya', 'ChIJ3TuZKWFZ4joRteiPfzFD2HM', 6.904361, 79.8540397, 'city', '0'),
('countries_switzerland_zurich_embrach', 'ChIJV67J1BGemkcR4M8YQIj_AAQ', 47.509856, 8.5938067, 'city', '1'),
('countries_switzerland_zurich_erlenbach', 'ChIJ-ZXf3XKmmkcRU1CwsPlgv44', 47.3052989, 8.5971471, 'city', '1'),
('countries_switzerland_zurich_esslingen', 'ChIJGztiEq66mkcRXrRdiSwTi3U', 47.283333, 8.716667, 'city', '1'),
('countries_switzerland_zurich_fehraltorf', 'ChIJ6392wtC8mkcRtVrFN9_7oYk', 47.3881047, 8.7517889, 'city', '1'),
('countries_switzerland_zurich_feldbach', 'ChIJJ7dOAM6wmkcRTcmOJd6UAA4', 47.2397, 8.78743, 'city', '1'),
('countries_sri_lanka_western_province_athurugiriya', 'ChIJb8pq50NR4joRSQm0qBry0zI', 6.8723185, 80.0003875, 'city', '0'),
('countries_switzerland_zurich_feuerthalen', 'ChIJa4EQTe6BmkcRqMCrN0r7MV8', 47.6885343, 8.6497285, 'city', '1'),
('countries_switzerland_zurich_fischenthal', 'ChIJXd2hGk3HmkcRI_yx07EuH6U', 47.3311758, 8.9202247, 'city', '1'),
('countries_switzerland_zurich_flaach', 'ChIJu6nqRl-dmkcRgM4YQIj_AAQ', 47.5754244, 8.6085302, 'city', '1'),
('countries_sri_lanka_western_province_andiambalama', 'ChIJD1_ob5Dv4joRtk48nZf6lm4', 7.1885687, 79.9040236, 'city', '0'),
('countries_switzerland_zurich_flurlingen', 'ChIJJaDJmfyBmkcReqvhVQ0x5Q4', 47.685357, 8.6294367, 'city', '1'),
('countries_sri_lanka_western_province_ambalangoda', 'ChIJoVPapSuC4ToR7Ghm2dVyyuE', 6.2441521, 80.0590804, 'city', '0'),
('countries_sri_lanka_southern_province_panvila', 'ChIJo3STM8Fe4zoRYY5p-7LcImk', 7.4004208, 80.7329079, 'city', '0'),
('countries_sri_lanka_southern_province_hambantota', 'ChIJ9zVypf-85joRUiE_lFivxDY', 6.1428829, 81.1212308, 'city', '1'),
('countries_switzerland_zurich_geroldswil', 'ChIJwTUlVvkMkEcROIxoFnR3mBc', 47.4239976, 8.4117709, 'city', '1'),
('countries_switzerland_zurich_gibswil', 'ChIJXd2hGk3HmkcRI_yx07EuH6U', 47.3311758, 8.9202247, 'city', '1'),
('countries_sri_lanka_southern_province_ahangama_east', 'ChIJyUzrRrEU4ToRtI1tB3bWa2I', 5.9680181, 80.3706935, 'city', '0'),
('countries_switzerland_zurich_glattfelden', 'ChIJYwD9IC1xkEcRhc-y6WYkMCo', 47.5598578, 8.4993768, 'city', '1'),
('countries_sri_lanka_sabaragamuwa_province_warakapola', 'ChIJMzEOAHoc4zoRHGz1N0szFZg', 7.2268033, 80.1958755, 'city', '1'),
('countries_switzerland_zurich_gossau', 'ChIJ-xB14FW6mkcREpVKehuavYQ', 47.3064531, 8.7586121, 'city', '1'),
('countries_sri_lanka_sabaragamuwa_province_panapola', 'ChIJB_8RFSNM4joRdf_LWnx6mP0', 6.7563403, 80.0171609, 'city', '1'),
('countries_sri_lanka_sabaragamuwa_province_kottegoda', 'ChIJ0fAq05k34ToRyjD_d7uWwBw', 5.9559827, 80.6525661, 'city', '0'),
('countries_switzerland_zurich_greifensee', 'ChIJG2g-y3mjmkcRnP9K3B3QrNU', 47.3665785, 8.6794982, 'city', '1'),
('countries_sri_lanka_sabaragamuwa_province_karangama', 'ChIJoZ7BJgQm5DoRyiq8WfNrLXI', 6.4135463, 81.3325679, 'city', '1'),
('countries_sri_lanka_sabaragamuwa_province_bulathkohupitiya', 'ChIJqxwuWv4O4zoR6uKWY5a45GY', 7.1045281, 80.336047, 'city', '1'),
('countries_sri_lanka_province_of_uva_hambegamuwa', 'ChIJhQD5oFcO5DoRKQjgtKqnEmI', 6.5356339, 80.9823639, 'city', '0'),
('countries_sri_lanka_north_western_province_wennappuwa_town', 'ChIJM_DgEj3C4joRtPrQd9jJPbQ', 7.3493037, 79.8352767, 'city', '0'),
('countries_switzerland_zurich_hagenbuch', 'ChIJC5J6hFyRmkcRKxuXMzpMREA', 47.5213595, 8.8890608, 'city', '1'),
('countries_switzerland_zurich_hauptikon', 'ChIJvVFPW14HkEcR1cg6KWQT7z0', 47.230341, 8.495348, 'city', '1'),
('countries_sri_lanka_north_western_province_welipennagahamulla', 'ChIJfYZq1Unb4joR0i71q0vVlwg', 7.4313154, 79.9275756, 'city', '0'),
('countries_switzerland_zurich_hedingen', 'ChIJg5nAnZYIkEcR_WCjlG-_LZ8', 47.2977669, 8.4482542, 'city', '1'),
('countries_switzerland_zurich_henggart', 'ChIJk71rnY-cmkcREM-NNhp-Iw4', 47.5639239, 8.6839945, 'city', '1'),
('countries_sri_lanka_north_western_province_pahala_katuneriya', NULL, 0, 0, 'city', '0'),
('countries_switzerland_zurich_herrliberg', 'ChIJgeXBaeulmkcRs2mwW8RytAQ', 47.2895818, 8.6134257, 'city', '1'),
('countries_switzerland_zurich_hettlingen', 'ChIJO8phfZubmkcRzOf67DbYqj4', 47.5470158, 8.7087902, 'city', '1'),
('countries_sri_lanka_north_western_province_nattandiya_town', 'ChIJgc7gpXnE4joRKYogQalBlBI', 7.412487, 79.859083, 'city', '0'),
('countries_switzerland_zurich_hinwil', 'ChIJKfy9A_m4mkcRBUC593tApHs', 47.3035511, 8.8365285, 'city', '1'),
('countries_switzerland_zurich_hirzel', 'ChIJzb4G4bCumkcRTbE5NdRXOyw', 47.2146575, 8.6106574, 'city', '1'),
('countries_switzerland_zurich_hochfelden', 'ChIJUQDv_h10kEcRuDwvX37RzU4', 47.5234132, 8.5156032, 'city', '1'),
('countries_sri_lanka_north_western_province_moragollagama', 'ChIJCeRWbKjH_DoRtXp2MZh5F9E', 7.891186, 80.420624, 'city', '0'),
('countries_switzerland_zurich_hofstetten', 'ChIJubAlZZqWmkcRyOuzj7ZLC2Y', 47.4731074, 8.8538246, 'city', '1'),
('countries_switzerland_zurich_hombrechtikon', 'ChIJ4xudWJSwmkcRDlQBL1CBotk', 47.25259, 8.77026, 'city', '1'),
('countries_switzerland_zurich_horgen', 'ChIJ14sJo9KomkcR_htspxcyv7k', 47.260742, 8.596363, 'city', '1'),
('countries_sri_lanka_north_western_province_marawila_town', 'ChIJddKFUgLE4joRzexyZHWJ6bc', 7.4239428, 79.8352767, 'city', '0'),
('countries_sri_lanka_north_western_province_malabe', 'ChIJgd8BltVW4joRukmNbtkdGgM', 6.9060787, 79.9696277, 'city', '0'),
('countries_switzerland_zurich_humlikon', 'ChIJKRbtML6cmkcRwM4YQIj_AAQ', 47.5763259, 8.6704909, 'city', '1'),
('countries_sri_lanka_north_western_province_hunupola', 'ChIJ-WAfBUQ04zoRtJsUFovualk', 7.6105011, 80.3894704, 'city', '0'),
('countries_sri_lanka_north_western_province_hindagolla', 'ChIJt6qOdjY44zoRZdiIccWpeg4', 7.4866705, 80.4160783, 'city', '0'),
('countries_switzerland_zurich_kefikon', 'ChIJnVCiBFGQmkcRtA-TLH1rYj8', 47.548939, 8.832188, 'city', '1'),
('countries_switzerland_zurich_kempttal', 'ChIJl1kGIoyYmkcR-v_hfmGfByM', 47.4472668, 8.7023781, 'city', '1'),
('countries_switzerland_zurich_kilchberg', 'ChIJI5bQsoKnmkcRgkJr79hmq4M', 47.3220092, 8.5452125, 'city', '1'),
('countries_switzerland_zurich_kleinandelfingen', 'ChIJz3HodNyCmkcRX4El4VY7Nqo', 47.5991937, 8.6827722, 'city', '1'),
('countries_switzerland_zurich_kloten', 'ChIJfXVSQEJ1kEcRWHaIRtZ3a8Y', 47.4612352, 8.5534976, 'city', '1'),
('countries_switzerland_zurich_knonau', 'ChIJsbrlzToHkEcRqo2O3-eZD_k', 47.22365, 8.46278, 'city', '1'),
('countries_sri_lanka_north_western_province_hettipola', 'ChIJQ3bjmEav5DoR1yF82yvpqqM', 7.5331124, 80.9152434, 'city', '1'),
('countries_switzerland_zurich_kyburg', 'ChIJBSPAIw8YkEcRPdygRciuhtU', 47.4575017, 8.744069, 'city', '1'),
('countries_switzerland_zurich_langnau_am_albis', 'ChIJARxNgUKomkcR6yF2uKoBwS0', 47.28812, 8.53783, 'city', '1'),
('countries_switzerland_zurich_lindau', 'ChIJw7xSiqGYmkcRfvpOb1jPgDg', 47.4304072, 8.6719126, 'city', '1'),
('countries_switzerland_zurich_lufingen', 'ChIJYXHjVTOemkcRuNaPWVlhr_A', 47.4896701, 8.5942872, 'city', '1'),
('countries_sri_lanka_north_western_province_gonawila', 'ChIJ04k4XrHp4joRQYjJ8t09K_4', 7.2955421, 79.8686539, 'city', '0'),
('countries_switzerland_zurich_marthalen', 'ChIJsVMEFpeCmkcRzC9cw41Wgcs', 47.6256347, 8.6502288, 'city', '1'),
('countries_switzerland_zurich_maschwanden', 'ChIJSeWJE78GkEcR1hQUDnQ5EzA', 47.2348501, 8.425838, 'city', '1'),
('countries_switzerland_zurich_maur', 'ChIJOelH2Ua7mkcRTJz4qnrKhcU', 47.3404954, 8.6696688, 'city', '1'),
('countries_switzerland_zurich_meilen', 'ChIJlfsnGoalmkcRTDR7avq2mDE', 47.2694361, 8.64875, 'city', '1'),
('countries_sri_lanka_north_western_province_bingiriya', 'ChIJkQQzRhDS4joRfjYyEMTxLVU', 7.5982234, 79.937219, 'city', '1'),
('countries_switzerland_zurich_mettmenstetten', 'ChIJQ-HIHAUHkEcRBQxfB1kbAtQ', 47.2437032, 8.4628831, 'city', '1'),
('countries_sri_lanka_eastern_province_ampara', 'ChIJZXG7eOI-5ToRoR1WnYYJKLY', 7.2911685, 81.6723761, 'city', '0'),
('countries_sri_lanka_central_province_wayikkal', 'ChIJe-1j46Dp4joRT0QNl0oQO9g', 7.2837919, 79.8577634, 'city', '1'),
('countries_switzerland_zurich_neerach', 'ChIJi1cjWo1zkEcRVkP8anT4XsY', 47.5126005, 8.4730174, 'city', '1'),
('countries_sri_lanka_central_province_sigiriya', 'ChIJtdwzlCOh_DoRDO-aYbtyLnY', 7.9572533, 80.7600374, 'city', '0'),
('countries_switzerland_zurich_niederglatt', 'ChIJtSx9J2R0kEcRWw8pkw7K6FU', 47.4904857, 8.5033814, 'city', '1'),
('countries_switzerland_zurich_niederhasli', 'ChIJIeTCeJV0kEcRnb1bjhLcHe4', 47.4788154, 8.487184, 'city', '1'),
('countries_sri_lanka_central_province_pundaluoya_town', 'ChIJa4hrC2V44zoRczifuS8zZHE', 7.0131278, 80.6632103, 'city', '0'),
('countries_sri_lanka_central_province_peradeniya', 'ChIJ95ZTkdlo4zoR7AMt9jCs_m8', 7.2698653, 80.593833, 'city', '0'),
('countries_switzerland_zurich_oberembrach', 'ChIJOedFTveemkcRffvdiPykNFo', 47.4877064, 8.6183666, 'city', '1'),
('countries_switzerland_zurich_oberengstringen', 'ChIJ7bb4gngLkEcRsNMYQIj_AAQ', 47.4090873, 8.4627128, 'city', '1'),
('countries_switzerland_zurich_oberglatt', 'ChIJF4Iu3AR1kEcRQKGSzewM2EQ', 47.4766643, 8.5194782, 'city', '1'),
('countries_switzerland_zurich_oberhasli_oberhasli_dorf', 'ChIJHRsZA8F0kEcRdD-NowETQ7g', 47.4653917, 8.5001736, 'city', '1'),
('countries_switzerland_zurich_oberrieden', 'ChIJQ21oQpeomkcR8IwV4O0fjPQ', 47.27471, 8.57929, 'city', '1'),
('countries_sri_lanka_central_province_nuwara_eliya', 'ChIJx1QVTkOA4zoRnH2TTEAIFik', 6.9497166, 80.7891068, 'city', '1'),
('countries_switzerland_zurich_oberweningen', 'ChIJaZ7ON3BykEcR-uxoHYOZEpw', 47.5010329, 8.4053582, 'city', '1'),
('countries_sri_lanka_central_province_homagama', 'ChIJje7imY5R4joR7nNiyNu_7sM', 6.8432762, 80.0031833, 'city', '0'),
('countries_switzerland_zurich_obfelden', 'ChIJ8S-YgnoGkEcRLQLm9o69C9g', 47.2643762, 8.4309497, 'city', '1'),
('countries_sri_lanka_central_province_handessa', 'ChIJvX27Mudu4zoR3UCEvHJaNds', 7.2285777, 80.5816186, 'city', '0'),
('countries_switzerland_zurich_oetwil_am_see', 'ChIJg-AiR6e6mkcR9f9fzR9jpOw', 47.2729371, 8.7205118, 'city', '1'),
('countries_sri_lanka_central_province_akurana', 'ChIJ_T0p-SRD4zoRdkTfneWiJYE', 7.3688959, 80.6131225, 'city', '0'),
('countries_switzerland_zurich_opfikon', 'ChIJiVZw0Q-gmkcR8JXwRz-Q3gg', 47.4346801, 8.5671098, 'city', '1'),
('countries_switzerland_zurich_ossingen', 'ChIJw_irK5mEmkcRlZ9ZFtFjbhA', 47.6120042, 8.7262376, 'city', '1'),
('countries_switzerland_zurich_otelfingen', 'ChIJxY2FDbpykEcR22lUj7kkX4c', 47.4623649, 8.3901222, 'city', '1'),
('countries_switzerland_zurich_ottenbach', 'ChIJ5c43_-YFkEcR0M0YQIj_AAQ', 47.2814693, 8.4040561, 'city', '1'),
('countries_spain_valencia_xirivella', 'ChIJbRTpybhPYA0R8IUj126vAgQ', 39.4597817, -0.4266584, 'city', '0'),
('countries_spain_valencia_villanueva_de_castellon', 'ChIJT6G-ig6kYQ0RU3k7RNd9fSU', 39.0764636, -0.5127877, 'city', '0'),
('countries_switzerland_zurich_pfungen', 'ChIJMQfdMYGemkcR7MTvy18nJD4', 47.5162008, 8.6468441, 'city', '1'),
('countries_switzerland_zurich_rafz', 'ChIJsbPHXtx5kEcRlY1_QU0D3Mg', 47.6114723, 8.5402379, 'city', '1'),
('countries_spain_valencia_villalonga', 'ChIJI_uhFiLsYQ0RAI8j126vAgQ', 38.8862689, -0.206942, 'city', '0'),
('countries_switzerland_zurich_regensberg', 'ChIJ-13XDOFykEcRqgA-6tjsbzw', 47.4821446, 8.436362, 'city', '1'),
('countries_spain_valencia_villafranca_del_cid', 'ChIJsXtsSfyWXw0Ra98f5ShYKM0', 40.4297868, -0.2576419, 'city', '0'),
('countries_switzerland_zurich_rheinau', 'ChIJoVlla4x4kEcRWbkvU_6CCKU', 47.6433, 8.60117, 'city', '1'),
('countries_switzerland_zurich_richterswil', 'ChIJO0JjJ6CxmkcRLdEGdhgDTXg', 47.2053892, 8.7070691, 'city', '1'),
('countries_switzerland_zurich_rickenbach', 'ChIJQYuexHiQmkcRkli5OHuTrDQ', 47.5421756, 8.7876389, 'city', '1'),
('countries_spain_valencia_venta_del_moro', 'ChIJS9V_-BglZw0R8I4j126vAgQ', 39.4365777, -1.4048249, 'city', '0'),
('countries_switzerland_zurich_rifferswil', 'ChIJBc2KjXsHkEcReQkOv83Rvro', 47.2419, 8.49602, 'city', '1'),
('countries_spain_valencia_vall_de_gallinera', 'ChIJKzOVsYrtYQ0Rc0gDLTsB8h8', 38.8307706, -0.2338473, 'city', '0'),
('countries_switzerland_zurich_rorbas', 'ChIJGwe-CBt2kEcR1a5H_w82Vk4', 47.5306966, 8.5745109, 'city', '1'),
('countries_switzerland_zurich_rudolfingen', 'ChIJ3-JS3ayDmkcR1gAQUeuLHuI', 47.6402945, 8.6739803, 'city', '1'),
('countries_spain_valencia_vallada', 'ChIJD1sHiF5xYQ0RwI4j126vAgQ', 38.891706, -0.6867939, 'city', '0'),
('countries_spain_valencia_tous', NULL, 0, 0, 'city', '0'),
('countries_spain_valencia_tavernes_de_la_valldigna', 'ChIJ1_gUCc7GYQ0R8I0j126vAgQ', 39.0812204, -0.2526163, 'city', '0'),
('countries_spain_valencia_tales', 'ChIJS2kIiNEKYA0RQEMi126vAgQ', 39.9448938, -0.3042778, 'city', '0'),
('countries_spain_valencia_silla', 'ChIJS4ahCvNMYA0RcI0j126vAgQ', 39.3626846, -0.4120058, 'city', '0'),
('countries_switzerland_zurich_russikon', 'ChIJJ7AVcg69mkcRAkdT12llzpQ', 47.3944962, 8.7770557, 'city', '1'),
('countries_switzerland_zurich_saland', 'ChIJvzIDSWW-mkcRhIPP9Zy6bfc', 47.391111, 8.853611, 'city', '1'),
('countries_switzerland_zurich_samstagern', 'ChIJ1TMieweymkcRods2Es8BC9Q', 47.191667, 8.682167, 'city', '1'),
('countries_spain_valencia_segorbe', 'ChIJUWSMC11lYA0R8EIi126vAgQ', 39.7952118, -0.4691097, 'city', '0'),
('countries_switzerland_zurich_schleinikon', 'ChIJaZ7ON3BykEcRJtlIJaU2tLk', 47.4981542, 8.3914164, 'city', '1'),
('countries_switzerland_zurich_schlieren', 'ChIJFaLQ-AoMkEcRCJXlUN2A-eM', 47.3982611, 8.448795, 'city', '1'),
('countries_spain_valencia_sedavi', 'ChIJ-16ofzVJYA0RAI0j126vAgQ', 39.4250011, -0.3760125, 'city', '0'),
('countries_spain_valencia_san_vicent_del_raspeig', 'ChIJ-XNP4cUzYg0RYNwh126vAgQ', 38.4101441, -0.5352356, 'city', '0'),
('countries_spain_valencia_san_vicente', 'ChIJ3X-1XKcKSQ0RJG-EJlIc2Kc', 43.3813069, -4.397058, 'city', '0'),
('countries_switzerland_zurich_schwerzenbach', 'ChIJIcbAg8SjmkcRO01cuMVfbpI', 47.3825634, 8.6577503, 'city', '1'),
('countries_spain_valencia_san_juan', NULL, 0, 0, 'city', '0'),
('countries_spain_valencia_san_juan_de_alicante', 'ChIJhbtpHh46Yg0RVkQYn0Tve9I', 38.4020456, -0.4360296, 'city', '0'),
('countries_spain_valencia_ribera_de_cabanes', 'ChIJdU5XiA8QoBIRTGWoVnaZwQ4', 40.1539616, 0.1586668, 'city', '0'),
('countries_switzerland_zurich_sihlwald', 'ChIJi3T9ifiomkcRLAMzzJFNT78', 47.2713916, 8.5554214, 'city', '1'),
('countries_spain_valencia_real_de_montroi', 'ChIJ8_ApWygAYQ0RUIwj126vAgQ', 39.3137634, -0.6251541, 'city', '0'),
('countries_switzerland_zurich_stallikon', 'ChIJKRGjxUMIkEcRbsXB3uPwiJQ', 47.32495, 8.48999, 'city', '1'),
('countries_spain_valencia_real', 'ChIJTReXPbPcaw0RK5znsegjr-8', 38.9848295, -3.9273778, 'city', '0'),
('countries_switzerland_zurich_steinmaur', 'ChIJd_uR_axzkEcR0BfR0oUO-G8', 47.4997532, 8.4556518, 'city', '1'),
('countries_spain_valencia_puerto_de_gandia', 'ChIJ27xZLTToYQ0RcWdI1pBvHoQ', 38.968032, -0.1844671, 'city', '0'),
('countries_spain_valencia_pucol', 'ChIJD1c2W3pAYA0R4Isj126vAgQ', 39.6152816, -0.3042778, 'city', '0'),
('countries_switzerland_zurich_sulzbach', 'ChIJH61kjj67mkcR_CJAB6Or__8', 47.3287081, 8.744778, 'city', '1'),
('countries_spain_valencia_polop', 'ChIJ74ykz9ICYg0RgNsh126vAgQ', 38.6221057, -0.1266861, 'city', '1'),
('countries_switzerland_zurich_tann', 'ChIJXd__FYC3mkcRWORISM8E62g', 47.263, 8.850833, 'city', '1'),
('countries_spain_valencia_piles', 'ChIJC2BHxzXmYQ0Rpe5o1ALHaYU', 38.9432525, -0.1284404, 'city', '0'),
('countries_switzerland_zurich_thalwil', 'ChIJZRgMayummkcRYOMYQIj_AAQ', 47.2949282, 8.5644799, 'city', '1'),
('countries_spain_valencia_picanya', 'ChIJ1X91ZzpOYA0RIIsj126vAgQ', 39.4390354, -0.4360881, 'city', '0'),
('countries_spain_valencia_peniscola', 'ChIJpUri3pBGoBIRmZO3ODGuNY4', 40.3668829, 0.3913172, 'city', '0'),
('countries_switzerland_zurich_truttikon', 'ChIJs6sdjXuEmkcRapwXDipp6eU', 47.6289912, 8.7272903, 'city', '1'),
('countries_switzerland_zurich_turbenthal', 'ChIJm4ML8pSVmkcRcOwp-T-EVPo', 47.4354, 8.84749, 'city', '1'),
('countries_switzerland_zurich_uerikon', 'ChIJHw1VrvywmkcRRfI5-BTyErs', 47.23666, 8.75566, 'city', '1'),
('countries_switzerland_zurich_uerzlikon', 'ChIJK8i9Tf2pmkcR4qW1u8qYmgw', 47.222, 8.4978, 'city', '1'),
('countries_switzerland_zurich_uetikon', 'ChIJf4muWvOvmkcR-0qE5A8TZeE', 47.2659401, 8.6767807, 'city', '1'),
('countries_spain_valencia_oropesa_del_mar', 'ChIJQUX1K8MEoBIRRTnUI_FWtnk', 40.1144658, 0.1401381, 'city', '0'),
('countries_spain_valencia_orihuela_costa', 'ChIJrXGhrgMGYw0RZHfqlcR_6s0', 37.9000734, -0.7505275, 'city', '0'),
('countries_switzerland_zurich_uitikon', 'ChIJU9cekFsJkEcRqiEljqV923I', 47.3709461, 8.451903, 'city', '1'),
('countries_switzerland_zurich_unterengstringen', 'ChIJrXCIJn0MkEcRTMggKyLz2og', 47.4136272, 8.4489183, 'city', '1'),
('countries_switzerland_zurich_unterstammheim', 'ChIJ8eFq3b-FmkcRPN7WXaf_QVk', 47.6393, 8.7903288, 'city', '1'),
('countries_spain_valencia_orihuela', 'ChIJhyIbJBqZYw0Ruvdj1ejbEV4', 38.0855352, -0.9480358, 'city', '0'),
('countries_spain_valencia_onda', 'ChIJa2wEGALiXw0RwEEi126vAgQ', 39.9604442, -0.2432307, 'city', '0'),
('countries_switzerland_zurich_uster', 'ChIJqSAyO3SkmkcRVHygt7gHYPo', 47.3482747, 8.7178739, 'city', '1'),
('countries_switzerland_zurich_volken', 'ChIJTbxgohWdmkcRRMAyty6n1yQ', 47.5740714, 8.6249262, 'city', '1'),
('countries_spain_valencia_oasis_la_marina', 'ChIJR50vvaqvYw0RoXSvNMEsUH4', 38.1319528, -0.6940473, 'city', '0'),
('countries_switzerland_zurich_wald', 'ChIJmx7q-43HmkcRfHljHmrU0Ss', 47.2771375, 8.9155608, 'city', '1'),
('countries_switzerland_zurich_wallisellen', 'ChIJRZuOWEigmkcRCrRpMv-i5yk', 47.4156189, 8.5889722, 'city', '1'),
('countries_spain_valencia_mutxamel', 'ChIJy9XOcOMwYg0RcNoh126vAgQ', 38.419735, -0.4471011, 'city', '0'),
('countries_switzerland_zurich_wasterkingen', 'ChIJJ_VD249wkEcRGqdB-H-mktg', 47.590325, 8.4719861, 'city', '1'),
('countries_spain_valencia_museros', 'ChIJTbjhJTZBYA0RIIoj126vAgQ', 39.5737943, -0.3607137, 'city', '0'),
('countries_switzerland_zurich_weiach', 'ChIJs7UDNqNxkEcRWfrQOBGOghw', 47.5564342, 8.4375977, 'city', '1'),
('countries_switzerland_zurich_weiningen', 'ChIJdz6Xo_UMkEcRB_p_Saz3A6c', 47.4197021, 8.4344485, 'city', '1'),
('countries_switzerland_zurich_weisslingen', 'ChIJVwOY1OGXmkcRqc9kmamtmaQ', 47.431923, 8.7634595, 'city', '1'),
('countries_switzerland_zurich_wermatswil', 'ChIJFQXoirG8mkcRr33WTfmyBIA', 47.3618541, 8.7439399, 'city', '1'),
('countries_spain_valencia_montesa', 'ChIJyz70UFB0YQ0R8Ikj126vAgQ', 38.9338004, -0.6298922, 'city', '0'),
('countries_spain_valencia_moncada', 'ChIJxaZTSEFEYA0R6nX08uBLE3M', 39.5633358, -0.3983829, 'city', '0'),
('countries_spain_valencia_mislata', 'ChIJxwW7PIVPYA0RoIkj126vAgQ', 39.4779243, -0.4195876, 'city', '0'),
('countries_switzerland_zurich_wetzikon', 'ChIJO8C5p9y7mkcR9wzxyfffUEo', 47.3270602, 8.801356, 'city', '1'),
('countries_spain_valencia_meliana', 'ChIJJ_6dqPZGYA0RmA9Rp3kyPvk', 39.5247603, -0.3348372, 'city', '0'),
('countries_spain_valencia_massalfassar', 'ChIJQ7jubkRHYA0RQIkj126vAgQ', 39.5558349, -0.3160286, 'city', '0'),
('countries_switzerland_zurich_wil', 'ChIJBaBuPwF6kEcRJqwuQamwQcw', 47.6058683, 8.5075995, 'city', '1'),
('countries_switzerland_zurich_wila', 'ChIJnbS4seS9mkcRkgBRhFdnnz4', 47.420074, 8.8454393, 'city', '1'),
('countries_switzerland_zurich_wildberg', 'ChIJLyXY1vK9mkcRC648n1CrckU', 47.4274354, 8.815767, 'city', '1'),
('countries_switzerland_zurich_windlach', 'ChIJRduZ4EJxkEcRKOgKnzDCKK0', 47.540831, 8.473612, 'city', '1'),
('countries_spain_valencia_manuel', 'ChIJL9TiHpyjYQ0REIkj126vAgQ', 39.0544094, -0.4927134, 'city', '0'),
('countries_switzerland_zurich_winkel', 'ChIJfxCVqJ51kEcR4NAYQIj_AAQ', 47.4921213, 8.5554248, 'city', '1'),
('countries_spain_valencia_l_eliana', 'ChIJofX1fVNZYA0RpkROfjpIfmE', 39.5628099, -0.5305087, 'city', '0'),
('countries_switzerland_zurich_winterthur', 'ChIJverASaAMkEcR7B0EQZ8EmPA', 47.4988196, 8.7236889, 'city', '1'),
('countries_spain_valencia_lugar_nuevo_de_fenollet', 'ChIJX5BI1MOiYQ0R755p2UpBzJA', 39.0132719, -0.4670195, 'city', '0'),
('countries_switzerland_zurich_zell', 'ChIJ64ULwLaXmkcRmTtKQJr-f74', 47.4442589, 8.7984569, 'city', '1'),
('countries_switzerland_zurich_zollikerberg', 'ChIJAQ8AGMGmmkcRgeRcle15OyY', 47.345954, 8.603357, 'city', '1'),
('countries_switzerland_zurich_zollikon', 'ChIJ5cI0O-mmmkcRKFqAv-X3JxM', 47.3412096, 8.5772146, 'city', '1'),
('countries_spain_valencia_llombai', 'ChIJj2aQBaKqYQ0R0Igj126vAgQ', 39.2879855, -0.5920027, 'city', '0'),
('countries_switzerland_zurich_zumikon', 'ChIJZTey8oKmmkcRFr1ytHtw2R4', 47.3298953, 8.623969, 'city', '1'),
('countries_spain_valencia_la_llosa', 'ChIJTa4Kx3IRYA0RIEEi126vAgQ', 39.7702163, -0.2103988, 'city', '0'),
('countries_spain_valencia_javea', 'ChIJHYtq6JkPnhIR5z1e-Vt-fmw', 38.7890109, 0.1660813, 'city', '0'),
('countries_afghanistan', 'ChIJbQL_-LZu0TgReNqWvg1GtfM', 33.93911, 67.709953, 'region', '1'),
('countries_albania', 'ChIJLUwnvfM7RRMR7juY1onlfAc', 41.153332, 20.168331, 'region', '1'),
('countries_algeria', 'ChIJ0XsDKGqKfg0RovjXq-O-QHE', 28.033886, 1.659626, 'region', '1'),
('countries_american_samoa', 'ChIJyf1IkreEpnER3UuuLZ5z7vM', -14.270972, -170.132217, 'region', '1'),
('countries_andorra', 'ChIJlfCemC71pRIRkn_qeNc-yQc', 42.506285, 1.521801, 'region', '1'),
('countries_angola', 'ChIJJ4utyk7yURoRPU5KDZ0oClk', -11.202692, 17.873887, 'region', '1'),
('countries_anguilla', 'ChIJ5QHvjnRjDowRgdTghNNqnTs', 18.220554, -63.068615, 'region', '1'),
('countries_antarctica', 'ChIJ4Ql4Koj_nbARx8fIXTgKjbA', -82.862752, 135, 'region', '1'),
('countries_antigua_and_barbuda', 'ChIJwdG4bbluDYwRlHmL4Yg3aic', 17.060816, -61.796428, 'region', '1'),
('countries_argentina', 'ChIJZ8b99fXKvJURqA_wKpl3Lz0', -38.416097, -63.616672, 'region', '1'),
('countries_armenia', 'ChIJx7pz54RWFUARIy2C63p1tNA', 40.069099, 45.038189, 'region', '1'),
('countries_aruba', 'ChIJ23da4s84hY4RL4yBiT6KavE', 12.52111, -69.968338, 'region', '1'),
('countries_australia', 'ChIJ38WHZwf9KysRUhNblaFnglM', -25.274398, 133.775136, 'region', '1'),
('countries_austria', 'ChIJfyqdJZsHbUcRr8Hk3XvUEhA', 47.516231, 14.550072, 'region', '1'),
('countries_azerbaijan', 'ChIJ3x2iGtl8MEARCM2DPmtSyeY', 40.143105, 47.576927, 'region', '1'),
('countries_bahrain', 'ChIJEaJHak5SSD4RRhDa2-JQlC4', 26.0667, 50.5577, 'region', '1'),
('countries_bangladesh', 'ChIJp4vhgO2qrTARa_zhxOAoLQ8', 23.684994, 90.356331, 'region', '1'),
('countries_barbados', 'ChIJoxoyrvvxQ4wRKzb0jLNR7A4', 13.193887, -59.543198, 'region', '1'),
('countries_belarus', 'ChIJgUit4oQl2kYREIzsgdGhAAA', 53.709807, 27.953389, 'region', '1'),
('countries_belgium', 'ChIJl5fz7WR9wUcR8g_mObTy60c', 50.503887, 4.469936, 'region', '1'),
('countries_belize', 'ChIJ-foSwT5bXI8RTuMeP02KSvY', 17.189877, -88.49765, 'region', '1'),
('countries_benin', 'ChIJlVZ6BCtUIxAR9S5iy_h3suw', 9.30769, 2.315834, 'region', '1'),
('countries_bermuda', 'ChIJpbBohp4TLYoRvLiZLMf93zw', 32.3078, -64.7505, 'region', '1'),
('countries_bhutan', 'ChIJz5XFc6WSWzcR2rw2KGWsDLs', 27.514162, 90.433601, 'region', '1'),
('countries_bolivia', 'ChIJlaK7d4nfXpERv-0VAbvCnhw', -16.290154, -63.588653, 'region', '1'),
('countries_spain_valencia_ibi', 'ChIJqeR061sqYg0R0Nkh126vAgQ', 38.6307459, -0.5446912, 'city', '0'),
('countries_bosnia_and_herzegovina', 'ChIJ16k3xxWiSxMRDOm3QwPi920', 43.915886, 17.679076, 'region', '1'),
('countries_botswana', 'ChIJESJF0SFDpB4Re68Vhyp8ZPE', -22.328474, 24.684866, 'region', '1'),
('countries_bouvet_island', 'ChIJFycMPCI_OkYR67za-flwaLc', -54.4207915, 3.3464497, 'region', '1'),
('countries_brazil', 'ChIJzyjM68dZnAARYz4p8gYVWik', -14.235004, -51.92528, 'region', '1'),
('countries_british_indian_ocean_territory', 'ChIJh6OdhOBzkiQR4WsfEHBkT6k', -6.343194, 71.876519, 'region', '1'),
('countries_british_virgin_islands', 'ChIJzVNkK5xzBYwRPTvsse5woG0', 18.420695, -64.639968, 'region', '1'),
('countries_brunei', 'ChIJ0bm4BEuZGDIR1toJ3YA1_l0', 4.535277, 114.727669, 'region', '1'),
('countries_bulgaria', 'ChIJifBbyMH-qEAREEy_aRKgAAA', 42.733883, 25.48583, 'region', '1'),
('countries_burkina_faso', 'ChIJm3Cm1SbKLQ4Rq22DRu0Kkyc', 12.238333, -1.561593, 'region', '1'),
('countries_burundi', 'ChIJW_FUNtNEwRkRjewxVg5NI7E', -3.373056, 29.918886, 'region', '1'),
('countries_cambodia', 'ChIJQzfc1L-HBzERUxL0ieC_t-Q', 12.565679, 104.990963, 'region', '1'),
('countries_cameroon', 'ChIJIQ8-cFM3YRARU5uCmUXEAys', 7.369722, 12.354722, 'region', '1'),
('countries_canada', 'ChIJ2WrMN9MDDUsRpY9Doiq3aJk', 56.130366, -106.346771, 'region', '1'),
('countries_cayman_islands', 'ChIJKaq4Lz6GJY8RXnFwh9PERXA', 19.3133, -81.2546, 'region', '1'),
('countries_central_african_republic', 'ChIJt6KGjVPpuBARJIBcWgLGm7g', 6.611111, 20.939444, 'region', '1'),
('countries_chad', 'ChIJYXNnvXg55xARnIDAzluDYDs', 15.454166, 18.732207, 'region', '1'),
('countries_chile', 'ChIJL68lBEHFYpYRHbkCERPhBQU', -35.675147, -71.542969, 'region', '1'),
('countries_china', 'ChIJwULG5WSOUDERbzafNHyqHZU', 35.86166, 104.195397, 'region', '1'),
('countries_christmas_island', 'ChIJz6fA4yea9S4RFup1BAnW5xU', -10.447525, 105.690449, 'region', '1'),
('countries_cocos_keeling_islands', 'ChIJwWnofonFDi8Rpp_jEPBC0ds', -12.164165, 96.870956, 'region', '1'),
('countries_colombia', 'ChIJo5QVrjqkFY4RQKPy7wSaDZo', 4.570868, -74.297333, 'region', '1'),
('countries_comoros', 'ChIJjaQIZAPjmBgR29Tf5L5_Cvc', -11.6455, 43.3333, 'region', '1'),
('countries_cook_islands', 'ChIJ3d57ue-KVHER2LQIiA6lTAI', -21.236736, -159.777671, 'region', '1'),
('countries_costa_rica', 'ChIJJcmsIWLlko8RK5qBNSX3VGI', 9.748917, -83.753428, 'region', '1'),
('countries_croatia', 'ChIJ7ZXdCghBNBMRfxtm4STA86A', 45.1, 15.2000001, 'region', '1'),
('countries_cuba', 'ChIJtUx6DwdJzYgRGqQQkVL3jHk', 21.521757, -77.781167, 'region', '1'),
('countries_curacao', 'ChIJx_3HYr6dhI4RI0fG2yiSf_w', 12.16957, -68.99002, 'region', '1'),
('countries_cyprus', 'ChIJVU1JymcX3hQRbhTEf4A8TDI', 35.126413, 33.429859, 'region', '1'),
('countries_czechia', 'ChIJQ4Ld14-UC0cRb1jb03UcZvg', 49.817492, 15.472962, 'region', '1'),
('countries_denmark', 'ChIJ-1-U7rYnS0YRzZLgw9BDh1I', 56.26392, 9.501785, 'region', '1'),
('countries_djibouti', 'ChIJAfb5NGfUIhYRiFsP76e7chQ', 11.825138, 42.590275, 'region', '1'),
('countries_dominica', 'ChIJFVoV8vrSFIwRPP06BQmRs0k', 15.414999, -61.370976, 'region', '1'),
('countries_dominican_republic', 'ChIJ9bbx3jiIr44R4PcNBiQPAqY', 18.735693, -70.162651, 'region', '1'),
('countries_spain_valencia_hondon_de_las_nieves', 'ChIJp-rFcF6_Yw0RywGRhFn-lzg', 38.3083971, -0.8525868, 'city', '0'),
('countries_ecuador', 'ChIJ1UuaqN2HI5ARAjecEQSvdp0', -1.831239, -78.183406, 'region', '1'),
('countries_egypt', 'ChIJ6TZcw3aJNhQRRMTEJQmgRSw', 26.820553, 30.802498, 'region', '1'),
('countries_el_salvador', 'ChIJVwZkWaYnY48RMkiFmOsWmm8', 13.794185, -88.89653, 'region', '1'),
('countries_equatorial_guinea', 'ChIJp4euX2A6ZBARet4QLKKicMg', 1.650801, 10.267895, 'region', '1'),
('countries_eritrea', 'ChIJZYW6nT9abRYR-g4SL_AIwhc', 15.179384, 39.782334, 'region', '1'),
('countries_estonia', 'ChIJ_UuggpyUkkYRwyW0T7qf6kA', 58.595272, 25.0136071, 'region', '1'),
('countries_eswatini', 'ChIJBw8yR-HO6B4RaXANGC_GPcE', -26.522503, 31.465866, 'region', '1'),
('countries_ethiopia', 'ChIJK_1s3c7QNRYRWsVIU3-m9ns', 9.145, 40.489673, 'region', '1'),
('countries_faroe_islands', 'ChIJ6_ktdpMVvEgRJBv3ZEgxsD8', 61.892635, -6.9118061, 'region', '1'),
('countries_federated_states_of_micronesia', 'ChIJE8hYrMW12WURJWWk-s2NelQ', 7.425554, 150.550812, 'region', '1'),
('countries_fiji', 'ChIJXdw8cP2QGW4Rk1vvRpkxnJ4', -17.713371, 178.065032, 'region', '1'),
('countries_finland', 'ChIJ3fYyS9_KgUYREKh1PNZGAQA', 61.92411, 25.7481511, 'region', '1'),
('countries_france', 'ChIJMVd4MymgVA0R99lHx5Y__Ws', 46.227638, 2.213749, 'region', '1'),
('countries_french_guiana', 'ChIJU9f3hVcVEo0RRvQKD-n3J94', 3.933889, -53.125782, 'region', '1'),
('countries_french_polynesia', 'ChIJTddtfNB1GHQREVfDCXp6wJs', -17.679742, -149.406843, 'region', '1'),
('countries_gabon', 'ChIJ7fM4VIo7fxARFWt4Ng7DDHs', -0.803689, 11.609444, 'region', '1'),
('countries_spain_valencia_guardamar_del_segura', 'ChIJj7zY2hmsYw0RoNkh126vAgQ', 38.0718346, -0.6678177, 'city', '0'),
('countries_germany', 'ChIJa76xwh5ymkcRW-WRjmtd6HU', 51.165691, 10.451526, 'region', '1'),
('countries_ghana', 'ChIJx9baqM1a1w8RNtKT0DDy11Q', 7.946527, -1.023194, 'region', '1'),
('countries_gibraltar', 'ChIJNb4UJ3a_DA0RD4cANiYlTjg', 36.140751, -5.353585, 'region', '1'),
('countries_greece', 'ChIJY2xxEcdKWxMRHS2a3HUXOjY', 39.074208, 21.824312, 'region', '1'),
('countries_greenland', 'ChIJFXfA47sNok4RGOIUAYOdzzQ', 71.706936, -42.604303, 'region', '1'),
('countries_grenada', 'ChIJ0XuH9IkXOIwRjk8fWgHH2DY', 12.1165, -61.679, 'region', '1'),
('countries_guadeloupe', 'ChIJUX0od1p1DowRqwdKtzc-vuw', 16.265, -61.551, 'region', '1'),
('countries_guam', 'ChIJ7yQPk_92H2cRpuWzxZGucVU', 13.444304, 144.793731, 'region', '1'),
('countries_guatemala', 'ChIJa1DnNlATiIURu9WEWzcrmDU', 15.783471, -90.230759, 'region', '1'),
('countries_guernsey', 'ChIJ33aRLjJyDUgRy2rAnmNjANE', 49.4481982, -2.58949, 'region', '1'),
('countries_guinea', 'ChIJP5XOvCGzAQ8R9i1a18t7c-g', 9.945587, -9.696645, 'region', '1'),
('countries_guinea_bissau', 'ChIJ8amCr3Q85A4RTggeVz-O6Ls', 11.803749, -15.180413, 'region', '1'),
('countries_guinea_bissau', 'ChIJ8amCr3Q85A4RTggeVz-O6Ls', 11.803749, -15.180413, 'region', '1'),
('countries_guyana', 'ChIJs8LYYK_vr40RQETltmeI40g', 4.860416, -58.93018, 'region', '1'),
('countries_haiti', 'ChIJEbvLf_PGto4R0_ZUTLI4FLU', 18.971187, -72.285215, 'region', '1'),
('countries_honduras', 'ChIJzzG3cxp1ao8RZIL7toLe0X4', 15.199999, -86.241905, 'region', '1'),
('countries_hong_kong', 'ChIJD5gyo-3iAzQRfMnq27qzivA', 22.3193039, 114.1693611, 'region', '1'),
('countries_hungary', 'ChIJw-Q333uDQUcREBAeDCnEAAA', 47.162494, 19.5033041, 'region', '1'),
('countries_iceland', 'ChIJQ2Dro1Ir0kgRmkXB5TQEim8', 64.963051, -19.020835, 'region', '1'),
('countries_india', 'ChIJkbeSa_BfYzARphNChaFPjNc', 20.593684, 78.96288, 'region', '1'),
('countries_indonesia', 'ChIJtwRkSdcHTCwRhfStG-dNe-M', -0.789275, 113.921327, 'region', '1'),
('countries_iran', 'ChIJ8R1rwS7s9z4RzvpRntOVsEA', 32.427908, 53.688046, 'region', '1'),
('countries_iraq', 'ChIJEUr1VD2CVxURAhYGorthpW0', 33.223191, 43.679291, 'region', '1'),
('countries_ireland', 'ChIJ-ydAXOS6WUgRCPTbzjQSfM8', 53.41291, -8.24389, 'region', '1'),
('countries_isle_of_man', 'ChIJ1YEuRDCFY0gRDeDw8bxbAuo', 54.236107, -4.548056, 'region', '1'),
('countries_israel', 'ChIJi8mnMiRJABURuiw1EyBCa2o', 31.046051, 34.851612, 'region', '1'),
('countries_italy', 'ChIJA9KNRIL-1BIRb15jJFz1LOI', 41.87194, 12.56738, 'region', '1'),
('countries_spain_valencia_gilet', 'ChIJU85xIGBqYA0RVrvCWKmttH0', 39.6668237, -0.3324856, 'city', '0'),
('countries_jamaica', 'ChIJnXHPxhsq2o4R-g4StcDRoFk', 18.109581, -77.297508, 'region', '1'),
('countries_japan', 'ChIJLxl_1w9OZzQRRFJmfNR1QvU', 36.204824, 138.252924, 'region', '1'),
('countries_jersey', 'ChIJM3WSjKRSDEgRw2waCqMjnFE', 49.2137711, -2.1357662, 'region', '1'),
('countries_kazakhstan', 'ChIJR6n87AcQqTgRGw6z5C-Ee18', 48.019573, 66.923684, 'region', '1'),
('countries_kenya', 'ChIJD5BQg9CAJxgR2W2XobAOO0A', -0.023559, 37.906193, 'region', '1'),
('countries_kiribati', 'ChIJA4cCwpF8ZGURB8NSAQR9MoQ', -3.370417, -168.734039, 'region', '1'),
('countries_kuwait', 'ChIJoVHqvj82xT8R0u3Yks1rcnQ', 29.31166, 47.481766, 'region', '1'),
('countries_kyrgyzstan', 'ChIJ8yfp_B04lzgRM8SITrdYECg', 41.20438, 74.766098, 'region', '1'),
('countries_laos', 'ChIJiUWCsFeQFDERgc2ZH0iSxQ4', 19.85627, 102.495496, 'region', '1'),
('countries_latvia', 'ChIJ_ZqKe2cw6UYREPzyaM3PAAA', 56.879635, 24.603189, 'region', '1'),
('countries_lebanon', 'ChIJraoihAIXHxURcPkAbAk0fcw', 33.854721, 35.862285, 'region', '1'),
('countries_lesotho', 'ChIJ64xf1idIjB4Rsx7ReLhXLSM', -29.609988, 28.233608, 'region', '1'),
('countries_liberia', 'ChIJwfyp1AP4CQ8Rc2PRMmso038', 6.428055, -9.429499, 'region', '1'),
('countries_libya', 'ChIJDQHOjtmSqBMRKsL5x0FgB_o', 26.3351, 17.228331, 'region', '1'),
('countries_liechtenstein', 'ChIJ_S9HHUQxm0cRibFa3Ta16mA', 47.166, 9.555373, 'region', '1'),
('countries_luxembourg', 'ChIJRyEhyrlFlUcR75LTAvZg22Q', 49.815273, 6.129583, 'region', '1'),
('countries_macao', 'ChIJ88g14uB6ATQR9qyFtCzje8Y', 22.198745, 113.543873, 'region', '1'),
('countries_madagascar', 'ChIJRYUj6uOk0SERiBN7l8HjRFI', -18.766947, 46.869107, 'region', '1'),
('countries_malawi', 'ChIJ18ATk91b2BgRQ4VmKRcuo0Q', -13.254308, 34.301525, 'region', '1'),
('countries_malaysia', 'ChIJrzBnX5fTNDAR2BwhKJOWRQc', 4.210484, 101.975766, 'region', '1'),
('countries_maldives', 'ChIJvXv7qr-ZtSQRiWKVgeEJRUE', 3.202778, 73.22068, 'region', '1'),
('countries_mali', 'ChIJz3MQG4g-FA4RgM-9oOJbOrs', 17.570692, -3.996166, 'region', '1'),
('countries_malta', 'ChIJxUeGHShFDhMROUK-NmHYgvU', 35.937496, 14.375416, 'region', '1'),
('countries_marshall_islands', 'ChIJK8opIbIZAWURdrcJqugDPos', 7.131474, 171.184478, 'region', '1'),
('countries_martinique', 'ChIJDQdmAPmgaowRsOevFxIbAOE', 14.641528, -61.024174, 'region', '1'),
('countries_mauritania', 'ChIJTzmzFMO4gA4RTlO-1usLIoM', 21.00789, -10.940835, 'region', '1'),
('countries_mauritius', 'ChIJyXRE-U1QfCERMdBrEcLZA0I', -20.348404, 57.552152, 'region', '1'),
('countries_mayotte', 'ChIJu43y3DMOCiIRSyr-lWcXMv8', -12.8275, 45.166244, 'region', '1'),
('countries_mexico', 'ChIJU1NoiDs6BIQREZgJa760ZO0', 23.634501, -102.552784, 'region', '1'),
('countries_monaco', 'ChIJMYU_e2_CzRIR_JzEOkx493Q', 43.7384176, 7.4246158, 'region', '1'),
('countries_mongolia', 'ChIJS22qaQYFJzYRluDmNzkh3eA', 46.862496, 103.846656, 'region', '1'),
('countries_montenegro', 'ChIJyx8sJBcyTBMRRtP_boadTDg', 42.708678, 19.37439, 'region', '1'),
('countries_montserrat', 'ChIJnTbH4VOrE4wRorEFiIPqDx4', 16.742498, -62.187366, 'region', '1'),
('countries_morocco', 'ChIJjcVRlmGICw0Rw_8sxIGT09k', 31.791702, -7.09262, 'region', '1'),
('countries_mozambique', 'ChIJxUr95uqs1BgRFaEWrrm_uxI', -18.665695, 35.529562, 'region', '1'),
('countries_namibia', 'ChIJIXXTbn489RsRYbLsqKXludM', -22.95764, 18.49041, 'region', '1'),
('countries_nauru', 'ChIJTVvkHR8cfW8RgQrUxfSd2Vk', -0.522778, 166.931503, 'region', '1'),
('countries_nepal', 'ChIJz2gufcfolTkR3obM0LyaojQ', 28.394857, 84.124008, 'region', '1'),
('countries_netherlands', 'ChIJu-SH28MJxkcRnwq9_851obM', 52.132633, 5.291266, 'region', '1'),
('countries_new_caledonia', 'ChIJyzIaP2niJ2wR7HqT1Y_20PY', -20.904305, 165.618042, 'region', '1'),
('countries_new_zealand', 'ChIJh5Z3Fw4gLG0RM0dqdeIY1rE', -40.900557, 174.885971, 'region', '1'),
('countries_nicaragua', 'ChIJzSL_zgDCEI8RtRWsP-Wn-sg', 12.865416, -85.207229, 'region', '1'),
('countries_niger', 'ChIJXa-hxnrsmRER1CSOFQqSM8k', 17.607789, 8.081666, 'region', '1'),
('countries_nigeria', 'ChIJDY2kfa8LThARyAvFaEH-qJk', 9.081999, 8.675277, 'region', '1'),
('countries_niue', 'ChIJO7duNyolnXERGIvcezR4QpE', -19.054445, -169.867233, 'region', '1'),
('countries_norfolk_island', 'ChIJOcm6rR_RS2wRUhVdMyOYerk', -29.040835, 167.954712, 'region', '1'),
('countries_northern_mariana_islands', 'ChIJUVyZkDSx2GYRMg46fKvrt50', 15.0979, 145.6739, 'region', '1'),
('countries_north_korea', 'ChIJN0NP5toCfjURHIYdPhyHCzo', 40.339852, 127.510093, 'region', '1'),
('countries_north_macedonia', 'ChIJCUi8cJ8VVBMRscUfyNZa8uA', 41.608635, 21.745275, 'region', '1'),
('countries_norway', 'ChIJv-VNj0VoEkYRK9BkuJ07sKE', 60.472024, 8.468946, 'region', '1'),
('countries_oman', 'ChIJv5vVqWaf1j0RF6ixZXZMBjo', 21.4735329, 55.975413, 'region', '1'),
('countries_pakistan', 'ChIJH3X9-NJS2zgRXJIU5veht0Y', 30.375321, 69.345116, 'region', '1'),
('countries_palau', 'ChIJmQOvorRFhDIRu-uhOd0e7RI', 7.51498, 134.58252, 'region', '1'),
('countries_palestine', 'ChIJ2b1miNLyHBURhvZm0QGgF-4', 31.952162, 35.233154, 'region', '1'),
('countries_panama', 'ChIJ4yu-yIMVpo8Rz5ulH03g7nk', 8.537981, -80.782127, 'region', '1'),
('countries_papua_new_guinea', 'ChIJr54Ov6_oWWgRehKcjg3l8No', -6.314993, 143.95555, 'region', '1'),
('countries_paraguay', 'ChIJYz3xkDQIXJQR8y5YHWH_-rM', -23.442503, -58.443832, 'region', '1'),
('countries_peru', 'ChIJ9RRZwFDIBZERSAYheRIBnvI', -9.189967, -75.015152, 'region', '1'),
('countries_philippines', 'ChIJY96HXyFTQDIRV9opeu-QR3g', 12.879721, 121.774017, 'region', '1'),
('countries_pitcairn_islands', 'ChIJiweo3H8POJ4RyJoVGceMnEY', -24.3767537, -128.3242376, 'region', '1'),
('countries_poland', 'ChIJuwtkpGSZAEcR6lXMScpzdQk', 51.919438, 19.145136, 'region', '1'),
('countries_portugal', 'ChIJ1SZCvy0kMgsRQfBOHAlLuCo', 39.399872, -8.224454, 'region', '1'),
('countries_puerto_rico', 'ChIJ-aeSGyaWAowRGpsEGCjsNvM', 18.220833, -66.590149, 'region', '1'),
('countries_qatar', 'ChIJf-jc_zTFRT4RMkArgc-I-hw', 25.354826, 51.183884, 'region', '1'),
('countries_republic_of_lithuania', 'ChIJE74zDxSU3UYRubpdpdNUCvM', 55.169438, 23.881275, 'region', '1'),
('countries_reunion', 'ChIJO-S4EIF3eCER-erb7ImOf0o', -21.115141, 55.536384, 'region', '1'),
('countries_romania', 'ChIJw3aJlSb_sUARlLEEqJJP74Q', 45.943161, 24.96676, 'region', '1'),
('countries_russia', 'ChIJ-yRniZpWPEURE_YRZvj9CRQ', 61.52401, 105.318756, 'region', '1'),
('countries_rwanda', 'ChIJ40A451SWwhkRA6HMyyawkHQ', -1.940278, 29.873888, 'region', '1'),
('countries_saint_barthelemy', 'ChIJnej-KlR1DowR5nUq6msRdAE', 17.9, -62.833333, 'region', '1'),
('countries_saint_helena', 'ChIJ4-UsNRPi6gQRpp8ZUARPgK4', -15.9650104, -5.7089241, 'region', '1'),
('countries_saint_lucia', 'ChIJHaMt8WVgQIwR9Z056MSGdG4', 13.909444, -60.978893, 'region', '1'),
('countries_saint_martin', 'ChIJ_U5xCKxvDowRp4huTgqDGbk', 18.08255, -63.052251, 'region', '1'),
('countries_saint_pierre_and_miquelon', 'ChIJ0VcO-0tLbEsREVxs6jdncZw', 46.8852, -56.3159, 'region', '1'),
('countries_saint_vincent_and_the_grenadines', 'ChIJuzU5nuKsQIwRsaHSjejT_TE', 12.984305, -61.287228, 'region', '1'),
('countries_samoa', 'ChIJAxDsZKMTpXERcnhhdJYMh6Y', -13.759029, -172.104629, 'region', '1'),
('countries_san_marino', 'ChIJeT_m9V_rLBMRECA0gpnzAAA', 43.94236, 12.457777, 'region', '1'),
('countries_sao_tome_and_principe', 'ChIJidiaC_nscBAR6jB2VQwjUWI', 0.18636, 6.613081, 'region', '1'),
('countries_saudi_arabia', 'ChIJQSqV5z-z5xURm7YawktQYFk', 23.885942, 45.079162, 'region', '1'),
('countries_senegal', 'ChIJcbvFs_VywQ4RQFlhmVClRlo', 14.497401, -14.452362, 'region', '1'),
('countries_serbia', 'ChIJlYCJ8t8dV0cRXYYjN-pQXgU', 44.016521, 21.005859, 'region', '1'),
('countries_seychelles', 'ChIJO62-cP0hXCIR99pJ06DQ0zI', -4.679574, 55.491977, 'region', '1'),
('countries_sierra_leone', 'ChIJQ_OrOhgGAQ8RGfcsx83paVM', 8.460555, -11.779889, 'region', '1'),
('countries_singapore', 'ChIJdZOLiiMR2jERxPWrUs9peIg', 1.352083, 103.819836, 'region', '1'),
('countries_sint_maarten', 'ChIJw5D41mJuDowRQo8zJsIsi3I', 18.04248, -63.05483, 'region', '1'),
('countries_slovakia', 'ChIJf8Z8rrlgFEcRfTpysWdha80', 48.669026, 19.699024, 'region', '1'),
('countries_slovenia', 'ChIJYYOWXuckZUcRZdTiJR5FQOc', 46.151241, 14.995463, 'region', '1'),
('countries_solomon_islands', 'ChIJ0QlQVeBR02gRgClEF6DATLQ', -9.64571, 160.156194, 'region', '1'),
('countries_somalia', 'ChIJg1vR7KcuHRgRvuXpXM46OZ4', 5.152149, 46.199616, 'region', '1'),
('countries_south_africa', 'ChIJURLu2YmmNBwRoOikHwxjXeg', -30.559482, 22.937506, 'region', '1'),
('countries_spain_valencia_genoves', 'ChIJb78Zi5-iYQ0RaP2Gtwl2YMo', 38.9880342, -0.4702895, 'city', '1'),
('countries_south_korea', 'ChIJm7oRy-tVZDURS9uIugCbJJE', 35.907757, 127.766922, 'region', '1'),
('countries_south_sudan', 'ChIJGTE-PbUwGRcRl7y2fmND8Ns', 6.8769919, 31.3069788, 'region', '1'),
('countries_spain', 'ChIJi7xhMnjjQgwR7KNoB5Qs7KY', 40.463667, -3.74922, 'region', '1'),
('countries_sri_lanka', 'ChIJnR5a9jxZ4joRjNPiALSkPeE', 7.873054, 80.771797, 'region', '1'),
('countries_sudan', 'ChIJlbFyEMQc2RURNythKkZwv9I', 12.862807, 30.217636, 'region', '1'),
('countries_suriname', 'ChIJUdXT2dU2CI0RsjYpccDhNxA', 3.919305, -56.027783, 'region', '1'),
('countries_svalbard_and_jan_mayen', 'ChIJgQmY0JVjd0URQdKkzJ42A4U', 77.553604, 23.6702719, 'region', '1'),
('countries_sweden', 'ChIJ8fA1bTmyXEYRYm-tjaLruCI', 60.128161, 18.643501, 'region', '1'),
('countries_syria', 'ChIJp8Y8QdzmGBURIPYqiPRGdYc', 34.802075, 38.996815, 'region', '1'),
('countries_taiwan', 'ChIJL1cHXAbzbjQRaVScvwTwEec', 23.69781, 120.960515, 'region', '1'),
('countries_tajikistan', 'ChIJzbO8enN2sTgRtYgZT4QxwyU', 38.861034, 71.276093, 'region', '1'),
('countries_tanzania', 'ChIJEaFpSDFRSxgRMMTBSzEXWog', -6.369028, 34.888822, 'region', '1'),
('countries_thailand', 'ChIJsU1CR_eNTTARAuhXB4gs154', 15.870032, 100.992541, 'region', '1'),
('countries_togo', 'ChIJGVQYE8HhIxARYJPRGjBbrvo', 8.619543, 0.824782, 'region', '1'),
('countries_tokelau', 'ChIJ9x14s6omUnARN5vbbUZicI8', -9.2002, -171.8484, 'region', '1'),
('countries_tonga', 'ChIJHdCfu0S2k3ERqeJexcrMbfM', -21.178986, -175.198242, 'region', '1'),
('countries_trinidad_and_tobago', 'ChIJxbZQY5cHNowRJ_E5xlUoCP8', 10.691803, -61.222503, 'region', '1'),
('countries_tunisia', 'ChIJ4aQWg0SVVRIR75sBqjozhDo', 33.886917, 9.537499, 'region', '1'),
('countries_turkey', 'ChIJcSZPllwVsBQRKl9iKtTb2UA', 38.963745, 35.243322, 'region', '1'),
('countries_turkmenistan', 'ChIJy2y8dFXLZT8RkaRpQWuC3X4', 38.969719, 59.556278, 'region', '1'),
('countries_turks_and_caicos_islands', 'ChIJdWu7vlVfS4kR3sGNAoDHEX4', 21.694025, -71.797928, 'region', '1'),
('countries_tuvalu', 'ChIJTaCxWbmcwW8RLhIHB2hUZ48', -7.109535, 177.64933, 'region', '1'),
('countries_uganda', 'ChIJRfmZZJ-mcRcRSUUBQ85VQYc', 1.373333, 32.290275, 'region', '1'),
('countries_ukraine', 'ChIJjw5wVMHZ0UAREED2iIQGAQA', 48.379433, 31.1655799, 'region', '1'),
('countries_united_arab_emirates', 'ChIJvRKrsd9IXj4RpwoIwFYv0zM', 23.424076, 53.847818, 'region', '1'),
('countries_united_kingdom', 'ChIJqZHHQhE7WgIReiWIMkOg-MQ', 55.378051, -3.435973, 'region', '1'),
('countries_united_states', 'ChIJCzYy5IS16lQRQrfeQ5K5Oxw', 37.09024, -95.712891, 'region', '1'),
('countries_uruguay', 'ChIJCd5f-zoHdZURSlIWYGGWVUo', -32.522779, -55.765835, 'region', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_uzbekistan', 'ChIJsXbWpSCLrjgRIB6Efq1tCso', 41.377491, 64.585262, 'region', '1'),
('countries_spain_valencia_enguera', 'ChIJ6ZEnocJsYQ0RcIYj126vAgQ', 38.9640047, -0.810357, 'city', '0'),
('countries_u_s_virgin_islands', 'ChIJuaza8mUQBYwRBRzFGx2JHfk', 18.335765, -64.896335, 'region', '1'),
('countries_vanuatu', 'ChIJE2CSyF5giW4RaibQvs85gzQ', -15.376706, 166.959158, 'region', '1'),
('countries_vatican_city', 'ChIJPS3UVwqJJRMRsH46sppPCQA', 41.902916, 12.453389, 'region', '1'),
('countries_venezuela', 'ChIJAdjLNstTKIwR003VfFjyoNw', 6.42375, -66.58973, 'region', '1'),
('countries_vietnam', 'ChIJXx5qc016FTERvmL-4smwO7A', 14.058324, 108.277199, 'region', '1'),
('countries_wallis_and_futuna', 'ChIJPUsabgaxyHERGwrSj-wYyRY', -14.2938, -178.1165, 'region', '1'),
('countries_western_sahara', 'ChIJUyEwIyVIIgwRWtffcxj4prc', 24.215527, -12.885834, 'region', '1'),
('countries_yemen', 'ChIJX7w0fKzbAxYRrneufjcp8ZI', 15.552727, 48.516388, 'region', '1'),
('countries_zambia', 'ChIJcQv8_KX0QBkRRT5Yfqz5n_E', -13.133897, 27.849332, 'region', '1'),
('countries_zimbabwe', 'ChIJYXGxBuekMRkR7r_LxV84wKE', -19.015438, 29.154857, 'region', '1'),
('countries_afghanistan_balkh', 'ChIJ56jGAKruND8RqJ96vYSrw38', 36.7550603, 66.8975372, 'region', '1'),
('countries_afghanistan_herat', 'ChIJ92y-lKjmPD8RxHfWUhf4uZ0', 34.352865, 62.2040287, 'region', '1'),
('countries_afghanistan_kabul', 'ChIJSW0ePExp0TgRKUQheDVH3-s', 34.5553494, 69.207486, 'region', '1'),
('countries_afghanistan_kandahar', 'ChIJN4jioLpx1j4RdapCkByyWSc', 31.628871, 65.7371749, 'region', '1'),
('countries_afghanistan_nangarhar', 'ChIJSQqHpM3-2TgRdRNRqQWW0Tw', 34.1718313, 70.6216794, 'region', '1'),
('countries_afghanistan_nimroz', 'ChIJkfefVGga3z4ROESisQoTSIE', 31.0261488, 62.4504154, 'region', '1'),
('countries_afghanistan_parwan', 'ChIJ1WolE2iP0TgRa2st5xx7J_o', 34.9630977, 68.8108849, 'region', '1'),
('countries_spain_valencia_el_grao', 'ChIJiRAbKIv_nxIRglU_DkvhB04', 39.9837993, 0.0209881, 'city', '1'),
('countries_afghanistan_herat_herat', 'ChIJ92y-lKjmPD8RxHfWUhf4uZ0', 34.352865, 62.2040287, 'city', '1'),
('countries_afghanistan_kabul_kabul', 'ChIJSW0ePExp0TgRKUQheDVH3-s', 34.5553494, 69.207486, 'city', '1'),
('countries_afghanistan_kandahar_kandahar', 'ChIJN4jioLpx1j4RdapCkByyWSc', 31.628871, 65.7371749, 'city', '1'),
('countries_afghanistan_nangarhar_jalalabad', 'ChIJjT8HBw4H2jgRNJY357n6F3U', 34.4283529, 70.4578019, 'city', '1'),
('countries_afghanistan_nimroz_zaranj', 'ChIJRx8pOUeX3z4R3fJNTqailRg', 30.9606622, 61.8526229, 'city', '1'),
('countries_afghanistan_parwan_charikar', 'ChIJuWyPaEKR0TgReKftBR1ShDI', 35.0107648, 69.1625896, 'city', '1'),
('countries_spain_valencia_els_poblets', 'ChIJJ03RKnMdnhIRgN0h126vAgQ', 38.854788, 0.0172741, 'city', '0'),
('countries_aland_aland_s_lands_eckero', 'ChIJPeafcaS9ikYRSQpPoKgcgdA', 60.2231622, 19.5595375, 'city', '1'),
('countries_aland_aland_s_lands_finstrom', 'ChIJV-Yz8C7qikYR8VFy16ViKPc', 60.2299128, 19.9880632, 'city', '1'),
('countries_aland_aland_s_lands_foglo', 'ChIJoaDttygni0YR0BE-Bwx10HY', 60.0146083, 20.4139403, 'city', '1'),
('countries_aland_aland_s_lands_hammarland', 'ChIJX7wiB9K_ikYRTc_U5K1m2VE', 60.216399, 19.7402399, 'city', '1'),
('countries_aland_aland_s_lands_hellesby', 'ChIJWXBLWbe_ikYRkEiPuVO1AAo', 60.200305, 19.7351966, 'city', '1'),
('countries_aland_aland_s_lands_jomala', 'ChIJTfNg9SvCikYRWrNkd83bjOI', 60.1522174, 19.9486168, 'city', '1'),
('countries_aland_aland_s_lands_kumlinge', 'ChIJRSA0Y8oEi0YREuabhpfI9dI', 60.2587889, 20.7779888, 'city', '1'),
('countries_aland_aland_s_lands_lemland', 'ChIJgezseWfbikYRtJBF4BT7x1o', 60.0688511, 20.0864136, 'city', '1'),
('countries_aland_aland_s_lands_mariehamn', 'ChIJ7TXGu5vDikYRzZqPbAILQkY', 60.0970945, 19.9348339, 'city', '1'),
('countries_spain_valencia_elda', 'ChIJ1_zHZ6jEYw0RANkh126vAgQ', 38.4764864, -0.7965933, 'city', '0'),
('countries_aland_aland_s_lands_saltvik', 'ChIJSUqZtoXuikYRUMnNjIbRLRI', 60.2755254, 20.0619188, 'city', '1'),
('countries_aland_aland_s_lands_sibby', 'ChIJwRabf1TvikYRUMiOuVO1AAo', 60.2570482, 20.1925261, 'city', '1'),
('countries_spain_valencia_daimus', 'ChIJi1s9kAnoYQ0RIIYj126vAgQ', 38.9745344, -0.1518394, 'city', '0'),
('countries_albania_qarku_i_beratit', 'ChIJUTWnWliaWhMR9fDTR_KNChI', 40.6953012, 20.0449662, 'region', '1'),
('countries_albania_qarku_i_dibres', 'ChIJjdFoO1OhURMRGgqTIi7s514', 41.5888163, 20.2355647, 'region', '1'),
('countries_albania_qarku_i_durresit', 'ChIJ147xajwrUBMRL2guPawAYGM', 41.5080972, 19.6163185, 'region', '1'),
('countries_albania_qarku_i_elbasanit', 'ChIJHRZnJp5nUBMRSqEA7NdmbjY', 41.1266672, 20.2355647, 'region', '1'),
('countries_albania_qarku_i_fierit', 'ChIJmfqXjzz8TxMRtcOcOmoEGGE', 40.9191392, 19.6639309, 'region', '1'),
('countries_albania_qarku_i_gjirokastres', 'ChIJY185ucYDWxMRuOK8fYVjhCs', 40.0817531, 20.1879106, 'region', '1'),
('countries_albania_qarku_i_korces', 'ChIJo4MyMRN1WhMRgft6g3xpYJw', 40.590567, 20.6168921, 'region', '1'),
('countries_albania_qarku_i_kukesit', 'ChIJaVcCMfczUhMR6BazzXPc2VI', 42.0120271, 20.4262088, 'region', '1'),
('countries_albania_qarku_i_lezhes', 'ChIJa9mUpFfpURMRu2dDDEepESw', 41.7813759, 19.8067916, 'region', '1'),
('countries_albania_qarku_i_shkodres', 'ChIJLyGY-VsAThMRToDRZL0_DXw', 42.0692985, 19.5032559, 'region', '1'),
('countries_albania_qarku_i_vlores', 'ChIJq8RyxfM7RRMRauu9ZqluA5U', 40.150096, 19.8067916, 'region', '1'),
('countries_albania_tirana', 'ChIJ28X6cAQxUBMRIDdlEK-SAAQ', 41.3275459, 19.8186982, 'region', '1'),
('countries_albania_qarku_i_beratit_berat', 'ChIJycU2dbOYWhMR5UQv3apiTNE', 40.7086377, 19.9437314, 'city', '1'),
('countries_spain_valencia_cullera', 'ChIJlcqFTX3IYQ0RoIUj126vAgQ', 39.1644989, -0.2526163, 'city', '0'),
('countries_albania_qarku_i_beratit_perondi', 'ChIJT7Qe3hGgWhMR8-LTXUYr8qw', 40.783499, 19.941322, 'city', '1'),
('countries_albania_qarku_i_beratit_prrenjas', 'ChIJz10D3PntUBMRsjkLErjD38w', 41.0714827, 20.5483612, 'city', '1'),
('countries_albania_qarku_i_beratit_ura_vajgurore', 'ChIJeXQLbN2gWhMRWhBUuu4N4uI', 40.7720633, 19.8752578, 'city', '1'),
('countries_albania_qarku_i_dibres_burrel', 'ChIJPSTpYTS5URMRHVGsxuYy4qs', 41.6089452, 20.006257, 'city', '1'),
('countries_albania_qarku_i_dibres_peshkopi', 'ChIJwU3-T5VzURMRhCjCsSULgBA', 41.684866, 20.4291879, 'city', '1'),
('countries_spain_valencia_chulilla', 'ChIJSxtsWkiVYA0RDuJAoQw5_P8', 39.6589813, -0.8579818, 'city', '0'),
('countries_albania_qarku_i_durresit_durres', 'ChIJx7y7X3zZTxMR7oHN5up383c', 41.3245904, 19.4564686, 'city', '1'),
('countries_spain_valencia_chiva', 'ChIJPxvZ03bwYA0RAIYj126vAgQ', 39.4726034, -0.7193825, 'city', '0'),
('countries_albania_qarku_i_durresit_hamallaj', 'ChIJIekv3iHVTxMRRSS9Un_RygY', 41.4675228, 19.525569, 'city', '1'),
('countries_spain_valencia_chilches', 'ChIJMbJNUoQQYA0R4uEOqup5ew0', 39.7680373, -0.1566833, 'city', '0'),
('countries_albania_qarku_i_durresit_shijak', 'ChIJw3UgoN_XTxMRX1nHBAD1_ig', 41.3458989, 19.5657349, 'city', '1'),
('countries_spain_valencia_carlet', 'ChIJvcQge1ipYQ0RYIQj126vAgQ', 39.246716, -0.5352356, 'city', '0'),
('countries_spain_valencia_carcaixent', 'ChIJicb27My6YQ0RAot5WLdagBE', 39.1015624, -0.4219444, 'city', '0'),
('countries_albania_qarku_i_elbasanit_elbasan', 'ChIJFdN4ggBDUBMRCm5pj3wyQ0I', 41.11023, 20.0866554, 'city', '1'),
('countries_albania_qarku_i_elbasanit_gramsh', 'ChIJ-UhfV6x7UBMRbCp7-6y1Gco', 40.8669873, 20.1849323, 'city', '1'),
('countries_albania_qarku_i_elbasanit_librazhd', 'ChIJi01HJxFYUBMRCKHNQ5zBlmk', 41.1829232, 20.3174769, 'city', '1'),
('countries_albania_qarku_i_elbasanit_peqin', 'ChIJUWmaEKsQUBMRcmQ4FtfIgQI', 41.0470902, 19.7502384, 'city', '1'),
('countries_spain_valencia_cabanes', 'ChIJ2_97UoEFoBIR0D4i126vAgQ', 40.1247556, 0.0933686, 'city', '0'),
('countries_albania_qarku_i_fierit_fier', 'ChIJ8_GYv85SRRMRvOrtAxWijGE', 40.727504, 19.5627596, 'city', '1'),
('countries_spain_valencia_benimeli', 'ChIJI4Mfq9biYQ0RYNch126vAgQ', 38.838841, -0.0349866, 'city', '0'),
('countries_albania_qarku_i_fierit_klos', 'ChIJy15xNfK3WhMRkO78XUYU0kI', 40.5292153, 19.7517266, 'city', '1'),
('countries_spain_valencia_benimamet', 'ChIJEw11yHNFYA0RHCUGg0EjWHg', 39.5027783, -0.4198175, 'city', '0'),
('countries_albania_qarku_i_fierit_roskovec', 'ChIJ2blFbeauWhMRkc081KMcgk0', 40.7379408, 19.7041069, 'city', '1'),
('countries_spain_valencia_benimaclet', 'ChIJUSq9aadIYA0Rn4-LqL60jIY', 39.4871955, -0.3548312, 'city', '0'),
('countries_spain_valencia_benijofar', 'ChIJI7n97kSvYw0RANch126vAgQ', 38.0766987, -0.7390245, 'city', '0'),
('countries_albania_qarku_i_gjirokastres_tepelene', 'ChIJxV_YahnmWhMReEBdv8i4ER4', 40.2966632, 20.0181673, 'city', '1'),
('countries_albania_qarku_i_korces_bilisht', 'ChIJxZwOpICpUBMRjQQBl-uPaaY', 40.6252454, 20.9894099, 'city', '1'),
('countries_albania_qarku_i_korces_korce', 'ChIJ-4O5ZBIKWhMRRLnDZ0kPb9Q', 40.6140785, 20.7778071, 'city', '1'),
('countries_albania_qarku_i_korces_pogradec', 'ChIJrTRPLi2UUBMRKbtCzvfHHeg', 40.9015314, 20.6556289, 'city', '1'),
('countries_albania_qarku_i_kukesit_bajram_curri', 'ChIJRxT6gfpGUhMR_-75TBQQ_kg', 42.3581499, 20.0777218, 'city', '1'),
('countries_spain_valencia_benifaio', 'ChIJXV-3J36tYQ0R0IIj126vAgQ', 39.2886534, -0.4408037, 'city', '0'),
('countries_albania_qarku_i_kukesit_kukes', 'ChIJa0a-QfzRUxMR6XqoKZD71Jo', 42.0755845, 20.4259456, 'city', '1'),
('countries_albania_qarku_i_lezhes_kurbnesh', 'ChIJw8UC5CeRURMRIA57i_b1OlM', 41.7820601, 20.0881443, 'city', '1'),
('countries_spain_valencia_benidoleig', 'ChIJTQ01rBH9YQ0RwNYh126vAgQ', 38.7943901, -0.0233208, 'city', '0'),
('countries_spain_valencia_beniarjo', 'ChIJcTcIruPoYQ0RmtLaHecb4-Q', 38.93273, -0.1893072, 'city', '0'),
('countries_spain_valencia_bellreguard', 'ChIJHQwY_WHoYQ0RZ38TExefqoI', 38.9484314, -0.1612029, 'city', '0'),
('countries_albania_qarku_i_lezhes_rubik', 'ChIJRX8X0UPoURMRAkfF_KWU55I', 41.7683491, 19.7859556, 'city', '1'),
('countries_spain_valencia_ayora', 'ChIJe6xaZ3E3YQ0R0IEj126vAgQ', 39.0597915, -1.0574321, 'city', '0'),
('countries_albania_qarku_i_shkodres_koplik', 'ChIJo4veNq_7TRMRJUJTp3zaVa8', 42.2130591, 19.4437591, 'city', '1'),
('countries_spain_valencia_anna', NULL, 0, 0, 'city', '0'),
('countries_spain_valencia_alquerias_del_nino_perdido', 'ChIJSx96SdcFYA0RJHrt0j_HXUI', 39.8972253, -0.1147471, 'city', '0'),
('countries_spain_valencia_alginet', 'ChIJUUs3gY2tYQ0RAIEj126vAgQ', 39.2677367, -0.4785495, 'city', '0'),
('countries_spain_valencia_alfafar', 'ChIJ77TQZPtLYA0RcIAj126vAgQ', 39.4056288, -0.3583606, 'city', '0'),
('countries_albania_qarku_i_vlores_sarande', 'ChIJMVSsr_8UWxMREBmiCH5e1dY', 39.8592119, 20.0271001, 'city', '1'),
('countries_albania_qarku_i_vlores_vlore', 'ChIJlRjM6PEzRRMRhg4-8ZoJMQ0', 40.4660668, 19.491356, 'city', '1'),
('countries_spain_valencia_aldaia', 'ChIJTf6_A0BQYA0RbkDkBKJTrXo', 39.4595217, -0.4927134, 'city', '0'),
('countries_albania_tirana_kavaje', 'ChIJveMs6ezfTxMRQieF91NXkEc', 41.1844529, 19.5627596, 'city', '1'),
('countries_albania_tirana_tirana', 'ChIJ28X6cAQxUBMRIDdlEK-SAAQ', 41.3275459, 19.8186982, 'city', '1'),
('countries_algeria_adrar', 'ChIJHeBuc3Cf9Q0R6vtgjhF0JS8', 28.0174403, -0.2642497, 'region', '1'),
('countries_algeria_ain_defla', 'ChIJS508O2Q1hBIR3TuTlGnJetQ', 36.1585027, 2.0665197, 'region', '1'),
('countries_algeria_ain_temouchent', 'ChIJ7X5Xf7MjeQ0Rb6B_7rCYUsY', 35.2974176, -1.135302, 'region', '1'),
('countries_algeria_algiers', 'ChIJn2Xqd2myjxIRSW-jOC0QMUI', 36.753768, 3.0587561, 'region', '1'),
('countries_algeria_annaba', 'ChIJcXVOA7sH8BIRErdVsujc_Sg', 36.9142081, 7.7426673, 'region', '1'),
('countries_algeria_batna', 'ChIJn5Avv5UR9BIRwNPH7wb3Im4', 35.5634192, 6.1889996, 'region', '1'),
('countries_algeria_bechar', 'ChIJgZisYVBfhQ0Rr0mXItRvIJc', 31.6238098, -2.2162443, 'region', '1'),
('countries_algeria_bejaia', 'ChIJxYIgqKHM8hIRbgszEx60B3g', 36.7515258, 5.0556837, 'region', '1'),
('countries_algeria_biskra', 'ChIJ0cG1UdQJ9RIRkEK_ypuL7vw', 34.8449437, 5.7248567, 'region', '1'),
('countries_algeria_blida', 'ChIJ0UxahmYMjxIR_m1kc8D5_Mw', 36.4735715, 2.8323153, 'region', '1'),
('countries_algeria_bordj_bou_arreridj', 'ChIJ9_yu7zuRjBIRs2lN-_Ia9Cs', 36.0739925, 4.7630271, 'region', '1'),
('countries_algeria_bouira', 'ChIJt2pFkIovjBIRFPv_vOh6F-Q', 36.3691846, 3.9006194, 'region', '1'),
('countries_algeria_boumerdes', 'ChIJI1ueyNxojhIRE-sFlCcU6YQ', 36.7510697, 3.4788905, 'region', '1'),
('countries_algeria_chlef', 'ChIJI-yVJYAOhBIRPp4Eo_TMPTQ', 36.1579664, 1.3372823, 'region', '1'),
('countries_algeria_constantine', 'ChIJJ1Z4xBd38RIRGoAI_QezXwI', 36.3570052, 6.6390282, 'region', '1'),
('countries_algeria_djelfa', 'ChIJiSEEmoTPiRIRuvsnTXlALZM', 34.6703956, 3.2503761, 'region', '1'),
('countries_algeria_el_bayadh', 'ChIJB8iJy9COfhIRX0oGREtWwQo', 33.6854149, 1.0303543, 'region', '1'),
('countries_algeria_el_oued', 'ChIJWw3cJw4RWRIRlkTdrjps4Bg', 33.367811, 6.8516511, 'region', '1'),
('countries_algeria_el_tarf', 'ChIJJ3WtelLA-hIRLa_GOUuhu_M', 36.7558581, 8.2212979, 'region', '1'),
('countries_algeria_ghardaia', 'ChIJwyagNQUmZBIRBKoh0ofbssM', 32.4943741, 3.64446, 'region', '1'),
('countries_algeria_guelma', 'ChIJYT0U2Phd8BIRmdqm-m9BlsA', 36.4627444, 7.4330833, 'region', '1'),
('countries_algeria_illizi', 'ChIJUyJM5CjgMBIRIgEOsXABwC4', 26.4775863, 8.4776326, 'region', '1'),
('countries_algeria_jijel', 'ChIJQ4RskHtg8hIR3GdcWOQLL70', 36.8210144, 5.7634126, 'region', '1'),
('countries_algeria_khenchela', 'ChIJh6MQii0h9xIRznDHn4qmMXk', 35.4269404, 7.1460155, 'region', '1'),
('countries_algeria_laghouat', 'ChIJy9nuo0riYhIRwppaDfbzC6E', 33.8078341, 2.8628294, 'region', '1'),
('countries_algeria_mascara', 'ChIJGc14XqXagRIRrPDWOkDkqnA', 35.4020988, 0.1400257, 'region', '1'),
('countries_algeria_medea', 'ChIJI0Iip8JqjxIRPunth0R6ChU', 36.2637078, 2.7587857, 'region', '1'),
('countries_algeria_mila', 'ChIJg-I55zMt8hIRgUYloSh-Y00', 36.4519049, 6.2584338, 'region', '1'),
('countries_algeria_mostaganem', 'ChIJl5Tjij4CghIRsvpJqJN8M2k', 35.9311454, 0.0909414, 'region', '1'),
('countries_algeria_m_sila', 'ChIJmdWr8iB7ixIROZBV94ndTsw', 35.7186646, 4.5233423, 'region', '1'),
('countries_algeria_naama', 'ChIJbRLxZj6TgA0RdL9HdGpYEOM', 33.4350615, -0.9056623, 'region', '1'),
('countries_algeria_oran', 'ChIJfVMfhFSIfg0RDyn3Yjf2h0E', 35.6987388, -0.6349319, 'region', '1'),
('countries_algeria_ouargla', 'ChIJqbzEeIVrXRIRHafJ0oI-PAY', 31.9527411, 5.3335348, 'region', '1'),
('countries_algeria_oum_el_bouaghi', 'ChIJ_3xDyUbW8BIRQKOnZuLaET0', 35.7983092, 7.0068393, 'region', '1'),
('countries_algeria_relizane', 'ChIJqUieBOF5gRIRJit2keoc5Uo', 35.7450263, 0.5578837, 'region', '1'),
('countries_algeria_saida', 'ChIJVZDNYYgXgBIRxH-1HjN5nac', 34.8415207, 0.1456055, 'region', '1'),
('countries_algeria_setif', 'ChIJS_zKX5wV8xIR1dzK07vPY7A', 36.1897593, 5.4107984, 'region', '1'),
('countries_algeria_sidi_bel_abbes', 'ChIJc4_3tTAAfw0RKdzPmlELYCQ', 35.2105876, -0.629983, 'region', '1'),
('countries_algeria_skikda', 'ChIJTdsyJJzF8RIR12W-Bn_8BpQ', 36.8662658, 6.9062556, 'region', '1'),
('countries_algeria_souk_ahras', 'ChIJY4G1xTVj-hIRjWtH-xdTEYc', 36.2801062, 7.9384033, 'region', '1'),
('countries_algeria_tamanrasset', 'ChIJ9UqaAyBvIBIR5JPSxd7LJNU', 22.7902972, 5.5193268, 'region', '1'),
('countries_algeria_tebessa', 'ChIJ3yKzucXs-RIRdnFSH4tKDOc', 35.4010797, 8.1172958, 'region', '1'),
('countries_algeria_tiaret', 'ChIJX7qL08_RhhIRUGlGNScagJE', 35.3708689, 1.3217852, 'region', '1'),
('countries_algeria_tindouf', 'ChIJ-9UtpEP1yA0Rl_R5PxN_8Hc', 27.6719159, -8.1398003, 'region', '1'),
('countries_algeria_tipaza', 'ChIJfwbeYfF_hRIR2ci0CT4o7-A', 36.5906719, 2.4433723, 'region', '1'),
('countries_algeria_tissemsilt', 'ChIJG1qDBNVihhIRo1Pb00tZjB4', 35.8174139, 1.5983959, 'region', '1'),
('countries_algeria_tizi_ouzou', 'ChIJCwn9v9_HjRIRBAgg3CCazSc', 36.713548, 4.0473075, 'region', '1'),
('countries_algeria_tlemcen', 'ChIJWe-09rjJeA0RgAf63de5dgU', 34.8828864, -1.3166815, 'region', '1'),
('countries_algeria_adrar_adrar', 'ChIJHeBuc3Cf9Q0R6vtgjhF0JS8', 28.0174403, -0.2642497, 'city', '1'),
('countries_algeria_adrar_aoulef', 'ChIJ3ZOak-dPCRIR9VTkWaXzYU4', 26.9723264, 1.0810031, 'city', '1'),
('countries_algeria_adrar_badriane', 'ChIJR2FlC5wLdRIRIlyXuqKiCIE', 29.3391241, 0.3395407, 'city', '1'),
('countries_algeria_adrar_reggane', 'ChIJi52vY0PDCRIRKnbgQFLmuu4', 26.7242654, 0.1657289, 'city', '1'),
('countries_algeria_adrar_timimoun', 'ChIJf6eEXiJydRIRPkazmQwltCk', 29.2616911, 0.2415964, 'city', '1'),
('countries_algeria_ain_defla_ain_defla', 'ChIJr-yYWsC3hRIRJMI7Sgv3LOM', 36.2509429, 1.9393815, 'city', '1'),
('countries_spain_valencia_alcasser', 'ChIJhZEhp_RNYA0RAIAj126vAgQ', 39.3768239, -0.44552, 'city', '0'),
('countries_algeria_ain_defla_djelida', 'ChIJMfWJK97AhRIRinL95JmQxog', 36.2038415, 2.0800579, 'city', '1'),
('countries_algeria_ain_defla_djendel', 'ChIJF_A9KOj0hRIRZucleYBUmOE', 36.2205342, 2.4149379, 'city', '1'),
('countries_algeria_ain_defla_el_abadia', 'ChIJ23XaiQ5IhBIRLYRf2NjmD1s', 36.2720385, 1.6853912, 'city', '1'),
('countries_algeria_ain_defla_el_attaf', 'ChIJ7UKzQiQ4hBIR2hBrWhiPZnU', 36.2258291, 1.6737113, 'city', '1'),
('countries_algeria_ain_defla_hammam_righa', 'ChIJm33wvtyIhRIRLXOZnw3IwMM', 36.3815327, 2.4000422, 'city', '1'),
('countries_algeria_ain_defla_khemis_miliana', 'ChIJ2yGR0qmUhRIR8YCXkYgzSYo', 36.2609828, 2.2343578, 'city', '1'),
('countries_algeria_ain_defla_miliana', 'ChIJ98QgKZmShRIR2I6xMef_AbU', 36.3080267, 2.228407, 'city', '1'),
('countries_algeria_ain_defla_rouina', 'ChIJ6w8w1WU1hBIRNrXXdqHCr4A', 36.2436971, 1.8076477, 'city', '1'),
('countries_spain_valencia_albalat_de_la_ribera', 'ChIJ_972ByOxYQ0RbL7LtfBHf8s', 39.2213766, -0.3701276, 'city', '0'),
('countries_algeria_ain_temouchent_ain_temouchent', 'ChIJN3n2_fnTfg0RARG0YJF1ysY', 35.2992698, -1.1392792, 'city', '1'),
('countries_spain_valencia_alaquas', 'ChIJ5YuPczBQYA0RjI37P6S33gA', 39.4518434, -0.4714694, 'city', '0'),
('countries_algeria_ain_temouchent_chaabat_el_leham', 'ChIJTRdmTQTRfg0RoFdSXCRlhvo', 35.3371242, -1.0983767, 'city', '1'),
('countries_algeria_ain_temouchent_el_amria', 'ChIJLf2MQgnHfg0RJpZBMT1C_jk', 35.5239104, -1.0166296, 'city', '1'),
('countries_algeria_ain_temouchent_el_malah', 'ChIJtQI1ktTPfg0RmRb1BersG9w', 35.3870327, -1.0976722, 'city', '1'),
('countries_algeria_ain_temouchent_hammam_bou_hadjar', 'ChIJmYjZgbvcfg0Rv9mEJ7G91Jk', 35.3789975, -0.9709937, 'city', '1'),
('countries_algeria_ain_temouchent_terga', 'ChIJTWPznqXNfg0RACwJwRIaD_8', 35.4184778, -1.1775221, 'city', '1'),
('countries_spain_principality_of_asturias_villallana', 'ChIJSfNHGlf3Ng0REbWpv7T3ZNY', 43.1870743, -5.8090159, 'city', '0'),
('countries_algeria_algiers_alger_plage', 'ChIJF_DHrZ9PjhIRMp3V6ObDJuk', 36.7772433, 3.2413365, 'city', '1'),
('countries_spain_principality_of_asturias_vigo', 'ChIJk8GyYRRiLw0Rn9RLF60dRHs', 42.2405989, -8.7207268, 'city', '0'),
('countries_algeria_algiers_bab_ezzouar', 'ChIJpdsFooxRjhIRpv8F-FqREgY', 36.7220182, 3.1856806, 'city', '1'),
('countries_spain_principality_of_asturias_tuilla', 'ChIJ_UkCvAteNg0Rio9j02oMqDY', 43.3285141, -5.6494357, 'city', '0'),
('countries_algeria_algiers_birkhadem', 'ChIJ_0NgV6StjxIR0Z0TUK5S--Q', 36.7160675, 3.0496695, 'city', '1'),
('countries_spain_principality_of_asturias_ribadesella', 'ChIJW3THXXYeNg0RkAXLc4L1BAQ', 43.463085, -5.0561012, 'city', '0'),
('countries_algeria_algiers_bourouba', 'ChIJh4fQ-8FSjhIRJ0XcqjEP9qM', 36.7138317, 3.1125625, 'city', '1'),
('countries_spain_principality_of_asturias_navia', 'ChIJidSCC0ReMQ0R5yG15XQqIc8', 43.5381816, -6.6851982, 'city', '0'),
('countries_algeria_algiers_el_harrach', 'ChIJ-6Mmx0FSjhIRc2fkwadFzFE', 36.7209669, 3.1376625, 'city', '1'),
('countries_algeria_algiers_el_madania', 'ChIJIXK5V32tjxIROq-jsSj5qGo', 36.7419724, 3.0666584, 'city', '1'),
('countries_algeria_algiers_hussein_dey', 'ChIJhUHNiqmyjxIRplXssRyiq_k', 36.7406167, 3.0961917, 'city', '1'),
('countries_algeria_algiers_kouba', 'ChIJtSiLxEGtjxIR_lV99q0uzoU', 36.7260163, 3.0826673, 'city', '1'),
('countries_algeria_algiers_oued_smar', 'ChIJJwbNI3dUjhIRpHP4hqAFnkI', 36.7071277, 3.1650558, 'city', '1'),
('countries_algeria_algiers_rouiba', 'ChIJexsAPTRFjhIR6lhq8Xeykes', 36.7358928, 3.2779879, 'city', '1'),
('countries_spain_principality_of_asturias_nava', 'ChIJo0Jmng5CNg0RkATLc4L1BAQ', 43.3710512, -5.4987565, 'city', '0'),
('countries_algeria_annaba_annaba', 'ChIJcXVOA7sH8BIRErdVsujc_Sg', 36.9142081, 7.7426673, 'city', '1'),
('countries_algeria_annaba_berrahal', 'ChIJD-E7HjoW8BIRjKvPYKERh3A', 36.8346382, 7.4559518, 'city', '1'),
('countries_algeria_annaba_drean', 'ChIJt_keASN18BIRH7mUKHUDwjU', 36.6865627, 7.7208062, 'city', '1'),
('countries_algeria_annaba_el_hadjar', 'ChIJfWHM45oJ8BIRz8oVp6MRMaA', 36.8074707, 7.7389134, 'city', '1'),
('countries_spain_principality_of_asturias_mieres', 'ChIJtTm4tTr2Ng0RYATLc4L1BAQ', 43.2497264, -5.7785282, 'city', '0'),
('countries_spain_principality_of_asturias_manjoya', 'ChIJgV_eltPyNg0RE5pzKa2V1XY', 43.3401961, -5.8521694, 'city', '1'),
('countries_spain_principality_of_asturias_llanera', 'ChIJ_eshv66PNg0RQATLc4L1BAQ', 43.4653488, -5.9198387, 'city', '0'),
('countries_algeria_batna_arris', 'ChIJechTxkYm9BIR2f01woYwRN0', 35.2582527, 6.3458058, 'city', '1'),
('countries_algeria_batna_barika', 'ChIJG1Ywe7nB9BIRpiasSFVW6J4', 35.3877747, 5.3703633, 'city', '1'),
('countries_spain_principality_of_asturias_lieres', 'ChIJr94oDdFnNg0RwDnqAx2HxFc', 43.380847, -5.5690953, 'city', '0'),
('countries_algeria_batna_chemora', 'ChIJ94I5LJOz9hIRGBL0QpYfT8I', 35.6685281, 6.6429744, 'city', '1'),
('countries_algeria_batna_chir', 'ChIJcZHGcHE39BIRENPJHugfAf8', 35.2273569, 6.1321997, 'city', '1'),
('countries_algeria_batna_merouana', 'ChIJQT2mfGVw9BIR_niuUwkrE1s', 35.6299464, 5.9118713, 'city', '1'),
('countries_algeria_batna_m_cil', 'ChIJD7ebCgKH8xIRSNwS0UHW0_8', 35.8288109, 5.8802357, 'city', '1'),
('countries_algeria_batna_n_gaous', 'ChIJa1JWxl6O9BIRfTGvoYYei8o', 35.5472882, 5.6296201, 'city', '1'),
('countries_algeria_batna_seriana', 'ChIJd9_8hRkJ9BIRKX3Z76mrXZQ', 35.6977699, 6.1879742, 'city', '1'),
('countries_spain_principality_of_asturias_la_felguera', 'ChIJT_EQ2KhfNg0RUtbeYNa_5Dc', 43.307823, -5.6958195, 'city', '0'),
('countries_spain_principality_of_asturias_la_carrera', 'ChIJmwy_8FClPw0Ro3Rh9nIaCpE', 40.3471658, -5.554509, 'city', '1'),
('countries_algeria_bechar_bechar', 'ChIJgZisYVBfhQ0Rr0mXItRvIJc', 31.6238098, -2.2162443, 'city', '1'),
('countries_spain_principality_of_asturias_las_arenas_de_cabrales', 'ChIJsdrtt63GSQ0Rx0-9DUPTRi0', 43.3025538, -4.8159918, 'city', '0'),
('countries_algeria_bechar_igli', 'ChIJ7XfQkGkXjg0Rv7KZv3ilwOM', 30.4517889, -2.2906605, 'city', '1'),
('countries_spain_principality_of_asturias_grandas_de_salime', 'ChIJd3AuSJARMQ0RwAPLc4L1BAQ', 43.176939, -6.9423844, 'city', '0'),
('countries_algeria_bechar_taghit', 'ChIJAaRwF_yyjw0RHTSm-tCfT88', 30.8792156, -2.0103649, 'city', '1'),
('countries_algeria_bejaia_akbou', 'ChIJISD0Eez8jBIRxQzFP-cUDS8', 36.4556403, 4.5365087, 'city', '1'),
('countries_algeria_bejaia_amalou', 'ChIJ_6pIXoHhjBIRi_YJD0aifUo', 36.4779273, 4.6318759, 'city', '1'),
('countries_algeria_bejaia_amizour', 'ChIJz9mp71MujRIRVNy9pZcYo24', 36.643932, 4.9036584, 'city', '1'),
('countries_algeria_bejaia_barbacha', 'ChIJmY2NLm0pjRIRFPAxHSJmSHc', 36.570766, 4.9735173, 'city', '1'),
('countries_algeria_bejaia_bejaia', 'ChIJxYIgqKHM8hIRbgszEx60B3g', 36.7515258, 5.0556837, 'city', '1'),
('countries_algeria_bejaia_boukhralfa', 'ChIJOUA8230ljRIRMj4pXevxySE', 36.6453687, 4.8929169, 'city', '1'),
('countries_algeria_bejaia_darguinah', 'ChIJa3IjPa7e8hIRVEmoGSp9OxE', 36.5642523, 5.3061543, 'city', '1'),
('countries_algeria_bejaia_el_kseur', 'ChIJOQJxYwU7jRIR6I7XISa7b_o', 36.6775376, 4.8492903, 'city', '1'),
('countries_algeria_bejaia_feraoun', 'ChIJ3ZZRSjgmjRIREWxbwC5QPXE', 36.5583932, 4.8603313, 'city', '1'),
('countries_spain_principality_of_asturias_fuejo_tineo', 'ChIJm0uodOtKMQ0Rlo0SS9GbTYs', 43.3244001, -6.4333634, 'city', '0'),
('countries_algeria_bejaia_kherrata', 'ChIJZa8f43gn8xIR3eQolso2qRs', 36.4936399, 5.2770714, 'city', '1'),
('countries_algeria_bejaia_oued_ghir', 'ChIJK-k0vS4yjRIRvZhSvNrF4Fs', 36.7055013, 4.9790384, 'city', '1'),
('countries_algeria_bejaia_seddouk', 'ChIJ11xxh00ejRIRhhu6l0QlXUg', 36.5467873, 4.6867022, 'city', '1'),
('countries_spain_principality_of_asturias_el_franco', 'ChIJqwyIkABkMQ0RgAPLc4L1BAQ', 43.5065183, -6.8376549, 'city', '0'),
('countries_algeria_bejaia_tifra', 'ChIJTflobUcYjRIRMA-UfvDyZTo', 36.6667252, 4.6977801, 'city', '1'),
('countries_algeria_biskra_biskra', 'ChIJ0cG1UdQJ9RIRkEK_ypuL7vw', 34.8449437, 5.7248567, 'city', '1'),
('countries_algeria_biskra_foughala', 'ChIJjdtii85A9RIRYtTbWicvYzA', 34.728734, 5.3293513, 'city', '1'),
('countries_algeria_biskra_lichana', 'ChIJHYiaXd9q9RIRIcBqCGGJBQ4', 34.7247292, 5.4325533, 'city', '1'),
('countries_algeria_biskra_ouled_djellal', 'ChIJWdRhSTNV9RIR8Y9I0LWb7Yw', 34.4294289, 5.0681159, 'city', '1'),
('countries_algeria_biskra_sidi_khaled', 'ChIJ8dqvAukBYBIRQAkg_BqCmWg', 34.397074, 4.9970929, 'city', '1'),
('countries_algeria_biskra_sidi_okba', 'ChIJ400HVC299RIRsDW6j7unKRw', 34.7505874, 5.9084077, 'city', '1'),
('countries_algeria_biskra_tolga', 'ChIJPYcBOAVA9RIRRCgKkdKIqPs', 34.9346106, 5.1305127, 'city', '1'),
('countries_spain_principality_of_asturias_cue', 'ChIJLV1KSM7qSQ0R-cLcgt8-FUg', 43.4135299, -4.7350163, 'city', '0'),
('countries_spain_principality_of_asturias_cudillero', 'ChIJ4T9Hw1GhNg0Rf6I0Hz6_fmc', 43.5600016, -6.148421, 'city', '1'),
('countries_algeria_blida_blida', 'ChIJ0UxahmYMjxIR_m1kc8D5_Mw', 36.4735715, 2.8323153, 'city', '1'),
('countries_algeria_blida_boufarik', 'ChIJA3I_TicIjxIRLlAN7L3MdRs', 36.5832413, 2.9121256, 'city', '1'),
('countries_algeria_blida_bougara', 'ChIJV-P6oeD_jhIRlXfx_t6rMus', 36.5419269, 3.0828449, 'city', '1'),
('countries_algeria_blida_bouinan', 'ChIJU4EQqh0HjxIRt4s8XJz8qV8', 36.5324276, 2.9939684, 'city', '1'),
('countries_spain_principality_of_asturias_corvera_de_asturias', 'ChIJiQszbc-ENg0RiHG33pTjCBQ', 43.5149529, -5.8881542, 'city', '0'),
('countries_algeria_blida_chiffa', 'ChIJy2---KdzjxIRyGKMxEPJb_I', 36.4624901, 2.7410554, 'city', '1'),
('countries_spain_principality_of_asturias_cerredo', 'ChIJ8xPLXCnUMA0RFzy629Hjvg0', 42.9464908, -6.4893146, 'city', '0'),
('countries_algeria_blida_meftah', 'ChIJ403T9RtXjhIRYDctae5LCpM', 36.6223869, 3.2261299, 'city', '1'),
('countries_spain_principality_of_asturias_cangas_de_onis', 'ChIJd4wYSeshNg0Rd93btnVnHMw', 43.3506251, -5.1310133, 'city', '1'),
('countries_algeria_blida_sidi_moussa', 'ChIJA6Z0wdRUjhIRh7-PruFHd3U', 36.6165787, 3.1032114, 'city', '1'),
('countries_algeria_blida_souma', 'ChIJeeiYeOQIjxIRpFuSOlGqCzY', 36.5188388, 2.9077851, 'city', '1'),
('countries_algeria_bordj_bou_arreridj_bordj_bou_arreridj', 'ChIJ9_yu7zuRjBIRs2lN-_Ia9Cs', 36.0739925, 4.7630271, 'city', '1'),
('countries_spain_principality_of_asturias_cangas_del_narcea', 'ChIJfwipa2EwMQ0RnOY2tItPXSk', 43.1773837, -6.5498404, 'city', '1'),
('countries_algeria_bordj_bou_arreridj_bordj_zemoura', 'ChIJtdrPcjPEjBIRuIawCPrI_yY', 36.2691651, 4.8465638, 'city', '1'),
('countries_algeria_bordj_bou_arreridj_mansourah', 'ChIJcSN2fkKJjBIRbwW22Ky9P8Q', 36.0857963, 4.4573676, 'city', '1'),
('countries_algeria_bordj_bou_arreridj_medjana', 'ChIJmVO1q_WUjBIRwJPaj11NjR0', 36.1319482, 4.6737497, 'city', '1'),
('countries_spain_principality_of_asturias_campomanes', 'ChIJYQrdFv_7Ng0R1E3BtZvQ1FI', 43.1061282, -5.8179718, 'city', '1'),
('countries_spain_principality_of_asturias_barcia', 'ChIJh1-bMsB0MQ0Rj9KeMQJuntQ', 43.286761, -7.0313622, 'city', '1'),
('countries_spain_principality_of_asturias_allande', 'ChIJ7RAlEuk-MQ0RIALLc4L1BAQ', 43.2488376, -6.7065914, 'city', '0'),
('countries_algeria_bouira_aomar', 'ChIJ71Hou1EqjBIRWQJTfekhk6E', 36.4917719, 3.7684225, 'city', '1'),
('countries_algeria_bouira_bechloul', 'ChIJC83yIWNHjBIREUBi1PtoEe4', 36.3121044, 4.0749862, 'city', '1'),
('countries_algeria_bouira_chorfa', 'ChIJSSF1Y1ZXjBIRs3R7WZckk3I', 36.3605515, 4.3290338, 'city', '1'),
('countries_algeria_bouira_djebahia', 'ChIJH86zEBEqjBIR-qr25yN2ZcE', 36.4773442, 3.7585198, 'city', '1'),
('countries_spain_navarre_zuniga', 'ChIJo7lImAMQUA0R4PvOCGWMAQQ', 42.6895341, -2.2975183, 'city', '0'),
('countries_algeria_bouira_el_adjiba', 'ChIJeWZqPH9GjBIRBgWFSZEqx0A', 36.3283648, 4.1586734, 'city', '1'),
('countries_algeria_bouira_el_hachimia', 'ChIJIZi1JNIjjBIRcAtm0sThGAU', 36.2194454, 3.8157329, 'city', '1'),
('countries_spain_navarre_viana', 'ChIJ9TmExtupWg0RAPvOCGWMAQQ', 42.5070947, -2.3616203, 'city', '0'),
('countries_algeria_bouira_kadiria', 'ChIJ5fO8F5WAjhIRDFBGQhCa3n8', 36.5340081, 3.683037, 'city', '1'),
('countries_algeria_bouira_lakhdaria', 'ChIJ28tAZrpijhIRubR3CwrFoJk', 36.5660649, 3.5960213, 'city', '1'),
('countries_algeria_bouira_m_chedallah', 'ChIJGyKVHnxQjBIRKtmRIMAiWLc', 36.364496, 4.2696806, 'city', '1'),
('countries_algeria_bouira_ouled_sidi_brahim', 'ChIJGde1nfVejBIRhPqyJCMVj6g', 36.2289482, 4.335829, 'city', '1'),
('countries_spain_navarre_puente_la_reina_gares', 'ChIJTXK7EpWHUA0R9ofn71VXnWg', 42.6723037, -1.8135943, 'city', '0'),
('countries_spain_navarre_peralta_azkoien', 'ChIJ30TuS1hiWg0RzkAtRqT1N9c', 42.3389757, -1.7990957, 'city', '0'),
('countries_algeria_boumerdes_baghlia', 'ChIJz3G7AHLcjRIRKXfv9uyByOU', 36.8180081, 3.8592419, 'city', '1'),
('countries_algeria_boumerdes_beni_amrane', 'ChIJnx2rrjl7jhIROWU7BCxaj8I', 36.6687171, 3.5900012, 'city', '1'),
('countries_algeria_boumerdes_bordj_menaiel', 'ChIJl9f8dZV3jhIRVitqPArn3ko', 36.7450878, 3.7192567, 'city', '1'),
('countries_algeria_boumerdes_boudouaou', 'ChIJLx7eg0tdjhIRJmhC_7kVORU', 36.7204759, 3.396615, 'city', '1'),
('countries_spain_navarre_huarte_uharte', 'ChIJgV4A_piUUA0RnrHkrgGVUnY', 42.8297005, -1.5903842, 'city', '0'),
('countries_algeria_boumerdes_chabet_el_ameur', 'ChIJ_bz07tJ-jhIRVx0fkhcezKM', 36.6371827, 3.6953685, 'city', '1'),
('countries_spain_navarre_estella_lizarra', 'ChIJpTFG9sVxUA0RmxoTifbTHAQ', 42.6720856, -2.0324524, 'city', '0'),
('countries_algeria_boumerdes_dellys', 'ChIJsUoUL8TnjRIR0z9M7swzjag', 36.9126574, 3.9124569, 'city', '1'),
('countries_spain_navarre_atarrabia', 'ChIJSSYw_2iTUA0RUAYU5JJSJxs', 42.8314377, -1.6123283, 'city', '0'),
('countries_algeria_boumerdes_makouda', 'ChIJGyQlg1bHjRIRKKZy3C_dYt4', 36.7914525, 4.0633201, 'city', '1'),
('countries_algeria_boumerdes_naciria', 'ChIJ00MQTzvajRIRdTHXmkUrP4c', 36.7456244, 3.8310805, 'city', '1'),
('countries_spain_navarre_arbizu', 'ChIJz1DJmI9DUA0RbmCFpTQi7Og', 42.9381416, -2.0420152, 'city', '0'),
('countries_spain_navarre_alsasua_altsasu', 'ChIJd9pEDhQ_UA0RXPr7BMRtchc', 42.8956348, -2.1708139, 'city', '0'),
('countries_spain_murcia_valladolises', 'ChIJCQU72SV7Yw0RL1SKYbhpBto', 37.8159122, -1.102033, 'city', '0'),
('countries_spain_murcia_totana', 'ChIJqSHmtbSSZA0RAOsi126vAgQ', 37.778001, -1.5015009, 'city', '0'),
('countries_spain_murcia_puerto_lumbreras', 'ChIJv4hs0LXYZA0RoOoi126vAgQ', 37.5609105, -1.8123324, 'city', '0'),
('countries_algeria_boumerdes_tizi_gheniff', 'ChIJK9o_xwPVjRIRQwqCZifqfxA', 36.5883144, 3.7737151, 'city', '1'),
('countries_algeria_boumerdes_zemmouri', 'ChIJAf9LzcBxjhIRm_C_jP09E3o', 36.7873788, 3.6033564, 'city', '1'),
('countries_spain_murcia_mula', 'ChIJySR6NkReZA0RYOoi126vAgQ', 38.0397022, -1.4920384, 'city', '0'),
('countries_spain_murcia_mazarron', 'ChIJ-dDw606iZA0Rk-U--GF6aos', 37.5958308, -1.3147688, 'city', '0'),
('countries_spain_murcia_la_union', 'ChIJZz2-Qr4_Yw0RIOsi126vAgQ', 37.6087645, -0.8818151, 'city', '0'),
('countries_algeria_chlef_ech_chettia', 'ChIJk6FdhbkLhBIRlSo5tdQ42y4', 36.1944323, 1.2568799, 'city', '1'),
('countries_algeria_chlef_el_karimia', 'ChIJaZSKghs9hBIRes0xwoNUKwo', 36.111108, 1.5535633, 'city', '1'),
('countries_algeria_chlef_oued_sly', 'ChIJ1bYZ4-j3gxIRGu9rQQi3i2U', 36.0994743, 1.2006905, 'city', '1'),
('countries_algeria_chlef_ouled_fares', 'ChIJrULiZOgKhBIRXVmQPpOdEdA', 36.2309293, 1.2341846, 'city', '1'),
('countries_algeria_chlef_oum_drou', 'ChIJ7dyLkEMShBIRhFYg9lBF2Rs', 36.1977011, 1.3903197, 'city', '1'),
('countries_algeria_chlef_sidi_akkacha', 'ChIJf4wgJTd6hBIRGbA6uIuh1bw', 36.4625212, 1.3020848, 'city', '1'),
('countries_algeria_chlef_sobha', 'ChIJYRZ6iezwgxIRxdsxVEhOKfU', 36.1173742, 1.0490374, 'city', '1'),
('countries_algeria_chlef_taougrite', 'ChIJm9ZvVrjqgxIRaoT65XAmE9E', 36.2643544, 0.9127327, 'city', '1'),
('countries_spain_murcia_la_manga_del_mar_menor', 'ChIJAY9epI4ZYw0RIahXLgnG-GI', 37.6311518, -0.7200237, 'city', '0'),
('countries_algeria_constantine_ain_smara', 'ChIJy4SEbFF78RIRAf6qedgn2Dc', 36.2803396, 6.5176259, 'city', '1'),
('countries_algeria_constantine_constantine', 'ChIJJ1Z4xBd38RIRGoAI_QezXwI', 36.3570052, 6.6390282, 'city', '1'),
('countries_algeria_constantine_didouche_mourad', 'ChIJ44a_5ryd8RIREymbSIre52o', 36.4476539, 6.6364036, 'city', '1'),
('countries_algeria_constantine_el_kantara', 'ChIJGwL9URx38RIR--emFxtevJk', 36.3689979, 6.6184296, 'city', '1'),
('countries_algeria_constantine_el_khroub', 'ChIJfbkfQ2Jy8RIRxrfcydkvh40', 36.2593314, 6.7014537, 'city', '1'),
('countries_algeria_constantine_el_milia', 'ChIJUcrKo_Ai8hIR38KltreklAA', 36.7531205, 6.2676726, 'city', '1'),
('countries_algeria_constantine_hamma_bouziane', 'ChIJZ1iJk-138RIRyOoMMeSUHbM', 36.4220962, 6.5988893, 'city', '1'),
('countries_spain_murcia_fortuna', 'ChIJNyTCQ7uOYw0R0Oki126vAgQ', 38.2054404, -1.1544963, 'city', '0'),
('countries_spain_murcia_cabo_de_palos', 'ChIJJVYVN3EiYw0RL7aZ7ivDEU8', 37.6299139, -0.7045921, 'city', '1'),
('countries_spain_murcia_blanca', 'ChIJO8HBsNRvZA0RwCcHc5kwUYU', 38.2144941, -1.2987349, 'city', '0'),
('countries_algeria_djelfa_birine', 'ChIJ3000w30kiRIRyY_89OEknvc', 35.6356279, 3.2240322, 'city', '1'),
('countries_algeria_djelfa_charef', 'ChIJK4WfDvMiiBIRMygO3vYJL6E', 34.6194743, 2.8076182, 'city', '1'),
('countries_algeria_djelfa_dar_chioukh', 'ChIJ570fCx2UiRIRqGlMDAtWh9w', 34.8972043, 3.4893977, 'city', '1'),
('countries_algeria_djelfa_djelfa', 'ChIJiSEEmoTPiRIRuvsnTXlALZM', 34.6703956, 3.2503761, 'city', '1'),
('countries_algeria_djelfa_el_idrissia', 'ChIJ23rhMi6qYhIRTuiLVnjMGF4', 34.4531021, 2.5307193, 'city', '1'),
('countries_algeria_djelfa_hassi_bahbah', 'ChIJEQptcuZTiBIR1NcysxCY5Xw', 35.0762544, 3.0267229, 'city', '1'),
('countries_algeria_djelfa_messaad', 'ChIJw2HIUSgUYhIR5vg0w6xMb0o', 34.1540623, 3.4922857, 'city', '1'),
('countries_spain_murcia_benizar', 'ChIJQ2ZwKY-3ZQ0RvptaHePsfMA', 38.2725557, -1.9838166, 'city', '0'),
('countries_algeria_el_bayadh_el_abiodh_sidi_cheikh', 'ChIJs-P9LuLZeBIRZQb-O5vbhA4', 32.8970651, 0.5457605, 'city', '1'),
('countries_algeria_el_bayadh_el_bayadh', 'ChIJB8iJy9COfhIRX0oGREtWwQo', 33.6854149, 1.0303543, 'city', '1'),
('countries_spain_murcia_alhama_de_murcia', 'ChIJswYPBzuOZA0REOki126vAgQ', 37.8218878, -1.3855161, 'city', '0'),
('countries_algeria_el_oued_casablanca', 'ChIJV9rBO5sWWRIR_jwytP-pixc', 33.3492202, 6.8038678, 'city', '1'),
('countries_algeria_el_oued_debila', 'ChIJY08XmWMDWRIRwONPQtlsgpo', 33.5058203, 6.9378981, 'city', '1'),
('countries_spain_murcia_aguilas', 'ChIJLWImThDGZA0RwOgi126vAgQ', 37.4119365, -1.5826055, 'city', '0'),
('countries_algeria_el_oued_el_oued', 'ChIJWw3cJw4RWRIRlkTdrjps4Bg', 33.367811, 6.8516511, 'city', '1'),
('countries_algeria_el_oued_guemar', 'ChIJBVQDVxsZWRIRNO2aqnLnQ7c', 33.4882993, 6.7966739, 'city', '1'),
('countries_spain_madrid_villa_de_vallecas', 'ChIJtQY2moskQg0RCavOgXFhARg', 40.3669555, -3.606064, 'city', '0'),
('countries_algeria_el_oued_kouinine', 'ChIJD_jI_DkXWRIRYQJ8EjB3OB0', 33.4033559, 6.8258449, 'city', '1'),
('countries_algeria_el_oued_reguiba', 'ChIJeTtGg60hWRIRWA_lq16VYj8', 33.5629976, 6.7128105, 'city', '1'),
('countries_algeria_el_oued_robbah', 'ChIJ2RVbQYUSWRIRzAmz2dWOEFc', 33.2912663, 6.9084817, 'city', '1'),
('countries_spain_madrid_villaverde', 'ChIJMazLZcUmQg0RpyoXGDkHkVg', 40.3469109, -3.7107845, 'city', '0'),
('countries_algeria_el_tarf_besbes', 'ChIJzdGzBN6h-hIRgAfzNH9ypfs', 36.7020841, 7.8464395, 'city', '1'),
('countries_algeria_el_tarf_bouteldja', 'ChIJw-WodevG-hIRVGSyjw8d5S8', 36.789473, 8.1978485, 'city', '1'),
('countries_algeria_el_tarf_el_kala', 'ChIJt8W694fW-hIRAtOTBDK_LnY', 36.8856754, 8.4408187, 'city', '1'),
('countries_algeria_el_tarf_el_tarf', 'ChIJG8lRX07b-hIR8P1bD3f9nxk', 36.7576678, 8.3076343, 'city', '1'),
('countries_algeria_ghardaia_berriane', 'ChIJ_16h_9qnZhIRyRwyIUf39Ws', 32.825651, 3.7639061, 'city', '1'),
('countries_spain_madrid_villanueva_del_pardillo', 'ChIJl4CUL3ScQQ0Rjm39bSrDSR8', 40.4953157, -3.9776389, 'city', '0'),
('countries_spain_madrid_vicalvaro', 'ChIJcQoFFGklQg0RsUsAvPRAAyY', 40.3940279, -3.6028761, 'city', '0'),
('countries_spain_madrid_usera', 'ChIJxWdQblMmQg0R9dOVh18-LZU', 40.3825927, -3.7098748, 'city', '0'),
('countries_algeria_guelma_belkheir', 'ChIJK9GCx9Rg8BIRxRtq_zFmqVQ', 36.4624365, 7.4768384, 'city', '1'),
('countries_algeria_guelma_bouchegouf', 'ChIJtysMJhd58BIRoE-b4Hd1drg', 36.4717047, 7.7276038, 'city', '1'),
('countries_algeria_guelma_guelma', 'ChIJYT0U2Phd8BIRmdqm-m9BlsA', 36.4627444, 7.4330833, 'city', '1'),
('countries_algeria_guelma_heliopolis', 'ChIJ1YXCUYBd8BIRYKCC6QXcqgg', 36.5083803, 7.4361944, 'city', '1'),
('countries_spain_madrid_san_fernando_de_henares', 'ChIJt15AfI8wQg0R84iu5FFdtG4', 40.4290529, -3.5104537, 'city', '0'),
('countries_algeria_guelma_oued_zenati', 'ChIJfbVN8aT-8BIRhH2dWF_Y_Kc', 36.3100347, 7.1657362, 'city', '1'),
('countries_algeria_guelma_roknia', 'ChIJ438t3DlQ8BIRaqT2T9znCgk', 36.5461752, 7.2347252, 'city', '1'),
('countries_algeria_guelma_tamlouka', 'ChIJoUh7jrXj8BIRZa9F18qwPeI', 36.1579809, 7.1405698, 'city', '1'),
('countries_spain_madrid_rascafria', 'ChIJcW2XNXBdQQ0RJpKk3QmlJKA', 40.8732261, -3.8858955, 'city', '0'),
('countries_spain_madrid_pozuelo_de_alarcon', 'ChIJVw4UKQ2GQQ0RAN5MvvNAAwQ', 40.4440627, -3.8058517, 'city', '0'),
('countries_algeria_illizi_bordj_omar_driss', 'ChIJbbfO3aLqOBIRUOxCgV4ZmLM', 28.1449927, 6.8236371, 'city', '1'),
('countries_algeria_illizi_djanet', 'ChIJ9apwJ1k0LBIRQPr_tBk_pHQ', 24.554151, 9.485429, 'city', '1'),
('countries_spain_madrid_parla', 'ChIJ7QAtmzf1QQ0RiVi1r91ZoEY', 40.2373062, -3.7739869, 'city', '0'),
('countries_spain_madrid_navalcarnero', 'ChIJk8q0OF-UQQ0RAN1MvvNAAwQ', 40.2855681, -4.016639, 'city', '0'),
('countries_spain_madrid_fuenlabrada', 'ChIJj3MxWAaLQQ0RMmM-U3u0VTQ', 40.2774625, -3.7943157, 'city', '0'),
('countries_spain_madrid_el_escorial', 'ChIJ496uwz8KQQ0RcCkvQjorfQc', 40.592573, -4.100217, 'city', '0'),
('countries_spain_madrid_el_alamo', 'ChIJy6czZ6jsQQ0Rz8TRvemqn3o', 40.2350808, -3.9929453, 'city', '0'),
('countries_spain_madrid_chamartin', 'ChIJdXlsPyQpQg0RtmGU4Ydw94Q', 40.4615174, -3.6865844, 'city', '0'),
('countries_spain_madrid_casarrubuelos', 'ChIJ5_t4IvrzQQ0RcutwEW8Fkro', 40.171554, -3.832454, 'city', '0'),
('countries_spain_madrid_bustarviejo', 'ChIJ2x2JJAHfQw0RkuhmT4-0EYk', 40.8381772, -3.7232005, 'city', '0'),
('countries_algeria_illizi_zarzaitine', 'ChIJXSoqWw6bNRIRHnSUp5MIY2I', 28.086413, 9.7873891, 'city', '1'),
('countries_algeria_jijel_el_maad', 'ChIJo-O2r6hR8hIRaW4wYVCkIxY', 36.5848824, 5.8627594, 'city', '1'),
('countries_algeria_jijel_el_milia', 'ChIJUcrKo_Ai8hIR38KltreklAA', 36.7531205, 6.2676726, 'city', '1'),
('countries_algeria_jijel_emir_abdelkader', 'ChIJTzdUtEJc8hIRKy562akB9rU', 36.7527844, 5.8432653, 'city', '1'),
('countries_algeria_jijel_jijelli', 'ChIJQ4RskHtg8hIR3GdcWOQLL70', 36.8210144, 5.7634126, 'city', '1'),
('countries_algeria_jijel_kaous', 'ChIJw4QtooBe8hIRZrgyCXbG0xM', 36.771323, 5.8113221, 'city', '1'),
('countries_spain_madrid_arganda', 'ChIJN_YAigk_Qg0RANhMvvNAAwQ', 40.3064074, -3.4479915, 'city', '0'),
('countries_algeria_khenchela_babar', 'ChIJMXxtx6UC9xIRCtNt897_Atg', 35.1659782, 7.1060125, 'city', '1'),
('countries_algeria_khenchela_bouhmama', 'ChIJyUTBElmT9hIRb6UASxde_3s', 35.3194636, 6.7447191, 'city', '1'),
('countries_spain_madrid_aravaca', 'ChIJ8aOHKwGHQQ0Refte7DD_Lr4', 40.455698, -3.7850912, 'city', '0'),
('countries_algeria_khenchela_el_ogla', 'ChIJKTjQOBNt9xIRgV4Jsqge2ME', 35.1885063, 7.4649189, 'city', '1'),
('countries_algeria_khenchela_kais', 'ChIJhVr6oy_b9hIRpPEHVzsLI8w', 35.4948854, 6.9244132, 'city', '1'),
('countries_algeria_khenchela_khenchela', 'ChIJh6MQii0h9xIRznDHn4qmMXk', 35.4269404, 7.1460155, 'city', '1'),
('countries_spain_la_rioja_amer', 'ChIJWcf1XGHQuhIRkGWkIeD6AAQ', 42.0104174, 2.6028036, 'city', '1'),
('countries_algeria_laghouat_aflou', 'ChIJGfvM4twUfRIR77jl7i9xyaA', 34.1139518, 2.0973854, 'city', '1'),
('countries_spain_galicia_vincios', 'ChIJIaAwLUiJJQ0Rv6f_AykTanE', 42.1477473, -8.726668, 'city', '0'),
('countries_algeria_laghouat_brida', 'ChIJF50-ngWpfRIR3AAjar_NiM0', 33.9063818, 1.7845741, 'city', '1'),
('countries_spain_galicia_vimianzo', 'ChIJE49HoBPILg0RAs8lOhJqhHQ', 43.1100475, -9.0324195, 'city', '0'),
('countries_spain_galicia_vilagarcia_de_arousa', 'ChIJc1wF4AgULw0RjFyn70Q9w_I', 42.5986025, -8.7371039, 'city', '0'),
('countries_algeria_laghouat_laghouat', 'ChIJy9nuo0riYhIRwppaDfbzC6E', 33.8078341, 2.8628294, 'city', '1'),
('countries_algeria_mascara_froha', 'ChIJ7-hp6wLSgRIRLPk4LLbTCoQ', 35.3030715, 0.126972, 'city', '1'),
('countries_algeria_mascara_ghriss', 'ChIJ18SHrWTNgRIRcGD7MzIRbUE', 35.2464028, 0.1585628, 'city', '1'),
('countries_algeria_mascara_mascara', 'ChIJGc14XqXagRIRrPDWOkDkqnA', 35.4020988, 0.1400257, 'city', '1'),
('countries_algeria_mascara_mohammadia', 'ChIJlaUhB8HggRIRtWBdFJw1ZFQ', 35.5919096, 0.06542, 'city', '1'),
('countries_spain_galicia_valga', 'ChIJd8jBM_4PLw0RgBjLc4L1BAQ', 42.6830485, -8.6490584, 'city', '0'),
('countries_algeria_mascara_sidi_kada', 'ChIJw-eMFOu2gRIRfrHwYl3fW78', 35.3322673, 0.3410159, 'city', '1'),
('countries_algeria_mascara_sig', 'ChIJA2fty6U9fg0R9TdvmtffvA4', 35.5313614, -0.1894458, 'city', '1'),
('countries_spain_galicia_trazo', 'ChIJV1fP_n33Lg0RwFXKc4L1BAQ', 42.9906467, -8.5501283, 'city', '0'),
('countries_algeria_mascara_tizi', 'ChIJjVzKia3WgRIR8OFTXVI9TZc', 35.3146596, 0.0718471, 'city', '1'),
('countries_spain_galicia_trabada', 'ChIJMfXtGmuDMQ0RsNbKc4L1BAQ', 43.4469813, -7.1942169, 'city', '1'),
('countries_algeria_medea_beni_slimane', 'ChIJe8Uq-DPojhIRXhc_QT_Nhz0', 36.2272319, 3.3071806, 'city', '1'),
('countries_algeria_medea_berrouaghia', 'ChIJT7AVLmE7jxIRcl_41gKUhQ8', 36.1397978, 2.9189942, 'city', '1'),
('countries_algeria_medea_chorfa', 'ChIJg97lqnbhjhIRB0JouX8fN3A', 36.2912304, 3.1400494, 'city', '1'),
('countries_algeria_medea_djouab', 'ChIJJfXUGsm-jhIRLYSUSbKno0A', 36.1385263, 3.424076, 'city', '1'),
('countries_algeria_medea_el_omaria', 'ChIJ1fXWvCYfjxIRO_L6aKVMs7U', 36.2685724, 3.0262719, 'city', '1'),
('countries_spain_galicia_touro', 'ChIJ-xoPD6eyLw0RsFXKc4L1BAQ', 42.8673326, -8.3068281, 'city', '0'),
('countries_spain_galicia_teo', 'ChIJV6sIOl0BLw0RgFXKc4L1BAQ', 42.8060726, -8.5611142, 'city', '0'),
('countries_algeria_medea_ouzera', 'ChIJTUAv5sIVjxIRm23i49h8-AU', 36.2535149, 2.8450098, 'city', '1'),
('countries_algeria_medea_souk_el_had', 'ChIJ3xnNXW7XjhIRRV7IpAkQnIg', 36.0323592, 3.1432415, 'city', '1'),
('countries_algeria_medea_tablat', 'ChIJiRZGH8fxjhIRo8Olg9E6guw', 36.4131818, 3.3110706, 'city', '1'),
('countries_spain_galicia_sotogrande', 'ChIJFXQbQYrEDA0R1RZqR8zbaBs', 36.2778457, -5.293075, 'city', '1'),
('countries_spain_galicia_somozas', 'ChIJuZdVOz_9LQ0R965iI2c5RzM', 43.535579, -7.9428881, 'city', '1'),
('countries_spain_galicia_sarria', 'ChIJ-yd_APlHMA0RcNbKc4L1BAQ', 42.7600365, -7.4165053, 'city', '0'),
('countries_spain_galicia_sardineiro', 'ChIJ3dDxyYQtKQ0R_wmoBc04aCI', 42.9466891, -9.2412022, 'city', '0'),
('countries_algeria_mila_mila', 'ChIJg-I55zMt8hIRgUYloSh-Y00', 36.4519049, 6.2584338, 'city', '1'),
('countries_algeria_mila_ouled_hamla', 'ChIJt3dj4Dxe8RIRnuX7gMWLXxc', 36.0827768, 6.4664056, 'city', '1'),
('countries_spain_galicia_sanxenxo', 'ChIJk2oOaU5oLw0RZNwrzMUOYf4', 42.416489, -8.8252502, 'city', '0'),
('countries_algeria_mila_rouached', 'ChIJL-mwZMtK8hIRBM6uK1sOMl0', 36.4586774, 6.0355536, 'city', '1'),
('countries_algeria_mila_tadjenanet', 'ChIJrb4EDwe-8xIRAsHpkn4B3EY', 36.1218328, 5.9852421, 'city', '1'),
('countries_spain_galicia_santa_uxia_de_ribeira', 'ChIJnRoI91A3Lw0R8FTKc4L1BAQ', 42.5540645, -8.9922481, 'city', '0'),
('countries_spain_galicia_santa_marta_de_ortigueira', 'ChIJh8oLL2b3LQ0RKPK6jd1m6fs', 43.6580789, -7.8068851, 'city', '0'),
('countries_algeria_mostaganem_mostaganem', 'ChIJl5Tjij4CghIRsvpJqJN8M2k', 35.9311454, 0.0909414, 'city', '1'),
('countries_spain_galicia_santa_comba', 'ChIJ-7FvEa_pLg0RMFXKc4L1BAQ', 43.0476999, -8.8142264, 'city', '0'),
('countries_algeria_mostaganem_sidi_ali', 'ChIJLSbW-tk6ghIRq_p8zEWdwP0', 36.1008532, 0.4220044, 'city', '1'),
('countries_algeria_mostaganem_sidi_lakhdar', 'ChIJTQg0TgQ6ghIRtdRHCeQ8jxg', 36.1630189, 0.4384188, 'city', '1'),
('countries_algeria_mostaganem_sirat', 'ChIJibTbnKbxgRIRtFsKR0xBjLE', 35.7794378, 0.1898452, 'city', '1'),
('countries_spain_galicia_sada', 'ChIJWyJiLy5wLg0REFXKc4L1BAQ', 43.3476427, -8.2760021, 'city', '0'),
('countries_spain_galicia_ribadumia', 'ChIJg28NNVxrLw0R4BfLc4L1BAQ', 42.5146137, -8.7536237, 'city', '0'),
('countries_spain_galicia_ribadeo', 'ChIJR9Gp5ld-MQ0Rp2SI6qGi3GY', 43.5122469, -7.1144039, 'city', '0'),
('countries_spain_galicia_rianxo', 'ChIJM57tN9AZLw0RL0OM22EkNDs', 42.6923723, -8.7811645, 'city', '0'),
('countries_algeria_m_sila_berhoum', 'ChIJP8X1MpJSixIRuaUHL6n5h6c', 35.6548832, 5.0347197, 'city', '1'),
('countries_spain_galicia_porto_do_son', 'ChIJwRfzQhUlLw0R0FTKc4L1BAQ', 42.6857433, -8.9907938, 'city', '0'),
('countries_algeria_m_sila_bou_saada', 'ChIJw05kRMazixIRn5qtndBtdH8', 35.2163516, 4.181463, 'city', '1'),
('countries_algeria_m_sila_chellal', 'ChIJJ8qBz8SfixIR56UP2n-JpZk', 35.5172674, 4.3834097, 'city', '1'),
('countries_algeria_m_sila_el_hamel', 'ChIJgYt8SLlKihIRxAvqyN-BWu8', 35.1249106, 4.0894807, 'city', '1'),
('countries_algeria_m_sila_hammam_dalaa', 'ChIJq-xRyOB9jBIRr2O8XUx9TvM', 35.9217776, 4.3769132, 'city', '1'),
('countries_algeria_m_sila_magra', 'ChIJPSQPQ3yt9BIR6SPu8euX9to', 35.6145867, 5.0978379, 'city', '1'),
('countries_algeria_m_sila_medjedel', 'ChIJ20VBp8KBiRIRR1wnNwt7umk', 35.0331162, 3.6352626, 'city', '1'),
('countries_algeria_m_sila_m_sila', 'ChIJmdWr8iB7ixIROZBV94ndTsw', 35.7186646, 4.5233423, 'city', '1'),
('countries_algeria_m_sila_sidi_aissa', 'ChIJvYVvOUQAjBIREUg20V53PYE', 35.885157, 3.774373, 'city', '1'),
('countries_spain_galicia_portas', 'ChIJy_8nZ50SLw0RgBfLc4L1BAQ', 42.5700111, -8.6655592, 'city', '0'),
('countries_algeria_naama_mecheria', 'ChIJbRLxZj6TgA0RPbNluRmwfQc', 33.5428376, -0.2751123, 'city', '1'),
('countries_algeria_naama_naama', 'ChIJdxf7WOHHgA0RR08xOeDi088', 33.2667317, -0.3128659, 'city', '1'),
('countries_algeria_oran_arzew', 'ChIJZ-SL5cR0fg0RFIVGkKXAcmQ', 35.8577443, -0.3096606, 'city', '1'),
('countries_spain_galicia_ponte_caldelas', 'ChIJiwB3KRx4Lw0Rz4TM9XDJ8BE', 42.3895252, -8.5018622, 'city', '0'),
('countries_spain_galicia_pobra_de_san_xulian', 'ChIJN6PGyPY1MA0R7FdoP8d6Ns8', 42.8684464, -7.4429711, 'city', '0'),
('countries_spain_galicia_panton', 'ChIJx-rszEcaMA0RcNXKc4L1BAQ', 42.5121166, -7.633113, 'city', '0'),
('countries_algeria_oran_es_senia', 'ChIJ29isfyKKfg0RFmx4g_9qgFA', 35.6492018, -0.6062277, 'city', '1'),
('countries_algeria_oran_gdyel', 'ChIJE-9Swvdwfg0RRzM51QNKNyk', 35.7823787, -0.4236196, 'city', '1'),
('countries_spain_galicia_padron', 'ChIJ7_WE1Y8ELw0RcFTKc4L1BAQ', 42.7381033, -8.6607662, 'city', '0'),
('countries_algeria_oran_misserghin', 'ChIJyenxAJaNfg0Rexz5xlrmw7c', 35.6194141, -0.7297879, 'city', '1'),
('countries_algeria_oran_oran', 'ChIJfVMfhFSIfg0RDyn3Yjf2h0E', 35.6987388, -0.6349319, 'city', '1'),
('countries_spain_galicia_o_vicedo', 'ChIJParZ-IsFMg0R4NbKc4L1BAQ', 43.6757358, -7.6873706, 'city', '0'),
('countries_algeria_ouargla_blidet_amor', 'ChIJNVakwZqdXhIR4bv6nDajOJc', 32.9502332, 5.9799925, 'city', '1'),
('countries_algeria_ouargla_chott', 'ChIJj6rUrlZrXRIRYaXASYVdaOo', 31.9620607, 5.3895599, 'city', '1'),
('countries_algeria_ouargla_djamaa', 'ChIJDxejQEvkXhIRxVVkz62MZXU', 33.5376374, 5.9899763, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_algeria_ouargla_el_hadjira', 'ChIJySqUKxPHXRIRsoVWgmi9w1U', 32.617022, 5.5131826, 'city', '1'),
('countries_algeria_ouargla_hassi_messaoud', 'ChIJK8rnyQi4XBIRbbukF8ditUY', 30.9859091, 5.7493813, 'city', '1'),
('countries_algeria_ouargla_megarine', 'ChIJ75sDH9-9XhIRzBX2Mz0AxTo', 33.1923527, 6.0911237, 'city', '1'),
('countries_algeria_ouargla_ouargla', 'ChIJqbzEeIVrXRIRHafJ0oI-PAY', 31.9527411, 5.3335348, 'city', '1'),
('countries_algeria_ouargla_rouissat', 'ChIJx7frM6prXRIRCbqI8poZt34', 31.7170613, 4.8935627, 'city', '1'),
('countries_spain_galicia_o_carballino', 'ChIJJTeff6TtLw0RgP3Kc4L1BAQ', 42.4316311, -8.0775076, 'city', '0'),
('countries_algeria_ouargla_tebesbest', 'ChIJYwbB-U69XhIRmxVPXs1S6BY', 33.1185583, 6.0836277, 'city', '1'),
('countries_algeria_ouargla_touggourt', 'ChIJK3YvVKqiXhIR6QKvtOYmfXY', 33.1049642, 6.0662834, 'city', '1'),
('countries_spain_galicia_o_barco_de_valdeorras', 'ChIJIR2OOPSDMA0R36qDQvNqMtU', 42.4164275, -6.9855705, 'city', '0'),
('countries_spain_galicia_oroso', 'ChIJFZW88MZQLg0RIFTKc4L1BAQ', 42.9948236, -8.3636131, 'city', '0'),
('countries_spain_galicia_ordes', 'ChIJqfCVJltZLg0Rnp8GOOTqSiU', 43.077619, -8.4184224, 'city', '0'),
('countries_spain_galicia_oia', 'ChIJW2hHdDbtJQ0RQBfLc4L1BAQ', 42.0320402, -8.8583309, 'city', '0'),
('countries_spain_galicia_nigran', 'ChIJ5ZPWtXGLJQ0Raco66jrfj5Q', 42.1459862, -8.7811645, 'city', '0'),
('countries_algeria_oum_el_bouaghi_berriche', 'ChIJESlzYPLG8BIR0CGg53OguQk', 35.9191832, 7.3764198, 'city', '1'),
('countries_algeria_oum_el_bouaghi_bir_chouhada', 'ChIJp4lk5hD78xIR1SgPNtUAIvU', 35.8946679, 6.2900215, 'city', '1'),
('countries_spain_galicia_muros', 'ChIJyyEEiz8oLw0RsFPKc4L1BAQ', 42.8073676, -9.0460525, 'city', '0'),
('countries_algeria_oum_el_bouaghi_meskiana', 'ChIJgR85OwVT9xIRV8Rjfny-mC4', 35.6338341, 7.6661215, 'city', '1'),
('countries_spain_galicia_mos', 'ChIJebQCm0SGJQ0RcF3FavmAx0I', 42.2051349, -8.6051092, 'city', '0'),
('countries_algeria_oum_el_bouaghi_sigus', 'ChIJwTJ6Gv0U8RIRaXk19X7DySo', 36.124066, 6.7885108, 'city', '1'),
('countries_algeria_relizane_ammi_moussa', 'ChIJKS573lhWgRIRIlAqHjSgAzA', 35.8721265, 1.1079316, 'city', '1'),
('countries_algeria_relizane_el_matmar', 'ChIJ26EQp7qagRIRYzooRtwzxZQ', 35.7311622, 0.4595531, 'city', '1'),
('countries_algeria_relizane_mazouna', 'ChIJRV8qBJDCgxIR6LhoZ_soiUo', 36.12647, 0.8906102, 'city', '1'),
('countries_algeria_relizane_oued_rhiou', 'ChIJM82Zj4bggxIRUVXcxIHd1ww', 35.9770048, 0.9247501, 'city', '1'),
('countries_algeria_relizane_ouled_aiche', 'ChIJM560al1ZgRIRkMO1mQz8i28', 35.8255639, 0.9636857, 'city', '1'),
('countries_algeria_relizane_relizane', 'ChIJqUieBOF5gRIRJit2keoc5Uo', 35.7450263, 0.5578837, 'city', '1'),
('countries_algeria_relizane_yellel', 'ChIJF-oNNw6SgRIRm8Gz4bl3KFY', 35.7232234, 0.3562903, 'city', '1'),
('countries_algeria_relizane_zemoura', 'ChIJTaB5L-dvgRIR72NH8fdvu6U', 35.7207023, 0.7585167, 'city', '1'),
('countries_spain_galicia_morana', 'ChIJm3S8b5gMLw0RABfLc4L1BAQ', 42.5713769, -8.5830907, 'city', '0'),
('countries_algeria_saida_youb', 'ChIJ-zwi8sbDfw0RyhjldSBOd8U', 34.9204749, -0.2109899, 'city', '1'),
('countries_algeria_setif_ain_arnat', 'ChIJRZQxpyw_8xIRdCiXyBVrJYU', 36.185058, 5.3137208, 'city', '1'),
('countries_spain_galicia_moeche', 'ChIJu-BqRR3jLQ0Rye0_pkfPvK0', 43.5608713, -7.9701846, 'city', '0'),
('countries_spain_galicia_moana', 'ChIJ91_ZgYdjLw0R0BbLc4L1BAQ', 42.3077373, -8.7150831, 'city', '0'),
('countries_algeria_setif_bougaa', 'ChIJD_FipmMt8xIRrfgY0VrV-eA', 36.3330921, 5.0898464, 'city', '1'),
('countries_algeria_setif_bouira', 'ChIJ1V24vm058xIR9kvHXHvlWkw', 36.2176656, 5.2796844, 'city', '1'),
('countries_algeria_setif_el_eulma', 'ChIJd6Hyp-AK8xIRWiTrqfc8FFE', 36.1505099, 5.6999461, 'city', '1'),
('countries_spain_galicia_mino', 'ChIJiSCc34dyLg0RYFPKc4L1BAQ', 43.3539624, -8.1884949, 'city', '0'),
('countries_spain_galicia_melide', 'ChIJ7fLUSJ0zLg0RQFPKc4L1BAQ', 42.9128344, -8.0247005, 'city', '0'),
('countries_algeria_setif_hammam_guergour', 'ChIJsyQtLFLNjBIREE1DkBs8_2o', 36.3235009, 5.0549455, 'city', '1'),
('countries_algeria_setif_salah_bey', 'ChIJw9YujRdZ8xIRC-wgkRAov7s', 35.8568252, 5.2929175, 'city', '1'),
('countries_spain_galicia_meis', 'ChIJ5QrVn_FsLw0RwBbLc4L1BAQ', 42.5029514, -8.7150831, 'city', '0'),
('countries_spain_galicia_meiras', 'ChIJ1RD5LgtwLg0Rd9roTSRF0zA', 43.3546535, -8.3056074, 'city', '0'),
('countries_algeria_sidi_bel_abbes_ben_badis', 'ChIJ-9t8m-M9fw0R6Vx0EqCVG04', 34.9523022, -0.9157679, 'city', '1'),
('countries_spain_galicia_malvas', 'ChIJJ5N0so_xOA0RV9Nejqzyl0A', 41.658722, -5.509247, 'city', '0'),
('countries_algeria_sidi_bel_abbes_marhoum', 'ChIJRypUhVEcgA0RTHcBY-5x4IY', 34.4476116, -0.1947303, 'city', '1'),
('countries_algeria_sidi_bel_abbes_ras_el_ma', 'ChIJ38kQpZ3YgQ0Re1X-K_E51FU', 34.4991716, -0.8119444, 'city', '1'),
('countries_spain_galicia_malpica', 'ChIJ01zvjxCYLg0REFPKc4L1BAQ', 43.2889461, -8.8032042, 'city', '0'),
('countries_algeria_sidi_bel_abbes_sidi_ali_boussidi', 'ChIJA8GfklgZfw0RXfmfDTSP2xI', 35.1129855, -0.8389252, 'city', '1'),
('countries_spain_galicia_lousame', 'ChIJkw-C2-chLw0RAFPKc4L1BAQ', 42.7665598, -8.8252502, 'city', '0'),
('countries_algeria_sidi_bel_abbes_teghalimet', 'ChIJBw7Bycuhfw0R7jZta0uWhUU', 34.8865721, -0.5497683, 'city', '1'),
('countries_algeria_sidi_bel_abbes_telagh', 'ChIJTQqWYmOefw0R2xapSO7IEzI', 34.7826774, -0.5737307, 'city', '1'),
('countries_spain_galicia_lobios', 'ChIJP5WqEFE-JQ0R8P7Kc4L1BAQ', 41.8935624, -8.068343, 'city', '0'),
('countries_algeria_skikda_azzaba', 'ChIJve1zLKZK8BIRLYIFbzjfbpE', 36.7411032, 7.1116629, 'city', '1'),
('countries_algeria_skikda_collo', 'ChIJDaKWKDr78RIR0O5B329A6mI', 36.9981614, 6.5557168, 'city', '1'),
('countries_algeria_skikda_es_sebt', 'ChIJ9w4fvp-08RIRK2LZV1eZOF0', 36.6627721, 7.0777101, 'city', '1'),
('countries_spain_galicia_lerez', 'ChIJKwu696FxLw0RpS2bbQkvqmo', 42.4465437, -8.6279441, 'city', '0'),
('countries_spain_galicia_leon', 'ChIJ2RteDZqaNw0R8-7x1PqfhH0', 42.5987263, -5.5670959, 'city', '0'),
('countries_spain_galicia_lancara', 'ChIJ3bG62gFMMA0R9wS9e6oHpXo', 42.8342608, -7.3192542, 'city', '0'),
('countries_spain_galicia_illa_de_arousa', 'ChIJV1SlDk0-Lw0RlH5al7k9Dhg', 42.5521338, -8.8666032, 'city', '0'),
('countries_spain_galicia_godos', 'ChIJEVZJ9zuTNg0Rk4o_S25WkvU', 43.3429464, -5.9560179, 'city', '1'),
('countries_algeria_skikda_skikda', 'ChIJTdsyJJzF8RIR12W-Bn_8BpQ', 36.8662658, 6.9062556, 'city', '1'),
('countries_spain_galicia_escairon', 'ChIJi3H_nUUYMA0RIyI8fZQaKCY', 42.586152, -7.6400417, 'city', '0'),
('countries_algeria_skikda_tamalous', 'ChIJs2KU_j7s8RIR5mzXcCgRmnM', 36.8384561, 6.6427365, 'city', '1'),
('countries_algeria_souk_ahras_drea', 'ChIJXeb0_S9x-hIRvRIIqsuOQvA', 36.1147047, 7.879176, 'city', '1'),
('countries_algeria_souk_ahras_m_daourouch', 'ChIJHe90ODpx-hIRWxFWkYEwIUM', 36.0733672, 7.8175999, 'city', '1'),
('countries_algeria_souk_ahras_sedrata', 'ChIJp2XXfVuR8BIRPwAtJ9AKEQ8', 36.1345249, 7.5297476, 'city', '1'),
('countries_algeria_souk_ahras_souk_ahras', 'ChIJY4G1xTVj-hIRjWtH-xdTEYc', 36.2801062, 7.9384033, 'city', '1'),
('countries_algeria_souk_ahras_taoura', 'ChIJw48XiVVv-hIR5K_OAYOS270', 36.16667, 8.0357365, 'city', '1'),
('countries_spain_galicia_dodro', 'ChIJwYWOZk4aLw0RcFLKc4L1BAQ', 42.7168491, -8.7150831, 'city', '0'),
('countries_spain_galicia_curtis', 'ChIJiz7PjqY-Lg0RYFLKc4L1BAQ', 43.1238014, -8.14653, 'city', '0'),
('countries_spain_galicia_corme_porto', 'ChIJDdPSuRi7Lg0RbppAehwQwCM', 43.2650806, -8.9630076, 'city', '0'),
('countries_algeria_tebessa_cheria', 'ChIJ98cXcqxh9xIR4YfBr0h9I4k', 35.2709501, 7.7512926, 'city', '1'),
('countries_algeria_tebessa_hammamet', 'ChIJmfzgWGDl-RIRH6FDa3lAKkE', 35.4491906, 7.9502777, 'city', '1'),
('countries_algeria_tebessa_ouenza', 'ChIJ53WxQy0--hIR74LLAhUycDs', 35.9518347, 8.1325283, 'city', '1'),
('countries_spain_galicia_coles', 'ChIJkzYtBRHReg0RMdkBDiYpPh0', 37.1524822, -1.8886224, 'city', '0'),
('countries_algeria_tiaret_dahmouni', 'ChIJLWUD5QXDhhIRXZbyraNteeg', 35.416323, 1.4265613, 'city', '1'),
('countries_algeria_tiaret_frenda', 'ChIJSRqAQ5HagBIR1PgeYn9FO08', 35.0638421, 1.0572065, 'city', '1'),
('countries_algeria_tiaret_hassi_fedoul', 'ChIJGf4JUVw5hhIRDJcbAukiSPM', 35.4378054, 2.2115104, 'city', '1'),
('countries_algeria_tiaret_ksar_chellala', 'ChIJV9pre0EthhIRwutoeDHjxfQ', 35.2181066, 2.3153581, 'city', '1'),
('countries_algeria_tiaret_sidi_hosni', 'ChIJl2C26P_BhhIRj25e7uZnqpc', 35.4718589, 1.5199592, 'city', '1'),
('countries_algeria_tiaret_sougueur', 'ChIJeb1v_WgghxIRhuTAZkW6LM8', 35.1857422, 1.4935025, 'city', '1'),
('countries_algeria_tiaret_tiaret', 'ChIJX7qL08_RhhIRUGlGNScagJE', 35.3708689, 1.3217852, 'city', '1'),
('countries_algeria_tindouf_tindouf', 'ChIJ-9UtpEP1yA0Rl_R5PxN_8Hc', 27.6719159, -8.1398003, 'city', '1'),
('countries_spain_galicia_cervas', 'ChIJAUsA-Q93Lg0RECTsoJThJN4', 43.4438775, -8.2761792, 'city', '0'),
('countries_spain_galicia_cee', 'ChIJwSmb3VctKQ0R0FHKc4L1BAQ', 42.9689054, -9.2009815, 'city', '0'),
('countries_algeria_tipaza_baba_hassen', 'ChIJSX1WiAOvjxIRXPRXXXimxEc', 36.694293, 2.9733179, 'city', '1'),
('countries_spain_galicia_castrelo_de_mino', 'ChIJx20P4Mf1Lw0RsP3Kc4L1BAQ', 42.2972894, -8.0574299, 'city', '0'),
('countries_spain_galicia_carnota', 'ChIJHaiAvhHWLg0RHMny6Fuhsz8', 42.8425535, -9.0902873, 'city', '0'),
('countries_spain_galicia_carballo', 'ChIJbdvcLz-SLg0RXVovkRWoDJE', 43.2128129, -8.6915927, 'city', '0'),
('countries_spain_galicia_capela', 'ChIJ3U_ycVoJLg0RgFHKc4L1BAQ', 43.4518469, -8.0247005, 'city', '0'),
('countries_algeria_tipaza_bourkika', 'ChIJbWxWZuF9jxIRwZysmBdGAaU', 36.4946469, 2.4776335, 'city', '1'),
('countries_spain_galicia_cangas_do_morrazo', 'ChIJZcyYyQJhLw0RQuXELjw2n1k', 42.2645845, -8.7809282, 'city', '0'),
('countries_spain_galicia_cambre', 'ChIJY-nwOaZlLg0RaZdsEtvv2pk', 43.286882, -8.3197946, 'city', '0'),
('countries_algeria_tipaza_chaiba', 'ChIJ97GU6K6fjxIRFrsGUWGztXY', 36.6030352, 2.7364209, 'city', '1'),
('countries_spain_galicia_caldas_de_reis', 'ChIJ-7q7vegNLw0R_jzh4iTSW30', 42.6040642, -8.6420199, 'city', '0'),
('countries_algeria_tipaza_cherchell', 'ChIJY9x-4ZZ1hRIRBGp9yVKBZi0', 36.5955738, 2.2525015, 'city', '1'),
('countries_spain_galicia_cacheiras', 'ChIJdelS_aEBLw0Ric9l6B7dGkc', 42.8208298, -8.5500924, 'city', '0'),
('countries_algeria_tipaza_douaouda', 'ChIJj6qRCwWijxIRHmng0uwM2ss', 36.6770431, 2.7955922, 'city', '1'),
('countries_spain_galicia_cabanas', 'ChIJz5I63mNzLg0RpeLc1monNyY', 43.4397134, -8.1283942, 'city', '0'),
('countries_algeria_tipaza_el_achour', 'ChIJQXCCsCGujxIRqZOZtp1ub0Y', 36.7409502, 2.9958986, 'city', '1'),
('countries_algeria_tipaza_el_affroun', 'ChIJWTFtoZ5wjxIR4lvbJlyU5xI', 36.4701592, 2.625741, 'city', '1'),
('countries_spain_galicia_burela_de_cabo', 'ChIJZdSv8o8jMg0RoYgis38If_Q', 43.6602954, -7.3611092, 'city', '0'),
('countries_algeria_tipaza_fouka', 'ChIJUdFZlTOfjxIRcYSXb-8huu0', 36.6615192, 2.7423497, 'city', '1'),
('countries_algeria_tipaza_hadjout', 'ChIJXxIISySBhRIRlrA76POLNUk', 36.5121841, 2.4142994, 'city', '1'),
('countries_spain_galicia_bueu', 'ChIJd_RFV2ddLw0RQBXLc4L1BAQ', 42.3239213, -8.7591311, 'city', '0'),
('countries_spain_galicia_budino', 'ChIJ7zQkM0RRLg0R9ZXPfH-ioQg', 42.9588353, -8.3827378, 'city', '0'),
('countries_algeria_tipaza_larhat', 'ChIJb2N118BUhBIRywsl9Q92XUI', 36.5565787, 1.8018343, 'city', '1'),
('countries_spain_galicia_bubal', 'ChIJhcDnwFmNVw0R-kIZV8EY2Y4', 42.7010756, -0.312503, 'city', '0'),
('countries_algeria_tipaza_mouzaia', 'ChIJG37h4mtxjxIRDusWgRUQRKs', 36.4669121, 2.6898596, 'city', '1'),
('countries_algeria_tipaza_nador', 'ChIJmZC9ze2BhRIRsYTx3yZFcPA', 36.5693409, 2.3935256, 'city', '1'),
('countries_spain_galicia_brantega', 'ChIJZWEvI3XJLw0R1dYdFuA-bms', 42.7931473, -8.0880853, 'city', '0'),
('countries_algeria_tipaza_ouled_fayet', 'ChIJN1v0YPCvjxIRIPCDEkf5uPU', 36.7340018, 2.9339798, 'city', '1'),
('countries_algeria_tipaza_saoula', 'ChIJrZVjxD6sjxIRBJebG5wP8Aw', 36.7032467, 3.0242644, 'city', '1'),
('countries_algeria_tipaza_sidi_amar', 'ChIJIwBX7iqDhRIRxA_QvRtObf0', 36.5439812, 2.3062853, 'city', '1'),
('countries_algeria_tipaza_sidi_ghiles', 'ChIJu8eMknCghRIRuRdWTx-6qog', 36.58391, 2.1248169, 'city', '1'),
('countries_algeria_tipaza_sidi_rached', 'ChIJg4Y9yk5_jxIR0ejRygr3XT0', 36.5620016, 2.5305399, 'city', '1'),
('countries_spain_galicia_borben', 'ChIJ1-JNzgF_Lw0RM55vKfYgghI', 42.2758748, -8.5273491, 'city', '0'),
('countries_spain_galicia_barizo', 'ChIJpX-eFtyiLg0RzHnJ9ExJL30', 43.3084314, -8.8738525, 'city', '0'),
('countries_algeria_tipaza_zeralda', 'ChIJw-nGdnOjjxIR0Rb6FuRI_f4', 36.7137456, 2.8449957, 'city', '1'),
('countries_algeria_tissemsilt_bordj_bounaama', 'ChIJM3vBU4WbhhIRH8IdKoBP96g', 35.85039, 1.6149139, 'city', '1'),
('countries_spain_galicia_bandeira', 'ChIJwX3pgBywLw0RkN4cyYg8dLs', 42.7294398, -8.3034871, 'city', '1'),
('countries_algeria_tissemsilt_tissemsilt', 'ChIJ7V5YZkKKhhIRaBzBvBriaqQ', 35.6053781, 1.813098, 'city', '1'),
('countries_spain_galicia_baiona', 'ChIJXeo0L9nyJQ0RMBXLc4L1BAQ', 42.1200897, -8.8523562, 'city', '0'),
('countries_spain_galicia_a_guarda', 'ChIJSYO9GZLqJQ0RM3FMZx2tyyE', 41.9074756, -8.865254, 'city', '0'),
('countries_spain_galicia_a_estrada', 'ChIJc2oAyRoILw0RjetRBkmDRSA', 42.6898712, -8.4909667, 'city', '0'),
('countries_spain_galicia_arteixo', 'ChIJeZRfAG-ILg0RsFDKc4L1BAQ', 43.303707, -8.5102275, 'city', '0'),
('countries_algeria_tizi_ouzou_akfadou', 'ChIJq0GgUbYbjRIRkXr5177cYfU', 36.6605042, 4.6140481, 'city', '1'),
('countries_algeria_tizi_ouzou_azazga', 'ChIJ81WzugmnjRIR2kzwRbMUlGI', 36.7453947, 4.3714004, 'city', '1'),
('countries_algeria_tizi_ouzou_beni_douala', 'ChIJhxYIivy1jRIROf9TyjYCoJg', 36.6208712, 4.0817582, 'city', '1'),
('countries_algeria_tizi_ouzou_boghni', 'ChIJV020hGjKjRIReHKd9aYZaKI', 36.5329303, 3.9611136, 'city', '1'),
('countries_algeria_tizi_ouzou_boudjima', 'ChIJt8-TXR68jRIRS-R6yWiexdQ', 36.8146237, 4.1597212, 'city', '1'),
('countries_algeria_tizi_ouzou_bou_saada', 'ChIJ5_UZtY-zixIR3qkwX8H0x0c', 35.2011819, 4.1602106, 'city', '1'),
('countries_spain_galicia_ares', 'ChIJPaUrerh2Lg0RFrRQMnFqtBQ', 43.4310744, -8.2486449, 'city', '0'),
('countries_algeria_tizi_ouzou_freha', 'ChIJ8xCvSZ2mjRIRUT6OsaEONow', 36.7568882, 4.316034, 'city', '1'),
('countries_algeria_tizi_ouzou_ifigha', 'ChIJnXXhXpIHjRIRbclv9uy-y_c', 36.6708971, 4.4098582, 'city', '1'),
('countries_spain_galicia_arcade', 'ChIJFXkkAbJ7Lw0R9-gfMFbsUaQ', 42.3407844, -8.6048713, 'city', '0'),
('countries_spain_galicia_ames', 'ChIJxbVERbX8Lg0R748cGi8hwb4', 42.9038027, -8.6583677, 'city', '1'),
('countries_algeria_tizi_ouzou_mekla', 'ChIJy9JTUpivjRIRxeOS-Ll-cAk', 36.6871278, 4.2669219, 'city', '1'),
('countries_spain_galicia_agualada', 'ChIJPSZyWCSVLg0R2Kh6tscDEIs', 43.1577807, -8.8004137, 'city', '0'),
('countries_algeria_tizi_ouzou_tigzirt', 'ChIJu9oAKYGVjRIRLvClesqu7ZY', 36.8919195, 4.129222, 'city', '1'),
('countries_algeria_tizi_ouzou_timizart', 'ChIJ-d6XTWWjjRIRJE7LUu0qZV4', 36.7940916, 4.2449425, 'city', '1'),
('countries_algeria_tizi_ouzou_tirmitine', 'ChIJG8ZPXMzOjRIR7TPemBRTnP0', 36.6754312, 3.9587091, 'city', '1'),
('countries_spain_galicia_agron', 'ChIJaYFPEnsbcg0RXt93yDGWsdY', 37.0300898, -3.8292747, 'city', '0'),
('countries_algeria_tizi_ouzou_tizi_ouzou', 'ChIJCwn9v9_HjRIRBAgg3CCazSc', 36.713548, 4.0473075, 'city', '1'),
('countries_algeria_tizi_ouzou_tizi_rached', 'ChIJ_R-j94qwjRIRw-FtErngwoE', 36.678519, 4.2080342, 'city', '1'),
('countries_algeria_tizi_ouzou_yakouren', 'ChIJlwsaPlYIjRIRpnKjqdhhsNc', 36.7345765, 4.4389827, 'city', '1'),
('countries_spain_galicia_abeancos', 'ChIJ64t6KFIzLg0RWDFEdyENMb0', 42.8972866, -8.0376871, 'city', '0'),
('countries_algeria_tlemcen_beni_mester', 'ChIJO6szlWXHeA0RUqHqu7YjaTY', 34.8663027, -1.4214462, 'city', '1'),
('countries_algeria_tlemcen_bensekrane', 'ChIJ11WaN9nSeA0RUUYVBcj5-lE', 35.0718762, -1.2281733, 'city', '1'),
('countries_algeria_tlemcen_chetouane', 'ChIJ09EZDmfJeA0RfSEU8tF1O10', 34.9239124, -1.299604, 'city', '1'),
('countries_algeria_tlemcen_ghazaouet', 'ChIJ32EC13FWeA0RVWAx5edkse0', 35.0936543, -1.861861, 'city', '1'),
('countries_algeria_tlemcen_hennaya', 'ChIJkZPLL_nFeA0RprJoey8pF2g', 34.9523096, -1.3723652, 'city', '1'),
('countries_algeria_tlemcen_maghnia', 'ChIJjTNnM8yMeA0R0veZM7n7qws', 34.8486597, -1.7293536, 'city', '1'),
('countries_algeria_tlemcen_nedroma', 'ChIJp9TVFerweA0RGwdy7oqaERE', 35.0292918, -1.7666936, 'city', '1'),
('countries_algeria_tlemcen_ouled_mimoun', 'ChIJMWcp-LI5fw0RCx_bBEaWn6A', 34.9044116, -1.0342358, 'city', '1'),
('countries_algeria_tlemcen_remchi', 'ChIJGxQxh27beA0RnDdVP7GGuQM', 35.064069, -1.42638, 'city', '1'),
('countries_algeria_tlemcen_sabra', 'ChIJPZRzU0KVeA0RUh-AzBOzzE4', 34.8279025, -1.5291653, 'city', '1'),
('countries_algeria_tlemcen_sebdou', 'ChIJraPnbk6ueA0R-4p-MBOXooA', 34.6376648, -1.3329676, 'city', '1'),
('countries_algeria_tlemcen_sidi_abdelli', 'ChIJzQW2KXgufw0R9vjXYyj9SlY', 35.0609205, -1.1318933, 'city', '1'),
('countries_algeria_tlemcen_sidi_djilali', 'ChIJ8UVDcsZ1gg0Ry2SELaXSJso', 34.4471071, -1.5689859, 'city', '1'),
('countries_algeria_tlemcen_sidi_medjahed', 'ChIJ15_oOdSTeA0RHi62xXdlTQg', 34.7738194, -1.6671931, 'city', '1'),
('countries_algeria_tlemcen_souahlia', 'ChIJDVeoShVXeA0RLzglnxFjpTs', 35.0408664, -1.8912952, 'city', '1'),
('countries_algeria_tlemcen_tlemcen', 'ChIJWe-09rjJeA0RgAf63de5dgU', 34.8828864, -1.3166815, 'city', '1'),
('countries_american_samoa_eastern_district', 'ChIJDRBuX1eFpnER0uOcM-bDOx4', -14.2762232, -170.6437906, 'region', '1'),
('countries_american_samoa_manu_a_district', 'ChIJ7Wop47x6p3ERVQQ8duY8pBU', -14.2341217, -169.4985091, 'region', '1'),
('countries_spain_galicia_abanqueiro', 'ChIJ4XSxOHY9Lw0RRfQhjdXrYKQ', 42.6395828, -8.8510667, 'city', '0'),
('countries_american_samoa_western_district', 'ChIJDRBuX1eFpnER0uOcM-bDOx4', -14.2762232, -170.6437906, 'region', '1'),
('countries_american_samoa_eastern_district_pago_pago', 'ChIJyf1IkreEpnERK0EVzuwzjjU', -14.2756319, -170.7020359, 'city', '1'),
('countries_spain_extremadura_valverde_de_llerena', 'ChIJvzwpTtaYEw0RpE8k3ldOepw', 38.204996, -5.8037437, 'city', '0'),
('countries_spain_extremadura_trujillo', 'ChIJ4zJf_yGjFQ0RD2G7JMlq0rE', 39.458293, -5.8767284, 'city', '0'),
('countries_american_samoa_western_district_faleniu', 'ChIJT8SopfScpnER3bKiID2q0do', -14.3275739, -170.7422285, 'city', '1'),
('countries_american_samoa_western_district_leone', 'ChIJgdk_3qCdpnERlM8VnIlXds4', -14.3377247, -170.7810162, 'city', '1'),
('countries_american_samoa_western_district_tafuna', 'ChIJMTNEDICcpnERVP2xj8101Sw', -14.331296, -170.7269854, 'city', '1'),
('countries_american_samoa_western_district_vaitogi', 'ChIJi1QMtvOcpnERstwDL_Lw0y0', -14.3519929, -170.7408429, 'city', '1'),
('countries_andorra_andorra_la_vella', 'ChIJC_slSiv1pRIRgHKZkXCUAAo', 42.5063174, 1.5218355, 'region', '1'),
('countries_andorra_canillo', 'ChIJTe6gnypirxIRz3zz-P1hYFk', 42.5978249, 1.6566377, 'region', '1'),
('countries_andorra_encamp', 'ChIJjxoc-DOIpRIRALGBPm6UAAQ', 42.5194138, 1.6566377, 'region', '1'),
('countries_andorra_escaldes_engordany', 'ChIJaxpK9OKKpRIRtp4e8lTF3v0', 42.5100804, 1.5387862, 'region', '1'),
('countries_andorra_la_massana', 'ChIJN6oRJ_pfrxIRgHGZkXCUAAo', 42.545625, 1.5147392, 'region', '1'),
('countries_andorra_ordino', 'ChIJMQoHTz5grxIRCdOGHvriZNY', 42.5994433, 1.5402327, 'region', '1'),
('countries_andorra_sant_julia_de_loria', 'ChIJMx4tb17zpRIR3SfXBr8BPNg', 42.4529631, 1.4918235, 'region', '1'),
('countries_andorra_andorra_la_vella_andorra_la_vella', 'ChIJC_slSiv1pRIRgHKZkXCUAAo', 42.5063174, 1.5218355, 'city', '1'),
('countries_andorra_andorra_la_vella_santa_coloma', 'ChIJ74ryS-b0pRIRwHCZkXCUAAo', 42.4952157, 1.4984765, 'city', '1'),
('countries_andorra_canillo_canillo', 'ChIJ6caIYidirxIRAHGZkXCUAAo', 42.5666535, 1.5994581, 'city', '1'),
('countries_andorra_encamp_encamp', 'ChIJDTxNjQuKpRIR8HCZkXCUAAo', 42.5362652, 1.5830224, 'city', '1'),
('countries_spain_extremadura_navaconcejo', 'ChIJ_cBbjDNIPg0RoDSgjP1jBAQ', 40.1791713, -5.827929, 'city', '0'),
('countries_andorra_la_massana_arinsal', 'ChIJpfGM_aRfrxIRWJ6kVinpwZI', 42.5748011, 1.4818459, 'city', '1'),
('countries_andorra_la_massana_la_massana', 'ChIJN6oRJ_pfrxIRgHGZkXCUAAo', 42.545625, 1.5147392, 'city', '1'),
('countries_spain_extremadura_merida', 'ChIJ6Zo1ybgmFA0RP8rPE-7Sbr4', 38.9394272, -6.365157, 'city', '0'),
('countries_andorra_la_massana_sispony', 'ChIJmY6EtVb1pRIRYHGZkXCUAAo', 42.5340788, 1.5155674, 'city', '1'),
('countries_andorra_ordino_llorts', 'ChIJN9PHPJlgrxIRAHKZkXCUAAo', 42.5964092, 1.5267634, 'city', '1'),
('countries_andorra_ordino_ordino', 'ChIJYblI4hNgrxIRoHGZkXCUAAo', 42.5556547, 1.5330732, 'city', '1'),
('countries_andorra_sant_julia_de_loria_sant_julia_de_loria', 'ChIJ86UCopz0pRIRcHCZkXCUAAo', 42.4657861, 1.4921277, 'city', '1'),
('countries_angola_bengo_province', 'ChIJ-cW4PAsjThoR0_l5o9P8eBQ', -9.1042257, 13.7289167, 'region', '1'),
('countries_angola_benguela', 'ChIJMxDN3grRrxsRFqYwLojPYp8', -12.5905158, 13.416501, 'region', '1'),
('countries_angola_bie', 'ChIJGSRoaDtKyBsR_CG8itGEwZM', -12.343907, 16.947666, 'region', '1'),
('countries_angola_cabinda', 'ChIJByA_QXXTXRoR-5pgDqGXtSM', -5.5705739, 12.197583, 'region', '1'),
('countries_angola_cuando_cobango', 'ChIJ8Zwt1k_QwRsRf7426eJMRfM', -16.4180824, 18.8076195, 'region', '1'),
('countries_angola_cuanza_norte_province', 'ChIJgVAfSXcgSRoR1HpLfduIyGI', -9.2398513, 14.6587821, 'region', '1'),
('countries_angola_cunene_province', 'ChIJg1JOSR8zlhsRRqMFqDgGBb8', -16.2802221, 16.1580937, 'region', '1'),
('countries_angola_huambo', 'ChIJ29_227R1txsR25w50SKIp0M', -12.7739761, 15.7468535, 'region', '1'),
('countries_angola_huila', 'ChIJ8e-6cINLoxsRDBPEVCG2svQ', -14.9280553, 14.6587821, 'region', '1'),
('countries_angola_kwanza_sul', 'ChIJm13pGRGXshsRwiRyhDUK97Q', -10.595191, 15.4068079, 'region', '1'),
('countries_angola_luanda_norte', 'ChIJEVp3X2_EKBoRpjYihiADm30', -8.3525022, 19.1880047, 'region', '1'),
('countries_angola_luanda_province', 'ChIJJ4utyk7yURoRh72IMlZ_E38', -9.035088, 13.2663479, 'region', '1'),
('countries_angola_lunda_sul', 'ChIJgQrmpNIa0hsRkYalgfMSrn4', -10.2866578, 20.7122465, 'region', '1'),
('countries_angola_malanje_province', 'ChIJsbm57UoKNRoREMEUDmbQxV0', -9.8251183, 16.912251, 'region', '1'),
('countries_angola_moxico', 'ChIJ34rbBqR2fRkRrc4iU_Sr0d0', -13.4293579, 20.3308814, 'region', '1'),
('countries_angola_namibe_province', 'ChIJDYgNpdM_nxsRUxXTAP1x9Ps', -15.7979942, 12.4380581, 'region', '1'),
('countries_angola_uige', 'ChIJ11tSpTAjRBoRla0xexL2jd4', -7.1736732, 15.4068079, 'region', '1'),
('countries_angola_zaire', 'ChIJExVtT5QPXBoRVylQ7iNKnRo', -6.5733458, 13.1740348, 'region', '1'),
('countries_angola_bengo_province_ambriz', 'ChIJ62nonXNrUBoRJfh-1dFv6-Y', -7.863084, 13.1192563, 'city', '1'),
('countries_angola_bengo_province_cazeta', 'ChIJ6e8rw9ouThoRNQ6_AQvnIbU', -8.366667, 13.65, 'city', '1'),
('countries_spain_extremadura_jerte', 'ChIJv205BBZLPg0Rf2Cjr6Xasdk', 40.2224705, -5.7519844, 'city', '1'),
('countries_spain_extremadura_guadiana_del_caudillo', 'ChIJPTSVbEmSFg0Rf8Ko7nlzSOc', 38.927801, -6.6892089, 'city', '0'),
('countries_spain_extremadura_cristina', NULL, 0, 0, 'city', '0'),
('countries_angola_benguela_benguela', 'ChIJMxDN3grRrxsRFqYwLojPYp8', -12.5905158, 13.416501, 'city', '1'),
('countries_angola_benguela_catumbela', 'ChIJN_FTuWLVsRsRj8xKEyEo23w', -12.4211276, 13.5494757, 'city', '1'),
('countries_angola_benguela_lobito', 'ChIJcTvoafAprhsR3kVfklYC7nA', -12.3757287, 13.5610451, 'city', '1'),
('countries_angola_bie_kuito', 'ChIJCTzxVb5JyBsRqkOdL3ebFv8', -12.3940412, 16.9417632, 'city', '1'),
('countries_angola_cabinda_cabinda', 'ChIJByA_QXXTXRoR-5pgDqGXtSM', -5.5705739, 12.197583, 'city', '1'),
('countries_angola_cuando_cobango_menongue', 'ChIJjW_Q8mY_wRsRNgwGcaDHHl0', -14.6594083, 17.6984879, 'city', '1'),
('countries_angola_cuanza_norte_province_camabatela', 'ChIJgVAfSXcgSRoRUN18g9HK_wo', -8.1874595, 15.3745964, 'city', '1'),
('countries_angola_cuanza_norte_province_n_dalatando', 'ChIJ8cEX7cFzTBoRcvIpwrUhFIk', -9.2993916, 14.9096846, 'city', '1'),
('countries_angola_cunene_province_ondjiva', 'ChIJE2c0pYxglBsRwCfBPApS6Wg', -17.0627088, 15.7028457, 'city', '1'),
('countries_angola_huambo_huambo', 'ChIJ29_227R1txsR25w50SKIp0M', -12.7739761, 15.7468535, 'city', '1'),
('countries_spain_extremadura_coria', 'ChIJpXVGkKPkPQ0RwDCgjP1jBAQ', 39.9829198, -6.5143087, 'city', '0'),
('countries_angola_huila_lubango', 'ChIJI39fEXlLoxsREPs55IcOoso', -14.9186136, 13.5321234, 'city', '1'),
('countries_spain_extremadura_burguillos_del_cerro', 'ChIJv49p4ANOEQ0RAPWfjP1jBAQ', 38.4044531, -6.5996963, 'city', '0'),
('countries_angola_kwanza_sul_porto_amboim', 'ChIJ_fWNWBiXshsRVr_NShjhcsQ', -10.7330115, 13.7694692, 'city', '1'),
('countries_angola_kwanza_sul_sumbe', 'ChIJC7CgOqBoshsRccrm-rJs3w0', -11.2122554, 13.8477121, 'city', '1'),
('countries_spain_extremadura_aldeanueva_del_camino', 'ChIJf_s0-rdFPg0RRyH1yvk2Pu4', 40.2645413, -5.9251211, 'city', '0'),
('countries_angola_luanda_norte_lucapa', 'ChIJCS3tTji9LhoR9Sb_cxA2s9A', -8.4432485, 20.7301263, 'city', '1'),
('countries_angola_luanda_province_belas', 'ChIJbfK-UND0URoRhRLeVOHdnAs', -9.0833861, 13.1279039, 'city', '1'),
('countries_angola_luanda_province_benfica', 'ChIJ9bHUAuQfUhoRfYX0o_tcy5A', -8.9567924, 13.1913383, 'city', '1'),
('countries_angola_luanda_province_cacuaco', 'ChIJZ2Ph2aH6URoRZkXMpg6uqZ8', -8.8055918, 13.3471775, 'city', '1'),
('countries_spain_extremadura_alcantara', 'ChIJIb-KzPcjFg0REC2gjP1jBAQ', 39.7169271, -6.8822281, 'city', '0'),
('countries_angola_luanda_province_kilamba_kiaxi', 'ChIJJZdKmgj0URoRe9p5lT2rGu4', -8.8735741, 13.254805, 'city', '1'),
('countries_angola_luanda_province_luanda', 'ChIJfSyN3FzxURoRklrMXlwcDIU', -8.8146556, 13.2301756, 'city', '1'),
('countries_angola_luanda_province_maianga', 'ChIJQaqmXKTzURoRqcma3LhWtQE', -8.8472375, 13.2374927, 'city', '1'),
('countries_angola_luanda_province_viana', 'ChIJFd1dh3n3URoRgnwdeETZwCY', -8.897137, 13.34962, 'city', '1'),
('countries_angola_lunda_sul_saurimo', 'ChIJN195U0XeLBoRg6TG7eYCsJ0', -9.6612173, 20.3904598, 'city', '1'),
('countries_angola_moxico_lumeje', 'ChIJfSYsJN1D0RsRB4wNzXTe-oo', -11.5613991, 20.7822772, 'city', '1'),
('countries_angola_namibe_province_namibe', 'ChIJzb4X-1vZoxsRre5AskmJ2bM', -15.1978317, 12.1575544, 'city', '1'),
('countries_spain_extremadura_alagon_del_rio', 'ChIJCRPnWfkFPg0R8w-wFF9M_tk', 39.9682619, -6.3172906, 'city', '0'),
('countries_spain_catalonia_vilassar_de_mar', 'ChIJ3WCZHAO0pBIRkA-kIeD6AAQ', 41.5041512, 2.3838304, 'city', '0'),
('countries_angola_zaire_soyo', 'ChIJNauzN00MXBoRQeno97YVMHI', -6.1410265, 12.3521148, 'city', '1'),
('countries_anguilla_anguilla_s_lands', 'ChIJ5QHvjnRjDowRgdTghNNqnTs', 18.220554, -63.068615, 'region', '1'),
('countries_spain_catalonia_vilanova_de_la_roca', 'ChIJS3Odd4y3pBIRQBWkIeD6AAQ', 41.5531532, 2.3073743, 'city', '0'),
('countries_spain_catalonia_vilanova_del_cami', 'ChIJcz8tuTZopBIRW75s_XtTHXk', 41.564678, 1.6323607, 'city', '0'),
('countries_antigua_and_barbuda_barbuda', 'ChIJ9cmWi1dsDYwRtYrMuAczizM', 17.6266242, -61.7713028, 'region', '1'),
('countries_antigua_and_barbuda_parish_of_saint_george', 'ChIJ6cF5YfGWEowRmpa8eUBRPOo', 17.1078489, -61.7882743, 'region', '1'),
('countries_antigua_and_barbuda_parish_of_saint_john', 'ChIJiT6yVLGTEowR1Umhm7fdKXY', 17.1086478, -61.8292206, 'region', '1'),
('countries_antigua_and_barbuda_parish_of_saint_mary', 'ChIJxy3TCjHtEowRz3L6kqeWNNs', 17.0512064, -61.8760283, 'region', '1'),
('countries_antigua_and_barbuda_parish_of_saint_paul', 'ChIJl11ncTjrEowRuxnK5knZrSM', 17.0371588, -61.7824256, 'region', '1'),
('countries_antigua_and_barbuda_parish_of_saint_peter', 'ChIJeQnfs1CUEowRqWPDYcTzvfM', 17.0980665, -61.7590329, 'region', '1'),
('countries_antigua_and_barbuda_parish_of_saint_philip', 'ChIJFzxherK_EowRqQOyAbkXVWg', 17.0480636, -61.712257, 'region', '1'),
('countries_antigua_and_barbuda_redonda', 'ChIJbYiO7QNPEowR1DkHiKEmdfU', 16.938416, -62.3455148, 'region', '1'),
('countries_antigua_and_barbuda_barbuda_codrington', 'ChIJp7lWYr5uDYwRBT0nnMlqDU4', 17.6425736, -61.8204456, 'city', '1'),
('countries_antigua_and_barbuda_parish_of_saint_george_piggotts', 'ChIJlVcGAuyTEowRDoZJPqZP6Yc', 17.1238845, -61.8233706, 'city', '1'),
('countries_antigua_and_barbuda_parish_of_saint_john_cassada_gardens', 'ChIJRaa1uOCTEowRpa1r8OHqWGk', 17.1359933, -61.8145958, 'city', '1'),
('countries_spain_catalonia_vilanant', 'ChIJ37ueVbaTuhIR47ixpG59Low', 42.2543606, 2.8826534, 'city', '0'),
('countries_spain_catalonia_vilamos', 'ChIJAWZGUUyOqBIRy49E9gdodDc', 42.7476961, 0.7263609, 'city', '1'),
('countries_antigua_and_barbuda_parish_of_saint_mary_bolands', 'ChIJ_RLHXLKSEowR4Pp3Lat0X4M', 17.0649813, -61.8738339, 'city', '1'),
('countries_antigua_and_barbuda_parish_of_saint_mary_jolly_harbour', 'ChIJ1xpijKqSEowRWKxEOeJ2GsM', 17.065805, -61.886455, 'city', '1'),
('countries_antigua_and_barbuda_parish_of_saint_paul_falmouth', 'ChIJEwLVpF3rEowRHM61PJZtTbY', 17.0289837, -61.786081, 'city', '1'),
('countries_antigua_and_barbuda_parish_of_saint_paul_liberta', 'ChIJMY78F1rrEowRS60nZyBzpUA', 17.0349138, -61.7853499, 'city', '1'),
('countries_antigua_and_barbuda_parish_of_saint_peter_all_saints', 'ChIJb87TZV-TEowRybfP2BHEwlc', 17.0626404, -61.7911987, 'city', '1'),
('countries_spain_catalonia_vilafant', 'ChIJ_x5C84eNuhIRGgt-UQjZ730', 42.2528434, 2.9425698, 'city', '0'),
('countries_argentina_buenos_aires', 'ChIJvQz5TjvKvJURh47oiC6Bs6A', -34.6036844, -58.3815591, 'region', '1'),
('countries_argentina_buenos_aires_f_d', 'ChIJvQz5TjvKvJURh47oiC6Bs6A', -34.6036844, -58.3815591, 'region', '1'),
('countries_argentina_catamarca', 'ChIJzZ8PHb8oJJQRGoYJFkvdHn4', -28.469581, -65.7795441, 'region', '1'),
('countries_argentina_chaco', 'ChIJR3LI4_rvQJQRleyel8CWr04', -26.5857656, -60.9540073, 'region', '1'),
('countries_argentina_chubut', 'ChIJR3BXosaj4r0RKKImS45F1No', -43.6846192, -69.2745537, 'region', '1'),
('countries_argentina_cordoba', 'ChIJaVuPR1-YMpQRkrBmU5pPorA', -31.4200833, -64.1887761, 'region', '1'),
('countries_argentina_corrientes', 'ChIJa9O-1XlrRZQRRga08x6fmfo', -27.4692131, -58.8306349, 'region', '1'),
('countries_argentina_entre_rios', 'ChIJvy9Iut1RpZURgmPU3PBLKGk', -32.5175643, -59.1041758, 'region', '1'),
('countries_argentina_formosa', 'ChIJBU_PiOSlXJQRcq4bWubrygs', -26.1857768, -58.1755669, 'region', '1'),
('countries_argentina_jujuy', 'ChIJL6bXi04PG5QRmeT2V-BQUTE', -24.1857864, -65.2994767, 'region', '1'),
('countries_argentina_la_pampa', 'ChIJ6TZppA1t3JURyFjyX753Fqw', -37.8956594, -65.0957792, 'region', '1'),
('countries_argentina_la_rioja', 'ChIJ5feWM4fZJ5QRysdyiTScHD4', -29.4134538, -66.8564579, 'region', '1'),
('countries_argentina_mendoza', 'ChIJv3lRxD4JfpYROvoO0vZ4WiA', -32.8894587, -68.8458386, 'region', '1'),
('countries_argentina_misiones', 'ChIJM-NMXSQR-JQRHVqx6381Xfs', -26.9377146, -54.4342138, 'region', '1'),
('countries_argentina_neuquen', 'ChIJNY7rNbozCpYR9eLjELisIGI', -38.9516784, -68.0591888, 'region', '1'),
('countries_argentina_rio_negro', 'ChIJP0p3YluX9pURxObsieX7_Gs', -39.8829436, -65.2597963, 'region', '1'),
('countries_argentina_salta', 'ChIJ-bdRUaPDG5QRBvKH1SyZzaU', -24.7821269, -65.4231976, 'region', '1'),
('countries_argentina_santa_cruz', 'ChIJX1N_w_37tr0RfCPI_XcNueQ', -48.7736825, -69.1917166, 'region', '1'),
('countries_argentina_santa_fe', 'ChIJ4YgIxK2ptZURSoACjR5299w', -31.6106578, -60.697294, 'region', '1'),
('countries_argentina_santiago_del_estero', 'ChIJa_kz32pSO5QR1shkd-0YnZo', -27.7833574, -64.264167, 'region', '1'),
('countries_argentina_san_juan', 'ChIJl9Q8oylAgZYRs_w8I6Cj878', -31.5351074, -68.5385941, 'region', '1'),
('countries_argentina_san_luis', 'ChIJzaZsGVQ51JURg8ye1LTjwn8', -33.3017267, -66.3377522, 'region', '1'),
('countries_argentina_tierra_del_fuego', 'ChIJISlD2c8iTLwRjdjwjDVU7oA', -54.3083548, -67.7451565, 'region', '1'),
('countries_argentina_tucuman', 'ChIJA2nF1pI3IpQRJ2XFtZJbjfg', -26.8082848, -65.2175903, 'region', '1'),
('countries_argentina_buenos_aires_9_de_abril', 'ChIJf7v5tBjOvJURpRn6aX39LWw', -34.7601843, -58.4868165, 'city', '1'),
('countries_spain_catalonia_viladecavalls', 'ChIJORG0UwONpBIRoBSkIeD6AAQ', 41.5546052, 1.9588007, 'city', '0'),
('countries_spain_catalonia_vilabella', 'ChIJUy5U0F74oxIR9FHy0NM-mm4', 41.2480731, 1.332462, 'city', '0'),
('countries_argentina_buenos_aires_acassuso', 'ChIJIYUQ5U6wvJUR_Wt0bqs61pw', -34.4752712, -58.496585, 'city', '1'),
('countries_argentina_buenos_aires_acevedo', 'ChIJQwLzqCHPuZUROCeosGbjJpk', -33.7535372, -60.4398186, 'city', '1'),
('countries_argentina_buenos_aires_adolfo_gonzales_chaves', 'ChIJdTYeLI4wkpURji7HDgfe3e4', -38.0324378, -60.0993683, 'city', '1'),
('countries_spain_catalonia_vielha_e_mijaran', 'ChIJUwmexnmQqBIRoMakIeD6AAQ', 42.7245643, 0.7722974, 'city', '0'),
('countries_argentina_buenos_aires_agustina', 'ChIJU9FpbIyOuJURKYmMHecSnAg', -34.460277, -61.0669063, 'city', '1'),
('countries_argentina_buenos_aires_alberti', 'ChIJqZYDlzfBvpURP6QyH1Fg1a4', -35.0316512, -60.2802699, 'city', '1'),
('countries_argentina_buenos_aires_aldo_bonzi', 'ChIJVd6hVeDOvJURYFLB2hVjmlM', -34.7075852, -58.517874, 'city', '1'),
('countries_spain_catalonia_verges', 'ChIJEw-j5w_3uhIRSeRK3kWHxUw', 42.0627053, 3.0425977, 'city', '0'),
('countries_argentina_buenos_aires_alejandro_korn', 'ChIJ4SWx5a8svZURGcTTjKxXAG8', -34.9896213, -58.3820098, 'city', '1'),
('countries_argentina_buenos_aires_alejandro_petion', 'ChIJnxuB82HfvJURBF8vPmXSZXg', -34.9789268, -58.6740609, 'city', '1'),
('countries_argentina_buenos_aires_algarrobo', 'ChIJ_T98_Rhp7pURUPfncL5GfPk', -38.8953916, -63.1354693, 'city', '1'),
('countries_spain_catalonia_vandellos', 'ChIJlwjn8aA-oRIRAiYalt2Rv7w', 40.9908991, 0.9236691, 'city', '0'),
('countries_argentina_buenos_aires_alsina', 'ChIJieM-NKW0u5URaxGEsRAPYvg', -33.9089655, -59.3901053, 'city', '1'),
('countries_argentina_buenos_aires_altamirano', 'ChIJ8WfFr8ClopURbgObC-St2Gk', -35.3614064, -58.1514285, 'city', '1'),
('countries_argentina_buenos_aires_america', 'ChIJvQz5TjvKvJURh47oiC6Bs6A', -34.6036844, -58.3815591, 'city', '1'),
('countries_argentina_buenos_aires_arenaza', 'ChIJtdr7LpQ5x5URqJxknsHjYWY', -34.9850237, -61.7742807, 'city', '1'),
('countries_argentina_buenos_aires_arrecifes', 'ChIJxfnUZMSduZUR9n8Sk2uPvHc', -34.0627823, -60.1027115, 'city', '1'),
('countries_spain_catalonia_vall_de_bianya', 'ChIJH9EwyudKpRIRUHGkIeD6AAQ', 42.2300898, 2.4406387, 'city', '0'),
('countries_argentina_buenos_aires_arroyo_dulce', 'ChIJhSdyna-ouZURQvuWUlzeg7o', -34.1001808, -60.4020687, 'city', '1'),
('countries_spain_catalonia_vacarisses', 'ChIJBwyUSV3zpBIRQ7eUeTXyZyk', 41.5951917, 1.9196949, 'city', '0'),
('countries_argentina_buenos_aires_asamblea', 'ChIJZz92o-flvpUR-2H-_OReeBI', -35.2256007, -60.4157124, 'city', '1'),
('countries_spain_catalonia_ullastrell', 'ChIJTXcdAbeNpBIR0LAdPPPfgCc', 41.5295517, 1.9636914, 'city', '0'),
('countries_argentina_buenos_aires_avellaneda', 'ChIJKwW9MFIzo5URMQqp7hgqY50', -34.6610756, -58.3669739, 'city', '1'),
('countries_argentina_buenos_aires_ayacucho', 'ChIJP5PM4MKYkJURCxqJ60GKEqk', -37.1502686, -58.4829712, 'city', '1'),
('countries_argentina_buenos_aires_azul', 'ChIJmQgtRrwnlJUR-cJxSs7nAuk', -36.7664063, -59.8671997, 'city', '1'),
('countries_argentina_buenos_aires_bahia_blanca', 'ChIJvQIT3Ku87ZUREXoeJI3Y0XY', -38.7183177, -62.2663478, 'city', '1'),
('countries_argentina_buenos_aires_baigorrita', 'ChIJjfsrFd-4uJURF3kpqslxZLE', -34.7442572, -60.9873013, 'city', '1'),
('countries_argentina_buenos_aires_balcarce', 'ChIJW65-Z2qvmpURe1Hkzw9llug', -37.8464067, -58.2554584, 'city', '1'),
('countries_argentina_buenos_aires_balneario_claromeco', 'ChIJpdpSZ6rDjZURqEWkWzAXqms', -38.8553243, -60.074066, 'city', '1'),
('countries_spain_catalonia_tossa_de_mar', 'ChIJWQShSgEQuxIR2Djjd8YfOEo', 41.7225184, 2.9302653, 'city', '0'),
('countries_spain_catalonia_torroella_de_fluvia', 'ChIJtTE8OLH0uhIRsHCkIeD6AAQ', 42.1752713, 3.0397249, 'city', '0'),
('countries_argentina_buenos_aires_banfield', 'ChIJZdY8-Uwto5UR1A8uXXuSoxk', -34.7456759, -58.3692798, 'city', '1'),
('countries_argentina_buenos_aires_baradero', 'ChIJ82xODk02upUR7gZ15ru7PW4', -33.812014, -59.50464, 'city', '1'),
('countries_spain_catalonia_torrent', 'ChIJEQBo_sdRYA0RDF-RKsYvI68', 39.4322368, -0.472373, 'city', '0'),
('countries_spain_catalonia_torrelles_de_llobregat', 'ChIJHe5D-a2EpBIRtokMpbrMPUc', 41.3592867, 1.9734743, 'city', '0'),
('countries_spain_catalonia_torrelles_de_foix', 'ChIJj1jzaT1ypBIR4BOkIeD6AAQ', 41.40055, 1.5693045, 'city', '0'),
('countries_spain_catalonia_tora_de_riubregos', 'ChIJHyaHdaAxpBIRCDupgNlgg50', 41.81054, 1.4036179, 'city', '0'),
('countries_argentina_buenos_aires_bella_vista', 'ChIJDSuZTsy9vJURgNfCQjcmDkY', -34.5637055, -58.6903973, 'city', '1'),
('countries_spain_catalonia_subirats', 'ChIJoYibXwJ9pBIR8BKkIeD6AAQ', 41.3971439, 1.8025852, 'city', '0'),
('countries_argentina_buenos_aires_benavidez', 'ChIJOWs1ApuhvJURq1Qux6afRc4', -34.4151715, -58.6867547, 'city', '1'),
('countries_spain_catalonia_sort', 'ChIJK5uxcWkEphIR8MSkIeD6AAQ', 42.4378504, 1.0873551, 'city', '0'),
('countries_argentina_buenos_aires_berazategui', 'ChIJv70vjDQvo5URBz-TdtJ7IYA', -34.762001, -58.2112961, 'city', '1'),
('countries_argentina_buenos_aires_berisso', 'ChIJG4pTmrDlopURSIBeUBgX-pk', -34.8795038, -57.8865025, 'city', '1'),
('countries_argentina_buenos_aires_bernal', 'ChIJXd0Lx_0xo5URrKtd8fMscGw', -34.7108688, -58.2800827, 'city', '1'),
('countries_spain_catalonia_solsona', 'ChIJhz6iJPzJpRIR1n9iUthRLPI', 41.9939512, 1.5160212, 'city', '0'),
('countries_argentina_buenos_aires_bonnement', 'ChIJ0X9Qw6zwl5UR0GXWRApza2k', -35.7177925, -58.4641037, 'city', '1'),
('countries_argentina_buenos_aires_bordenave', 'ChIJY9yRVWJD6ZUR-S_qVi3l1WI', -37.8031673, -63.0422868, 'city', '1'),
('countries_argentina_buenos_aires_bosques', 'ChIJTZC-GEgoo5URXqvj8exp8N0', -34.8250771, -58.2246208, 'city', '1'),
('countries_argentina_buenos_aires_boulogne', 'ChIJg5foeNy6vJURaix25G2GwYU', -34.4931066, -58.5919873, 'city', '1'),
('countries_argentina_buenos_aires_bragado', 'ChIJZXOYfyrcvpURcLfi5GqRzjg', -35.1154755, -60.4899413, 'city', '1'),
('countries_argentina_buenos_aires_brandsen', 'ChIJ2V8Dayu2opURDv2VSYwxzgo', -35.1679518, -58.2373784, 'city', '1'),
('countries_argentina_buenos_aires_burzaco', 'ChIJvXWZFJrUvJURdfGIk1GYH8w', -34.8286232, -58.3933342, 'city', '1'),
('countries_spain_catalonia_sentmenat', 'ChIJ3ZDYeIvqpBIRkBKkIeD6AAQ', 41.6113574, 2.1352039, 'city', '0'),
('countries_argentina_buenos_aires_campana', 'ChIJX86YM7Zzu5URHWZSQIzo-_c', -34.1643617, -58.9751378, 'city', '1'),
('countries_spain_catalonia_san_vicenc_de_torello', 'ChIJHeM5OMk6pRIRgXjT8UmWUO8', 42.0708787, 2.2581158, 'city', '0'),
('countries_argentina_buenos_aires_canning', 'ChIJNe4dU_rWvJURrXwwzbXs_y4', -34.8759735, -58.5065143, 'city', '1'),
('countries_argentina_buenos_aires_cantera_aguirre', 'ChIJNVj97qfmkJURuRa5VJ5nMzo', -37.3505342, -58.9980442, 'city', '1'),
('countries_spain_catalonia_sant_vicenc_de_montalt', 'ChIJHbVMkY81uxIRYBKkIeD6AAQ', 41.5789778, 2.5049414, 'city', '0'),
('countries_spain_catalonia_sant_vicenc_dels_horts', 'ChIJN0oOVcCapBIRW11qPlKsQeM', 41.3888363, 2.002836, 'city', '0'),
('countries_spain_catalonia_sant_salvador_de_guardiola', 'ChIJu79hpiNZpBIRNJGd-SlVUqs', 41.6774553, 1.7636181, 'city', '0'),
('countries_argentina_buenos_aires_carapachay', 'ChIJl4nwvr6wvJURVfifDIew_cQ', -34.5264942, -58.5360185, 'city', '1'),
('countries_spain_catalonia_sant_sadurni_d_anoia', 'ChIJA7L7NSVjpBIR4BCkIeD6AAQ', 41.4374918, 1.7830973, 'city', '0'),
('countries_argentina_buenos_aires_carlos_casares', 'ChIJK7mJOByCwJURS157O93mmvw', -35.6233827, -61.343025, 'city', '1'),
('countries_argentina_buenos_aires_carlos_spegazzini', 'ChIJXZ2yhvjYvJURAoKyTUfK-R8', -34.9263781, -58.5998975, 'city', '1'),
('countries_argentina_buenos_aires_carlos_tejedor', 'ChIJWUv90bg1wZURamN4dqpuspk', -35.3925291, -62.4218791, 'city', '1'),
('countries_argentina_buenos_aires_carmen_de_areco', 'ChIJnWIWSjjgu5URm7p8HYMIyzc', -34.3662434, -59.8211039, 'city', '1'),
('countries_argentina_buenos_aires_carmen_de_patagones', 'ChIJB7Bb25mi9pURjRVRTuwJlsQ', -40.7936301, -62.9877306, 'city', '1'),
('countries_argentina_buenos_aires_casbas', 'ChIJezDDS1gM6pURWdQKWlSG_Dc', -36.7590314, -62.5017783, 'city', '1'),
('countries_argentina_buenos_aires_caseros', 'ChIJo3-rjGm4vJURb1vHOOE_2MQ', -34.6094827, -58.5634631, 'city', '1'),
('countries_argentina_buenos_aires_castelar', 'ChIJC6bvnVTHvJURbLpS2bWqGJg', -34.6574616, -58.6439651, 'city', '1'),
('countries_argentina_buenos_aires_castelli', 'ChIJ1X7NABaumZUR13dMjdfulPw', -36.0858334, -57.8078142, 'city', '1'),
('countries_argentina_buenos_aires_castilla', 'ChIJz__AQ51WuZURIQwtgwmtAL8', -34.6123945, -59.9020067, 'city', '1'),
('countries_argentina_buenos_aires_chacabuco', 'ChIJceg_fywkuZURrXXGD8NIX5o', -34.6420841, -60.4715188, 'city', '1'),
('countries_spain_catalonia_sant_quinti_de_mediona', 'ChIJMyTSx4RvpBIRk0iAjD3hHJo', 41.4543156, 1.6614947, 'city', '0'),
('countries_argentina_buenos_aires_chillar', 'ChIJ34x6T4L5k5URueryipoKiiI', -37.3128384, -59.9852565, 'city', '1'),
('countries_argentina_buenos_aires_chivilcoy', 'ChIJk93l3DClvpURd0tvoCA65lo', -34.8969795, -60.0190731, 'city', '1'),
('countries_argentina_buenos_aires_city_bell', 'ChIJF4Hgz33eopURHnLp-NNxgBM', -34.8807236, -58.0572698, 'city', '1'),
('countries_argentina_buenos_aires_ciudadela', 'ChIJ_-UDQA_IvJURNSYAp7rISjg', -34.6352975, -58.5432951, 'city', '1'),
('countries_argentina_buenos_aires_ciudad_evita', 'ChIJDT1nc2PPvJURJXfb_ODATeE', -34.7226033, -58.5356477, 'city', '1'),
('countries_argentina_buenos_aires_claypole', 'ChIJ900utYMso5UR7wlQcVMD7cc', -34.8009732, -58.3421125, 'city', '1'),
('countries_spain_catalonia_sant_pol_de_mar', 'ChIJRwYkJII3uxIRkBCkIeD6AAQ', 41.6064873, 2.6139655, 'city', '0'),
('countries_argentina_buenos_aires_colonia_san_miguel_arcangel', 'ChIJK83PaOd16ZUR49IQ0X_08sQ', -37.4494332, -63.1197303, 'city', '1'),
('countries_argentina_buenos_aires_comandante_nicanor_otamendi', 'ChIJ2RBPKeE8hZURMLN4cwDX2uQ', -38.1105162, -57.8411524, 'city', '1'),
('countries_argentina_buenos_aires_conesa', 'ChIJBUe3URjauZURdgujhjxlDdo', -33.5957263, -60.3558277, 'city', '1'),
('countries_spain_catalonia_sant_pere_de_vilamajor', 'ChIJmbSktMLNpBIRgBCkIeD6AAQ', 41.7059896, 2.3912362, 'city', '0'),
('countries_argentina_buenos_aires_coronel_dorrego', 'ChIJozXvXwytkpURyrfLLvDoS6I', -38.7186346, -61.2884962, 'city', '1'),
('countries_argentina_buenos_aires_coronel_granada', 'ChIJwfvf4zD7xpURoBAmN69SX9g', -34.7900978, -62.2010113, 'city', '1'),
('countries_spain_catalonia_sant_pere_de_riudebitlles', 'ChIJCc1OExVlpBIRtLip8d7vLps', 41.4504992, 1.7044013, 'city', '1'),
('countries_argentina_buenos_aires_coronel_pringles', 'ChIJPcF38QHL7JUR5aUfvoW4Zns', -37.9852584, -61.3497918, 'city', '1'),
('countries_argentina_buenos_aires_coronel_segui', 'ChIJY7rEunbSvpURsjMuNoBCeDY', -34.8682377, -60.3913784, 'city', '1'),
('countries_spain_catalonia_sant_pere_de_ribes', 'ChIJ6xSOo5CAoxIRUBCkIeD6AAQ', 41.2570604, 1.7830973, 'city', '0'),
('countries_argentina_buenos_aires_coronel_vidal', 'ChIJVWTdYjXhmpURR8iUuZ7KB3s', -37.4464719, -57.7293011, 'city', '1'),
('countries_argentina_buenos_aires_corti', 'ChIJqfkrvLUJ7ZURNj6QrxJovuQ', -38.6166611, -62.0499992, 'city', '1'),
('countries_argentina_buenos_aires_costa_azul', 'ChIJoZwokutunJURFtVDffLxXjc', -36.6715028, -56.680823, 'city', '1'),
('countries_argentina_buenos_aires_costa_del_este', 'ChIJPTAUdQJtnJURZLSaY5omIQw', -36.6087864, -56.6880228, 'city', '1'),
('countries_spain_catalonia_sant_marti_sesgueioles', 'ChIJcwwxrvo4pBIR3TiXP06Q1uI', 41.7018468, 1.4912187, 'city', '1'),
('countries_argentina_buenos_aires_daireaux', 'ChIJqw56oNKZ6pURAzPKW_eJ3gU', -36.5994803, -61.7475931, 'city', '1'),
('countries_argentina_buenos_aires_darregueira', 'ChIJ2X59M3Fr6ZURr1QrW6kvoXw', -37.6893359, -63.1609664, 'city', '1'),
('countries_argentina_buenos_aires_del_carril', 'ChIJu5oAVDHAvZURKFSPTz35GnE', -35.5120644, -59.5146681, 'city', '1'),
('countries_argentina_buenos_aires_del_valle', 'ChIJMfU7CUTIv5URsmUvIkp6r88', -35.8985871, -60.7293153, 'city', '1'),
('countries_argentina_buenos_aires_del_viso', 'ChIJIbH1tj-ZvJURs-lbc3SzRjk', -34.4476799, -58.8052387, 'city', '1'),
('countries_argentina_buenos_aires_de_la_garma', 'ChIJi5d-jjutk5URc1iKqUasGRA', -37.9628516, -60.4131573, 'city', '1'),
('countries_argentina_buenos_aires_diecisiete_de_agosto', 'ChIJAyI3WyJR6ZURjYgj7N8m3Rw', -37.908459, -62.942181, 'city', '1'),
('countries_spain_catalonia_sant_marti_sarroca', 'ChIJr5FdZGlxpBIREBCkIeD6AAQ', 41.3797106, 1.627507, 'city', '0'),
('countries_argentina_buenos_aires_dock_sud', 'ChIJG2cO9V0zo5URSIbVINQM5u8', -34.6541394, -58.3479512, 'city', '1'),
('countries_argentina_buenos_aires_dolores', 'ChIJHfgFcFuemZURaw6JCIpLsDM', -36.3152317, -57.6753107, 'city', '1'),
('countries_argentina_buenos_aires_domselaar', 'ChIJ25ZpWTDMopUR9Re1HgCDb1U', -35.0733475, -58.2875325, 'city', '1'),
('countries_argentina_buenos_aires_don_bosco', 'ChIJC94IBw4yo5UR_sbHiFIaaS4', -34.6991161, -58.2966742, 'city', '1'),
('countries_argentina_buenos_aires_don_torcuato', 'ChIJ96XEl1K7vJURhAFLX1vo2ts', -34.4912685, -58.6355431, 'city', '1'),
('countries_argentina_buenos_aires_dudignac', 'ChIJ-dJQBP-uv5URoVeRM0wf_FU', -35.6502564, -60.7095689, 'city', '1'),
('countries_spain_catalonia_sant_llorenc_savall', 'ChIJo2jtULfupBIRMAhee2mYRO4', 41.6787856, 2.0584203, 'city', '0'),
('countries_argentina_buenos_aires_el_lenguaraz', 'ChIJUT41RGgkkJUR_0TxHo2O9hE', -38.0499992, -58.8499985, 'city', '1'),
('countries_argentina_buenos_aires_el_palomar', 'ChIJ1fifCFm4vJURZgoT0jTFN1Y', -34.6266731, -58.5943604, 'city', '1'),
('countries_argentina_buenos_aires_el_paraiso', 'ChIJOwWFnnnwuZURU8P7PBb20Ac', -33.5686183, -59.9803184, 'city', '1'),
('countries_argentina_buenos_aires_el_talar', 'ChIJUxvlDGOjvJURbH2kGtlKtGw', -34.4720967, -58.6540206, 'city', '1'),
('countries_spain_catalonia_sant_hipolit_de_voltrega', 'ChIJSWDMeWIkpRIRkEQzZ2tIA1M', 42.0158746, 2.2381726, 'city', '0'),
('countries_argentina_buenos_aires_ensenada', 'ChIJnWywwzjkopURpXMREgYQm5k', -34.8597, -57.8956237, 'city', '1'),
('countries_argentina_buenos_aires_ernestina', 'ChIJlXMMoITLvZURJVXNs6vF1GE', -35.2691352, -59.5572106, 'city', '1'),
('countries_argentina_buenos_aires_espartillar', 'ChIJE6eNIha265URNhKabf-Cr1c', -37.3610704, -62.4338725, 'city', '1'),
('countries_argentina_buenos_aires_etchegoyen', 'ChIJXXZlDL1_u5UR6iBHXYgVKWM', -34.4288755, -59.0747983, 'city', '1'),
('countries_argentina_buenos_aires_ezpeleta', 'ChIJrVwWFQMvo5URrw14gpGqJS4', -34.7412279, -58.2304053, 'city', '1'),
('countries_argentina_buenos_aires_felipe_sola', 'ChIJT08-YR8A7JURZOIZGCwK4M0', -38.0088263, -62.8165646, 'city', '1'),
('countries_argentina_buenos_aires_ferre', 'ChIJjcK4iQRuuJURo6FEXJxCDBc', -34.1263318, -61.1333924, 'city', '1'),
('countries_argentina_buenos_aires_florencio_varela', 'ChIJrSxVj2Ipo5URmUmDCbpVPYE', -34.7965806, -58.276012, 'city', '1'),
('countries_argentina_buenos_aires_florentino_ameghino', 'ChIJM_BNqdTyxpURGphhpQjRVRg', -34.8452168, -62.4664275, 'city', '1'),
('countries_argentina_buenos_aires_florida', 'ChIJYTnrd8y2vJUR2Whxk65MQ-4', -34.5329498, -58.4909058, 'city', '1'),
('countries_argentina_buenos_aires_florida_oeste', 'ChIJX7oVdSy3vJURSNEXG6_aCl0', -34.5386091, -58.5145868, 'city', '1'),
('countries_spain_catalonia_sant_genis_de_palafolls', 'ChIJ22yy38c9uxIRVGEYEMfdUSU', 41.6666957, 2.7473605, 'city', '0'),
('countries_argentina_buenos_aires_francisco_alvarez', 'ChIJPYX1cBORvJURbeT9Z1O1OGg', -34.6313033, -58.8545198, 'city', '1'),
('countries_argentina_buenos_aires_francisco_madero', 'ChIJw8qMtdL_wJUReY0AgcblFlk', -35.847873, -62.070054, 'city', '1'),
('countries_argentina_buenos_aires_gahan', 'ChIJ5eCbv0VpuZUR6zzjU6RuLTE', -34.3370056, -60.0971521, 'city', '1'),
('countries_argentina_buenos_aires_garin', 'ChIJJfioVt6hvJUR7_4ZEO6dyuQ', -34.4162121, -58.7336212, 'city', '1'),
('countries_argentina_buenos_aires_garre', 'ChIJLeH0q4zkwZURwDXxsGFPseE', -36.5603935, -62.6014861, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_argentina_buenos_aires_general_alvear', 'ChIJU8PSVjD4lZURjOYYkv8DZck', -36.0217066, -60.0145232, 'city', '1'),
('countries_spain_catalonia_sant_fost_de_campsentelles', 'ChIJs68SxDO5pBIRmxtJjr4AZWI', 41.5096571, 2.2335066, 'city', '0'),
('countries_spain_catalonia_sant_feliu_sasserra', 'ChIJT-xqS_wcpRIRnCe9kFzSs9A', 41.9444613, 2.0207516, 'city', '0'),
('countries_argentina_buenos_aires_general_guido', 'ChIJZfqGgvIompURuVwhp9cnAo0', -36.6416578, -57.7921213, 'city', '1'),
('countries_argentina_buenos_aires_general_hornos', 'ChIJd9muWav6vJURsIPecjwop0Q', -34.8921296, -58.9188543, 'city', '1'),
('countries_argentina_buenos_aires_general_juan_madariaga', 'ChIJkyBwfmSdm5URCR61HG4Bc2c', -37.0162988, -57.1321518, 'city', '1'),
('countries_argentina_buenos_aires_general_las_heras', 'ChIJD1Kae-vwvJURI16Fi8EIwCk', -34.9267359, -58.946704, 'city', '1'),
('countries_argentina_buenos_aires_general_lavalle', 'ChIJU9IcoTH_m5UR2wqFCwJTfoc', -36.406402, -56.9433384, 'city', '1'),
('countries_argentina_buenos_aires_general_la_madrid', 'ChIJoz2-90bKlJURMMzeOkRiVoA', -37.2496772, -61.2621919, 'city', '1'),
('countries_spain_catalonia_sant_feliu_de_guixols', 'ChIJrzsN3CEEuxIRYG6kIeD6AAQ', 41.7859253, 3.0125674, 'city', '0'),
('countries_argentina_buenos_aires_general_pacheco', 'ChIJ0crcX46kvJURgR7_yfEojeE', -34.4565144, -58.630106, 'city', '1'),
('countries_argentina_buenos_aires_general_pinto', 'ChIJaRFFT50Qx5UR4lMajLSK9Dc', -34.7643401, -61.891533, 'city', '1'),
('countries_spain_catalonia_sant_feliu_de_codines', 'ChIJ0w7y4FvCpBIRJtnGC2r3AHM', 41.6956211, 2.1597595, 'city', '0'),
('countries_argentina_buenos_aires_general_rojo', 'ChIJCRoaIvZht5URoGpuYtKD4pM', -33.4740675, -60.2881317, 'city', '1'),
('countries_spain_catalonia_sant_esteve_de_palautordera', 'ChIJYaclzgrNpBIR0A6kIeD6AAQ', 41.7102452, 2.4258123, 'city', '0'),
('countries_argentina_buenos_aires_general_viamonte', 'ChIJpQSEX1xLv5URXmh8kffXbHU', -35.0002899, -61.0384266, 'city', '1'),
('countries_argentina_buenos_aires_general_villegas', 'ChIJZ0OWZCw7xJUR33rC2MsB6lQ', -35.0326402, -63.0148417, 'city', '1'),
('countries_argentina_buenos_aires_gerli', 'ChIJw4RSqdLMvJUR64e9Ea20DcQ', -34.6846809, -58.3720894, 'city', '1'),
('countries_argentina_buenos_aires_germania', 'ChIJHamE45aqx5URjz6sZc0j1Z0', -34.5761398, -62.0508394, 'city', '1'),
('countries_argentina_buenos_aires_glew', 'ChIJHR_tiEXVvJURQ-Myax9BkSA', -34.8884013, -58.3901407, 'city', '1'),
('countries_argentina_buenos_aires_gobernador_castro', 'ChIJ34ufb6j1uZURsHqmUldfRuU', -33.6589312, -59.8685346, 'city', '1'),
('countries_argentina_buenos_aires_gobernador_ugarte', 'ChIJ8wgONQGRvpUR4ELJZCU5Odg', -35.1659048, -60.0804412, 'city', '1'),
('countries_spain_catalonia_sant_cugat_sesgarrigues', 'ChIJS4jU3_R7pBIRWAwkIie3Fl8', 41.3629043, 1.7490143, 'city', '0'),
('countries_spain_catalonia_sant_cugat_del_valles', 'ChIJNfOVZSuRpBIRsA6kIeD6AAQ', 41.4664438, 2.0701279, 'city', '0'),
('countries_argentina_buenos_aires_grand_bourg', 'ChIJ38ji1oSivJUR3Uwfo8BDQAM', -34.486068, -58.7250438, 'city', '1'),
('countries_argentina_buenos_aires_guernica', 'ChIJ28cpw5AqvZUR9Ur9z2A1kJQ', -34.9131722, -58.400956, 'city', '1'),
('countries_argentina_buenos_aires_haedo', 'ChIJsXo5c4LHvJURV8SwETtok1A', -34.6440676, -58.5956428, 'city', '1'),
('countries_argentina_buenos_aires_henderson', 'ChIJX-nWe7wiwJURKo2ZpKQ_AiE', -36.2981457, -61.7184579, 'city', '1'),
('countries_argentina_buenos_aires_hilario_ascasubi', 'ChIJsR5DmIYa8pURQjBKQA1XjZY', -39.3752234, -62.6465704, 'city', '1'),
('countries_spain_catalonia_sant_climent_de_llobregat', 'ChIJHaxy9FGDpBIRoA6kIeD6AAQ', 41.3290475, 1.9832594, 'city', '0'),
('countries_argentina_buenos_aires_hurlingham', 'ChIJ9T0ITCW5vJURrHuToNwztoc', -34.589571, -58.6275502, 'city', '1'),
('countries_argentina_buenos_aires_indio_rico', 'ChIJPWdDIhPpkpUR3lr80k4GMiE', -38.330397, -60.8856267, 'city', '1'),
('countries_spain_catalonia_sant_celoni', 'ChIJcQ2ZVAIzuxIRcP9Iia1pzm4', 41.6826815, 2.5495112, 'city', '0'),
('countries_argentina_buenos_aires_ingeniero_adolfo_sourdeaux', 'ChIJB45fobO8vJUReITc8tO0Bbg', -34.50126, -58.6601456, 'city', '1'),
('countries_argentina_buenos_aires_ingeniero_budge', 'ChIJ50NFYHbOvJUR68Y8wYcNCG0', -34.7353046, -58.4609144, 'city', '1'),
('countries_argentina_buenos_aires_ingeniero_maschwitz', 'ChIJOfzPCxKgvJURzejvvWAyK5g', -34.3912154, -58.7384929, 'city', '1'),
('countries_argentina_buenos_aires_isidro_casanova', 'ChIJyZ2GU2nGvJUR-ussOkAdIkY', -34.7084659, -58.5858675, 'city', '1'),
('countries_argentina_buenos_aires_jeppener', 'ChIJ91mwGWKwopURwm3uMF_BtxU', -35.2796899, -58.1977981, 'city', '1'),
('countries_spain_catalonia_sant_carles_de_la_rapita', 'ChIJ5aQZHUVVoBIRlwQVgklstQM', 40.6279226, 0.6251541, 'city', '0'),
('countries_argentina_buenos_aires_jose_leon_suarez', 'ChIJk1JXKUe6vJURXLgA7TM_xZY', -34.529389, -58.5734048, 'city', '1'),
('countries_spain_catalonia_sant_andreu_de_llavaneres', 'ChIJG-55HGE1uxIRMA6kIeD6AAQ', 41.579406, 2.4851463, 'city', '0'),
('countries_spain_catalonia_sant_adria_de_besos', 'ChIJw3gOXaq8pBIRAA6kIeD6AAQ', 41.42668, 2.2245813, 'city', '0'),
('countries_spain_catalonia_santa_susanna', 'ChIJhzBX4FU5uxIRMBKkIeD6AAQ', 41.6545038, 2.6934166, 'city', '0'),
('countries_spain_catalonia_santa_oliva', 'ChIJ3zdBdcCKoxIRjKWxSUagJzc', 41.2454259, 1.5450766, 'city', '0'),
('countries_spain_catalonia_santa_maria_de_palautordera', 'ChIJxxlRvs_MpBIREBKkIeD6AAQ', 41.6933702, 2.4458308, 'city', '0'),
('countries_argentina_buenos_aires_junin', 'ChIJZYW96zPruJUR5xPPTP6vUvs', -34.5885499, -60.949554, 'city', '1'),
('countries_spain_catalonia_santa_maria_de_martorelles', 'ChIJ0U8_YQ25pBIRvD-qXC-LUsY', 41.5166241, 2.2605775, 'city', '0'),
('countries_spain_catalonia_santa_cristina_de_aro', 'ChIJjcNQJ58DuxIRoG-kIeD6AAQ', 41.8312825, 2.9875565, 'city', '0'),
('countries_argentina_buenos_aires_laguna_alsina', 'ChIJE5KGxuJl6pURl2SwwfSNFHk', -36.8080047, -62.245042, 'city', '1'),
('countries_spain_catalonia_santa_coloma_de_gramenet', 'ChIJ_1XjxIy8pBIRMBGkIeD6AAQ', 41.4551421, 2.2089109, 'city', '0'),
('countries_spain_catalonia_santa_coloma_de_cervello', 'ChIJpztuUwmbpBIRIBGkIeD6AAQ', 41.36846, 2.0224213, 'city', '0'),
('countries_argentina_buenos_aires_las_flores', 'ChIJCeuXNyk1lpUR7paT5P1-cjc', -36.0141576, -59.0992986, 'city', '1'),
('countries_spain_catalonia_salt', 'ChIJBcZThU7nuhIR1z9l21xXUdk', 41.9700647, 2.7929203, 'city', '0'),
('countries_argentina_buenos_aires_las_toninas', 'ChIJW0QDIYIRnJURavt1qj4c4QM', -36.4870244, -56.6931113, 'city', '1'),
('countries_argentina_buenos_aires_las_toscas', 'ChIJo76uK93FwJURbX8OdiLdIro', -35.3644043, -61.8058221, 'city', '1'),
('countries_argentina_buenos_aires_la_dulce', 'ChIJ3VkThYgpjpURQvWqgUFW9Gs', -38.2837605, -59.203163, 'city', '1'),
('countries_argentina_buenos_aires_la_emilia', 'ChIJKZfp9Odlt5URBFEiJBMH0vk', -33.348589, -60.3154333, 'city', '1'),
('countries_argentina_buenos_aires_la_lucila', 'ChIJx-dlrhKxvJURu5X8ZqO1RSQ', -34.4987, -58.4887803, 'city', '1'),
('countries_argentina_buenos_aires_la_plata', 'ChIJoYUAHyvmopUR4xJzVPBE_Lw', -34.9204948, -57.9535657, 'city', '1'),
('countries_argentina_buenos_aires_la_violeta', 'ChIJi3p2ckPquZUR4Z_TQ4PlNyo', -33.7330102, -60.1685441, 'city', '1'),
('countries_argentina_buenos_aires_leandro_n_alem', 'ChIJdQy0gDx8x5UR3ieIBcwfCKY', -34.5195144, -61.3913566, 'city', '1'),
('countries_argentina_buenos_aires_libertad', 'ChIJLzawYPzAvJUR8RXodOi4hmU', -34.7003212, -58.6834717, 'city', '1'),
('countries_argentina_buenos_aires_lima', 'ChIJbSCZP9Wlu5URDPHcgEijX_w', -34.0447565, -59.1961093, 'city', '1'),
('countries_argentina_buenos_aires_lincoln', 'ChIJZcddEV9Dx5URUDnAR99yUq0', -34.8684492, -61.5290906, 'city', '1'),
('countries_argentina_buenos_aires_lin_calel', 'ChIJo6UM5Z2SjZURiUR6B1SPtUo', -38.7065975, -60.2437124, 'city', '1'),
('countries_argentina_buenos_aires_llavallol', 'ChIJ-5yQrbPTvJURby5723QrKE4', -34.7965057, -58.4292259, 'city', '1'),
('countries_spain_catalonia_salou', 'ChIJ93ilr4JZoRIRUYXO4oP1Ftk', 41.0777465, 1.1315926, 'city', '0'),
('countries_argentina_buenos_aires_lobos', 'ChIJf0inZ6wAvZURT5HurgUG42E', -35.176526, -59.0975089, 'city', '1'),
('countries_argentina_buenos_aires_lomas_del_mirador', 'ChIJF8Cfq4zIvJURM4mnmXol7Nk', -34.6663627, -58.5297986, 'city', '1'),
('countries_argentina_buenos_aires_lomas_de_zamora', 'ChIJdfv4q2HSvJURMjByYp8RtNM', -34.7611823, -58.4302476, 'city', '1'),
('countries_argentina_buenos_aires_longchamps', 'ChIJaXr7DSHVvJURyGvR_vxoYgk', -34.8627397, -58.3894481, 'city', '1'),
('countries_argentina_buenos_aires_los_cardales', 'ChIJ6U8yaJZ7u5URvBjXVDu0IxI', -34.3287718, -58.9807583, 'city', '1'),
('countries_argentina_buenos_aires_los_polvorines', 'ChIJ81D4MyyjvJURBExNM5AKxnc', -34.4996258, -58.6914464, 'city', '1'),
('countries_argentina_buenos_aires_lozano', 'ChIJ4dtZq4P2vJUR0Rp3D2XQDJc', -34.85, -59.05, 'city', '1'),
('countries_spain_catalonia_saldes', 'ChIJKYgccaSYpRIRwA2kIeD6AAQ', 42.232893, 1.7441475, 'city', '0'),
('countries_argentina_buenos_aires_luis_guillon', 'ChIJfW45XtLTvJUR-zua-aHhi-s', -34.7998811, -58.4513637, 'city', '1'),
('countries_argentina_buenos_aires_lujan', 'ChIJQcZkpod9vJURriJTxZaHCVU', -34.5633312, -59.1208805, 'city', '1'),
('countries_spain_catalonia_roses', 'ChIJCVJ1C01huhIRyyzVE2hp7us', 42.2605204, 3.2080991, 'city', '0'),
('countries_spain_catalonia_roda_de_bera', 'ChIJW4uSqYzzoxIRQGClIeD6AAQ', 41.1870398, 1.4603319, 'city', '0'),
('countries_spain_catalonia_ripoll', 'ChIJg_9bNDE_pRIRoG2kIeD6AAQ', 42.1954115, 2.2039933, 'city', '0'),
('countries_argentina_buenos_aires_manuel_alberti', 'ChIJ7--E90-DvJURxBJEuO6H1KM', -34.483611, -58.931944, 'city', '1'),
('countries_argentina_buenos_aires_manuel_b_gonnet', 'ChIJs8vQ4ezdopURXH4YzFk0MXk', -34.8889618, -58.021431, 'city', '1'),
('countries_argentina_buenos_aires_manuel_j_cobo', 'ChIJvTlvIUFPmJURC-G7vJ-6ff8', -35.8728311, -57.8971069, 'city', '1'),
('countries_argentina_buenos_aires_manuel_ocampo', 'ChIJAYmmCBYyuJURR9_jRv8hp-k', -33.7645123, -60.6514013, 'city', '1'),
('countries_argentina_buenos_aires_maquinista_savio', 'ChIJC3uBHwifvJUR8i46G0UnNd0', -34.4085349, -58.7701479, 'city', '1'),
('countries_argentina_buenos_aires_marcos_paz', 'ChIJm6c9WRjsvJURRrMYzCFTfOo', -34.7823358, -58.8377795, 'city', '1'),
('countries_argentina_buenos_aires_mariano_acosta', 'ChIJgVk1YKOUvJURZCFJLtIUgz0', -34.6875676, -58.8198206, 'city', '1'),
('countries_spain_catalonia_rajadell', 'ChIJnf-5yvJapBIRTXXkdeW6CkY', 41.7284297, 1.7061442, 'city', '1'),
('countries_spain_catalonia_rabos', 'ChIJlRwh-nOGuhIRMNPuYbVBUMw', 42.4026078, 3.0476046, 'city', '0'),
('countries_spain_catalonia_quart_d_onyar', 'ChIJu3bbgmzhuhIRJhgVcNaXDL8', 41.9378031, 2.8410675, 'city', '0'),
('countries_spain_catalonia_puigpelat', 'ChIJC5EZOVcHpBIRUkprVh1_ryc', 41.2785243, 1.3035514, 'city', '0'),
('countries_argentina_buenos_aires_mar_del_plata', 'ChIJCULTGU3ZhJURJtH-S4Bwlt0', -38.0054771, -57.5426106, 'city', '1'),
('countries_spain_catalonia_portbou', 'ChIJU2GyIR98uhIR_gkXXz-WjVM', 42.4245988, 3.1428341, 'city', '0'),
('countries_spain_catalonia_ponts', 'ChIJCdGBVyx-phIREMOkIeD6AAQ', 41.9036488, 1.1833043, 'city', '0'),
('countries_argentina_buenos_aires_mar_de_las_pampas', 'ChIJ8epU-tBdm5URKeOSk3djW3Q', -37.3257858, -57.0222331, 'city', '1'),
('countries_argentina_buenos_aires_matheu', 'ChIJO5uVIgFiu5URRaTNOyLuZ4c', -34.3815187, -58.8236347, 'city', '1'),
('countries_spain_catalonia_pontons', 'ChIJMdtVEzgNpBIRgAykIeD6AAQ', 41.4162825, 1.5160212, 'city', '0'),
('countries_argentina_buenos_aires_mayor_buratovich', 'ChIJkwhT_7II8pURQ4K1THsB1A8', -39.2611608, -62.6106831, 'city', '1'),
('countries_spain_catalonia_polinya', 'ChIJ-fVuTcK_pBIRh9nM7HVZuSc', 41.5560111, 2.1597595, 'city', '0'),
('countries_argentina_buenos_aires_mechita', 'ChIJ11-NAbDcvpURzaXKkKj8T08', -35.0692665, -60.4079558, 'city', '1'),
('countries_spain_catalonia_platja_d_aro', 'ChIJN2HiFd8AuxIRM0kjmgULOYw', 41.8297094, 3.0476046, 'city', '0'),
('countries_argentina_buenos_aires_melchor_romero', 'ChIJg-Bbp9zcopUR8isMqnj3_Yk', -34.9434382, -58.034701, 'city', '1'),
('countries_argentina_buenos_aires_mercedes', 'ChIJW-SlyhNzvJUROrsJeKdjb8g', -34.6510201, -59.4305996, 'city', '1'),
('countries_argentina_buenos_aires_merlo', 'ChIJa92TQEOVvJUReKLkVfcy2Fg', -34.6685004, -58.7282483, 'city', '1'),
('countries_argentina_buenos_aires_ministro_rivadavia', 'ChIJk2_f_fgqo5URzQld6GVoPVk', -34.8517337, -58.3328766, 'city', '1'),
('countries_argentina_buenos_aires_miramar', 'ChIJbcs8jZgQhZURWYskUjMJTYk', -38.2703168, -57.8394498, 'city', '1'),
('countries_spain_catalonia_pineda_de_mar', 'ChIJE5k3NDE5uxIRf7je7YXc04g', 41.6350339, 2.6735412, 'city', '0'),
('countries_argentina_buenos_aires_monte_chingolo', 'ChIJ01ga5l0to5URCEt-rfyarRo', -34.7280303, -58.3541907, 'city', '1'),
('countries_argentina_buenos_aires_monte_grande', 'ChIJb5pNjuHTvJURZ3byY_4mfkA', -34.8271786, -58.4620124, 'city', '1'),
('countries_argentina_buenos_aires_monte_hermoso', 'ChIJh2DKy5BSjZURivyuUo2VUGI', -38.9878667, -61.287567, 'city', '1'),
('countries_spain_catalonia_piera', 'ChIJeYSjQ6xmpBIREAykIeD6AAQ', 41.518091, 1.7441475, 'city', '0'),
('countries_spain_catalonia_parets_del_valles', 'ChIJD014B7C4pBIR7g8oZ_-GcHY', 41.564686, 2.2285864, 'city', '0'),
('countries_spain_catalonia_pals', 'ChIJGcmG4JFWuhIR9rUDdyIUdZ0', 41.9851158, 3.1679257, 'city', '0'),
('countries_spain_catalonia_palafrugell', 'ChIJQYf5fF5UuhIRNjkOk6nsHYo', 41.9179145, 3.1628837, 'city', '0'),
('countries_argentina_buenos_aires_munro', 'ChIJwVNNZMawvJURg6dq1bDWDJw', -34.5304233, -58.5243501, 'city', '1'),
('countries_argentina_buenos_aires_navarro', 'ChIJm2mjHBxQvJUR2lL9QAi2j7s', -35.0058318, -59.2783596, 'city', '1'),
('countries_argentina_buenos_aires_necochea', 'ChIJ6ekwQ0O9j5URIrNvJ5nA9wc', -38.5544968, -58.7396088, 'city', '1'),
('countries_argentina_buenos_aires_norberto_de_la_riestra', 'ChIJa2RGB0IrvJUR6wkKYSp8JSo', -35.2732846, -59.7755179, 'city', '1'),
('countries_spain_catalonia_ordis', 'ChIJaWXdC92SuhIRmR9mFjhFd3c', 42.2146833, 2.8926342, 'city', '0'),
('countries_spain_catalonia_olost', 'ChIJryK05hUZpRIRUAukIeD6AAQ', 41.989812, 2.0959429, 'city', '0'),
('countries_argentina_buenos_aires_olavarria', 'ChIJo5CertpFlJURcvDbE7OtGtE', -36.8937167, -60.3233499, 'city', '1'),
('countries_argentina_buenos_aires_olivos', 'ChIJN4kB1EexvJUR9xjaanymMPo', -34.5105515, -58.4963913, 'city', '1'),
('countries_argentina_buenos_aires_open_door', 'ChIJfToou2mAvJURI4tdBzA8Lxo', -34.49112, -59.0752241, 'city', '1'),
('countries_argentina_buenos_aires_orense', 'ChIJ6wkDfqULjpURIdKVqz9Re0I', -38.6882636, -59.7807589, 'city', '1'),
('countries_argentina_buenos_aires_oriente', 'ChIJWy2rM8F4jZURmLyFh6xjrIo', -38.7443398, -60.6094386, 'city', '1'),
('countries_argentina_buenos_aires_ostende', 'ChIJMSCrPBudnJURAduYyBxE9eQ', -37.1250381, -56.8838234, 'city', '1'),
('countries_argentina_buenos_aires_o_higgins', 'ChIJI-HuFJPduJURBDBO9vJ7hD0', -34.5841342, -60.6996936, 'city', '1'),
('countries_argentina_buenos_aires_pasman', 'ChIJGecOyH2r65URQ6G80YYOo_o', -37.2236087, -62.1647158, 'city', '1'),
('countries_argentina_buenos_aires_paso_del_rey', 'ChIJMa-2UpqVvJURs8A9jnY5A4U', -34.6315538, -58.7404704, 'city', '1'),
('countries_argentina_buenos_aires_pasteur', 'ChIJ5dl3wxPQxpURinMvmCjptdc', -35.1413333, -62.2439907, 'city', '1'),
('countries_argentina_buenos_aires_pedernales', 'ChIJM36FLhbNvZURyhXkqro63cw', -35.2622632, -59.6310409, 'city', '1'),
('countries_argentina_buenos_aires_pedro_luro', 'ChIJHyjojoYY8pUR7OR93uqrSss', -39.5027145, -62.6869493, 'city', '1'),
('countries_argentina_buenos_aires_pehuajo', 'ChIJ86BrWCz4wJURA89cs7G_REg', -35.8107166, -61.8987832, 'city', '1'),
('countries_spain_catalonia_olivella', 'ChIJpz5d9DV-pBIRXEqszrp2npo', 41.3100908, 1.8123761, 'city', '0'),
('countries_argentina_buenos_aires_pereyra', 'ChIJZdYV5LLYopUR03ITeNan8kA', -34.8428513, -58.1532656, 'city', '1'),
('countries_spain_catalonia_olius', 'ChIJO1wC3wW2pRIR8MGkIeD6AAQ', 42.0182619, 1.5499211, 'city', '0'),
('countries_argentina_buenos_aires_pergamino', 'ChIJMQr2Pq1KuJURxelieSfDGkg', -33.8912831, -60.5745999, 'city', '1'),
('countries_argentina_buenos_aires_piedritas', 'ChIJATz4VEPSxZURYdiGHL1zONo', -34.7718433, -62.9859805, 'city', '1'),
('countries_spain_catalonia_oliana', 'ChIJM4fVOZ_QpRIRk0aC73gpLzk', 42.0954215, 1.3131861, 'city', '0'),
('countries_argentina_buenos_aires_pila', 'ChIJiwenDIExmJURIcEyM5VmZTo', -35.999892, -58.1456885, 'city', '1'),
('countries_argentina_buenos_aires_pilar', 'ChIJAyA9ZLacvJURNrY09gIE2qg', -34.4663154, -58.9153722, 'city', '1'),
('countries_argentina_buenos_aires_pinamar', 'ChIJl5r3aOWcnJURGYSMQwRXRLM', -37.1145662, -56.8607055, 'city', '1'),
('countries_argentina_buenos_aires_pirovano', 'ChIJu4oTC02k6pURVxOI3z5w6SA', -36.5105488, -61.5550059, 'city', '1'),
('countries_spain_catalonia_olesa_de_bonesvalls', 'ChIJHR8RzkmHpBIRIAukIeD6AAQ', 41.3561415, 1.8611011, 'city', '0'),
('countries_argentina_buenos_aires_plomer', 'ChIJV9cxB_L0vJUR96JEpFSREIg', -34.7932101, -59.0301302, 'city', '1'),
('countries_argentina_buenos_aires_pontevedra', 'ChIJGxz-bR_CvJURmK6oiN02L-8', -34.744264, -58.7001579, 'city', '1'),
('countries_argentina_buenos_aires_presidente_derqui', 'ChIJ_zB5eJWbvJUROlXkjuxQJ7I', -34.4904459, -58.8402383, 'city', '1'),
('countries_argentina_buenos_aires_puan', 'ChIJVXtUnAbZ65URa3boTIJHgA4', -37.5455602, -62.7660962, 'city', '1'),
('countries_argentina_buenos_aires_punta_alta', 'ChIJT7LKHeJ37ZURTzO5g4vZfpw', -38.8766081, -62.0707813, 'city', '1'),
('countries_spain_catalonia_navarcles', 'ChIJc9pGLvr5pBIRWvK8qpzsDzU', 41.7497243, 1.9148091, 'city', '0'),
('countries_spain_catalonia_montseny', 'ChIJlbTlID7SpBIRVmE5yPPzZJA', 41.7855837, 2.3912362, 'city', '0'),
('countries_argentina_buenos_aires_quilmes', 'ChIJd1df5Dguo5URT1I0E8Lahmo', -34.7206336, -58.2546051, 'city', '1'),
('countries_spain_catalonia_montornes_del_valles', 'ChIJ2Qgad1S4pBIRLh3SSuDlAto', 41.5445244, 2.2670286, 'city', '0'),
('countries_argentina_buenos_aires_rafael_calzada', 'ChIJmzNlicAso5URzKL6oNws8yw', -34.7898171, -58.3537724, 'city', '1'),
('countries_argentina_buenos_aires_rafael_castillo', 'ChIJE_mmiJnGvJURIFoX-aVHpoo', -34.7093805, -58.6236754, 'city', '1'),
('countries_argentina_buenos_aires_ramallo', 'ChIJZ9BK96L8uZURWkfO0cddS_U', -33.4850695, -60.0045531, 'city', '1'),
('countries_argentina_buenos_aires_ramos_mejia', 'Ej1BcmdlbnRpbmEsIFJhbW9zIE1lasOtYSwgUHJvdmluY2lhIGRlIEJ1ZW5vcyBBaXJlcywgQXJnZW50aW5hIi4qLAoUChIJA2hi34HIvJURgfZjsASe-4ASFAoSCaN1qzvZx7yVEduj3skLFP6q', -34.6609822, -58.5661084, 'city', '1'),
('countries_argentina_buenos_aires_ranchos', 'ChIJQbBmdYQAmJURY7q2AfYlr_c', -35.516397, -58.3189242, 'city', '1'),
('countries_argentina_buenos_aires_ranelagh', 'ChIJMTzOIoYoo5UR3E1wQGmNEAQ', -34.7960011, -58.1946849, 'city', '1'),
('countries_argentina_buenos_aires_rauch', 'ChIJienXzGknl5URwJLMCcklgDk', -36.7749176, -59.0897865, 'city', '1'),
('countries_spain_catalonia_montmelo', 'ChIJJc49I-m4pBIRHWX9Jh41fMY', 41.5567683, 2.2507317, 'city', '0'),
('countries_argentina_buenos_aires_remedios_de_escalada', 'ChIJIbUHC2bNvJURfGNjhxOc2xA', -34.7212143, -58.39851, 'city', '1'),
('countries_argentina_buenos_aires_rincon_de_milberg', 'ChIJh2SdWB2kvJURtb1JRZIG_Z4', -34.4142756, -58.6080344, 'city', '1'),
('countries_argentina_buenos_aires_rio_tala', 'ChIJvwZraNw6upUR0nFNpWp6ruA', -33.7692611, -59.6394599, 'city', '1'),
('countries_argentina_buenos_aires_rivera', 'ChIJB83U8p6_6ZUR2PUwtoe1OLU', -37.1605336, -63.24179, 'city', '1'),
('countries_argentina_buenos_aires_roberts', 'ChIJy_Lu1wIsx5URIuS5ZclirKk', -35.1420915, -61.9721725, 'city', '1'),
('countries_argentina_buenos_aires_rojas', 'ChIJz6c1sRZXuJUROB6T34N22k8', -34.197698, -60.7338035, 'city', '1'),
('countries_argentina_buenos_aires_roque_perez', 'ChIJCbh9Ln-8vZURS8uWF835Euo', -35.4006236, -59.3348143, 'city', '1'),
('countries_spain_catalonia_montcada_i_reixac', 'ChIJBUst7za8pBIRQ_CRyWuuI8c', 41.4904225, 2.1941598, 'city', '0'),
('countries_argentina_buenos_aires_saenz_pena', 'ChIJ61n5bpW3vJURoA8AO3RZ7p0', -34.5992073, -58.5316821, 'city', '1'),
('countries_argentina_buenos_aires_saladillo', 'ChIJkbiEO-_gvZUR7HxzIglfEh0', -35.6388799, -59.7794795, 'city', '1'),
('countries_argentina_buenos_aires_salazar', 'ChIJbxnJ1BfJwZURP93ZpNzEVq8', -36.3102988, -62.2085048, 'city', '1'),
('countries_argentina_buenos_aires_saldungaray', 'ChIJt_gt_RXm7JURQ8DCdAU5saE', -38.2051334, -61.7697166, 'city', '1'),
('countries_argentina_buenos_aires_salliquelo', 'ChIJ-QmX93gHwpUReTs1hH5jjY8', -36.7494478, -62.9654548, 'city', '1'),
('countries_argentina_buenos_aires_salto', 'ChIJ7UxWGJESuZURPCKinYdLbis', -34.295047, -60.2473787, 'city', '1'),
('countries_argentina_buenos_aires_santa_clara_del_mar', 'ChIJJ4rQ_HnRhJURFBvh3wLXw8A', -37.8367878, -57.5130201, 'city', '1'),
('countries_argentina_buenos_aires_santa_lucia', 'ChIJUUaC58WHuZURUsWYfe7Oilw', -33.8785467, -59.8728273, 'city', '1'),
('countries_argentina_buenos_aires_santa_regina', 'ChIJH6eJ8DvAxZURu1VWzvreWTU', -34.5470498, -63.1752306, 'city', '1'),
('countries_argentina_buenos_aires_santa_teresita', 'ChIJG3GuVU0SnJUR56AY0ubYMxw', -36.5293063, -56.6962517, 'city', '1'),
('countries_argentina_buenos_aires_santos_lugares', 'ChIJ3yD0gY23vJURL6ol1qKiAJY', -34.5990645, -58.5467344, 'city', '1'),
('countries_argentina_buenos_aires_san_andres', 'ChIJM9UVHUS3vJUR2qOHkQacViM', -34.5564986, -58.5361078, 'city', '1'),
('countries_argentina_buenos_aires_san_andres_de_giles', 'ChIJ7ZHkWuuMu5UR8exYj3imj2E', -34.4429759, -59.4472466, 'city', '1'),
('countries_argentina_buenos_aires_san_antonio_de_areco', 'ChIJwbCE_DOVu5URf7JlOr221jM', -34.2436166, -59.4738665, 'city', '1'),
('countries_argentina_buenos_aires_san_antonio_de_padua', 'ChIJlZ7KB4e_vJURKeVjNPAlS3o', -34.6666718, -58.7000008, 'city', '1'),
('countries_argentina_buenos_aires_san_bernardo', 'ChIJD7BD3hpvnJUR769ON1nepZo', -36.6863655, -56.6791979, 'city', '1'),
('countries_argentina_buenos_aires_san_bernardo_del_tuyu', 'ChIJD7BD3hpvnJUR769ON1nepZo', -36.6863655, -56.6791979, 'city', '1'),
('countries_argentina_buenos_aires_san_carlos_de_bolivar', 'ChIJXx7fCTDjv5URwQrc_jS01EI', -36.2398628, -61.1288251, 'city', '1'),
('countries_argentina_buenos_aires_san_cayetano', 'ChIJ4wkevuLikZURUa5yWa7UioQ', -38.3432397, -59.6114468, 'city', '1'),
('countries_argentina_buenos_aires_san_clemente_del_tuyu', 'ChIJJwobRhgbnJUR-mHh2UeYb9A', -36.3688312, -56.7185135, 'city', '1'),
('countries_argentina_buenos_aires_san_fernando', 'ChIJYSiaEWilvJURkCvBV8Q9kyc', -34.4430618, -58.5579643, 'city', '1'),
('countries_argentina_buenos_aires_san_francisco_solano', 'ChIJWcbC2mUso5URjTfoNV12W7k', -34.7778417, -58.3082434, 'city', '1'),
('countries_argentina_buenos_aires_san_german', 'ChIJSXbS1QKj7pURanDczE4U070', -38.3026183, -62.980912, 'city', '1'),
('countries_argentina_buenos_aires_san_isidro', 'ChIJf0OR2DywvJURdQI1ceZJO6s', -34.470829, -58.5286102, 'city', '1'),
('countries_argentina_buenos_aires_san_justo', 'ChIJBZhw-SLGvJURpVAacsdz87U', -34.6874084, -58.5632629, 'city', '1'),
('countries_argentina_buenos_aires_san_manuel', 'ChIJ0RBn4JVGkJURUhjD-cN5PQg', -37.788226, -58.8474745, 'city', '1'),
('countries_argentina_buenos_aires_san_miguel', 'ChIJb-3Xjn-9vJURUR122z3xQaE', -34.543055, -58.7118577, 'city', '1'),
('countries_argentina_buenos_aires_san_miguel_del_monte', 'ChIJR3z2Lz5pvZURBo5Hsby-Lzc', -35.4411249, -58.8070938, 'city', '1'),
('countries_argentina_buenos_aires_san_nicolas_de_los_arroyos', 'ChIJ9wC0-ZNnt5URsYle9NpII2I', -33.3334669, -60.2110494, 'city', '1'),
('countries_argentina_buenos_aires_san_pedro', 'ChIJX6WxDu0iupUROpnuyFe78uU', -33.6757835, -59.6628664, 'city', '1'),
('countries_argentina_buenos_aires_san_vicente', 'ChIJ_WU7GqctvZURxeQLlEL9r0w', -35.0241134, -58.423763, 'city', '1'),
('countries_argentina_buenos_aires_sarandi', 'ChIJnygoQgwzo5URPWeLg4L1mLY', -34.6832581, -58.3439941, 'city', '1'),
('countries_argentina_buenos_aires_sierras_bayas', 'ChIJEWsELUQ-lJUR-DsBsEibLE0', -36.9366888, -60.1561645, 'city', '1'),
('countries_argentina_buenos_aires_sierra_de_la_ventana', 'ChIJH2s0rcru7JURpZI8SRSxK8M', -38.139328, -61.7941399, 'city', '1'),
('countries_argentina_buenos_aires_sierra_de_los_padres', 'ChIJzyA0_f0uhZURPlMNzcEFINs', -37.9474256, -57.7778205, 'city', '1'),
('countries_argentina_buenos_aires_solis', 'ChIJd4C8Ut-Qu5URWa5jHI-XDDs', -34.2980169, -59.3236075, 'city', '1'),
('countries_argentina_buenos_aires_stroeder', 'ChIJnyMi7LLo85URExl-5My6FUs', -40.1826687, -62.6215668, 'city', '1'),
('countries_argentina_buenos_aires_suipacha', 'ChIJSdESMCkFvJURjICf2ddK-78', -34.7720035, -59.6847924, 'city', '1'),
('countries_argentina_buenos_aires_tablada', 'ChIJ2cPOrLjIvJURgRA1dCGbJP8', -34.6855199, -58.532003, 'city', '1'),
('countries_argentina_buenos_aires_tandil', 'ChIJb5QzJ5sfkZURLSCciXYs784', -37.3287999, -59.1367167, 'city', '1'),
('countries_argentina_buenos_aires_tapalque', 'ChIJCzM_Hi3DlZURPlG8ikK87uI', -36.3559008, -60.0255354, 'city', '1'),
('countries_argentina_buenos_aires_tapiales', 'ChIJNyOrs8LOvJURpQZtPYLMT0E', -34.7097342, -58.5005715, 'city', '1'),
('countries_argentina_buenos_aires_temperley', 'ChIJm1Fqu9HSvJURI_vsTW-mcUA', -34.7678337, -58.3792534, 'city', '1'),
('countries_argentina_buenos_aires_tigre', 'ChIJsbnd0KKlvJUR5KHLZ0yXGiw', -34.425087, -58.5796585, 'city', '1'),
('countries_argentina_buenos_aires_tornquist', 'ChIJf7zVjltm7JUR3rF7u2lX_nE', -38.0987358, -62.2236252, 'city', '1'),
('countries_argentina_buenos_aires_torres', 'ChIJsZS1e0yAu5URw1qfI900n4g', -34.4304108, -59.1276324, 'city', '1'),
('countries_argentina_buenos_aires_tortuguitas', 'ChIJBxpmEo6YvJURMyXakvPeUQo', -34.47509, -58.753746, 'city', '1'),
('countries_spain_catalonia_montblanc', 'ChIJacdUfA2pphIRmq0bj_NrKII', 41.3744399, 1.1615674, 'city', '0'),
('countries_argentina_buenos_aires_trenque_lauquen', 'ChIJe6E0eP97wZUR8cL3yCeHVfs', -35.9732789, -62.7325973, 'city', '1'),
('countries_argentina_buenos_aires_tres_algarrobos', 'ChIJaV57Ve-mxpUR_Z7eXQSj8Ow', -35.1955715, -62.7742588, 'city', '1'),
('countries_argentina_buenos_aires_tres_arroyos', 'ChIJmQqDFqxtkpURnkxDbyGLDVg', -38.3775437, -60.2752295, 'city', '1'),
('countries_argentina_buenos_aires_tres_lomas', 'ChIJncL0p08ewpURAOQvDhgDeZ8', -36.4583812, -62.8624543, 'city', '1'),
('countries_argentina_buenos_aires_tristan_suarez', 'ChIJaUYvZNnZvJURg5QFg4KrCh4', -34.8925719, -58.5575923, 'city', '1'),
('countries_argentina_buenos_aires_turdera', 'ChIJuxpnEhvTvJURGQDDsN4v3gE', -34.7893264, -58.4084369, 'city', '1'),
('countries_argentina_buenos_aires_urdampilleta', 'ChIJFVyhUV2p6pURouuZl9rRu2c', -36.4294744, -61.4213243, 'city', '1'),
('countries_argentina_buenos_aires_valeria_del_mar', 'ChIJBW5fJKednJUROyimOdKBPKQ', -37.1450559, -56.8804518, 'city', '1'),
('countries_argentina_buenos_aires_vedia', 'ChIJA22-C6N3x5URSO8bgA8VGjU', -34.4979018, -61.5423677, 'city', '1'),
('countries_argentina_buenos_aires_veinticinco_de_mayo', 'ChIJjZzXEFVgvpURQJhRFlIcX0Q', -35.4324208, -60.1716334, 'city', '1'),
('countries_argentina_buenos_aires_veronica', 'ChIJ961gTXCXmJURKvIYY-GJeQQ', -35.3873557, -57.3384111, 'city', '1'),
('countries_argentina_buenos_aires_vicente_lopez', 'ChIJyaVrOKa2vJURTdphWNeeA7g', -34.5281205, -58.473816, 'city', '1'),
('countries_argentina_buenos_aires_victoria', 'ChIJRUcmQuivvJURgh4ixQhHprw', -34.4562893, -58.5466236, 'city', '1'),
('countries_argentina_buenos_aires_villalonga', 'ChIJj_kNhsrP85UROL905gjLtsI', -39.9131758, -62.6166237, 'city', '1'),
('countries_argentina_buenos_aires_villars', 'ChIJBXLXFOjxvJURyVEPRAAmZBY', -34.8274875, -58.9392582, 'city', '1'),
('countries_argentina_buenos_aires_villa_adelina', 'ChIJQdsDHqOwvJURKBRCBgXRH68', -34.5144416, -58.5462954, 'city', '1'),
('countries_argentina_buenos_aires_villa_alsina', 'ChIJieM-NKW0u5URaxGEsRAPYvg', -33.9089655, -59.3901053, 'city', '1'),
('countries_argentina_buenos_aires_villa_ballester', 'EkNCdWVub3MgQWlyZXMsIFZpbGxhIEJhbGxlc3RlciwgUHJvdmluY2lhIGRlIEJ1ZW5vcyBBaXJlcywgQXJnZW50aW5hIi4qLAoUChIJGwwGdQ-6vJURC_lEKTtCQ7QSFAoSCSMG04D4ubyVEXA9ObXi1Tv2', -34.5380305, -58.5630033, 'city', '1'),
('countries_argentina_buenos_aires_villa_bosch', 'ChIJmZPT-Li5vJUREFr5447lBa8', -34.5812289, -58.5798667, 'city', '1'),
('countries_argentina_buenos_aires_villa_de_mayo', 'ChIJqR2RTS2jvJURrtQewNnw9QU', -34.5114258, -58.6794244, 'city', '1'),
('countries_argentina_buenos_aires_villa_dominico', 'ChIJU3I7ivEyo5URjPr2tVCWyYI', -34.695385, -58.3320999, 'city', '1'),
('countries_argentina_buenos_aires_villa_elisa', 'ChIJmzeLq9reopUR0NmKTAfEoWY', -34.8535254, -58.0791137, 'city', '1'),
('countries_argentina_buenos_aires_villa_el_cacique', 'ChIJfSvQdTkKkZURRrFdp9zF6xU', -37.6787145, -59.395832, 'city', '1'),
('countries_spain_catalonia_monistrol_de_montserrat', 'ChIJobGfGmn1pBIRwCvP4ppF3G0', 41.611353, 1.8464648, 'city', '0'),
('countries_argentina_buenos_aires_villa_gesell', 'ChIJhROrs1xgm5URdZzxCRGstoc', -37.2598939, -56.9714194, 'city', '1'),
('countries_argentina_buenos_aires_villa_iris', 'ChIJ2RvHLYjJ7pUR_P8X956xEnY', -38.1725049, -63.2353312, 'city', '1'),
('countries_argentina_buenos_aires_villa_luzuriaga', 'ChIJT6PTwK7HvJUR4WWGdJ1hkaA', -34.6717415, -58.5932999, 'city', '1'),
('countries_spain_catalonia_mollet_del_valles', 'ChIJy5fJ0iS_pBIRwAmkIeD6AAQ', 41.5411881, 2.2188527, 'city', '0'),
('countries_argentina_buenos_aires_villa_maipu', 'ChIJ_e5DrQ-3vJUREmqZAo8bq2Q', -34.5687326, -58.5202126, 'city', '1'),
('countries_argentina_buenos_aires_villa_martelli', 'ChIJHTtmASC3vJURZsgq5y-6_F4', -34.5510812, -58.5084053, 'city', '1'),
('countries_argentina_buenos_aires_villa_rosa', 'ChIJpyhi3YKdvJURlrMn7QRdDHw', -34.4159183, -58.8715073, 'city', '1'),
('countries_argentina_buenos_aires_villa_sarmiento', 'ChIJVZK2f_bHvJURz_yg8E2b8vY', -34.6340543, -58.5712797, 'city', '1'),
('countries_argentina_buenos_aires_villa_ventana', 'ChIJwZiClr1d7JUR0XzmpjrX8Vg', -38.07365, -61.9258166, 'city', '1'),
('countries_spain_catalonia_molins_de_rei', 'ChIJRRzzM3qapBIRsAmkIeD6AAQ', 41.4183618, 2.0322172, 'city', '0'),
('countries_argentina_buenos_aires_virreyes', 'ChIJOSH_F0alvJURl8V7vanlYLE', -34.4605198, -58.5722336, 'city', '1'),
('countries_argentina_buenos_aires_vivorata', 'ChIJMZkfqbnXmpURbuZDaVtDSNY', -37.6625859, -57.6681185, 'city', '1'),
('countries_argentina_buenos_aires_wilde', 'ChIJF7txVGEyo5URALmps6zzbEE', -34.7040787, -58.3205986, 'city', '1'),
('countries_argentina_buenos_aires_zarate', 'ChIJTXs1kmoLu5URXQhFwceafV8', -34.0957811, -59.0242302, 'city', '1'),
('countries_spain_catalonia_mediona', 'ChIJqew7SI9upBIRoxpB6Y349MA', 41.4798069, 1.627507, 'city', '0'),
('countries_spain_catalonia_matadepera', 'ChIJU5F9wSDtpBIRjp_Rrc7gs0M', 41.633763, 1.9979411, 'city', '0'),
('countries_spain_catalonia_martorelles', 'ChIJ9xOg-CO5pBIRkQw29kVJhIA', 41.532089, 2.235967, 'city', '0'),
('countries_spain_catalonia_martorell', 'ChIJh4i3vMOOpBIR8lyXuWwDGHE', 41.4774253, 1.9175637, 'city', '0'),
('countries_spain_catalonia_martinet', 'ChIJLw0frGqapRIRUMGkIeD6AAQ', 42.3542129, 1.7045499, 'city', '0'),
('countries_spain_catalonia_manresa', 'ChIJJR3J0WxYpBIRtMlxr9Xld1w', 41.7211121, 1.8164413, 'city', '0'),
('countries_spain_catalonia_manlleu', 'ChIJi0zkY6QlpRIRAAmkIeD6AAQ', 42.0111171, 2.2778128, 'city', '0'),
('countries_argentina_buenos_aires_f_d_buenos_aires', 'ChIJvQz5TjvKvJURh47oiC6Bs6A', -34.6036844, -58.3815591, 'city', '1'),
('countries_spain_catalonia_malgrat_de_mar', 'ChIJ823GCNc9uxIR4AikIeD6AAQ', 41.6528561, 2.7630471, 'city', '0'),
('countries_spain_catalonia_l_escala', 'ChIJ6X3ViyZfuhIRwGikIeD6AAQ', 42.1198504, 3.1227702, 'city', '0'),
('countries_spain_catalonia_l_ampolla', 'ChIJCbZanCIboRIRqdktuFwr1OA', 40.805003, 0.6867939, 'city', '0'),
('countries_spain_catalonia_llinars_del_valles', 'ChIJ5fd9YJPLpBIREjvOzKkMzXg', 41.6262792, 2.3912362, 'city', '0'),
('countries_spain_catalonia_llica_d_amunt', 'ChIJYZOkIyPHpBIR0-5aUggi6C4', 41.6145781, 2.2285864, 'city', '0'),
('countries_spain_catalonia_llica_de_vall', 'ChIJRWTeaVDHpBIRwAikIeD6AAQ', 41.5846483, 2.2285864, 'city', '0'),
('countries_spain_catalonia_llanca', 'ChIJj3z5c9p8uhIRte4gQFga9mg', 42.3615931, 3.1450291, 'city', '0'),
('countries_spain_catalonia_llagostera', 'ChIJs1SU_VscuxIRu_S7OMjwum0', 41.8264879, 2.8931303, 'city', '0'),
('countries_spain_catalonia_les_franqueses_del_valles', 'ChIJfy7mybrIpBIRYAekIeD6AAQ', 41.6478275, 2.3123031, 'city', '0'),
('countries_spain_catalonia_la_selva_del_camp', 'ChIJ0yYwePBToRIRIGGlIeD6AAQ', 41.2050591, 1.1257082, 'city', '0'),
('countries_spain_catalonia_la_rapita', 'ChIJ5aQZHUVVoBIRlwQVgklstQM', 40.6279226, 0.6251541, 'city', '0'),
('countries_spain_catalonia_la_llagosta', 'ChIJ5zC7XI6-pBIR9jHFwBhFSQU', 41.5127697, 2.2015347, 'city', '0'),
('countries_spain_catalonia_la_jonquera', 'ChIJrbmS3n2buhIRMGqkIeD6AAQ', 42.4460207, 2.8876436, 'city', '0'),
('countries_spain_catalonia_la_granada', 'ChIJSRyI5rl7pBIRmn59MLm-7SI', 41.3758318, 1.7222535, 'city', '0'),
('countries_spain_catalonia_la_gornal', 'ChIJhxKzkNSJoxIRbxT7MR0_vBM', 41.2535361, 1.5925029, 'city', '0'),
('countries_spain_catalonia_la_gleva', 'ChIJ26K1fKCipBIRnnHa84spV7w', 41.403373, 2.1458031, 'city', '0'),
('countries_spain_catalonia_la_garriga', 'ChIJi87K9ZPFpBIRxiPMo78S_x0', 41.6933493, 2.2778128, 'city', '0'),
('countries_spain_catalonia_las_poblas', 'ChIJbZ88hlpgYw0RtYVvgtkkzXM', 37.6626644, -1.1880945, 'city', '0'),
('countries_spain_catalonia_igualada', 'ChIJXQwbN-NppBIRYAikIeD6AAQ', 41.5849177, 1.612949, 'city', '0'),
('countries_spain_catalonia_gualba_de_baix', 'ChIJn7AbZ3kyuxIRkRS2jBrnxzE', 41.7318992, 2.5022418, 'city', '0'),
('countries_spain_catalonia_gironella', 'ChIJ9yITcU8GpRIRjdVQGA4uQQo', 42.0281086, 1.8855057, 'city', '0'),
('countries_argentina_buenos_aires_f_d_villa_celina', 'ChIJkYVELI3OvJUR-l7iPIGtibY', -34.7066418, -58.483539, 'city', '1'),
('countries_spain_catalonia_fonollosa', 'ChIJ67PiYe9PpBIRSCs7xvhPy7w', 41.7577002, 1.7246856, 'city', '0'),
('countries_spain_catalonia_fogars_de_montclus', 'ChIJ758nKnLSpBIRHW0JYY67zfc', 41.7274934, 2.4428424, 'city', '0'),
('countries_spain_catalonia_flaca', 'ChIJ70WEiHPwuhIROi8dTnmQFAc', 42.0450143, 2.9625587, 'city', '0'),
('countries_spain_catalonia_esplugues_de_llobregat', 'ChIJ4UwlUgqZpBIR0AakIeD6AAQ', 41.3772561, 2.0910377, 'city', '0'),
('countries_spain_catalonia_esparreguera', 'ChIJB3kifFKKpBIRcf60Nj4DFUQ', 41.5562225, 1.8611011, 'city', '0'),
('countries_spain_catalonia_el_prat_de_llobregat', 'ChIJE77o7caepBIRCe33ZQ-Usto', 41.3225846, 2.096263, 'city', '0'),
('countries_spain_catalonia_el_port_de_la_selva', 'ChIJT1JJBMRkuhIRxy0rU38ePbQ', 42.3190248, 3.2281983, 'city', '0'),
('countries_argentina_catamarca_andalgala', 'ChIJWRJCHAwUIZQR9DDFIst3M4k', -27.5827186, -66.3148915, 'city', '1'),
('countries_argentina_catamarca_belen', 'ChIJP1aLKeOSIJQRjVcM5vZkPGg', -27.650239, -67.0259484, 'city', '1'),
('countries_argentina_catamarca_chumbicha', 'ChIJDck70IlnJpQRz61N13TanTQ', -28.8581402, -66.2310587, 'city', '1'),
('countries_argentina_catamarca_poman', 'ChIJF2OC596UJpQRTETZHbLdC7o', -28.395136, -66.2187696, 'city', '1'),
('countries_argentina_catamarca_recreo', 'ChIJNZfYoymCL5QRzkmAGLNfWmU', -29.2781887, -65.0583849, 'city', '1'),
('countries_argentina_catamarca_santa_maria', 'ChIJzwJKYy3lIZQRdq-9f6Th0OE', -26.7035442, -66.0459116, 'city', '1'),
('countries_argentina_catamarca_santa_rosa', 'ChIJhyX3qqDNwpUR4JbXvjYFcCw', -36.6142109, -64.2911937, 'city', '1'),
('countries_spain_catalonia_el_pla_de_santa_maria', 'ChIJF_XT1AcEpBIRt8zfRB6HDsQ', 41.3651819, 1.2903074, 'city', '1'),
('countries_argentina_catamarca_san_jose', 'ChIJH0BzauMkJJQRlSyUPkf6jgU', -28.3885592, -65.7037945, 'city', '1'),
('countries_argentina_catamarca_sumalao', 'ChIJk9IeAxcvJJQRn-PXsn5ebQM', -28.4682377, -65.7335672, 'city', '1'),
('countries_argentina_catamarca_tinogasta', 'ChIJywTRpfgPnpYRfalSjM1Q22k', -28.0670975, -67.5631957, 'city', '1'),
('countries_argentina_chaco_avia_terai', 'ChIJ1wa7-pLaQJQRySDv7swtxs0', -26.686622, -60.7280801, 'city', '1'),
('countries_argentina_chaco_barranqueras', 'ChIJf-OT7LFyRZQRnsEU0gor098', -27.4822998, -58.9334106, 'city', '1'),
('countries_argentina_chaco_basail', 'ChIJDxk9XPqHRZQRVwovxORfEWY', -27.8877722, -59.280812, 'city', '1'),
('countries_argentina_chaco_campo_largo', 'ChIJ71tUpKTOQJQRdtz10OG5i7g', -26.8006989, -60.8417351, 'city', '1'),
('countries_argentina_chaco_castelli', 'ChIJL4lw0uJMQJQRNwTxRmLXkxI', -25.947088, -60.6198397, 'city', '1'),
('countries_argentina_chaco_charata', 'ChIJtd7CxZ9bR5QRikgu0AhU-UM', -27.2179902, -61.1873617, 'city', '1'),
('countries_argentina_chaco_ciervo_petiso', 'ChIJezLErAr3Q5QRWdM4d6bNdeI', -26.5810989, -59.6316513, 'city', '1'),
('countries_argentina_chaco_colonias_unidas', 'ChIJ_-_f0b4IRJQRqtB43QbQRwE', -26.6983181, -59.63009, 'city', '1'),
('countries_argentina_chaco_concepcion_del_bermejo', 'ChIJn7y9FA3AQJQRTwm5z8Phojc', -26.602604, -60.9480616, 'city', '1'),
('countries_argentina_chaco_coronel_du_graty', 'ChIJMSN0InahR5QRXMeicTc_G0I', -27.6853714, -60.9086075, 'city', '1'),
('countries_argentina_chaco_corzuela', 'ChIJbUt2kJNKR5QR4Z8AG-KlzCY', -26.9535135, -60.9682706, 'city', '1'),
('countries_argentina_chaco_fontana', 'ChIJxe_90uELRZQR2UB6dYA26T8', -27.4185047, -59.0378258, 'city', '1'),
('countries_argentina_chaco_gancedo', 'ChIJicP4ZeiUOJQR5MnXfnxyHs4', -27.4886171, -61.6749147, 'city', '1'),
('countries_argentina_chaco_general_jose_de_san_martin', 'ChIJ2__DVMiJQ5QRTcUnyhyw8_Y', -26.5379812, -59.3420281, 'city', '1'),
('countries_argentina_chaco_general_pinedo', 'ChIJl8Lj68lfR5QR0VcHEfunQrk', -27.3245762, -61.2813451, 'city', '1'),
('countries_argentina_chaco_general_vedia', 'ChIJd9oQv5HcRJQRw9Zp1h0mvms', -26.9324359, -58.6591338, 'city', '1'),
('countries_argentina_chaco_hermoso_campo', 'ChIJK1etjhmCOJQRqgHlxmt5TFE', -27.6082718, -61.3446846, 'city', '1'),
('countries_argentina_chaco_isla_del_cerrito', 'ChIJN2kqkcA7RZQRrgFZrnHkL1w', -27.2927639, -58.6180905, 'city', '1'),
('countries_argentina_chaco_las_brenas', 'ChIJ-Sl0vf1OR5QRt__K_FW_ieI', -27.0892409, -61.0836495, 'city', '1'),
('countries_argentina_chaco_las_palmas', 'ChIJuTPbKA_fRJQRRZAq8QJ3eOA', -27.050733, -58.6776801, 'city', '1'),
('countries_argentina_chaco_la_escondida', 'ChIJEb4iAG1IRJQR8XgTErW5424', -27.1039533, -59.4459501, 'city', '1'),
('countries_argentina_chaco_la_leonesa', 'ChIJ6SUNKa3fRJQRoTNFy3-wMpw', -27.0421005, -58.70539, 'city', '1'),
('countries_argentina_chaco_la_tigra', 'ChIJh3xAS6kgR5QR5o1poqoeSGM', -27.110632, -60.5878408, 'city', '1'),
('countries_argentina_chaco_la_verde', 'ChIJsxEWrDNJRJQRDbfYYNmKkjs', -27.1227895, -59.3782295, 'city', '1'),
('countries_argentina_chaco_los_frentones', 'ChIJxYgJA8p-P5QRWDRNIhpLXjk', -26.4117032, -61.4155931, 'city', '1'),
('countries_argentina_chaco_machagai', 'ChIJ6xm23OC6RpQR0Ku9Z6msXBU', -26.9260113, -60.0484359, 'city', '1'),
('countries_argentina_chaco_makalle', 'ChIJowVm7qZSRJQRklS9rVMjAIM', -27.2091872, -59.2840518, 'city', '1'),
('countries_argentina_chaco_margarita_belen', 'ChIJ9Qo5NkUERZQRNATM8i2Y0x8', -27.2591035, -58.9714959, 'city', '1'),
('countries_argentina_chaco_pampa_del_indio', 'ChIJZUUPUTF5QZQRju5iK_RW00U', -26.0479545, -59.941624, 'city', '1'),
('countries_argentina_chaco_pampa_del_infierno', 'ChIJ99Dou_uaQJQRnnCKLoMgRkM', -26.5003297, -61.1797424, 'city', '1'),
('countries_argentina_chaco_presidencia_de_la_plaza', 'ChIJ9csfngmgRpQRIOpKKg4HYnQ', -27.0033832, -59.8456905, 'city', '1'),
('countries_spain_catalonia_el_perello', 'ChIJhdgtrNUboRIRL34Z23X728Y', 40.8959829, 0.6962853, 'city', '0'),
('countries_argentina_chaco_puerto_tirol', 'ChIJ5yDFvDYIRZQRgX_JyhjIcwk', -27.3825467, -59.088123, 'city', '1'),
('countries_argentina_chaco_puerto_vilelas', 'ChIJfZrVa4hyRZQRGjnHAL_o3Js', -27.5143547, -58.9372482, 'city', '1'),
('countries_argentina_chaco_quitilipi', 'ChIJSdHsetvJRpQRJZ6cq6bx_Wg', -26.8720031, -60.2211755, 'city', '1'),
('countries_argentina_chaco_resistencia', 'ChIJC_f1pmIMRZQRbc3CEWXIOvA', -27.4518622, -58.9855547, 'city', '1'),
('countries_argentina_chaco_santa_sylvina', 'ChIJte1-fQGQR5QRD3SgbdlA0As', -27.8315995, -61.1360334, 'city', '1'),
('countries_argentina_chaco_san_bernardo', 'ChIJ_RoJKnIZR5QRf87W3RNdyBA', -27.2872872, -60.7110753, 'city', '1'),
('countries_argentina_chaco_taco_pozo', 'ChIJl_1QAA5BFpQR9xIQ47B5Nbo', -25.6158794, -63.2679565, 'city', '1'),
('countries_argentina_chaco_tres_isletas', 'ChIJd2n4AFgaQZQRErimXLWK57o', -26.3391973, -60.427214, 'city', '1'),
('countries_argentina_chaco_villa_angela', 'ChIJtVKEI7apR5QRL_AYFGTnThE', -27.5758266, -60.7136879, 'city', '1'),
('countries_argentina_chaco_villa_berthet', 'ChIJ3dZObm7lRpQRhEIz4SFNVrg', -27.2893593, -60.4117462, 'city', '1'),
('countries_argentina_chubut_alto_rio_senguer', 'ChIJ278-i0h78b0RXRlzrXpVUEw', -45.0391479, -70.8274789, 'city', '1'),
('countries_argentina_chubut_camarones', 'ChIJXbPXsTZT_b0RKxSbCkk5Zpk', -44.7984997, -65.7103312, 'city', '1'),
('countries_argentina_chubut_comodoro_rivadavia', 'ChIJ9SRI4E1U5L0RS-64O45_n10', -45.8656149, -67.4822429, 'city', '1'),
('countries_argentina_chubut_dolavon', 'ChIJmecqirY8Ab4R0DPhbQWEZIA', -43.307932, -65.7048454, 'city', '1'),
('countries_argentina_chubut_el_corcovado', 'ChIJUeSYKm4h9r0RKgMSNKVCVcM', -43.5388475, -71.4687735, 'city', '1'),
('countries_argentina_chubut_el_maiten', 'ChIJBW9zGOt3G5YRFtkwCs6OeoE', -42.0501902, -71.1701288, 'city', '1'),
('countries_argentina_chubut_esquel', 'ChIJye4kZiGsHZYRWcythA79xfw', -42.9209517, -71.3154291, 'city', '1'),
('countries_argentina_chubut_gaiman', 'ChIJlTqrdFZHAb4RbiCJV2mWwd8', -43.2895976, -65.492011, 'city', '1'),
('countries_argentina_chubut_gobernador_costa', 'ChIJ6Q1ZwCgF970R5nlWliO281M', -44.0479337, -70.5993984, 'city', '1'),
('countries_argentina_chubut_golondrinas', 'ChIJ13leA1GUG5YR94o3n_uTM1Y', -42.0166702, -71.5166702, 'city', '1'),
('countries_spain_catalonia_el_masnou', 'ChIJKSvGQrywpBIRrMB97Tu2ums', 41.4805684, 2.3147677, 'city', '0'),
('countries_argentina_chubut_jose_de_san_martin', 'ChIJo6guJTkO970RM1XGxL5DtYw', -44.0505772, -70.4686238, 'city', '1'),
('countries_argentina_chubut_lago_puelo', 'ChIJHWEhq23rG5YR4RfGAqldHHI', -42.061269, -71.5971258, 'city', '1'),
('countries_argentina_chubut_leleque', 'ChIJ0447DQePHJYRGukMbbVbEl4', -42.3825111, -71.0513306, 'city', '1'),
('countries_argentina_chubut_paso_de_indios', 'ChIJI13RCFkJ-b0RKLMYvSOdlss', -43.864514, -69.0464837, 'city', '1'),
('countries_argentina_chubut_puerto_madryn', 'ChIJ0eqih141Ar4RgkO0ECgNiR4', -42.7636217, -65.0348311, 'city', '1'),
('countries_argentina_chubut_rada_tilly', 'ChIJCbCg0Wes5b0RUntP-d6wo2E', -45.9307657, -67.569463, 'city', '1'),
('countries_argentina_chubut_rawson', 'ChIJN5Yawx9XAb4RDAWDZCuyxlc', -43.2998581, -65.0994873, 'city', '1'),
('countries_argentina_chubut_rio_mayo', 'ChIJVUPEZsXi8b0R7r6lyn4UEUs', -45.6890705, -70.2552694, 'city', '1'),
('countries_argentina_chubut_rio_pico', 'ChIJ16bSeyWF9r0Ry7Y2cht0D7g', -44.1806707, -71.3691758, 'city', '1'),
('countries_argentina_chubut_sarmiento', 'ChIJLZtfsATk770R0eqFySLQIhQ', -45.5868207, -69.068778, 'city', '1'),
('countries_argentina_chubut_tecka', 'ChIJz1Y9OZbc970RKl82y9uO0xY', -43.492739, -70.810849, 'city', '1'),
('countries_argentina_chubut_trelew', 'ChIJu2lnz7ZEAb4RDS4Tr3ZsvZw', -43.2493016, -65.3076351, 'city', '1'),
('countries_argentina_chubut_trevelin', 'ChIJiTIXI8O7HZYRRVZB4FRTZ5k', -43.0888123, -71.4625883, 'city', '1'),
('countries_argentina_cordoba_achiras', 'ChIJCVgQYZ0u0pUR8RkdKQCSnP4', -33.1768821, -64.994372, 'city', '1'),
('countries_argentina_cordoba_adelia_maria', 'ChIJafSqhek2zpURUPiq6UfSIl4', -33.6282692, -64.0272856, 'city', '1'),
('countries_argentina_cordoba_agua_de_oro', 'ChIJbWqI9LB_MpQReWZDjjuLgbI', -31.0621897, -64.3003714, 'city', '1'),
('countries_spain_catalonia_els_monjos', 'ChIJOSb2k3B3pBIRkBGkIeD6AAQ', 41.3140674, 1.6614947, 'city', '0'),
('countries_argentina_cordoba_alejandro_roca', 'ChIJLQgCPZ9dzpURXodfYnca4GI', -33.3525069, -63.7173621, 'city', '1'),
('countries_argentina_cordoba_alejo_ledesma', 'EixDw7NyZG9iYSwgQWxlam8gTGVkZXNtYSwgQ8OzcmRvYmEsIEFyZ2VudGluYSIuKiwKFAoSCb07TKh6xciVEQMewjF2vkcCEhQKEgkvN6-taMXIlRF6Ir1uOVWZsw', -33.6061412, -62.6254549, 'city', '1'),
('countries_argentina_cordoba_alicia', 'ChIJDUwj7kZzy5URia6XvE3Cd38', -31.9387485, -62.4648818, 'city', '1'),
('countries_argentina_cordoba_almafuerte', 'ChIJm1r_cl1hzZUR4AGr9arS5F8', -32.1928924, -64.2649083, 'city', '1'),
('countries_argentina_cordoba_alpa_corral', 'ChIJ_VMs12Nd0pURn4tljkCC2x8', -32.6915109, -64.72365, 'city', '1'),
('countries_argentina_cordoba_alta_gracia', 'ChIJm5OJ3kpXLZQR_UNdnZG3kFI', -31.6584428, -64.4273429, 'city', '1'),
('countries_argentina_cordoba_altos_de_chipion', 'Ei9Db3Jkb2JhLCBBbHRvcyBkZSBDaGlwacOzbiwgQ8OzcmRvYmEsIEFyZ2VudGluYSIuKiwKFAoSCZ0Wxcmd6TSUEcoH8G81WtBcEhQKEglZtKYmc-k0lBEB3wGAg9Stqg', -30.9593271, -62.3369376, 'city', '1'),
('countries_argentina_cordoba_alto_alegre', 'ChIJ1WuEWOR2zJURxnBw1nyDDyM', -32.3456329, -62.8845996, 'city', '1'),
('countries_argentina_cordoba_arias', 'ChIJgVkE1azryJURE3doyMNMX10', -33.6428951, -62.4032806, 'city', '1'),
('countries_argentina_cordoba_arroyito', 'ChIJt2ve4cRNM5QR-MEjTnvDnnI', -31.4192155, -63.0508598, 'city', '1'),
('countries_argentina_cordoba_arroyo_algodon', 'ChIJOwPwIyhgzJURgzJJ2Dsbel4', -32.201034, -63.1641856, 'city', '1'),
('countries_argentina_cordoba_arroyo_cabral', 'ChIJvZXjdllPzJURNEPesqCPtIU', -32.4920062, -63.3991893, 'city', '1'),
('countries_argentina_cordoba_ascochinga', 'ChIJ6-W3Prh5MpQRL7WcHTSQBgI', -30.9422889, -64.276993, 'city', '1'),
('countries_argentina_cordoba_atahona', 'ChIJsV3xhK5WMpQRtVIoSbGi_z8', -30.9032912, -63.7068172, 'city', '1'),
('countries_argentina_cordoba_ausonia', 'ChIJi7VYGbY9zJURfO0YggiXuno', -32.661845, -63.2449886, 'city', '1'),
('countries_argentina_cordoba_ballesteros', 'ChIJXRMS37gNzJURLt9bEsuUjsM', -32.5429649, -62.9821075, 'city', '1'),
('countries_argentina_cordoba_ballesteros_sur', 'ChIJozjWkhkSzJURqOrsbs_swzI', -32.5886779, -63.0256066, 'city', '1'),
('countries_argentina_cordoba_balnearia', 'ChIJl9UCO76ZNJQRcIjlxpBqeZ4', -31.0128017, -62.6657249, 'city', '1'),
('countries_argentina_cordoba_bell_ville', 'ChIJj57DG1D6y5UR4TAqSDS73Wg', -32.6301587, -62.6969088, 'city', '1'),
('countries_argentina_cordoba_bengolea', 'ChIJD6mhECx_zpURyECyFfJegm4', -33.0280297, -63.6705071, 'city', '1'),
('countries_argentina_cordoba_benjamin_gould', 'ChIJ1zW6jfbRyJURsrH71LfkgaY', -33.5889903, -62.7292903, 'city', '1'),
('countries_argentina_cordoba_berrotaran', 'ChIJUf9hO_SA0pUR-G88OX-95Uk', -32.4523498, -64.3872486, 'city', '1'),
('countries_argentina_cordoba_bialet_masse', 'ChIJb8mLjzJ7LZQRjglqNtEedZw', -31.2984489, -64.4666988, 'city', '1'),
('countries_argentina_cordoba_blas_de_rosales', 'ChIJD2cpAf3rMpQRFWPuuajRRc8', -31.2597808, -63.877075, 'city', '1'),
('countries_argentina_cordoba_brinkmann', 'ChIJV4xpsWkeNZQRkzhADu6U-sY', -30.8663699, -62.0341726, 'city', '1'),
('countries_argentina_cordoba_bulnes', 'ChIJrXWINALr0ZURxux6Dn1GA_0', -33.5039696, -64.6765032, 'city', '1'),
('countries_argentina_cordoba_calchin', 'ChIJhWp0StK3zJUROdU-OQlMcE4', -31.6682192, -63.199948, 'city', '1'),
('countries_argentina_cordoba_camilo_aldao', 'ChIJZ9L2fugHyZURGf57VVeeMqY', -33.1315915, -62.0959957, 'city', '1'),
('countries_argentina_cordoba_canada_martel', 'ChIJX2El2tl3MpQR4gBH7BV1Qps', -30.8882499, -64.3302382, 'city', '1'),
('countries_argentina_cordoba_canals', 'ChIJebuyr2csz5UR6Z815TulKfw', -33.5615274, -62.8856108, 'city', '1'),
('countries_argentina_cordoba_capilla_del_monte', 'ChIJgTLJN3eSLZQRmdD7ot5AT4g', -30.8574486, -64.5325578, 'city', '1'),
('countries_argentina_cordoba_capilla_de_siton', 'ChIJySPAK_82MpQRGBDlLEa5ukU', -30.5724757, -63.652892, 'city', '1'),
('countries_argentina_cordoba_carnerillo', 'ChIJaWzARDzmzZURkIHZz4IJIig', -32.9136546, -64.0234413, 'city', '1'),
('countries_argentina_cordoba_carrilobo', 'ChIJcxsUJo2VzJURY1PJO2R-WPQ', -31.8697529, -63.1157151, 'city', '1'),
('countries_argentina_cordoba_casa_grande', 'ChIJgRiz2Fl4LZQRmtWZ7etAPKk', -31.1677356, -64.476048, 'city', '1'),
('countries_argentina_cordoba_chazon', 'ChIJrx8iAUWXzpURJpITHWn9UVU', -33.0788106, -63.2776564, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_argentina_cordoba_chucul', 'ChIJhdB0u137zZURE-NPtl7I7Ng', -33.0100301, -64.1699564, 'city', '1'),
('countries_argentina_cordoba_colazo', 'ChIJySMKR17ozJURPOJI-OOL7Ps', -31.9641137, -63.3832935, 'city', '1'),
('countries_argentina_cordoba_colonia_bismarck', 'ChIJuf5YTVouyZURJL4pIFIxplg', -33.3005117, -62.7131622, 'city', '1'),
('countries_argentina_cordoba_colonia_caroya', 'ChIJJ6BErG5iMpQRIhwdCAHjtoU', -31.0221158, -64.0617371, 'city', '1'),
('countries_argentina_cordoba_colonia_coyunda', 'ChIJ3UzRkeVcM5QRQJju5gHHnYI', -31.1962127, -62.9690211, 'city', '1'),
('countries_argentina_cordoba_colonia_marina', 'ChIJn_q2IU7JNJQROW2OezN0af0', -31.2484113, -62.3631847, 'city', '1'),
('countries_argentina_cordoba_colonia_san_bartolome', 'ChIJk1Ryk0hRy5URbZqrw5ypJLU', -31.529705, -62.7235651, 'city', '1'),
('countries_argentina_cordoba_cordoba', 'ChIJaVuPR1-YMpQRkrBmU5pPorA', -31.4200833, -64.1887761, 'city', '1'),
('countries_argentina_cordoba_coronel_baigorria', 'ChIJUQQgSvUK0pURYGSyRw_a01M', -32.8497253, -64.3589863, 'city', '1'),
('countries_argentina_cordoba_coronel_moldes', 'ChIJxwcNIBXE0ZUR0YPbTaUz4bg', -33.6233067, -64.5973906, 'city', '1'),
('countries_argentina_cordoba_coronel_olmedo', 'ChIJX0N-s1yjMpQRlcxPP4riQn8', -31.4833298, -64.1666718, 'city', '1'),
('countries_argentina_cordoba_corralito', 'ChIJY3hHWIpczZURxzHfc1p2IE0', -32.0252721, -64.1915799, 'city', '1'),
('countries_argentina_cordoba_corral_de_bustos', 'ChIJRxNyODkCyZURtuMkBxV6WzQ', -33.2823744, -62.18751, 'city', '1'),
('countries_argentina_cordoba_cosquin', 'ChIJP179xhR7LZQRMUREyTR7AXc', -31.2468127, -64.4703813, 'city', '1'),
('countries_argentina_cordoba_costa_sacate', 'ChIJh1HLwqTSMpQRJ0TPd0vUeiQ', -31.6492748, -63.7614234, 'city', '1'),
('countries_argentina_cordoba_cruz_alta', 'ChIJpzP_XTS6yZURsJE7mCSQncE', -33.0072364, -61.8094146, 'city', '1'),
('countries_argentina_cordoba_cruz_del_eje', 'ChIJz3MZRn3DLZQRkQGHO_FF2lI', -30.7218548, -64.8086431, 'city', '1'),
('countries_argentina_cordoba_dalmacio_velez_sarsfield', 'ChIJvwwE9cpKzJURuReO4Tf-A4A', -32.6125617, -63.5788661, 'city', '1'),
('countries_argentina_cordoba_dean_funes', 'ChIJ6xpwheH_LZQRiW0FkPXut8g', -30.4231124, -64.354271, 'city', '1'),
('countries_argentina_cordoba_del_campillo', 'ChIJK__PVQkF0JUR05D0T8x7Vzc', -34.3752302, -64.496485, 'city', '1'),
('countries_argentina_cordoba_devoto', 'ChIJV8ncyi8yy5URi8xRCeakefI', -31.4016153, -62.3061831, 'city', '1'),
('countries_argentina_cordoba_elena', 'ChIJAWsg_i950pURiCyCCiq6rAc', -32.5708433, -64.3948091, 'city', '1'),
('countries_argentina_cordoba_el_aranado', 'ChIJEYs6cRahzJURmO559f1oqQQ', -31.7413697, -62.89343, 'city', '1'),
('countries_argentina_cordoba_el_fortin', 'ChIJC4vX5E8Iy5UR-dNL74gPRjc', -31.9689246, -62.3007968, 'city', '1'),
('countries_argentina_cordoba_el_tio', 'ChIJ58F13PVVM5QRpuNrQmmIPdk', -31.384529, -62.8284538, 'city', '1'),
('countries_argentina_cordoba_embalse', 'ChIJx0mmDief0pURl7Bdw7gZoc4', -32.204975, -64.4008877, 'city', '1'),
('countries_argentina_cordoba_etruria', 'ChIJN5PmsgOfzpURRW8Pdhp9Ysw', -32.9391214, -63.2461019, 'city', '1'),
('countries_argentina_cordoba_freyre', 'ChIJUypjYDjWNJQRuwo4jY9Pqd8', -31.1683623, -62.0967011, 'city', '1'),
('countries_argentina_cordoba_frontera', 'ChIJvdhSzUOgNJQRrVn97c8VQF0', -31.425839, -62.061566, 'city', '1'),
('countries_argentina_cordoba_general_baldissera', 'ChIJoSA8u3URyZURpGs_DYSrf1o', -33.1227632, -62.3023981, 'city', '1'),
('countries_argentina_cordoba_general_cabrera', 'ChIJfxuoWIXDzZUR7gq1a0gX7G8', -32.8109998, -63.8707607, 'city', '1'),
('countries_argentina_cordoba_general_deheza', 'ChIJew09bg_GzZURkwVSkNujK24', -32.7574275, -63.7873047, 'city', '1'),
('countries_argentina_cordoba_general_levalle', 'ChIJY7Celwi_z5URkmHsXRt6x1Y', -34.0024582, -63.924575, 'city', '1'),
('countries_argentina_cordoba_guatimozin', 'ChIJKX1wc1jnyJUR0qbC2PKS56k', -33.4635993, -62.4387831, 'city', '1'),
('countries_argentina_cordoba_hernando', 'ChIJkwhVoyWvzZURzIo_6RqFIvc', -32.4255251, -63.7319581, 'city', '1'),
('countries_spain_catalonia_els_hostalets_de_pierola', 'ChIJ1fyrDDphpBIR-NpqQSTElok', 41.5371759, 1.8025852, 'city', '0'),
('countries_argentina_cordoba_huanchillas', 'ChIJsQj0WSKrz5URfurxr_HhNG0', -33.6646403, -63.6363544, 'city', '1'),
('countries_argentina_cordoba_huerta_grande', 'ChIJr5H3p2mDLZQRh9rmb9qjUXY', -31.0752734, -64.4908722, 'city', '1'),
('countries_argentina_cordoba_huinca_renanco', 'ChIJl0uDz-_K2pUR4_4gprG9ngA', -34.8397371, -64.3753894, 'city', '1'),
('countries_argentina_cordoba_idiazabal', 'ChIJF7G-oDwdzJUR4zBjAp2wS8g', -32.8130631, -63.0324915, 'city', '1'),
('countries_argentina_cordoba_inriville', 'ChIJ30d-L_VyyZURbWnOcvSJTA4', -32.947289, -62.2312403, 'city', '1'),
('countries_argentina_cordoba_isla_verde', 'ChIJmzd3CP8YyZURUbeLoxrHUVQ', -33.2375129, -62.404972, 'city', '1'),
('countries_argentina_cordoba_italo', 'ChIJhw6fHScOxZURFlOvvz0Z17c', -34.790568, -63.7815683, 'city', '1'),
('countries_argentina_cordoba_james_craik', 'ChIJPRpAnen7zJURmEDwM7fDn9k', -32.1615877, -63.4672594, 'city', '1'),
('countries_argentina_cordoba_jesus_maria', 'ChIJb3n4S5djMpQRQ7VBoMslwy8', -30.9815529, -64.0957996, 'city', '1'),
('countries_argentina_cordoba_juarez_celman', 'ChIJT3k-RomaMpQR3R-rNF5XJhM', -31.2757806, -64.1645537, 'city', '1'),
('countries_argentina_cordoba_justiniano_posse', 'ChIJg6t32lRQyZURLMH5EIKjcHQ', -32.8834772, -62.6796167, 'city', '1'),
('countries_argentina_cordoba_laborde', 'ChIJpx52ppLKzpURCq25x2KTx8s', -33.1579995, -62.8615693, 'city', '1'),
('countries_argentina_cordoba_laboulaye', 'ChIJh_S4fCtlz5URrnfKqbIvzXs', -34.1289345, -63.3907763, 'city', '1'),
('countries_argentina_cordoba_laguna_larga', 'ChIJYZ29p7kxzZURqTm3yUo0YaI', -31.7808163, -63.7944838, 'city', '1'),
('countries_argentina_cordoba_las_acequias', 'ChIJ5ZvMnTsTzpUR8eiW0uvJlGA', -33.2820333, -63.9754366, 'city', '1'),
('countries_argentina_cordoba_las_junturas', 'ChIJfy85eJrbzJURC-FVfgv-ESQ', -31.8322886, -63.4508839, 'city', '1'),
('countries_argentina_cordoba_las_perdices', 'ChIJP6oKMqHJzZURikqXDMionQs', -32.6972334, -63.7049856, 'city', '1'),
('countries_argentina_cordoba_las_varas', 'ChIJZ2NYZJVoy5URKj1unBfwDEc', -31.8022119, -62.6168889, 'city', '1'),
('countries_argentina_cordoba_las_varillas', 'ChIJySHLlW9ky5URU0kieYaeWDk', -31.8765445, -62.7205527, 'city', '1'),
('countries_argentina_cordoba_la_calera', 'ChIJ4dhJk4idMpQRpijSduwIIuw', -31.3284495, -64.3331127, 'city', '1'),
('countries_argentina_cordoba_la_carlota', 'ChIJlSaBadzlzpURVNNav9lBS8s', -33.4295607, -63.304566, 'city', '1'),
('countries_argentina_cordoba_la_cumbre', 'ChIJjz-VDQyFLZQRN8Kpu2dOqU4', -30.982372, -64.4970309, 'city', '1'),
('countries_spain_catalonia_dosrius', 'ChIJrQg3bmrKpBIRDRjP-HHjMJg', 41.6055074, 2.4307539, 'city', '0'),
('countries_argentina_cordoba_la_laguna', 'ChIJd7_B3ysizJURUnJkqvxRZAM', -32.8016154, -63.2450488, 'city', '1'),
('countries_argentina_cordoba_la_paquita', 'ChIJUYpvT4rmNJQRPHYKgH9Ncuc', -30.9069774, -62.2160676, 'city', '1'),
('countries_argentina_cordoba_la_para', 'ChIJGeo7ufZ5M5QRhiQXVeL_Dwo', -30.8923643, -62.9996212, 'city', '1'),
('countries_argentina_cordoba_la_playosa', 'ChIJe8GWpruIzJURvkvE5BMBJzo', -32.1016034, -63.0316312, 'city', '1'),
('countries_argentina_cordoba_leones', 'ChIJIXPK93fYy5URmqUVOYSHwqU', -32.6678289, -62.2972925, 'city', '1'),
('countries_argentina_cordoba_los_cocos', 'ChIJAdtbMEuOLZQRP8OwRIdQ7_k', -30.9253512, -64.5013203, 'city', '1'),
('countries_argentina_cordoba_los_condores', 'ChIJF2F2Cvt8zZURnJM03eVu-xs', -32.318527, -64.2758785, 'city', '1'),
('countries_argentina_cordoba_los_reartes', 'ChIJ19knVdSz0pURksHVbrcNJ3o', -31.9089342, -64.5740952, 'city', '1'),
('countries_argentina_cordoba_los_surgentes', 'ChIJUQpdcQShyZUR1gumo8erNhQ', -32.9837015, -62.0215187, 'city', '1'),
('countries_argentina_cordoba_lozada', 'ChIJq4EzSNmzMpQRshc1P1rArP8', -31.6488205, -64.0886078, 'city', '1'),
('countries_argentina_cordoba_luque', 'ChIJhw-MpSzMzJUR_FQNcXne6z8', -31.6476686, -63.3444408, 'city', '1'),
('countries_argentina_cordoba_malagueno', 'ChIJ8T1K9sNfLZQRpR-pPbLX_Hk', -31.4609319, -64.3517688, 'city', '1'),
('countries_argentina_cordoba_marcos_juarez', 'ChIJCZeDGRF_yZURUmdUaqeCmpA', -32.680333, -62.1067493, 'city', '1'),
('countries_argentina_cordoba_marull', 'ChIJd441-HdiM5QRsiAc_GHjJik', -30.993909, -62.8253736, 'city', '1'),
('countries_argentina_cordoba_mattaldi', 'ChIJDSpIiAtXxZUR48iXW4zVSGc', -34.4826964, -64.1718559, 'city', '1'),
('countries_argentina_cordoba_melo', 'ChIJezHq1IOGxZURbPgeBjiEJ94', -34.3479855, -63.4456316, 'city', '1'),
('countries_argentina_cordoba_mendiolaza', 'ChIJFSIpNS2dMpQRxDL6nu7cUvY', -31.2666702, -64.3000107, 'city', '1'),
('countries_argentina_cordoba_mina_clavero', 'ChIJ3cRIkNUlLZQRbMtFDkCzk6Y', -31.7282783, -65.0055595, 'city', '1'),
('countries_argentina_cordoba_miramar', 'ChIJpb9cxc-aNJQRrQhYTsMmvVk', -30.9177405, -62.678696, 'city', '1'),
('countries_argentina_cordoba_monte_buey', 'ChIJMZcVfipoyZURbh891xjNBR0', -32.9127626, -62.4485343, 'city', '1'),
('countries_argentina_cordoba_monte_cristo', 'ChIJXdS2y7HqMpQRdeF69TGHwCc', -31.343339, -63.9460372, 'city', '1'),
('countries_argentina_cordoba_monte_lena', 'ChIJlah-fgLly5URaQPEOmEw-jI', -32.6117347, -62.589675, 'city', '1'),
('countries_argentina_cordoba_monte_maiz', 'ChIJ71k93vs6yZURQDWY3aEfU9Y', -33.2048662, -62.6007029, 'city', '1'),
('countries_argentina_cordoba_morrison', 'ChIJe7eWwyUIzJUR7GWQjT8Wzeg', -32.5916447, -62.8342242, 'city', '1'),
('countries_argentina_cordoba_morteros', 'ChIJHTEi858DNZQRcqSMAMSCu9w', -30.7113387, -62.0065703, 'city', '1'),
('countries_argentina_cordoba_noetinger', 'ChIJxXxoIqfHy5URJHJBADOGt8w', -32.3637963, -62.3123776, 'city', '1'),
('countries_argentina_cordoba_nono', 'ChIJDfkAUisvLZQR_nHlyr8Mxfc', -31.793064, -65.0006272, 'city', '1'),
('countries_argentina_cordoba_obispo_trejo', 'ChIJaxLm9AyvM5QRKqEqGpZjB8E', -30.7817302, -63.4177914, 'city', '1'),
('countries_argentina_cordoba_oliva', 'ChIJQdL8AgTizJURLskUfYMijGs', -32.0427403, -63.5670022, 'city', '1'),
('countries_argentina_cordoba_oncativo', 'ChIJR0Kkg98jzZURg6yu3MdNlGE', -31.9134288, -63.6820629, 'city', '1'),
('countries_argentina_cordoba_ordonez', 'ChIJCz57ngCrzpURAd1neZGJxmQ', -32.8396869, -62.8651092, 'city', '1'),
('countries_argentina_cordoba_pascanas', 'ChIJZ8-cRLi5zpURbFYFdACQSCg', -33.1238885, -63.0420795, 'city', '1'),
('countries_argentina_cordoba_pasco', 'ChIJ109V1yo7zJURTymZqXAxrJI', -32.7480797, -63.3402432, 'city', '1'),
('countries_argentina_cordoba_pilar', 'ChIJh9mITE7LMpQRW15OEhHnxqk', -31.6781613, -63.8786458, 'city', '1'),
('countries_argentina_cordoba_piquillin', 'ChIJHxGF9efnMpQRpq6LhYykTso', -31.2992567, -63.7597143, 'city', '1'),
('countries_argentina_cordoba_portena', 'ChIJZ1VelrMgNZQRayQTigpmMso', -31.0139185, -62.0619979, 'city', '1'),
('countries_spain_catalonia_deltebre', 'ChIJKbilCpoFoRIRQGOlIeD6AAQ', 40.7338056, 0.7342734, 'city', '0'),
('countries_argentina_cordoba_pozo_del_molle', 'ChIJ-eFIS3yDzJUR6ZRZu8n3OzI', -32.0138878, -62.9167703, 'city', '1'),
('countries_argentina_cordoba_rio_ceballos', 'ChIJJfV_Ji1-MpQRPv8tE--ufp0', -31.1737267, -64.3123326, 'city', '1'),
('countries_argentina_cordoba_rio_cuarto', 'ChIJQ5fd14b_zZURPR45a6Y0xX0', -33.0927684, -64.3250594, 'city', '1'),
('countries_argentina_cordoba_rio_de_los_sauces', 'ChIJs77beGZi0pURJIHgIqH5oCo', -32.5276953, -64.5865377, 'city', '1'),
('countries_argentina_cordoba_rio_primero', 'ChIJe4NBlqnfMpQRK3GxFcY4Au4', -31.3317205, -63.6220702, 'city', '1'),
('countries_argentina_cordoba_rio_segundo', 'ChIJ5VQ2SwDLMpQRzCt7nC_0l38', -31.6512139, -63.9064959, 'city', '1'),
('countries_argentina_cordoba_rio_tercero', 'ChIJdW6bzCRvzZURMwF-lQjpMQ8', -32.1766541, -64.1130995, 'city', '1'),
('countries_argentina_cordoba_rosales', 'ChIJA27ysglfz5URqlbpNRlJeik', -34.1724359, -63.1535843, 'city', '1'),
('countries_argentina_cordoba_sacanta', 'ChIJo4WN_HOwzJURcX2K8qJ-EVw', -31.6639934, -63.0472807, 'city', '1'),
('countries_argentina_cordoba_salsipuedes', 'ChIJVWDIAcmBMpQRUlBC2HUDvdI', -31.1368964, -64.2964335, 'city', '1'),
('countries_argentina_cordoba_sampacho', 'ChIJjdCgramS0ZUReRK46C2HMPk', -33.384713, -64.7231018, 'city', '1'),
('countries_argentina_cordoba_santa_eufemia', 'ChIJqxXiqWmUzpURiAJDXqR30uA', -33.1784049, -63.2828866, 'city', '1'),
('countries_spain_catalonia_das', 'ChIJK6kJX593pRIRsGikIeD6AAQ', 42.3539548, 1.8757422, 'city', '0'),
('countries_spain_catalonia_corbins', 'ChIJkXY8ngXkphIRML6kIeD6AAQ', 41.6839393, 0.682049, 'city', '0'),
('countries_argentina_cordoba_santa_rosa_de_calamuchita', 'ChIJeQDfCFC70pURy3c5Bjh9oWg', -32.0680956, -64.5395456, 'city', '1'),
('countries_spain_catalonia_corbera_de_llobregat', 'ChIJmz0QwomFpBIRgAakIeD6AAQ', 41.4202064, 1.9245812, 'city', '0'),
('countries_argentina_cordoba_santiago_temple', 'ChIJrfrnNBYlM5QR_B3pZYKGH9E', -31.3877604, -63.4183109, 'city', '1'),
('countries_argentina_cordoba_san_agustin', 'ChIJT7Wp6s-n0pURVpXQs40jFq0', -31.9777622, -64.3751707, 'city', '1'),
('countries_argentina_cordoba_san_antonio_de_litin', 'ChIJYxhGntGay5URT4lNlfebSnc', -32.2139842, -62.6321273, 'city', '1'),
('countries_argentina_cordoba_san_basilio', 'ChIJaZSGC28gzpURsW2zrTczg9E', -33.4976173, -64.3157374, 'city', '1'),
('countries_argentina_cordoba_san_carlos', 'ChIJRVEhaKpULJQRByzIHmWG6KY', -31.1754275, -65.1021949, 'city', '1'),
('countries_argentina_cordoba_san_francisco', 'ChIJZ9DBiyIoy5UR9AA3jP6rBI8', -31.4249992, -62.0841599, 'city', '1'),
('countries_argentina_cordoba_san_francisco_del_chanar', 'ChIJzxPh1s-3MZQRkhLTpuKFXKs', -29.7876085, -63.9423571, 'city', '1'),
('countries_argentina_cordoba_san_jose_de_la_dormida', 'ChIJn-b7jRggMpQRXBjNf29ZQcg', -30.3563061, -63.9503935, 'city', '1'),
('countries_argentina_cordoba_san_marcos_sierra', 'ChIJQWeZ5XXrLZQRE0IfGqKJEQY', -30.7823771, -64.6394726, 'city', '1'),
('countries_spain_catalonia_collbato', 'ChIJV3r6AhxgpBIRUAakIeD6AAQ', 41.5768136, 1.8220818, 'city', '0'),
('countries_argentina_cordoba_sebastian_elcano', 'ChIJMRApBhuCMZQRaIXhg4pWoBU', -30.1606251, -63.5943537, 'city', '1'),
('countries_argentina_cordoba_serrano', 'ChIJtQ1HWySdxZURp55z3vAoG0U', -34.4731902, -63.5384134, 'city', '1'),
('countries_argentina_cordoba_silvio_pellico', 'ChIJXa7yauZ7zJURws30vqYpNyc', -32.2510284, -62.9309997, 'city', '1'),
('countries_argentina_cordoba_tancacha', 'ChIJpVhhyN1yzZUR0AzeI6PYa_s', -32.2433281, -63.9817173, 'city', '1'),
('countries_argentina_cordoba_tanti', 'ChIJ7bfkBR9uLZQRC85Tf9N0QrY', -31.3614122, -64.5829186, 'city', '1'),
('countries_argentina_cordoba_ticino', 'ChIJ96ZEsdcwzJUR8xY8LEzFawM', -32.6919815, -63.437664, 'city', '1'),
('countries_argentina_cordoba_tio_pujio', 'ChIJ5XgI2VJYzJURaI98vPjei5Y', -32.2858968, -63.353412, 'city', '1'),
('countries_argentina_cordoba_toledo', 'ChIJe7LjEXi3MpQR8aDksDyw7ds', -31.5556585, -64.0064846, 'city', '1'),
('countries_argentina_cordoba_transito', 'ChIJj0XmGd1JM5QRIPtlSIZTfyw', -31.4245503, -63.1958166, 'city', '1'),
('countries_argentina_cordoba_ucacha', 'ChIJlauQ8TSBzpUR3e7JNewsfrk', -33.0305447, -63.5072215, 'city', '1'),
('countries_argentina_cordoba_unquillo', 'ChIJAxdWfIyCMpQRXDcY04Bfzro', -31.2341309, -64.3167114, 'city', '1'),
('countries_argentina_cordoba_valle_hermoso', 'ChIJ9f8kzoGCLZQRGjjDyelsW2M', -31.1346015, -64.487919, 'city', '1'),
('countries_argentina_cordoba_viamonte', 'ChIJVcD8KI47z5URr3YszenFxR4', -33.7461639, -63.0974125, 'city', '1'),
('countries_argentina_cordoba_vicuna_mackenna', 'ChIJ05Q3pHYp0JUR019zlTMk-bA', -33.9179611, -64.3894806, 'city', '1'),
('countries_argentina_cordoba_villa_allende', 'ChIJX26magWdMpQRDkGZ7ZaD1Sw', -31.2915864, -64.2922971, 'city', '1'),
('countries_argentina_cordoba_villa_anizacate', 'EihDw7NyZG9iYSwgQW5pc2FjYXRlLCBDw7NyZG9iYSwgQXJnZW50aW5hIi4qLAoUChIJA0jz9QZULZQRMum9seUjpYESFAoSCREKFfc4VC2UEbkZEN5kLZiH', -31.7267007, -64.4109431, 'city', '1'),
('countries_argentina_cordoba_villa_ascasubi', 'ChIJCXfVR0gSzZURI9jEm_oh6R8', -32.162364, -63.8917526, 'city', '1'),
('countries_argentina_cordoba_villa_carlos_paz', 'ChIJLWIaIlxmLZQR12j9HUh3_cw', -31.4166218, -64.4857183, 'city', '1'),
('countries_argentina_cordoba_villa_concepcion_del_tio', 'ChIJX-fp7sypNJQR8qfEydKCOok', -31.3221629, -62.8140508, 'city', '1'),
('countries_argentina_cordoba_villa_cura_brochero', 'ChIJ57TB0pMmLZQRdELXfN8Khvg', -31.6667512, -65.0173072, 'city', '1'),
('countries_argentina_cordoba_villa_del_dique', 'ChIJ46_kLcCY0pURdPPTaapfKvs', -32.1733856, -64.4545626, 'city', '1'),
('countries_argentina_cordoba_villa_del_rosario', 'ChIJyX5pslMqM5QRE_CTQk448zc', -31.5562575, -63.5356054, 'city', '1'),
('countries_argentina_cordoba_villa_del_totoral', 'ChIJM-6O2qtsMpQRu4wNKyVy-6g', -30.7053705, -64.057379, 'city', '1'),
('countries_argentina_cordoba_villa_de_maria', 'ChIJQf8byVeiMZQRLMMiXnc65h8', -29.9063988, -63.7249796, 'city', '1'),
('countries_argentina_cordoba_villa_de_soto', 'ChIJ79KOxITJLZQR6fS4OO9u8Ho', -30.85506, -64.9928858, 'city', '1'),
('countries_argentina_cordoba_villa_dolores', 'ChIJ4bDrEmDTLJQRxFGeT2dOTTo', -31.9450289, -65.1902739, 'city', '1'),
('countries_argentina_cordoba_villa_fontana', 'ChIJwfz9DiN0M5QRBYpkZMrKmLw', -30.8936551, -63.1170968, 'city', '1'),
('countries_argentina_cordoba_villa_general_belgrano', 'ChIJId8v812w0pUR02ZFnXa3MMo', -31.9776652, -64.5594102, 'city', '1'),
('countries_argentina_cordoba_villa_giardino', 'ChIJdVFx34SELZQR5qo0gWf9Z_g', -31.0529852, -64.4991278, 'city', '1'),
('countries_argentina_cordoba_villa_huidobro', 'ChIJf3FRkpK42pURfZVkB98Plus', -34.8379353, -64.58459, 'city', '1'),
('countries_spain_catalonia_cervera', 'ChIJfYpvGEshpBIRInL9ikEbOgs', 41.6838422, 1.2794744, 'city', '0'),
('countries_argentina_cordoba_villa_maria', 'ChIJwW0wUftCzJURscYl1Pv_s78', -32.4104614, -63.243645, 'city', '1'),
('countries_argentina_cordoba_villa_nueva', 'ChIJCaQb8lRCzJURReU9DIWSRyg', -32.4356257, -63.2480859, 'city', '1'),
('countries_argentina_cordoba_villa_reduccion', 'ChIJXYUYDvxtzpURM96_g_IpdbQ', -33.2003984, -63.8621518, 'city', '1'),
('countries_argentina_cordoba_villa_rumipal', 'ChIJsXqCzF6Y0pURDU65OnMT3iE', -32.1895171, -64.4792805, 'city', '1'),
('countries_argentina_cordoba_villa_tulumba', 'ChIJwREV-BQdMpQRWdLFMfoYqCA', -30.3958649, -64.1218055, 'city', '1'),
('countries_argentina_cordoba_villa_valeria', 'ChIJdzNZAARm0JURqMa0HMZr_T8', -34.3462032, -64.9137114, 'city', '1'),
('countries_argentina_cordoba_villa_yacanto', 'ChIJw4tvJhrH0pURJO3pjfKyVZw', -32.1057442, -64.7540869, 'city', '1'),
('countries_argentina_cordoba_wenceslao_escalante', 'ChIJITFR3zs0yZUR-Q2Q5Ft9nh0', -33.1709508, -62.7704554, 'city', '1'),
('countries_argentina_cordoba_yacanto', 'ChIJw4tvJhrH0pURJO3pjfKyVZw', -32.1057442, -64.7540869, 'city', '1'),
('countries_spain_catalonia_cervello', 'ChIJC4RSmwiFpBIRc6IDn_KJm4o', 41.3896747, 1.9539106, 'city', '0'),
('countries_argentina_corrientes_alvear', 'ChIJO4wM8nNdVJQRyQvyH6M8hS0', -29.0899299, -56.5448071, 'city', '1'),
('countries_argentina_corrientes_bella_vista', 'ChIJ48LRTDCrT5QRIwZiT_4Taq4', -28.5066193, -59.0422553, 'city', '1'),
('countries_argentina_corrientes_buena_vista', 'ChIJyZ1axmowTJQRGtr883gJMbQ', -29.4286938, -59.2907333, 'city', '1'),
('countries_argentina_corrientes_cerrito', 'EitDb3JyaWVudGVzLCBDZXJyaXRvLCBFbnRyZSBSw61vcywgQXJnZW50aW5hIi4qLAoUChIJacX04FRktJURCbCmd4TQrmwSFAoSCT05p6EGZbSVEceiVjJZ4ajC', -31.5785842, -60.0697149, 'city', '1'),
('countries_spain_catalonia_cerdanyola_del_valles', 'ChIJy1TEqAOWpBIRDZ5Ug70q4fA', 41.490047, 2.1397612, 'city', '0'),
('countries_argentina_corrientes_corrientes', 'ChIJa9O-1XlrRZQRRga08x6fmfo', -27.4692131, -58.8306349, 'city', '1'),
('countries_argentina_corrientes_curuzu_cuatia', 'ChIJYRKiKviSUpQR4wErtJSQERA', -29.7903375, -58.0580471, 'city', '1'),
('countries_argentina_corrientes_empedrado', 'ChIJM2igjwuST5QRh6aWvALLZkw', -27.952497, -58.8031921, 'city', '1'),
('countries_argentina_corrientes_esquina', 'ChIJz8dneoSETpQROhvyGoRShis', -30.0184837, -59.5314088, 'city', '1'),
('countries_argentina_corrientes_goya', 'ChIJ7ztSBZaETpQR4ZoyalQRCXw', -29.1442242, -59.2643242, 'city', '1'),
('countries_argentina_corrientes_itati', 'ChIJp_vjqa_JWpQRJFHQpxdTdws', -27.2727981, -58.2425644, 'city', '1'),
('countries_argentina_corrientes_ituzaingo', 'ChIJgclKbfM4V5QRh4Pn2ILqcn8', -27.5884602, -56.6900782, 'city', '1'),
('countries_argentina_corrientes_mburucuya', 'ChIJ2RlrQpwkUJQRB6G5OMZchrk', -28.0576592, -58.2197702, 'city', '1'),
('countries_argentina_corrientes_mercedes', 'ChIJ08GscqEWUpQRuJoQ4piZpY8', -29.184582, -58.0735719, 'city', '1'),
('countries_argentina_corrientes_mocoreta', 'ChIJU8r1PPgUrZURPqJBBZcBzZ0', -30.6144638, -57.9636032, 'city', '1'),
('countries_argentina_corrientes_monte_caseros', 'ChIJMX3FOSPWrJURLLVhwfF0WNc', -30.2531458, -57.6365555, 'city', '1'),
('countries_spain_catalonia_castell_platja_d_aro', 'ChIJN2HiFd8AuxIRM0kjmgULOYw', 41.8297094, 3.0476046, 'city', '0'),
('countries_argentina_corrientes_paso_de_la_patria', 'ChIJe6h885E5RZQR26-rujtHBmg', -27.3148011, -58.5636468, 'city', '1'),
('countries_argentina_corrientes_paso_de_los_libres', 'ChIJoT89tMRcU5QRoVWT7-SBxqU', -29.7137101, -57.0855601, 'city', '1'),
('countries_argentina_corrientes_pueblo_libertador', 'ChIJz8VySd7rTJQRtZHkpzmkvE4', -30.2192482, -59.3845491, 'city', '1'),
('countries_argentina_corrientes_riachuelo', 'ChIJEcLbSxdoRZQReofWcfmUm38', -27.5809603, -58.7405488, 'city', '1'),
('countries_argentina_corrientes_saladas', 'ChIJw9PjdULPT5QRcYvL2v8Fe0k', -28.2557422, -58.6233566, 'city', '1'),
('countries_argentina_corrientes_santa_lucia', 'ChIJv8MK4HhiTpQRKPetf2aJpb4', -28.9820202, -59.1009032, 'city', '1'),
('countries_argentina_corrientes_santa_rosa', 'ChIJDdZSFUYzUJQRaAKWgraTWnw', -28.265736, -58.1181236, 'city', '1'),
('countries_argentina_corrientes_santo_tome', 'ChIJ09b14eTPVZQRFKhR7hlTr1Q', -28.5524101, -56.0452135, 'city', '1'),
('countries_argentina_corrientes_san_carlos', 'ChIJC6SeJs9LVpQRuBVkPTK9Tkw', -27.745135, -55.898368, 'city', '1'),
('countries_argentina_corrientes_san_lorenzo', 'ChIJNyOYq7i_T5QRJr9m0UfjFaU', -28.137383, -58.7675888, 'city', '1'),
('countries_argentina_corrientes_san_luis_del_palmar', 'ChIJS5SDrn9FRZQRVmtY5xETTNU', -27.5119817, -58.5598537, 'city', '1'),
('countries_argentina_corrientes_san_roque', 'ChIJXbuzhr43TpQRXDYCwH0nbck', -28.5743789, -58.7082201, 'city', '1'),
('countries_argentina_corrientes_sauce', 'ChIJYXurLqgVTZQRKs8yy1hta4U', -30.0860397, -58.7881101, 'city', '1'),
('countries_argentina_corrientes_yapeyu', 'ChIJwem3opubVJQRtloQoTYvz4o', -29.4697685, -56.8163948, 'city', '1'),
('countries_argentina_corrientes_yurucua', 'ChIJ_diCKRYEVJQRTW-UG-8ZLCU', -28.7037315, -56.8118477, 'city', '1'),
('countries_argentina_entre_rios_alcaraz', 'ChIJ0bgnyLKbs5URh2KK6k6gV40', -31.4547897, -59.5979649, 'city', '1'),
('countries_argentina_entre_rios_aldea_maria_luisa', 'ChIJF1Zq3vA3tJURdoYEwv1eetI', -31.8846751, -60.4103223, 'city', '1'),
('countries_argentina_entre_rios_aldea_santa_maria', 'ChIJ1VVbtZ96tJURwDGrvPXlqVc', -31.6110428, -60.0061699, 'city', '1'),
('countries_argentina_entre_rios_altamirano_sur', 'ChIJS86hFd52sZURYp0MPHXuHjQ', -32.0883217, -59.1751099, 'city', '1'),
('countries_argentina_entre_rios_aranguren', 'ChIJhQMQ4bOjtpURYjPhIL2UK_Q', -32.2486777, -60.1591792, 'city', '1'),
('countries_argentina_entre_rios_arroyo_urquiza', 'ChIJKxSe6qDRr5URsqKkt04HvBA', -32.3833313, -58.2333298, 'city', '1'),
('countries_argentina_entre_rios_atencio', 'ChIJZWxYO8W7spUR8oNfb0Yz5n0', -30.6374649, -58.6378118, 'city', '1'),
('countries_argentina_entre_rios_basavilbaso', 'ChIJ16sdOSiysZURy_UdgFQZ0PY', -32.3769298, -58.8845084, 'city', '1'),
('countries_argentina_entre_rios_bovril', 'ChIJm3biubOhs5URPGksEMTJqeU', -31.335363, -59.4411508, 'city', '1'),
('countries_spain_catalonia_castellvell_del_camp', 'ChIJUbUPaXZRoRIRaD1GgAE91D4', 41.187811, 1.0897511, 'city', '0'),
('countries_argentina_entre_rios_chajari', 'ChIJK-OH7j0NrZURVpXt78SI7yE', -30.7618581, -57.9861283, 'city', '1'),
('countries_argentina_entre_rios_clara', 'ChIJA3P3fCqKsZURNlBfJxzC1-c', -31.8284558, -58.8220222, 'city', '1'),
('countries_argentina_entre_rios_colon', 'ChIJTW0kBx0zrpURCT97_i8YfMc', -32.2249328, -58.1447142, 'city', '1'),
('countries_argentina_entre_rios_concepcion_del_uruguay', 'ChIJ4R7ioUPar5URAh80nELHwyM', -32.469191, -58.2493778, 'city', '1'),
('countries_argentina_entre_rios_concordia', 'ChIJ4RtgcAXorZURhMuG6ORAvz8', -31.3730029, -58.0133328, 'city', '1'),
('countries_argentina_entre_rios_crespo', 'ChIJKXyHrpAktJURCgRNzeV-LTI', -32.0308896, -60.3071844, 'city', '1'),
('countries_argentina_entre_rios_diamante', 'ChIJM-43l6LNtZUR7gb7g-5x1i4', -32.0743371, -60.6387969, 'city', '1'),
('countries_argentina_entre_rios_dominguez', 'ChIJnS4IAdaEsZURSltYuOaTFgo', -31.9877299, -58.9635815, 'city', '1'),
('countries_argentina_entre_rios_el_pingo', 'ChIJm5YRGHp3tJURUR9NZRU_Us8', -31.5820068, -59.8926443, 'city', '1'),
('countries_argentina_entre_rios_federacion', 'ChIJAToSS4CkrZUR692PySwsYbs', -30.9850361, -57.9198417, 'city', '1'),
('countries_argentina_entre_rios_federal', 'ChIJG9DAFIntspURkh9vX7XvGZY', -30.9512012, -58.7849549, 'city', '1'),
('countries_argentina_entre_rios_general_campos', 'ChIJP7jcw7cHspUR-SQS23nLDdE', -31.528637, -58.408486, 'city', '1'),
('countries_argentina_entre_rios_general_galarza', 'ChIJnbVtPGXmsJURBWDGbZ7LYEk', -32.720475, -59.3958098, 'city', '1'),
('countries_argentina_entre_rios_gobernador_mansilla', 'ChIJf4pEBModsZURfPfixCgQMHA', -32.5461235, -59.3544174, 'city', '1'),
('countries_argentina_entre_rios_gualeguay', 'ChIJk_8kB4CbsJURefxatbpHjPg', -33.1503285, -59.3104685, 'city', '1'),
('countries_argentina_entre_rios_gualeguaychu', 'ChIJQzUz8yioupURwZeUp9aTX6k', -33.0077778, -58.5111667, 'city', '1'),
('countries_argentina_entre_rios_hasenkamp', 'ChIJLdGZboZ4tJUReMBocl-BV1E', -31.5120085, -59.836209, 'city', '1'),
('countries_argentina_entre_rios_hernandez', 'ChIJVRgEM6ewtpURpzJfflNRaf0', -32.3372584, -60.022396, 'city', '1'),
('countries_argentina_entre_rios_ibicuy', 'ChIJmW2M6MVWupURbofS3_CbK4o', -33.7434675, -59.1557553, 'city', '1'),
('countries_argentina_entre_rios_larroque', 'ChIJ7RncqIp7sJURbmwfOomQBuk', -33.0351227, -58.9978401, 'city', '1'),
('countries_spain_catalonia_castello_d_empuries', 'ChIJq753DzyKuhIRp6y-TrtvtR8', 42.2604918, 3.0738992, 'city', '0'),
('countries_argentina_entre_rios_la_paz', 'ChIJw15zf5RNs5URHpixdDivO2M', -30.7589703, -59.6392784, 'city', '1'),
('countries_argentina_entre_rios_libertador_san_martin', 'ChIJw8DdIhYutJURrpz1he1bp9Q', -32.0721176, -60.4629211, 'city', '1'),
('countries_argentina_entre_rios_liebig', 'ChIJBRa321ovrpUReB_NWy_GQGU', -32.1545743, -58.1935026, 'city', '1'),
('countries_argentina_entre_rios_los_charruas', 'ChIJ63dHKtGRrZURYfgBVl9vw_Q', -31.1698659, -58.1891494, 'city', '1'),
('countries_argentina_entre_rios_los_conquistadores', 'ChIJdaasViSkspURyHXc2MHXFHk', -30.5907458, -58.4665704, 'city', '1'),
('countries_argentina_entre_rios_lucas_gonzalez', 'ChIJUyaRLiI8sZUROok025AIxkc', -32.3844042, -59.530963, 'city', '1'),
('countries_argentina_entre_rios_macia', 'ChIJy5K7cUxpsZURn04JNn4J2rQ', -32.1747833, -59.4044387, 'city', '1'),
('countries_argentina_entre_rios_nogoya', 'ChIJb3tpyRA1sZURwxiVBRMN31Y', -32.3901919, -59.7931152, 'city', '1'),
('countries_argentina_entre_rios_oro_verde', 'ChIJFzxic4pLtJURZ9ZkzZK5YKg', -31.8239453, -60.5190495, 'city', '1'),
('countries_argentina_entre_rios_parana', 'ChIJMVKDufJNtJURmvpcquC9TlU', -31.7413197, -60.5115471, 'city', '1'),
('countries_argentina_entre_rios_pronunciamiento', 'ChIJWSH3FTwrsJURwsSfISCLVOI', -32.3462951, -58.4433733, 'city', '1'),
('countries_spain_catalonia_castellbisbal', 'ChIJjfQWySOOpBIR0HKTQpzn6H8', 41.4946573, 1.9588007, 'city', '0'),
('countries_spain_catalonia_castellcir', 'ChIJmZQKxl3dpBIRhnV7T9inWtc', 41.7703577, 2.1548473, 'city', '0'),
('countries_argentina_entre_rios_rosario_del_tala', 'ChIJYQ0Hf6IJsZURg03EBiyb0uI', -32.3032364, -59.1443273, 'city', '1'),
('countries_argentina_entre_rios_santa_ana', 'ChIJJWxxormgrZURczLUVQikB4w', -30.8993509, -57.9311154, 'city', '1'),
('countries_argentina_entre_rios_santa_anita', 'ChIJZ_eO_ti-sZURjwASSaw_zE8', -32.1723598, -58.7858561, 'city', '1'),
('countries_argentina_entre_rios_santa_elena', 'ChIJJZLJKSNZs5UR54ohvNBAW64', -30.9461148, -59.7835328, 'city', '1'),
('countries_argentina_entre_rios_san_benito', 'ChIJn9xmEiVPtJURa8xrC7X_kkc', -31.7824593, -60.4393005, 'city', '1'),
('countries_argentina_entre_rios_san_jose_de_feliciano', 'ChIJO6YarZI1TZQRH-pevVFoYDE', -30.3859895, -58.7511513, 'city', '1'),
('countries_argentina_entre_rios_san_justo', 'ChIJGUlqPhcpsJURUS2PQAdMKHM', -32.4445463, -58.4361161, 'city', '1'),
('countries_argentina_entre_rios_san_salvador', 'ChIJK5YMoIEDspUR-uKYEYmB93U', -31.6237603, -58.5049631, 'city', '1'),
('countries_argentina_entre_rios_sauce_de_luna', 'ChIJA7ObmNmps5URY8SKv4_BDl8', -31.2395775, -59.2175534, 'city', '1'),
('countries_argentina_entre_rios_segui', 'ChIJ-zCo01sXtJURwkPcNvjs8jk', -31.9579412, -60.1280072, 'city', '1'),
('countries_argentina_entre_rios_strobel', 'ChIJrWOyTR3NtZURObqLrlctD4M', -32.0530558, -60.6123389, 'city', '1'),
('countries_argentina_entre_rios_tabossi', 'ChIJ806V72MMtJUR00i4XMbOpVM', -31.8023915, -59.9356355, 'city', '1'),
('countries_argentina_entre_rios_ubajay', 'ChIJR8EEMhcDrpUR6etDBdui9PQ', -31.794141, -58.3142332, 'city', '1'),
('countries_argentina_entre_rios_urdinarrain', 'ChIJ5Zb_Ao5EsJURXJ1LC7B83jc', -32.6886776, -58.8867856, 'city', '1'),
('countries_argentina_entre_rios_viale', 'ChIJLW8WlxMOtJURcIiK6btRUdQ', -31.8689913, -60.0084395, 'city', '1'),
('countries_argentina_entre_rios_victoria', 'ChIJnYdeBufCtpURndL19JHBDG4', -32.6215856, -60.1575344, 'city', '1'),
('countries_argentina_entre_rios_villaguay', 'ChIJx3x5ncCAsZUR7CkBrMNB_vM', -31.8677008, -59.0269219, 'city', '1'),
('countries_argentina_entre_rios_villa_elisa', 'ChIJLXbze4nXsZURgl8jr9mxT1k', -32.1641185, -58.400599, 'city', '1'),
('countries_spain_catalonia_carme', 'ChIJn3Jb1RRppBIRBAapP5U60L8', 41.5318282, 1.6203468, 'city', '1'),
('countries_argentina_entre_rios_villa_hernandarias', 'ChIJL4_hgVOatJURcUa0d-iyGhA', -31.2324665, -59.9863402, 'city', '1'),
('countries_argentina_entre_rios_villa_paranacito', 'ChIJZWAWRd4gu5URpLDbjGMn1y4', -33.7146367, -58.6583381, 'city', '1'),
('countries_spain_catalonia_canoves_i_samalus', 'ChIJpzdfb_bOpBIRtjgt9VOO3xA', 41.6939748, 2.3532739, 'city', '0'),
('countries_argentina_formosa_clorinda', 'ChIJg266ccQIXZQRjOW6aF1fd40', -25.2881832, -57.7228203, 'city', '1'),
('countries_argentina_formosa_comandante_fontana', 'ChIJqWkqq0cGQpQRYSQHc-_rNtQ', -25.3323756, -59.6815762, 'city', '1'),
('countries_argentina_formosa_el_colorado', 'ChIJAzAPGKmWQ5QRJKgn4NTBEy0', -26.3055199, -59.371293, 'city', '1'),
('countries_argentina_formosa_formosa', 'ChIJBU_PiOSlXJQRcq4bWubrygs', -26.1857768, -58.1755669, 'city', '1'),
('countries_argentina_formosa_ibarreta', 'ChIJF9tT_z0CapQRpnoRXZAter0', -25.2081615, -59.8620396, 'city', '1'),
('countries_spain_catalonia_canovelles', 'ChIJ9xrwhEvGpBIRi4g4mW9HswI', 41.6237835, 2.2679632, 'city', '0'),
('countries_argentina_formosa_laguna_blanca', 'ChIJkzP94TdOXZQR4QTTTGyV6ig', -25.1266785, -58.2446653, 'city', '1'),
('countries_argentina_formosa_laguna_naick_neck', 'ChIJuy23axZHXZQR1t7e3IOftSI', -25.2218325, -58.1205738, 'city', '1'),
('countries_argentina_formosa_las_lomitas', 'ChIJLxstF7QAa5QR7fj4Dx4_OEM', -24.7011751, -60.5926326, 'city', '1'),
('countries_argentina_formosa_palo_santo', 'ChIJDQdNgENCQpQR8AYGzdnSvXI', -25.563371, -59.3345048, 'city', '1'),
('countries_argentina_formosa_pirane', 'ChIJaYXilABWQpQRFeWkG10EUNk', -25.737788, -59.1115501, 'city', '1'),
('countries_argentina_jujuy_abra_pampa', 'ChIJ8Qx8KUBwBJQRF4IzeuLbL-w', -22.7226738, -65.6969832, 'city', '1'),
('countries_argentina_jujuy_calilegua', 'ChIJkfqFih7BGpQRUmcLFGtSVmg', -23.7745621, -64.7700507, 'city', '1'),
('countries_argentina_jujuy_el_carmen', 'ChIJhS_ztxavG5QRI3JfPhF2rNM', -24.3893458, -65.2616207, 'city', '1'),
('countries_argentina_jujuy_fraile_pintado', 'ChIJ9WPmkGTsGpQRFs1TZakeMwo', -23.9442066, -64.8031487, 'city', '1'),
('countries_argentina_jujuy_humahuaca', 'ChIJf9MnBLvpBJQRxvvK_304sTQ', -23.2029787, -65.3486, 'city', '1'),
('countries_argentina_jujuy_la_mendieta', 'ChIJTZEWa8ZWGpQRNSpvHqzy0Ds', -24.3142376, -64.9668756, 'city', '1'),
('countries_argentina_jujuy_la_quiaca', 'ChIJJwOHPDukBpQRzI_DiTlSfr8', -22.1048149, -65.6026146, 'city', '1'),
('countries_argentina_jujuy_libertador_general_san_martin', 'ChIJb1tPy5nBGpQR4NwLMTbMcZg', -23.8153322, -64.7928261, 'city', '1'),
('countries_argentina_jujuy_palpala', 'ChIJRfOeRq0AG5QRTLkZ8SNe-vA', -24.2584127, -65.2084907, 'city', '1'),
('countries_argentina_jujuy_perico', 'ChIJ7xX90dqsG5QRrWgCytbA0xM', -24.3849622, -65.1208524, 'city', '1'),
('countries_argentina_jujuy_rosario', 'ChIJT438QEirt5URGXW0j5-_sek', -32.935299, -60.6525793, 'city', '1'),
('countries_argentina_jujuy_san_pedro_de_jujuy', 'ChIJ0-V3OmRYGpQRSqFwRw8RsDE', -24.2310284, -64.8683055, 'city', '1'),
('countries_spain_catalonia_canet_de_mar', 'ChIJaTOAXkw2uxIRgASkIeD6AAQ', 41.5998437, 2.5767694, 'city', '0'),
('countries_argentina_jujuy_sey', 'ChIJuQqAG_nWHJQRXKkHo71IZyg', -23.91667, -66.56668, 'city', '1'),
('countries_argentina_jujuy_tilcara', 'ChIJXV7ULUPLBJQRZdNaYO03EMY', -23.5783065, -65.3926788, 'city', '1'),
('countries_argentina_jujuy_yuto', 'ChIJAwitwKOlGpQRf4g7x61gxy8', -23.6427652, -64.4718995, 'city', '1'),
('countries_argentina_la_pampa_abramo', 'ChIJH7GeCY_p6JURqt7PPhRYE2g', -37.8967185, -63.8506326, 'city', '1'),
('countries_argentina_la_pampa_algarrobo_del_aguila', 'ChIJCd9DXSxN35URsAZBQ7VD5yg', -36.398067, -67.1444507, 'city', '1'),
('countries_argentina_la_pampa_alpachiri', 'ChIJ7ZoX5I5F6JUR06Sw3Ost3C8', -37.376877, -63.7733982, 'city', '1'),
('countries_argentina_la_pampa_alta_italia', 'ChIJbwEHsnbGxJUROARQaSuJANM', -35.3320765, -64.118465, 'city', '1'),
('countries_argentina_la_pampa_anguil', 'ChIJSzd15ivDwpUR_4GZiYnISjA', -36.5290206, -64.0128026, 'city', '1'),
('countries_argentina_la_pampa_arata', 'ChIJHacwb1KtxJURE2ToCS_9T1o', -35.639103, -64.3565478, 'city', '1'),
('countries_argentina_la_pampa_ataliva_roca', 'ChIJtXMb6qyrwpURVqp85uP25kM', -37.0318657, -64.2851758, 'city', '1'),
('countries_spain_catalonia_campdevanol', 'ChIJz_OO23JApRIRSS3vjamrCHk', 42.2219838, 2.1683571, 'city', '1'),
('countries_argentina_la_pampa_bernardo_larroude', 'ChIJH68KDPZVxJURVNt957VNUkY', -35.0259654, -63.5827442, 'city', '1'),
('countries_argentina_la_pampa_bernasconi', 'ChIJ25KLqWHd6JURbut3Fg8MCE4', -37.8998284, -63.745728, 'city', '1'),
('countries_argentina_la_pampa_boeuf', 'ChIJ19IJzBuu3JURcrDOatBttAw', -35.9604992, -64.4427401, 'city', '1'),
('countries_argentina_la_pampa_caleufu', 'ChIJIeaLTA1G25URpZvEySQjET0', -35.5946338, -64.5586583, 'city', '1'),
('countries_argentina_la_pampa_catrilo', 'ChIJcQTsuJRawpURNySzVVPKSfU', -36.4067568, -63.4235461, 'city', '1'),
('countries_argentina_la_pampa_colonia_baron', 'ChIJvWOjCLAQw5URK-Ur3cbb5oA', -36.1532593, -63.8525391, 'city', '1'),
('countries_argentina_la_pampa_colonia_santa_maria', 'ChIJHd3oRyFx6JURaqRZfaOmdyY', -37.4947656, -64.2265919, 'city', '1'),
('countries_argentina_la_pampa_doblas', 'ChIJ3zmUgcYZ6JURtdj0MeU8OCc', -37.1506123, -64.0114391, 'city', '1'),
('countries_argentina_la_pampa_eduardo_castex', 'ChIJMy7xVO1Sw5URxIuBR-df_Uo', -35.9160166, -64.2956413, 'city', '1'),
('countries_argentina_la_pampa_embajador_martini', 'ChIJNeF4CqLLxJUROiWgO519QaY', -35.3858223, -64.2841382, 'city', '1'),
('countries_argentina_la_pampa_general_acha', 'ChIJ6bkY87Du55URy81vUh7AYCA', -37.3687938, -64.5998672, 'city', '1'),
('countries_argentina_la_pampa_general_manuel_j_campos', 'ChIJbSzaPFRT6JURWhN_m6JGWi0', -37.4619349, -63.5879882, 'city', '1'),
('countries_argentina_la_pampa_general_pico', 'ChIJP7RHmE99w5URiZ17z67HT2s', -35.6593239, -63.7577887, 'city', '1'),
('countries_argentina_la_pampa_general_san_martin', 'ChIJNVvheIvY6JURnuUGc83EIV0', -37.9788272, -63.6035347, 'city', '1'),
('countries_argentina_la_pampa_guatrache', 'ChIJQa-EceAC6ZURA2aBB9tX_Z0', -37.6700705, -63.5378092, 'city', '1'),
('countries_argentina_la_pampa_ingeniero_luiggi', 'ChIJswitZhgx25URpUlS2wKsYGU', -35.3888525, -64.4672404, 'city', '1'),
('countries_argentina_la_pampa_intendente_alvear', 'ChIJn6TUvYb1xJUREGJ26iNu-wM', -35.2407705, -63.5854267, 'city', '1'),
('countries_argentina_la_pampa_jacinto_arauz', 'ChIJXRZDj7Et6ZUR-ueRTcsPtxA', -38.0831509, -63.4297125, 'city', '1'),
('countries_argentina_la_pampa_la_maruja', 'ChIJBahlTC1y25URVD3S4Ch1TZY', -35.6740803, -64.9418832, 'city', '1'),
('countries_argentina_la_pampa_lonquimay', 'ChIJi_dNPan3wpURL7w6C1PHBNw', -36.4663293, -63.6236252, 'city', '1'),
('countries_argentina_la_pampa_luan_toro', 'ChIJ58pSIwFi3JUR5ceiXikBr9M', -36.2042373, -65.0994692, 'city', '1'),
('countries_argentina_la_pampa_macachin', 'ChIJJ_6ndNkz6JURy6rcxBRHNoM', -37.1371217, -63.6670689, 'city', '1'),
('countries_argentina_la_pampa_miguel_riglos', 'ChIJQWG3XfCDwpURtgSyghyomCY', -36.8564793, -63.6875814, 'city', '1'),
('countries_argentina_la_pampa_monte_nievas', 'ChIJyxSukYNQw5URA3KNy1-EsZA', -35.8614655, -64.1528549, 'city', '1'),
('countries_argentina_la_pampa_parera', 'ChIJnVor07_X2pURvLlH2XwSdaA', -35.1473773, -64.5016384, 'city', '1'),
('countries_argentina_la_pampa_quehue', 'ChIJ12yipw7455URWFRy_UuB5Tw', -37.1218951, -64.5153218, 'city', '1'),
('countries_argentina_la_pampa_quemu_quemu', 'ChIJP7YkZgmnw5URw2FRt_hrHaQ', -36.0548204, -63.5659606, 'city', '1'),
('countries_argentina_la_pampa_quetrequen', 'ChIJJbClO2La2pUR1q7xBecoV4Q', -35.0571363, -64.5231295, 'city', '1'),
('countries_argentina_la_pampa_rancul', 'ChIJJZxXbBfd2pURVxIr0MNSPK0', -35.067957, -64.6839714, 'city', '1'),
('countries_argentina_la_pampa_realico', 'ChIJ_ZWdtf4rxZURz0nZnUdkamM', -35.0380173, -64.2465744, 'city', '1'),
('countries_argentina_la_pampa_ricardo_lavalle', 'ChIJS0bWZZ7XxJUR8DRg8EPqKF8', -35.1318627, -64.1611376, 'city', '1'),
('countries_spain_catalonia_camarles', 'ChIJx1yLETkDoRIRYGOlIeD6AAQ', 40.7849717, 0.6488505, 'city', '0'),
('countries_argentina_la_pampa_santa_isabel', 'ChIJTd40jQ_J2JURVIFl3jTOQhw', -36.2321043, -66.9404965, 'city', '1'),
('countries_argentina_la_pampa_santa_rosa', 'ChIJM4pV9wfNwpURgf1weyqM2ns', -36.620922, -64.2912369, 'city', '1'),
('countries_argentina_la_pampa_santa_teresa', 'ChIJDVZFPGsG6ZUR9NPrnHo5PiE', -37.5752254, -63.4308161, 'city', '1'),
('countries_argentina_la_pampa_toay', 'ChIJX9FminYz3ZURRbWlfev3KZQ', -36.674059, -64.3793694, 'city', '1'),
('countries_argentina_la_pampa_trenel', 'ChIJvXgs_zKmxJUR7AFcWj5mCwI', -35.6985981, -64.1341816, 'city', '1'),
('countries_argentina_la_pampa_veinticinco_de_mayo', 'ChIJ-W3A-_5KdZYR6AmNMDpwXjg', -37.7749575, -67.7134734, 'city', '1'),
('countries_argentina_la_pampa_victorica', 'ChIJnUxlNAtt3JURR5ONxwgFNIE', -36.2165588, -65.4370932, 'city', '1'),
('countries_argentina_la_pampa_villa_mirasol', 'ChIJJYpPbRYUw5URnP8yrvTVsv8', -36.0764092, -63.8860129, 'city', '1'),
('countries_argentina_la_pampa_winifreda', 'ChIJS16jHI0xw5URwPtfUwKzgVk', -36.2247627, -64.2354515, 'city', '1'),
('countries_argentina_la_rioja_aimogasta', 'ChIJZ6gJxK0QJ5QRsQnw43W1HBk', -28.5507672, -66.8151707, 'city', '1'),
('countries_argentina_la_rioja_anillaco', 'ChIJmZo0l1AKJ5QRH4Ui7cJ9_5U', -28.8064359, -66.9414387, 'city', '1'),
('countries_argentina_la_rioja_chamical', 'ChIJUaiwu7gWKZQRLd34SisSX9E', -30.361165, -66.3140926, 'city', '1'),
('countries_spain_catalonia_calonge', 'ChIJTd4LkTgAuxIRgYmIbfuxpcs', 41.8637896, 3.0726468, 'city', '0'),
('countries_argentina_la_rioja_chilecito', 'ChIJxwvDXWdknZYRqom1hnVELQI', -29.1611279, -67.4962016, 'city', '1'),
('countries_argentina_la_rioja_colonia_vichigasta', 'ChIJ62Ixio5QnZYRfwQA9nZT32s', -29.4821749, -67.5143936, 'city', '1'),
('countries_argentina_la_rioja_la_rioja', 'ChIJ5feWM4fZJ5QRysdyiTScHD4', -29.4134538, -66.8564579, 'city', '1'),
('countries_argentina_la_rioja_milagro', 'ChIJdQ6H-4HxK5QR8TOL-nmevMo', -31.009339, -65.9922152, 'city', '1'),
('countries_argentina_la_rioja_nonogasta', 'ChIJtccl-5FdnZYR6I6kvBsS_LY', -29.3009222, -67.5054977, 'city', '1'),
('countries_argentina_la_rioja_ulapes', 'ChIJjTPi6lQLK5QRjR_j8WkAVnY', -31.5732144, -66.237089, 'city', '1'),
('countries_argentina_la_rioja_villa_union', 'ChIJSfpQLMjjnJYRvA44133wWTM', -29.3181764, -68.2282932, 'city', '1'),
('countries_argentina_mendoza_agrelo', 'ChIJZXr0qRN2fpYRWP19nvlCfqk', -33.1194013, -68.8868944, 'city', '1'),
('countries_spain_catalonia_callus', 'ChIJrfhEb-tWpBIRYASkIeD6AAQ', 41.7965959, 1.7830973, 'city', '0'),
('countries_argentina_mendoza_banos_lunlunta', 'ChIJZwa4wGl0fpYRVvfsrBxsmeQ', -33.0666618, -68.8333511, 'city', '1'),
('countries_argentina_mendoza_bowen', 'ChIJx30pLqQFeJYREALaIH7l5VI', -34.9965468, -67.5097744, 'city', '1'),
('countries_argentina_mendoza_chacras_de_coria', 'ChIJH48O3PMKfpYRz_kdhkZ2ZGs', -32.9809081, -68.8769007, 'city', '1'),
('countries_argentina_mendoza_colonia_alvear', 'ChIJsb3tPwgaeJYRbSrPICr0_Fs', -35.0008746, -67.6551239, 'city', '1'),
('countries_argentina_mendoza_el_challao', 'ChIJtUdvMjT9fZYRaXydEnQrnw8', -32.856145, -68.8987695, 'city', '1'),
('countries_argentina_mendoza_gaspar_campos', 'ChIJ36GUc8tweJYRpZy6d5f-Ydc', -34.6536217, -67.4780273, 'city', '1'),
('countries_argentina_mendoza_general_alvear', 'ChIJnfxIxREaeJYRruaK68QaKfo', -34.9779882, -67.6893858, 'city', '1'),
('countries_spain_catalonia_calldetenes', 'ChIJs_1V9M8npRIRl2W_9Gdh2G4', 41.9215421, 2.2975183, 'city', '0'),
('countries_spain_catalonia_caldes_de_montbui', 'ChIJVyWhsbjBpBIRboCKnVzYW_w', 41.6512425, 2.1352039, 'city', '0'),
('countries_argentina_mendoza_godoy_cruz', 'ChIJ5wFq6l0JfpYRN8NYV6xX-5A', -32.9286268, -68.8583963, 'city', '1'),
('countries_argentina_mendoza_junin', 'ChIJGytpyeBcfpYR9hBWdNDrffw', -33.1441469, -68.4836771, 'city', '1'),
('countries_argentina_mendoza_las_heras', 'ChIJobNt7LMIfpYRmhi5KUKmzkw', -32.8420011, -68.8337505, 'city', '1'),
('countries_spain_catalonia_caldes_de_malavella', 'ChIJixRcbA8fuxIR5Czt7TsZVWw', 41.8358025, 2.807864, 'city', '0'),
('countries_argentina_mendoza_la_consulta', 'ChIJ6WtdwuEXfJYRATBGZ1nniIA', -33.7339291, -69.1199066, 'city', '1'),
('countries_argentina_mendoza_la_dormida', 'ChIJudyAr9oPf5YRaR6Kub6q0yo', -33.3482337, -67.9143741, 'city', '1'),
('countries_argentina_mendoza_la_paz', 'ChIJQaa8u19df5YRM_N_IFhyxek', -33.45928, -67.5497468, 'city', '1'),
('countries_argentina_mendoza_lujan_de_cuyo', 'ChIJMYNAAwV1fpYRpL5zk7crxtQ', -32.9980559, -68.8726145, 'city', '1'),
('countries_spain_catalonia_cabrera_de_mar', 'ChIJR-sL9zi0pBIR0AOkIeD6AAQ', 41.5211753, 2.4060513, 'city', '0'),
('countries_argentina_mendoza_maipu', 'ChIJCUhXDJYMfpYRJ5pVuWYZYlc', -32.9584934, -68.7895478, 'city', '1'),
('countries_argentina_mendoza_malargue', 'ChIJn0kvttd-epYR_hwartweP6w', -35.484462, -69.5797495, 'city', '1'),
('countries_argentina_mendoza_mendoza', 'ChIJv3lRxD4JfpYROvoO0vZ4WiA', -32.8894587, -68.8458386, 'city', '1'),
('countries_argentina_mendoza_palmira', 'ChIJhzx71IBpfpYRdbIqmJRuQIA', -33.0503912, -68.5610138, 'city', '1'),
('countries_argentina_mendoza_perdriel', 'ChIJI9aPEZJ1fpYRr_TxZBPhwpU', -33.0764292, -68.8868944, 'city', '1'),
('countries_argentina_mendoza_real_del_padre', 'ChIJKygqQR9AeJYRZ0dUmtx3i6o', -34.8373844, -67.7586177, 'city', '1'),
('countries_argentina_mendoza_rivadavia', 'ChIJOeLqbC5cfpYR3s_XoqWIxm0', -33.1909479, -68.4621744, 'city', '1'),
('countries_argentina_mendoza_rodeo_del_medio', 'ChIJVfMUJTNtfpYRNYEmp9CD2Rk', -32.9945801, -68.6858374, 'city', '1'),
('countries_argentina_mendoza_rodeo_de_la_cruz', 'ChIJuf0ko5MNfpYRRXiW-voNXvo', -32.9231283, -68.7384982, 'city', '1'),
('countries_argentina_mendoza_san_carlos', 'ChIJA6dzu-EYfJYRVCt8rpDiyzw', -33.7721259, -69.0404345, 'city', '1'),
('countries_argentina_mendoza_san_martin', 'ChIJzzr6Vf5CfpYRApE9pO_pdRY', -33.0806497, -68.47057, 'city', '1'),
('countries_argentina_mendoza_san_rafael', 'ChIJpwY9sf0HeZYRnTBz1JYn--A', -34.6128922, -68.3390622, 'city', '1'),
('countries_argentina_mendoza_tunuyan', 'ChIJU3epedAlfJYRw1uP6pNkTD4', -33.5813185, -69.0153361, 'city', '1'),
('countries_argentina_mendoza_tupungato', 'ChIJxyuyygfNfZYR-d9VsU1hsyw', -33.3728036, -69.1475583, 'city', '1'),
('countries_argentina_mendoza_uspallata', 'ChIJZ9nLuC9mh5YRWdhkPcVlXlU', -32.5910827, -69.3478836, 'city', '1'),
('countries_argentina_mendoza_villa_atuel', 'ChIJNw3l5f5GeJYRRYdy8msns5s', -34.8309203, -67.9240453, 'city', '1'),
('countries_argentina_mendoza_villa_nueva', 'ChIJS4IziI0OfpYRu-pvK7L0sBg', -32.90131, -68.7826614, 'city', '1'),
('countries_argentina_misiones_andresito', 'ChIJw7zkbY8y8ZQRujIdo8Xs0PU', -25.6688734, -54.0479569, 'city', '1'),
('countries_argentina_misiones_apostoles', 'ChIJ94T5KiE8VpQReaUQc_Sg__0', -27.9141554, -55.7549371, 'city', '1'),
('countries_argentina_misiones_azara', 'ChIJN9vuWoIQVpQRc9DnWrQ3fQc', -28.0624159, -55.676207, 'city', '1'),
('countries_argentina_misiones_barra_bonita', 'ChIJWbkYvwzj-JQRd6O5eTNuVq8', -27.5996748, -54.845302, 'city', '1'),
('countries_argentina_misiones_bernardo_de_irigoyen', 'ChIJXSxK9Cea8JQRqgammYM2T7U', -26.2630263, -53.6474817, 'city', '1'),
('countries_argentina_misiones_campo_grande', 'ChIJSTCpMJdF-JQRzMbZUhNlWLY', -27.206181, -54.9787679, 'city', '1'),
('countries_argentina_misiones_campo_viera', 'ChIJx3DwmIBc-JQRnX4qw9VwsQQ', -27.3194783, -55.0534925, 'city', '1'),
('countries_argentina_misiones_candelaria', 'ChIJy74hre_FV5QRh2gr6vVET7w', -27.4617416, -55.7448645, 'city', '1'),
('countries_argentina_misiones_capiovi', 'ChIJ4QgTD2oj-JQRkIj9HhUW0Qk', -26.9322174, -55.0520938, 'city', '1'),
('countries_argentina_misiones_cerro_cora', 'ChIJF1s1q2bRV5QRyLMt74u_1cg', -27.5112666, -55.6047461, 'city', '1'),
('countries_argentina_misiones_concepcion_de_la_sierra', 'ChIJnxrnctodVpQRoMSn-Jg7LIY', -27.9949443, -55.5240807, 'city', '1'),
('countries_argentina_misiones_dos_de_mayo', 'ChIJB-FsUqy3-ZQR0-u9jr6hHIQ', -27.0362838, -54.6755593, 'city', '1'),
('countries_argentina_misiones_fracran', 'ChIJYUc0Mpzv-ZQRVoi5TETHk78', -26.7427599, -54.2973353, 'city', '1'),
('countries_argentina_misiones_garupa', 'ChIJ-3K2M-nHV5QRavsTxjv_AM8', -27.454278, -55.8618622, 'city', '1'),
('countries_argentina_misiones_gobernador_roca', 'ChIJ33tls10K-JQRUCpudd1qdjI', -27.189324, -55.4678639, 'city', '1'),
('countries_argentina_misiones_jardin_america', 'ChIJM-NMXSQR-JQRUFhmb9jfUPE', -27.0398571, -55.2307281, 'city', '1'),
('countries_argentina_misiones_leandro_n_alem', 'ChIJm2fug-OF-JQRVtjsMwkTBAU', -27.602819, -55.323688, 'city', '1'),
('countries_argentina_misiones_montecarlo', 'ChIJLSA7f2l495QRWXBLAZzB9O0', -26.5716167, -54.7413116, 'city', '1'),
('countries_argentina_misiones_obera', 'ChIJAbWxBkf1-JQRybTtiGx5pAI', -27.4867802, -55.1203326, 'city', '1'),
('countries_argentina_misiones_posadas', 'ChIJw5YECH--V5QRmns-YnTzv8w', -27.3621374, -55.9008746, 'city', '1'),
('countries_argentina_misiones_puerto_esperanza', 'ChIJcR-2ZsoC95QRgseR091mheA', -26.0227203, -54.6125731, 'city', '1'),
('countries_argentina_misiones_puerto_iguazu', 'ChIJ3ZZO9zqS9pQRB64qlNruuLQ', -25.5971635, -54.578599, 'city', '1'),
('countries_argentina_misiones_puerto_libertad', 'ChIJRRYy22Dj9pQRxATmhxnOo0M', -25.9210525, -54.5839367, 'city', '1'),
('countries_argentina_misiones_puerto_piray', 'ChIJs5s5dsx295QRhB9key8Ynho', -26.4686865, -54.7158799, 'city', '1'),
('countries_argentina_misiones_puerto_rico', 'ChIJ81NjNxgn-JQR0OvU5Q6Ge7I', -26.8063572, -55.0240801, 'city', '1'),
('countries_argentina_misiones_santa_ana', 'ChIJnV_6g-DbV5QRsQkkBIU-L2A', -27.3692482, -55.5817447, 'city', '1'),
('countries_argentina_misiones_santo_pipo', 'ChIJv3etWFgJ-JQRTXQcYK_IXJ0', -27.1428724, -55.4104793, 'city', '1'),
('countries_argentina_misiones_san_ignacio', 'ChIJdRyHiS7eV5QR_WjxxX0nk6o', -27.2575078, -55.5354048, 'city', '1'),
('countries_argentina_misiones_san_pedro', 'ChIJdY_k-vH4-ZQRun4u_2pFugY', -26.621583, -54.1093111, 'city', '1'),
('countries_argentina_misiones_san_vicente', 'ChIJgzZIpP2--ZQR11hJagf-bAE', -26.9954037, -54.4820017, 'city', '1'),
('countries_argentina_misiones_veinticinco_de_mayo', 'ChIJ7frNqV8A-ZQRuoUDsnShxk8', -27.3773233, -54.7454261, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_argentina_misiones_wanda', 'ChIJPXZkOYri9pQRp_a1QvXvsS8', -25.9762399, -54.5672205, 'city', '1'),
('countries_argentina_neuquen_alumine', 'ChIJFQe04I5EEpYRi51Yxmhodiw', -39.2371085, -70.9226667, 'city', '1'),
('countries_argentina_neuquen_andacollo', 'ChIJYflybrvlbZYR9FDjhqjuPMk', -37.1797391, -70.6700266, 'city', '1'),
('countries_argentina_neuquen_anelo', 'ChIJyTMLH2lnC5YRbY9_QAu3lKk', -38.3516044, -68.7874869, 'city', '1'),
('countries_argentina_neuquen_bajada_del_agrio', 'ChIJhzn-xcs3DZYR4IJjZLNsXeQ', -38.4081663, -70.0309213, 'city', '1'),
('countries_argentina_neuquen_barrancas', 'ChIJBVZyo0iPcZYRjUQVYckpxv4', -36.8220629, -69.9161779, 'city', '1'),
('countries_argentina_neuquen_buta_ranquil', 'ChIJfUcrO0YlcpYROSOtLfYQgso', -37.0509274, -69.8794025, 'city', '1'),
('countries_argentina_neuquen_caviahue', 'ChIJK7ToytQGbZYRtwMqcLYRnY4', -37.8189661, -71.0987509, 'city', '1'),
('countries_argentina_neuquen_centenario', 'ChIJq7VpV8BKCpYRv2RxA478n1U', -38.827752, -68.1442932, 'city', '1'),
('countries_argentina_neuquen_chos_malal', 'ChIJlwpsviFycpYRCQEbo-Zj1Dg', -37.3818798, -70.2660329, 'city', '1'),
('countries_spain_catalonia_cabra_del_camp', 'ChIJxdwrNHYDpBIRcetmQ2rtiV0', 41.40391, 1.2987349, 'city', '0'),
('countries_argentina_neuquen_cutral_co', 'ChIJFQcXufBoDJYR5NV3xV3jo_w', -38.9377552, -69.2294588, 'city', '1'),
('countries_argentina_neuquen_huinganco', 'ChIJ88y7SmHjbZYRvA3bClJWPo0', -37.1604895, -70.6236775, 'city', '1'),
('countries_argentina_neuquen_junin_de_los_andes', 'ChIJbQtlQ1iZEZYROX3fbhMXaOM', -39.9510918, -71.0707009, 'city', '1'),
('countries_argentina_neuquen_las_coloradas', 'ChIJUQyJJmYDEpYRLp_uhgmZL_I', -39.5560014, -70.5929886, 'city', '1'),
('countries_argentina_neuquen_las_lajas', 'ChIJNwOidxFZDZYR7Pgolo2wlHc', -38.5238888, -70.3640077, 'city', '1'),
('countries_argentina_neuquen_la_salada', 'ChIJKwvGeaNycpYRfn-xj_83Vdo', -37.3021521, -70.2438694, 'city', '1'),
('countries_argentina_neuquen_loncopue', 'ChIJwe1Y6ixDbZYRtpR_3gpASvA', -38.0696162, -70.611022, 'city', '1'),
('countries_argentina_neuquen_mariano_moreno', 'ChIJMdTFoyUNDZYRIguIkgDxpSw', -38.7624321, -70.0369161, 'city', '1'),
('countries_argentina_neuquen_neuquen', 'ChIJNY7rNbozCpYR9eLjELisIGI', -38.9516784, -68.0591888, 'city', '1'),
('countries_argentina_neuquen_picun_leufu', 'ChIJaz2ti36YDpYR7xVut5HSmqg', -39.5149917, -69.292774, 'city', '1'),
('countries_argentina_neuquen_piedra_del_aguila', 'ChIJ4-NTFTM2DpYRbdhZXSFxX_A', -40.0482871, -70.0754465, 'city', '1'),
('countries_argentina_neuquen_plaza_huincul', 'ChIJ_TXuDNRoDJYR2SjVmo72viM', -38.9326421, -69.1968194, 'city', '1'),
('countries_argentina_neuquen_plottier', 'ChIJSctHQgfMC5YR78nVOzOzZqM', -38.9475672, -68.22885, 'city', '1'),
('countries_argentina_neuquen_rincon_de_los_sauces', 'ChIJnUPLLgOAc5YRPOOo115YV3o', -37.3939948, -68.9270849, 'city', '1'),
('countries_argentina_neuquen_san_martin_de_los_andes', 'ChIJx9AFNnQOEZYROrxmHPs_xHE', -40.1572103, -71.3524436, 'city', '1'),
('countries_argentina_neuquen_senillosa', 'ChIJrYpL5PDDC5YRKi4eqDvIyN0', -39.0100404, -68.4276756, 'city', '1'),
('countries_argentina_neuquen_villa_el_chocon', 'ChIJ5eQDPq39C5YRb0nU-mImreg', -39.2615393, -68.7790878, 'city', '1'),
('countries_argentina_neuquen_villa_la_angostura', 'ChIJk6qP5EK_EJYRNrZwZHi8XiA', -40.7627426, -71.6417984, 'city', '1'),
('countries_argentina_neuquen_zapala', 'ChIJvd4tDZOfDZYR97my0G5cU5g', -38.9031623, -70.0649014, 'city', '1'),
('countries_argentina_rio_negro_allen', 'ChIJjwtGYzgjCpYRlEJHxF4RUSk', -38.976285, -67.8297076, 'city', '1'),
('countries_argentina_rio_negro_bariloche', 'ChIJ5WDIIBV7GpYRZZp7y5euEII', -41.1334722, -71.3102778, 'city', '1'),
('countries_argentina_rio_negro_catriel', 'ChIJN1GPrrzLCpYR0QAAKJNdWJo', -37.879257, -67.7919073, 'city', '1'),
('countries_argentina_rio_negro_cervantes', 'ChIJr3cpkNr_CZYR_oB4sHqe2N8', -39.0541169, -67.3941844, 'city', '1'),
('countries_argentina_rio_negro_chimpay', 'ChIJ7Rja7a2W45URYEvWR3WLcI8', -39.164431, -66.1457519, 'city', '1'),
('countries_argentina_rio_negro_choele_choel', 'ChIJg5PgcwCI5JURfoPYK_5K0Kw', -39.2893209, -65.6623091, 'city', '1'),
('countries_argentina_rio_negro_cinco_saltos', 'ChIJxcH7oQVKCpYR_xUqtePqql0', -38.8312353, -68.0570239, 'city', '1'),
('countries_argentina_rio_negro_cipolletti', 'ChIJ7V9RVJMwCpYR7uXT3-0V9FU', -38.9269441, -67.9760401, 'city', '1'),
('countries_argentina_rio_negro_comallo', 'ChIJ7bLD1BFPBZYRk7_DZbM6Tg0', -41.0318057, -70.2629206, 'city', '1'),
('countries_argentina_rio_negro_contraalmirante_cordero', 'ChIJtYDhI4ZMCpYRKOY_BOc1P4g', -38.7559483, -68.0994944, 'city', '1'),
('countries_argentina_rio_negro_coronel_belisle', 'ChIJcQBipFOP45URUBXSiRZs_xg', -39.1863818, -65.9541176, 'city', '1'),
('countries_argentina_rio_negro_dina_huapi', 'ChIJyWUR6DqHGpYRSCTkriSrjbI', -41.07376, -71.1573986, 'city', '1'),
('countries_argentina_rio_negro_el_bolson', 'ChIJicpJLSm-G5YR9uA2YwLU_KQ', -41.9649235, -71.5353386, 'city', '1'),
('countries_argentina_rio_negro_fray_luis_beltran', 'ChIJ2aMC162A5JURelSX06abQas', -39.3131462, -65.759527, 'city', '1'),
('countries_argentina_rio_negro_general_conesa', 'ChIJpWW2tbCE-pURkv5sysbqQfg', -40.1038277, -64.4588061, 'city', '1'),
('countries_argentina_rio_negro_general_fernandez_oro', 'EjZSw61vIE5lZ3JvLCBHcmFsLiBGZXJuYW5kZXogT3JvLCBSw61vIE5lZ3JvLCBBcmdlbnRpbmEiLiosChQKEgk9Hccn3DoKlhGG1DcUclWmshIUChIJT5aeB-g6CpYRUXa9SP_7Nik', -38.9515266, -67.9107746, 'city', '1'),
('countries_argentina_rio_negro_general_roca', 'ChIJWz9RQOIcCpYRUOsHthvorgk', -39.032803, -67.5892227, 'city', '1'),
('countries_argentina_rio_negro_ingeniero_jacobacci', 'ChIJKZXU_ThTBJYRIR9jSrSt6YI', -41.3298891, -69.5480038, 'city', '1'),
('countries_argentina_rio_negro_ingeniero_luis_a_huergo', 'ChIJdcQ0FIAD4pURuf_EXPcxLSI', -39.0701776, -67.2335204, 'city', '1'),
('countries_argentina_rio_negro_lamarque', 'ChIJMyvWRReF5JURinTn9r8kOJs', -39.4240795, -65.7014299, 'city', '1'),
('countries_argentina_rio_negro_las_grutas', 'ChIJJwsL8S4z-pUR31wWYqZ7xII', -40.8108283, -65.0943303, 'city', '1'),
('countries_argentina_rio_negro_los_menucos', 'ChIJm70QeVOyB5YR5_uocy4J8Cw', -40.8442269, -68.0879935, 'city', '1'),
('countries_argentina_rio_negro_maquinchao', 'ChIJ0XOCvEWPBpYRv82wiIqJQoU', -41.2485581, -68.7019736, 'city', '1'),
('countries_argentina_rio_negro_ministro_ramos_mexia', 'ChIJRXWjnkBc_ZURZWpsucAahkU', -40.5070034, -67.2606116, 'city', '1'),
('countries_argentina_rio_negro_pilcaniyeu', 'ChIJOYUE4Qu8GpYR7FOYjaGl0M8', -41.1226452, -70.7215709, 'city', '1'),
('countries_argentina_rio_negro_rio_colorado', 'ChIJ3-m6lNOC75URcgWnP_N9W8s', -38.9945636, -64.095561, 'city', '1'),
('countries_argentina_rio_negro_san_antonio_oeste', 'ChIJZdebwMI2-pURp9baTjiamps', -40.7299433, -64.9663085, 'city', '1'),
('countries_argentina_rio_negro_sierra_colorada', 'ChIJbVly2AHqB5YRXunC9KXmkhE', -40.5861146, -67.758054, 'city', '1'),
('countries_argentina_rio_negro_sierra_grande', 'ChIJJQ2Gymsc-ZURsFHw4ZH89kM', -41.6061015, -65.3564268, 'city', '1'),
('countries_argentina_rio_negro_valcheta', 'ChIJRxE6eHNh_JURY32yGwb7mEk', -40.6804699, -66.1628028, 'city', '1'),
('countries_argentina_rio_negro_viedma', 'ChIJn09bzj-Y9pURFT4s3dhH6YM', -40.8230663, -62.9939352, 'city', '1'),
('countries_argentina_rio_negro_villa_regina', 'ChIJKUDD2PAZ4pUR6ladSKVFfkc', -39.1017633, -67.0878881, 'city', '1'),
('countries_argentina_salta_aguaray', 'ChIJ79Lw848iD5QRkaSq1L29N3g', -22.2432406, -63.7346423, 'city', '1'),
('countries_argentina_salta_aguas_blancas', 'ChIJ4fWU0sN_BZQRl74MH0WB4Ug', -22.7361245, -64.3542692, 'city', '1'),
('countries_argentina_salta_angostura', 'ChIJZX1wvOi_HpQR01cIKUzOglc', -25.5016747, -66.2238388, 'city', '1'),
('countries_argentina_salta_apolinario_saravia', 'ChIJ_1HTksi_EJQRZOB2ELyB9R0', -24.4328808, -63.9954911, 'city', '1'),
('countries_argentina_salta_cachi', 'ChIJd0e5BEIeHJQRRVAm2F8cxMw', -25.1202353, -66.1624965, 'city', '1'),
('countries_argentina_salta_cafayate', 'ChIJ6e-Xv2wxH5QRaYcx18P2Pkk', -26.0699591, -65.9734202, 'city', '1'),
('countries_argentina_salta_cerrillos', 'ChIJkf8JmIbnG5QR8MiZJeauQ_w', -24.8958166, -65.4871162, 'city', '1'),
('countries_argentina_salta_chicoana', 'ChIJJzmmMO5eGZQRl3esDnIUSHo', -25.1029019, -65.5334079, 'city', '1'),
('countries_argentina_salta_coronel_juan_sola', 'ChIJFR3GL_L0EZQRo1kAYHfvFSY', -23.4706468, -62.8913147, 'city', '1'),
('countries_spain_catalonia_borreda', 'ChIJUTyqcJQRpRIRgAOkIeD6AAQ', 42.1501511, 1.9783666, 'city', '0'),
('countries_argentina_salta_el_galpon', 'ChIJjQetTlDGGZQRZNKX4ZVnLYQ', -25.3848527, -64.6557147, 'city', '1'),
('countries_argentina_salta_embarcacion', 'ChIJZySI_5zlD5QRlCN8-6QQ_lE', -23.210322, -64.0973059, 'city', '1'),
('countries_argentina_salta_general_enrique_mosconi', 'ChIJ9w4LbEwID5QRHVWEyq-rlXs', -22.5890144, -63.8126771, 'city', '1'),
('countries_spain_catalonia_bonmati', 'ChIJjUCQDX3ZuhIRPFD0mv__5Cc', 41.9703892, 2.6641081, 'city', '1'),
('countries_argentina_salta_las_lajitas', 'ChIJK18nbCysEJQREIZBnEhG3qI', -24.7232944, -64.1992422, 'city', '1'),
('countries_argentina_salta_metan', 'ChIJ4zBjLAyvGZQR-8nIQc9mJiI', -25.4942245, -64.9721298, 'city', '1'),
('countries_argentina_salta_oran', 'ChIJl4qZZOb1D5QR_ug-dhjEtfg', -23.128383, -64.3216987, 'city', '1'),
('countries_argentina_salta_pichanal', 'ChIJO2bs4D38D5QR9yxrz41Nq5c', -23.3280512, -64.2247222, 'city', '1'),
('countries_argentina_salta_rosario_de_la_frontera', 'ChIJUZ51zulQGJQRDhvB7IvB-8Y', -25.8004358, -64.9767859, 'city', '1'),
('countries_argentina_salta_rosario_de_lerma', 'ChIJpTv_v8LjG5QRzf5AO10hUeo', -24.9898259, -65.5820891, 'city', '1'),
('countries_argentina_salta_salta', 'ChIJ-bdRUaPDG5QRBvKH1SyZzaU', -24.7821269, -65.4231976, 'city', '1'),
('countries_argentina_salta_salvador_mazza', 'ChIJ93r4-zkvD5QRwoBNM9G9Yk4', -22.0554561, -63.6885824, 'city', '1'),
('countries_argentina_salta_santa_rosa', 'ChIJL1mR7XTNwpUR5dfwwUjIDw0', -36.6080599, -64.2944097, 'city', '1'),
('countries_argentina_salta_san_antonio_de_los_cobres', 'ChIJSe5QoBnsHJQR_nMUd_dphms', -24.2191898, -66.3211702, 'city', '1'),
('countries_argentina_salta_san_lorenzo', 'ChIJGdUqtuNatpURYeTmjlVfa_4', -32.7448292, -60.740474, 'city', '1'),
('countries_argentina_salta_tabacal', 'ChIJoSZ-UIL5D5QRTVeFM3CI2KU', -23.2551748, -64.2438546, 'city', '1'),
('countries_argentina_salta_tartagal', 'ChIJA1Pls-AID5QRjjmxG6wF_6g', -22.5167622, -63.8056084, 'city', '1'),
('countries_argentina_salta_urundel', 'ChIJ8TftGzupGpQRyK-Dgfh3XuI', -23.5577752, -64.3972179, 'city', '1'),
('countries_argentina_santa_cruz_28_de_noviembre', 'ChIJ0SYMnBQcsL0Rp5a93kZa6pc', -51.5843985, -72.2135521, 'city', '1'),
('countries_argentina_santa_cruz_caleta_olivia', 'ChIJH0fDrrHf5b0Rse-pym5XRYY', -46.4324748, -67.524692, 'city', '1'),
('countries_argentina_santa_cruz_canadon_seco', 'ChIJ9w6sP_sL5r0Rk4eDhDcwQ7k', -46.5321806, -67.5518466, 'city', '1'),
('countries_argentina_santa_cruz_comandante_luis_piedra_buena', 'ChIJJ9b7m9tzx70RuyuFF3Cfvu4', -49.983253, -68.9160718, 'city', '1'),
('countries_argentina_santa_cruz_el_calafate', 'ChIJy2KPE8AMu70RadzkiF0D1DA', -50.337969, -72.2647982, 'city', '1'),
('countries_argentina_santa_cruz_el_chalten', 'ChIJMUKRkv4Dvb0R_K5Up1q-xAA', -49.3314941, -72.886325, 'city', '1'),
('countries_argentina_santa_cruz_gobernador_gregores', 'ChIJ309UEMaJv70ROmcqcsYZHzE', -48.7509053, -70.2485017, 'city', '1'),
('countries_spain_catalonia_bonavista', 'ChIJtfDC8oxXoRIRAI3JnOL6AAo', 41.1201544, 1.1917104, 'city', '0'),
('countries_argentina_santa_cruz_las_heras', 'ChIJyfLXa4PY7r0RuzBPU_yL6B8', -46.5394317, -68.929922, 'city', '1'),
('countries_argentina_santa_cruz_los_antiguos', 'ChIJ1ekZvywq7b0RBLIDE2UKWEw', -46.548735, -71.6286831, 'city', '1'),
('countries_argentina_santa_cruz_perito_moreno', 'ChIJbcGWrTb67L0RYInTZyZSwzI', -46.5912473, -70.9260471, 'city', '1'),
('countries_argentina_santa_cruz_pico_truncado', 'ChIJO1b9WYaj6L0Rpr9HT2y8d2k', -46.7963492, -67.9334267, 'city', '1'),
('countries_argentina_santa_cruz_puerto_deseado', 'ChIJMdekQpKf3b0RT0b9eYMAfuE', -47.7515646, -65.9013773, 'city', '1'),
('countries_argentina_santa_cruz_rio_gallegos', 'ChIJ5WYcslL5tr0RAnFkR_JBfKs', -51.6230485, -69.2168291, 'city', '1'),
('countries_argentina_santa_cruz_rio_turbio', 'ChIJeedj6C0dsL0RQCQ7tovjCTo', -51.5359649, -72.3379862, 'city', '1'),
('countries_argentina_santa_cruz_san_julian', 'ChIJ1SqNE5wCxL0RYeOTnolALJg', -49.3068942, -67.7298249, 'city', '1'),
('countries_argentina_santa_fe_acebal', 'ChIJCbR9AkG8t5URkX51067D16Q', -33.2411006, -60.8370004, 'city', '1'),
('countries_argentina_santa_fe_alcorta', 'ChIJ0zggAwXwt5URBDpugldd9qE', -33.5389688, -61.124381, 'city', '1'),
('countries_argentina_santa_fe_alejandra', 'ChIJoQS0kQV4TJQRrCKrpV1eoEU', -29.9085161, -59.8274768, 'city', '1'),
('countries_argentina_santa_fe_alvarez', 'ChIJjR3enHiwt5URn2Jkne48zPo', -33.1317879, -60.8038707, 'city', '1'),
('countries_argentina_santa_fe_alvear', 'ChIJyyfqlFyot5URnIgUIjNaqfs', -33.0574351, -60.6185989, 'city', '1'),
('countries_argentina_santa_fe_ambrosetti', 'ChIJ986BfB_vNZQRIEN83nawnZ4', -30.0133939, -61.5756575, 'city', '1'),
('countries_argentina_santa_fe_angelica', 'ChIJEQmDShiXypUR5P58aP70Hvc', -31.5481284, -61.5496873, 'city', '1'),
('countries_argentina_santa_fe_antonio_pini', 'ChIJQ6fUMXi2N5QRwUJTJjHnRh8', -29.0745373, -61.7363968, 'city', '1'),
('countries_argentina_santa_fe_arequito', 'ChIJscOrmTktyJURMsw-f2S9OPE', -33.144756, -61.4695416, 'city', '1'),
('countries_argentina_santa_fe_arminda', 'ChIJ_TG8JLvAt5URjfyeFqcngQ0', -33.2639676, -60.965848, 'city', '1'),
('countries_argentina_santa_fe_armstrong', 'ChIJrWhYamPpyZURJ3LljJtFZCE', -32.7828968, -61.6040831, 'city', '1'),
('countries_argentina_santa_fe_arocena', 'ChIJAU-mOhXqtZURNGhCpEU32Xw', -32.0819147, -60.9770476, 'city', '1'),
('countries_argentina_santa_fe_arroyo_seco', 'ChIJH2GDEL4Lt5URWHyCgN7W-zo', -33.1564137, -60.5129906, 'city', '1'),
('countries_argentina_santa_fe_arrufo', 'ChIJ8cHKyju-NZQRjWPwoYfTy7c', -30.231781, -61.7289731, 'city', '1'),
('countries_argentina_santa_fe_arteaga', 'ChIJbw7px9W2yZURGffc5WUvC-U', -33.0896463, -61.7899265, 'city', '1'),
('countries_argentina_santa_fe_ataliva', 'ChIJcQuQBy9RNZQRqE0yx3FvjDA', -30.9977485, -61.4323923, 'city', '1'),
('countries_argentina_santa_fe_avellaneda', 'ChIJa4D02J2wTpQRys6aNbruZHs', -29.1174521, -59.6586341, 'city', '1'),
('countries_argentina_santa_fe_barrancas', 'ChIJwxg4dA7ntZURpWL5L3yP3Pg', -32.2333843, -60.9829153, 'city', '1'),
('countries_spain_catalonia_bonastre', 'ChIJB91yJIP2oxIRUkttf6JvEmw', 41.2210731, 1.4399455, 'city', '0'),
('countries_argentina_santa_fe_berabevu', 'ChIJJY0XtEdOyJURN4mFBLkKIF4', -33.3401407, -61.8632966, 'city', '1'),
('countries_argentina_santa_fe_bernardo_de_irigoyen', 'ChIJ00Pj8MPxtZURQ_FZI04ZaMg', -32.1677228, -61.1581986, 'city', '1'),
('countries_argentina_santa_fe_bigand', 'ChIJ2frURprdt5URUnP4DWC4NkM', -33.3723736, -61.1852951, 'city', '1'),
('countries_argentina_santa_fe_bouquet', 'ChIJsVskV_QvypUR51ggxycUi0s', -32.424159, -61.8912626, 'city', '1'),
('countries_argentina_santa_fe_bustinza', 'ChIJQ81hEZgftpURlWusdsr0FgU', -32.7383173, -61.2926073, 'city', '1'),
('countries_argentina_santa_fe_calchaqui', 'ChIJOQKjf8O-S5QRJL8U56lVOzY', -29.8884523, -60.2840357, 'city', '1'),
('countries_argentina_santa_fe_canada_de_gomez', 'ChIJR_tgG2DeyZUR5DrNrnNy_TA', -32.8211646, -61.3953734, 'city', '1'),
('countries_argentina_santa_fe_canada_rosquin', 'ChIJIW0JzddoypURVUx4QH8F4O0', -32.053109, -61.6022068, 'city', '1'),
('countries_argentina_santa_fe_capitan_bermudez', 'ChIJzePKIQFRtpURjry3J7PjKRo', -32.8232975, -60.71767, 'city', '1'),
('countries_argentina_santa_fe_carcarana', 'ChIJKaB74xcltpURmHzDU3CCTgY', -32.8571864, -61.1578169, 'city', '1'),
('countries_argentina_santa_fe_carlos_pellegrini', 'ChIJFRjHO01bypUREv0PSjBlFoI', -32.0504446, -61.7828879, 'city', '1'),
('countries_argentina_santa_fe_carmen', 'ChIJa87Id0hyyJURquiB0GdsmZo', -33.7308003, -61.7601957, 'city', '1'),
('countries_argentina_santa_fe_carmen_del_sauce', 'ChIJ2fAPh_O8t5URZ7bueK6Crxs', -33.2374785, -60.8115626, 'city', '1'),
('countries_argentina_santa_fe_carreras', 'ChIJ0_ukTVf9t5URFoV7ROC2ze0', -33.5971918, -61.3128917, 'city', '1'),
('countries_argentina_santa_fe_casilda', 'ChIJUZIpWDYttpUR8d2ZKpClHeI', -33.044522, -61.1650211, 'city', '1'),
('countries_argentina_santa_fe_cayasta', 'ChIJc6mKTPaUtJURpsXtjjilIjc', -31.1989074, -60.1597187, 'city', '1'),
('countries_argentina_santa_fe_centeno', 'ChIJl47lwQ8GypURC6MmJ3qBsXk', -32.3002697, -61.4094008, 'city', '1'),
('countries_argentina_santa_fe_cepeda', 'ChIJU3aRC9qct5URt-5zio19lVs', -33.3966828, -60.6229774, 'city', '1'),
('countries_argentina_santa_fe_ceres', 'ChIJN83bEoV4NpQRpqKst0LjtF4', -29.8845944, -61.9419946, 'city', '1'),
('countries_argentina_santa_fe_chabas', 'ChIJ5ckLwl0oyJUR-3jBv9lg8Qs', -33.2462328, -61.3570303, 'city', '1'),
('countries_argentina_santa_fe_chanar_ladeado', 'ChIJx54cua9VyJURBUGx2cZTxkU', -33.3226338, -62.0379847, 'city', '1'),
('countries_spain_catalonia_biure_de_gaia', 'ChIJR31yoWsapBIRNmL5rQe42Mk', 41.4905636, 1.3508425, 'city', '0'),
('countries_argentina_santa_fe_colonia_aldao', 'ChIJUXhQ6fs4NZQReP2boKcar2I', -30.9800126, -61.7432139, 'city', '1'),
('countries_argentina_santa_fe_colonia_belgrano', 'ChIJl02l1p95ypURMeEkjSll_Ss', -31.9096388, -61.4020679, 'city', '1'),
('countries_argentina_santa_fe_coronda', 'ChIJo4pyqKO_tZURiaHral1joqI', -31.9734931, -60.920606, 'city', '1'),
('countries_argentina_santa_fe_coronel_arnold', 'ChIJ6YFr7O_Jt5UR3P4o5Eo8BnE', -33.1059245, -60.9660535, 'city', '1'),
('countries_argentina_santa_fe_coronel_bogado', 'ChIJ0eNmuQqet5UR1XiBE9xby0k', -33.3150761, -60.6024315, 'city', '1'),
('countries_argentina_santa_fe_correa', 'ChIJdybJfFJptpURTM4COH6xE8Y', -32.566667, -60.85, 'city', '1'),
('countries_argentina_santa_fe_diaz', 'ChIJQdC1gIbitZUR2BYhdNm6xY4', -32.3712995, -61.0870401, 'city', '1'),
('countries_argentina_santa_fe_egusquiza', 'ChIJ06BTTtJLNZQRD9iM4hxtXQ8', -31.0964501, -61.6278122, 'city', '1'),
('countries_argentina_santa_fe_elisa', 'ChIJRyYVfv-VSpQRGG3RExgNZ9Q', -30.6964965, -61.0476645, 'city', '1'),
('countries_argentina_santa_fe_elortondo', 'ChIJN5W9O9INyJURIIm04934Wgo', -33.7011985, -61.6160889, 'city', '1'),
('countries_argentina_santa_fe_el_trebol', 'ChIJrR1h-_w_ypURqCS3nCuIgVs', -32.2023945, -61.703855, 'city', '1'),
('countries_argentina_santa_fe_emilia', 'ChIJaWhVrWoutZURDa9ORnUkYH4', -31.0584518, -60.7454633, 'city', '1'),
('countries_argentina_santa_fe_empalme_villa_constitucion', 'ChIJw107lORtt5URW3LYpte9FYU', -33.2616226, -60.3822433, 'city', '1'),
('countries_argentina_santa_fe_esmeralda', 'ChIJ436VmqznypURNN2RMnnVQvk', -31.6170072, -61.9329768, 'city', '1'),
('countries_argentina_santa_fe_esperanza', 'ChIJDfb30xcTtZUR0TWaN0z3x0Y', -31.4489859, -60.9303663, 'city', '1'),
('countries_argentina_santa_fe_eusebia', 'ChIJkcLYKI08NZQRbi7A7dC_SgQ', -30.9458868, -61.8577748, 'city', '1'),
('countries_argentina_santa_fe_felicia', 'ChIJ141U3AxatZURbk6PjKFiV40', -31.2453789, -61.2141234, 'city', '1'),
('countries_argentina_santa_fe_fighiera', 'ChIJdWTCJLYMt5URbBBLPFuLEFk', -33.1923016, -60.4704403, 'city', '1'),
('countries_argentina_santa_fe_firmat', 'ChIJfY8slpciyJURc_b9FKrp5hg', -33.4583964, -61.4862572, 'city', '1'),
('countries_argentina_santa_fe_fortin_olmos', 'ChIJffEtKdFQSJQRKYNy0NdvxyM', -28.783333, -60.683333, 'city', '1'),
('countries_argentina_santa_fe_franck', 'ChIJr-Hr0qAMtZURYSclXHiiWl4', -31.5872033, -60.9383524, 'city', '1'),
('countries_argentina_santa_fe_fray_luis_a_beltran', 'ChIJbZLKymRQtpURCz_UCWbBYf8', -32.7911672, -60.7288061, 'city', '1'),
('countries_argentina_santa_fe_fuentes', 'ChIJW0uehBbPt5URU30rVVX6IbM', -33.1726215, -61.073268, 'city', '1'),
('countries_argentina_santa_fe_funes', 'ChIJ56WuOKxNtpUR-EJgKbmbcOc', -32.916996, -60.8108123, 'city', '1'),
('countries_argentina_santa_fe_gaboto', 'ChIJ3TnH-qpxtpURJXO8BBZBSQk', -32.4338718, -60.8191083, 'city', '1'),
('countries_argentina_santa_fe_galvez', 'ChIJjx1PpX2MtZURs9ZuFN7mfUY', -32.029275, -61.2244215, 'city', '1'),
('countries_argentina_santa_fe_garabato', 'ChIJaRKPgksjSZQRE4qyfA7-g2I', -28.9527878, -60.1384844, 'city', '1'),
('countries_argentina_santa_fe_general_lagos', 'EipTYW50YSBGZSwgR3JhbC4gTGFnb3MsIFNhbnRhIEZlLCBBcmdlbnRpbmEiLiosChQKEglffmTgyQm3lRGYyoQQAPd9OxIUChIJxeF-kDAIt5UR-qdUrk29JdE', -33.1147854, -60.5580199, 'city', '1'),
('countries_argentina_santa_fe_gessler', 'ChIJe_wIg6SatZURBXSJ3FyrMGM', -31.8744929, -61.1285118, 'city', '1'),
('countries_argentina_santa_fe_gobernador_crespo', 'ChIJAznr0FQFS5QRS3Avp_t4sAc', -30.3620638, -60.4020713, 'city', '1'),
('countries_argentina_santa_fe_gobernador_galvez', 'ChIJwzf0x1yot5URnJYStNkGEUM', -33.0255203, -60.6337608, 'city', '1'),
('countries_argentina_santa_fe_godoy', 'ChIJ3bFUdEN3t5UR57OUuGEsn9U', -33.3711642, -60.5049247, 'city', '1'),
('countries_argentina_santa_fe_granadero_baigorria', 'ChIJ9VAyycJTtpUR9ypv_wD9lIo', -32.8580243, -60.7035177, 'city', '1'),
('countries_argentina_santa_fe_helvecia', 'ChIJIaQ8IcC9tJURiGA6G4FSZR4', -31.106688, -60.0958071, 'city', '1'),
('countries_argentina_santa_fe_hersilia', 'ChIJUbhLLQLbNZQRce7unGh-0CY', -30.0033156, -61.8375698, 'city', '1'),
('countries_argentina_santa_fe_hipatia', 'ChIJ2dktRThJtZURdFpxz0YWqb8', -31.1255978, -61.0333082, 'city', '1'),
('countries_argentina_santa_fe_hughes', 'ChIJRX2V0Hj_x5URJz-Ga3qy8_w', -33.8014692, -61.3346764, 'city', '1'),
('countries_argentina_santa_fe_humboldt', 'ChIJ9UzaqrFptZUR7FONMSVpKus', -31.3990364, -61.0818911, 'city', '1'),
('countries_argentina_santa_fe_ibarlucea', 'ChIJfeXX4DhOtpURStXuJThinGM', -32.8560929, -60.7870992, 'city', '1'),
('countries_argentina_santa_fe_intiyaco', 'ChIJLWvW5i3aSJQR9DRG3Wx0ndU', -28.6762207, -60.0718302, 'city', '1'),
('countries_argentina_santa_fe_josefina', 'ChIJDeWTGzXXypUR3xsAKdJoLuk', -31.4062507, -61.99199, 'city', '1'),
('countries_argentina_santa_fe_juncal', 'ChIJCbQ8ntcduJUR6LKLadyshPQ', -33.7157947, -61.0482382, 'city', '1'),
('countries_argentina_santa_fe_labordeboy', 'ChIJlV0Kk9b_t5URErqIlG7SuSE', -33.7170179, -61.3159228, 'city', '1'),
('countries_argentina_santa_fe_laguna_paiva', 'ChIJ442nZLXCtJURorFMNezEYV0', -31.182195, -60.394329, 'city', '1'),
('countries_argentina_santa_fe_landeta', 'ChIJNQiBHLFUypURb0P60HGKAV0', -32.0139813, -62.0618752, 'city', '1'),
('countries_argentina_santa_fe_lanteri', 'ChIJ461xmqzaTpQRHH16ScaAMG8', -28.840932, -59.6386246, 'city', '1'),
('countries_argentina_santa_fe_las_parejas', 'ChIJ3_dH6YXvyZURvNM1AWp6Nso', -32.6813791, -61.5264646, 'city', '1'),
('countries_argentina_santa_fe_las_rosas', 'ChIJPdK735UdypURzWGuhG71xyg', -32.4751189, -61.5766664, 'city', '1'),
('countries_argentina_santa_fe_las_toscas', 'ChIJMcATMEkOT5QRZobP8bPS7qI', -28.3543593, -59.260009, 'city', '1'),
('countries_argentina_santa_fe_la_california', 'ChIJDaxkjeT2yZURqBeikdcWGTg', -32.5444298, -61.5481682, 'city', '1'),
('countries_argentina_santa_fe_la_criolla', 'ChIJvYbeMlcIS5QRQflrYVf4XuI', -30.2263217, -60.3630381, 'city', '1'),
('countries_argentina_santa_fe_la_gallareta', 'ChIJey8z48HZS5QRbOTOq2osbl8', -29.5838171, -60.3760434, 'city', '1'),
('countries_argentina_santa_fe_lehmann', 'ChIJ1_zpgsysypURDSHDyu4toho', -31.1240392, -61.4520983, 'city', '1'),
('countries_argentina_santa_fe_llambi_campbell', 'ChIJU_0kNsEktZUR9u6I0zHeMkQ', -31.1830509, -60.7474907, 'city', '1'),
('countries_argentina_santa_fe_logrono', 'ChIJe_T4Q1IVNpQRnRurtIGQoO8', -29.5031057, -61.6961807, 'city', '1'),
('countries_argentina_santa_fe_lopez', 'ChIJravurTWGtZUR_msT9BSK3hA', -31.9042854, -61.2766228, 'city', '1'),
('countries_argentina_santa_fe_los_cardos', 'ChIJCw55yGoXypURt_VqZqRkcH0', -32.3249996, -61.6326593, 'city', '1'),
('countries_argentina_santa_fe_los_molinos', 'ChIJiWWDN1bVt5URwbs8CXt9zK0', -33.1039576, -61.3258444, 'city', '1'),
('countries_argentina_santa_fe_maciel', 'ChIJi7pl2lFytpURCwvdSt-rrzA', -32.4567, -60.8876992, 'city', '1'),
('countries_argentina_santa_fe_maggiolo', 'ChIJL_r51PONyJURHKZsAze0juQ', -33.7247131, -62.2469973, 'city', '1'),
('countries_argentina_santa_fe_malabrigo', 'ChIJdYAONcVWSZQR-s4w5C6xIVk', -29.3489242, -59.9700682, 'city', '1'),
('countries_argentina_santa_fe_margarita', 'ChIJIz-s6fvCS5QRTfdakoyA3nw', -29.6883639, -60.2516349, 'city', '1'),
('countries_argentina_santa_fe_maria_juana', 'ChIJyw8X76btypUR_VCQKBS7P7w', -31.6763989, -61.7504613, 'city', '1'),
('countries_argentina_santa_fe_maria_susana', 'ChIJK09uUew3ypURa0L8HIf3kOw', -32.2602573, -61.9011812, 'city', '1'),
('countries_argentina_santa_fe_maria_teresa', 'ChIJHcxz1urQx5URu5TAevxA7ro', -34.0049918, -61.9005882, 'city', '1'),
('countries_argentina_santa_fe_maximo_paz', 'ChIJP-zfDk3tt5URvhwGsN_IiMk', -33.4839955, -60.9566858, 'city', '1'),
('countries_argentina_santa_fe_melincue', 'ChIJR-k3w-YEyJURPBa-nFGIorI', -33.6592848, -61.457823, 'city', '1'),
('countries_argentina_santa_fe_moises_ville', 'ChIJtxR-8HZmNZQR2--_i8HoZZs', -30.7143054, -61.469815, 'city', '1'),
('countries_argentina_santa_fe_monje', 'ChIJ9VSrrE51tpURBbrPfE_iYJE', -32.3548511, -60.942955, 'city', '1'),
('countries_argentina_santa_fe_montes_de_oca', 'ChIJMd-COUuKyZURl9zHeUvIwOk', -32.5661289, -61.7699435, 'city', '1'),
('countries_argentina_santa_fe_monte_vera', 'ChIJ4UJFe_wDtZURiSjjUW5xTMU', -31.5182437, -60.6786091, 'city', '1'),
('countries_argentina_santa_fe_nelson', 'ChIJm2WtKMkitZURBY1rw3_4rMg', -31.2657973, -60.7613306, 'city', '1'),
('countries_argentina_santa_fe_oliveros', 'ChIJcSbJfFJptpURziDoQ0avIAI', -32.5746765, -60.8499985, 'city', '1'),
('countries_argentina_santa_fe_pavon', 'ChIJBUB9gHpyt5URkN8VdG51WBg', -33.2420469, -60.4059698, 'city', '1'),
('countries_argentina_santa_fe_pavon_arriba', 'ChIJdbVwODqWt5URfzgrLg5W7bg', -33.311959, -60.8236422, 'city', '1'),
('countries_argentina_santa_fe_perez', 'ChIJWZiek4Ctt5UR7tuRsUvmLrM', -32.9991405, -60.7731686, 'city', '1'),
('countries_argentina_santa_fe_peyrano', 'ChIJGaHToM-It5UROKAke0xOfMQ', -33.538643, -60.8007103, 'city', '1'),
('countries_argentina_santa_fe_piamonte', 'ChIJL43qE4NOypURYvOjXxzgUtQ', -32.1433052, -61.9809975, 'city', '1'),
('countries_argentina_santa_fe_pilar', 'ChIJyYz3t-xgtZURjzafytt8tSE', -31.4404029, -61.2596314, 'city', '1'),
('countries_argentina_santa_fe_presidente_roca', 'ChIJa8mmOny0ypURRua5MuGoZq4', -31.2134962, -61.6138677, 'city', '1'),
('countries_argentina_santa_fe_pueblo_andino', 'ChIJiSmLwOxBtpURL-bqy9jh04E', -32.6698507, -60.8763443, 'city', '1'),
('countries_spain_catalonia_begur', 'ChIJQdEQkdhTuhIRQSOL3UIJHDI', 41.9535354, 3.2025863, 'city', '0'),
('countries_argentina_santa_fe_puerto_san_martin', 'ChIJ4zY-iW1btpUR2mvkaDyrYAY', -32.7161131, -60.7314613, 'city', '1'),
('countries_argentina_santa_fe_pujato', 'ChIJfxdD6ag0tpUR0T8EuBUScso', -33.0181915, -61.0437449, 'city', '1'),
('countries_argentina_santa_fe_rafaela', 'ChIJD3yyDUauypURe8Fz1Ca54Ys', -31.2525979, -61.4916422, 'city', '1'),
('countries_argentina_santa_fe_reconquista', 'ChIJq9uiO5q6TpQRlS55ybXVDDU', -29.1448193, -59.6435242, 'city', '1'),
('countries_argentina_santa_fe_recreo', 'ChIJwaprJg8FtZURcQGiIHQDrp0', -31.4908772, -60.7356773, 'city', '1'),
('countries_argentina_santa_fe_ricardone', 'ChIJkVEQgzdFtpURmMdb5XAXhU4', -32.7728842, -60.7850951, 'city', '1'),
('countries_argentina_santa_fe_roldan', 'ChIJL8OlvoJJtpURTF3mK1QDnWg', -32.9002118, -60.9102481, 'city', '1'),
('countries_argentina_santa_fe_romang', 'ChIJf-eoCHkGTJQRYeOj_rsXnUk', -29.5020812, -59.7510098, 'city', '1'),
('countries_argentina_santa_fe_rosario', 'ChIJf2q3Wq6st5URd1uFp2_8nSU', -32.9370216, -60.682901, 'city', '1'),
('countries_argentina_santa_fe_rufino', 'ChIJi5srmEQPxpURm0rPlpClBaU', -34.2632375, -62.712828, 'city', '1'),
('countries_argentina_santa_fe_salto_grande', 'ChIJvXlN6lYWtpURsDl2emAFSn0', -32.6669201, -61.0882883, 'city', '1'),
('countries_argentina_santa_fe_sancti_spiritu', 'ChIJSfff-kIoxpURZG1qXXbsALA', -34.0122289, -62.2339851, 'city', '1'),
('countries_argentina_santa_fe_sanford', 'ChIJXQ3K2LDVt5URAJDImh3t34Y', -33.1456915, -61.2777787, 'city', '1'),
('countries_argentina_santa_fe_santa_clara_de_buena_vista', 'ChIJibPTxAKAtZURVS8KOOk0LVk', -31.7635446, -61.3173505, 'city', '1'),
('countries_argentina_santa_fe_santa_clara_de_saguier', 'ChIJlVbHkwPPypURKROZ7KNQ9-4', -31.3385039, -61.8186659, 'city', '1'),
('countries_argentina_santa_fe_santa_fe', 'ChIJ4YgIxK2ptZURSoACjR5299w', -31.6106578, -60.697294, 'city', '1'),
('countries_argentina_santa_fe_santa_rosa', 'ChIJ8csFia_NwpURFpQQSeIhxf4', -36.616726, -64.2800511, 'city', '1'),
('countries_argentina_santa_fe_santo_tome', 'ChIJX8400XiotZURI1khKJ-mgY4', -31.6727704, -60.7689185, 'city', '1'),
('countries_spain_catalonia_bas', 'ChIJ7Y64J1AzpRIR45wXgQzuYqQ', 42.121378, 2.452299, 'city', '0'),
('countries_argentina_santa_fe_san_carlos_centro', 'ChIJdSq-wXWdtZUR-DdXJ3DWdA4', -31.7259773, -61.091377, 'city', '1'),
('countries_argentina_santa_fe_san_carlos_norte', 'ChIJa-B6Il12tZURA4_D5_tcGBo', -31.6716935, -61.0770812, 'city', '1'),
('countries_argentina_santa_fe_san_cristobal', 'ChIJM5MKwFV5SpQRMhDwyXBzjNI', -30.3111769, -61.2385263, 'city', '1'),
('countries_argentina_santa_fe_san_eduardo', 'ChIJFQiXNLaAyJUR7J3x3LMBhA4', -33.871393, -62.0955663, 'city', '1'),
('countries_argentina_santa_fe_san_genaro', 'ChIJywTk488AypURDi0hTAbKk7I', -32.3694935, -61.3616614, 'city', '1'),
('countries_argentina_santa_fe_san_gregorio', 'ChIJnxoBnZq0x5URKKtQT4zwU0A', -34.3253166, -62.0358519, 'city', '1'),
('countries_argentina_santa_fe_san_guillermo', 'ChIJj9Y91kKwNZQRpN0rlIseveM', -30.35908, -61.9168854, 'city', '1'),
('countries_argentina_santa_fe_san_javier', 'ChIJ-0W3X_xZS5QReZUsAgTEoD4', -30.5795582, -59.9303082, 'city', '1'),
('countries_argentina_santa_fe_san_jeronimo_norte', 'ChIJs7Ugj8FxtZUR6yS9-zxqEEw', -31.5515761, -61.0715522, 'city', '1'),
('countries_argentina_santa_fe_san_jeronimo_sur', 'ChIJSSXmmjk3tpURQvZ72rP9-I4', -32.8790394, -61.0270928, 'city', '1'),
('countries_argentina_santa_fe_san_jorge', 'ChIJC4CsQd_3ypURhhS6_tKh7UQ', -31.8970823, -61.8598807, 'city', '1'),
('countries_argentina_santa_fe_san_jose_del_rincon', 'ChIJh-vfvLSqtZURoTa8BZ5ik_c', -31.6000004, -60.5833282, 'city', '1'),
('countries_argentina_santa_fe_san_jose_de_la_esquina', 'ChIJ_9qhyfi1yZURuQCiBMdelJM', -33.1130905, -61.7021942, 'city', '1'),
('countries_argentina_santa_fe_san_justo', 'ChIJ488H8irWSpQRpJzWlaRyzIU', -30.7893901, -60.5935165, 'city', '1'),
('countries_argentina_santa_fe_san_lorenzo', 'ChIJx3bCr_patpURLL8VFCdRqHA', -32.7477485, -60.7341297, 'city', '1'),
('countries_argentina_santa_fe_san_martin_de_las_escobas', 'ChIJc69q5lpiypURQn6g1dCh8Do', -31.8574142, -61.5720176, 'city', '1'),
('countries_argentina_santa_fe_san_vicente', 'ChIJxdhZDFaOypURLsqM6XESlY0', -31.6981699, -61.5672378, 'city', '1'),
('countries_argentina_santa_fe_sarmiento', 'ChIJf334vTOtSpQRZBmf9Dg6UG4', -31.0597598, -61.168027, 'city', '1'),
('countries_argentina_santa_fe_sastre', 'ChIJDXQzJAzxypURQM776M1PYcA', -31.7685776, -61.8291221, 'city', '1'),
('countries_argentina_santa_fe_sauce_viejo', 'ChIJOSCSDl-ktZURWXgboJqFZkY', -31.7699224, -60.8340608, 'city', '1'),
('countries_argentina_santa_fe_sa_pereyra', 'ChIJ19ejglWcypURZh2ha1xhlng', -31.5703249, -61.3778629, 'city', '1'),
('countries_argentina_santa_fe_suardi', 'ChIJhUvDEZ-pNZQRG1CWCMvRKwA', -30.5344101, -61.9608991, 'city', '1'),
('countries_argentina_santa_fe_sunchales', 'ChIJp19vCABFNZQRe483SGNo4pA', -30.9451714, -61.5607353, 'city', '1'),
('countries_argentina_santa_fe_susana', 'ChIJOQB9cCy7ypURnVAnXrM8hkY', -31.3554539, -61.5180585, 'city', '1'),
('countries_argentina_santa_fe_tacural', 'ChIJH0DjJRRCNZQReN5hqqxcqXk', -30.8460033, -61.5941613, 'city', '1'),
('countries_argentina_santa_fe_teodelina', 'ChIJ0f8pEEWSx5URi7Ibd9lE41U', -34.1862776, -61.5285506, 'city', '1'),
('countries_argentina_santa_fe_timbues', 'ChIJ5aRGCOVCtpURQZq5OysMi5M', -32.6672917, -60.7926806, 'city', '1'),
('countries_argentina_santa_fe_tortugas', 'ChIJTaDbsL-RyZURCuHue9Oh2-c', -32.745267, -61.8205509, 'city', '1'),
('countries_argentina_santa_fe_tostado', 'ChIJRRIN375LNpQRlzQkKhmPWkM', -29.229162, -61.7717196, 'city', '1'),
('countries_argentina_santa_fe_totoras', 'ChIJm7qkUN4atpURhrXNq5rWhtM', -32.5834789, -61.167371, 'city', '1'),
('countries_argentina_santa_fe_venado_tuerto', 'ChIJXVJ6JLNkyJUR0v2A85N0wZg', -33.7455566, -61.9690161, 'city', '1'),
('countries_argentina_santa_fe_vera', 'ChIJv6vet-NfSZQRpuGFhp0aKxk', -29.4593067, -60.2149272, 'city', '1'),
('countries_argentina_santa_fe_vera_y_pintado', 'ChIJZ4hpvAOnS5QRqk7T8cWMtSc', -30.1430457, -60.3416264, 'city', '1'),
('countries_argentina_santa_fe_vila', 'ChIJCXsNuhkzNZQRN3-OtoQ8rHM', -31.1905053, -61.833018, 'city', '1'),
('countries_argentina_santa_fe_villa_amelia', 'ChIJ74hwJa2mt5UR2BQt3ITk6ck', -33.1762328, -60.6659406, 'city', '1'),
('countries_argentina_santa_fe_villa_canas', 'ChIJJ01JALrox5URjXZRUCIGQBY', -34.0042311, -61.6057322, 'city', '1'),
('countries_argentina_santa_fe_villa_constitucion', 'ChIJ9aFLkU5st5URS0ObNGfOkVM', -33.2305999, -60.342188, 'city', '1'),
('countries_argentina_santa_fe_villa_eloisa', 'ChIJfSYzQwrFyZURSwE_XNpLgbk', -32.9658845, -61.5584798, 'city', '1'),
('countries_argentina_santa_fe_villa_guillermina', 'ChIJW7aFBIpqT5QRfuD_XanoNsw', -28.2382372, -59.4544268, 'city', '1'),
('countries_argentina_santa_fe_villa_minetti', 'ChIJ53ARvQryN5QRfwaOn4HDxXQ', -28.6241744, -61.6290724, 'city', '1'),
('countries_argentina_santa_fe_villa_ocampo', 'ChIJGyBPDO0bT5QRZa6Lhu65dWA', -28.4979894, -59.3626408, 'city', '1'),
('countries_argentina_santa_fe_villa_trinidad', 'ChIJZ9cd8xK4NZQR38G747vvis8', -30.2149601, -61.8752518, 'city', '1'),
('countries_argentina_santa_fe_wheelwright', 'ChIJjQUeqcYDuJURSEIa8mhsBDk', -33.792328, -61.2116519, 'city', '1'),
('countries_argentina_santa_fe_zavalla', 'ChIJz1slRY20t5URyvygvOl0RNU', -33.0189687, -60.8830081, 'city', '1'),
('countries_spain_catalonia_balaguer', 'ChIJL2niMaTxphIRYg1BZKx1FX8', 41.7877143, 0.8008388, 'city', '0'),
('countries_argentina_santiago_del_estero_anatuya', 'ChIJuZ7h6gIeOpQRUdJr3UXp9k0', -28.4605787, -62.8343649, 'city', '1'),
('countries_argentina_santiago_del_estero_argentina', 'ChIJa_kz32pSO5QR1shkd-0YnZo', -27.7833574, -64.264167, 'city', '1'),
('countries_argentina_santiago_del_estero_bandera', 'ChIJ8dybLoZtN5QRj5pX0XmJd30', -28.888195, -62.2688745, 'city', '1'),
('countries_argentina_santiago_del_estero_campo_gallo', 'ChIJS17lH77VPZQRSTzO5-Gaf-M', -26.5834765, -62.8452392, 'city', '1'),
('countries_spain_catalonia_avinyonet_de_puigventos', 'ChIJ4TbwN0KSuhIR4GWkIeD6AAQ', 42.2536062, 2.9126022, 'city', '0'),
('countries_argentina_santiago_del_estero_clodomira', 'ChIJrbSq1ManPJQRHvQBSisD0ks', -27.5761454, -64.1315953, 'city', '1'),
('countries_argentina_santiago_del_estero_fernandez', 'ChIJm0R_5sEUO5QRprDVXOT94QE', -27.9231574, -63.8925774, 'city', '1'),
('countries_argentina_santiago_del_estero_frias', 'ChIJzxmuSU-oJZQRBWaJKJ4J6_o', -28.6375538, -65.1287605, 'city', '1'),
('countries_spain_catalonia_arenys_de_mar', 'ChIJW2liWwU2uxIRN5v-nZer0MM', 41.5783288, 2.5346498, 'city', '0'),
('countries_argentina_santiago_del_estero_la_punta', 'ChIJxc6NpWvhJJQR9s6ANJS5H-k', -28.3694844, -64.7928403, 'city', '1'),
('countries_argentina_santiago_del_estero_los_juries', 'ChIJATjGfW_TOZQRAMRnT29li54', -28.4655312, -62.1085792, 'city', '1'),
('countries_argentina_santiago_del_estero_los_telares', 'ChIJ3cHuP6yFMJQRSH1JONSS-vI', -28.984566, -63.446691, 'city', '1'),
('countries_argentina_santiago_del_estero_monte_quemado', 'ChIJKWLGj48HFpQRe-OviBYVDp4', -25.8019117, -62.8354813, 'city', '1'),
('countries_argentina_santiago_del_estero_nueva_esperanza', 'ChIJl2JBteD9F5QRgArSrcvOsxQ', -26.2025489, -64.2391857, 'city', '1'),
('countries_argentina_santiago_del_estero_pampa_de_los_guanacos', 'ChIJg4AaCBq7P5QRwJuE1g6EMa4', -26.2275411, -61.8363416, 'city', '1'),
('countries_argentina_santiago_del_estero_quimili', 'ChIJNR0lqeUUOZQRhLtStVNb2OQ', -27.6450219, -62.4134894, 'city', '1'),
('countries_argentina_santiago_del_estero_santa_isabel', 'ChIJ-ZyAWBrJ2JURbNrHLfPFd9U', -36.233722, -66.936239, 'city', '1'),
('countries_argentina_santiago_del_estero_santiago_del_estero', 'ChIJa_kz32pSO5QR1shkd-0YnZo', -27.7833574, -64.264167, 'city', '1'),
('countries_argentina_santiago_del_estero_selva', 'ChIJq6h-3z99NpQRyjttCznRE5A', -29.7673964, -62.047275, 'city', '1'),
('countries_argentina_santiago_del_estero_sumampa', 'ChIJJZ9EjKPwMJQRnze2xi4I-TU', -29.3809362, -63.4725564, 'city', '1'),
('countries_argentina_santiago_del_estero_termas_de_rio_hondo', 'ChIJza-qnGZuI5QReIWcsLj9cD8', -27.4985572, -64.8605362, 'city', '1'),
('countries_spain_catalonia_altafulla', 'ChIJT4m-1XHwoxIRcHHimBIzKhU', 41.1469855, 1.3806902, 'city', '0'),
('countries_spain_catalonia_angles', 'ChIJwbG0SpPZuhIRNQ_SeSDrTD0', 41.9392441, 2.6288523, 'city', '0'),
('countries_argentina_santiago_del_estero_villa_rio_hondo', 'ChIJDaFTGndwI5QR_VK4x0DDxog', -27.5929065, -64.9130127, 'city', '1'),
('countries_argentina_san_juan_albardon', 'ChIJuV6zMytogZYRUDMLvSv902Y', -31.4508462, -68.518554, 'city', '1'),
('countries_argentina_san_juan_algarrobo_verde', 'ChIJDyBnwwYFgZYRCCvg3aIRkdc', -31.7410159, -68.2840137, 'city', '1'),
('countries_argentina_san_juan_caucete', 'ChIJ9XljRP8OgZYRKxvsKmQ3YSQ', -31.6541691, -68.2852783, 'city', '1'),
('countries_argentina_san_juan_chimbas', 'ChIJLTiyXgJCgZYRfXSDDk3-hXY', -31.4965964, -68.5317615, 'city', '1'),
('countries_argentina_san_juan_nueve_de_julio', 'ChIJh3gOMWkRgZYRsOp4s3_wlMY', -31.6531785, -68.3927121, 'city', '1'),
('countries_argentina_san_juan_pocito', 'ChIJHZhEujA8gZYR-lR99TXGn4o', -31.6833305, -68.5833511, 'city', '1'),
('countries_argentina_san_juan_ramblon', 'ChIJl2z54fW4gJYR_uUVJwJMwTI', -32.3107255, -68.6330284, 'city', '1'),
('countries_argentina_san_juan_rivadavia', 'ChIJxZdzZBxHgZYRYYEqubFGnAo', -31.5294819, -68.5940558, 'city', '1'),
('countries_argentina_san_juan_rodeo', 'ChIJF-6HKPe8hJYRb15NsVwrIXk', -30.2136891, -69.1429418, 'city', '1'),
('countries_spain_catalonia_alpicat', 'ChIJQS9fQ4UepxIRELukIeD6AAQ', 41.669674, 0.554149, 'city', '0'),
('countries_argentina_san_juan_san_jose_de_jachal', 'ChIJ3W--qbBng5YRpP9FDVvyQr4', -30.2408199, -68.7471628, 'city', '1'),
('countries_argentina_san_juan_san_juan', 'ChIJl9Q8oylAgZYRs_w8I6Cj878', -31.5351074, -68.5385941, 'city', '1'),
('countries_argentina_san_juan_villa_krause', 'ChIJK0ydJwRAgZYR6enZoPv5SBg', -31.5662323, -68.5343468, 'city', '1'),
('countries_spain_catalonia_alforja', 'ChIJey3XSsxLoRIRsFilIeD6AAQ', 41.2066087, 0.9533984, 'city', '0'),
('countries_argentina_san_luis_buena_esperanza', 'ChIJhSYsIiZ62pUR8cdkxWLWMKo', -34.7604046, -65.2505133, 'city', '1'),
('countries_spain_catalonia_alcarras', 'ChIJbetKVwcYpxIRYLqkIeD6AAQ', 41.5632511, 0.5244194, 'city', '0'),
('countries_argentina_san_luis_casimiro_gomez', 'ChIJJwg69ZRY2pURqtF58V1r6xo', -35.0833282, -65.1166687, 'city', '1'),
('countries_argentina_san_luis_justo_daract', 'ChIJp6X82H0G0ZURT7LcprWhpDc', -33.8582206, -65.1794895, 'city', '1'),
('countries_argentina_san_luis_merlo', 'ChIJd4Mip2Xh0pURS1g4rNwodSQ', -32.3478326, -65.0157565, 'city', '1'),
('countries_argentina_san_luis_naschel', 'ChIJYbH6bXW805URrSE4B6lMWtA', -32.9167112, -65.3719906, 'city', '1'),
('countries_argentina_san_luis_quines', 'ChIJPd638A5X05URiaybBAEymps', -32.2337053, -65.8055325, 'city', '1'),
('countries_argentina_san_luis_san_francisco_del_monte_de_oro', 'ChIJz4wDDFuR1JURU1mOSxA_eXc', -32.6001667, -66.1253348, 'city', '1'),
('countries_argentina_san_luis_san_luis', 'ChIJzaZsGVQ51JURg8ye1LTjwn8', -33.3017267, -66.3377522, 'city', '1'),
('countries_argentina_san_luis_tilisarao', 'ChIJSwralx-m05URgg8WWJ9O6Vc', -32.7317276, -65.287796, 'city', '1'),
('countries_argentina_san_luis_villa_mercedes', 'ChIJp2x5iIlq0ZURNS5mlEBkjBc', -33.6754417, -65.4580688, 'city', '1'),
('countries_argentina_tierra_del_fuego_rio_grande', 'ChIJy8F-qUQWS7wRKHNSAUU_J0g', -53.7860374, -67.7002243, 'city', '1'),
('countries_argentina_tierra_del_fuego_tolhuin', 'ChIJNWj440zCS7wRBc1ujPOGXIg', -54.5108893, -67.1929895, 'city', '1'),
('countries_argentina_tierra_del_fuego_ushuaia', 'ChIJvwnRurUiTLwR_OtDuj1HmFQ', -54.8019121, -68.3029511, 'city', '1'),
('countries_argentina_tucuman_acheral', 'ChIJ05qxX4ZKIpQRSbD-7Szm9oc', -27.1203839, -65.4682391, 'city', '1'),
('countries_argentina_tucuman_aguilares', 'ChIJdakXu2fEI5QRtz3w9zwse3w', -27.4315089, -65.6147162, 'city', '1'),
('countries_argentina_tucuman_alderetes', 'ChIJGVe_HSVfIpQRBx5dDUUBUks', -26.8166695, -65.1333313, 'city', '1'),
('countries_argentina_tucuman_amaicha_del_valle', 'ChIJ11QNMfD-IZQRnMp2t3i03vs', -26.5938655, -65.9228956, 'city', '1'),
('countries_argentina_tucuman_banda_del_rio_sali', 'ChIJKToJj9bwIpQReDJojvUfzdM', -26.8341103, -65.1654205, 'city', '1'),
('countries_argentina_tucuman_bella_vista', 'ChIJcXnULAhOIpQRC99y27tdySY', -27.0293086, -65.3032404, 'city', '1'),
('countries_argentina_tucuman_burruyacu', 'ChIJffoHk4yXIpQRyaWK1OOkNRc', -26.499424, -64.7419434, 'city', '1'),
('countries_argentina_tucuman_concepcion', 'ChIJUxt04GnPI5QRy4akDCm7eQI', -27.3453363, -65.5883464, 'city', '1'),
('countries_argentina_tucuman_famailla', 'ChIJZ3ZuhV9JIpQRNPlYmHyps10', -27.0560551, -65.4021683, 'city', '1'),
('countries_argentina_tucuman_juan_bautista_alberdi', 'ChIJN79iR_7oI5QRb63l4J0OPPY', -27.5860327, -65.6240762, 'city', '1'),
('countries_argentina_tucuman_la_cocha', 'ChIJi1vrp0LxI5QReq2aeRiFdrM', -27.772779, -65.5839063, 'city', '1'),
('countries_argentina_tucuman_la_trinidad', 'ChIJ44czMiLHI5QR4o4GxHg-RYA', -27.4105326, -65.5166069, 'city', '1'),
('countries_argentina_tucuman_los_ralos', 'ChIJ1eOHh1H3IpQRTGgRMqShUcg', -26.8870919, -64.9992353, 'city', '1'),
('countries_argentina_tucuman_monteros', 'ChIJwVS6M7XKI5QRoFGVS2sxK50', -27.1628947, -65.4971734, 'city', '1'),
('countries_argentina_tucuman_pacara', 'ChIJHVifETdYIpQRFQjXxJMIrc8', -26.889809, -65.1297928, 'city', '1'),
('countries_spain_catalonia_aiguafreda', 'ChIJ5QWt_lPapBIR4AKkIeD6AAQ', 41.7831042, 2.2679632, 'city', '0'),
('countries_argentina_tucuman_san_miguel', 'ChIJA2nF1pI3IpQRJ2XFtZJbjfg', -26.8082848, -65.2175903, 'city', '1'),
('countries_argentina_tucuman_san_miguel_de_tucuman', 'ChIJA2nF1pI3IpQRJ2XFtZJbjfg', -26.8082848, -65.2175903, 'city', '1'),
('countries_argentina_tucuman_simoca', 'ChIJe0VtzRixI5QR6Ur5Aq_DONk', -27.2630357, -65.3578262, 'city', '1'),
('countries_argentina_tucuman_tafi_del_valle', 'ChIJzygN6HcYIpQRRehyEJAG-Hw', -26.8516667, -65.7098167, 'city', '1'),
('countries_argentina_tucuman_tafi_viejo', 'ChIJIeGo3btnIpQR6xdqcpQNmjo', -26.7324791, -65.2670288, 'city', '1'),
('countries_argentina_tucuman_villa_quinteros', 'ChIJZyCnsufLI5QR0v0cM5yquMQ', -27.2529802, -65.5494212, 'city', '1'),
('countries_argentina_tucuman_yerba_buena', 'ChIJ-7_hLjpDIpQRsZgN7j4I1MU', -26.8119881, -65.3013529, 'city', '1'),
('countries_armenia_aragatsotn', 'ChIJu5vMvK-NakARdSaOkL-i8s8', 40.2591212, 44.1793418, 'region', '1'),
('countries_spain_castille_la_mancha_villarta', 'ChIJG3NrzeUaZw0R_876OdRFBzk', 39.4424232, -1.6505672, 'city', '1'),
('countries_armenia_armavir', 'ChIJywSKztfvakARa1TxQigHnXw', 40.1555525, 44.0388482, 'region', '1'),
('countries_armenia_armenia_s_lands', 'ChIJx7pz54RWFUARIy2C63p1tNA', 40.069099, 45.038189, 'region', '1'),
('countries_armenia_gegharkunik', 'ChIJP5rPIWAIQEARVYZhNNtrrlc', 40.2500421, 45.1463314, 'region', '1'),
('countries_armenia_kotayk', 'ChIJU2bMV0-gakARkOppPQdINQY', 40.2791429, 44.6600779, 'region', '1'),
('countries_armenia_lori', 'ChIJX-qE8sHRQUARP4B0IPemuXc', 40.9698452, 44.4900138, 'region', '1'),
('countries_armenia_shirak', 'ChIJKxG3gsrwQUARo0_yq9d7eTg', 40.8384463, 43.9142395, 'region', '1'),
('countries_armenia_syunik', 'ChIJBycSig89FkARRwsD71m8uzQ', 39.2028881, 46.4798169, 'region', '1'),
('countries_armenia_tavush', 'ChIJ8drYtTXnQEARtHuPKNjW5Ok', 40.9152268, 45.4032387, 'region', '1'),
('countries_armenia_vayots_dzor', 'ChIJjdSPlBbVP0AR8FAOsW6cX8k', 39.8172259, 45.6727334, 'region', '1'),
('countries_armenia_yerevan', 'ChIJW4v8uNqiakARalLah655FD0', 40.1872023, 44.515209, 'region', '1'),
('countries_armenia_aragatsotn_aparan', 'ChIJ9_VhAr3RQUARqvRtNmrBzO8', 40.5922068, 44.3574379, 'city', '1'),
('countries_armenia_aragatsotn_ashtarak', 'ChIJe2q80KGaakAR9QQXI0YypiE', 40.2928735, 44.3505077, 'city', '1'),
('countries_armenia_aragatsotn_avan', 'ChIJKYwJTASJakARnwQ-WALWTkU', 40.3364361, 44.1674252, 'city', '1'),
('countries_armenia_aragatsotn_byurakan', 'ChIJf5b7EvOFakARQZCdR1vzNtE', 40.3373909, 44.272133, 'city', '1'),
('countries_armenia_aragatsotn_mastara', 'ChIJ_8c0ZidvakAR8i9Jf95UfzE', 40.4470532, 43.8818687, 'city', '1'),
('countries_armenia_aragatsotn_t_alin', 'ChIJa13kHshnakARbNF1IeQ5ptE', 40.3822607, 43.8782737, 'city', '1'),
('countries_armenia_aragatsotn_voskevaz', 'ChIJJcKMuNKRakARu9nYObmpdrk', 40.2807751, 44.293988, 'city', '1'),
('countries_armenia_ararat_ararat', 'ChIJ614KE30wFUARpk-LER8BVi4', 39.8551211, 44.6942731, 'city', '1'),
('countries_armenia_ararat_artashat', 'ChIJkayFHnHLakAR6B4PBSsqxng', 39.9535181, 44.5519782, 'city', '1'),
('countries_armenia_ararat_aygavan', 'ChIJiQeUnT8xFUARVEYTmpGjEhM', 39.8752693, 44.6683679, 'city', '1'),
('countries_armenia_ararat_byuravan', 'ChIJe-wuLa7JakARusuME2sMMgU', 40.0150745, 44.5191627, 'city', '1'),
('countries_armenia_ararat_dashtavan', 'ChIJ4cZ9UKLAakARpagBwg2wqvA', 40.1014047, 44.3906123, 'city', '1'),
('countries_armenia_ararat_hayanist', 'ChIJu1nIhoG_akARTSjprzzXpwI', 40.121789, 44.3694867, 'city', '1'),
('countries_armenia_ararat_lusarrat', 'ChIJm_ZhjDkyFUARHpPmg6B6x1c', 39.872384, 44.5906691, 'city', '1'),
('countries_armenia_ararat_masis', 'ChIJ590kdp_HakARwisFCYObg14', 40.0634518, 44.4410909, 'city', '1'),
('countries_armenia_ararat_nor_kharberd', 'ChIJg3D8RPS4akARfiRGURuAVO0', 40.0891602, 44.4792997, 'city', '1'),
('countries_armenia_ararat_sis', 'ChIJnxBLQ-jGakARorvO1500yDA', 40.0577703, 44.3860136, 'city', '1'),
('countries_armenia_ararat_sisavan', 'ChIJx-TJNAQ0FUARY70WlTzEJD8', 39.905877, 44.6681369, 'city', '1'),
('countries_armenia_ararat_vedi', 'ChIJD24HZXw2FUARRhGz4uh--9A', 39.9137183, 44.7199404, 'city', '1'),
('countries_armenia_ararat_zangakatun', 'ChIJFwwWrelqFUARbdGDNw_Yhps', 39.8198558, 45.0414019, 'city', '1'),
('countries_armenia_armavir_aknalich', 'ChIJbbbFGRzsakARWtg-cO5KNrg', 40.1405463, 44.1607005, 'city', '1'),
('countries_armenia_armavir_armavir', 'ChIJywSKztfvakARa1TxQigHnXw', 40.1555525, 44.0388482, 'city', '1'),
('countries_armenia_armavir_norakert', 'ChIJETBpOzaUakART9_UtNq7pS0', 40.193601, 44.3475789, 'city', '1'),
('countries_armenia_armavir_parakar', 'ChIJUQktfhi-akARHudUj7PQbS8', 40.1682988, 44.4053332, 'city', '1'),
('countries_armenia_armavir_vagharshapat', 'ChIJ7fXVjtGUakARNiHKh3Pc6Ps', 40.1632626, 44.2935926, 'city', '1'),
('countries_spain_castille_la_mancha_villanueva_de_alcardete', 'ChIJs1GcSVUxaA0RMH5NvvNAAwQ', 39.6741279, -3.0375914, 'city', '0'),
('countries_armenia_gegharkunik_chambarak', 'ChIJ0_iCaqxhQEARSe8jzeH78_4', 40.5990983, 45.3529401, 'city', '1'),
('countries_armenia_gegharkunik_gavarr', 'ChIJ3yj97LsNQEARiQ6Fn0c_UGY', 40.3513253, 45.1272675, 'city', '1'),
('countries_armenia_gegharkunik_geghamavan', 'ChIJE5F7JclHQEARnz1qUPj3pmo', 40.56594, 44.8947239, 'city', '1'),
('countries_armenia_gegharkunik_martuni', 'ChIJT7YqF7j6P0ARC5aX3bF_9M0', 40.1364187, 45.3023323, 'city', '1'),
('countries_armenia_gegharkunik_sevan', 'ChIJcet3lMNGQEARdo3S2CqQW-s', 40.5484721, 44.9618132, 'city', '1'),
('countries_armenia_gegharkunik_verin_getashen', 'ChIJ3VELXgX7P0ARN4kMMVrZV6s', 40.1314496, 45.2501779, 'city', '1'),
('countries_armenia_kotayk_abovyan', 'ChIJKSOf7MOhakARtaMoDA6f7lw', 40.2715286, 44.633383, 'city', '1'),
('countries_armenia_kotayk_alap_ars', 'ChIJV0eGy8klQEARdvPm_RnkR7U', 40.4198903, 44.6327565, 'city', '1'),
('countries_armenia_kotayk_aramus', 'ChIJAzS-1g-hakAR0WRiKTn6uyg', 40.2469366, 44.6655525, 'city', '1'),
('countries_armenia_kotayk_arzni', 'ChIJa6ZIYKefakARJ46iQCPLMpQ', 40.2982207, 44.5971488, 'city', '1'),
('countries_armenia_kotayk_balahovit', 'ChIJW63pIfWhakARi6wZwc9r5jE', 40.2544003, 44.6027766, 'city', '1'),
('countries_armenia_kotayk_byureghavan', 'ChIJMb0yfUmeakARkuxvare8KN4', 40.3137085, 44.5970067, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_armenia_kotayk_charentsavan', 'ChIJ8Q5NOjskQEARnUEw42h3I3c', 40.4018115, 44.6433958, 'city', '1'),
('countries_armenia_kotayk_geghashen', 'ChIJT-ew5SCnakAR6aOx7ZgVI_E', 40.2265321, 44.723164, 'city', '1'),
('countries_armenia_kotayk_hrazdan', 'ChIJlbfPsiY6QEARnF1B7UA13k4', 40.5353559, 44.7695698, 'city', '1'),
('countries_armenia_kotayk_lerrnanist', 'ChIJ4UnWJJU7QEARnJrt3RzhuME', 40.4670674, 44.7899209, 'city', '1'),
('countries_armenia_kotayk_nor_geghi', 'ChIJ9QbErgSeakARV33-3mo63-4', 40.3187714, 44.5760235, 'city', '1'),
('countries_armenia_kotayk_nor_hachyn', 'ChIJQaxqewCfakAROloXyV_3o5A', 40.3007262, 44.5814295, 'city', '1'),
('countries_armenia_kotayk_saralanj', 'ChIJ6SUqsnYoQEARIRC0kRsXI3I', 40.3999002, 44.5175576, 'city', '1'),
('countries_armenia_kotayk_tsaghkadzor', 'ChIJk573uy83QEARWt-cP1qG4Z0', 40.5317434, 44.7159759, 'city', '1'),
('countries_armenia_kotayk_yeghvard', 'ChIJg4KmyXScakARP7FU5GAi1qM', 40.3234491, 44.4869872, 'city', '1'),
('countries_armenia_lori_alaverdi', 'ChIJ92o_DwFxQUAR1Ad257hIKTU', 41.0911538, 44.6590356, 'city', '1'),
('countries_armenia_lori_gogaran', 'ChIJb7gIQY-SQUARE7_Pmtzozi4', 40.894048, 44.1992229, 'city', '1'),
('countries_armenia_lori_margahovit', 'ChIJxXFuTHuxQUARvL1s9vFd1jk', 40.7348487, 44.6829567, 'city', '1'),
('countries_armenia_lori_pushkino', 'ChIJC1n2oU-aQUARTjRpWIiw_Nw', 40.9588873, 44.4210985, 'city', '1'),
('countries_armenia_lori_spitak', 'ChIJUaMn5MmUQUARUQla97OocIg', 40.8318278, 44.2797884, 'city', '1'),
('countries_armenia_lori_tashir', 'ChIJXQ-6d3mAQUARDltXvWoFjjI', 41.1159648, 44.285778, 'city', '1'),
('countries_armenia_lori_vanadzor', 'ChIJV-ypwhy8QUAR9H8MGcbw5DQ', 40.807399, 44.4970268, 'city', '1'),
('countries_armenia_shirak_akhuryan', 'ChIJ_4h1ShP7QUARILGyw0LQa7U', 40.7806495, 43.8997986, 'city', '1'),
('countries_armenia_shirak_amasia', 'ChIJF_hX3nccQkARSpEkZyrcEhw', 40.9574499, 43.7838467, 'city', '1'),
('countries_armenia_shirak_arrap_i', 'ChIJ66Qv9CL8QUARNPfQoW6zsfY', 40.7832947, 43.8045228, 'city', '1'),
('countries_armenia_shirak_gyumri', 'ChIJn_w0m4v7QUARApH5RQ7tS08', 40.7929026, 43.8464971, 'city', '1'),
('countries_armenia_shirak_maralik', 'ChIJH-Z8b80MakARX_KQ36Tq06I', 40.5871242, 43.8677691, 'city', '1'),
('countries_armenia_shirak_musayelyan', 'ChIJk2_fd9EhQkAR7zrXoPzj3t4', 40.9910964, 43.939693, 'city', '1'),
('countries_armenia_shirak_pemzashen', 'ChIJA3RrsMd0akARJdUNWp-WFYE', 40.5854016, 43.9362677, 'city', '1'),
('countries_armenia_shirak_shirak', 'ChIJKxG3gsrwQUARo0_yq9d7eTg', 40.8384463, 43.9142395, 'city', '1'),
('countries_armenia_shirak_yerazgavors', 'ChIJGUI0rdkHakARWxr0qyWZSZA', 40.7031503, 43.7750216, 'city', '1'),
('countries_armenia_syunik_agarak', 'ChIJLU5CKDr_FkARXxcy_uxOY3I', 38.8602012, 46.205051, 'city', '1'),
('countries_armenia_syunik_goris', 'ChIJ71MnCWQAPkARR4S1Jagtpj0', 39.508988, 46.343889, 'city', '1'),
('countries_armenia_syunik_hats_avan', 'ChIJI_ERxm7lFUARewcSnNA5S-4', 39.4624171, 45.9676091, 'city', '1'),
('countries_armenia_syunik_lor', 'ChIJH1mr6DT9FUARSOm76edjoLs', 39.4100796, 46.1305151, 'city', '1'),
('countries_armenia_syunik_meghri', 'ChIJXyBDC2NWFkAR0lT6DZ14tis', 38.9016976, 46.2467317, 'city', '1'),
('countries_armenia_tavush_archis', 'ChIJ0RAzHYFpQUARiO11dRgI_yc', 41.1637808, 44.8746069, 'city', '1'),
('countries_armenia_tavush_aygedzor', 'ChIJtx8k-HjpQEARSFzjtgRL6pU', 40.8252968, 45.5400813, 'city', '1'),
('countries_armenia_tavush_aygehovit', 'ChIJC3SwiAEfQUARaOQm7AA79L8', 40.9762473, 45.2550314, 'city', '1'),
('countries_armenia_tavush_azatamut', 'ChIJpa4soLceQUARKEQXLS6tpzo', 40.9882155, 45.2072695, 'city', '1'),
('countries_armenia_tavush_berd', 'ChIJuZPVfI3mQEAROi-KQwNdPzM', 40.8837788, 45.3923464, 'city', '1'),
('countries_armenia_tavush_berdavan', 'ChIJf9jfs0FBQUARxEo-38ah10E', 41.2062024, 45, 'city', '1'),
('countries_armenia_tavush_dilijan', 'ChIJccK2PtGsQUARE_50EATNxMI', 40.7405524, 44.8625965, 'city', '1'),
('countries_armenia_tavush_ijevan', 'ChIJl8Y2A6ACQUARCFDh8iuOgIA', 40.8791442, 45.1470572, 'city', '1'),
('countries_armenia_vayots_dzor_gndevaz', 'ChIJzRvQ8pqBFUARqhgsy5HXWUI', 39.7590903, 45.6253328, 'city', '1'),
('countries_armenia_vayots_dzor_jermuk', 'ChIJjdSPlBbVP0AR8FAOsW6cX8k', 39.8172259, 45.6727334, 'city', '1'),
('countries_armenia_vayots_dzor_malishka', 'ChIJNY8iL-d2FUAR90cJ00Ov-vk', 39.7376099, 45.3925813, 'city', '1'),
('countries_armenia_vayots_dzor_yeghegnadzor', 'ChIJYc9uuARxFUARE_nrNef6N0I', 39.7632738, 45.3307882, 'city', '1'),
('countries_spain_castille_la_mancha_urda', 'ChIJLy8CeWiHaQ0RUH1NvvNAAwQ', 39.4124828, -3.7170312, 'city', '0'),
('countries_armenia_yerevan_jrvezh', 'ChIJcQvaGFejakAR0uGWyT-giFk', 40.1888299, 44.6242439, 'city', '1'),
('countries_armenia_yerevan_yerevan', 'ChIJW4v8uNqiakARalLah655FD0', 40.1872023, 44.515209, 'city', '1'),
('countries_aruba_aruba_s_lands', 'ChIJ23da4s84hY4RL4yBiT6KavE', 12.52111, -69.968338, 'region', '1'),
('countries_aruba_aruba_s_lands_noord', 'ChIJp6TKLAQ4hY4RHnCyRWxwWss', 12.574738, -70.043808, 'city', '1'),
('countries_aruba_aruba_s_lands_oranjestad', 'ChIJYbGY9QVHhY4RVInfl7DgjHc', 12.5319116, -70.0528882, 'city', '1'),
('countries_spain_castille_la_mancha_uceda', 'ChIJIfrKtiDBQw0Rz0VHkm63hNQ', 40.8365487, -3.4498346, 'city', '0'),
('countries_aruba_aruba_s_lands_paradera', 'ChIJbdS-5P84hY4RBU5aA71EL9E', 12.5347904, -70.0041644, 'city', '1'),
('countries_aruba_aruba_s_lands_santa_cruz', 'ChIJO0Zb5FI5hY4R9fVBtSxSRFo', 12.4911032, -69.9684334, 'city', '1'),
('countries_aruba_aruba_s_lands_san_nicolas', 'ChIJlyQ6GwI9hY4RKlxsmIBzmuk', 12.4227616, -69.8776091, 'city', '1'),
('countries_aruba_aruba_s_lands_savaneta', 'ChIJlVgRTC08hY4RnVBaEA4eRno', 12.444514, -69.9441693, 'city', '1'),
('countries_australia_australian_capital_territory', 'ChIJSxCboN9MFmsRA3huXDhEWOc', -35.4734679, 149.0123679, 'region', '1'),
('countries_australia_australia_s_lands', 'ChIJ38WHZwf9KysRUhNblaFnglM', -25.274398, 133.775136, 'region', '1'),
('countries_australia_new_south_wales', 'ChIJDUte93TLDWsRLZ_EIhGvgBc', -31.2532183, 146.921099, 'region', '1'),
('countries_australia_northern_territory', 'ChIJDxnz5sJyUSsRdScAAAAAAAA', -19.4914108, 132.5509603, 'region', '1'),
('countries_australia_queensland', 'ChIJ_dxieiTf1GsRmb4SdiLQ8vU', -20.9175738, 142.7027956, 'region', '1'),
('countries_australia_south_australia', 'ChIJ88foW55Yp2oR2ND6PZl5fts', -30.0002315, 136.2091547, 'region', '1'),
('countries_australia_tasmania', 'ChIJz_o0fifteqoRZEBAKd2ljyo', -41.4545196, 145.9706647, 'region', '1'),
('countries_australia_victoria', 'ChIJT5UYfksx1GoRNJWCvuL8Tlo', -37.4713077, 144.7851531, 'region', '1'),
('countries_australia_western_australia', 'ChIJ0YTziS4qOSoRmaMAMt9KDm4', -27.6728168, 121.6283098, 'region', '1'),
('countries_australia_australian_capital_territory_acton', 'ChIJuYHaMrKyF2sRUFZpp27qAAU', -35.279444, 149.119444, 'city', '1'),
('countries_australia_australian_capital_territory_ainslie', 'ChIJT5XYc4hSFmsREFZpp27qAAU', -35.262778, 149.144167, 'city', '1'),
('countries_australia_australian_capital_territory_amaroo', 'ChIJs9tkWJVUFmsRAFlpp27qAAU', -35.171389, 149.128889, 'city', '1'),
('countries_australia_australian_capital_territory_aranda', 'ChIJDWsDh5-yF2sRkFVpp27qAAU', -35.258333, 149.08, 'city', '1'),
('countries_australia_australian_capital_territory_banks', 'ChIJ6aCkqDPLF2sRkFppp27qAAU', -35.473, 149.095, 'city', '1'),
('countries_australia_australian_capital_territory_barton', 'ChIJwX5VbQNNFmsRwFZpp27qAAU', -35.307778, 149.134444, 'city', '1'),
('countries_australia_australian_capital_territory_belconnen', 'ChIJMTw2H3KtF2sRoFRpp27qAAU', -35.237, 149.065, 'city', '1'),
('countries_australia_australian_capital_territory_bonner', 'ChIJWWFTBPxUFmsRQF1pp27qAAU', -35.16413, 149.13322, 'city', '1'),
('countries_australia_australian_capital_territory_bonython', 'ChIJNbe0UJzKF2sRMFppp27qAAU', -35.431, 149.082, 'city', '1'),
('countries_australia_australian_capital_territory_braddon', 'ChIJx8pB649SFmsRIFZpp27qAAU', -35.271944, 149.135556, 'city', '1'),
('countries_australia_australian_capital_territory_bruce', 'ChIJme9TxS9TFmsRkFRpp27qAAU', -35.242, 149.077, 'city', '1'),
('countries_australia_australian_capital_territory_calwell', 'ChIJrbjX-6dKFmsRYFppp27qAAU', -35.438, 149.11, 'city', '1'),
('countries_australia_australian_capital_territory_campbell', 'ChIJuX5BaQhSFmsRgFZpp27qAAU', -35.288056, 149.153889, 'city', '1'),
('countries_australia_australian_capital_territory_canberra', 'ChIJIZBcsGlNFmsRYFZpp27qAAU', -35.2809368, 149.1300092, 'city', '1'),
('countries_australia_australian_capital_territory_casey', 'ChIJnR9NWz6rF2sR4Fhpp27qAAU', -35.1747, 149.0959, 'city', '1'),
('countries_australia_australian_capital_territory_chapman', 'ChIJ16kMHIG2F2sREFtpp27qAAU', -35.357, 149.04, 'city', '1'),
('countries_australia_australian_capital_territory_charnwood', 'ChIJJ0XCQTWsF2sR4FRpp27qAAU', -35.2, 149.037, 'city', '1'),
('countries_australia_australian_capital_territory_chifley', 'ChIJVQ__0ZS0F2sRoFtpp27qAAU', -35.351111, 149.077778, 'city', '1'),
('countries_australia_australian_capital_territory_chisholm', 'ChIJ16Y78qFKFmsR0Flpp27qAAU', -35.424167, 149.1225, 'city', '1'),
('countries_australia_australian_capital_territory_conder', 'ChIJ16QIVYq1F2sRgFppp27qAAU', -35.458, 149.097, 'city', '1'),
('countries_australia_australian_capital_territory_cook', 'ChIJJzwKUY-yF2sRgFVpp27qAAU', -35.259722, 149.063889, 'city', '1'),
('countries_australia_australian_capital_territory_coombs', 'ChIJGXMG1o6zF2sR3TJzuZwBg3c', -35.318908, 149.044819, 'city', '1'),
('countries_australia_australian_capital_territory_crace', 'ChIJU0YY6TBTFmsR0Fdpp27qAAU', -35.2048561, 149.1070459, 'city', '1'),
('countries_australia_australian_capital_territory_curtin', 'ChIJgaEBBVyzF2sRQFtpp27qAAU', -35.325, 149.077778, 'city', '1'),
('countries_australia_australian_capital_territory_deakin', 'ChIJHaDoRSazF2sRMFdpp27qAAU', -35.316, 149.107, 'city', '1'),
('countries_australia_australian_capital_territory_denman_prospect', 'ChIJYXPelcKzF2sRToyR9g0LJvI', -35.3031, 149.0241, 'city', '1'),
('countries_australia_australian_capital_territory_dickson', 'ChIJKS2OmYxSFmsRAFZpp27qAAU', -35.2525, 149.139722, 'city', '1'),
('countries_australia_australian_capital_territory_downer', 'ChIJlT0inu9SFmsR8FVpp27qAAU', -35.244167, 149.145, 'city', '1'),
('countries_australia_australian_capital_territory_duffy', 'ChIJ7dcSbBO0F2sRsFppp27qAAU', -35.337, 149.035, 'city', '1'),
('countries_australia_australian_capital_territory_dunlop', 'ChIJrZpU-PWrF2sREFRpp27qAAU', -35.195556, 149.02, 'city', '1'),
('countries_australia_australian_capital_territory_evatt', 'ChIJy3YFgIWsF2sRQFRpp27qAAU', -35.211667, 149.067778, 'city', '1'),
('countries_australia_australian_capital_territory_fadden', 'ChIJn-fZk8dKFmsRoFlpp27qAAU', -35.402, 149.118, 'city', '1'),
('countries_australia_australian_capital_territory_farrer', 'ChIJ0Qs9UCtLFmsR8Ftpp27qAAU', -35.377222, 149.105278, 'city', '1'),
('countries_australia_australian_capital_territory_fisher', 'ChIJS1O7gPi0F2sRIFtpp27qAAU', -35.361, 149.057, 'city', '1'),
('countries_australia_australian_capital_territory_florey', 'ChIJvfi4b5itF2sRsFRpp27qAAU', -35.225833, 149.049444, 'city', '1'),
('countries_australia_australian_capital_territory_flynn', 'ChIJe9gs4LKtF2sR0FRpp27qAAU', -35.2025, 149.050278, 'city', '1'),
('countries_australia_australian_capital_territory_forde', 'ChIJ8c0nKt9UFmsREFlpp27qAAU', -35.166389, 149.143056, 'city', '1'),
('countries_australia_australian_capital_territory_forrest', 'ChIJzXw0PcNMFmsRIFdpp27qAAU', -35.318056, 149.125, 'city', '1'),
('countries_australia_australian_capital_territory_franklin', 'ChIJQwRyhXtTFmsRsFdpp27qAAU', -35.2, 149.1425, 'city', '1'),
('countries_australia_australian_capital_territory_fraser', 'ChIJzXHV50SsF2sRIFRpp27qAAU', -35.1925, 149.050556, 'city', '1'),
('countries_australia_australian_capital_territory_fyshwick', 'ChIJm2T-FH1OFmsR4FZpp27qAAU', -35.329, 149.174, 'city', '1'),
('countries_australia_australian_capital_territory_garran', 'ChIJ5YsL9pq0F2sRcFtpp27qAAU', -35.342, 149.108, 'city', '1'),
('countries_australia_australian_capital_territory_gilmore', 'ChIJqyIwnJFKFmsRwFlpp27qAAU', -35.421, 149.133, 'city', '1'),
('countries_australia_australian_capital_territory_giralang', 'ChIJr-4Fx9GsF2sRYFRpp27qAAU', -35.211944, 149.097222, 'city', '1'),
('countries_australia_australian_capital_territory_gordon', 'ChIJ8eSMtSHLF2sRUFppp27qAAU', -35.451, 149.085, 'city', '1'),
('countries_australia_australian_capital_territory_gowrie', 'ChIJ37_o4rFKFmsR8Flpp27qAAU', -35.412, 149.11, 'city', '1'),
('countries_australia_australian_capital_territory_greenway', 'ChIJxeP3oTnLF2sRIFppp27qAAU', -35.418, 149.07, 'city', '1'),
('countries_australia_australian_capital_territory_griffith', 'ChIJM1ngD_JMFmsREFdpp27qAAU', -35.324722, 149.137222, 'city', '1'),
('countries_australia_australian_capital_territory_gungahlin', 'ChIJD1_2-7dUFmsRwFdpp27qAAU', -35.1831, 149.133, 'city', '1'),
('countries_australia_australian_capital_territory_hackett', 'ChIJnWuNJUVSFmsR4FVpp27qAAU', -35.248056, 149.162778, 'city', '1'),
('countries_australia_australian_capital_territory_hall', 'ChIJpzPjap2rF2sRAFhpp27qAAU', -35.1679431, 149.0616656, 'city', '1'),
('countries_australia_australian_capital_territory_harrison', 'ChIJDUC7NKlUFmsRMFlpp27qAAU', -35.1975, 149.154444, 'city', '1'),
('countries_australia_australian_capital_territory_hawker', 'ChIJQXx4W3OyF2sRUFVpp27qAAU', -35.244, 149.038, 'city', '1'),
('countries_australia_australian_capital_territory_higgins', 'ChIJM16ZxPCtF2sRIFVpp27qAAU', -35.232222, 149.027222, 'city', '1'),
('countries_australia_australian_capital_territory_holder', 'ChIJ1_pBQnC0F2sRwFppp27qAAU', -35.336, 149.045, 'city', '1'),
('countries_australia_australian_capital_territory_holt', 'ChIJofCm6QWuF2sREFVpp27qAAU', -35.224167, 149.015278, 'city', '1'),
('countries_australia_australian_capital_territory_hughes', 'ChIJqSiyeIK0F2sRYFtpp27qAAU', -35.333, 149.094, 'city', '1'),
('countries_australia_australian_capital_territory_isaacs', 'ChIJUxz9UTdLFmsR4Ftpp27qAAU', -35.3675, 149.111389, 'city', '1'),
('countries_australia_australian_capital_territory_isabella_plains', 'ChIJywnofbrKF2sRQFppp27qAAU', -35.428, 149.095, 'city', '1'),
('countries_australia_australian_capital_territory_jacka', 'ChIJ8VVFmuFUFmsRUF1pp27qAAU', -35.1516143, 149.1300092, 'city', '1'),
('countries_australia_australian_capital_territory_kaleen', 'ChIJG1_MFNRSFmsRcFRpp27qAAU', -35.221, 149.106, 'city', '1'),
('countries_australia_australian_capital_territory_kambah', 'ChIJQWq7W6O1F2sRgFlpp27qAAU', -35.394444, 149.068611, 'city', '1'),
('countries_australia_australian_capital_territory_kingston', 'ChIJFyj1UgBNFmsR0FZpp27qAAU', -35.315556, 149.144167, 'city', '1'),
('countries_australia_australian_capital_territory_latham', 'ChIJy0vvO8GtF2sRAFVpp27qAAU', -35.217222, 149.031389, 'city', '1'),
('countries_australia_australian_capital_territory_lawson', 'ChIJKbaHoiStF2sRgFRpp27qAAU', -35.225, 149.088056, 'city', '1'),
('countries_australia_australian_capital_territory_lyneham', 'ChIJwxO40-5SFmsRwFVpp27qAAU', -35.25, 149.129167, 'city', '1'),
('countries_australia_australian_capital_territory_lyons', 'ChIJSWbGB2a0F2sRUFtpp27qAAU', -35.342, 149.076, 'city', '1'),
('countries_australia_australian_capital_territory_macarthur', 'ChIJodAi9etKFmsRsFlpp27qAAU', -35.405833, 149.13, 'city', '1'),
('countries_australia_australian_capital_territory_macgregor', 'ChIJNya139mtF2sR8FRpp27qAAU', -35.210833, 149.015278, 'city', '1'),
('countries_australia_australian_capital_territory_macquarie', 'ChIJZyYrCYKyF2sRcFVpp27qAAU', -35.250833, 149.064722, 'city', '1'),
('countries_spain_castille_la_mancha_torrijos', 'ChIJUXSGUC3RQQ0REH1NvvNAAwQ', 39.9833124, -4.2811885, 'city', '0'),
('countries_australia_australian_capital_territory_mawson', 'ChIJg3EBWCy1F2sR0Ftpp27qAAU', -35.365, 149.094444, 'city', '1'),
('countries_australia_australian_capital_territory_mckellar', 'ChIJv0Cj5h6tF2sRUFRpp27qAAU', -35.2175, 149.076111, 'city', '1'),
('countries_australia_australian_capital_territory_melba', 'ChIJRSIXul2sF2sRwFRpp27qAAU', -35.208333, 149.054167, 'city', '1'),
('countries_australia_australian_capital_territory_mitchell', 'ChIJpWnjKmJTFmsRoFdpp27qAAU', -35.215278, 149.140833, 'city', '1'),
('countries_australia_australian_capital_territory_monash', 'ChIJr15C50c1FmsRAFppp27qAAU', -35.417, 149.1, 'city', '1'),
('countries_australia_australian_capital_territory_moncrieff', 'ChIJneYtn8ZUFmsR35T83Rzb9x0', -35.1564303, 149.1142969, 'city', '1'),
('countries_australia_australian_capital_territory_narrabundah', 'ChIJs9aPaR9MFmsR8FZpp27qAAU', -35.3325, 149.153333, 'city', '1'),
('countries_australia_australian_capital_territory_ngunnawal', 'ChIJTeOx2r9UFmsR8Fhpp27qAAU', -35.175833, 149.109167, 'city', '1'),
('countries_australia_australian_capital_territory_nicholls', 'ChIJK2xifGqrF2sR8Fdpp27qAAU', -35.186, 149.092, 'city', '1'),
('countries_australia_australian_capital_territory_oxley', 'ChIJW0BO35_KF2sREFppp27qAAU', -35.406, 149.08, 'city', '1'),
('countries_australia_australian_capital_territory_o_connor', 'ChIJsSr5bcasF2sRQFZpp27qAAU', -35.259167, 149.121111, 'city', '1'),
('countries_australia_australian_capital_territory_o_malley', 'ChIJMetesU9LFmsRgFtpp27qAAU', -35.3525, 149.108611, 'city', '1'),
('countries_australia_australian_capital_territory_page', 'ChIJ9_WtHYWtF2sRQFVpp27qAAU', -35.238333, 149.049167, 'city', '1'),
('countries_australia_australian_capital_territory_palmerston', 'ChIJRQbkpltTFmsR4Fdpp27qAAU', -35.19457, 149.114, 'city', '1'),
('countries_australia_australian_capital_territory_pearce', 'ChIJM4HLmcG0F2sRsFtpp27qAAU', -35.362, 149.085, 'city', '1'),
('countries_australia_australian_capital_territory_phillip', 'ChIJwVmuo420F2sRkFtpp27qAAU', -35.349444, 149.090278, 'city', '1'),
('countries_australia_australian_capital_territory_pialligo', 'ChIJkR18tNtNFmsRkFhpp27qAAU', -35.306389, 149.18, 'city', '1'),
('countries_australia_australian_capital_territory_red_hill', 'ChIJPRx_fedMFmsRAFdpp27qAAU', -35.3339729, 149.124268, 'city', '1'),
('countries_australia_australian_capital_territory_reid', 'ChIJryuGJT5NFmsRcFZpp27qAAU', -35.283333, 149.141667, 'city', '1'),
('countries_australia_australian_capital_territory_richardson', 'ChIJsYgi0lk1FmsR4Flpp27qAAU', -35.4300126, 149.1127863, 'city', '1'),
('countries_australia_australian_capital_territory_rivett', 'ChIJLfkGKZu2F2sRAFtpp27qAAU', -35.348, 149.038, 'city', '1'),
('countries_australia_australian_capital_territory_scullin', 'ChIJFfx3v42tF2sRMFVpp27qAAU', -35.234722, 149.038333, 'city', '1'),
('countries_australia_australian_capital_territory_spence', 'ChIJS_CA5_CsF2sRMFRpp27qAAU', -35.198889, 149.065278, 'city', '1'),
('countries_australia_australian_capital_territory_stirling', 'ChIJvRGdqz60F2sR8Fppp27qAAU', -35.349, 149.05, 'city', '1'),
('countries_australia_australian_capital_territory_symonston', 'ChIJKTdSD35OFmsRMFhpp27qAAU', -35.346389, 149.177778, 'city', '1'),
('countries_australia_australian_capital_territory_theodore', 'ChIJz73Ghg81FmsRcFppp27qAAU', -35.446, 149.122, 'city', '1'),
('countries_australia_australian_capital_territory_throsby', 'ChIJW5sKH29UFmsR9Do5NR5NvRI', -35.1880997, 149.1639015, 'city', '1'),
('countries_australia_australian_capital_territory_torrens', 'ChIJUUqyMsG0F2sRwFtpp27qAAU', -35.372778, 149.087222, 'city', '1'),
('countries_spain_castille_la_mancha_tomelloso', 'ChIJiek63Jf5aA0RkEpMvvNAAwQ', 39.1582611, -3.0212324, 'city', '0'),
('countries_australia_australian_capital_territory_turner', 'ChIJK_j30aFSFmsRMFZpp27qAAU', -35.268611, 149.124167, 'city', '1'),
('countries_australia_australian_capital_territory_uriarra_village', 'ChIJsQpX6Va3F2sR4SGrQPIbbpg', -35.2969811, 148.9234952, 'city', '1'),
('countries_australia_australian_capital_territory_wanniassa', 'ChIJQa5GDUe1F2sRkFlpp27qAAU', -35.403056, 149.097222, 'city', '1'),
('countries_australia_australian_capital_territory_waramanga', 'ChIJ5Qt2bke0F2sR4Fppp27qAAU', -35.353, 149.063, 'city', '1'),
('countries_australia_australian_capital_territory_watson', 'ChIJ48vDoK1TFmsR0FVpp27qAAU', -35.238333, 149.153333, 'city', '1'),
('countries_australia_australian_capital_territory_weetangera', 'ChIJh6r57XiyF2sRYFVpp27qAAU', -35.25, 149.049, 'city', '1'),
('countries_australia_australian_capital_territory_weston', 'ChIJZ6gZQoe0F2sR0Fppp27qAAU', -35.338, 149.059, 'city', '1'),
('countries_spain_castille_la_mancha_tebar', 'ChIJ272LRr3HZw0RSIPFiKN7AyE', 39.496749, -2.1652863, 'city', '1'),
('countries_australia_australian_capital_territory_wright', 'ChIJPaAau3W0F2sRZlULyzDu_gY', -35.317, 149.033, 'city', '1'),
('countries_australia_australian_capital_territory_yarralumla', 'ChIJa6HF4TuzF2sRQFdpp27qAAU', -35.305092, 149.098098, 'city', '1'),
('countries_australia_australia_s_lands_coochin_creek', 'ChIJh1Mr_luQk2sR8Anf81qjAgU', -26.8948514, 153.0844353, 'city', '1'),
('countries_australia_new_south_wales_aarons_pass', 'ChIJ92a6XZp3DmsRwFpDkLQJBgQ', -32.8647451, 149.8066172, 'city', '1'),
('countries_australia_new_south_wales_abbotsbury', 'ChIJU1drp0KREmsR4KoyFmh9AQU', -33.8728035, 150.8671315, 'city', '1'),
('countries_australia_new_south_wales_abbotsford', 'ChIJQ4020z6lEmsR8KoyFmh9AQU', -33.8512755, 151.1289296, 'city', '1'),
('countries_australia_new_south_wales_abercrombie', 'ChIJuXDzxKLmEWsRUCJEkLQJBgU', -33.3901487, 149.549599, 'city', '1'),
('countries_australia_new_south_wales_aberdare', 'ChIJ42S_3282c2sRkOcyFmh9AQU', -32.8450848, 151.3787657, 'city', '1'),
('countries_australia_new_south_wales_aberdeen', 'ChIJAeeBvg9pC2sRcH5DkLQJBgQ', -32.1680712, 150.8914436, 'city', '1'),
('countries_australia_new_south_wales_aberfoyle', 'ChIJo7x-jtgYn2sRwKtDkLQJBgQ', -30.2839894, 151.9350333, 'city', '1'),
('countries_australia_new_south_wales_aberglasslyn', 'ChIJQXfcEZ5Fc2sRoOcyFmh9AQU', -32.6958052, 151.5350336, 'city', '1'),
('countries_australia_new_south_wales_abermain', 'ChIJn0Ilh0Q2c2sRsOcyFmh9AQU', -32.8108251, 151.4315929, 'city', '1'),
('countries_australia_new_south_wales_abernethy', 'ChIJXweF2uszc2sRwOcyFmh9AQU', -32.8814067, 151.397053, 'city', '1'),
('countries_spain_castille_la_mancha_san_pedro', 'ChIJFbE3zRUqcw0RICqdIHvSAwo', 36.486704, -4.9920468, 'city', '0'),
('countries_australia_new_south_wales_acacia_gardens', 'ChIJdTyTZNOYEmsRAKsyFmh9AQU', -33.7344821, 150.9126975, 'city', '1'),
('countries_australia_new_south_wales_adaminaby', 'ChIJ5wTr3j8UPWsRsBFEkLQJBgQ', -35.996012, 148.7740012, 'city', '1'),
('countries_australia_new_south_wales_adamstown', 'ChIJmRlEQcAVc2sR0OcyFmh9AQU', -32.9342502, 151.7258697, 'city', '1'),
('countries_australia_new_south_wales_adamstown_heights', 'ChIJCYK6ewYWc2sR4OcyFmh9AQU', -32.9500059, 151.7132619, 'city', '1'),
('countries_australia_new_south_wales_adelong', 'ChIJLaqaoswNGGsRoORDkLQJBgQ', -35.3093163, 148.0656088, 'city', '1'),
('countries_australia_new_south_wales_agnes_banks', 'ChIJxTmDskGCEmsREKsyFmh9AQU', -33.6127825, 150.7130526, 'city', '1'),
('countries_australia_new_south_wales_airds', 'ChIJG97cbprvEmsRIKsyFmh9AQU', -34.0802161, 150.8337444, 'city', '1'),
('countries_australia_new_south_wales_albion_park_rail', 'ChIJu4k7W9oSE2sRkOAyFmh9AQU', -34.5686535, 150.8060595, 'city', '1'),
('countries_australia_new_south_wales_albury', 'ChIJpz7zaXxfIWsRACdEkLQJBgU', -36.0751193, 146.9094852, 'city', '1'),
('countries_australia_new_south_wales_aldavilla', 'ChIJ2_AJXN10nmsRsJJDkLQJBgQ', -31.0592482, 152.7703267, 'city', '1'),
('countries_australia_new_south_wales_alexandria', 'ChIJa0nQNrSxEmsRMKsyFmh9AQU', -33.9080273, 151.1902576, 'city', '1'),
('countries_australia_new_south_wales_alfords_point', 'ChIJedHt9UC_EmsRQKsyFmh9AQU', -33.9945641, 151.0246842, 'city', '1'),
('countries_australia_new_south_wales_alice', 'ChIJb_OZzbaTmWsR4KtDkLQJBgQ', -29.0408329, 152.5880763, 'city', '1'),
('countries_australia_new_south_wales_alison', 'ChIJsTaHMhPScmsRQNYyFmh9AQU', -33.2760759, 151.4046873, 'city', '1'),
('countries_australia_new_south_wales_allambie_heights', 'ChIJ4wy6ejmqEmsRUKsyFmh9AQU', -33.7654848, 151.250911, 'city', '1'),
('countries_australia_new_south_wales_allandale', 'ChIJl_KjU4ZJc2sRMEMzFmh9AQU', -32.7211809, 151.4132742, 'city', '1'),
('countries_australia_new_south_wales_allawah', 'ChIJ5y6GAb-5EmsRYKsyFmh9AQU', -33.9744349, 151.115534, 'city', '1'),
('countries_australia_new_south_wales_allgomera', 'ChIJR2KdmyB_nmsRwJJDkLQJBgQ', -30.815875, 152.8370101, 'city', '1'),
('countries_australia_new_south_wales_allynbrook', 'ChIJL9bXZ4RZc2sRoH5DkLQJBgQ', -32.3622684, 151.5432854, 'city', '1'),
('countries_spain_castille_la_mancha_priego', 'ChIJUT3fQPiQbQ0REjlYvjZxGpk', 37.437791, -4.1987434, 'city', '0'),
('countries_australia_new_south_wales_alstonvale', 'ChIJV7AInsSckGsRIPFDkLQJBgQ', -28.7966366, 153.4448711, 'city', '1'),
('countries_australia_new_south_wales_alstonville', 'ChIJW5024LWDkGsRMPFDkLQJBgQ', -28.8420825, 153.4403555, 'city', '1'),
('countries_australia_new_south_wales_alumy_creek', 'ChIJnTmN7ALam2sRYBZEkLQJBgQ', -29.6408778, 152.951612, 'city', '1'),
('countries_australia_new_south_wales_amaroo', 'ChIJ8frShwgnEGsRoHZDkLQJBgQ', -33.1635738, 148.9196315, 'city', '1'),
('countries_australia_new_south_wales_ambarvale', 'ChIJj9QziyjuEmsRcKsyFmh9AQU', -34.0878917, 150.7984601, 'city', '1'),
('countries_australia_new_south_wales_ando', 'ChIJbz-ZyeBnPGsR4NlDkLQJBgQ', -36.7385393, 149.2611325, 'city', '1'),
('countries_australia_new_south_wales_angledale', 'ChIJAXn3cuwrPGsRoAVEkLQJBgQ', -36.637666, 149.8747006, 'city', '1'),
('countries_australia_new_south_wales_anglers_reach', 'ChIJ262iPnA-PWsRwBFEkLQJBgQ', -36.0035364, 148.662384, 'city', '1'),
('countries_australia_new_south_wales_angourie', 'ChIJXwc2XaVNmmsRICxEkLQJBgU', -29.47908, 153.3600112, 'city', '1'),
('countries_australia_new_south_wales_annandale', 'ChIJIQR-U9-vEmsRgKsyFmh9AQU', -33.8814, 151.1707, 'city', '1'),
('countries_australia_new_south_wales_annangrove', 'ChIJ__dexgBgDWsRkKsyFmh9AQU', -33.6605646, 150.9461013, 'city', '1'),
('countries_australia_new_south_wales_anna_bay', 'ChIJzbJS5KCCc2sREOgyFmh9AQU', -32.7789846, 152.0857844, 'city', '1'),
('countries_australia_new_south_wales_appin', 'ChIJy9QD6qepE2sRgI1DkLQJBgQ', -34.200914, 150.7874904, 'city', '1'),
('countries_australia_new_south_wales_apsley', 'ChIJfYoQ7LGvD2sRsHZDkLQJBgQ', -32.5945569, 148.9517002, 'city', '1'),
('countries_australia_new_south_wales_arakoon', 'ChIJe88qPH3OnWsRgC1EkLQJBgU', -30.883153, 153.0715494, 'city', '1'),
('countries_australia_new_south_wales_arcadia', 'ChIJ35-57dhbDWsRoKsyFmh9AQU', -33.6216441, 151.0428714, 'city', '1'),
('countries_australia_new_south_wales_arcadia_vale', 'ChIJY2Timtwlc2sRIOgyFmh9AQU', -33.0608373, 151.5807382, 'city', '1'),
('countries_australia_new_south_wales_arding', 'ChIJ7a-D-zebn2sR8KtDkLQJBgQ', -30.5715631, 151.5279035, 'city', '1'),
('countries_australia_new_south_wales_ardlethan', 'ChIJbxJP9M_THmsRwMZDkLQJBgQ', -34.3571322, 146.8996482, 'city', '1'),
('countries_australia_new_south_wales_argenton', 'ChIJH8dmMT08c2sRMOgyFmh9AQU', -32.9354295, 151.6290246, 'city', '1'),
('countries_australia_new_south_wales_ariah_park', 'ChIJs9aOLqM-GWsR4MZDkLQJBgQ', -34.3481414, 147.2211928, 'city', '1'),
('countries_australia_new_south_wales_armatree', 'ChIJZY0TmJijCGsR8G9DkLQJBgQ', -31.4469746, 148.4797411, 'city', '1'),
('countries_australia_new_south_wales_armidale', 'ChIJfVxG3dufn2sRwClEkLQJBgU', -30.5035714, 151.6523371, 'city', '1'),
('countries_australia_new_south_wales_arncliffe', 'ChIJtc4gXqGwEmsRsKsyFmh9AQU', -33.9391501, 151.1478116, 'city', '1'),
('countries_australia_new_south_wales_arndell_park', 'ChIJj24a_cGZEmsRwKsyFmh9AQU', -33.7878243, 150.8759624, 'city', '1'),
('countries_spain_castille_la_mancha_paredes', 'ChIJf8eEqX6ZQg0RZlDykGNYBSs', 40.0744248, -2.8527235, 'city', '0'),
('countries_australia_new_south_wales_arrawarra_headland', 'ChIJrzKLxU7zm2sR8JJDkLQJBgQ', -30.0675348, 153.1993077, 'city', '1'),
('countries_australia_new_south_wales_artarmon', 'ChIJDbLtntmuEmsR0KsyFmh9AQU', -33.8093311, 151.185647, 'city', '1'),
('countries_australia_new_south_wales_ashbury', 'ChIJ04wWuoy6EmsR4KsyFmh9AQU', -33.8995035, 151.1203949, 'city', '1'),
('countries_australia_new_south_wales_ashby', 'ChIJD7qjZG1KmmsRcBZEkLQJBgQ', -29.4362923, 153.197212, 'city', '1'),
('countries_australia_new_south_wales_ashcroft', 'ChIJdVli6k6UEmsR8KsyFmh9AQU', -33.9166677, 150.900325, 'city', '1'),
('countries_australia_new_south_wales_ashfield', 'ChIJPVkSxZe6EmsRAKwyFmh9AQU', -33.8889, 151.1249, 'city', '1'),
('countries_australia_new_south_wales_ashford', 'ChIJbUn8Rst2omsRALxDkLQJBgQ', -29.3217877, 151.0930968, 'city', '1'),
('countries_australia_new_south_wales_ashmont', 'ChIJeYCsVUCfGGsRUCVEkLQJBgU', -35.1248904, 147.3296586, 'city', '1'),
('countries_australia_new_south_wales_ashtonfield', 'ChIJuckozQdHc2sRQOgyFmh9AQU', -32.7730213, 151.5989846, 'city', '1'),
('countries_australia_new_south_wales_asquith', 'ChIJP8pEChNYDWsREKwyFmh9AQU', -33.6881873, 151.1095718, 'city', '1'),
('countries_australia_new_south_wales_attunga', 'ChIJ-U-Fred2oGsRILxDkLQJBgQ', -30.9293486, 150.8416676, 'city', '1'),
('countries_australia_new_south_wales_auburn', 'ChIJt4rvN7m8EmsRIKwyFmh9AQU', -33.8603378, 151.023592, 'city', '1'),
('countries_australia_new_south_wales_austinmer', 'ChIJv5U0oyLgEmsRoOAyFmh9AQU', -34.306311, 150.93451, 'city', '1'),
('countries_australia_new_south_wales_austral', 'ChIJgQ2UtOCSEmsRMKwyFmh9AQU', -33.9179036, 150.8087813, 'city', '1'),
('countries_australia_new_south_wales_austral_eden', 'ChIJi3UKosrbnWsRAJNDkLQJBgQ', -31.0213437, 152.9190478, 'city', '1'),
('countries_australia_new_south_wales_avalon_beach', 'ChIJSQNB1DKtcmsRQKwyFmh9AQU', -33.6332741, 151.3311538, 'city', '1'),
('countries_australia_new_south_wales_avoca_beach', 'ChIJEarYSwu2cmsRUNYyFmh9AQU', -33.4719835, 151.4279522, 'city', '1'),
('countries_australia_new_south_wales_avondale', 'ChIJOdbaQrkNE2sRsOAyFmh9AQU', -34.5243898, 150.7491233, 'city', '1'),
('countries_australia_new_south_wales_avonside', 'ChIJ6Z_BPeTCPGsR0BFEkLQJBgQ', -36.4105901, 148.7199593, 'city', '1'),
('countries_australia_new_south_wales_awaba', 'ChIJHXb2NQwlc2sRYOgyFmh9AQU', -33.0086146, 151.5475816, 'city', '1'),
('countries_australia_new_south_wales_aylmerton', 'ChIJO7BP8o2mE2sRwI1DkLQJBgQ', -34.4188756, 150.4980208, 'city', '1'),
('countries_australia_new_south_wales_baan_baa', 'ChIJdcbnpPSxoGsRMLxDkLQJBgQ', -30.5976499, 149.9537124, 'city', '1'),
('countries_australia_new_south_wales_backmede', 'ChIJay0dq40HmmsRYPFDkLQJBgQ', -28.785503, 153.0287607, 'city', '1'),
('countries_australia_new_south_wales_back_forest', 'ChIJWUbihB98E2sRS8-MDyLoGqY', -34.8359824, 150.6710217, 'city', '1'),
('countries_australia_new_south_wales_baerami', 'ChIJtaQH8Ep7DGsRwH5DkLQJBgQ', -32.3883946, 150.4816611, 'city', '1'),
('countries_spain_castille_la_mancha_orgaz', 'ChIJMSavd70Zag0RWY-2g7X-luc', 39.6479222, -3.8769847, 'city', '1'),
('countries_australia_new_south_wales_balcolyn', 'ChIJW2q1jHwmc2sRYNYyFmh9AQU', -33.0956393, 151.5531816, 'city', '1'),
('countries_australia_new_south_wales_baldry', 'ChIJ1Xa9f8L7D2sR4HZDkLQJBgQ', -32.8656744, 148.4966882, 'city', '1'),
('countries_australia_new_south_wales_balgowlah', 'ChIJzwbb7l-pEmsRgKwyFmh9AQU', -33.794418, 151.264853, 'city', '1'),
('countries_australia_new_south_wales_balgowlah_heights', 'ChIJS6fPPParEmsRkKwyFmh9AQU', -33.8047464, 151.2604573, 'city', '1'),
('countries_australia_new_south_wales_balgownie', 'ChIJ2wF9Ff4bE2sR0OAyFmh9AQU', -34.3889448, 150.8806015, 'city', '1'),
('countries_australia_new_south_wales_balldale', 'ChIJ3YHXqYUTIWsR8MZDkLQJBgQ', -35.844342, 146.5203222, 'city', '1'),
('countries_australia_new_south_wales_ballengarra', 'ChIJFaQ5tUAEnmsR4JtDkLQJBgQ', -31.3284574, 152.72405, 'city', '1'),
('countries_australia_new_south_wales_ballimore', 'ChIJGaycYrgXD2sR8HZDkLQJBgQ', -32.195181, 148.8965471, 'city', '1'),
('countries_australia_new_south_wales_ballina', 'ChIJ1QP0rGCAkGsRwCtEkLQJBgU', -28.8627985, 153.5658162, 'city', '1'),
('countries_australia_new_south_wales_balmain', 'ChIJQeFWlZyvEmsRoKwyFmh9AQU', -33.8587742, 151.1775556, 'city', '1'),
('countries_australia_new_south_wales_balmain_east', 'ChIJExDbK0yuEmsRsKwyFmh9AQU', -33.8573488, 151.1936603, 'city', '1'),
('countries_australia_new_south_wales_balmoral', 'ChIJYRWXtJypE2sR0I1DkLQJBgQ', -34.3136258, 150.5188573, 'city', '1'),
('countries_australia_new_south_wales_balranald', 'ChIJDfeYaVR63WoRUAJEkLQJBgQ', -34.6394376, 143.5629137, 'city', '1'),
('countries_australia_new_south_wales_bamarang', 'ChIJ35Vp-LZ_FGsRANRDkLQJBgQ', -34.9040641, 150.5004005, 'city', '1'),
('countries_australia_new_south_wales_bangalow', 'ChIJU9a5p0OPkGsRgPFDkLQJBgQ', -28.686843, 153.5226753, 'city', '1'),
('countries_australia_new_south_wales_bangor', 'ChIJI7X6nqXAEmsR0KwyFmh9AQU', -34.0181791, 151.0261227, 'city', '1'),
('countries_australia_new_south_wales_banksia', 'ChIJgRN8KKawEmsR4KwyFmh9AQU', -33.9468482, 151.1461979, 'city', '1'),
('countries_australia_new_south_wales_banksmeadow', 'ChIJ9UxZL0GxEmsR8KwyFmh9AQU', -33.9448433, 151.2160287, 'city', '1'),
('countries_australia_new_south_wales_bankstown', 'ChIJaYm8iRu8EmsRAK0yFmh9AQU', -33.9177861, 151.0263741, 'city', '1'),
('countries_australia_new_south_wales_bannaby', 'ChIJP4cufsDmE2sRINpDkLQJBgQ', -34.4419555, 149.9954625, 'city', '1'),
('countries_australia_new_south_wales_banora_point', 'ChIJjd9rhAH_kGsR8C5EkLQJBgU', -28.2124164, 153.5341324, 'city', '1'),
('countries_australia_new_south_wales_barangaroo', 'ChIJ1ZL9NkGuEmsRUEkzFmh9AQU', -33.8638333, 151.2015251, 'city', '1'),
('countries_australia_new_south_wales_barden_ridge', 'ChIJH9ki5PjAEmsR4DczFmh9AQU', -34.0318637, 151.0087918, 'city', '1'),
('countries_australia_new_south_wales_bardia', 'ChIJC9uJxafsEmsRA3pUf0Qp_Vo', -33.9790861, 150.8544921, 'city', '1'),
('countries_australia_new_south_wales_bardwell_park', 'ChIJt9tedBG6EmsRIK0yFmh9AQU', -33.9343258, 151.1259455, 'city', '1'),
('countries_australia_new_south_wales_bardwell_valley', 'ChIJPeGeMw66EmsRMK0yFmh9AQU', -33.9356092, 151.1347802, 'city', '1'),
('countries_australia_new_south_wales_barellan', 'ChIJ4we9FBjdHmsRAMdDkLQJBgQ', -34.2861889, 146.5705962, 'city', '1'),
('countries_australia_new_south_wales_bargo', 'ChIJy_DBN-UAE2sR8I1DkLQJBgQ', -34.2829192, 150.5772064, 'city', '1'),
('countries_australia_new_south_wales_barham', 'ChIJ074c2nFQ2WoREMdDkLQJBgQ', -35.6266437, 144.1310206, 'city', '1'),
('countries_australia_new_south_wales_barmedman', 'ChIJ19uAUuRkGWsRIOVDkLQJBgQ', -34.14501, 147.3866794, 'city', '1'),
('countries_australia_new_south_wales_barnsley', 'ChIJjf8jfuk7c2sRoOgyFmh9AQU', -32.9303374, 151.5946034, 'city', '1'),
('countries_australia_new_south_wales_barraba', 'ChIJ6R3DJ2n0oGsRgLxDkLQJBgQ', -30.3804652, 150.6101149, 'city', '1'),
('countries_australia_new_south_wales_barrack_heights', 'ChIJ_6jr24UTE2sR4OAyFmh9AQU', -34.5648569, 150.8602461, 'city', '1'),
('countries_australia_new_south_wales_barrack_point', 'ChIJK3_J9XAUE2sR8OAyFmh9AQU', -34.562427, 150.8700999, 'city', '1'),
('countries_australia_new_south_wales_barraganyatti', 'ChIJv6Pg7szWnWsRMJNDkLQJBgQ', -30.8445943, 152.932283, 'city', '1'),
('countries_australia_new_south_wales_barrengarry', 'ChIJIflvw4yCE2sRMNRDkLQJBgQ', -34.6900471, 150.5272069, 'city', '1'),
('countries_australia_new_south_wales_barrington', 'ChIJfVDDZrr-dGsRAJxDkLQJBgQ', -31.9732537, 151.9114688, 'city', '1'),
('countries_australia_new_south_wales_bar_beach', 'ChIJEZFMvT8Uc2sRkOgyFmh9AQU', -32.9377866, 151.7701917, 'city', '1'),
('countries_australia_new_south_wales_basin_view', 'ChIJBVdAxYdhFGsRUNRDkLQJBgQ', -35.0929056, 150.5687316, 'city', '1'),
('countries_australia_new_south_wales_bass_hill', 'ChIJPQWYzM69EmsRQK0yFmh9AQU', -33.8972201, 150.9969197, 'city', '1'),
('countries_australia_new_south_wales_bateau_bay', 'ChIJayOglHHPcmsRgNYyFmh9AQU', -33.3856724, 151.4724881, 'city', '1'),
('countries_australia_new_south_wales_batehaven', 'ChIJu1SbtifAFWsRUChEkLQJBgU', -35.7368662, 150.2027207, 'city', '1'),
('countries_australia_new_south_wales_batemans_bay', 'ChIJeTNw8izAFWsRYChEkLQJBgU', -35.7162174, 150.1794566, 'city', '1'),
('countries_australia_new_south_wales_bathurst', 'ChIJ73m0BjPkEWsRYCJEkLQJBgU', -33.4111857, 149.578693, 'city', '1'),
('countries_australia_new_south_wales_batlow', 'ChIJVYShjX-mImsRMOVDkLQJBgQ', -35.5221288, 148.1445915, 'city', '1'),
('countries_australia_new_south_wales_baulkham_hills', 'ChIJyeDOlZeiEmsRUK0yFmh9AQU', -33.7619106, 150.9929255, 'city', '1'),
('countries_australia_new_south_wales_bawley_point', 'ChIJZSxv8qSxFWsRIAZEkLQJBgQ', -35.5183585, 150.3967269, 'city', '1'),
('countries_australia_new_south_wales_baw_baw', 'ChIJLcWomjquFmsRU8qjcVxP314', -34.7048618, 149.6409785, 'city', '1'),
('countries_australia_new_south_wales_beaconsfield', 'ChIJx4wWlLmxEmsRAKkyFmh9AQU', -33.9123307, 151.2001469, 'city', '1'),
('countries_australia_new_south_wales_beacon_hill', 'ChIJgSME6waqEmsR8KgyFmh9AQU', -33.7524769, 151.2529048, 'city', '1'),
('countries_australia_new_south_wales_beaumont', 'ChIJpbnTsL54E2sRYNRDkLQJBgQ', -34.7894603, 150.58963, 'city', '1'),
('countries_australia_new_south_wales_beaumont_hills', 'ChIJy3lGUp2fEmsR4EMzFmh9AQU', -33.6966654, 150.9378999, 'city', '1'),
('countries_australia_new_south_wales_beechwood', 'ChIJzxHFBzn4dWsRUJxDkLQJBgQ', -31.4371438, 152.6668277, 'city', '1'),
('countries_australia_new_south_wales_beecroft', 'ChIJfaZsl22hEmsRIKkyFmh9AQU', -33.7494858, 151.0645522, 'city', '1'),
('countries_australia_new_south_wales_beelbangera', 'ChIJ46to_UirH2sRYMdDkLQJBgQ', -34.2526135, 146.1028557, 'city', '1'),
('countries_australia_new_south_wales_bega', 'ChIJ5-2pN4kpPGsRMAZEkLQJBgQ', -36.6742897, 149.8432479, 'city', '1'),
('countries_australia_new_south_wales_beggan_beggan', 'ChIJxxurfz3aGWsR0dlMSxn_SEQ', -34.6264045, 148.2895945, 'city', '1'),
('countries_australia_new_south_wales_belfield', 'ChIJYUea2q67EmsRMKkyFmh9AQU', -33.9021462, 151.0836053, 'city', '1'),
('countries_australia_new_south_wales_belford', 'ChIJky0BfO20DGsR0EUzFmh9AQU', -32.6587362, 151.2738433, 'city', '1'),
('countries_australia_new_south_wales_belimbla_park', 'ChIJreliTqZXEmsRsDwzFmh9AQU', -34.0844742, 150.538939, 'city', '1'),
('countries_australia_new_south_wales_bell', 'ChIJw47T8FF0EmsRsFtDkLQJBgQ', -33.5119931, 150.2803068, 'city', '1'),
('countries_australia_new_south_wales_bellambi', 'ChIJvahn8iMfE2sREOEyFmh9AQU', -34.3688506, 150.9163064, 'city', '1'),
('countries_australia_new_south_wales_bellata', 'ChIJzcLg-5PQpmsR8LhDkLQJBgQ', -29.9136321, 149.7910786, 'city', '1'),
('countries_australia_new_south_wales_bellawongarah', 'ChIJg-WSPNV4E2sRgNRDkLQJBgQ', -34.7591776, 150.6132776, 'city', '1'),
('countries_australia_new_south_wales_bella_vista', 'ChIJ12udSf-hEmsRQKkyFmh9AQU', -33.7385605, 150.9504582, 'city', '1'),
('countries_australia_new_south_wales_bellbird', 'ChIJXQ6cvhHLDGsRsOgyFmh9AQU', -32.8579328, 151.3223384, 'city', '1'),
('countries_australia_new_south_wales_bellbird_heights', 'ChIJA57uN6o0c2sRwOgyFmh9AQU', -32.8478478, 151.329653, 'city', '1'),
('countries_australia_new_south_wales_bellbrook', 'ChIJ3WqDVuZhnmsRQJNDkLQJBgQ', -30.8182668, 152.5083271, 'city', '1'),
('countries_australia_new_south_wales_bellevue_hill', 'ChIJRYmHccCtEmsRUKkyFmh9AQU', -33.878422, 151.2536463, 'city', '1'),
('countries_australia_new_south_wales_bellimbopinni', 'ChIJp7o-myXanWsRUJNDkLQJBgQ', -31.0025551, 152.9108408, 'city', '1'),
('countries_australia_new_south_wales_bellingen', 'ChIJX4GOaswhnGsRYJNDkLQJBgQ', -30.4521493, 152.8970631, 'city', '1'),
('countries_australia_new_south_wales_belmont', 'ChIJ7ZNDergic2sR0OgyFmh9AQU', -33.0312702, 151.6594347, 'city', '1'),
('countries_australia_new_south_wales_belmont_north', 'ChIJz1v9czQ9c2sR4OgyFmh9AQU', -33.0217904, 151.6679837, 'city', '1'),
('countries_australia_new_south_wales_belmont_south', 'ChIJt6dL1fgic2sR8OgyFmh9AQU', -33.0506395, 151.6565795, 'city', '1'),
('countries_australia_new_south_wales_belmore', 'ChIJU0i7_rW7EmsRYKkyFmh9AQU', -33.919672, 151.0896126, 'city', '1'),
('countries_australia_new_south_wales_belmore_river', 'ChIJn3hCnwfcnWsRcJNDkLQJBgQ', -31.1095423, 152.9845037, 'city', '1'),
('countries_australia_new_south_wales_belrose', 'ChIJy_YAYAhWDWsRcKkyFmh9AQU', -33.7282899, 151.2179132, 'city', '1'),
('countries_australia_new_south_wales_bemboka', 'ChIJsYXU8Zw2PGsRUAZEkLQJBgQ', -36.6274358, 149.5704418, 'city', '1'),
('countries_australia_new_south_wales_bendemeer', 'ChIJu88xKUIXoGsRoLxDkLQJBgQ', -30.8862188, 151.1543942, 'city', '1'),
('countries_australia_new_south_wales_bendolba', 'ChIJufpURZ-XdGsRIH9DkLQJBgQ', -32.3557643, 151.7372316, 'city', '1'),
('countries_australia_new_south_wales_benerembah', 'ChIJgUAvE2C6H2sRgMdDkLQJBgQ', -34.3932542, 145.8753281, 'city', '1'),
('countries_australia_new_south_wales_bennetts_green', 'ChIJ593iHtkXc2sRAOkyFmh9AQU', -32.9955197, 151.6893662, 'city', '1'),
('countries_australia_new_south_wales_bensville', 'ChIJnweEIkS0cmsRkNYyFmh9AQU', -33.4999758, 151.3907769, 'city', '1'),
('countries_australia_new_south_wales_bentley', 'ChIJUzG6MWCnkGsRoPFDkLQJBgQ', -28.7578261, 153.0935995, 'city', '1'),
('countries_australia_new_south_wales_ben_bullen', 'ChIJOYw4CnvvDWsR0FtDkLQJBgQ', -33.2190382, 150.0113271, 'city', '1'),
('countries_australia_new_south_wales_berala', 'ChIJm1f_JJC8EmsRgKkyFmh9AQU', -33.8720912, 151.032696, 'city', '1'),
('countries_australia_new_south_wales_berambing', 'ChIJF4VbJ4J4EmsR8EczFmh9AQU', -33.5366372, 150.442833, 'city', '1'),
('countries_australia_new_south_wales_beresfield', 'ChIJycS-ZAJBc2sREOkyFmh9AQU', -32.8027136, 151.6509967, 'city', '1'),
('countries_australia_new_south_wales_bergalia', 'ChIJn9fRI1n2FWsRgAZEkLQJBgQ', -35.9810997, 150.1045887, 'city', '1'),
('countries_australia_new_south_wales_berkeley', 'ChIJx3ZrktsQE2sRIOEyFmh9AQU', -34.4768821, 150.8388781, 'city', '1'),
('countries_australia_new_south_wales_berkeley_vale', 'ChIJ4w5tl_nOcmsRoNYyFmh9AQU', -33.3417275, 151.4378279, 'city', '1'),
('countries_australia_new_south_wales_berkshire_park', 'ChIJlRgNSNacEmsRkKkyFmh9AQU', -33.6767514, 150.7884592, 'city', '1'),
('countries_australia_new_south_wales_bermagui', 'ChIJIerTGBxyPmsRoAZEkLQJBgQ', -36.4271922, 150.0763926, 'city', '1'),
('countries_australia_new_south_wales_berowra', 'ChIJxe22pLNQDWsRoKkyFmh9AQU', -33.6231747, 151.1474501, 'city', '1'),
('countries_australia_new_south_wales_berowra_creek', 'ChIJOeTv_6NaDWsRoN7ocY77mfY', -33.5877809, 151.1147354, 'city', '1'),
('countries_australia_new_south_wales_berowra_heights', 'ChIJg_6EmXNaDWsRsKkyFmh9AQU', -33.6133844, 151.1398277, 'city', '1'),
('countries_australia_new_south_wales_berowra_waters', 'ChIJTXrP9xRaDWsRcD0zFmh9AQU', -33.5996165, 151.1201147, 'city', '1'),
('countries_australia_new_south_wales_berrara', 'ChIJu5yE8rpfFGsRoNRDkLQJBgQ', -35.2060895, 150.5498231, 'city', '1'),
('countries_australia_new_south_wales_berridale', 'ChIJ5_wlhEfkPGsR8BFEkLQJBgQ', -36.3677802, 148.8289331, 'city', '1'),
('countries_australia_new_south_wales_berrigan', 'ChIJLfJ2btK4IGsRkMdDkLQJBgQ', -35.657423, 145.8116744, 'city', '1'),
('countries_australia_new_south_wales_berrilee', 'ChIJ850okS9aDWsRwKkyFmh9AQU', -33.6147877, 151.0957205, 'city', '1'),
('countries_australia_new_south_wales_berrima', 'ChIJQVOYl4q9E2sRwCREkLQJBgU', -34.4865037, 150.3385238, 'city', '1'),
('countries_australia_new_south_wales_berry', 'ChIJ7_goru17E2sRMOEyFmh9AQU', -34.7757734, 150.6988896, 'city', '1'),
('countries_australia_new_south_wales_berry_park', 'ChIJkXT1xMpDc2sRIOkyFmh9AQU', -32.7472763, 151.6697409, 'city', '1'),
('countries_australia_new_south_wales_beverley_park', 'ChIJlZ2gb9u5EmsR0KkyFmh9AQU', -33.974224, 151.1324467, 'city', '1'),
('countries_australia_new_south_wales_beverly_hills', 'ChIJ8Sshc2G5EmsR4KkyFmh9AQU', -33.9471128, 151.0788043, 'city', '1'),
('countries_australia_new_south_wales_bexhill', 'ChIJT32IfbGdkGsRsPFDkLQJBgQ', -28.7626795, 153.3464112, 'city', '1'),
('countries_australia_new_south_wales_bexley', 'ChIJu9GIumu6EmsR8KkyFmh9AQU', -33.9500226, 151.126412, 'city', '1'),
('countries_australia_new_south_wales_bexley_north', 'ChIJV_qcjyG6EmsRAKoyFmh9AQU', -33.941588, 151.1146265, 'city', '1'),
('countries_australia_new_south_wales_bibbenluke', 'ChIJFzuR5_poPGsRcNpDkLQJBgQ', -36.816036, 149.2835109, 'city', '1'),
('countries_australia_new_south_wales_bidwill', 'ChIJPbJzg6abEmsREKoyFmh9AQU', -33.7289081, 150.8227104, 'city', '1'),
('countries_australia_new_south_wales_bilambil', 'ChIJTeNQjgj8kGsRAC9EkLQJBgU', -28.2247836, 153.4661506, 'city', '1'),
('countries_australia_new_south_wales_bilambil_heights', 'ChIJeRSf7vv9kGsREC9EkLQJBgU', -28.215539, 153.4835873, 'city', '1'),
('countries_australia_new_south_wales_bilgola_beach', 'ChIJAVAyWzFTDWsRIKoyFmh9AQU', -33.6443592, 151.3255356, 'city', '1'),
('countries_australia_new_south_wales_bilgola_plateau', 'ChIJUQ4q6DBTDWsRokS4QDr2yd8', -33.646554, 151.3130419, 'city', '1'),
('countries_australia_new_south_wales_billinudgel', 'ChIJsyliDpmLkGsRwPFDkLQJBgQ', -28.5042252, 153.5253935, 'city', '1'),
('countries_australia_new_south_wales_bilpin', 'ChIJW_agfe2BDWsRsEczFmh9AQU', -33.4982128, 150.5222456, 'city', '1'),
('countries_australia_new_south_wales_binalong', 'ChIJRSxWOc9BF2sRoOVDkLQJBgQ', -34.6708455, 148.6280964, 'city', '1'),
('countries_australia_new_south_wales_binda', 'ChIJ15JPHhw7EWsREFxDkLQJBgQ', -34.3243654, 149.3630933, 'city', '1'),
('countries_australia_new_south_wales_bingara', 'ChIJ0Rvqkkh1oWsRwLxDkLQJBgQ', -29.8687414, 150.5718229, 'city', '1'),
('countries_australia_new_south_wales_bingeebeebra_creek', 'ChIJv-UBnc0DmmsR0PFDkLQJBgQ', -28.8226784, 152.7899463, 'city', '1'),
('countries_australia_new_south_wales_bingie', 'ChIJK1TgJYf2FWsRwAZEkLQJBgQ', -36.0027945, 150.1426125, 'city', '1'),
('countries_australia_new_south_wales_binjura', 'ChIJqy-sbDAGPWsRoNpDkLQJBgQ', -36.1874344, 149.1140988, 'city', '1'),
('countries_australia_new_south_wales_binnaway', 'ChIJD1fiMG5rCWsRYHdDkLQJBgQ', -31.5524142, 149.3786759, 'city', '1'),
('countries_australia_new_south_wales_binya', 'ChIJu8ayesHvHmsR0MdDkLQJBgQ', -34.2278778, 146.3360834, 'city', '1'),
('countries_australia_new_south_wales_birchgrove', 'ChIJEa88ybevEmsRUKoyFmh9AQU', -33.8534234, 151.1817208, 'city', '1'),
('countries_australia_new_south_wales_birmingham_gardens', 'ChIJ0apKxtE_c2sRMOkyFmh9AQU', -32.8962305, 151.6929252, 'city', '1'),
('countries_australia_new_south_wales_birrong', 'ChIJ1x6_11y8EmsRYKoyFmh9AQU', -33.8925436, 151.0219171, 'city', '1'),
('countries_australia_new_south_wales_bishops_bridge', 'ChIJp9AemONIc2sRUOkyFmh9AQU', -32.7456952, 151.4715381, 'city', '1'),
('countries_australia_new_south_wales_blackalls_park', 'ChIJ2fO-18skc2sRcOkyFmh9AQU', -33.001687, 151.5855467, 'city', '1'),
('countries_australia_new_south_wales_blackbutt', 'ChIJY11Q0nUTE2sRQOEyFmh9AQU', -34.5725701, 150.8346988, 'city', '1'),
('countries_australia_new_south_wales_blackett', 'ChIJSefGILCbEmsRcKoyFmh9AQU', -33.7394276, 150.8110779, 'city', '1'),
('countries_australia_new_south_wales_blackheath', 'ChIJfcN9JRFyEmsRQNQyFmh9AQU', -33.6356121, 150.2851616, 'city', '1'),
('countries_australia_new_south_wales_blacksmiths', 'ChIJKUh7yUoic2sRgOkyFmh9AQU', -33.0762842, 151.6508854, 'city', '1'),
('countries_australia_new_south_wales_blacktown', 'ChIJFS-r926XEmsRgKoyFmh9AQU', -33.7660982, 150.9126927, 'city', '1'),
('countries_australia_new_south_wales_blackville', 'ChIJ6RL64KK3C2sR4LxDkLQJBgQ', -31.6405591, 150.2353673, 'city', '1'),
('countries_australia_new_south_wales_blackwall', 'ChIJ9SwT2q60cmsRsNYyFmh9AQU', -33.5056041, 151.3314543, 'city', '1'),
('countries_australia_new_south_wales_black_head', 'ChIJNWcalDTLdWsRwJxDkLQJBgQ', -32.0676627, 152.5385085, 'city', '1'),
('countries_australia_new_south_wales_black_mountain', 'ChIJ-ThBH6Zyn2sRAK1DkLQJBgQ', -30.3130134, 151.6901857, 'city', '1'),
('countries_australia_new_south_wales_blairmount', 'ChIJJXiIqNvvEmsRoKoyFmh9AQU', -34.0509687, 150.8032595, 'city', '1'),
('countries_australia_new_south_wales_blair_athol', 'ChIJk2o_uE_uEmsRkKoyFmh9AQU', -34.0620785, 150.8014464, 'city', '1'),
('countries_australia_new_south_wales_blakebrook', 'ChIJWZTtGq-fkGsR8PFDkLQJBgQ', -28.7899821, 153.2202761, 'city', '1'),
('countries_australia_new_south_wales_blakehurst', 'ChIJz-jAgU64EmsRsKoyFmh9AQU', -33.9897654, 151.1080239, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_australia_new_south_wales_blakney_creek', 'ChIJYWcFxp0mF2sRsNpDkLQJBgQ', -34.6486348, 149.0387839, 'city', '1'),
('countries_australia_new_south_wales_blandford', 'ChIJyZLuT-cYC2sRcH9DkLQJBgQ', -31.7927063, 150.9026236, 'city', '1'),
('countries_australia_new_south_wales_blaxland', 'ChIJF7ce6nqIEmsRUNQyFmh9AQU', -33.7453046, 150.615642, 'city', '1'),
('countries_australia_new_south_wales_blaxlands_ridge', 'ChIJkUrm1WtlDWsRQDkzFmh9AQU', -33.5016773, 150.7449998, 'city', '1'),
('countries_australia_new_south_wales_blayney', 'ChIJN-OOR922EWsRcFxDkLQJBgQ', -33.5306154, 149.2555693, 'city', '1'),
('countries_australia_new_south_wales_bligh_park', 'ChIJcxeMQXOdEmsRwKoyFmh9AQU', -33.6379589, 150.795817, 'city', '1'),
('countries_australia_new_south_wales_blueys_beach', 'ChIJ9SOIF4g-dGsR4JxDkLQJBgQ', -32.3481064, 152.5372179, 'city', '1'),
('countries_australia_new_south_wales_blue_bay', 'ChIJC4rNHnDPcmsRwNYyFmh9AQU', -33.3555643, 151.4981766, 'city', '1'),
('countries_australia_new_south_wales_blue_haven', 'ChIJQZJB5VrXcmsR0NYyFmh9AQU', -33.2078523, 151.5033661, 'city', '1'),
('countries_spain_castille_la_mancha_mora', 'ChIJK9x9ctAdag0RmH6pHVmfM1A', 39.6954462, -3.7232005, 'city', '0'),
('countries_australia_new_south_wales_boambee', 'ChIJjTkypjUQnGsRYB9EkLQJBgU', -30.3352485, 153.0790733, 'city', '1'),
('countries_australia_new_south_wales_boat_harbour', 'ChIJHxEf1dGCc2sR7oQxiI4m2zA', -32.7824724, 152.10868, 'city', '1'),
('countries_australia_new_south_wales_bobin', 'ChIJszaXc8K8dWsR8JxDkLQJBgQ', -31.7017674, 152.2786988, 'city', '1'),
('countries_australia_new_south_wales_bobs_creek', 'ChIJpR5vmk_8dWsRAJ1DkLQJBgQ', -31.5861567, 152.7555353, 'city', '1'),
('countries_australia_new_south_wales_bobundara', 'ChIJ49BUgf35PGsR0NpDkLQJBgQ', -36.485549, 148.9928541, 'city', '1'),
('countries_australia_new_south_wales_bodalla', 'ChIJ17-ImRQFPmsR4AZEkLQJBgQ', -36.097283, 150.0522272, 'city', '1'),
('countries_australia_new_south_wales_bogangar', 'ChIJMf8W0Hz3kGsRADJEkLQJBgU', -28.3304338, 153.568004, 'city', '1'),
('countries_australia_new_south_wales_bogan_gate', 'ChIJK9dRp5fCGmsRgHBDkLQJBgQ', -33.1078375, 147.8029498, 'city', '1'),
('countries_australia_new_south_wales_boggabri', 'ChIJze3uWiO7oGsREL1DkLQJBgQ', -30.7, 150.033333, 'city', '1'),
('countries_australia_new_south_wales_bohena_creek', 'ChIJsX2mB-JFp2sRMLlDkLQJBgQ', -30.3701017, 149.6863604, 'city', '1'),
('countries_australia_new_south_wales_bohnock', 'ChIJFa4H99zOdWsREJ1DkLQJBgQ', -31.9461524, 152.5649179, 'city', '1'),
('countries_australia_new_south_wales_bolivia', 'ChIJJ5JT0fD5mGsRIK1DkLQJBgQ', -29.2871969, 151.9678515, 'city', '1'),
('countries_australia_new_south_wales_bolong', 'ChIJg0JRkCp_E2sRYEUzFmh9AQU', -34.8355517, 150.6459285, 'city', '1'),
('countries_australia_new_south_wales_bolton_point', 'ChIJKwiHZak8c2sRoOkyFmh9AQU', -33.003, 151.615, 'city', '1'),
('countries_australia_new_south_wales_bolwarra', 'ChIJVZJDfVpEc2sRsOkyFmh9AQU', -32.7092375, 151.5778481, 'city', '1'),
('countries_australia_new_south_wales_bolwarra_heights', 'ChIJT6mx8ZJEc2sRwOkyFmh9AQU', -32.7, 151.584722, 'city', '1'),
('countries_australia_new_south_wales_bomaderry', 'ChIJhWj76EZ6E2sRYOEyFmh9AQU', -34.85, 150.616667, 'city', '1'),
('countries_australia_new_south_wales_bombala', 'ChIJEbJoyiZ7PGsR8NpDkLQJBgQ', -36.911523, 149.2423244, 'city', '1'),
('countries_australia_new_south_wales_bombira', 'ChIJI763uBeJDmsR0FxDkLQJBgQ', -32.5752244, 149.6045718, 'city', '1'),
('countries_australia_new_south_wales_bombo', 'ChIJpfR-yfBsE2sRcOEyFmh9AQU', -34.654666, 150.8522133, 'city', '1'),
('countries_australia_new_south_wales_bonalbo', 'ChIJDagyoMzimWsRMK1DkLQJBgQ', -28.7364418, 152.6227554, 'city', '1'),
('countries_australia_new_south_wales_bondi', 'ChIJnxgzRnayEmsR0KoyFmh9AQU', -33.8939634, 151.2640357, 'city', '1'),
('countries_australia_new_south_wales_bondi_beach', 'ChIJx4FyRJytEmsReOktxgkYwyA', -33.8914755, 151.2766845, 'city', '1'),
('countries_australia_new_south_wales_bondi_junction', 'ChIJdwsCavGtEmsRkK0yFmh9AQU', -33.8928168, 151.2551822, 'city', '1'),
('countries_australia_new_south_wales_bonnells_bay', 'ChIJI1BYaDwmc2sR8NYyFmh9AQU', -33.1088918, 151.5343256, 'city', '1'),
('countries_australia_new_south_wales_bonnet_bay', 'ChIJR-RUsGXHEmsRoK0yFmh9AQU', -34.0101534, 151.0561822, 'city', '1'),
('countries_australia_new_south_wales_bonnyrigg', 'ChIJ6ca-QiGUEmsRsK0yFmh9AQU', -33.8930618, 150.8891259, 'city', '1'),
('countries_australia_new_south_wales_bonnyrigg_heights', 'ChIJeZcY_ASUEmsRwK0yFmh9AQU', -33.8910592, 150.8688072, 'city', '1'),
('countries_australia_new_south_wales_bonny_hills', 'ChIJmbqz8Lz9dWsRMJ1DkLQJBgQ', -31.5879159, 152.8332402, 'city', '1'),
('countries_australia_new_south_wales_bonville', 'ChIJndGOJq8cnGsRoJNDkLQJBgQ', -30.3753694, 153.0477509, 'city', '1'),
('countries_australia_new_south_wales_booker_bay', 'ChIJgTgok6C0cmsRANcyFmh9AQU', -33.5140471, 151.345364, 'city', '1'),
('countries_australia_new_south_wales_boolambayte', 'ChIJAVrYIjlmdGsRQJ1DkLQJBgQ', -32.4035253, 152.2787222, 'city', '1'),
('countries_australia_new_south_wales_boolaroo', 'ChIJfQiIJS08c2sR4OkyFmh9AQU', -32.9526508, 151.6231985, 'city', '1'),
('countries_australia_new_south_wales_boomerang_beach', 'ChIJmxk5m4M-dGsRUJ1DkLQJBgQ', -32.3405482, 152.5409853, 'city', '1'),
('countries_australia_new_south_wales_boorabee', 'ChIJE7E-792lkGsRQPJDkLQJBgQ', -28.69141, 153.0500809, 'city', '1'),
('countries_australia_new_south_wales_booragul', 'ChIJFY-4T5w8c2sR8OkyFmh9AQU', -32.9745052, 151.6085189, 'city', '1'),
('countries_australia_new_south_wales_booral', 'ChIJiXF35qGIdGsRgH9DkLQJBgQ', -32.4649718, 151.9675807, 'city', '1'),
('countries_australia_new_south_wales_boorooma', 'ChIJQcjV_FWXGGsRcCVEkLQJBgU', -35.074014, 147.365425, 'city', '1'),
('countries_australia_new_south_wales_booroorban', 'ChIJm66GBuBM3moRIMhDkLQJBgQ', -34.9322957, 144.7631234, 'city', '1'),
('countries_australia_new_south_wales_boorowa', 'ChIJmQGaJ5bKEGsRENtDkLQJBgQ', -34.4364648, 148.7167614, 'city', '1'),
('countries_australia_new_south_wales_booyong', 'ChIJ_bUKz2WEkGsRUPJDkLQJBgQ', -28.7464423, 153.4501722, 'city', '1'),
('countries_australia_new_south_wales_borambola', 'ChIJS1YM9GNjGGsRIOZDkLQJBgQ', -35.1724243, 147.6490152, 'city', '1'),
('countries_australia_new_south_wales_boree_creek', 'ChIJY_N_P9jdIWsRMMhDkLQJBgQ', -35.1095879, 146.6069502, 'city', '1'),
('countries_australia_new_south_wales_borenore', 'ChIJ-xTPWfwuEGsRoHdDkLQJBgQ', -33.2558943, 148.9664501, 'city', '1'),
('countries_australia_new_south_wales_boro', 'ChIJX2O7j1-GFmsRINtDkLQJBgQ', -35.2207457, 149.6947416, 'city', '1'),
('countries_australia_new_south_wales_bossley_park', 'ChIJdyr-BkWREmsR0K0yFmh9AQU', -33.8628086, 150.8842945, 'city', '1'),
('countries_australia_new_south_wales_botany', 'ChIJs30P0w6xEmsR4K0yFmh9AQU', -33.9469267, 151.1973167, 'city', '1'),
('countries_australia_new_south_wales_bourke', 'ChIJVZAC1B1nAGsR4ANEkLQJBgQ', -30.0888375, 145.9377648, 'city', '1'),
('countries_australia_new_south_wales_bourkelands', 'ChIJ09Xqc8eeGGsRgCVEkLQJBgU', -35.1541192, 147.3499032, 'city', '1'),
('countries_australia_new_south_wales_bowen_mountain', 'ChIJLQWEaCmAEmsREDozFmh9AQU', -33.5738195, 150.6278209, 'city', '1'),
('countries_australia_new_south_wales_bowning', 'ChIJQ4nR2boVF2sRMNtDkLQJBgQ', -34.7663339, 148.8194487, 'city', '1'),
('countries_australia_new_south_wales_bowral', 'ChIJz78vQJiiE2sRkCREkLQJBgU', -34.4802367, 150.4176228, 'city', '1'),
('countries_australia_new_south_wales_bowraville', 'ChIJR4aD0SUpnGsRwJNDkLQJBgQ', -30.6476743, 152.8525332, 'city', '1'),
('countries_australia_new_south_wales_bow_bowing', 'ChIJfaDComvsEmsR8K0yFmh9AQU', -34.0200071, 150.8385737, 'city', '1'),
('countries_australia_new_south_wales_boxers_creek', 'ChIJ2aWG8LipFmsR_QFdbmcI7v4', -34.7618133, 149.8507158, 'city', '1'),
('countries_australia_new_south_wales_bradbury', 'ChIJR-s19NLvEmsREK4yFmh9AQU', -34.0888594, 150.8131111, 'city', '1'),
('countries_australia_new_south_wales_braemar', 'ChIJ2zKE_yuiE2sRQI5DkLQJBgQ', -34.4305232, 150.4829181, 'city', '1'),
('countries_australia_new_south_wales_braidwood', 'ChIJGwK1fBHTFWsRIAdEkLQJBgQ', -35.4460326, 149.7990648, 'city', '1'),
('countries_australia_new_south_wales_brandy_hill', 'ChIJ76Mh9yJoc2sRsH9DkLQJBgQ', -32.6959721, 151.6964513, 'city', '1'),
('countries_australia_new_south_wales_branxton', 'ChIJx-1I-htNc2sREOoyFmh9AQU', -32.6559544, 151.3513996, 'city', '1'),
('countries_australia_new_south_wales_braunstone', 'ChIJd9ZkvuDmm2sR8BZEkLQJBgQ', -29.8024966, 152.9592491, 'city', '1'),
('countries_australia_new_south_wales_bray_park', 'ChIJa2KF3MPvkGsRgCpEkLQJBgU', -28.3404194, 153.3752675, 'city', '1'),
('countries_australia_new_south_wales_breakfast_point', 'ChIJ96aj2xWlEmsRIK4yFmh9AQU', -33.8425356, 151.110938, 'city', '1'),
('countries_australia_new_south_wales_bream_beach', 'ChIJo6eWvUiJFGsR8NRDkLQJBgQ', -35.1106994, 150.661719, 'city', '1'),
('countries_australia_new_south_wales_bredbo', 'ChIJUbWA4SydPWsRYNtDkLQJBgQ', -35.9535639, 149.1468017, 'city', '1'),
('countries_australia_new_south_wales_brewarrina', 'ChIJ7RMD-EP_qWsR8ANEkLQJBgQ', -29.96247, 146.8611294, 'city', '1'),
('countries_australia_new_south_wales_brewongle', 'ChIJ6ZSe-djkEWsREF1DkLQJBgQ', -33.4823046, 149.7102871, 'city', '1'),
('countries_australia_new_south_wales_brierfield', 'ChIJgWysOksinGsR0JNDkLQJBgQ', -30.5178333, 152.9131995, 'city', '1'),
('countries_australia_new_south_wales_brighton_le_sands', 'ChIJLdtfEE23EmsRMK4yFmh9AQU', -33.9590873, 151.1520593, 'city', '1'),
('countries_australia_new_south_wales_brightwaters', 'ChIJLaB8SLYnc2sRINcyFmh9AQU', -33.1166548, 151.546542, 'city', '1'),
('countries_australia_new_south_wales_brimbin', 'ChIJeRVS0-vHdWsRYC5EkLQJBgU', -31.8611942, 152.4801835, 'city', '1'),
('countries_australia_new_south_wales_bringelly', 'ChIJeRa0T97yEmsRQK4yFmh9AQU', -33.9303747, 150.7271608, 'city', '1'),
('countries_australia_new_south_wales_broadmeadow', 'ChIJFcQyN7oVc2sRMOoyFmh9AQU', -32.9241709, 151.7305971, 'city', '1'),
('countries_australia_new_south_wales_broadwater', 'ChIJg22VNw9lmmsRABdEkLQJBgQ', -29.0145838, 153.4300366, 'city', '1'),
('countries_australia_new_south_wales_brocklehurst', 'ChIJJ67zWtRoD2sR8HdDkLQJBgQ', -32.1806379, 148.6226326, 'city', '1'),
('countries_australia_new_south_wales_brogo', 'ChIJlR1VJq3RPWsRQAdEkLQJBgQ', -36.5453705, 149.8072293, 'city', '1'),
('countries_australia_new_south_wales_broke', 'ChIJAWnry3PIDGsR8H9DkLQJBgQ', -32.7493668, 151.1025658, 'city', '1'),
('countries_australia_new_south_wales_broken_head', 'ChIJ6-G7ZfyHkGsRgPJDkLQJBgQ', -28.7108362, 153.5936066, 'city', '1'),
('countries_australia_new_south_wales_broken_hill', 'ChIJzcJS3mAz72oRcAFEkLQJBgQ', -31.9595859, 141.4608138, 'city', '1'),
('countries_australia_new_south_wales_brombin', 'ChIJkZ-adhT3dWsR0J1DkLQJBgQ', -31.457226, 152.6361622, 'city', '1'),
('countries_australia_new_south_wales_bronte', 'ChIJCQe5EnayEmsRUK4yFmh9AQU', -33.902954, 151.259729, 'city', '1'),
('countries_australia_new_south_wales_brooklet', 'ChIJmSCbffWGkGsRkPJDkLQJBgQ', -28.730676, 153.5146314, 'city', '1'),
('countries_australia_new_south_wales_brooklyn', 'ChIJ0TaV6cBRDWsRYK4yFmh9AQU', -33.5475372, 151.2190601, 'city', '1'),
('countries_australia_new_south_wales_brookvale', 'ChIJadAVxGCqEmsRcK4yFmh9AQU', -33.76497, 151.2704476, 'city', '1'),
('countries_australia_new_south_wales_brooms_head', 'ChIJ1XkXr8m2m2sREBdEkLQJBgQ', -29.6083168, 153.3358324, 'city', '1'),
('countries_australia_new_south_wales_broughton_vale', 'ChIJS0NU33F6E2sRgEUzFmh9AQU', -34.7386101, 150.7063591, 'city', '1'),
('countries_australia_new_south_wales_broughton_village', 'ChIJlW8Zp_h6E2sRRfJBRr8EP0w', -34.7468827, 150.752914, 'city', '1'),
('countries_australia_new_south_wales_broulee', 'ChIJZzp8VTfsFWsRYAdEkLQJBgQ', -35.8549913, 150.1746997, 'city', '1'),
('countries_australia_new_south_wales_brownlow_hill', 'ChIJZ8dgHAj3EmsR8DszFmh9AQU', -34.0369413, 150.6566072, 'city', '1'),
('countries_australia_new_south_wales_brownsville', 'ChIJ6Y7-z6sRE2sRgOEyFmh9AQU', -34.4827758, 150.8068394, 'city', '1'),
('countries_australia_new_south_wales_brundee', 'ChIJFWkmzyh-E2sRAeaoVncvljw', -34.8935164, 150.6550658, 'city', '1'),
('countries_australia_new_south_wales_brunkerville', 'ChIJF2o4k4cwc2sRQOoyFmh9AQU', -32.9487995, 151.4789463, 'city', '1'),
('countries_australia_new_south_wales_brunswick_heads', 'ChIJYRLjyJmLkGsRoPJDkLQJBgQ', -28.5414127, 153.5477651, 'city', '1'),
('countries_australia_new_south_wales_brushgrove', 'ChIJUZYB40fOm2sRIBdEkLQJBgQ', -29.5664412, 153.0795775, 'city', '1'),
('countries_australia_new_south_wales_buckajo', 'ChIJjUr3ZEUvPGsRcAdEkLQJBgQ', -36.6884966, 149.811187, 'city', '1'),
('countries_australia_new_south_wales_buckra_bendinni', 'ChIJq-D3nFWBnmsREJRDkLQJBgQ', -30.6316196, 152.8108855, 'city', '1'),
('countries_australia_new_south_wales_budgee_budgee', 'ChIJpfjas-aPDmsRcF1DkLQJBgQ', -32.5285832, 149.6559428, 'city', '1'),
('countries_australia_new_south_wales_budgewoi', 'ChIJ_6UdEnfZcmsRQNcyFmh9AQU', -33.234, 151.557, 'city', '1'),
('countries_australia_new_south_wales_buff_point', 'ChIJFSL7t47ZcmsRYNcyFmh9AQU', -33.2297812, 151.5314648, 'city', '1'),
('countries_australia_new_south_wales_bugaldie', 'ChIJI8PjlXqrCWsRcLlDkLQJBgQ', -31.1239139, 149.1106902, 'city', '1'),
('countries_australia_new_south_wales_bulahdelah', 'ChIJg2SuT8xmdGsR8J1DkLQJBgQ', -32.4057305, 152.2087957, 'city', '1'),
('countries_australia_new_south_wales_bulga', 'ChIJ3dS8UCm_DGsRIIBDkLQJBgQ', -32.6533758, 151.0213503, 'city', '1'),
('countries_australia_new_south_wales_bullaburra', 'ChIJRSMuPaBlEmsRcNQyFmh9AQU', -33.725329, 150.4130906, 'city', '1'),
('countries_australia_new_south_wales_bullatale', 'ChIJWQeGrZA132oRgMhDkLQJBgQ', -35.7442138, 145.1470402, 'city', '1'),
('countries_australia_new_south_wales_bullawa_creek', 'ChIJ1Sz8vpnaoGsRoL1DkLQJBgQ', -30.3078312, 149.9892668, 'city', '1'),
('countries_australia_new_south_wales_bulli', 'ChIJxxapOUweE2sRkOEyFmh9AQU', -34.3335025, 150.9133384, 'city', '1'),
('countries_australia_new_south_wales_bundanoon', 'ChIJ3ZbxFaWNE2sRYI5DkLQJBgQ', -34.6568082, 150.2994592, 'city', '1'),
('countries_australia_new_south_wales_bundarra', 'ChIJc8fY36DFoWsREK5DkLQJBgQ', -30.1718684, 151.0758502, 'city', '1'),
('countries_australia_new_south_wales_bundeena', 'ChIJQwYrDoXIEmsRgK4yFmh9AQU', -34.0850678, 151.1511763, 'city', '1'),
('countries_australia_new_south_wales_bungaba', 'ChIJ19pULsGvDmsRgF1DkLQJBgQ', -32.179591, 149.6262697, 'city', '1'),
('countries_australia_new_south_wales_bungarribee', 'ChIJMwD3AI-ZEmsRG_8kYtyqgRI', -33.7757513, 150.8689442, 'city', '1'),
('countries_australia_new_south_wales_bungendore', 'ChIJyRB3PB1eFmsRwNtDkLQJBgQ', -35.2562507, 149.440445, 'city', '1'),
('countries_australia_new_south_wales_bungonia', 'ChIJvdkadZQcFGsR0NtDkLQJBgQ', -34.8573298, 149.9432284, 'city', '1'),
('countries_australia_new_south_wales_bungwahl', 'ChIJk5pJE39qdGsRMJ5DkLQJBgQ', -32.3895639, 152.4428534, 'city', '1'),
('countries_australia_new_south_wales_bunnan', 'ChIJKyTDvGidC2sRQIBDkLQJBgQ', -32.0407758, 150.5940529, 'city', '1'),
('countries_australia_new_south_wales_bunyah', 'ChIJI-ePm0hYdGsRQJ5DkLQJBgQ', -32.1642758, 152.2191888, 'city', '1'),
('countries_australia_new_south_wales_bunyan', 'ChIJhzKbZfSjPWsR4NtDkLQJBgQ', -36.1693898, 149.1537216, 'city', '1'),
('countries_australia_new_south_wales_burcher', 'ChIJS8wh8FWWG2sR8HBDkLQJBgQ', -33.5156294, 147.2546402, 'city', '1'),
('countries_australia_new_south_wales_buronga', 'ChIJrSZ2eJPpwmoRgAFEkLQJBgQ', -34.1708751, 142.1811191, 'city', '1'),
('countries_australia_new_south_wales_burra', 'ChIJqwo-E-4zFmsR8NtDkLQJBgQ', -35.5574936, 149.2225266, 'city', '1'),
('countries_australia_new_south_wales_burradoo', 'ChIJd9mOK2eYE2sRoCREkLQJBgU', -34.5030332, 150.4058178, 'city', '1'),
('countries_australia_new_south_wales_burragate', 'ChIJf4_zLaYaPGsRoAdEkLQJBgQ', -37.0090327, 149.6203199, 'city', '1'),
('countries_australia_new_south_wales_burraneer', 'ChIJD5uOG3bIEmsRkK4yFmh9AQU', -34.0700325, 151.1378863, 'city', '1'),
('countries_australia_new_south_wales_burrawang', 'ChIJC9eF9UmeE2sRcI5DkLQJBgQ', -34.5934438, 150.5185067, 'city', '1'),
('countries_australia_new_south_wales_burren_junction', 'ChIJ-c3ophWlp2sRoLlDkLQJBgQ', -30.1024126, 148.9661622, 'city', '1'),
('countries_australia_new_south_wales_burrier', 'ChIJdfAU1V15FGsRkNVDkLQJBgQ', -34.870506, 150.4496105, 'city', '1'),
('countries_australia_new_south_wales_burrill_lake', 'ChIJm_1tOStSFGsRsAdEkLQJBgQ', -35.3889091, 150.444088, 'city', '1'),
('countries_australia_new_south_wales_burringbar', 'ChIJG2EyVRDxkGsRwPJDkLQJBgQ', -28.4297795, 153.4705343, 'city', '1'),
('countries_australia_new_south_wales_burrumbuttock', 'ChIJy31VOltjIWsR4MhDkLQJBgQ', -35.834219, 146.8046287, 'city', '1'),
('countries_australia_new_south_wales_burwood', 'ChIJYdbxl9y6EmsRoK4yFmh9AQU', -33.8773941, 151.1036621, 'city', '1'),
('countries_australia_new_south_wales_burwood_heights', 'ChIJjzQAluW6EmsRsK4yFmh9AQU', -33.8906534, 151.1047872, 'city', '1'),
('countries_australia_new_south_wales_busby', 'ChIJDcRFyWuUEmsRwK4yFmh9AQU', -33.9108752, 150.8798928, 'city', '1'),
('countries_australia_new_south_wales_buttaba', 'ChIJufeL1v8kc2sRYOoyFmh9AQU', -33.053247, 151.5799693, 'city', '1'),
('countries_australia_new_south_wales_buttai', 'ChIJCwJzeX04c2sRcOoyFmh9AQU', -32.8230868, 151.5599611, 'city', '1'),
('countries_australia_new_south_wales_buxton', 'ChIJ4dk-2mIAE2sRgI5DkLQJBgQ', -34.2565758, 150.5334838, 'city', '1'),
('countries_australia_new_south_wales_byabarra', 'ChIJ3RkFynPxdWsRYJ5DkLQJBgQ', -31.5283597, 152.5412221, 'city', '1'),
('countries_australia_new_south_wales_byangum', 'ChIJTWBPU0vukGsRkCpEkLQJBgU', -28.35, 153.366667, 'city', '1'),
('countries_australia_new_south_wales_byron_bay', 'ChIJK3Y-LYVikGsR0PJDkLQJBgQ', -28.6473671, 153.601977, 'city', '1'),
('countries_australia_new_south_wales_bywong', 'ChIJle2eKNb3FmsRANxDkLQJBgQ', -35.1799609, 149.3109945, 'city', '1'),
('countries_australia_new_south_wales_cabarita', 'ChIJY_eWQnH4kGsREDJEkLQJBgU', -28.3289849, 153.5698, 'city', '1'),
('countries_australia_new_south_wales_cabarita_beach', 'ChIJY_eWQnH4kGsREDJEkLQJBgU', -28.3289849, 153.5698, 'city', '1'),
('countries_australia_new_south_wales_cabramatta', 'ChIJOfz4zAuWEmsR4K4yFmh9AQU', -33.8940012, 150.9283445, 'city', '1'),
('countries_australia_new_south_wales_cabramatta_west', 'ChIJp4c-TdSVEmsR8K4yFmh9AQU', -33.8913358, 150.909389, 'city', '1'),
('countries_australia_new_south_wales_cabramurra', 'ChIJOes9WpM2PWsRAOdDkLQJBgQ', -35.9362026, 148.3802053, 'city', '1'),
('countries_australia_new_south_wales_caddens', 'ChIJQfUQy5yPEmsRGtcG8bpiD00', -33.7737634, 150.728184, 'city', '1'),
('countries_australia_new_south_wales_cadgee', 'ChIJJzcpNgYJPmsRwAdEkLQJBgQ', -36.1451746, 149.9203986, 'city', '1'),
('countries_australia_new_south_wales_caerleon', 'ChIJi9r2t2-JDmsR8F1DkLQJBgQ', -32.5702691, 149.55561, 'city', '1'),
('countries_australia_new_south_wales_calala', 'ChIJ13vGNu2iCmsRAClEkLQJBgU', -31.1303738, 150.9482946, 'city', '1'),
('countries_australia_new_south_wales_calderwood', 'ChIJjf6YX9AKE2sRkI5DkLQJBgQ', -34.5576702, 150.7556348, 'city', '1'),
('countries_australia_new_south_wales_calga', 'ChIJyWShqPBJDWsRgNcyFmh9AQU', -33.4308272, 151.2280315, 'city', '1'),
('countries_australia_new_south_wales_callaghan', 'ChIJu-odgH4Vc2sRgOoyFmh9AQU', -32.8941482, 151.7068833, 'city', '1'),
('countries_australia_new_south_wales_callala_bay', 'ChIJXyKsNn2EFGsRqDfzNl3CeqY', -34.9928932, 150.7217018, 'city', '1'),
('countries_australia_new_south_wales_callala_beach', 'ChIJA5nMw2eEFGsRsNVDkLQJBgQ', -35.0073686, 150.6998227, 'city', '1'),
('countries_australia_new_south_wales_camberwell', 'ChIJC-hj2QClDGsRcIBDkLQJBgQ', -32.4698192, 151.0883998, 'city', '1'),
('countries_australia_new_south_wales_cambewarra', 'ChIJQ-k9iFp_E2sR4OEyFmh9AQU', -34.8331941, 150.5726033, 'city', '1'),
('countries_australia_new_south_wales_cambridge_gardens', 'ChIJ-xksUqeFEmsRAK8yFmh9AQU', -33.7401147, 150.7217363, 'city', '1'),
('countries_australia_new_south_wales_cambridge_park', 'ChIJb64hoHaFEmsREK8yFmh9AQU', -33.7489421, 150.7304719, 'city', '1'),
('countries_australia_new_south_wales_camden', 'ChIJFUk7_ADxEmsRMDwzFmh9AQU', -34.0659551, 150.6935958, 'city', '1'),
('countries_spain_castille_la_mancha_minglanilla', 'ChIJ26FmB8oWZw0Rs8FSWOc2mcs', 39.4964568, -1.5789994, 'city', '0'),
('countries_australia_new_south_wales_camden_south', 'ChIJm7_dT_jwEmsRQDwzFmh9AQU', -34.0823993, 150.6947844, 'city', '1'),
('countries_australia_new_south_wales_camellia', 'ChIJLQh6-WWjEmsRIK8yFmh9AQU', -33.8197502, 151.0410034, 'city', '1'),
('countries_australia_new_south_wales_cameron_park', 'ChIJiRbUNXs5c2sRUEMzFmh9AQU', -32.9107871, 151.6156653, 'city', '1'),
('countries_australia_new_south_wales_cammeray', 'ChIJkyYu2LuuEmsRMK8yFmh9AQU', -33.8229724, 151.2102367, 'city', '1'),
('countries_australia_new_south_wales_campbelltown', 'ChIJf40DlVHuEmsRQK8yFmh9AQU', -34.0666148, 150.8195571, 'city', '1'),
('countries_australia_new_south_wales_camperdown', 'ChIJobCMZSywEmsRUK8yFmh9AQU', -33.8862243, 151.1791091, 'city', '1'),
('countries_australia_new_south_wales_campsie', 'ChIJq1Okxk-6EmsRYK8yFmh9AQU', -33.9087356, 151.1010267, 'city', '1'),
('countries_australia_new_south_wales_cams_wharf', 'ChIJ_f0Wjighc2sRoOoyFmh9AQU', -33.121914, 151.6163827, 'city', '1'),
('countries_australia_new_south_wales_canada_bay', 'ChIJLR95SDWlEmsRcK8yFmh9AQU', -33.866234, 151.1153528, 'city', '1'),
('countries_australia_new_south_wales_candelo', 'ChIJm3SGKPsjPGsR0AdEkLQJBgQ', -36.765825, 149.6939021, 'city', '1'),
('countries_australia_new_south_wales_caniaba', 'ChIJSXRyt3h1mmsREPNDkLQJBgQ', -28.8248492, 153.2104034, 'city', '1'),
('countries_australia_new_south_wales_canley_heights', 'ChIJz2jqMWmWEmsRgK8yFmh9AQU', -33.8836362, 150.9237564, 'city', '1'),
('countries_australia_new_south_wales_canley_vale', 'ChIJZw_6LRmWEmsRkK8yFmh9AQU', -33.8873043, 150.9433353, 'city', '1'),
('countries_australia_new_south_wales_canobolas', 'ChIJ3b12rdczEGsRYHhDkLQJBgQ', -33.3154909, 149.0241097, 'city', '1'),
('countries_australia_new_south_wales_canowindra', 'ChIJnyrDSsRlEGsRcHhDkLQJBgQ', -33.5622339, 148.6648597, 'city', '1'),
('countries_australia_new_south_wales_canterbury', 'ChIJZaMBil26EmsRsK8yFmh9AQU', -33.9144301, 151.1136352, 'city', '1'),
('countries_australia_new_south_wales_canton_beach', 'ChIJuZSwKvHacmsRkNcyFmh9AQU', -33.2716974, 151.5481758, 'city', '1'),
('countries_australia_new_south_wales_canyonleigh', 'ChIJIeIeFo3tE2sRoI5DkLQJBgQ', -34.578822, 150.1557782, 'city', '1'),
('countries_australia_new_south_wales_caparra', 'ChIJ2fPRoOWidWsRwJ5DkLQJBgQ', -31.7069974, 152.2350388, 'city', '1'),
('countries_australia_new_south_wales_captains_flat', 'ChIJlUF8ZAM5FmsRINxDkLQJBgQ', -35.589629, 149.4470654, 'city', '1'),
('countries_australia_new_south_wales_carabost', 'ChIJ44IocZ-MImsRIOdDkLQJBgQ', -35.6008743, 147.7286821, 'city', '1'),
('countries_australia_new_south_wales_carcoar', 'ChIJg0_meqW0EWsRUF5DkLQJBgQ', -33.6113874, 149.1400263, 'city', '1'),
('countries_australia_new_south_wales_cardiff', 'ChIJj06JXh0_c2sRsOoyFmh9AQU', -32.9482066, 151.6568211, 'city', '1'),
('countries_australia_new_south_wales_cardiff_heights', 'ChIJjzUW0nU-c2sRwOoyFmh9AQU', -32.9294789, 151.6674636, 'city', '1'),
('countries_australia_new_south_wales_cardiff_south', 'ChIJiwOGubg9c2sR0OoyFmh9AQU', -32.9535766, 151.6620805, 'city', '1'),
('countries_australia_new_south_wales_carey_bay', 'ChIJS6Gcdp4kc2sR4OoyFmh9AQU', -33.0266598, 151.6067263, 'city', '1'),
('countries_australia_new_south_wales_carinda', 'ChIJWwRB20N1B2sRMHFDkLQJBgQ', -30.4613617, 147.6913389, 'city', '1'),
('countries_australia_new_south_wales_caringbah', 'ChIJDeBTsvbHEmsRwK8yFmh9AQU', -34.0432609, 151.1235685, 'city', '1'),
('countries_australia_new_south_wales_caringbah_south', 'ChIJW9zdCY3HEmsRYEkzFmh9AQU', -34.0550256, 151.1214373, 'city', '1'),
('countries_australia_new_south_wales_carlingford', 'ChIJOaUESfijEmsR0K8yFmh9AQU', -33.7679751, 151.0434142, 'city', '1'),
('countries_australia_new_south_wales_carlton', 'ChIJg781R4u5EmsR4K8yFmh9AQU', -33.9685296, 151.1246063, 'city', '1'),
('countries_australia_new_south_wales_carnes_hill', 'ChIJof82cGiTEmsRCPqvrNaOmiw', -33.9363141, 150.8469362, 'city', '1'),
('countries_australia_new_south_wales_carramar', 'ChIJqR58v429EmsR8K8yFmh9AQU', -33.8820793, 150.9630004, 'city', '1'),
('countries_australia_new_south_wales_carrathool', 'ChIJS6kbWJ0d4GoREMlDkLQJBgQ', -34.4085281, 145.4339876, 'city', '1'),
('countries_australia_new_south_wales_carrick', 'ChIJ40nawMYAFGsRjceG3O-CFUA', -34.689425, 149.9274876, 'city', '1'),
('countries_australia_new_south_wales_carrington', 'ChIJr8rLyfQUc2sR8OoyFmh9AQU', -32.9160349, 151.7657575, 'city', '1'),
('countries_australia_new_south_wales_carroll', 'ChIJg8ndPLF7CmsR4L1DkLQJBgQ', -30.9915023, 150.4404524, 'city', '1'),
('countries_australia_new_south_wales_carss_park', 'ChIJnW7rQjW4EmsRALAyFmh9AQU', -33.9858713, 151.1160272, 'city', '1'),
('countries_australia_new_south_wales_cartwright', 'ChIJ0XfAfF6UEmsRELAyFmh9AQU', -33.9250949, 150.8899396, 'city', '1'),
('countries_australia_new_south_wales_carwoola', 'ChIJi36JX8BFFmsRkDBEkLQJBgU', -35.365331, 149.337142, 'city', '1'),
('countries_australia_new_south_wales_cascade', 'ChIJgyjryHOonmsRojTj4fJt2NA', -30.2608746, 152.7954229, 'city', '1'),
('countries_australia_new_south_wales_casino', 'ChIJFf1rWHoPmmsRIPNDkLQJBgQ', -28.8583975, 153.0469677, 'city', '1'),
('countries_australia_new_south_wales_cassilis', 'ChIJnRIO6FP6C2sRcF5DkLQJBgQ', -32.0063851, 149.9788293, 'city', '1'),
('countries_australia_new_south_wales_castlecrag', 'ChIJ2_8OVEWpEmsRQLAyFmh9AQU', -33.8016832, 151.2164179, 'city', '1'),
('countries_australia_new_south_wales_castlereagh', 'ChIJB-9TMn2bEmsRULAyFmh9AQU', -33.6686921, 150.6825449, 'city', '1'),
('countries_australia_new_south_wales_castle_cove', 'ChIJPSTOLmqpEmsRILAyFmh9AQU', -33.7874727, 151.2112292, 'city', '1'),
('countries_australia_new_south_wales_castle_doyle', 'ChIJB2rQ71ahn2sRkK5DkLQJBgQ', -30.5793599, 151.7379288, 'city', '1'),
('countries_australia_new_south_wales_castle_hill', 'ChIJqWACb--jEmsRMLAyFmh9AQU', -33.7348232, 151.0030714, 'city', '1'),
('countries_australia_new_south_wales_casuarina', 'ChIJm8HK6Jr4kGsRQC9EkLQJBgU', -28.3011946, 153.5712424, 'city', '1'),
('countries_australia_new_south_wales_casula', 'ChIJt1G99ueUEmsRYLAyFmh9AQU', -33.9503864, 150.9044946, 'city', '1'),
('countries_australia_new_south_wales_catalina', 'ChIJswfiPY3qFWsRcChEkLQJBgU', -35.7281323, 150.1878032, 'city', '1'),
('countries_australia_new_south_wales_cathcart', 'ChIJmdZiO91rPGsRQNxDkLQJBgQ', -36.8434827, 149.3883587, 'city', '1'),
('countries_australia_new_south_wales_catherine_field', 'ChIJRXWKLt7xEmsRcLAyFmh9AQU', -33.9878159, 150.769279, 'city', '1'),
('countries_australia_new_south_wales_catherine_hill_bay', 'ChIJj8vz8sAgc2sRoNcyFmh9AQU', -33.1578402, 151.6271715, 'city', '1'),
('countries_australia_new_south_wales_cattai', 'ChIJ7263GBBnDWsRgLAyFmh9AQU', -33.5599903, 150.907324, 'city', '1'),
('countries_australia_new_south_wales_caves_beach', 'ChIJP2GhLnIhc2sREOsyFmh9AQU', -33.1070067, 151.6451875, 'city', '1'),
('countries_australia_new_south_wales_cawdor', 'ChIJocMdPx76EmsRUDwzFmh9AQU', -34.085449, 150.6752921, 'city', '1'),
('countries_australia_new_south_wales_cecil_hills', 'ChIJVUCwVu-TEmsRkLAyFmh9AQU', -33.8876831, 150.8490573, 'city', '1'),
('countries_australia_new_south_wales_cecil_park', 'ChIJvezSisWTEmsRoLAyFmh9AQU', -33.8614808, 150.8263757, 'city', '1'),
('countries_australia_new_south_wales_cedar_brush_creek', 'ChIJJR7J7cstDWsRsNcyFmh9AQU', -33.1705606, 151.2769657, 'city', '1'),
('countries_australia_new_south_wales_cedar_party', 'ChIJv8NT9Ju5dWsR0J5DkLQJBgQ', -31.7985068, 152.3894487, 'city', '1'),
('countries_australia_new_south_wales_centennial_park', 'ChIJyV-lISKuEmsRsLAyFmh9AQU', -33.892162, 151.2321807, 'city', '1'),
('countries_spain_castille_la_mancha_la_roda', 'ChIJt7gREhI2Zg0RtqTbStu9Gx4', 39.1755765, -2.1843285, 'city', '0'),
('countries_australia_new_south_wales_central_macdonald', 'ChIJTQ2WsAtADWsRwEgzFmh9AQU', -33.331492, 150.9755056, 'city', '1'),
('countries_australia_new_south_wales_central_mangrove', 'ChIJsw6OV88zDWsRwNcyFmh9AQU', -33.2925411, 151.2360859, 'city', '1'),
('countries_australia_new_south_wales_central_tilba', 'ChIJC6r_e_4SPmsR4AdEkLQJBgQ', -36.3153297, 150.0804582, 'city', '1'),
('countries_australia_new_south_wales_cessnock', 'ChIJTdmSr_c0c2sRIOsyFmh9AQU', -32.8321587, 151.3558797, 'city', '1'),
('countries_australia_new_south_wales_chain_valley_bay', 'ChIJIxCKwYTYcmsR0NcyFmh9AQU', -33.1726603, 151.5705261, 'city', '1'),
('countries_australia_new_south_wales_charlestown', 'ChIJyU-MzNkXc2sRMOsyFmh9AQU', -32.967883, 151.6945872, 'city', '1'),
('countries_australia_new_south_wales_charlotte_bay', 'ChIJC-yPiVo-dGsR8J5DkLQJBgQ', -32.3549846, 152.505872, 'city', '1'),
('countries_australia_new_south_wales_charmhaven', 'ChIJTegF1HXacmsR4NcyFmh9AQU', -33.2262433, 151.5029848, 'city', '1'),
('countries_australia_new_south_wales_chatswood', 'ChIJQQZjH9SoEmsRwLAyFmh9AQU', -33.7960696, 151.1780469, 'city', '1'),
('countries_australia_new_south_wales_chatswood_west', 'ChIJ0fNGoEqvEmsR0LAyFmh9AQU', -33.7948914, 151.1631215, 'city', '1'),
('countries_spain_castille_la_mancha_isso', 'ChIJ_2AUhQ0uZA0Rx6fiiwoqxXQ', 38.4891448, -1.7454418, 'city', '0'),
('countries_australia_new_south_wales_cheero_point', 'ChIJT6sQCfxODWsRGaRGTYIXXW8', -33.5108405, 151.1944082, 'city', '1'),
('countries_australia_new_south_wales_cheltenham', 'ChIJhzgDFJOmEmsR4LAyFmh9AQU', -33.7587314, 151.0748656, 'city', '1'),
('countries_australia_new_south_wales_cherrybrook', 'ChIJj07T3tSgEmsR8LAyFmh9AQU', -33.724448, 151.038591, 'city', '1'),
('countries_australia_new_south_wales_chester_hill', 'ChIJGe4q7au9EmsRALEyFmh9AQU', -33.8863162, 151.0002234, 'city', '1'),
('countries_australia_new_south_wales_chifley', 'ChIJB7PmYvuzEmsRELEyFmh9AQU', -33.9699438, 151.2391581, 'city', '1'),
('countries_australia_new_south_wales_chilcotts_grass', 'ChIJHcdS6tp3mmsRACtEkLQJBgU', -28.834609, 153.3365499, 'city', '1'),
('countries_australia_new_south_wales_chillingham', 'ChIJ6wfv96_okGsRYPNDkLQJBgQ', -28.313547, 153.2761649, 'city', '1'),
('countries_australia_new_south_wales_chinderah', 'ChIJy20Tuib_kGsRUC9EkLQJBgU', -28.2374989, 153.5592754, 'city', '1'),
('countries_australia_new_south_wales_chippendale', 'ChIJmX02FgWuEmsRILEyFmh9AQU', -33.8860923, 151.1987222, 'city', '1'),
('countries_australia_new_south_wales_chipping_norton', 'ChIJT1gYcwO-EmsRMLEyFmh9AQU', -33.9154066, 150.9544194, 'city', '1'),
('countries_australia_new_south_wales_chiswick', 'ChIJSRcbTmClEmsRQLEyFmh9AQU', -33.8491787, 151.1394131, 'city', '1'),
('countries_australia_new_south_wales_chittaway_bay', 'ChIJt9WM2sbPcmsR8NcyFmh9AQU', -33.3248294, 151.4365141, 'city', '1'),
('countries_australia_new_south_wales_chittaway_point', 'ChIJoe7mRkPOcmsRANgyFmh9AQU', -33.3228133, 151.447667, 'city', '1'),
('countries_australia_new_south_wales_chullora', 'ChIJgXo1n4G7EmsRULEyFmh9AQU', -33.8986062, 151.0431637, 'city', '1'),
('countries_australia_new_south_wales_church_point', 'ChIJQYT_G3hTDWsRYLEyFmh9AQU', -33.6458116, 151.2840729, 'city', '1'),
('countries_australia_new_south_wales_claremont_meadows', 'ChIJRXW0VvaPEmsRkLEyFmh9AQU', -33.779, 150.753, 'city', '1'),
('countries_australia_new_south_wales_clarence', 'ChIJe3G2oS91EmsR0F5DkLQJBgQ', -33.4820991, 150.2243765, 'city', '1'),
('countries_australia_new_south_wales_clarence_town', 'ChIJocPjqKhjc2sREIFDkLQJBgQ', -32.585028, 151.77775, 'city', '1'),
('countries_australia_new_south_wales_clarenza', 'ChIJRZe9hQjbm2sRkCxEkLQJBgU', -29.7131251, 153.0029847, 'city', '1'),
('countries_australia_new_south_wales_clareville', 'ChIJmbMx8yRTDWsRsLEyFmh9AQU', -33.6362228, 151.3100857, 'city', '1'),
('countries_australia_new_south_wales_claymore', 'ChIJPWJsLGLuEmsR4LEyFmh9AQU', -34.0444, 150.8096, 'city', '1'),
('countries_australia_new_south_wales_clemton_park', 'ChIJ0WOYqTe6EmsRcEMzFmh9AQU', -33.9258275, 151.104641, 'city', '1'),
('countries_australia_new_south_wales_clergate', 'ChIJVZ_kZ7gqEGsR8F5DkLQJBgQ', -33.2054844, 149.1141315, 'city', '1'),
('countries_australia_new_south_wales_cliftleigh', 'ChIJAxFYKpVHc2sRUOsyFmh9AQU', -32.7900049, 151.5165234, 'city', '1'),
('countries_australia_new_south_wales_clifton', 'ChIJoZ11mD3eEmsR8OEyFmh9AQU', -34.259444, 150.969167, 'city', '1'),
('countries_australia_new_south_wales_clifton_grove', 'ChIJQa27YGrUEWsRAF9DkLQJBgQ', -33.2427558, 149.1845642, 'city', '1'),
('countries_australia_new_south_wales_clontarf', 'ChIJU93uNO2rEmsRALIyFmh9AQU', -33.80834, 151.25342, 'city', '1'),
('countries_australia_new_south_wales_clothiers_creek', 'ChIJOwe0-lP3kGsRgPNDkLQJBgQ', -28.333333, 153.5, 'city', '1'),
('countries_australia_new_south_wales_clovelly', 'ChIJye2IiXGyEmsRELIyFmh9AQU', -33.9121, 151.2629, 'city', '1'),
('countries_australia_new_south_wales_clunes', 'ChIJp03OKeqEkGsRoPNDkLQJBgQ', -28.733333, 153.4, 'city', '1'),
('countries_australia_new_south_wales_clybucca', 'ChIJXdwrk-fQnWsRYJRDkLQJBgQ', -30.9483012, 152.959187, 'city', '1'),
('countries_australia_new_south_wales_clyde', 'ChIJG2bIUzKjEmsRifm7mop8quA', -33.8325954, 151.0223928, 'city', '1'),
('countries_australia_new_south_wales_coalcliff', 'ChIJz15iVwzeEmsRAOIyFmh9AQU', -34.2457264, 150.9729194, 'city', '1'),
('countries_australia_new_south_wales_coaldale', 'ChIJHbs_1tuBmWsR8BdEkLQJBgQ', -29.4525068, 152.8257332, 'city', '1'),
('countries_australia_new_south_wales_coal_point', 'ChIJE75V8X4jc2sRYOsyFmh9AQU', -33.037, 151.61, 'city', '1'),
('countries_australia_new_south_wales_cobaki_lakes', 'ChIJp_JUkvz9kGsRcC9EkLQJBgU', -28.1712097, 153.4803044, 'city', '1'),
('countries_australia_new_south_wales_cobar', 'ChIJXWBY03FcAmsRIAREkLQJBgQ', -31.495761, 145.8388597, 'city', '1'),
('countries_australia_new_south_wales_cobargo', 'ChIJHd4q0G13PmsREAhEkLQJBgQ', -36.3865699, 149.9017972, 'city', '1'),
('countries_australia_new_south_wales_cobar_park', 'ChIJu9D5UGQKEmsRUCFEkLQJBgU', -33.4647181, 150.1575358, 'city', '1'),
('countries_australia_new_south_wales_cobbitty', 'ChIJRe9R0j7xEmsRMLIyFmh9AQU', -34.016667, 150.683333, 'city', '1'),
('countries_australia_new_south_wales_coffs_harbour', 'ChIJHaTYiwkOnGsREC1EkLQJBgU', -30.298612, 153.1093922, 'city', '1'),
('countries_australia_new_south_wales_coleambally', 'ChIJ_0DnC5AhIGsRMMlDkLQJBgQ', -34.8053864, 145.882762, 'city', '1'),
('countries_australia_new_south_wales_colebee', 'ChIJA3Z0FmiZEmsRQLIyFmh9AQU', -33.721, 150.855, 'city', '1'),
('countries_australia_new_south_wales_coledale', 'ChIJAS5vdEfgEmsREOIyFmh9AQU', -34.283333, 150.95, 'city', '1'),
('countries_australia_new_south_wales_collarenebri', 'ChIJL9CF1XE9pmsRsLlDkLQJBgQ', -29.5430236, 148.5785584, 'city', '1'),
('countries_australia_new_south_wales_collaroy', 'ChIJ8XcieEJVDWsRULIyFmh9AQU', -33.73, 151.3, 'city', '1'),
('countries_spain_castille_la_mancha_el_robledo', 'ChIJj28IYIOsaw0RoEtMvvNAAwQ', 39.2179353, -4.2826759, 'city', '0'),
('countries_australia_new_south_wales_collaroy_plateau', 'ChIJt1gGvHZVDWsRYLIyFmh9AQU', -33.7293326, 151.290404, 'city', '1'),
('countries_australia_new_south_wales_collendina', 'ChIJnVzuqnwoIWsRUMlDkLQJBgQ', -36.0240819, 146.2206437, 'city', '1'),
('countries_australia_new_south_wales_collie', 'ChIJ499DzF3-BWsRUHFDkLQJBgQ', -31.6752574, 148.2850854, 'city', '1'),
('countries_australia_new_south_wales_collingullie', 'ChIJrXF6OhCoGGsRYMlDkLQJBgQ', -35.088611, 147.128889, 'city', '1'),
('countries_australia_new_south_wales_collins_creek', 'ChIJuZiGxgq6kGsRwPNDkLQJBgQ', -28.4784888, 153.0305349, 'city', '1'),
('countries_australia_new_south_wales_collombatti', 'ChIJF9-tUWyAnmsRgJRDkLQJBgQ', -31.001889, 152.8367611, 'city', '1'),
('countries_australia_new_south_wales_colo', 'ChIJgZSwJ1NuDWsRIEgzFmh9AQU', -33.416667, 150.8, 'city', '1'),
('countries_australia_new_south_wales_colo_heights', 'ChIJbQuqiJNyDWsR0EczFmh9AQU', -33.369, 150.722, 'city', '1'),
('countries_australia_new_south_wales_colo_vale', 'ChIJAens5kqkE2sR0I5DkLQJBgQ', -34.4, 150.483333, 'city', '1'),
('countries_australia_new_south_wales_colyton', 'ChIJlV_Fg3OQEmsRcLIyFmh9AQU', -33.7830958, 150.7954903, 'city', '1'),
('countries_australia_new_south_wales_comboyne', 'ChIJmeNNHKPtdWsREJ9DkLQJBgQ', -31.605867, 152.46835, 'city', '1'),
('countries_australia_new_south_wales_como', 'ChIJndTLfZa4EmsRgLIyFmh9AQU', -34.0045, 151.06379, 'city', '1'),
('countries_australia_new_south_wales_concord', 'ChIJ1UqRedO6EmsRkLIyFmh9AQU', -33.8550219, 151.1078139, 'city', '1'),
('countries_australia_new_south_wales_concord_west', 'ChIJu293FN-kEmsRsLIyFmh9AQU', -33.8396663, 151.088239, 'city', '1'),
('countries_australia_new_south_wales_condell_park', 'ChIJCVI9koS-EmsRwLIyFmh9AQU', -33.92498, 151.00769, 'city', '1'),
('countries_australia_new_south_wales_condobolin', 'ChIJd7GvSHxeG2sRcHFDkLQJBgQ', -33.0885216, 147.1472337, 'city', '1'),
('countries_australia_new_south_wales_condong', 'ChIJlyHYhGb6kGsR4PNDkLQJBgQ', -28.316667, 153.433333, 'city', '1'),
('countries_australia_new_south_wales_congarinni', 'ChIJMV0gNsornGsRoJRDkLQJBgQ', -30.7700372, 152.8617596, 'city', '1'),
('countries_australia_new_south_wales_congewai', 'ChIJzQmf4k_SDGsRMIFDkLQJBgQ', -32.9783727, 151.2860306, 'city', '1'),
('countries_australia_new_south_wales_congo', 'ChIJYV7G7KL2FWsRQAhEkLQJBgQ', -35.9597908, 150.1358366, 'city', '1'),
('countries_australia_new_south_wales_coniston', 'ChIJTb1RDnQZE2sRIOIyFmh9AQU', -34.4383388, 150.8827443, 'city', '1'),
('countries_australia_new_south_wales_conjola', 'ChIJ31sPhglcFGsRMNdDkLQJBgQ', -35.2696191, 150.4810158, 'city', '1'),
('countries_australia_new_south_wales_connells_point', 'ChIJRRJb-VW4EmsR0LIyFmh9AQU', -33.98246, 151.10016, 'city', '1'),
('countries_australia_new_south_wales_constitution_hill', 'ChIJ2WRMlYqiEmsRMEkzFmh9AQU', -33.7945, 150.9765, 'city', '1'),
('countries_australia_new_south_wales_coogee', 'ChIJ4ZOCY5yxEmsR4LIyFmh9AQU', -33.919, 151.2555, 'city', '1'),
('countries_australia_new_south_wales_cooks_gap', 'ChIJNdQqK4CiDmsRQF9DkLQJBgQ', -32.3629938, 149.7141154, 'city', '1'),
('countries_australia_new_south_wales_cooks_hill', 'ChIJkQE0okEUc2sRcOsyFmh9AQU', -32.9338, 151.7696, 'city', '1'),
('countries_australia_new_south_wales_coolabah', 'ChIJey4pNw1FAWsRQAREkLQJBgQ', -31.0204087, 146.7122744, 'city', '1'),
('countries_australia_new_south_wales_coolac', 'ChIJLYioK4ArGGsRcOdDkLQJBgQ', -34.8923258, 148.2213327, 'city', '1'),
('countries_australia_new_south_wales_coolagolite', 'ChIJd3gDq3F5PmsRUAhEkLQJBgQ', -36.4023169, 149.9777187, 'city', '1'),
('countries_australia_new_south_wales_coolah', 'ChIJa0-m3YFfCWsRUF9DkLQJBgQ', -31.844224, 149.6831167, 'city', '1'),
('countries_australia_new_south_wales_coolamon', 'ChIJmQeNAEbCGGsRgMlDkLQJBgQ', -34.8195243, 147.2005423, 'city', '1'),
('countries_australia_new_south_wales_coolangatta', 'ChIJIRUATfB8E2sRgEQzFmh9AQU', -34.8547862, 150.7141742, 'city', '1'),
('countries_australia_new_south_wales_coolongolook', 'ChIJLShzdCNFdGsRMJ9DkLQJBgQ', -32.2122679, 152.3192667, 'city', '1'),
('countries_australia_new_south_wales_cooma', 'ChIJiTtT7JauPWsRwNxDkLQJBgQ', -36.2268655, 149.1297882, 'city', '1'),
('countries_australia_new_south_wales_coomba_park', 'ChIJ5T5rMRU4dGsRUJ9DkLQJBgQ', -32.2366033, 152.4742956, 'city', '1'),
('countries_australia_new_south_wales_coombell', 'ChIJReFGAcsbmmsRIBhEkLQJBgQ', -29.0161163, 152.9770541, 'city', '1'),
('countries_australia_new_south_wales_coonabarabran', 'ChIJ1Q7_QOUGCWsR0HhDkLQJBgQ', -31.2734198, 149.2772344, 'city', '1'),
('countries_australia_new_south_wales_coonamble', 'ChIJVfbbONF2CGsRoHFDkLQJBgQ', -30.954253, 148.3884139, 'city', '1'),
('countries_australia_new_south_wales_cooperabung', 'ChIJ4cS0EfYInmsRYJ9DkLQJBgQ', -31.2965285, 152.8123854, 'city', '1'),
('countries_australia_new_south_wales_coopernook', 'ChIJ6XFevl3DdWsRcJ9DkLQJBgQ', -31.8248896, 152.6125409, 'city', '1'),
('countries_australia_new_south_wales_coopers_shoot', 'ChIJFbhachyIkGsRAPRDkLQJBgQ', -28.6909104, 153.5713622, 'city', '1'),
('countries_australia_new_south_wales_cooranbong', 'ChIJJaOfAvIoc2sRgOsyFmh9AQU', -33.0767884, 151.4533777, 'city', '1'),
('countries_australia_new_south_wales_cootamundra', 'ChIJY0E0RFG2GWsRkOdDkLQJBgQ', -34.6386855, 148.0240849, 'city', '1'),
('countries_australia_new_south_wales_copacabana', 'ChIJU329B2W2cmsRQNgyFmh9AQU', -33.4904263, 151.4315807, 'city', '1'),
('countries_australia_new_south_wales_copmanhurst', 'ChIJJTN_MVN9mWsRMBhEkLQJBgQ', -29.5863341, 152.7762578, 'city', '1'),
('countries_australia_new_south_wales_coraki', 'ChIJkSoyLRFymmsRQBhEkLQJBgQ', -28.993391, 153.2816992, 'city', '1'),
('countries_australia_new_south_wales_coramba', 'ChIJDfXEIBYGnGsRsJRDkLQJBgQ', -30.2217054, 153.0144478, 'city', '1'),
('countries_australia_new_south_wales_corang', 'ChIJv0MUlWY6FGsRgAhEkLQJBgQ', -35.1504624, 150.0768055, 'city', '1'),
('countries_australia_new_south_wales_cordeaux_heights', 'ChIJhfdFGp0QE2sRMOIyFmh9AQU', -34.4451841, 150.8376789, 'city', '1'),
('countries_australia_new_south_wales_coreen', 'ChIJE3-RdlwbIWsRsMlDkLQJBgQ', -35.7483963, 146.3447434, 'city', '1'),
('countries_australia_new_south_wales_corindi', 'ChIJ84tZOMzym2sRxOvC69B7hiM', -30.030916, 153.198665, 'city', '1'),
('countries_australia_new_south_wales_corlette', 'ChIJjyxKLDGCc2sRkOsyFmh9AQU', -32.717133, 152.1130056, 'city', '1'),
('countries_australia_new_south_wales_corndale', 'ChIJ4SyreR6bkGsRIPRDkLQJBgQ', -28.6994571, 153.3656799, 'city', '1'),
('countries_australia_new_south_wales_corowa', 'ChIJKeO-a4kvIWsR0MlDkLQJBgQ', -35.9987227, 146.3911991, 'city', '1'),
('countries_australia_new_south_wales_corrimal', 'ChIJI38I18geE2sRQOIyFmh9AQU', -34.373193, 150.8969115, 'city', '1'),
('countries_australia_new_south_wales_corunna', 'ChIJlxBSQ08RPmsRkAhEkLQJBgQ', -36.277068, 150.1046742, 'city', '1'),
('countries_australia_new_south_wales_cottage_point', 'ChIJlzqMiRZRDWsRALMyFmh9AQU', -33.6168312, 151.2051242, 'city', '1'),
('countries_australia_new_south_wales_cottonvale', 'ChIJZ_7u2i0omGsRAKsgf_HuAAQ', -28.5212525, 151.9671983, 'city', '1'),
('countries_australia_new_south_wales_couridjah', 'ChIJbywjCOqqE2sR8I5DkLQJBgQ', -34.2337918, 150.5532698, 'city', '1'),
('countries_australia_new_south_wales_coutts_crossing', 'ChIJJWNEPNzjm2sRUBhEkLQJBgQ', -29.8269534, 152.8919184, 'city', '1'),
('countries_australia_new_south_wales_cowan', 'ChIJ7f-N0mtQDWsRELMyFmh9AQU', -33.5899157, 151.1711015, 'city', '1'),
('countries_australia_new_south_wales_cowper', 'ChIJP0Wu4WTOm2sRYBhEkLQJBgQ', -29.5731697, 153.0737782, 'city', '1'),
('countries_australia_new_south_wales_cowra', 'ChIJTThXQVeREGsR4HhDkLQJBgQ', -33.8346839, 148.6911799, 'city', '1'),
('countries_spain_castille_la_mancha_alcala_del_jucar', 'ChIJx3TDoPjaZg0R8M9LvvNAAwQ', 39.1917781, -1.4295714, 'city', '0'),
('countries_australia_new_south_wales_crabbes_creek', 'ChIJCTGtmmHzkGsRQPRDkLQJBgQ', -28.4564126, 153.4964766, 'city', '1'),
('countries_australia_new_south_wales_crackenback', 'ChIJQ3ndtM3OPGsRkBJEkLQJBgQ', -36.4397414, 148.5178304, 'city', '1'),
('countries_australia_new_south_wales_craigie', 'ChIJW0mttcN7O2sR4NxDkLQJBgQ', -37.0708568, 149.0507886, 'city', '1'),
('countries_australia_new_south_wales_cranebrook', 'ChIJffZ9mK6FEmsRILMyFmh9AQU', -33.7192974, 150.7087705, 'city', '1'),
('countries_australia_new_south_wales_craven', 'ChIJp1WbDSH3dGsRsJ9DkLQJBgQ', -32.1407977, 151.9376168, 'city', '1'),
('countries_australia_new_south_wales_cremorne', 'ChIJ_2gHg6OuEmsRMLMyFmh9AQU', -33.8292068, 151.22822, 'city', '1'),
('countries_australia_new_south_wales_cremorne_point', 'ChIJfbVJS4OuEmsRQLMyFmh9AQU', -33.838744, 151.2270386, 'city', '1'),
('countries_australia_new_south_wales_crescent_head', 'ChIJeztPetXgnWsR4JRDkLQJBgQ', -31.1769749, 152.9106663, 'city', '1'),
('countries_australia_new_south_wales_crestwood', 'ChIJWTMxWJROFmsRoDBEkLQJBgU', -35.3467408, 149.2108456, 'city', '1'),
('countries_australia_new_south_wales_cringila', 'ChIJ1WCs1UsXE2sRUOIyFmh9AQU', -34.4666668, 150.8724334, 'city', '1'),
('countries_australia_new_south_wales_cromer', 'ChIJ50mndpBVDWsRULMyFmh9AQU', -33.7370436, 151.28272, 'city', '1'),
('countries_australia_new_south_wales_cronulla', 'ChIJM4_YNRLIEmsRYLMyFmh9AQU', -34.0516553, 151.1545063, 'city', '1'),
('countries_australia_new_south_wales_crooble', 'ChIJFUSF7F3Do2sRgL5DkLQJBgQ', -29.2784535, 150.2655488, 'city', '1'),
('countries_australia_new_south_wales_crooked_corner', 'ChIJy7Vt9v4XEWsRwF9DkLQJBgQ', -34.2328227, 149.2934262, 'city', '1'),
('countries_australia_new_south_wales_crookwell', 'ChIJPSVs4G02EWsRAN1DkLQJBgQ', -34.4580448, 149.4702871, 'city', '1'),
('countries_australia_new_south_wales_croppa_creek', 'ChIJDQrRkRi5o2sRkL5DkLQJBgQ', -29.1247982, 150.3047724, 'city', '1'),
('countries_australia_new_south_wales_croudace_bay', 'ChIJO62sS9E8c2sRoOsyFmh9AQU', -33.0058867, 151.6448655, 'city', '1'),
('countries_australia_new_south_wales_crows_nest', 'ChIJQVclt-uuEmsRcLMyFmh9AQU', -33.8241049, 151.2027151, 'city', '1'),
('countries_australia_new_south_wales_croydon', 'ChIJ16wGVMe6EmsRgLMyFmh9AQU', -33.8840281, 151.1141301, 'city', '1'),
('countries_australia_new_south_wales_cudal', 'ChIJDbqHHykUEGsR8HhDkLQJBgQ', -33.2867614, 148.7389367, 'city', '1'),
('countries_australia_new_south_wales_cudgen', 'ChIJb05k6M34kGsRgC9EkLQJBgU', -28.2641144, 153.5560187, 'city', '1'),
('countries_australia_new_south_wales_cudgera_creek', 'ChIJbVdN0jf3kGsRYPRDkLQJBgQ', -28.3937323, 153.510375, 'city', '1'),
('countries_australia_new_south_wales_cudmirrah', 'ChIJ_YR0Qd9fFGsRMNZDkLQJBgQ', -35.1980298, 150.5578041, 'city', '1'),
('countries_australia_new_south_wales_culburra_beach', 'ChIJpTrldGp9E2sRkEMzFmh9AQU', -34.9304549, 150.7580271, 'city', '1'),
('countries_australia_new_south_wales_culcairn', 'ChIJebdrHXYuImsRAMpDkLQJBgQ', -35.6677758, 147.0371391, 'city', '1'),
('countries_australia_new_south_wales_cullenbone', 'ChIJi7xnjAaNDmsREGBDkLQJBgQ', -32.4977326, 149.5120499, 'city', '1'),
('countries_australia_new_south_wales_cullen_bullen', 'ChIJfwxJSHbwDWsRAGBDkLQJBgQ', -33.2994059, 150.0330207, 'city', '1'),
('countries_australia_new_south_wales_cumbalum', 'ChIJaQJLtvyAkGsRcPRDkLQJBgQ', -28.8204625, 153.5326042, 'city', '1'),
('countries_australia_new_south_wales_cumberland_reach', 'ChIJCycy_JVoDWsR59-njg_ciNk', -33.4696441, 150.8988046, 'city', '1'),
('countries_australia_new_south_wales_cumnock', 'ChIJlaPaTBjlD2sRIHlDkLQJBgQ', -32.9305076, 148.7546458, 'city', '1'),
('countries_australia_new_south_wales_cundletown', 'ChIJH3oLk4fIdWsRcC5EkLQJBgU', -31.9001521, 152.5177062, 'city', '1'),
('countries_australia_new_south_wales_cundumbul', 'ChIJ4Xof25zID2sRMHlDkLQJBgQ', -32.8355532, 148.9093294, 'city', '1'),
('countries_australia_new_south_wales_curlewis', 'ChIJ2wWto2ZpCmsRoL5DkLQJBgQ', -31.1172394, 150.2646882, 'city', '1'),
('countries_australia_new_south_wales_curlwaa', 'ChIJgX0eLa2rw2oRkAFEkLQJBgQ', -34.1106539, 141.9794578, 'city', '1'),
('countries_australia_new_south_wales_curl_curl', 'ChIJxQQSN_KqEmsRoLMyFmh9AQU', -33.7693969, 151.291992, 'city', '1'),
('countries_australia_new_south_wales_currabubula', 'ChIJtZ5z4ESMCmsRsL5DkLQJBgQ', -31.2642323, 150.7319363, 'city', '1'),
('countries_australia_new_south_wales_currans_hill', 'ChIJrYlgWLjxEmsRsLMyFmh9AQU', -34.04575, 150.7695729, 'city', '1'),
('countries_australia_new_south_wales_currarong', 'ChIJyZ9RtIWbFGsRUNZDkLQJBgQ', -35.01478, 150.8234898, 'city', '1'),
('countries_australia_new_south_wales_currawarna', 'ChIJ6zJbm82xGGsRQMpDkLQJBgQ', -35.0133382, 147.0690154, 'city', '1'),
('countries_australia_new_south_wales_daceyville', 'ChIJRbz4l3WxEmsR0LMyFmh9AQU', -33.9285039, 151.2268904, 'city', '1'),
('countries_australia_new_south_wales_dairymans_plains', 'ChIJezasdB0HPWsRMN1DkLQJBgQ', -36.2302376, 149.0706947, 'city', '1'),
('countries_australia_new_south_wales_dairy_flat', 'ChIJsTWhzrNJl2sRgPRDkLQJBgQ', -28.3818875, 152.7169882, 'city', '1'),
('countries_australia_new_south_wales_daleys_point', 'ChIJLT-gLZe0cmsRYNgyFmh9AQU', -33.5020757, 151.353482, 'city', '1'),
('countries_australia_new_south_wales_dalgety', 'ChIJTfFe40LpPGsRQN1DkLQJBgQ', -36.5, 148.833333, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_australia_new_south_wales_dalmeny', 'ChIJXWjL88AbPmsR4AhEkLQJBgQ', -36.166667, 150.133333, 'city', '1'),
('countries_australia_new_south_wales_dalswinton', 'ChIJx6Xe4gOFDGsRYIFDkLQJBgQ', -32.430699, 150.7037637, 'city', '1'),
('countries_australia_new_south_wales_dalton', 'ChIJMY3O8DPZFmsRUN1DkLQJBgQ', -34.7436302, 149.2000019, 'city', '1'),
('countries_australia_new_south_wales_dangarsleigh', 'ChIJV5I1Y4uYn2sREK9DkLQJBgQ', -30.6092546, 151.7018464, 'city', '1'),
('countries_australia_new_south_wales_dangar_island', 'ChIJx-PTH9pNDWsRcNgyFmh9AQU', -33.54142, 151.2381, 'city', '1'),
('countries_australia_new_south_wales_dapto', 'ChIJV3ozT5IRE2sRgOIyFmh9AQU', -34.491667, 150.791667, 'city', '1'),
('countries_australia_new_south_wales_darawank', 'ChIJA4-8B0o0dGsRMKBDkLQJBgQ', -32.0884895, 152.4758125, 'city', '1'),
('countries_australia_new_south_wales_darbalara', 'ChIJq6i_myMlGGsR4OdDkLQJBgQ', -35.0612981, 148.247328, 'city', '1'),
('countries_australia_new_south_wales_dareton', 'ChIJEbdp0lr-wmoRoAFEkLQJBgQ', -34.0943674, 142.0400808, 'city', '1'),
('countries_australia_new_south_wales_darkes_forest', 'ChIJvSkuE-LgEmsRAI9DkLQJBgQ', -34.2299689, 150.9084031, 'city', '1'),
('countries_australia_new_south_wales_darlinghurst', 'ChIJ7bV1-XuuEmsR8LMyFmh9AQU', -33.8780176, 151.2204441, 'city', '1'),
('countries_australia_new_south_wales_darlington', 'ChIJpUONmyywEmsRALQyFmh9AQU', -33.890334, 151.19661, 'city', '1'),
('countries_australia_new_south_wales_darlington_point', 'ChIJ0-ZSY0KSH2sRUMpDkLQJBgQ', -34.566667, 146, 'city', '1'),
('countries_australia_new_south_wales_darling_point', 'ChIJB-9rD9-tEmsR4LMyFmh9AQU', -33.87021, 151.23746, 'city', '1'),
('countries_australia_new_south_wales_daruka', 'ChIJ79PjSjmgCmsRwL5DkLQJBgQ', -31.048611, 150.973611, 'city', '1'),
('countries_australia_new_south_wales_darwood', 'ChIJ4VPQ7me9nmsR8JRDkLQJBgQ', -30.4335705, 152.6721415, 'city', '1'),
('countries_australia_new_south_wales_davidson', 'ChIJMWjwzcupEmsRELQyFmh9AQU', -33.73801, 151.19297, 'city', '1'),
('countries_australia_new_south_wales_davistown', 'ChIJYayB0_q0cmsRgNgyFmh9AQU', -33.482, 151.36, 'city', '1'),
('countries_australia_new_south_wales_dawes_point', 'ChIJJbGZ4FyuEmsRILQyFmh9AQU', -33.856, 151.207, 'city', '1'),
('countries_australia_new_south_wales_daysdale', 'ChIJWxVJWHcGIWsRYMpDkLQJBgQ', -35.6028256, 146.3310287, 'city', '1'),
('countries_australia_new_south_wales_dean_park', 'ChIJqS7MsOGbEmsRMLQyFmh9AQU', -33.7333, 150.85, 'city', '1'),
('countries_australia_new_south_wales_deepwater', 'ChIJrV5BnUfkmGsRMK9DkLQJBgQ', -29.445554, 151.8468173, 'city', '1'),
('countries_australia_new_south_wales_dee_why', 'ChIJYe4rTodVDWsRQLQyFmh9AQU', -33.7544, 151.2854, 'city', '1'),
('countries_australia_new_south_wales_delegate', 'ChIJl6bG5698O2sRcN1DkLQJBgQ', -37.0455241, 148.9367503, 'city', '1'),
('countries_australia_new_south_wales_delungra', 'ChIJl_cv86KFoWsR0L5DkLQJBgQ', -29.6196616, 150.8195083, 'city', '1'),
('countries_australia_new_south_wales_denhams_beach', 'ChIJWQoxpTSVFWsRgChEkLQJBgU', -35.7482805, 150.2125224, 'city', '1'),
('countries_australia_new_south_wales_denham_court', 'ChIJSwFYfj_sEmsRULQyFmh9AQU', -33.9844003, 150.8444381, 'city', '1'),
('countries_australia_new_south_wales_deniliquin', 'ChIJrdjFh9ku32oRcMpDkLQJBgQ', -35.5282408, 144.9565781, 'city', '1'),
('countries_australia_new_south_wales_denistone', 'ChIJdQkwTqKlEmsRYLQyFmh9AQU', -33.80085, 151.08648, 'city', '1'),
('countries_australia_new_south_wales_denistone_east', 'ChIJPXSMVcqlEmsRcLQyFmh9AQU', -33.79885, 151.09948, 'city', '1'),
('countries_australia_new_south_wales_denistone_west', 'ChIJz9CObUSkEmsRgLQyFmh9AQU', -33.8007216, 151.0777054, 'city', '1'),
('countries_australia_new_south_wales_denman', 'ChIJOwPRAn-EDGsRoIFDkLQJBgQ', -32.383333, 150.683333, 'city', '1'),
('countries_australia_new_south_wales_dharruk', 'ChIJ8ec6eVWaEmsRkLQyFmh9AQU', -33.74807, 150.8159, 'city', '1'),
('countries_australia_new_south_wales_diamond_beach', 'ChIJg2x1KWvLdWsRcKBDkLQJBgQ', -32.0285584, 152.5355518, 'city', '1'),
('countries_australia_new_south_wales_dignams_creek', 'ChIJqeNoJKhzPmsRMAlEkLQJBgQ', -36.3232773, 149.9746467, 'city', '1'),
('countries_australia_new_south_wales_dilkoon', 'ChIJd3xX5knSm2sRkBhEkLQJBgQ', -29.4894109, 152.9757621, 'city', '1'),
('countries_australia_new_south_wales_dolans_bay', 'ChIJL_KRcc_HEmsRoLQyFmh9AQU', -34.06259, 151.12641, 'city', '1'),
('countries_australia_new_south_wales_dolls_point', 'ChIJb-ah7n63EmsRsLQyFmh9AQU', -33.99386, 151.14301, 'city', '1'),
('countries_australia_new_south_wales_dollys_flat', 'ChIJ5YKsN8qxdWsRoKBDkLQJBgQ', -31.8670424, 152.3209486, 'city', '1'),
('countries_spain_castille_and_leon_villasana_de_mena', 'ChIJKYnSNhcdTw0RruBlN7VvdiQ', 43.0999653, -3.2832818, 'city', '1'),
('countries_australia_new_south_wales_dondingalong', 'ChIJv3Hv-ygLnmsRMJVDkLQJBgQ', -31.1463914, 152.744146, 'city', '1'),
('countries_australia_new_south_wales_donnellyville', 'ChIJ8_3SqH4rnGsRQJVDkLQJBgQ', -30.7543864, 152.9161788, 'city', '1'),
('countries_australia_new_south_wales_doonside', 'ChIJaUv3vZyZEmsRwLQyFmh9AQU', -33.7639837, 150.8696588, 'city', '1'),
('countries_australia_new_south_wales_doon_doon', 'ChIJk4wx6OCSkGsRsPRDkLQJBgQ', -28.4935033, 153.2980471, 'city', '1'),
('countries_australia_new_south_wales_dooralong', 'ChIJhcmzennUcmsRkNgyFmh9AQU', -33.182, 151.351, 'city', '1'),
('countries_australia_new_south_wales_dora_creek', 'ChIJBUFtrSAmc2sRsOsyFmh9AQU', -33.082, 151.501, 'city', '1'),
('countries_australia_new_south_wales_dorrigo', 'ChIJFZ5tcqajnmsRUJVDkLQJBgQ', -30.333333, 152.716667, 'city', '1'),
('countries_australia_new_south_wales_dorroughby', 'ChIJA8Kbde6akGsRwPRDkLQJBgQ', -28.6573257, 153.3594044, 'city', '1'),
('countries_australia_new_south_wales_double_bay', 'ChIJU28AFNytEmsR0LQyFmh9AQU', -33.8775, 151.2412, 'city', '1'),
('countries_australia_new_south_wales_doubtful_creek', 'ChIJneXTKYsAmmsR0PRDkLQJBgQ', -28.6820328, 152.8654361, 'city', '1'),
('countries_australia_new_south_wales_douglas_park', 'ChIJ4ZwgavX7EmsREI9DkLQJBgQ', -34.1884377, 150.7124937, 'city', '1'),
('countries_australia_new_south_wales_dover_heights', 'ChIJ5YYXeAetEmsR4LQyFmh9AQU', -33.87185, 151.27837, 'city', '1'),
('countries_australia_new_south_wales_doyalson', 'ChIJJTxBNH3XcmsRoNgyFmh9AQU', -33.1994745, 151.5227771, 'city', '1'),
('countries_australia_new_south_wales_doyalson_north', 'ChIJ8Y1aLKbZcmsRsNgyFmh9AQU', -33.1863013, 151.5488385, 'city', '1'),
('countries_australia_new_south_wales_doyles_creek', 'ChIJ-1KLo9XsDGsRwIFDkLQJBgQ', -32.5072568, 150.815492, 'city', '1'),
('countries_australia_new_south_wales_drummoyne', 'ChIJYduzn5KvEmsR8LQyFmh9AQU', -33.8510541, 151.1545209, 'city', '1'),
('countries_australia_new_south_wales_dry_plain', 'ChIJU4xc7fwRPWsRoBJEkLQJBgQ', -36.1069909, 148.9234838, 'city', '1'),
('countries_australia_new_south_wales_dubbo', 'ChIJO5GkTLBxD2sRMCVEkLQJBgU', -32.2443908, 148.614418, 'city', '1'),
('countries_australia_new_south_wales_dudley', 'ChIJB72p-soXc2sR0OsyFmh9AQU', -32.9882621, 151.7152682, 'city', '1'),
('countries_australia_new_south_wales_duffys_forest', 'ChIJtcDmgv5WDWsRALUyFmh9AQU', -33.6768193, 151.1844804, 'city', '1'),
('countries_australia_new_south_wales_dulwich_hill', 'ChIJGZSg9Zm6EmsRELUyFmh9AQU', -33.9033268, 151.1424436, 'city', '1'),
('countries_australia_new_south_wales_dunbogan', 'ChIJx3IfUfvidWsRwKBDkLQJBgQ', -31.6681603, 152.8047554, 'city', '1'),
('countries_australia_new_south_wales_duncans_creek', 'ChIJfZau-_m2CmsR8L5DkLQJBgQ', -31.3757267, 151.1927594, 'city', '1'),
('countries_australia_new_south_wales_dundas', 'ChIJw4_Ho4GjEmsRILUyFmh9AQU', -33.7991604, 151.0453821, 'city', '1'),
('countries_australia_new_south_wales_dundas_valley', 'ChIJy8dQsnOkEmsRMLUyFmh9AQU', -33.7926665, 151.0565565, 'city', '1'),
('countries_australia_new_south_wales_dundee', 'ChIJb8gxE2ndmGsRoK9DkLQJBgQ', -29.5562152, 151.8387235, 'city', '1'),
('countries_australia_new_south_wales_dunedoo', 'ChIJ1-CN9DfJDmsRcHlDkLQJBgQ', -32.0163115, 149.4006204, 'city', '1'),
('countries_australia_new_south_wales_dungog', 'ChIJ8yBhbK-ZdGsR4IFDkLQJBgQ', -32.3998381, 151.757979, 'city', '1'),
('countries_australia_new_south_wales_dungowan', 'ChIJOctzCc6vCmsRAL9DkLQJBgQ', -31.2146207, 151.1198688, 'city', '1'),
('countries_australia_new_south_wales_dunmore', 'ChIJZ_mv7tpsE2sRoOIyFmh9AQU', -34.6159663, 150.8352746, 'city', '1'),
('countries_australia_new_south_wales_dunoon', 'ChIJXbayum6akGsRIPVDkLQJBgQ', -28.6916531, 153.3127685, 'city', '1'),
('countries_australia_new_south_wales_duns_creek', 'ChIJJeEUYjxdc2sR8IFDkLQJBgQ', -32.6327469, 151.6249609, 'city', '1'),
('countries_australia_new_south_wales_dural', 'ChIJL534AsegEmsRQLUyFmh9AQU', -33.695986, 151.030291, 'city', '1'),
('countries_australia_new_south_wales_duranbah', 'ChIJUWERnfD5kGsRkC9EkLQJBgU', -28.3020609, 153.5199439, 'city', '1'),
('countries_australia_new_south_wales_duri', 'ChIJqZ8jg9GTCmsREL9DkLQJBgQ', -31.2184858, 150.8180218, 'city', '1'),
('countries_australia_new_south_wales_durran_durra', 'ChIJ4W4XxmwqFGsRYAlEkLQJBgQ', -35.3482, 149.8655546, 'city', '1'),
('countries_australia_new_south_wales_dyers_crossing', 'ChIJjx74535NdGsR0KBDkLQJBgQ', -32.0852303, 152.3224134, 'city', '1'),
('countries_australia_new_south_wales_dyraaba', 'ChIJB3nvPG0BmmsRMPVDkLQJBgQ', -28.7638011, 152.8637336, 'city', '1'),
('countries_australia_new_south_wales_dyrring', 'ChIJJwNtRTSsDGsREIJDkLQJBgQ', -32.490225, 151.2339243, 'city', '1'),
('countries_australia_new_south_wales_eagle_vale', 'ChIJuSepFn3uEmsRULUyFmh9AQU', -34.0386678, 150.8131919, 'city', '1'),
('countries_australia_new_south_wales_earlwood', 'ChIJt8Vzg3G6EmsRYLUyFmh9AQU', -33.9241073, 151.1255927, 'city', '1'),
('countries_australia_new_south_wales_eastgardens', 'ChIJR486tGSxEmsR4EIzFmh9AQU', -33.946, 151.225, 'city', '1'),
('countries_australia_new_south_wales_eastlakes', 'ChIJbcQ4yKexEmsRwLUyFmh9AQU', -33.9272474, 151.2106299, 'city', '1'),
('countries_australia_new_south_wales_eastwood', 'ChIJM2hb8aSlEmsR0LUyFmh9AQU', -33.790362, 151.081731, 'city', '1'),
('countries_australia_new_south_wales_east_ballina', 'ChIJtUWT5AyAkGsR0CtEkLQJBgU', -28.8444006, 153.5986426, 'city', '1'),
('countries_australia_new_south_wales_east_branxton', 'ChIJ64dS9PxMc2sRQDgzFmh9AQU', -32.6565214, 151.3614567, 'city', '1'),
('countries_australia_new_south_wales_east_corrimal', 'ChIJ2S79PykfE2sRIEUzFmh9AQU', -34.3760641, 150.9088467, 'city', '1'),
('countries_australia_new_south_wales_east_gosford', 'ChIJG4yMemm1cmsR0NgyFmh9AQU', -33.4365164, 151.349346, 'city', '1'),
('countries_australia_new_south_wales_east_gresford', 'ChIJAZNZsYCmdGsRMIJDkLQJBgQ', -32.4298609, 151.5526668, 'city', '1'),
('countries_spain_castille_and_leon_toro', 'ChIJibCiKyvAOA0RsLD1WgeHBQQ', 41.4540325, -5.4149003, 'city', '0'),
('countries_australia_new_south_wales_east_hills', 'ChIJ9egJwrG_EmsRcLUyFmh9AQU', -33.9619752, 150.9837433, 'city', '1'),
('countries_australia_new_south_wales_east_kangaloon', 'ChIJX4XUHx2gE2sRII9DkLQJBgQ', -34.558147, 150.5787667, 'city', '1'),
('countries_australia_new_south_wales_east_killara', 'ChIJd67szlWoEmsRgLUyFmh9AQU', -33.7537483, 151.1765605, 'city', '1'),
('countries_australia_new_south_wales_east_kurrajong', 'ChIJq4Pna8VkDWsRUDkzFmh9AQU', -33.5142611, 150.7635556, 'city', '1'),
('countries_australia_new_south_wales_east_lindfield', 'ChIJh1hOPgKpEmsRkLUyFmh9AQU', -33.7676919, 151.185323, 'city', '1'),
('countries_australia_new_south_wales_east_lismore', 'ChIJtTDvreR1mmsRECtEkLQJBgU', -28.8217783, 153.2939132, 'city', '1'),
('countries_australia_new_south_wales_east_lynne', 'ChIJUZigIde5FWsRgAlEkLQJBgQ', -35.5613633, 150.2756628, 'city', '1'),
('countries_australia_new_south_wales_east_ryde', 'ChIJY00mNEevEmsRoLUyFmh9AQU', -33.8141303, 151.140167, 'city', '1'),
('countries_australia_new_south_wales_east_seaham', 'ChIJ30_Yo71nc2sRQIJDkLQJBgQ', -32.6413858, 151.7460842, 'city', '1'),
('countries_australia_new_south_wales_east_wagga_wagga', 'ChIJAcXSL7ebGGsRsCVEkLQJBgU', -35.1222395, 147.3918728, 'city', '1'),
('countries_australia_new_south_wales_ebenezer', 'ChIJ-XskQF9mDWsRwDkzFmh9AQU', -33.5318, 150.8679, 'city', '1'),
('countries_australia_new_south_wales_eden', 'ChIJl0geDnenPmsRkAlEkLQJBgQ', -37.066667, 149.9, 'city', '1'),
('countries_australia_new_south_wales_edensor_park', 'ChIJMTBefl-REmsR4LUyFmh9AQU', -33.88095, 150.87516, 'city', '1'),
('countries_australia_new_south_wales_eden_creek', 'ChIJ9SxvLCCukGsRUPVDkLQJBgQ', -28.5878941, 152.9036758, 'city', '1'),
('countries_australia_new_south_wales_edgecliff', 'ChIJEe5Lzw6uEmsR8LUyFmh9AQU', -33.8799875, 151.2357452, 'city', '1'),
('countries_australia_new_south_wales_edgeroi', 'ChIJ37A1devVpmsRILpDkLQJBgQ', -30.1086451, 149.791644, 'city', '1'),
('countries_australia_new_south_wales_edgeworth', 'ChIJ3-lua-c7c2sR8OsyFmh9AQU', -32.924698, 151.6216653, 'city', '1'),
('countries_australia_new_south_wales_edith', 'ChIJqQyIVpghEmsRAGFDkLQJBgQ', -33.7963393, 149.913979, 'city', '1'),
('countries_australia_new_south_wales_edmondson_park', 'ChIJI_KeoKnsEmsRALYyFmh9AQU', -33.9606778, 150.8622496, 'city', '1'),
('countries_australia_new_south_wales_eglinton', 'ChIJcUlmxFXhEWsRcCJEkLQJBgU', -33.3725033, 149.5403994, 'city', '1'),
('countries_australia_new_south_wales_elands', 'ChIJAQqwW5OTdWsR4KBDkLQJBgQ', -31.6273607, 152.3049638, 'city', '1'),
('countries_australia_new_south_wales_elanora_heights', 'ChIJge6rpn5WDWsRELYyFmh9AQU', -33.70102, 151.2789, 'city', '1'),
('countries_australia_new_south_wales_elcombe', 'ChIJ4YCSXC9toWsRIL9DkLQJBgQ', -29.8655735, 150.3329625, 'city', '1'),
('countries_australia_new_south_wales_elderslie', 'ChIJx7WZmdTwEmsRILYyFmh9AQU', -34.05462, 150.7125, 'city', '1'),
('countries_australia_new_south_wales_eleebana', 'ChIJa5c5iWA7c2sRAOwyFmh9AQU', -32.996, 151.635, 'city', '1'),
('countries_australia_new_south_wales_elermore_vale', 'ChIJT08rvmY-c2sREOwyFmh9AQU', -32.915, 151.668, 'city', '1'),
('countries_australia_new_south_wales_elizabeth_bay', 'ChIJh0ghm3SuEmsRMLYyFmh9AQU', -33.87143, 151.22841, 'city', '1'),
('countries_australia_new_south_wales_elizabeth_beach', 'ChIJNzHE25s-dGsR8KBDkLQJBgQ', -32.3315882, 152.53702, 'city', '1'),
('countries_australia_new_south_wales_elizabeth_hills', 'ChIJwZnaKpOTEmsRz4mY0vHqpiE', -33.9000666, 150.8478522, 'city', '1'),
('countries_australia_new_south_wales_ellalong', 'ChIJ9-4VzoPSDGsRwNEyFmh9AQU', -32.907222, 151.321389, 'city', '1'),
('countries_australia_new_south_wales_ellangowan', 'ChIJ7wfv4cURmmsR8BhEkLQJBgQ', -29.0358122, 153.0731729, 'city', '1'),
('countries_australia_new_south_wales_ellerston', 'ChIJiwMqHVXVdGsRgIJDkLQJBgQ', -31.7948372, 151.3490918, 'city', '1'),
('countries_australia_new_south_wales_ellis_lane', 'ChIJb0PPikvxEmsREDwzFmh9AQU', -34.034, 150.675, 'city', '1'),
('countries_australia_new_south_wales_elrington', 'ChIJwyEBUPY2c2sRMOwyFmh9AQU', -32.8778566, 151.4296856, 'city', '1'),
('countries_australia_new_south_wales_elsmore', 'ChIJCfSjHAj-oWsR4K9DkLQJBgQ', -29.8133651, 151.2605215, 'city', '1'),
('countries_australia_new_south_wales_eltham', 'ChIJEZhJFqWckGsRcPVDkLQJBgQ', -28.7624423, 153.4095259, 'city', '1'),
('countries_australia_new_south_wales_emerald_beach', 'ChIJY0N2vdoLnGsRgJVDkLQJBgQ', -30.1574794, 153.1501948, 'city', '1'),
('countries_australia_new_south_wales_emerton', 'ChIJE8N1WAKbEmsRULYyFmh9AQU', -33.75, 150.8027, 'city', '1'),
('countries_australia_new_south_wales_emmaville', 'ChIJJx4V86SRmGsR8K9DkLQJBgQ', -29.3717793, 151.6114403, 'city', '1'),
('countries_australia_new_south_wales_empire_bay', 'ChIJnfT56Iu0cmsR4NgyFmh9AQU', -33.49, 151.36, 'city', '1'),
('countries_australia_new_south_wales_emu_heights', 'ChIJwypOBz2GEmsRgNQyFmh9AQU', -33.73521, 150.6503, 'city', '1'),
('countries_australia_new_south_wales_emu_plains', 'ChIJ-QhNcIuFEmsRkNQyFmh9AQU', -33.75206, 150.65967, 'city', '1'),
('countries_australia_new_south_wales_emu_swamp', 'ChIJe2xetl3SEWsREGFDkLQJBgQ', -33.3153499, 149.1737949, 'city', '1'),
('countries_australia_new_south_wales_engadine', 'ChIJx4sTLBHBEmsRcLYyFmh9AQU', -34.065722, 151.012664, 'city', '1'),
('countries_australia_new_south_wales_englorie_park', 'ChIJDUIpi7nvEmsRYEMzFmh9AQU', -34.0806577, 150.7948026, 'city', '1'),
('countries_australia_new_south_wales_enmore', 'ChIJyaoPaziwEmsRgLYyFmh9AQU', -33.90067, 151.16768, 'city', '1'),
('countries_australia_new_south_wales_epping', 'ChIJ80KirMKjEmsRkLYyFmh9AQU', -33.7746, 151.0788, 'city', '1'),
('countries_australia_new_south_wales_eraring', 'ChIJI9pCH-Ylc2sRQOwyFmh9AQU', -33.065, 151.518, 'city', '1'),
('countries_australia_new_south_wales_erina', 'ChIJpYocO4m1cmsR8NgyFmh9AQU', -33.4338169, 151.3900807, 'city', '1'),
('countries_australia_new_south_wales_erina_heights', 'ChIJV1dIkRjKcmsRANkyFmh9AQU', -33.4266283, 151.4133145, 'city', '1'),
('countries_australia_new_south_wales_ermington', 'ChIJoYARe2KkEmsRoLYyFmh9AQU', -33.8143301, 151.0562386, 'city', '1'),
('countries_australia_new_south_wales_erowal_bay', 'ChIJPy0k6oGIFGsRYNZDkLQJBgQ', -35.1002948, 150.6540546, 'city', '1'),
('countries_australia_new_south_wales_erskineville', 'ChIJf0tfNzWwEmsRwLYyFmh9AQU', -33.8998061, 151.1848934, 'city', '1'),
('countries_australia_new_south_wales_erskine_park', 'ChIJl-jcHmCQEmsRsLYyFmh9AQU', -33.8038535, 150.805564, 'city', '1'),
('countries_australia_new_south_wales_erudgere', 'ChIJCe1HFwyLDmsRMGFDkLQJBgQ', -32.5818423, 149.4926226, 'city', '1'),
('countries_australia_new_south_wales_eschol_park', 'ChIJyw4Tg3fuEmsR0LYyFmh9AQU', -34.0304257, 150.8090824, 'city', '1'),
('countries_australia_new_south_wales_estella', 'ChIJpYzU3OaZGGsRwCVEkLQJBgU', -35.0747427, 147.3545244, 'city', '1'),
('countries_australia_new_south_wales_ettalong', 'ChIJn0pUS1GzcmsRENkyFmh9AQU', -33.5138852, 151.3370286, 'city', '1'),
('countries_australia_new_south_wales_euabalong_west', 'ChIJo-nYpzxYHGsRwAJEkLQJBgQ', -33.0557039, 146.3937348, 'city', '1'),
('countries_australia_new_south_wales_euberta', 'ChIJD1RzzmakGGsRsMpDkLQJBgQ', -35.0539801, 147.2107463, 'city', '1'),
('countries_australia_new_south_wales_euchareena', 'ChIJLzesgDozDmsRUGFDkLQJBgQ', -32.9413906, 149.0958988, 'city', '1'),
('countries_spain_castille_and_leon_sanchidrian', 'ChIJz-AJocTCQA0RSqKAJqV_zgg', 40.89773, -4.5934, 'city', '0'),
('countries_australia_new_south_wales_eugowra', 'ChIJSe-BaGydGmsRoHlDkLQJBgQ', -33.4271672, 148.3714859, 'city', '1'),
('countries_australia_new_south_wales_eumungerie', 'ChIJW3qV-i5BD2sRAHJDkLQJBgQ', -31.949695, 148.6196559, 'city', '1'),
('countries_australia_new_south_wales_eungella', 'ChIJ1TT0dN_ukGsRoPVDkLQJBgQ', -28.3541532, 153.3046998, 'city', '1'),
('countries_australia_new_south_wales_eureka', 'ChIJgxHLl3aFkGsRsPVDkLQJBgQ', -28.6820352, 153.4385516, 'city', '1'),
('countries_australia_new_south_wales_euroka', 'ChIJ22YBLwV1nmsR0C1EkLQJBgU', -31.0758727, 152.7973248, 'city', '1'),
('countries_australia_new_south_wales_eurunderee', 'ChIJ0QDwkDiODmsRYGFDkLQJBgQ', -32.5283224, 149.6084419, 'city', '1'),
('countries_australia_new_south_wales_euston', 'ChIJqZ9XySgo3WoR0AJEkLQJBgQ', -34.57501, 142.7450684, 'city', '1'),
('countries_australia_new_south_wales_evans_head', 'ChIJeaQzgd9lmmsREBlEkLQJBgQ', -29.1188889, 153.4315059, 'city', '1'),
('countries_australia_new_south_wales_evans_plains', 'ChIJzb5mbfznEWsRgCJEkLQJBgU', -33.4370637, 149.5053313, 'city', '1'),
('countries_australia_new_south_wales_eveleigh', 'ChIJXY0B_c2xEmsR4LYyFmh9AQU', -33.8963418, 151.1950014, 'city', '1'),
('countries_australia_new_south_wales_ewingar', 'ChIJHbRJ9nyWmWsRELBDkLQJBgQ', -29.0684521, 152.5434125, 'city', '1'),
('countries_australia_new_south_wales_ewingsdale', 'ChIJ-wUvVIGBkGsRwPVDkLQJBgQ', -28.636686, 153.5551531, 'city', '1'),
('countries_australia_new_south_wales_exeter', 'ChIJI9yG04-NE2sRMI9DkLQJBgQ', -34.613147, 150.3170636, 'city', '1'),
('countries_australia_new_south_wales_failford', 'ChIJ_7Z4wLpOdGsREKFDkLQJBgQ', -32.0918609, 152.447207, 'city', '1'),
('countries_australia_new_south_wales_fairfield', 'ChIJvZzj19yXEmsR8LYyFmh9AQU', -33.8705856, 150.9564102, 'city', '1'),
('countries_australia_new_south_wales_fairfield_east', 'ChIJ431ELZm9EmsRALcyFmh9AQU', -33.8761377, 150.9708095, 'city', '1'),
('countries_australia_new_south_wales_fairfield_heights', 'ChIJI2ph8TGWEmsRELcyFmh9AQU', -33.8635246, 150.9386649, 'city', '1'),
('countries_australia_new_south_wales_fairfield_west', 'ChIJKYkUZAeXEmsRILcyFmh9AQU', -33.8689636, 150.9220906, 'city', '1'),
('countries_australia_new_south_wales_fairlight', 'ChIJHUdDMLCrEmsRMLcyFmh9AQU', -33.795921, 151.2764518, 'city', '1'),
('countries_australia_new_south_wales_fairy_hill', 'ChIJs4Ku6oYHmmsR0PVDkLQJBgQ', -28.7628733, 152.9868392, 'city', '1'),
('countries_australia_new_south_wales_fairy_meadow', 'ChIJeSgVHMUeE2sRwOIyFmh9AQU', -34.3940312, 150.8929307, 'city', '1'),
('countries_australia_new_south_wales_falls_creek', 'ChIJ6-f9PfuHFGsRgNZDkLQJBgQ', -34.9919008, 150.5852874, 'city', '1'),
('countries_australia_new_south_wales_farmborough_heights', 'ChIJxQWKD4oQE2sR0OIyFmh9AQU', -34.4554481, 150.8199607, 'city', '1'),
('countries_australia_new_south_wales_farmeadow', 'ChIJLWVtc195E2sRCMw_8IUG6-k', -34.8334014, 150.7010293, 'city', '1'),
('countries_australia_new_south_wales_farrants_hill', 'ChIJTYlk_R_6kGsR4PVDkLQJBgQ', -28.3158144, 153.4889845, 'city', '1'),
('countries_australia_new_south_wales_fassifern', 'ChIJYasGBzo7c2sRcOwyFmh9AQU', -32.9845157, 151.5838417, 'city', '1'),
('countries_australia_new_south_wales_faulconbridge', 'ChIJcRpHkg59EmsRoNQyFmh9AQU', -33.693501, 150.5473195, 'city', '1'),
('countries_australia_new_south_wales_faulkland', 'ChIJA7JoAu_6dGsRIKFDkLQJBgQ', -32.0523756, 151.9141289, 'city', '1'),
('countries_australia_new_south_wales_federal', 'ChIJrbX6A6iPkGsRAPZDkLQJBgQ', -28.6525255, 153.4561498, 'city', '1'),
('countries_australia_new_south_wales_fennell_bay', 'ChIJe1KtPls7c2sRgOwyFmh9AQU', -32.992121, 151.6001733, 'city', '1'),
('countries_australia_new_south_wales_fernbank_creek', 'ChIJ23OPHyQAdmsRMKFDkLQJBgQ', -31.4163367, 152.8498513, 'city', '1'),
('countries_australia_new_south_wales_fernleigh', 'ChIJERnt6kyBkGsREPZDkLQJBgQ', -28.7653087, 153.4977614, 'city', '1'),
('countries_australia_new_south_wales_fernmount', 'ChIJuXNlzn4inGsRwJVDkLQJBgQ', -30.4704911, 152.9403301, 'city', '1'),
('countries_australia_new_south_wales_fern_bay', 'ChIJ3z65QZZsc2sRkOwyFmh9AQU', -32.8614844, 151.8135809, 'city', '1'),
('countries_australia_new_south_wales_ferodale', 'ChIJld3eWBhvc2sRUDgzFmh9AQU', -32.7058986, 151.8373107, 'city', '1'),
('countries_australia_new_south_wales_fiddletown', 'ChIJw1o-yxxbDWsRQLcyFmh9AQU', -33.6019605, 151.0533526, 'city', '1'),
('countries_australia_new_south_wales_figtree', 'ChIJ0Qui5hkaE2sR8OIyFmh9AQU', -34.4357271, 150.8612708, 'city', '1'),
('countries_australia_new_south_wales_fingal_bay', 'ChIJeRzs346Dc2sRsOwyFmh9AQU', -32.7497997, 152.1687988, 'city', '1'),
('countries_australia_new_south_wales_fingal_head', 'ChIJw-Wa5Or_kGsRwC9EkLQJBgU', -28.2008861, 153.5658875, 'city', '1'),
('countries_australia_new_south_wales_finley', 'ChIJka_RnDNe32oR4MpDkLQJBgQ', -35.6417544, 145.5777193, 'city', '1'),
('countries_australia_new_south_wales_firefly', 'ChIJ2YUVFZxRdGsRQKFDkLQJBgQ', -32.0823189, 152.2498221, 'city', '1'),
('countries_australia_new_south_wales_fishermans_bay', 'ChIJEcMJ37WCc2sRwOwyFmh9AQU', -32.7884132, 152.0904199, 'city', '1'),
('countries_australia_new_south_wales_fishermans_paradise', 'ChIJ9we3omRcFGsRkNZDkLQJBgQ', -35.2297216, 150.4486759, 'city', '1'),
('countries_australia_new_south_wales_fishing_point', 'ChIJUWjCF24kc2sR0OwyFmh9AQU', -33.0504524, 151.5941333, 'city', '1'),
('countries_australia_new_south_wales_fitzroy_falls', 'ChIJ9_E2SeyaE2sRQI9DkLQJBgQ', -34.6470356, 150.4823825, 'city', '1'),
('countries_australia_new_south_wales_five_dock', 'ChIJ8ydvwkylEmsRYLcyFmh9AQU', -33.8692538, 151.1295659, 'city', '1'),
('countries_australia_new_south_wales_flat_tops', 'ChIJVXl2AtObdGsR0IJDkLQJBgQ', -32.4575367, 151.8114257, 'city', '1'),
('countries_australia_new_south_wales_fletcher', 'ChIJjfr7whE_c2sR4OwyFmh9AQU', -32.8778054, 151.6466235, 'city', '1'),
('countries_australia_new_south_wales_flinders', 'ChIJz6MeOm4TE2sRAOMyFmh9AQU', -34.5772645, 150.8421332, 'city', '1'),
('countries_australia_new_south_wales_floraville', 'ChIJ13gbSSw9c2sR8OwyFmh9AQU', -33.0111461, 151.6650065, 'city', '1'),
('countries_australia_new_south_wales_forbes', 'ChIJb4IvPOSMGmsR0HlDkLQJBgQ', -33.3844596, 148.0080975, 'city', '1'),
('countries_australia_new_south_wales_fordwich', 'ChIJZ6r-_qq5DGsR4IJDkLQJBgQ', -32.7092632, 151.0486774, 'city', '1'),
('countries_australia_new_south_wales_forestville', 'ChIJcbTYVp-pEmsRkLcyFmh9AQU', -33.7609165, 151.2166775, 'city', '1'),
('countries_australia_new_south_wales_forest_glen', 'ChIJa-1GLPdcDWsRcLcyFmh9AQU', -33.5484531, 151.0131585, 'city', '1'),
('countries_australia_new_south_wales_forest_hill', 'ChIJRVrJOsqEGGsRYOhDkLQJBgQ', -35.1527313, 147.4567069, 'city', '1'),
('countries_australia_new_south_wales_forest_lodge', 'ChIJVSTgE9avEmsRgLcyFmh9AQU', -33.884913, 151.1823154, 'city', '1'),
('countries_australia_new_south_wales_forest_reefs', 'ChIJd64GRS81EGsRsGFDkLQJBgQ', -33.454818, 149.0862335, 'city', '1'),
('countries_australia_new_south_wales_forresters_beach', 'ChIJkbVdFxzJcmsRMNkyFmh9AQU', -33.4057691, 151.4650238, 'city', '1'),
('countries_australia_new_south_wales_forster', 'ChIJmZN-nuA5dGsRcKFDkLQJBgQ', -32.1795722, 152.5117641, 'city', '1'),
('countries_australia_new_south_wales_fountaindale', 'ChIJ4bjbkRPMcmsRQNkyFmh9AQU', -33.3353173, 151.4039364, 'city', '1'),
('countries_australia_new_south_wales_foxground', 'ChIJ-YvzkGN6E2sRYrHhEizybW8', -34.717354, 150.770648, 'city', '1'),
('countries_australia_new_south_wales_frazers_creek', 'ChIJFVJxSb_3dWsRgKFDkLQJBgQ', -31.4211041, 152.6672193, 'city', '1'),
('countries_australia_new_south_wales_frederickton', 'ChIJGfQ_k8rZnWsR4JVDkLQJBgQ', -31.0368644, 152.8712598, 'city', '1'),
('countries_australia_new_south_wales_freemans_reach', 'ChIJlca8wBljDWsRoDkzFmh9AQU', -33.5592741, 150.8030855, 'city', '1'),
('countries_australia_new_south_wales_frenchs_forest', 'ChIJRa28VoupEmsRoLcyFmh9AQU', -33.7512632, 151.2440201, 'city', '1'),
('countries_australia_new_south_wales_french_park', 'ChIJtQ1qHicDImsRAMtDkLQJBgQ', -35.2671706, 146.926257, 'city', '1'),
('countries_australia_new_south_wales_freshwater', 'ChIJc5bZqU-qEmsRoLkyFmh9AQU', -33.7787729, 151.2834818, 'city', '1'),
('countries_australia_new_south_wales_fullerton_cove', 'ChIJHcr6xlpsc2sREO0yFmh9AQU', -32.8423461, 151.8265901, 'city', '1'),
('countries_australia_new_south_wales_galambine', 'ChIJE2erZ4-NDmsRAGJDkLQJBgQ', -32.4419086, 149.5181159, 'city', '1'),
('countries_australia_new_south_wales_galong', 'ChIJNWMmdoxcF2sRgOhDkLQJBgQ', -34.6016262, 148.5567348, 'city', '1'),
('countries_australia_new_south_wales_galston', 'ChIJHShyFyVfDWsRsLcyFmh9AQU', -33.6532375, 151.0471145, 'city', '1'),
('countries_australia_new_south_wales_ganbenang', 'ChIJJYBT_5sWEmsREGJDkLQJBgQ', -33.7087572, 150.1426996, 'city', '1'),
('countries_australia_new_south_wales_ganmain', 'ChIJFzoZltG3GGsRMMtDkLQJBgQ', -34.7921797, 147.0393186, 'city', '1'),
('countries_australia_new_south_wales_garah', 'ChIJl4-wCiFypGsRMLpDkLQJBgQ', -29.0739131, 149.6353746, 'city', '1'),
('countries_australia_new_south_wales_garden_suburb', 'ChIJnzW14-c9c2sRIO0yFmh9AQU', -32.9471851, 151.6833344, 'city', '1'),
('countries_australia_new_south_wales_garema', 'ChIJdz5EzQ9cGmsR8HlDkLQJBgQ', -33.5522948, 147.9371661, 'city', '1'),
('countries_australia_new_south_wales_gateshead', 'ChIJv7qFC309c2sRMO0yFmh9AQU', -32.989296, 151.6956677, 'city', '1'),
('countries_australia_new_south_wales_gemalla', 'ChIJVY_TwX4CEmsRMGJDkLQJBgQ', -33.5239939, 149.8362984, 'city', '1'),
('countries_australia_new_south_wales_geneva', 'ChIJry_N0RivkGsRUPZDkLQJBgQ', -28.6185975, 152.9848696, 'city', '1'),
('countries_australia_new_south_wales_georges_hall', 'ChIJset4hNC9EmsRwLcyFmh9AQU', -33.9128712, 150.9824038, 'city', '1'),
('countries_australia_new_south_wales_georges_plains', 'ChIJJ-Bxfr_pEWsRQGJDkLQJBgQ', -33.5160183, 149.5221767, 'city', '1'),
('countries_australia_new_south_wales_georgetown', 'ChIJ3QtcTbsVc2sRQO0yFmh9AQU', -32.908696, 151.7300843, 'city', '1'),
('countries_australia_new_south_wales_georgica', 'ChIJ9_hWQDujkGsRYPZDkLQJBgQ', -28.6577914, 153.1747106, 'city', '1'),
('countries_australia_new_south_wales_gerringong', 'ChIJ-yA2r0hwE2sREOMyFmh9AQU', -34.747239, 150.8271944, 'city', '1'),
('countries_australia_new_south_wales_gerroa', 'ChIJZcKARKBvE2sRIOMyFmh9AQU', -34.7699, 150.813133, 'city', '1'),
('countries_australia_new_south_wales_geurie', 'ChIJx1YFvHQJD2sREHpDkLQJBgQ', -32.3903521, 148.8272978, 'city', '1'),
('countries_australia_new_south_wales_giants_creek', 'ChIJYUljqM-AC2sREINDkLQJBgQ', -32.2334765, 150.51896, 'city', '1'),
('countries_australia_new_south_wales_gilead', 'ChIJpdNQyqXvEmsR4LcyFmh9AQU', -34.1410068, 150.7923904, 'city', '1'),
('countries_australia_new_south_wales_gilgai', 'ChIJp8A19v3voWsRcLBDkLQJBgQ', -29.85, 151.12, 'city', '1'),
('countries_australia_new_south_wales_gilgandra', 'ChIJrVPyegWyCGsRQHJDkLQJBgQ', -31.6952312, 148.6558441, 'city', '1'),
('countries_australia_new_south_wales_gillieston_heights', 'ChIJC-6V_xFIc2sRUO0yFmh9AQU', -32.765, 151.534444, 'city', '1'),
('countries_australia_new_south_wales_gilmore', 'ChIJ9QBDh2sPGGsR0OhDkLQJBgQ', -35.420992, 148.1771902, 'city', '1'),
('countries_australia_new_south_wales_gin_gin', 'ChIJA-3FtV6UBWsRYHJDkLQJBgQ', -31.9120084, 148.0886021, 'city', '1'),
('countries_australia_new_south_wales_girards_hill', 'ChIJ0XZ2xvV1mmsRICtEkLQJBgU', -28.8169723, 153.2783491, 'city', '1'),
('countries_australia_new_south_wales_girralong', 'ChIJQSrfywCQnmsR8JVDkLQJBgQ', -30.5764816, 152.6648057, 'city', '1'),
('countries_australia_new_south_wales_girraween', 'ChIJPzsPx3KYEmsR8LcyFmh9AQU', -33.80128, 150.94305, 'city', '1'),
('countries_australia_new_south_wales_gladesville', 'ChIJ6QBFt3elEmsRALgyFmh9AQU', -33.8301698, 151.1267591, 'city', '1'),
('countries_australia_new_south_wales_gladstone', 'ChIJ6bbSqmDanWsRAJZDkLQJBgQ', -31.0175428, 152.9588416, 'city', '1'),
('countries_australia_new_south_wales_glanmire', 'ChIJ7cRwIfD7EWsRgGJDkLQJBgQ', -33.4067425, 149.7139792, 'city', '1'),
('countries_australia_new_south_wales_glebe', 'ChIJZaTbWNOvEmsRELgyFmh9AQU', -33.8797767, 151.1869715, 'city', '1'),
('countries_australia_new_south_wales_gledswood_hills', 'ChIJo_su9XbyEmsRX07y8wvFQV0', -34.011667, 150.780278, 'city', '1'),
('countries_australia_new_south_wales_glenbawn', 'ChIJv9vJ2AdAC2sRYINDkLQJBgQ', -32.122042, 150.9602927, 'city', '1'),
('countries_australia_new_south_wales_glenbrook', 'ChIJVXe9J2R5EmsRsNQyFmh9AQU', -33.766667, 150.619444, 'city', '1'),
('countries_australia_new_south_wales_glencoe', 'ChIJsfyCIBE2n2sRsLBDkLQJBgQ', -29.9158628, 151.7272385, 'city', '1'),
('countries_australia_new_south_wales_glendale', 'ChIJk89Vbvo7c2sRYO0yFmh9AQU', -32.9267174, 151.6508831, 'city', '1'),
('countries_australia_new_south_wales_glendenning', 'ChIJefJO_XuZEmsRMLgyFmh9AQU', -33.7461349, 150.8536426, 'city', '1'),
('countries_australia_new_south_wales_glendon_brook', 'ChIJZbqHmTBUc2sRgINDkLQJBgQ', -32.4972193, 151.4070715, 'city', '1'),
('countries_australia_new_south_wales_glenfield', 'ChIJJccuqjTrEmsRQLgyFmh9AQU', -33.9748797, 150.8992441, 'city', '1'),
('countries_australia_new_south_wales_glenfield_park', 'ChIJNUGOqVqeGGsR4CVEkLQJBgU', -35.136128, 147.332078, 'city', '1'),
('countries_australia_new_south_wales_glenhaven', 'ChIJbfnsXMmgEmsRULgyFmh9AQU', -33.70547, 151.00334, 'city', '1'),
('countries_australia_new_south_wales_gleniffer', 'ChIJfVCMcgkcnGsREJZDkLQJBgQ', -30.3709531, 152.8852905, 'city', '1'),
('countries_australia_new_south_wales_glenmore_park', 'ChIJj9NA7iuPEmsRYLgyFmh9AQU', -33.79, 150.676, 'city', '1'),
('countries_australia_new_south_wales_glenning_valley', 'ChIJR_wEdaHOcmsRcNkyFmh9AQU', -33.348, 151.418, 'city', '1'),
('countries_australia_new_south_wales_glenorie', 'ChIJ23xOL9tdDWsRcLgyFmh9AQU', -33.60224, 151.00247, 'city', '1'),
('countries_australia_new_south_wales_glenreagh', 'ChIJu527zo34m2sRIJZDkLQJBgQ', -30.05, 152.983333, 'city', '1'),
('countries_australia_new_south_wales_glenroy', 'ChIJWTfFCZhfIWsRICdEkLQJBgU', -36.054, 146.915, 'city', '1'),
('countries_australia_new_south_wales_glenthorne', 'ChIJQ_vE51zIdWsRkC5EkLQJBgU', -31.9255865, 152.476833, 'city', '1'),
('countries_australia_new_south_wales_glenwood', 'ChIJm0FPSkufEmsRgLgyFmh9AQU', -33.7398598, 150.9385702, 'city', '1'),
('countries_australia_new_south_wales_glen_alice', 'ChIJSa0lNi_BDWsRkGJDkLQJBgQ', -33.0323072, 150.1893053, 'city', '1'),
('countries_australia_new_south_wales_glen_alpine', 'ChIJ34JYuvvvEmsRILgyFmh9AQU', -34.09, 150.785, 'city', '1'),
('countries_australia_new_south_wales_glen_davis', 'ChIJ0VJOzyjADWsRsGJDkLQJBgQ', -33.121809, 150.1459625, 'city', '1'),
('countries_australia_new_south_wales_glen_elgin', 'ChIJ7XRGj3kfmWsRgLBDkLQJBgQ', -29.5981601, 152.1045769, 'city', '1'),
('countries_australia_new_south_wales_glen_innes', 'ChIJs0FxVTC2mGsRkLBDkLQJBgQ', -29.7518376, 151.7361891, 'city', '1'),
('countries_australia_new_south_wales_glen_oak', 'ChIJj3WCmWZcc2sRQINDkLQJBgQ', -32.614155, 151.7111006, 'city', '1'),
('countries_australia_new_south_wales_glen_william', 'ChIJS-FnvAOcdGsRUINDkLQJBgQ', -32.5256471, 151.8021006, 'city', '1'),
('countries_australia_new_south_wales_glossodia', 'ChIJTc78NQ5jDWsRkDkzFmh9AQU', -33.53432, 150.78231, 'city', '1'),
('countries_australia_new_south_wales_gloucester', 'ChIJNcnEaPr-dGsR8KFDkLQJBgQ', -32.0233309, 151.95875, 'city', '1'),
('countries_australia_new_south_wales_gobbagombalin', 'ChIJo2mTvHSYGGsR8CVEkLQJBgU', -35.0712235, 147.3384415, 'city', '1'),
('countries_australia_new_south_wales_gollan', 'ChIJsywGWeUeD2sRQHpDkLQJBgQ', -32.2850129, 149.0779891, 'city', '1'),
('countries_australia_new_south_wales_golspie', 'ChIJX3Rb1uRnEWsRwGJDkLQJBgQ', -34.2542799, 149.6733861, 'city', '1'),
('countries_australia_new_south_wales_gol_gol', 'ChIJ6WhEU_HgwmoRsAFEkLQJBgQ', -34.166667, 142.216667, 'city', '1'),
('countries_australia_new_south_wales_goobarragandra', 'ChIJSR8Vwt36F2sRMOlDkLQJBgQ', -35.381233, 148.4319955, 'city', '1'),
('countries_australia_new_south_wales_googong', 'ChIJE_HUfotIFmsRwDBEkLQJBgU', -35.433333, 149.216667, 'city', '1'),
('countries_australia_new_south_wales_goolgowi', 'ChIJYdpfKLUwHmsRgMtDkLQJBgQ', -33.9769925, 145.7076296, 'city', '1'),
('countries_australia_new_south_wales_goolmangar', 'ChIJsaO_1MCekGsRkPZDkLQJBgQ', -28.7308033, 153.2474085, 'city', '1'),
('countries_australia_new_south_wales_gooloogong', 'ChIJU_Vv1O6AEGsRUHpDkLQJBgQ', -33.6394492, 148.44516, 'city', '1'),
('countries_australia_new_south_wales_goombargana', 'ChIJ-Qj_c1xyIWsRkMtDkLQJBgQ', -35.7622364, 146.5563915, 'city', '1'),
('countries_australia_new_south_wales_goonellabah', 'ChIJTc9iYeedkGsRMCtEkLQJBgU', -28.816667, 153.316667, 'city', '1'),
('countries_australia_new_south_wales_goonengerry', 'ChIJueEXMmKOkGsRoPZDkLQJBgQ', -28.6052931, 153.4331163, 'city', '1'),
('countries_australia_new_south_wales_gordon', 'ChIJuaDNFYmoEmsRkLgyFmh9AQU', -33.7556261, 151.1527768, 'city', '1'),
('countries_australia_new_south_wales_gormans_hill', 'ChIJGbUIUGLvEWsRkCJEkLQJBgU', -33.4739536, 149.5959275, 'city', '1'),
('countries_australia_new_south_wales_gorokan', 'ChIJk5NkaIjacmsRkNkyFmh9AQU', -33.2537407, 151.5106841, 'city', '1'),
('countries_australia_new_south_wales_gosford', 'ChIJcQ2a1GbMcmsRoNkyFmh9AQU', -33.426667, 151.341667, 'city', '1'),
('countries_australia_new_south_wales_goulburn', 'ChIJLagf6equFmsR0CdEkLQJBgU', -34.7479181, 149.7277447, 'city', '1'),
('countries_australia_new_south_wales_grabben_gullen', 'ChIJp-LpkhTMFmsR8N1DkLQJBgQ', -34.5305099, 149.387921, 'city', '1'),
('countries_australia_new_south_wales_grafton', 'ChIJGURk4vnbm2sRoCxEkLQJBgU', -29.6816894, 152.9336547, 'city', '1'),
('countries_australia_new_south_wales_granville', 'ChIJGexldzKjEmsRoLgyFmh9AQU', -33.8353132, 151.0065546, 'city', '1'),
('countries_australia_new_south_wales_grasmere', 'ChIJw6tUGc32EmsRIDwzFmh9AQU', -34.057, 150.667, 'city', '1'),
('countries_australia_new_south_wales_grassy_head', 'ChIJIxFyt94tnGsRMJZDkLQJBgQ', -30.7818654, 152.9853264, 'city', '1'),
('countries_australia_new_south_wales_grattai', 'ChIJ67gHNVRgDmsRAGNDkLQJBgQ', -32.6844288, 149.4908023, 'city', '1'),
('countries_australia_new_south_wales_grays_point', 'ChIJzXIQlBzHEmsRsLgyFmh9AQU', -34.05508, 151.07492, 'city', '1'),
('countries_australia_new_south_wales_great_marlow', 'ChIJnRA4vGPam2sRsCxEkLQJBgU', -29.6551318, 152.9706122, 'city', '1'),
('countries_australia_new_south_wales_greenacre', 'ChIJMcvKWX67EmsR4LgyFmh9AQU', -33.9077605, 151.0643509, 'city', '1'),
('countries_australia_new_south_wales_greendale', 'ChIJl9SJzJr0EmsR8LgyFmh9AQU', -33.92, 150.67, 'city', '1'),
('countries_australia_new_south_wales_greenethorpe', 'ChIJMzWlTPSmEGsRYOlDkLQJBgQ', -34.1005733, 148.3834564, 'city', '1'),
('countries_australia_new_south_wales_greenfield_park', 'ChIJdYHSc5GWEmsRALkyFmh9AQU', -33.87676, 150.88819, 'city', '1'),
('countries_australia_new_south_wales_greengrove', 'ChIJ8ySksfo3DWsRMEEzFmh9AQU', -33.3788441, 151.1577979, 'city', '1'),
('countries_australia_new_south_wales_greenhills_beach', 'ChIJiQw9kd23EmsRy3ngdZp6Za0', -34.034689, 151.1646, 'city', '1'),
('countries_australia_new_south_wales_greenleigh', 'ChIJhyvdXjtPFmsR0DBEkLQJBgU', -35.361111, 149.254444, 'city', '1'),
('countries_australia_new_south_wales_greenwell_point', 'ChIJMxbgXYaCFGsRoEMzFmh9AQU', -34.9107434, 150.7303819, 'city', '1'),
('countries_australia_new_south_wales_greenwich', 'ChIJF6QmDR2vEmsRELkyFmh9AQU', -33.83302, 151.18362, 'city', '1'),
('countries_australia_new_south_wales_greenwich_park', 'ChIJkbqIdWH-E2sRAN5DkLQJBgQ', -34.5967411, 149.921922, 'city', '1'),
('countries_australia_new_south_wales_green_hill', 'ChIJYa1GmRl1nmsRQJZDkLQJBgQ', -31.0498862, 152.8088251, 'city', '1'),
('countries_australia_new_south_wales_green_hills', 'ChIJXxCqHPUTn2sR4LBDkLQJBgQ', -30.2496746, 151.7775571, 'city', '1'),
('countries_australia_new_south_wales_green_pigeon', 'ChIJu4-muju6kGsRwPZDkLQJBgQ', -28.5033807, 153.0600082, 'city', '1'),
('countries_australia_new_south_wales_green_point', 'ChIJF_V55I21cmsRsNkyFmh9AQU', -33.465, 151.36, 'city', '1'),
('countries_australia_new_south_wales_green_valley', 'ChIJ7U3WCQ-UEmsR0LgyFmh9AQU', -33.90596, 150.86681, 'city', '1'),
('countries_australia_new_south_wales_gregadoo', 'ChIJqfU3UntzImsRgOlDkLQJBgQ', -35.2291668, 147.387092, 'city', '1'),
('countries_australia_new_south_wales_gregory_hills', 'ChIJe9CvOQPuEmsR4dcNkjuxAd0', -34.0307506, 150.7766392, 'city', '1'),
('countries_australia_new_south_wales_greg_greg', 'ChIJl301fCwgI2sRcOlDkLQJBgQ', -36.0586789, 148.0799017, 'city', '1'),
('countries_australia_new_south_wales_grenfell', 'ChIJCWZCYKgNGmsRkOlDkLQJBgQ', -33.8918989, 148.1541984, 'city', '1'),
('countries_australia_new_south_wales_gresford', 'ChIJAZNZsYCmdGsRMIJDkLQJBgQ', -32.4298609, 151.5526668, 'city', '1'),
('countries_australia_new_south_wales_greta', 'ChIJgzz5hkBLc2sRgO0yFmh9AQU', -32.6890007, 151.3866681, 'city', '1'),
('countries_australia_new_south_wales_greta_main', 'ChIJLe9yQgbNDGsRcDgzFmh9AQU', -32.8872436, 151.283115, 'city', '1'),
('countries_australia_new_south_wales_grevillia', 'ChIJs4kEnU9Ll2sR4PZDkLQJBgQ', -28.4371585, 152.8169114, 'city', '1'),
('countries_australia_new_south_wales_greystanes', 'ChIJwdmXPx2YEmsRILkyFmh9AQU', -33.8297061, 150.9488947, 'city', '1'),
('countries_australia_new_south_wales_griffith', 'ChIJHeK38guuH2sRACVEkLQJBgU', -34.2800883, 146.0455313, 'city', '1'),
('countries_australia_new_south_wales_grong_grong', 'ChIJY2v_sfA2H2sRsMtDkLQJBgQ', -34.734359, 146.7784232, 'city', '1'),
('countries_australia_new_south_wales_grose_vale', 'ChIJNXoIJ-OBEmsREDszFmh9AQU', -33.584, 150.674, 'city', '1'),
('countries_australia_new_south_wales_grose_wold', 'ChIJ9VZjZh2CEmsRIDszFmh9AQU', -33.598611, 150.684722, 'city', '1'),
('countries_australia_new_south_wales_grosses_plain', 'ChIJ1X46JTq0PGsR0BJEkLQJBgQ', -36.5551283, 148.5018997, 'city', '1'),
('countries_australia_new_south_wales_guildford', 'ChIJy33GQhe9EmsRMLkyFmh9AQU', -33.8557329, 150.9950627, 'city', '1'),
('countries_australia_new_south_wales_guildford_west', 'ChIJYU7tlWe9EmsRQLkyFmh9AQU', -33.850656, 150.96308, 'city', '1'),
('countries_australia_new_south_wales_gulargambone', 'ChIJ3aWNiESQCGsRkHJDkLQJBgQ', -31.333333, 148.466667, 'city', '1'),
('countries_australia_new_south_wales_gulf_creek', 'ChIJZX1zjIuuoWsRAMBDkLQJBgQ', -30.1328188, 150.7334193, 'city', '1'),
('countries_australia_new_south_wales_gulgong', 'ChIJy2ZYunKUDmsRMGNDkLQJBgQ', -32.35, 149.533333, 'city', '1'),
('countries_australia_new_south_wales_gulmarrad', 'ChIJqbunEPNKmmsRoBlEkLQJBgQ', -29.5005759, 153.2247183, 'city', '1'),
('countries_australia_new_south_wales_gumly_gumly', 'ChIJ5ejMQwebGGsRACZEkLQJBgU', -35.1267, 147.428111, 'city', '1'),
('countries_australia_new_south_wales_gum_flat', 'ChIJEyo_pZnzoWsREMBDkLQJBgQ', -29.7727688, 150.9896513, 'city', '1'),
('countries_australia_new_south_wales_gundagai', 'ChIJcWQUtak-GGsRsOlDkLQJBgQ', -35.0566492, 148.102061, 'city', '1'),
('countries_australia_new_south_wales_gundaroo', 'ChIJ6URkAsD7FmsREN5DkLQJBgQ', -35.0291599, 149.2664419, 'city', '1'),
('countries_australia_new_south_wales_gundary', 'ChIJHbKkgX6oFmsRIN5DkLQJBgQ', -34.8318358, 149.8021048, 'city', '1'),
('countries_spain_castille_and_leon_roa_de_duero', 'ChIJPTFcg7yPRg0RoCT0WgeHBQQ', 41.7040526, -3.9164585, 'city', '0'),
('countries_australia_new_south_wales_gundy', 'ChIJ53NBtEc-C2sREIRDkLQJBgQ', -32.0142813, 150.9969266, 'city', '1'),
('countries_australia_new_south_wales_gunnedah', 'ChIJY1cCpRsNCmsRMMBDkLQJBgQ', -30.9922968, 150.2368919, 'city', '1'),
('countries_australia_new_south_wales_gunning', 'ChIJU0abWfPnFmsRMN5DkLQJBgQ', -34.783333, 149.266667, 'city', '1'),
('countries_australia_new_south_wales_gurranang', 'ChIJz6tYOqzSm2sRsBlEkLQJBgQ', -29.44385, 153.0066638, 'city', '1'),
('countries_australia_new_south_wales_gurrundah', 'ChIJCWPLTtfJFmsRUN5DkLQJBgQ', -34.5988302, 149.3774936, 'city', '1'),
('countries_spain_castille_and_leon_riano', 'ChIJx2_l3GcpSA0RNL2u01B3WEs', 42.9781529, -5.0078451, 'city', '0'),
('countries_australia_new_south_wales_gwandalan', 'ChIJfZMs7hgnc2sRwNkyFmh9AQU', -33.132, 151.585, 'city', '1'),
('countries_australia_new_south_wales_gwynneville', 'ChIJmTUPOp0ZE2sRMOMyFmh9AQU', -34.416111, 150.883889, 'city', '1'),
('countries_australia_new_south_wales_gymea', 'ChIJrUtUvXPHEmsRULkyFmh9AQU', -34.0333, 151.08556, 'city', '1'),
('countries_australia_new_south_wales_gymea_bay', 'ChIJXwnga6DHEmsRYLkyFmh9AQU', -34.0496, 151.0864, 'city', '1'),
('countries_australia_new_south_wales_haberfield', 'ChIJzT4TyQawEmsRcLkyFmh9AQU', -33.8804879, 151.138849, 'city', '1'),
('countries_australia_new_south_wales_halekulani', 'ChIJYVJk_ZjZcmsR0NkyFmh9AQU', -33.2236186, 151.5486393, 'city', '1'),
('countries_australia_new_south_wales_hallidays_point', 'ChIJM11kOtI0dGsRUKJDkLQJBgQ', -32.0758437, 152.4908152, 'city', '1'),
('countries_australia_new_south_wales_hallsville', 'ChIJ3TpZYs6dCmsRUMBDkLQJBgQ', -31.0252753, 150.8818089, 'city', '1'),
('countries_australia_new_south_wales_halton', 'ChIJqX9QeO26dGsRMIRDkLQJBgQ', -32.3155171, 151.5142478, 'city', '1'),
('countries_australia_new_south_wales_hamilton', 'ChIJs63IgbIVc2sRoO0yFmh9AQU', -32.9208496, 151.7475449, 'city', '1'),
('countries_australia_new_south_wales_hamilton_east', 'ChIJr-FY5U4Uc2sRsO0yFmh9AQU', -32.9255032, 151.7531077, 'city', '1'),
('countries_australia_new_south_wales_hamilton_north', 'ChIJndgfLa8Vc2sRwO0yFmh9AQU', -32.9123595, 151.7374964, 'city', '1'),
('countries_australia_new_south_wales_hamilton_valley', 'ChIJoWKdUt5fIWsRMCdEkLQJBgU', -36.0336525, 146.9085495, 'city', '1'),
('countries_australia_new_south_wales_hamlyn_terrace', 'ChIJmUTPPLzQcmsR0EIzFmh9AQU', -33.2552751, 151.4749426, 'city', '1'),
('countries_australia_new_south_wales_hammondville', 'ChIJ09ZQjda_EmsRgLkyFmh9AQU', -33.9483124, 150.9553562, 'city', '1'),
('countries_australia_new_south_wales_hannam_vale', 'ChIJ1UxBOQ3odWsRcKJDkLQJBgQ', -31.7121784, 152.5940628, 'city', '1'),
('countries_australia_new_south_wales_hanwood', 'ChIJYyTeKDalH2sR0MtDkLQJBgQ', -34.3311971, 146.0409075, 'city', '1'),
('countries_australia_new_south_wales_harden', 'ChIJM2Rfyv7fGWsRwOlDkLQJBgQ', -34.5532645, 148.3680252, 'city', '1'),
('countries_australia_new_south_wales_hardys_bay', 'ChIJb_WrqGizcmsR4NkyFmh9AQU', -33.5255644, 151.3567649, 'city', '1'),
('countries_australia_new_south_wales_harefield', 'ChIJnySAbWDzGGsR0OlDkLQJBgQ', -34.9628203, 147.5184945, 'city', '1'),
('countries_australia_new_south_wales_hargraves', 'ChIJw9JD6XlEDmsRcGNDkLQJBgQ', -32.7864049, 149.4632457, 'city', '1'),
('countries_australia_new_south_wales_harrington', 'ChIJq-FNNVTbdWsRgKJDkLQJBgQ', -31.8716001, 152.6878815, 'city', '1'),
('countries_australia_new_south_wales_harrington_park', 'ChIJMc5pkDbwEmsRsLkyFmh9AQU', -34.029268, 150.7347791, 'city', '1'),
('countries_australia_new_south_wales_harris_park', 'ChIJ8ccOaSOjEmsRwLkyFmh9AQU', -33.8224148, 151.0089654, 'city', '1'),
('countries_australia_new_south_wales_hartley', 'ChIJf7aebIULEmsRgGNDkLQJBgQ', -33.5490357, 150.1903153, 'city', '1'),
('countries_australia_new_south_wales_hartley_vale', 'ChIJL-MaFJR0EmsRkGNDkLQJBgQ', -33.5347481, 150.2364463, 'city', '1'),
('countries_australia_new_south_wales_harwood', 'ChIJx2-NRaVJmmsR0BlEkLQJBgQ', -29.4268938, 153.2393184, 'city', '1'),
('countries_australia_new_south_wales_hassall_grove', 'ChIJs8iTtuqbEmsR0LkyFmh9AQU', -33.7310177, 150.8400375, 'city', '1'),
('countries_australia_new_south_wales_hastings_point', 'ChIJ4xpWc_v3kGsR4DFEkLQJBgU', -28.3566658, 153.5734429, 'city', '1'),
('countries_australia_new_south_wales_hat_head', 'ChIJk6YLjTvbnWsRYJZDkLQJBgQ', -31.0545041, 153.0499271, 'city', '1'),
('countries_australia_new_south_wales_hawkesbury_heights', 'ChIJj1hwKTWBEmsRwNQyFmh9AQU', -33.6663915, 150.6418253, 'city', '1'),
('countries_australia_new_south_wales_hawks_nest', 'ChIJXxpcmlWHc2sRYIRDkLQJBgQ', -32.6727562, 152.1773011, 'city', '1'),
('countries_australia_new_south_wales_hay', 'ChIJEe8ZJcl-4GoR4CREkLQJBgU', -34.5042009, 144.8444508, 'city', '1'),
('countries_australia_new_south_wales_haymarket', 'ChIJBbYoni-uEmsR4LkyFmh9AQU', -33.8803263, 151.2049173, 'city', '1'),
('countries_australia_new_south_wales_haywards_bay', 'ChIJQ6PlVDQSE2sRsEQzFmh9AQU', -34.540995, 150.7909958, 'city', '1'),
('countries_australia_new_south_wales_hazelbrook', 'ChIJRcIQsD57EmsR0NQyFmh9AQU', -33.7208773, 150.4515724, 'city', '1'),
('countries_australia_new_south_wales_hazelgrove', 'ChIJsThV0KsfEmsRwGNDkLQJBgQ', -33.6656432, 149.8933866, 'city', '1'),
('countries_australia_new_south_wales_heathcote', 'ChIJ8Q93eX7BEmsR8LkyFmh9AQU', -34.0877515, 151.0074095, 'city', '1'),
('countries_australia_new_south_wales_heatherbrae', 'ChIJHeLnLHBpc2sR4O0yFmh9AQU', -32.7874369, 151.732415, 'city', '1'),
('countries_australia_new_south_wales_hebersham', 'ChIJLRvGd6ybEmsRALoyFmh9AQU', -33.7494039, 150.8237898, 'city', '1'),
('countries_australia_new_south_wales_heckenberg', 'ChIJD28Y3jiUEmsRELoyFmh9AQU', -33.9071888, 150.8930138, 'city', '1'),
('countries_australia_new_south_wales_heddon_greta', 'ChIJDey4ARg4c2sR8O0yFmh9AQU', -32.8044722, 151.5095383, 'city', '1'),
('countries_australia_new_south_wales_helensburgh', 'ChIJ2yFSBZbdEmsRQOMyFmh9AQU', -34.1913797, 150.9820056, 'city', '1'),
('countries_australia_new_south_wales_henley', 'ChIJeww2m2OlEmsRILoyFmh9AQU', -33.8422194, 151.1359423, 'city', '1'),
('countries_australia_new_south_wales_henty', 'ChIJQcqr1QgkImsRAMxDkLQJBgQ', -35.5169381, 147.0327543, 'city', '1'),
('countries_australia_new_south_wales_hermitage_flat', 'ChIJNyTWX0YKEmsRkCFEkLQJBgU', -33.4792778, 150.1461795, 'city', '1'),
('countries_australia_new_south_wales_hernani', 'ChIJt6myIX_AnmsRcJZDkLQJBgQ', -30.2978993, 152.4185346, 'city', '1'),
('countries_australia_new_south_wales_herons_creek', 'ChIJLbjh32_7dWsRoKJDkLQJBgQ', -31.5878868, 152.7267469, 'city', '1'),
('countries_australia_new_south_wales_hexham', 'ChIJyc4Kjy5Hc2sRAO4yFmh9AQU', -32.8279576, 151.6844271, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_australia_new_south_wales_higher_macdonald', 'ChIJH6RLHFwZDWsRgIRDkLQJBgQ', -33.2146164, 150.9337776, 'city', '1'),
('countries_australia_new_south_wales_highfields', 'ChIJO5bzCREWc2sREO4yFmh9AQU', -32.9564939, 151.7131741, 'city', '1'),
('countries_australia_new_south_wales_high_range', 'ChIJLd_Oh5S6E2sRkI9DkLQJBgQ', -34.373539, 150.2976839, 'city', '1'),
('countries_australia_new_south_wales_hilldale', 'ChIJOVNi3mmgdGsRkIRDkLQJBgQ', -32.503533, 151.6505373, 'city', '1'),
('countries_australia_new_south_wales_hillgrove', 'ChIJn9mv4A-pn2sRILFDkLQJBgQ', -30.5691477, 151.9060756, 'city', '1'),
('countries_australia_new_south_wales_hillsborough', 'ChIJTWFkw7w9c2sRIO4yFmh9AQU', -32.9560325, 151.674331, 'city', '1'),
('countries_australia_new_south_wales_hillsdale', 'ChIJ-aIcGhSxEmsRMLoyFmh9AQU', -33.9519768, 151.2280961, 'city', '1'),
('countries_australia_new_south_wales_hillston', 'ChIJ17nBzvn5HWsRAANEkLQJBgQ', -33.4855373, 145.5314081, 'city', '1'),
('countries_spain_castille_and_leon_portillo', 'ChIJP-MNgtMiRw0R4Jb1WgeHBQQ', 41.4805659, -4.5727598, 'city', '0'),
('countries_australia_new_south_wales_hillvue', 'ChIJE4Wne1SYCmsRIClEkLQJBgU', -31.1237798, 150.9098686, 'city', '1'),
('countries_australia_new_south_wales_hill_end', 'ChIJVxy7w3M-DmsR0GNDkLQJBgQ', -33.0326812, 149.4167779, 'city', '1'),
('countries_australia_new_south_wales_hill_top', 'ChIJl4bwFwGmE2sRoI9DkLQJBgQ', -34.3543187, 150.494215, 'city', '1'),
('countries_australia_new_south_wales_hinchinbrook', 'ChIJaw68rXiUEmsRQLoyFmh9AQU', -33.9165364, 150.8639325, 'city', '1'),
('countries_australia_new_south_wales_hinton', 'ChIJw3mcAPdCc2sRMO4yFmh9AQU', -32.7165793, 151.6513886, 'city', '1'),
('countries_australia_new_south_wales_hobartville', 'ChIJW7E1OmB9DWsRAEQzFmh9AQU', -33.605331, 150.7445355, 'city', '1'),
('countries_australia_new_south_wales_holbrook', 'ChIJw5S8ObhJImsR4OlDkLQJBgQ', -35.7205598, 147.3162836, 'city', '1'),
('countries_australia_new_south_wales_holgate', 'ChIJj6sIUc3LcmsR8NkyFmh9AQU', -33.4027419, 151.4063776, 'city', '1'),
('countries_australia_new_south_wales_holmesville', 'ChIJ1-ISqNk7c2sRQO4yFmh9AQU', -32.915, 151.568, 'city', '1'),
('countries_australia_new_south_wales_holroyd', 'ChIJnaKm9Cq9EmsRYLoyFmh9AQU', -33.831, 150.997, 'city', '1'),
('countries_australia_new_south_wales_holsworthy', 'ChIJg4geY0TAEmsRcLoyFmh9AQU', -33.9565362, 150.9498811, 'city', '1'),
('countries_australia_new_south_wales_homebush', 'ChIJ4cGIXTK7EmsRsLoyFmh9AQU', -33.8628387, 151.0796443, 'city', '1'),
('countries_australia_new_south_wales_homebush_west', 'ChIJaWzRgki7EmsR0LoyFmh9AQU', -33.8623709, 151.066621, 'city', '1'),
('countries_australia_new_south_wales_homeleigh', 'ChIJwXxyta-6kGsREPdDkLQJBgQ', -28.5686121, 153.0559687, 'city', '1'),
('countries_australia_new_south_wales_hopefield', 'ChIJxTamVyw8IWsREMxDkLQJBgQ', -35.9094403, 146.4376943, 'city', '1'),
('countries_australia_new_south_wales_hopkins_creek', 'ChIJG621wXfokGsRIPdDkLQJBgQ', -28.2952002, 153.244462, 'city', '1'),
('countries_australia_new_south_wales_horningsea_park', 'ChIJ0aEr7EaTEmsR8EAzFmh9AQU', -33.944, 150.844, 'city', '1'),
('countries_australia_new_south_wales_hornsby', 'ChIJDZApusWnEmsR4LoyFmh9AQU', -33.7046328, 151.0987055, 'city', '1'),
('countries_australia_new_south_wales_horseshoe_bend', 'ChIJG_nVqi9Ec2sRUO4yFmh9AQU', -32.734167, 151.563889, 'city', '1'),
('countries_australia_new_south_wales_horse_station_creek', 'ChIJL8i2eaqvkGsRMPdDkLQJBgQ', -28.629017, 152.9608002, 'city', '1'),
('countries_australia_new_south_wales_horsfield_bay', 'ChIJbx9LaWhLDWsRANoyFmh9AQU', -33.492, 151.304, 'city', '1'),
('countries_australia_new_south_wales_horsley', 'ChIJ3emR3xoOE2sRQNEyFmh9AQU', -34.4916005, 150.7708274, 'city', '1'),
('countries_australia_new_south_wales_horsley_park', 'ChIJf5rQhBWREmsRALsyFmh9AQU', -33.8417894, 150.8553834, 'city', '1'),
('countries_australia_new_south_wales_hoskinstown', 'ChIJz47bOMxBFmsRkN5DkLQJBgQ', -35.4110068, 149.4435669, 'city', '1'),
('countries_australia_new_south_wales_howlong', 'ChIJw94di3VqIWsRIMxDkLQJBgQ', -35.9813839, 146.6373439, 'city', '1'),
('countries_australia_new_south_wales_hoxton_park', 'ChIJlZXQSmOTEmsRELsyFmh9AQU', -33.93382, 150.85284, 'city', '1'),
('countries_australia_new_south_wales_humula', 'ChIJXTcpAw6GImsR8OlDkLQJBgQ', -35.5368944, 147.7211421, 'city', '1'),
('countries_australia_new_south_wales_hunters_hill', 'ChIJ8S90G3mvEmsRILsyFmh9AQU', -33.8337, 151.14366, 'city', '1'),
('countries_australia_new_south_wales_hunterview', 'ChIJAdVe1MmvDGsRkCBEkLQJBgU', -32.5402273, 151.1781916, 'city', '1'),
('countries_australia_new_south_wales_huntingdon', 'ChIJhVwcQAz3dWsR0KJDkLQJBgQ', -31.4664007, 152.6530426, 'city', '1'),
('countries_australia_new_south_wales_huntingwood', 'ChIJtzOgUr-ZEmsRMLsyFmh9AQU', -33.799, 150.885, 'city', '1'),
('countries_australia_new_south_wales_huntley', 'ChIJSemEg3ESE2sR4EQzFmh9AQU', -34.4971444, 150.7413186, 'city', '1'),
('countries_australia_new_south_wales_huntleys_cove', 'ChIJYwqQmX2lEmsRsEMzFmh9AQU', -33.8385208, 151.138135, 'city', '1'),
('countries_australia_new_south_wales_huntleys_point', 'ChIJYTgOPoavEmsRQLsyFmh9AQU', -33.839, 151.147, 'city', '1'),
('countries_australia_new_south_wales_huonbrook', 'ChIJX7y67kuSkGsRUPdDkLQJBgQ', -28.5496474, 153.3645634, 'city', '1'),
('countries_australia_new_south_wales_hurlstone_park', 'ChIJH0_rrGK6EmsRULsyFmh9AQU', -33.91058, 151.12919, 'city', '1'),
('countries_australia_new_south_wales_hurstville', 'ChIJveHmvpi5EmsRYLsyFmh9AQU', -33.9645633, 151.1010187, 'city', '1'),
('countries_australia_new_south_wales_hurstville_grove', 'ChIJX5qesAC5EmsRcLsyFmh9AQU', -33.97972, 151.09298, 'city', '1'),
('countries_australia_new_south_wales_huskisson', 'ChIJK7OpSMuHFGsRoNZDkLQJBgQ', -35.04184, 150.67133, 'city', '1'),
('countries_australia_new_south_wales_hyams_beach', 'ChIJzTQj6bWOFGsRsNZDkLQJBgQ', -35.1033165, 150.6918909, 'city', '1'),
('countries_australia_new_south_wales_hyland_park', 'ChIJS4dP2DglnGsRkJZDkLQJBgQ', -30.6126229, 152.9956269, 'city', '1'),
('countries_australia_new_south_wales_ilarwill', 'ChIJh3I9EufKm2sR4BlEkLQJBgQ', -29.4714376, 153.18149, 'city', '1'),
('countries_australia_new_south_wales_ilford', 'ChIJR5pC8Mp1DmsREGRDkLQJBgQ', -32.9680083, 149.8540605, 'city', '1'),
('countries_australia_new_south_wales_illabo', 'ChIJA8n5oSJRGGsRAOpDkLQJBgQ', -34.816667, 147.75, 'city', '1'),
('countries_spain_castille_and_leon_olmedo', 'ChIJ7W77EGk2Rw0R8JX1WgeHBQQ', 41.2851649, -4.7070616, 'city', '0'),
('countries_australia_new_south_wales_iluka', 'ChIJ185IOO9OmmsR8BlEkLQJBgQ', -29.4017094, 153.3512005, 'city', '1'),
('countries_australia_new_south_wales_ingleburn', 'ChIJFQavmGPrEmsRkLsyFmh9AQU', -34.0044124, 150.8630229, 'city', '1'),
('countries_australia_new_south_wales_ingleside', 'ChIJndZA1zdUDWsRoLsyFmh9AQU', -33.6823, 151.26315, 'city', '1'),
('countries_australia_new_south_wales_inverell', 'ChIJH050xEL3oWsRULFDkLQJBgQ', -29.7627514, 151.1102815, 'city', '1'),
('countries_australia_new_south_wales_invergowrie', 'ChIJl11ZuimDn2sRYLFDkLQJBgQ', -30.5106511, 151.5089856, 'city', '1'),
('countries_australia_new_south_wales_islington', 'ChIJj3-HHKsVc2sRYO4yFmh9AQU', -32.9140892, 151.7461811, 'city', '1'),
('countries_australia_new_south_wales_ivanhoe', 'ChIJ12svoAjq42oRIANEkLQJBgQ', -32.8997365, 144.3004317, 'city', '1'),
('countries_australia_new_south_wales_jamberoo', 'ChIJ2VshVIlxE2sRYOMyFmh9AQU', -34.6481254, 150.7742277, 'city', '1'),
('countries_australia_new_south_wales_james_creek', 'ChIJm3iExVZKmmsRIBpEkLQJBgQ', -29.4563411, 153.2483612, 'city', '1'),
('countries_australia_new_south_wales_jamisontown', 'ChIJQwo6RkWPEmsRsLsyFmh9AQU', -33.7691552, 150.676584, 'city', '1'),
('countries_australia_new_south_wales_jannali', 'ChIJQ4NMDlnHEmsRwLsyFmh9AQU', -34.0161164, 151.0649493, 'city', '1'),
('countries_australia_new_south_wales_jaspers_brush', 'ChIJcwdinfp7E2sRoEUzFmh9AQU', -34.8035003, 150.6562891, 'city', '1'),
('countries_australia_new_south_wales_jellat_jellat', 'ChIJy6gTNrqCPmsRMApEkLQJBgQ', -36.7162143, 149.8841535, 'city', '1'),
('countries_australia_new_south_wales_jerangle', 'ChIJ0TJwTWjzPWsR0N5DkLQJBgQ', -35.870432, 149.3638685, 'city', '1'),
('countries_australia_new_south_wales_jerilderie', 'ChIJqc0uNSFuIGsRMMxDkLQJBgQ', -35.3564281, 145.7292848, 'city', '1'),
('countries_australia_new_south_wales_jerrabomberra', 'ChIJXWpTMCZJFmsR4DBEkLQJBgU', -35.3829753, 149.2107365, 'city', '1'),
('countries_australia_new_south_wales_jerrara', 'ChIJAW1cGSduE2sRIEEzFmh9AQU', -34.6696319, 150.8237429, 'city', '1'),
('countries_australia_new_south_wales_jerrawa', 'ChIJ20ZDk_sfF2sR8N5DkLQJBgQ', -34.7852202, 149.0863598, 'city', '1'),
('countries_australia_new_south_wales_jerrys_plains', 'ChIJyeE4rgKaDGsR4IRDkLQJBgQ', -32.4911159, 150.9038421, 'city', '1'),
('countries_australia_new_south_wales_jesmond', 'ChIJ7YpLhi4-c2sRcO4yFmh9AQU', -32.9042681, 151.6948326, 'city', '1'),
('countries_australia_new_south_wales_jewells', 'ChIJY6uCQls9c2sRgO4yFmh9AQU', -33.0139432, 151.6831354, 'city', '1'),
('countries_australia_new_south_wales_jiggi', 'ChIJr-2Qd1GfkGsRgPdDkLQJBgQ', -28.6768606, 153.1820203, 'city', '1'),
('countries_australia_new_south_wales_jilliby', 'ChIJWzHrjH7WcmsRENoyFmh9AQU', -33.2316233, 151.4067361, 'city', '1'),
('countries_australia_new_south_wales_jindabyne', 'ChIJ2b3Ot4nEPGsRwCdEkLQJBgU', -36.4172451, 148.6248294, 'city', '1'),
('countries_australia_new_south_wales_jinden', 'ChIJ4z5AM2UeFmsRYApEkLQJBgQ', -35.8875823, 149.5927621, 'city', '1'),
('countries_australia_new_south_wales_jindera', 'ChIJBQLBZ2NgIWsRQOpDkLQJBgQ', -35.9549344, 146.8887215, 'city', '1'),
('countries_australia_new_south_wales_jingellic', 'ChIJZR0q71L_ImsRUOpDkLQJBgQ', -35.9261984, 147.6980739, 'city', '1'),
('countries_spain_castille_and_leon_medina_de_rioseco', 'ChIJ9y4Q0rWARw0R1IlU7GwRDCc', 41.8792161, -5.0286488, 'city', '0'),
('countries_australia_new_south_wales_johns_river', 'ChIJf0IQqLvndWsREKNDkLQJBgQ', -31.7312738, 152.6958067, 'city', '1'),
('countries_australia_new_south_wales_jordan_springs', 'ChIJO1h4RwCFEmsRP7PvJmhB1PM', -33.7229395, 150.7277359, 'city', '1'),
('countries_australia_new_south_wales_jugiong', 'ChIJvf_tpqxiF2sRgOpDkLQJBgQ', -34.8233868, 148.3244181, 'city', '1'),
('countries_australia_new_south_wales_junction_hill', 'ChIJw3jhbC7am2sRwCxEkLQJBgU', -29.6375106, 152.9263796, 'city', '1'),
('countries_australia_new_south_wales_junee', 'ChIJRcot7av3GGsRkOpDkLQJBgQ', -34.8689219, 147.5833258, 'city', '1'),
('countries_australia_new_south_wales_kahibah', 'ChIJ-6gmzhkWc2sRkO4yFmh9AQU', -32.9634578, 151.7107954, 'city', '1'),
('countries_australia_new_south_wales_kains_flat', 'ChIJQdDLgFcnDGsRkGRDkLQJBgQ', -32.4817377, 149.852617, 'city', '1'),
('countries_australia_new_south_wales_kalaru', 'ChIJI7lSp7WDPmsRcApEkLQJBgQ', -36.7317551, 149.9276991, 'city', '1'),
('countries_australia_new_south_wales_kalkite', 'ChIJj1Ce7kXDPGsREBNEkLQJBgQ', -36.3395074, 148.6479243, 'city', '1'),
('countries_australia_new_south_wales_kanahooka', 'ChIJNZYrRpYRE2sRgOMyFmh9AQU', -34.491667, 150.808333, 'city', '1'),
('countries_australia_new_south_wales_kandos', 'ChIJ-3rUQ5PRDWsRsGRDkLQJBgQ', -32.854707, 149.9783536, 'city', '1'),
('countries_australia_new_south_wales_kangaroo_valley', 'ChIJ9cIlzDmDE2sRANdDkLQJBgQ', -34.7341513, 150.5258648, 'city', '1'),
('countries_australia_new_south_wales_kangy_angy', 'ChIJ2XeCAEPOcmsRINoyFmh9AQU', -33.324, 151.385, 'city', '1'),
('countries_australia_new_south_wales_kanoona', 'ChIJKaS7sA0nPGsRkApEkLQJBgQ', -36.7543344, 149.7696122, 'city', '1'),
('countries_australia_new_south_wales_kanwal', 'ChIJd1OVxljQcmsRMNoyFmh9AQU', -33.265, 151.485, 'city', '1'),
('countries_australia_new_south_wales_karabar', 'ChIJ2RrEpdhIFmsR8DBEkLQJBgU', -35.366667, 149.233333, 'city', '1'),
('countries_australia_new_south_wales_karangi', 'ChIJZ23QcV8DnGsR0JZDkLQJBgQ', -30.266667, 153.05, 'city', '1'),
('countries_australia_new_south_wales_kareela', 'ChIJI8L804K4EmsR4LsyFmh9AQU', -34.01503, 151.08046, 'city', '1'),
('countries_australia_new_south_wales_kariong', 'ChIJvylgETdKDWsRQNoyFmh9AQU', -33.4407034, 151.2883222, 'city', '1'),
('countries_australia_new_south_wales_karuah', 'ChIJz5CQMH58c2sRAIVDkLQJBgQ', -32.6435096, 151.9754691, 'city', '1'),
('countries_australia_new_south_wales_katoomba', 'ChIJrf08OilsEmsR4NQyFmh9AQU', -33.7125, 150.311944, 'city', '1'),
('countries_australia_new_south_wales_kearns', 'ChIJBWim6drtEmsR8LsyFmh9AQU', -34.02373, 150.80628, 'city', '1'),
('countries_australia_new_south_wales_kearsley', 'ChIJaduBkhQ0c2sRsO4yFmh9AQU', -32.8490887, 151.3997773, 'city', '1'),
('countries_australia_new_south_wales_keera', 'ChIJW3QgifO7oWsRoMBDkLQJBgQ', -29.9330813, 150.6897331, 'city', '1'),
('countries_australia_new_south_wales_keinbah', 'ChIJhx9NU6tLc2sRIEMzFmh9AQU', -32.7592376, 151.402695, 'city', '1'),
('countries_australia_new_south_wales_keiraville', 'ChIJn38hJpUeE2sRkOMyFmh9AQU', -34.4072659, 150.8754745, 'city', '1'),
('countries_australia_new_south_wales_keith_hall', 'ChIJ4bD4NpF_mmsR4CtEkLQJBgU', -28.8870268, 153.5393031, 'city', '1'),
('countries_australia_new_south_wales_kellyville', 'ChIJg9ejPQafEmsRALwyFmh9AQU', -33.7111451, 150.9550731, 'city', '1'),
('countries_australia_new_south_wales_kellyville_ridge', 'ChIJd17rPRCfEmsRIEczFmh9AQU', -33.703, 150.919, 'city', '1'),
('countries_australia_new_south_wales_kelso', 'ChIJne8IiM36EWsRoCJEkLQJBgU', -33.418889, 149.605833, 'city', '1'),
('countries_australia_new_south_wales_kelvin', 'ChIJb8mKXTqdoGsRsMBDkLQJBgQ', -30.8118621, 150.3448584, 'city', '1'),
('countries_australia_new_south_wales_kembla_grange', 'ChIJISdht0QQE2sRoOMyFmh9AQU', -34.4705454, 150.7969823, 'city', '1'),
('countries_australia_new_south_wales_kembla_heights', 'ChIJkVkMCeAbE2sRsOMyFmh9AQU', -34.430556, 150.806944, 'city', '1'),
('countries_australia_new_south_wales_kempsey', 'ChIJOYFX0BPfnWsR8C1EkLQJBgU', -31.0604769, 152.8481977, 'city', '1'),
('countries_australia_new_south_wales_kemps_creek', 'ChIJ_YOm3RiSEmsRELwyFmh9AQU', -33.87464, 150.79868, 'city', '1'),
('countries_australia_new_south_wales_kendall', 'ChIJUSUDBsbkdWsRUKNDkLQJBgQ', -31.633333, 152.7, 'city', '1'),
('countries_spain_castille_and_leon_magaz_de_abajo', 'ChIJ7x82gZ--MA0RxGq4asiNpWE', 42.5930885, -6.6854486, 'city', '0'),
('countries_australia_new_south_wales_kensington', 'ChIJibqk14ixEmsRILwyFmh9AQU', -33.910021, 151.2232749, 'city', '1'),
('countries_australia_new_south_wales_kenthurst', 'ChIJEWOn4FBfDWsRMLwyFmh9AQU', -33.6693, 151.00158, 'city', '1'),
('countries_australia_new_south_wales_kentlyn', 'ChIJqabbl__uEmsRQLwyFmh9AQU', -34.05193, 150.87797, 'city', '1'),
('countries_australia_new_south_wales_kentucky', 'ChIJaxUZa42Ln2sR0LFDkLQJBgQ', -30.7580196, 151.4515731, 'city', '1'),
('countries_australia_new_south_wales_kew', 'ChIJL4JIRJXjdWsRcKNDkLQJBgQ', -31.633333, 152.716667, 'city', '1'),
('countries_australia_new_south_wales_keybarbin', 'ChIJ0bl3IT2SmWsR8LFDkLQJBgQ', -29.1202021, 152.6018819, 'city', '1'),
('countries_australia_new_south_wales_khancoban', 'ChIJfaAxUiY7I2sRsOpDkLQJBgQ', -36.22, 148.126944, 'city', '1'),
('countries_australia_new_south_wales_kiacatoo', 'ChIJ3yDGC5qEHGsRAHNDkLQJBgQ', -33.0507794, 146.7724526, 'city', '1'),
('countries_spain_castille_and_leon_iscar', 'ChIJt1WAkI8vRw0RRPZ7W64DZNI', 41.3422602, -4.5315029, 'city', '0'),
('countries_australia_new_south_wales_kiama', 'ChIJ37AzodFtE2sR0OMyFmh9AQU', -34.6738221, 150.8443706, 'city', '1'),
('countries_australia_new_south_wales_kiama_heights', 'ChIJh8m3kZ1uE2sR8OMyFmh9AQU', -34.7022345, 150.840584, 'city', '1'),
('countries_australia_new_south_wales_kianga', 'ChIJC-o96IsQPmsRAChEkLQJBgU', -36.1890337, 150.0975097, 'city', '1'),
('countries_australia_new_south_wales_kielvale', 'ChIJUbpVV3b6kGsRoPdDkLQJBgQ', -28.3334, 153.4334, 'city', '1'),
('countries_australia_new_south_wales_kikoira', 'ChIJUS2GTL4eHGsRYMxDkLQJBgQ', -33.6447782, 146.5486991, 'city', '1'),
('countries_australia_new_south_wales_kilaben_bay', 'ChIJJ_w8z5Akc2sRwO4yFmh9AQU', -33.026111, 151.592778, 'city', '1'),
('countries_australia_new_south_wales_killara', 'ChIJ9ybyrpaoEmsRULwyFmh9AQU', -33.76864, 151.16347, 'city', '1'),
('countries_australia_new_south_wales_killarney_heights', 'ChIJq4td5nmpEmsRYLwyFmh9AQU', -33.7742, 151.2155, 'city', '1'),
('countries_australia_new_south_wales_killarney_vale', 'ChIJH8JRyg7PcmsRYNoyFmh9AQU', -33.365, 151.46, 'city', '1'),
('countries_australia_new_south_wales_killawarra', 'ChIJGc31XZCxdWsRsKNDkLQJBgQ', -31.8928348, 152.3037176, 'city', '1'),
('countries_australia_new_south_wales_killcare', 'ChIJC_2GSHyzcmsRcNoyFmh9AQU', -33.5195114, 151.3589359, 'city', '1'),
('countries_australia_new_south_wales_killcare_heights', 'ChIJfQ_usHi0cmsRgNoyFmh9AQU', -33.5239107, 151.3764381, 'city', '1'),
('countries_australia_new_south_wales_killingworth', 'ChIJNfZZjUg6c2sR0O4yFmh9AQU', -32.9378222, 151.5555788, 'city', '1'),
('countries_australia_new_south_wales_kimbriki', 'ChIJ17P69mutdWsRwKNDkLQJBgQ', -31.9267587, 152.2494793, 'city', '1'),
('countries_australia_new_south_wales_kinchela', 'ChIJv5g5Cu7anWsREJdDkLQJBgQ', -30.993611, 152.991667, 'city', '1'),
('countries_australia_new_south_wales_kincumber', 'ChIJTxxpzUi0cmsRkNoyFmh9AQU', -33.465, 151.393, 'city', '1'),
('countries_australia_new_south_wales_kingfisher_shores', 'ChIJ2avRaWHYcmsR9685DUAD408', -33.1682364, 151.5559438, 'city', '1'),
('countries_australia_new_south_wales_kingscliff', 'ChIJy10061P_kGsR8C9EkLQJBgU', -28.2645938, 153.5776602, 'city', '1'),
('countries_australia_new_south_wales_kingsford', 'ChIJfZfvsoWxEmsRkLwyFmh9AQU', -33.92457, 151.22765, 'city', '1'),
('countries_australia_new_south_wales_kingsgrove', 'ChIJLXuv2Cu6EmsRoLwyFmh9AQU', -33.9386352, 151.100641, 'city', '1'),
('countries_australia_new_south_wales_kingstown', 'ChIJufGte9QxoGsRELJDkLQJBgQ', -30.5170184, 151.121023, 'city', '1'),
('countries_australia_new_south_wales_kingsvale', 'ChIJ3xnYeLnjGWsR4OpDkLQJBgQ', -34.4119888, 148.3132336, 'city', '1'),
('countries_australia_new_south_wales_kingswood', 'ChIJex-Q-H2PEmsRsLwyFmh9AQU', -33.759, 150.72, 'city', '1'),
('countries_australia_new_south_wales_kings_langley', 'ChIJJZr3ebmYEmsRcLwyFmh9AQU', -33.7499763, 150.9345044, 'city', '1'),
('countries_australia_new_south_wales_kings_park', 'ChIJUxof6CaZEmsRgLwyFmh9AQU', -33.7457198, 150.9047417, 'city', '1'),
('countries_australia_new_south_wales_kings_point', 'ChIJ2XT4dXdRFGsRsApEkLQJBgQ', -35.3729901, 150.4457317, 'city', '1'),
('countries_australia_new_south_wales_king_creek', 'ChIJZzy0fSf8dWsR4KNDkLQJBgQ', -31.49133, 152.7500251, 'city', '1'),
('countries_australia_new_south_wales_kioloa', 'ChIJKeHs9GGxFWsR0ApEkLQJBgQ', -35.561111, 150.374167, 'city', '1'),
('countries_australia_new_south_wales_kirkham', 'ChIJnTMSyGPxEmsR0LwyFmh9AQU', -34.039, 150.709, 'city', '1'),
('countries_australia_new_south_wales_kirrawee', 'ChIJ44uvKWrHEmsR4LwyFmh9AQU', -34.0357295, 151.0707945, 'city', '1'),
('countries_australia_new_south_wales_kirribilli', 'ChIJE4sIK4quEmsR8LwyFmh9AQU', -33.8491363, 151.2175297, 'city', '1'),
('countries_australia_new_south_wales_kitchener', 'ChIJoRxQhwwzc2sR8O4yFmh9AQU', -32.875833, 151.366111, 'city', '1'),
('countries_australia_new_south_wales_knockrow', 'ChIJ6fFgIy-HkGsRwPdDkLQJBgQ', -28.7573446, 153.5393031, 'city', '1'),
('countries_australia_new_south_wales_kogarah', 'ChIJGQY04ua5EmsRAL0yFmh9AQU', -33.9643523, 151.1372588, 'city', '1'),
('countries_australia_new_south_wales_kogarah_bay', 'ChIJfX2ePsy5EmsREL0yFmh9AQU', -33.98338, 151.12166, 'city', '1'),
('countries_australia_new_south_wales_koolewong', 'ChIJ0Sd7lShLDWsRsNoyFmh9AQU', -33.466, 151.318, 'city', '1'),
('countries_australia_new_south_wales_koolkhan', 'ChIJQcGhV-TZm2sRUBpEkLQJBgQ', -29.616667, 152.933333, 'city', '1'),
('countries_australia_new_south_wales_koonawarra', 'ChIJUw5biJwRE2sRAOQyFmh9AQU', -34.501667, 150.808333, 'city', '1'),
('countries_australia_new_south_wales_koonorigan', 'ChIJ_RozW8qYkGsR0PdDkLQJBgQ', -28.700881, 153.2208914, 'city', '1'),
('countries_australia_new_south_wales_kooragang', 'ChIJB597vvw_c2sRAO8yFmh9AQU', -32.887377, 151.7736914, 'city', '1'),
('countries_australia_new_south_wales_koorawatha', 'ChIJ17YXYIy8EGsR8OpDkLQJBgQ', -34.038333, 148.553889, 'city', '1'),
('countries_australia_new_south_wales_kooringal', 'ChIJ4wbV9OKbGGsRMCZEkLQJBgU', -35.135, 147.376, 'city', '1'),
('countries_australia_new_south_wales_kootingal', 'ChIJ7bGRlJ6nCmsR8MBDkLQJBgQ', -31.05, 151.05, 'city', '1'),
('countries_australia_new_south_wales_koraleigh', 'ChIJpzUQyo5-3GoRgMxDkLQJBgQ', -35.1612939, 143.4185319, 'city', '1'),
('countries_australia_new_south_wales_korora', 'ChIJ_SstmacOnGsRIC1EkLQJBgU', -30.2458686, 153.1148552, 'city', '1'),
('countries_australia_new_south_wales_kosciuszko_national_park', 'ChIJiRtyMGsoPWsRIBNEkLQJBgQ', -35.866634, 148.497223, 'city', '1'),
('countries_australia_new_south_wales_kotara', 'ChIJpVSmuv89c2sREO8yFmh9AQU', -32.9433965, 151.6976421, 'city', '1'),
('countries_australia_new_south_wales_kotara_south', 'ChIJ5XHiTfA9c2sRIO8yFmh9AQU', -32.951, 151.691, 'city', '1'),
('countries_australia_new_south_wales_krambach', 'ChIJxYnhFCKtdWsRUKRDkLQJBgQ', -32.05, 152.266667, 'city', '1'),
('countries_australia_new_south_wales_kulnura', 'ChIJt97NfFsuDWsRwNoyFmh9AQU', -33.232, 151.218, 'city', '1'),
('countries_australia_new_south_wales_kundabung', 'ChIJO7TwyGYKnmsRMJdDkLQJBgQ', -31.2, 152.85, 'city', '1'),
('countries_australia_new_south_wales_kungala', 'ChIJl6RwEObvm2sRYBpEkLQJBgQ', -29.95, 153.016667, 'city', '1'),
('countries_australia_new_south_wales_kunghur', 'ChIJocSCyjKVkGsR8PdDkLQJBgQ', -28.4718287, 153.2647932, 'city', '1'),
('countries_australia_new_south_wales_kurmond', 'ChIJo71w9kh8DWsR8DkzFmh9AQU', -33.551, 150.69, 'city', '1'),
('countries_australia_new_south_wales_kurnell', 'ChIJ74PoqrS3EmsRML0yFmh9AQU', -34.01159, 151.20686, 'city', '1'),
('countries_australia_new_south_wales_kurraba_point', 'ChIJF62xcoWuEmsRpxBt8CNTSXo', -33.843, 151.223, 'city', '1'),
('countries_australia_new_south_wales_kurrajong_heights', 'ChIJabeUaRJ_DWsRIDkzFmh9AQU', -33.5186855, 150.6227031, 'city', '1'),
('countries_australia_new_south_wales_kurrajong_hills', 'ChIJ5z1LEpR-DWsRMDkzFmh9AQU', -33.533333, 150.65, 'city', '1'),
('countries_australia_new_south_wales_kurri_kurri', 'ChIJz0827cU3c2sRMO8yFmh9AQU', -32.816667, 151.483333, 'city', '1'),
('countries_australia_new_south_wales_kybeyan', 'ChIJDwxENxC0PWsRYN9DkLQJBgQ', -36.4006471, 149.4256824, 'city', '1'),
('countries_australia_new_south_wales_kyeemagh', 'ChIJ8-MIe7ewEmsRQL0yFmh9AQU', -33.94829, 151.15711, 'city', '1'),
('countries_australia_new_south_wales_kyle_bay', 'ChIJywjKMFG4EmsRUL0yFmh9AQU', -33.9911107, 151.1002727, 'city', '1'),
('countries_spain_castille_and_leon_hospital_de_orbigo', 'ChIJXbK9Urh8Nw0RfuEX3EFTGhM', 42.4627721, -5.8815943, 'city', '0'),
('countries_australia_new_south_wales_ladysmith', 'ChIJofyn4WiBGGsRQOtDkLQJBgQ', -35.2032722, 147.5299237, 'city', '1'),
('countries_australia_new_south_wales_laffing_waters', 'ChIJDbq-GobkEWsRsCJEkLQJBgU', -33.3812469, 149.6242736, 'city', '1'),
('countries_australia_new_south_wales_laggan', 'ChIJxVMxoMJDEWsRYGVDkLQJBgQ', -34.3546247, 149.539034, 'city', '1'),
('countries_australia_new_south_wales_laguna', 'ChIJB_av1ZkpDWsRMIVDkLQJBgQ', -32.99, 151.134444, 'city', '1'),
('countries_australia_new_south_wales_lakelands', 'ChIJmXQBRlI8c2sRQO8yFmh9AQU', -32.961, 151.65, 'city', '1'),
('countries_australia_new_south_wales_lakemba', 'ChIJu2tkxcC7EmsRcL0yFmh9AQU', -33.9200417, 151.0771497, 'city', '1'),
('countries_australia_new_south_wales_lakesland', 'ChIJXYmWWrqqE2sR8I9DkLQJBgQ', -34.166667, 150.533333, 'city', '1'),
('countries_australia_new_south_wales_lakewood', 'ChIJ9Rc9-NfidWsRoKRDkLQJBgQ', -31.6345172, 152.7647235, 'city', '1'),
('countries_australia_new_south_wales_lake_albert', 'ChIJfeSNvhucGGsRQCZEkLQJBgU', -35.166, 147.381, 'city', '1'),
('countries_australia_new_south_wales_lake_bathurst', 'ChIJGydDaUaaFmsRMJLf0bQJBio', -35.0522542, 149.6968129, 'city', '1'),
('countries_australia_new_south_wales_lake_cargelligo', 'ChIJMVeF0ZNHHGsRsMxDkLQJBgQ', -33.2985866, 146.3724762, 'city', '1'),
('countries_australia_new_south_wales_lake_cathie', 'ChIJOzs7plMHdmsRgKRDkLQJBgQ', -31.5465341, 152.8355653, 'city', '1'),
('countries_australia_new_south_wales_lake_conjola', 'ChIJ31sPhglcFGsRMNdDkLQJBgQ', -35.2696191, 150.4810158, 'city', '1'),
('countries_australia_new_south_wales_lake_haven', 'ChIJBewgypnQcmsR0NoyFmh9AQU', -33.24, 151.501, 'city', '1'),
('countries_australia_new_south_wales_lake_heights', 'ChIJ_wTkIy4XE2sREOQyFmh9AQU', -34.4854, 150.866, 'city', '1'),
('countries_spain_castille_and_leon_guijuelo', 'ChIJd7HB8W0BPw0RgvjRsLY8H5E', 40.5664773, -5.6773512, 'city', '0'),
('countries_australia_new_south_wales_lake_innes', 'ChIJTW0gMHL-dWsRkKRDkLQJBgQ', -31.4901372, 152.8199434, 'city', '1'),
('countries_australia_new_south_wales_lake_munmorah', 'ChIJb9xsleTYcmsR4NoyFmh9AQU', -33.1923043, 151.5749274, 'city', '1'),
('countries_australia_new_south_wales_lake_tabourie', 'ChIJaaGtomJNFGsR8ApEkLQJBgQ', -35.437195, 150.4051459, 'city', '1'),
('countries_australia_new_south_wales_lake_wyangan', 'ChIJb0OTAIOyH2sRQB7f0bQJBio', -34.2177071, 146.0222113, 'city', '1'),
('countries_australia_new_south_wales_lalor_park', 'ChIJP1TqtZSYEmsRgL0yFmh9AQU', -33.7666, 150.9277, 'city', '1'),
('countries_australia_new_south_wales_lane_cove', 'ChIJnRMwPhWvEmsRkL0yFmh9AQU', -33.8148145, 151.1663935, 'city', '1'),
('countries_australia_new_south_wales_lane_cove_north', 'ChIJjTJNUEivEmsRwEMzFmh9AQU', -33.8062733, 151.1664881, 'city', '1'),
('countries_australia_new_south_wales_lane_cove_west', 'ChIJWcUVG2ivEmsRoL0yFmh9AQU', -33.811478, 151.1527422, 'city', '1'),
('countries_australia_new_south_wales_lanitza', 'ChIJWTOzzsrlm2sRkBpEkLQJBgQ', -29.883333, 153, 'city', '1'),
('countries_australia_new_south_wales_lankeys_creek', 'ChIJ9zxepWFUImsRYOtDkLQJBgQ', -35.816667, 147.666667, 'city', '1'),
('countries_australia_new_south_wales_lansdowne', 'ChIJ9-bpFt3AdWsRwKRDkLQJBgQ', -31.783056, 152.534444, 'city', '1'),
('countries_australia_new_south_wales_lansvale', 'ChIJnZDAx_u9EmsRwL0yFmh9AQU', -33.906913, 150.9685549, 'city', '1'),
('countries_australia_new_south_wales_lapstone', 'ChIJL_No5_CIEmsRANUyFmh9AQU', -33.774, 150.637, 'city', '1'),
('countries_australia_new_south_wales_largs', 'ChIJJ45sYXREc2sRYO8yFmh9AQU', -32.701, 151.601, 'city', '1'),
('countries_australia_new_south_wales_laughtondale', 'ChIJF19_P1lBDWsRMEgzFmh9AQU', -33.43, 151.029, 'city', '1'),
('countries_australia_new_south_wales_lavender_bay', 'ChIJ6yari_SuEmsR0EAzFmh9AQU', -33.8435728, 151.2069658, 'city', '1'),
('countries_australia_new_south_wales_lavington', 'ChIJJ_9xt9TfI2sRQCdEkLQJBgU', -36.05, 146.933, 'city', '1'),
('countries_australia_new_south_wales_lawrence', 'ChIJe8MQres0mmsRsBpEkLQJBgQ', -29.5, 153.1, 'city', '1'),
('countries_australia_new_south_wales_lawson', 'ChIJj2jXKBtlEmsRENUyFmh9AQU', -33.716667, 150.433333, 'city', '1'),
('countries_australia_new_south_wales_la_perouse', 'ChIJ5Ts0ahu0EmsRYL0yFmh9AQU', -33.9888, 151.232, 'city', '1'),
('countries_australia_new_south_wales_leconfield', 'ChIJScGM87hNc2sRkDgzFmh9AQU', -32.652738, 151.3910248, 'city', '1'),
('countries_australia_new_south_wales_leeton', 'ChIJGfQMdKMQH2sR8MxDkLQJBgQ', -34.566667, 146.4, 'city', '1'),
('countries_australia_new_south_wales_leeville', 'ChIJOxl7H3sammsRwBpEkLQJBgQ', -28.9494691, 152.9757621, 'city', '1'),
('countries_australia_new_south_wales_leichhardt', 'ChIJcXTalRuwEmsR0L0yFmh9AQU', -33.8837222, 151.157028, 'city', '1'),
('countries_australia_new_south_wales_lemon_tree_passage', 'ChIJYZ4mnVV4c2sRcO8yFmh9AQU', -32.7325, 152.038333, 'city', '1'),
('countries_australia_new_south_wales_lenaghan', 'ChIJO-Tijao4c2sRgO8yFmh9AQU', -32.848, 151.629, 'city', '1'),
('countries_australia_new_south_wales_lennox_head', 'ChIJyy3PfF2HkGsRQPhDkLQJBgQ', -28.8, 153.583333, 'city', '1'),
('countries_australia_new_south_wales_leonay', 'ChIJt5z3WuqIEmsRINUyFmh9AQU', -33.76506, 150.64568, 'city', '1'),
('countries_australia_new_south_wales_leppington', 'ChIJ82UJM5HtEmsR8L0yFmh9AQU', -33.965, 150.801, 'city', '1'),
('countries_australia_new_south_wales_lethbridge_park', 'ChIJwYI9hRybEmsRAL4yFmh9AQU', -33.7374293, 150.8013419, 'city', '1'),
('countries_australia_new_south_wales_leumeah', 'ChIJsXDiib_uEmsREL4yFmh9AQU', -34.05546, 150.83328, 'city', '1'),
('countries_australia_new_south_wales_leura', 'ChIJa__j6uNuEmsRMNUyFmh9AQU', -33.716667, 150.333333, 'city', '1'),
('countries_australia_new_south_wales_lewisham', 'ChIJ6cnlZnOwEmsRIL4yFmh9AQU', -33.8949, 151.144415, 'city', '1'),
('countries_australia_new_south_wales_leycester', 'ChIJ6_zhtISfkGsRUPhDkLQJBgQ', -28.7806097, 153.1855389, 'city', '1'),
('countries_australia_new_south_wales_liberty_grove', 'ChIJv5EwjNykEmsRsEAzFmh9AQU', -33.841667, 151.083611, 'city', '1'),
('countries_australia_new_south_wales_lidcombe', 'ChIJU-y7w167EmsRQL4yFmh9AQU', -33.865214, 151.0435043, 'city', '1'),
('countries_australia_new_south_wales_lidster', 'ChIJlw2ZES8uEGsR0HpDkLQJBgQ', -33.2947339, 148.9535899, 'city', '1'),
('countries_australia_new_south_wales_lightning_ridge', 'ChIJoyrmlmmUqGsR8AREkLQJBgQ', -29.4312089, 147.9808672, 'city', '1'),
('countries_australia_new_south_wales_lillian_rock', 'ChIJSaBEA_u9kGsRYPhDkLQJBgQ', -28.5372034, 153.161976, 'city', '1'),
('countries_australia_new_south_wales_lilli_pilli', 'ChIJIXtS8srHEmsRUL4yFmh9AQU', -34.068333, 151.115833, 'city', '1'),
('countries_australia_new_south_wales_lilyfield', 'ChIJhQjePOevEmsRYL4yFmh9AQU', -33.874345, 151.164693, 'city', '1'),
('countries_australia_new_south_wales_limpinwood', 'ChIJXx_4lRnokGsRcPhDkLQJBgQ', -28.3237928, 153.2252987, 'city', '1'),
('countries_australia_new_south_wales_linden', 'ChIJiRJKeFJjEmsRQNUyFmh9AQU', -33.715556, 150.496111, 'city', '1'),
('countries_australia_new_south_wales_lindfield', 'ChIJ6d8pr8CoEmsRcL4yFmh9AQU', -33.7787851, 151.1693413, 'city', '1'),
('countries_australia_new_south_wales_lisarow', 'ChIJQRJDsqTLcmsR8NoyFmh9AQU', -33.382, 151.376, 'city', '1'),
('countries_australia_new_south_wales_lismore', 'ChIJC-4Phg-ekGsRYCtEkLQJBgU', -28.8093154, 153.2882876, 'city', '1'),
('countries_australia_new_south_wales_lismore_heights', 'ChIJK5vWLeKdkGsRcCtEkLQJBgU', -28.801434, 153.3004522, 'city', '1'),
('countries_spain_castille_and_leon_fuentesnuevas', 'ChIJneFN9r67MA0RCuF0w-zEAZ4', 42.572708, -6.6399907, 'city', '1'),
('countries_australia_new_south_wales_littleton', 'ChIJH7kFvckLEmsRsCFEkLQJBgU', -33.4958431, 150.1401762, 'city', '1'),
('countries_australia_new_south_wales_little_bay', 'ChIJPzmX7Qi0EmsRkL4yFmh9AQU', -33.98054, 151.24301, 'city', '1'),
('countries_australia_new_south_wales_little_billabong', 'ChIJTfsJXvxcImsRgOtDkLQJBgQ', -35.6385344, 147.5086986, 'city', '1'),
('countries_australia_new_south_wales_little_forest', 'ChIJa7ZUeFlFFGsRAAtEkLQJBgQ', -35.2978715, 150.361674, 'city', '1'),
('countries_australia_new_south_wales_little_hartley', 'ChIJv6EMBtoMEmsRIEQzFmh9AQU', -33.590286, 150.1937088, 'city', '1'),
('countries_australia_new_south_wales_liverpool', 'ChIJlUEtsBCWEmsRoL4yFmh9AQU', -33.9285567, 150.9179595, 'city', '1'),
('countries_australia_new_south_wales_llanarth', 'ChIJaW5HNpfmEWsRwCJEkLQJBgU', -33.3954114, 149.5498347, 'city', '1'),
('countries_australia_new_south_wales_llandilo', 'ChIJFy7GJMeEEmsRsL4yFmh9AQU', -33.7061, 150.7453, 'city', '1'),
('countries_australia_new_south_wales_lloyd', 'ChIJoREYp0KfGGsRUCZEkLQJBgU', -35.1509869, 147.3213992, 'city', '1'),
('countries_australia_new_south_wales_lochiel', 'ChIJe4acGF8cPGsREAtEkLQJBgQ', -36.9622592, 149.8125624, 'city', '1'),
('countries_australia_new_south_wales_lochinvar', 'ChIJcajcYc1Oc2sRoO8yFmh9AQU', -32.7, 151.45, 'city', '1'),
('countries_australia_new_south_wales_lockhart', 'ChIJv3fHk-zzIWsREM1DkLQJBgQ', -35.2224975, 146.717338, 'city', '1'),
('countries_australia_new_south_wales_locksley', 'ChIJA65FzUf4EWsREGZDkLQJBgQ', -33.5270303, 149.8039085, 'city', '1'),
('countries_australia_new_south_wales_loftus', 'ChIJN_SgWSHBEmsRwL4yFmh9AQU', -34.0465, 151.0471, 'city', '1'),
('countries_australia_new_south_wales_loftville', 'ChIJiTa2v6N1mmsRgCtEkLQJBgU', -28.8358248, 153.2591948, 'city', '1'),
('countries_australia_new_south_wales_logans_crossing', 'ChIJ7ZM3uaLkdWsRAKVDkLQJBgQ', -31.6090915, 152.7000585, 'city', '1'),
('countries_australia_new_south_wales_londonderry', 'ChIJkfCmfheDEmsR0L4yFmh9AQU', -33.6485, 150.7355, 'city', '1'),
('countries_australia_new_south_wales_longueville', 'ChIJS5s9wA2vEmsR8L4yFmh9AQU', -33.83309, 151.16494, 'city', '1'),
('countries_australia_new_south_wales_long_beach', 'ChIJK5Pnzp2_FWsRoChEkLQJBgU', -35.6866084, 150.2284437, 'city', '1'),
('countries_australia_new_south_wales_long_jetty', 'ChIJY6Ty3o3PcmsRINsyFmh9AQU', -33.357, 151.485, 'city', '1'),
('countries_australia_new_south_wales_long_point', 'ChIJ_-iX3AfrEmsR4L4yFmh9AQU', -34.012, 150.897, 'city', '1'),
('countries_australia_new_south_wales_loomberah', 'ChIJd5s_oVSRCmsRYMFDkLQJBgQ', -31.2419782, 150.9561771, 'city', '1'),
('countries_australia_new_south_wales_lorn', 'ChIJrQxg1zlEc2sRsO8yFmh9AQU', -32.7266681, 151.5749274, 'city', '1'),
('countries_australia_new_south_wales_lostock', 'ChIJL4OUzqKudGsRoIVDkLQJBgQ', -32.3123081, 151.4592345, 'city', '1'),
('countries_australia_new_south_wales_louth_park', 'ChIJWcQyjFFGc2sRwO8yFmh9AQU', -32.765694, 151.5544836, 'city', '1'),
('countries_australia_new_south_wales_lovedale', 'ChIJhXyESH41c2sREEMzFmh9AQU', -32.7646282, 151.3618529, 'city', '1'),
('countries_australia_new_south_wales_lowanna', 'ChIJN1uHI58GnGsRQJdDkLQJBgQ', -30.2022199, 152.8997591, 'city', '1'),
('countries_spain_castille_and_leon_frias', 'ChIJnwUw67ltTw0RyKK4fyJbOQk', 42.748448, -3.2885455, 'city', '0'),
('countries_australia_new_south_wales_lower_mangrove', 'ChIJw9JF4d5HDWsRMNsyFmh9AQU', -33.415, 151.16, 'city', '1'),
('countries_australia_new_south_wales_lower_portland', 'ChIJUbDElNxoDWsRUEgzFmh9AQU', -33.442, 150.879, 'city', '1'),
('countries_australia_new_south_wales_lower_southgate', 'ChIJHb8nRdzNm2sR4BpEkLQJBgQ', -29.5231956, 153.0876182, 'city', '1'),
('countries_australia_new_south_wales_lowesdale', 'ChIJiebcK28YIWsRMM1DkLQJBgQ', -35.8309069, 146.3537506, 'city', '1'),
('countries_australia_new_south_wales_loxford', 'ChIJ_Q3GhddJc2sR0O8yFmh9AQU', -32.7898364, 151.4844099, 'city', '1'),
('countries_australia_new_south_wales_lucknow', 'ChIJlf8VPZ3SEWsRQGZDkLQJBgQ', -33.3548169, 149.1673337, 'city', '1'),
('countries_australia_new_south_wales_luddenham', 'ChIJ0Xa5hl2OEmsRQL8yFmh9AQU', -33.8807, 150.7146, 'city', '1'),
('countries_australia_new_south_wales_lugarno', 'ChIJV_f_hDK_EmsRUL8yFmh9AQU', -33.98469, 151.04352, 'city', '1'),
('countries_australia_new_south_wales_lurnea', 'ChIJUyHhGPqUEmsRYL8yFmh9AQU', -33.9326, 150.900826, 'city', '1'),
('countries_australia_new_south_wales_lyndhurst', 'ChIJ-wdzsWtREGsRYGZDkLQJBgQ', -33.666667, 149.033333, 'city', '1'),
('countries_australia_new_south_wales_macksville', 'ChIJuUgJG_crnGsRYC1EkLQJBgU', -30.716667, 152.916667, 'city', '1'),
('countries_australia_new_south_wales_maclean', 'ChIJIeif_ohKmmsREB9EkLQJBgU', -29.4486305, 153.214752, 'city', '1'),
('countries_australia_new_south_wales_macquarie_fields', 'ChIJnV76jD3rEmsRcL8yFmh9AQU', -33.99434, 150.88757, 'city', '1'),
('countries_australia_new_south_wales_macquarie_hills', 'ChIJ95_yUkg8c2sR8O8yFmh9AQU', -32.953, 151.65, 'city', '1'),
('countries_australia_new_south_wales_macquarie_links', 'ChIJX7QPrUTrEmsRoDgzFmh9AQU', -33.982, 150.874, 'city', '1'),
('countries_australia_new_south_wales_macquarie_park', 'ChIJgSpbR3amEmsRgL8yFmh9AQU', -33.7810467, 151.122968, 'city', '1'),
('countries_australia_new_south_wales_maffra', 'ChIJg1YlmM_xPGsR8N9DkLQJBgQ', -36.582283, 148.9551901, 'city', '1'),
('countries_australia_new_south_wales_magenta', 'ChIJvaz3lBXacmsRUNsyFmh9AQU', -33.299, 151.543, 'city', '1'),
('countries_australia_new_south_wales_maianbar', 'ChIJ2ZRJzDHGEmsRkL8yFmh9AQU', -34.0764794, 151.1272123, 'city', '1'),
('countries_australia_new_south_wales_maitland', 'ChIJddSU9NZFc2sRAPAyFmh9AQU', -32.7383988, 151.5492182, 'city', '1'),
('countries_australia_new_south_wales_maitland_vale', 'ChIJyxt2YSJFc2sREPAyFmh9AQU', -32.672368, 151.5544836, 'city', '1'),
('countries_australia_new_south_wales_majors_creek', 'ChIJk_lclHdzFmsRIAtEkLQJBgQ', -35.571111, 149.738889, 'city', '1'),
('countries_australia_new_south_wales_malabar', 'ChIJC6vmVOqzEmsRoL8yFmh9AQU', -33.9656, 151.2487, 'city', '1'),
('countries_australia_new_south_wales_mallabula', 'ChIJsUCYOaR5c2sRIPAyFmh9AQU', -32.735, 152.01, 'city', '1'),
('countries_australia_new_south_wales_mallanganee', 'ChIJjfxSlBX3mWsRAPlDkLQJBgQ', -28.9076761, 152.721835, 'city', '1'),
('countries_australia_new_south_wales_mallowa', 'ChIJD7aSeBrrpmsRoLpDkLQJBgQ', -29.6622099, 149.3263196, 'city', '1'),
('countries_australia_new_south_wales_maloneys_beach', 'ChIJv6KdxKu_FWsRsChEkLQJBgU', -35.7011415, 150.2545005, 'city', '1'),
('countries_australia_new_south_wales_malua_bay', 'ChIJ63R6rObqFWsRMAtEkLQJBgQ', -35.7930082, 150.2168644, 'city', '1'),
('countries_australia_new_south_wales_mandalong', 'ChIJDY-c1Cwoc2sRYNsyFmh9AQU', -33.132, 151.426, 'city', '1'),
('countries_australia_new_south_wales_mandemar', 'ChIJGZVslmm-E2sRAPkGgcLfxmQ', -34.433333, 150.283333, 'city', '1'),
('countries_australia_new_south_wales_mandurama', 'ChIJn0XwPJZREGsRgGZDkLQJBgQ', -33.6648444, 149.0403333, 'city', '1'),
('countries_australia_new_south_wales_mangerton', 'ChIJEWHwUZAZE2sRYOQyFmh9AQU', -34.4327791, 150.8711127, 'city', '1'),
('countries_australia_new_south_wales_mangoplah', 'ChIJewmhbdETImsRcM1DkLQJBgQ', -35.413985, 147.2359909, 'city', '1'),
('countries_australia_new_south_wales_mangrove_creek', 'ChIJTapNjCI4DWsRUEQzFmh9AQU', -33.3575414, 151.1452039, 'city', '1'),
('countries_australia_new_south_wales_mangrove_mountain', 'ChIJl8hCZDYxDWsRcNsyFmh9AQU', -33.299, 151.193, 'city', '1'),
('countries_australia_new_south_wales_manildra', 'ChIJtxzvC8EZEGsREHtDkLQJBgQ', -33.1811485, 148.688016, 'city', '1'),
('countries_australia_new_south_wales_manilla', 'ChIJLYDjKbFloGsRgMFDkLQJBgQ', -30.7314993, 150.7250673, 'city', '1'),
('countries_australia_new_south_wales_manly', 'ChIJfX8VVbCrEmsRsL8yFmh9AQU', -33.8060158, 151.2947775, 'city', '1'),
('countries_australia_new_south_wales_manly_vale', 'ChIJB-vL7cerEmsRwL8yFmh9AQU', -33.783, 151.2622, 'city', '1'),
('countries_australia_new_south_wales_mannering_park', 'ChIJe9rHfWXYcmsRkNsyFmh9AQU', -33.148, 151.535, 'city', '1'),
('countries_australia_new_south_wales_manyana', 'ChIJXTlTHDdZFGsRUNdDkLQJBgQ', -35.25, 150.516667, 'city', '1'),
('countries_australia_new_south_wales_maraylya', 'ChIJ35ghF-ZgDWsR0L8yFmh9AQU', -33.59775, 150.91609, 'city', '1'),
('countries_australia_new_south_wales_marayong', 'ChIJ2zuoiBaZEmsR4L8yFmh9AQU', -33.7495256, 150.8929227, 'city', '1'),
('countries_australia_new_south_wales_mardi', 'ChIJM8Zzu-3NcmsRoNsyFmh9AQU', -33.29, 151.41, 'city', '1'),
('countries_australia_new_south_wales_marks_point', 'ChIJ5Y2DY64jc2sRQPAyFmh9AQU', -33.06, 151.651, 'city', '1'),
('countries_australia_new_south_wales_marmong_point', 'ChIJSbN9oZg8c2sRUPAyFmh9AQU', -32.982, 151.618, 'city', '1'),
('countries_australia_new_south_wales_marom_creek', 'ChIJWVED3z53mmsREPlDkLQJBgQ', -28.9293277, 153.3564564, 'city', '1'),
('countries_australia_new_south_wales_maroota', 'ChIJX2SbQYhCDWsRYEgzFmh9AQU', -33.4540456, 150.9889238, 'city', '1'),
('countries_australia_new_south_wales_maroubra', 'ChIJaUVuF86zEmsRAMAyFmh9AQU', -33.9495, 151.2437, 'city', '1'),
('countries_australia_new_south_wales_marrar', 'ChIJXwD2BiDsGGsRgM1DkLQJBgQ', -34.8333, 147.3667, 'city', '1'),
('countries_australia_new_south_wales_marrickville', 'ChIJGUHmdmSwEmsREMAyFmh9AQU', -33.908667, 151.1524142, 'city', '1'),
('countries_australia_new_south_wales_marsden', 'ChIJPXv06febEmsRIMAyFmh9AQU', -33.68908, 150.80285, 'city', '1'),
('countries_australia_new_south_wales_marsden_park', 'ChIJPXv06febEmsRIMAyFmh9AQU', -33.68908, 150.80285, 'city', '1'),
('countries_australia_new_south_wales_marsfield', 'ChIJiZAz2HmmEmsRMMAyFmh9AQU', -33.7800906, 151.1029137, 'city', '1'),
('countries_australia_new_south_wales_marshdale', 'ChIJK7jW3S2adGsRMIZDkLQJBgQ', -32.43499, 151.7977788, 'city', '1'),
('countries_australia_new_south_wales_marthaguy', 'ChIJ0XlPQKd6BmsRUHNDkLQJBgQ', -31.4647465, 147.8910483, 'city', '1'),
('countries_australia_new_south_wales_martinsville', 'ChIJcy9XwwMuc2sRcEEzFmh9AQU', -33.0594727, 151.409327, 'city', '1'),
('countries_australia_new_south_wales_marulan', 'ChIJK2m_OKHwE2sRMOBDkLQJBgQ', -34.716656, 150.0005338, 'city', '1'),
('countries_australia_new_south_wales_maryland', 'ChIJoTsv0FI_c2sRYPAyFmh9AQU', -32.877127, 151.6613528, 'city', '1'),
('countries_australia_new_south_wales_maryville', 'ChIJHfLj31cUc2sRcPAyFmh9AQU', -32.9120591, 151.7546471, 'city', '1'),
('countries_australia_new_south_wales_mascot', 'ChIJz-9y-iGxEmsRQMAyFmh9AQU', -33.9285775, 151.1871697, 'city', '1'),
('countries_australia_new_south_wales_matcham', 'ChIJa79BYC_KcmsRwNsyFmh9AQU', -33.4163854, 151.4210202, 'city', '1'),
('countries_australia_new_south_wales_mathoura', 'ChIJ5cGP_fvZ2GoRkM1DkLQJBgQ', -35.8130077, 144.9028923, 'city', '1'),
('countries_australia_new_south_wales_matraville', 'ChIJEezIEXWxEmsRUMAyFmh9AQU', -33.9613, 151.2315, 'city', '1'),
('countries_australia_new_south_wales_maybole', 'ChIJ547Cz6ROn2sRcLNDkLQJBgQ', -29.910453, 151.5830588, 'city', '1'),
('countries_australia_new_south_wales_mayfield', 'ChIJ94_wyBoVc2sRgPAyFmh9AQU', -32.89742, 151.73643, 'city', '1'),
('countries_australia_new_south_wales_mayfield_east', 'ChIJ6TEK5OIUc2sRkPAyFmh9AQU', -32.9000229, 151.7501418, 'city', '1'),
('countries_australia_new_south_wales_mayfield_north', 'ChIJ-ejO4-M_c2sRoPAyFmh9AQU', -32.8903061, 151.7440956, 'city', '1'),
('countries_australia_new_south_wales_mayfield_west', 'ChIJFwz5tWoVc2sRsPAyFmh9AQU', -32.8897508, 151.7262935, 'city', '1'),
('countries_australia_new_south_wales_mays_hill', 'ChIJOxDGtNqiEmsRYMAyFmh9AQU', -33.8201717, 150.9908454, 'city', '1'),
('countries_australia_new_south_wales_mccullys_gap', 'ChIJJym5w7lCC2sRcIZDkLQJBgQ', -32.208248, 150.9898829, 'city', '1'),
('countries_australia_new_south_wales_mcdougalls_hill', 'ChIJqVeQfQ-wDGsRwCBEkLQJBgU', -32.5470013, 151.1418422, 'city', '1'),
('countries_australia_new_south_wales_mcgraths_hill', 'ChIJabzkkfKdEmsRcMAyFmh9AQU', -33.6179506, 150.8419976, 'city', '1'),
('countries_australia_new_south_wales_mckees_hill', 'ChIJU3HEZsx0mmsRIPlDkLQJBgQ', -28.8816305, 153.1989049, 'city', '1'),
('countries_australia_new_south_wales_mckellars_park', 'ChIJT4OPMmYKEmsRwCFEkLQJBgU', -33.4700452, 150.1533181, 'city', '1'),
('countries_australia_new_south_wales_mcleans_ridges', 'ChIJ88hQ6BmdkGsRMPlDkLQJBgQ', -28.797548, 153.3835835, 'city', '1'),
('countries_australia_new_south_wales_mcleods_shoot', 'ChIJM2y_ISOIkGsRQPlDkLQJBgQ', -28.6546776, 153.5512686, 'city', '1'),
('countries_australia_new_south_wales_mcmahons_point', 'ChIJtwxfFfauEmsRgMAyFmh9AQU', -33.844619, 151.2042612, 'city', '1'),
('countries_australia_new_south_wales_mcmasters_beach', 'ChIJu9AJ1i20cmsRQNsyFmh9AQU', -33.4967169, 151.4114482, 'city', '1'),
('countries_australia_new_south_wales_meadowbank', 'ChIJjeJi5FWkEmsRkMAyFmh9AQU', -33.8157836, 151.0896983, 'city', '1'),
('countries_australia_new_south_wales_meadow_flat', 'ChIJIWo9tmgBEmsRwGZDkLQJBgQ', -33.435011, 149.9211831, 'city', '1'),
('countries_australia_new_south_wales_medlow_bath', 'ChIJqyNmcXVuEmsRUNUyFmh9AQU', -33.6723458, 150.2802141, 'city', '1'),
('countries_australia_new_south_wales_medowie', 'ChIJtxQo6flvc2sRwPAyFmh9AQU', -32.7415092, 151.8674591, 'city', '1'),
('countries_australia_new_south_wales_medway', 'ChIJP_APabeWE2sRQJBDkLQJBgQ', -34.4940976, 150.2882412, 'city', '1'),
('countries_australia_new_south_wales_meerschaum_vale', 'ChIJ1ThUq5N5mmsRYPlDkLQJBgQ', -28.9117787, 153.436799, 'city', '1'),
('countries_australia_new_south_wales_melrose_park', 'ChIJ6SQHY1ikEmsRoMAyFmh9AQU', -33.8145781, 151.0718821, 'city', '1'),
('countries_australia_new_south_wales_menah', 'ChIJ60hnzq6ODmsR8GZDkLQJBgQ', -32.5416605, 149.5355903, 'city', '1'),
('countries_australia_new_south_wales_menai', 'ChIJmx091s--EmsRsMAyFmh9AQU', -34.0118, 151.0089, 'city', '1'),
('countries_australia_new_south_wales_menangle', 'ChIJ2QcJGu7vEmsRgDwzFmh9AQU', -34.127258, 150.738731, 'city', '1'),
('countries_australia_new_south_wales_mendooran', 'ChIJPSYS8KDVCGsRQHtDkLQJBgQ', -31.8342173, 149.1208983, 'city', '1'),
('countries_australia_new_south_wales_menindee', 'ChIJ14_JJN7p5WoRwAFEkLQJBgQ', -32.3985324, 142.4139158, 'city', '1'),
('countries_australia_new_south_wales_merah_north', 'ChIJj_VDlXkMp2sRsLpDkLQJBgQ', -30.1366069, 149.3048856, 'city', '1'),
('countries_australia_new_south_wales_merewether', 'ChIJLesqyNYVc2sR4PAyFmh9AQU', -32.942778, 151.7525, 'city', '1'),
('countries_australia_new_south_wales_merewether_heights', 'ChIJNUF3vdkVc2sR8PAyFmh9AQU', -32.949, 151.735, 'city', '1'),
('countries_australia_new_south_wales_merimbula', 'ChIJly-AYE6gPmsRgDFEkLQJBgU', -36.8875485, 149.9058748, 'city', '1'),
('countries_australia_new_south_wales_meringo', 'ChIJDQZqfqX2FWsRYAtEkLQJBgQ', -35.979641, 150.1358366, 'city', '1'),
('countries_australia_new_south_wales_meroo', 'ChIJHSgePUlkDmsRAGdDkLQJBgQ', -32.7663358, 149.5923122, 'city', '1'),
('countries_australia_new_south_wales_meroo_meadow', 'ChIJ-SGyQzZ_E2sRQEUzFmh9AQU', -34.8162699, 150.6110918, 'city', '1'),
('countries_australia_new_south_wales_merricumbene', 'ChIJU4yhn2ziFWsRcAtEkLQJBgQ', -35.7272813, 149.8738582, 'city', '1'),
('countries_australia_new_south_wales_merriwa', 'ChIJ57GVD4ztC2sRkIZDkLQJBgQ', -32.1393377, 150.3557351, 'city', '1'),
('countries_australia_new_south_wales_merriwagga', 'ChIJ_yTJz-U8HmsRAM5DkLQJBgQ', -33.8161555, 145.6238463, 'city', '1'),
('countries_australia_new_south_wales_merrylands', 'ChIJN2pFtzO9EmsR0MAyFmh9AQU', -33.835802, 150.9865196, 'city', '1'),
('countries_australia_new_south_wales_merrylands_west', 'ChIJgdOGYkW9EmsR4MAyFmh9AQU', -33.83742, 150.96168, 'city', '1'),
('countries_australia_new_south_wales_merungle_hill', 'ChIJoWmKAl4TH2sREM5DkLQJBgQ', -34.6, 146.433333, 'city', '1'),
('countries_australia_new_south_wales_metford', 'ChIJ97L3GU1Bc2sRAPEyFmh9AQU', -32.7664015, 151.6099796, 'city', '1'),
('countries_australia_new_south_wales_michelago', 'ChIJ3a6k5cgoFmsRgOBDkLQJBgQ', -35.7408986, 149.1831282, 'city', '1'),
('countries_australia_new_south_wales_middleton_grange', 'ChIJabetXpmTEmsREEczFmh9AQU', -33.915, 150.842, 'city', '1'),
('countries_australia_new_south_wales_middle_arm', 'ChIJMQadd_ZSEWsRkOBDkLQJBgQ', -34.6188095, 149.731981, 'city', '1'),
('countries_australia_new_south_wales_middle_cove', 'ChIJjxUd80OpEmsR8MAyFmh9AQU', -33.7938, 151.2086, 'city', '1'),
('countries_australia_new_south_wales_middle_dural', 'ChIJVy6DngRfDWsRAMEyFmh9AQU', -33.6408817, 151.0180269, 'city', '1'),
('countries_australia_new_south_wales_middlingbank', 'ChIJIy_9ZgocPWsRQBNEkLQJBgQ', -36.2293677, 148.8593901, 'city', '1'),
('countries_australia_new_south_wales_milbrodale', 'ChIJY02e3iWVDGsRwIZDkLQJBgQ', -32.6937112, 150.9983817, 'city', '1'),
('countries_australia_new_south_wales_miller', 'ChIJbcHP62aUEmsREMEyFmh9AQU', -33.9268, 150.8724, 'city', '1'),
('countries_australia_new_south_wales_millers_forest', 'ChIJN7BbBuFpc2sREPEyFmh9AQU', -32.7615492, 151.7064109, 'city', '1'),
('countries_australia_new_south_wales_millers_point', 'ChIJe3b-M1yuEmsRIMEyFmh9AQU', -33.86085, 151.20281, 'city', '1'),
('countries_australia_new_south_wales_millfield', 'ChIJbdl3FrDNDGsR0IZDkLQJBgQ', -32.8803534, 151.245218, 'city', '1'),
('countries_australia_new_south_wales_millingandi', 'ChIJuyI9r26gPmsRgAtEkLQJBgQ', -36.8824629, 149.852617, 'city', '1'),
('countries_australia_new_south_wales_millthorpe', 'ChIJYSzE9grMEWsRQGdDkLQJBgQ', -33.45, 149.183333, 'city', '1'),
('countries_australia_new_south_wales_milparinka', 'ChIJVyvArZM_8WoR8ABEkLQJBgQ', -29.7376024, 141.8831655, 'city', '1'),
('countries_australia_new_south_wales_milperra', 'ChIJJSpJzUW-EmsRMMEyFmh9AQU', -33.9370869, 150.9827465, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_australia_new_south_wales_milroy', 'ChIJTdIqgRGJDmsRUGdDkLQJBgQ', -32.5918747, 149.6189801, 'city', '1'),
('countries_australia_new_south_wales_milsons_point', 'ChIJxUaE3oquEmsRQMEyFmh9AQU', -33.84765, 151.21201, 'city', '1'),
('countries_australia_new_south_wales_milton', 'ChIJw38U2kBQFGsRkAtEkLQJBgQ', -35.3193792, 150.4390623, 'city', '1'),
('countries_australia_new_south_wales_mimosa', 'ChIJ6aeSGBscGWsRQM5DkLQJBgQ', -34.44133, 147.4051189, 'city', '1'),
('countries_australia_new_south_wales_minchinbury', 'ChIJ6UraBYmaEmsRUMEyFmh9AQU', -33.7896243, 150.8369469, 'city', '1'),
('countries_australia_new_south_wales_mindaribba', 'ChIJRwLg19FEc2sRMPEyFmh9AQU', -32.6557378, 151.58442, 'city', '1'),
('countries_australia_new_south_wales_minimbah', 'ChIJmz766QNPdGsR0KVDkLQJBgQ', -32.1610459, 152.3741183, 'city', '1'),
('countries_australia_new_south_wales_minmi', 'ChIJg78tZSY_c2sRQPEyFmh9AQU', -32.882, 151.618, 'city', '1'),
('countries_australia_new_south_wales_minnamurra', 'ChIJVdbl045xE2sRcOQyFmh9AQU', -34.625, 150.851944, 'city', '1'),
('countries_australia_new_south_wales_minnie_water', 'ChIJ93FQs-O4m2sRABtEkLQJBgQ', -29.7765148, 153.2982025, 'city', '1'),
('countries_australia_new_south_wales_minto', 'ChIJ_2fVPn3sEmsRYMEyFmh9AQU', -34.02646, 150.8507, 'city', '1'),
('countries_australia_new_south_wales_minto_heights', 'ChIJny-4BfDrEmsRcMEyFmh9AQU', -34.031, 150.8743, 'city', '1'),
('countries_australia_new_south_wales_mirador', 'ChIJP4jNT72fPmsRoAtEkLQJBgQ', -36.8789153, 149.9190336, 'city', '1'),
('countries_australia_new_south_wales_miranda', 'ChIJjZflckW4EmsRgMEyFmh9AQU', -34.0299364, 151.1055499, 'city', '1'),
('countries_australia_new_south_wales_mirannie', 'ChIJWTSHRwGrdGsR8IZDkLQJBgQ', -32.4373423, 151.3669576, 'city', '1'),
('countries_australia_new_south_wales_mirrabooka', 'ChIJ1y9IB1kmc2sR0NsyFmh9AQU', -33.1140122, 151.5559438, 'city', '1'),
('countries_australia_new_south_wales_mirrool', 'ChIJ7ciwOAc3GWsRUM5DkLQJBgQ', -34.3101715, 147.0955059, 'city', '1'),
('countries_australia_new_south_wales_missabotti', 'ChIJay7yR6eCnmsRgJdDkLQJBgQ', -30.5821158, 152.8219141, 'city', '1'),
('countries_spain_castille_and_leon_el_espinar', 'ChIJMWpRhR4QQQ0RUD31WgeHBQQ', 40.7404915, -4.2128337, 'city', '0'),
('countries_australia_new_south_wales_mitchells_flat', 'ChIJ0wAH5FZNc2sRAIdDkLQJBgQ', -32.5550272, 151.2818024, 'city', '1'),
('countries_australia_new_south_wales_mitchells_island', 'ChIJ-RVtOdDadWsR4KVDkLQJBgQ', -31.9, 152.616667, 'city', '1'),
('countries_australia_new_south_wales_mittagong', 'ChIJP4r2rXKhE2sRUCREkLQJBgU', -34.45, 150.45, 'city', '1'),
('countries_australia_new_south_wales_moama', 'ChIJuXe3la8h2WoRYM5DkLQJBgQ', -36.1074189, 144.7554298, 'city', '1'),
('countries_australia_new_south_wales_modanville', 'ChIJ0em4SE-ZkGsRkPlDkLQJBgQ', -28.715278, 153.301111, 'city', '1'),
('countries_australia_new_south_wales_mogareeka', 'ChIJj0VH97OGPmsRsAtEkLQJBgQ', -36.6938086, 149.9768139, 'city', '1'),
('countries_australia_new_south_wales_mogo', 'ChIJga5v8JruFWsR4AtEkLQJBgQ', -35.783333, 150.133333, 'city', '1'),
('countries_australia_new_south_wales_mollymook', 'ChIJ6wny9cFQFGsRwDFEkLQJBgU', -35.3407606, 150.4703786, 'city', '1'),
('countries_australia_new_south_wales_molong', 'ChIJadDgKLwnEGsRgHtDkLQJBgQ', -33.0910485, 148.8568255, 'city', '1'),
('countries_australia_new_south_wales_monaltrie', 'ChIJ7fDytoZ1mmsRkCtEkLQJBgU', -28.8495596, 153.2857165, 'city', '1'),
('countries_australia_new_south_wales_mona_vale', 'ChIJOTJee5dUDWsRkMEyFmh9AQU', -33.67596, 151.30653, 'city', '1'),
('countries_australia_new_south_wales_mondrook', 'ChIJd2sqZFC2dWsRoC5EkLQJBgU', -31.9071535, 152.4093285, 'city', '1'),
('countries_australia_new_south_wales_mongarlowe', 'ChIJZTYT9ArTFWsRIAxEkLQJBgQ', -35.4, 149.939, 'city', '1'),
('countries_australia_new_south_wales_mongogarie', 'ChIJ2311dPAcmmsRIBtEkLQJBgQ', -28.985958, 152.8843514, 'city', '1'),
('countries_australia_new_south_wales_monteagle', 'ChIJue0BncgAGmsRMOxDkLQJBgQ', -34.2049854, 148.3307601, 'city', '1'),
('countries_australia_new_south_wales_montefiores', 'ChIJmQ7CYjWvD2sR4B9EkLQJBgU', -32.5284872, 148.9378251, 'city', '1'),
('countries_australia_new_south_wales_monterey', 'ChIJ_5fzDVC3EmsRoMEyFmh9AQU', -33.9738, 151.1479, 'city', '1'),
('countries_australia_new_south_wales_mooball', 'ChIJl1A5J1rxkGsRsPlDkLQJBgQ', -28.4337022, 153.4921029, 'city', '1'),
('countries_australia_new_south_wales_moobi', 'ChIJh9L9obhtC2sRMIdDkLQJBgQ', -32.0684677, 150.8035218, 'city', '1'),
('countries_australia_new_south_wales_moonan_flat', 'ChIJpw8uWG0uC2sRUIdDkLQJBgQ', -31.9258438, 151.2082628, 'city', '1'),
('countries_australia_new_south_wales_moonbah', 'ChIJN6FpNNPHPGsRUBNEkLQJBgQ', -36.4758389, 148.600815, 'city', '1'),
('countries_australia_new_south_wales_moonbi', 'ChIJ7d_LleMLoGsR0MFDkLQJBgQ', -31.016667, 151.066667, 'city', '1'),
('countries_australia_new_south_wales_moonee_beach', 'ChIJxbulTuYLnGsRoJdDkLQJBgQ', -30.1895467, 153.1501948, 'city', '1'),
('countries_australia_new_south_wales_mooney_mooney', 'ChIJ-4GCRcxPDWsRANwyFmh9AQU', -33.523, 151.201, 'city', '1'),
('countries_australia_new_south_wales_moorbel', 'ChIJHc1ArsBnEGsRkHtDkLQJBgQ', -33.5585988, 148.6973117, 'city', '1'),
('countries_spain_castille_and_leon_columbrianos', 'ChIJTxOLl0i6MA0R2CXxcoWUvRk', 42.572158, -6.611061, 'city', '0'),
('countries_australia_new_south_wales_moorebank', 'ChIJM7h9PXeVEmsRwMEyFmh9AQU', -33.9397082, 150.9249864, 'city', '1'),
('countries_australia_new_south_wales_moorong', 'ChIJ25RItlOfGGsRYCZEkLQJBgU', -35.114067, 147.315267, 'city', '1'),
('countries_australia_new_south_wales_moree', 'ChIJ6SQyGJhyp2sR0LpDkLQJBgQ', -29.465833, 149.833889, 'city', '1'),
('countries_australia_new_south_wales_morisset', 'ChIJn0I8ohEoc2sRINwyFmh9AQU', -33.115, 151.501, 'city', '1'),
('countries_australia_new_south_wales_mororo', 'ChIJs1gtwjxImmsRQBtEkLQJBgQ', -29.3417952, 153.2172087, 'city', '1'),
('countries_australia_new_south_wales_morpeth', 'ChIJmZDY_lVBc2sRgPEyFmh9AQU', -32.726111, 151.631667, 'city', '1'),
('countries_australia_new_south_wales_mortdale', 'ChIJBzDE9Bi5EmsR8MEyFmh9AQU', -33.96932, 151.06969, 'city', '1'),
('countries_australia_new_south_wales_mortlake', 'ChIJg5_teBelEmsRAMIyFmh9AQU', -33.8405772, 151.1060971, 'city', '1'),
('countries_australia_new_south_wales_morton', 'ChIJjX6c8aZMFGsRQAxEkLQJBgQ', -35.4167927, 150.3461016, 'city', '1'),
('countries_australia_new_south_wales_mortons_creek', 'ChIJc5-srnH4dWsRMKZDkLQJBgQ', -31.3786269, 152.6501045, 'city', '1'),
('countries_australia_new_south_wales_morundah', 'ChIJh6jZ7v_SIWsR0M5DkLQJBgQ', -34.9365564, 146.3057095, 'city', '1'),
('countries_australia_new_south_wales_moruya', 'ChIJfyPnwyf3FWsRUAxEkLQJBgQ', -35.9073095, 150.0928052, 'city', '1'),
('countries_australia_new_south_wales_moruya_heads', 'ChIJJSKDEnnxFWsRYAxEkLQJBgQ', -35.9167897, 150.1340285, 'city', '1'),
('countries_australia_new_south_wales_morven', 'ChIJQyPeUu4wImsR4M5DkLQJBgQ', -35.6507562, 147.1289701, 'city', '1'),
('countries_australia_new_south_wales_mosman', 'ChIJo_-SrTusEmsREMIyFmh9AQU', -33.829075, 151.24409, 'city', '1'),
('countries_australia_new_south_wales_mossy_point', 'ChIJnxtiZGbsFWsRcAxEkLQJBgQ', -35.8300362, 150.1792385, 'city', '1'),
('countries_australia_new_south_wales_moss_vale', 'ChIJeS_YrkSXE2sRgJBDkLQJBgQ', -34.550571, 150.3964283, 'city', '1'),
('countries_australia_new_south_wales_mountain_creek', 'ChIJr07qOCvNI2sRgOxDkLQJBgQ', -35.7866818, 147.1594667, 'city', '1'),
('countries_australia_new_south_wales_mount_annan', 'ChIJU2Y0iVjlEmsRIMIyFmh9AQU', -34.065, 150.76, 'city', '1'),
('countries_australia_new_south_wales_mount_austin', 'ChIJyw-DZk-ZGGsRcCZEkLQJBgU', -35.136128, 147.352078, 'city', '1'),
('countries_australia_new_south_wales_mount_burrell', 'ChIJz9n3GfeVkGsRwPlDkLQJBgQ', -28.5, 153.216667, 'city', '1'),
('countries_australia_new_south_wales_mount_colah', 'ChIJ1Yw-Ey9YDWsRQMIyFmh9AQU', -33.670759, 151.1152582, 'city', '1'),
('countries_australia_new_south_wales_mount_david', 'ChIJJUS0zlWaEWsRwGdDkLQJBgQ', -33.8541303, 149.6110554, 'city', '1'),
('countries_australia_new_south_wales_mount_druitt', 'ChIJMzyom4-QEmsRMMIyFmh9AQU', -33.7722, 150.8194, 'city', '1'),
('countries_australia_new_south_wales_mount_elliot', 'ChIJZT9m8VHKcmsRQEQzFmh9AQU', -33.401, 151.388, 'city', '1'),
('countries_australia_new_south_wales_mount_hunter', 'ChIJE6Qqa-74EmsRYDwzFmh9AQU', -34.066667, 150.633333, 'city', '1'),
('countries_australia_new_south_wales_mount_hutton', 'ChIJz4hwrQ89c2sRoPEyFmh9AQU', -32.982, 151.671, 'city', '1'),
('countries_australia_new_south_wales_mount_keira', 'ChIJ09gmdNAbE2sRnvVmYFeaP_M', -34.4026988, 150.8564661, 'city', '1'),
('countries_australia_new_south_wales_mount_kembla', 'ChIJUXzey44QE2sRkOQyFmh9AQU', -34.442, 150.809, 'city', '1'),
('countries_australia_new_south_wales_mount_kuring_gai', 'ChIJe2yP6eFZDWsRUMIyFmh9AQU', -33.6414763, 151.1308651, 'city', '1'),
('countries_australia_new_south_wales_mount_lewis', 'ChIJl8GHg_a7EmsRYMIyFmh9AQU', -33.915, 151.051, 'city', '1'),
('countries_australia_new_south_wales_mount_marsden', 'ChIJ-ZX9847PDWsRAGhDkLQJBgQ', -32.9560031, 150.0627503, 'city', '1'),
('countries_australia_new_south_wales_mount_ousley', 'ChIJj2ftanQZE2sRoOQyFmh9AQU', -34.4003381, 150.8805633, 'city', '1'),
('countries_australia_new_south_wales_mount_pleasant', 'ChIJsZQ43WYZE2sRsOQyFmh9AQU', -34.3964937, 150.868205, 'city', '1'),
('countries_australia_new_south_wales_mount_pritchard', 'ChIJiRqD5DaUEmsRgMIyFmh9AQU', -33.898, 150.901, 'city', '1'),
('countries_australia_new_south_wales_mount_rankin', 'ChIJ39XxnyThEWsRIGhDkLQJBgQ', -33.33891, 149.5015843, 'city', '1'),
('countries_australia_new_south_wales_mount_riverview', 'ChIJoyXMlzCGEmsRYNUyFmh9AQU', -33.733333, 150.633333, 'city', '1'),
('countries_australia_new_south_wales_mount_russell', 'ChIJ93dbz5mKoWsR8MFDkLQJBgQ', -29.677778, 150.930556, 'city', '1'),
('countries_australia_new_south_wales_mount_saint_thomas', 'ChIJTTueX_EZE2sRwOQyFmh9AQU', -34.4412141, 150.8718397, 'city', '1'),
('countries_australia_new_south_wales_mount_thorley', 'ChIJrdaXMAC5DGsRoIdDkLQJBgQ', -32.6165279, 151.1521394, 'city', '1'),
('countries_australia_new_south_wales_mount_tomah', 'ChIJp6A8smZ4EmsRoEczFmh9AQU', -33.55, 150.416667, 'city', '1'),
('countries_australia_new_south_wales_mount_vernon', 'ChIJH1ua9oSREmsRkMIyFmh9AQU', -33.857, 150.81, 'city', '1'),
('countries_australia_new_south_wales_mount_victoria', 'ChIJLYIpMhBzEmsRcNUyFmh9AQU', -33.583333, 150.25, 'city', '1'),
('countries_australia_new_south_wales_mount_view', 'ChIJIZv1-HrLDGsRsDgzFmh9AQU', -32.85, 151.283333, 'city', '1'),
('countries_australia_new_south_wales_mount_vincent', 'ChIJBWqVEOMwc2sRsPEyFmh9AQU', -32.923576, 151.5019256, 'city', '1'),
('countries_australia_new_south_wales_mount_warning', 'ChIJtXhsIMfrkGsRNIofHNzkaVY', -28.3979788, 153.2719981, 'city', '1'),
('countries_australia_new_south_wales_mount_warrigal', 'ChIJHyHpn_ITE2sR0OQyFmh9AQU', -34.546667, 150.843333, 'city', '1'),
('countries_spain_castille_and_leon_cistierna', 'ChIJ9bl0n5LeNw0RsK_0WgeHBQQ', 42.7986416, -5.1119407, 'city', '0'),
('countries_australia_new_south_wales_mozart', 'ChIJacf2LCWIEWsRYGhDkLQJBgQ', -33.8265648, 149.82329, 'city', '1'),
('countries_australia_new_south_wales_mudgee', 'ChIJLTuSI2OJDmsRcGhDkLQJBgQ', -32.6144566, 149.5733291, 'city', '1'),
('countries_australia_new_south_wales_mulbring', 'ChIJ7ZRv0Jkwc2sRwPEyFmh9AQU', -32.906667, 151.492778, 'city', '1'),
('countries_australia_new_south_wales_mulgoa', 'ChIJq8CjFseOEmsRoMIyFmh9AQU', -33.8461, 150.6525, 'city', '1'),
('countries_australia_new_south_wales_mullaway', 'ChIJw4Q_m1bzm2sR0JdDkLQJBgQ', -30.0806073, 153.1958504, 'city', '1'),
('countries_australia_new_south_wales_mulla_creek', 'ChIJ8XPiWeOoCmsRAMJDkLQJBgQ', -31.0675445, 151.1188778, 'city', '1'),
('countries_australia_new_south_wales_mullengandra', 'ChIJ-Xax9zjGI2sRkOxDkLQJBgQ', -35.876944, 147.180556, 'city', '1'),
('countries_australia_new_south_wales_mullion_creek', 'ChIJof-OV_ErDmsRkGhDkLQJBgQ', -33.1400261, 149.1328079, 'city', '1'),
('countries_australia_new_south_wales_mulloon', 'ChIJ13JcBmZiFmsR8OBDkLQJBgQ', -35.2734625, 149.6182597, 'city', '1'),
('countries_australia_new_south_wales_mullumbimby', 'ChIJBX8q8giMkGsR8PlDkLQJBgQ', -28.5469354, 153.4969812, 'city', '1'),
('countries_australia_new_south_wales_mulwala', 'ChIJZ4hVjVDQIGsRAM9DkLQJBgQ', -35.981944, 146.001111, 'city', '1'),
('countries_australia_new_south_wales_mumbil', 'ChIJtadQavayD2sRoGhDkLQJBgQ', -32.716667, 149.05, 'city', '1'),
('countries_australia_new_south_wales_mummel', 'ChIJMWo6kSiyFmsR4CdEkLQJBgU', -34.6610911, 149.5424637, 'city', '1'),
('countries_australia_new_south_wales_mundamia', 'ChIJJYs39gqAFGsRMEUzFmh9AQU', -34.877716, 150.5657441, 'city', '1'),
('countries_australia_new_south_wales_mungindi', 'ChIJNWg9kMbCpWsRoL4gf_HuAAQ', -28.9665575, 148.6784899, 'city', '1'),
('countries_australia_new_south_wales_murrah', 'ChIJJec8FjN6PmsRsAxEkLQJBgQ', -36.5401849, 150.0237786, 'city', '1'),
('countries_australia_new_south_wales_murrays_beach', 'ChIJj3uZ7yonc2sRkEkzFmh9AQU', -33.1160723, 151.6216653, 'city', '1'),
('countries_australia_new_south_wales_murringo', 'ChIJQcYkv66zEGsR4OxDkLQJBgQ', -34.3034765, 148.518431, 'city', '1'),
('countries_australia_new_south_wales_murrumbateman', 'ChIJ75lyTVgBF2sRAOFDkLQJBgQ', -34.9729427, 149.0228616, 'city', '1'),
('countries_australia_new_south_wales_murrumbucca', 'ChIJcwKRIH0JPWsREOFDkLQJBgQ', -36.09962, 149.0288595, 'city', '1'),
('countries_australia_new_south_wales_murrurundi', 'ChIJ6xwvExAaC2sR0IdDkLQJBgQ', -31.7638982, 150.8325894, 'city', '1'),
('countries_australia_new_south_wales_murwillumbah', 'ChIJ4eyiy8fvkGsRoCpEkLQJBgU', -28.3322568, 153.3827556, 'city', '1'),
('countries_australia_new_south_wales_muscle_creek', 'ChIJw-QycVBeC2sR8IdDkLQJBgQ', -32.2867124, 151.0012919, 'city', '1'),
('countries_australia_new_south_wales_muswellbrook', 'ChIJkY2KCx5gC2sRAIhDkLQJBgQ', -32.2848467, 150.9049638, 'city', '1'),
('countries_australia_new_south_wales_muttama', 'ChIJ9aswFCvNGWsRAO1DkLQJBgQ', -34.8190857, 148.1316421, 'city', '1'),
('countries_australia_new_south_wales_myocum', 'ChIJL5c_15eLkGsRMPpDkLQJBgQ', -28.5985151, 153.5039021, 'city', '1'),
('countries_australia_new_south_wales_myrtleville', 'ChIJTXIS7HDiE2sR0r2P4V6dODY', -34.4676175, 149.8183388, 'city', '1'),
('countries_australia_new_south_wales_mystery_bay', 'ChIJxc4Jbn4TPmsR4AxEkLQJBgQ', -36.303611, 150.130278, 'city', '1'),
('countries_australia_new_south_wales_nabiac', 'ChIJ3Xb9THVMdGsRkKZDkLQJBgQ', -32.1, 152.383333, 'city', '1'),
('countries_australia_new_south_wales_nambucca_heads', 'ChIJqUUXrnovnGsRAJhDkLQJBgQ', -30.6419702, 152.9978834, 'city', '1'),
('countries_australia_new_south_wales_nana_glen', 'ChIJcZsoK9kHnGsREJhDkLQJBgQ', -30.133333, 153, 'city', '1'),
('countries_australia_new_south_wales_napoleon_reef', 'ChIJObcb5ob-EWsR0GhDkLQJBgQ', -33.4266662, 149.75259, 'city', '1'),
('countries_australia_new_south_wales_naradhan', 'ChIJg5YF_iAhHGsRcM9DkLQJBgQ', -33.5827196, 146.3310287, 'city', '1'),
('countries_australia_new_south_wales_narara', 'ChIJS-BPvs_KcmsRYNwyFmh9AQU', -33.3920856, 151.3326862, 'city', '1'),
('countries_australia_new_south_wales_narellan', 'ChIJjRwmjALxEmsRwMIyFmh9AQU', -34.04511, 150.73706, 'city', '1'),
('countries_australia_new_south_wales_narellan_vale', 'ChIJS0AsLyXwEmsR0MIyFmh9AQU', -34.0504, 150.7483, 'city', '1'),
('countries_australia_new_south_wales_naremburn', 'ChIJpW4gZuyuEmsR4MIyFmh9AQU', -33.8177311, 151.2011183, 'city', '1'),
('countries_australia_new_south_wales_narooma', 'ChIJrwsUHy8XPmsRMChEkLQJBgU', -36.2419463, 150.1081935, 'city', '1'),
('countries_australia_new_south_wales_narrabeen', 'ChIJJW-kQQVVDWsR8MIyFmh9AQU', -33.7231, 151.2952, 'city', '1'),
('countries_australia_new_south_wales_narrabri', 'ChIJ5Zbm0UHSoGsR8LpDkLQJBgQ', -30.3324062, 149.7812403, 'city', '1'),
('countries_australia_new_south_wales_narrandera', 'ChIJG0g3Q2o_H2sRgM9DkLQJBgQ', -34.7379824, 146.557684, 'city', '1'),
('countries_australia_new_south_wales_narrawallee', 'ChIJR3GnunVaFGsR0DFEkLQJBgU', -35.3125136, 150.4631291, 'city', '1'),
('countries_australia_new_south_wales_narraweena', 'ChIJCXLSE3uqEmsRAMMyFmh9AQU', -33.748611, 151.267778, 'city', '1'),
('countries_australia_new_south_wales_narromine', 'ChIJ9Y4ENGWeBWsRIHRDkLQJBgQ', -32.2327424, 148.2394681, 'city', '1'),
('countries_australia_new_south_wales_narwee', 'ChIJ0SqxkkK5EmsREMMyFmh9AQU', -33.947329, 151.0707329, 'city', '1'),
('countries_australia_new_south_wales_nashdale', 'ChIJvZ3m7fMtEGsRAHxDkLQJBgQ', -33.3004961, 149.0066322, 'city', '1'),
('countries_australia_new_south_wales_nashua', 'ChIJze-j-0iEkGsRQPpDkLQJBgQ', -28.72715, 153.46695, 'city', '1'),
('countries_australia_new_south_wales_neath', 'ChIJL0UvwMA1c2sR8PEyFmh9AQU', -32.8172136, 151.4172839, 'city', '1'),
('countries_australia_new_south_wales_neilrex', 'ChIJ7S0qtm85CWsREHxDkLQJBgQ', -31.7418879, 149.3638219, 'city', '1'),
('countries_australia_new_south_wales_nelligen', 'ChIJa1Tg_lboFWsRIA1EkLQJBgQ', -35.6452979, 150.0923356, 'city', '1'),
('countries_australia_new_south_wales_nelson', 'ChIJ3W18HydgDWsRIMMyFmh9AQU', -33.6457, 150.922, 'city', '1'),
('countries_australia_new_south_wales_nelsons_plains', 'ChIJRfbDbhdoc2sRoNEyFmh9AQU', -32.715, 151.717778, 'city', '1'),
('countries_australia_new_south_wales_nelson_bay', 'ChIJbUO1MsKDc2sRAPIyFmh9AQU', -32.715, 152.151111, 'city', '1'),
('countries_australia_new_south_wales_nemingha', 'ChIJd8V-dtCjCmsRQMJDkLQJBgQ', -31.108333, 150.991667, 'city', '1'),
('countries_australia_new_south_wales_nericon', 'ChIJra0v-9FSHmsRkM9DkLQJBgQ', -34.1864053, 146.0452584, 'city', '1'),
('countries_australia_new_south_wales_nerriga', 'ChIJub1Al18jFGsRUA1EkLQJBgQ', -35.1378937, 150.1127964, 'city', '1'),
('countries_australia_new_south_wales_nethercote', 'ChIJtyFQ-8kcPGsRcA1EkLQJBgQ', -37.0342003, 149.8218433, 'city', '1'),
('countries_australia_new_south_wales_neurea', 'ChIJfZ_haJKwD2sRMHxDkLQJBgQ', -32.6784272, 148.9442196, 'city', '1'),
('countries_australia_new_south_wales_neutral_bay', 'ChIJO39xG5GuEmsRMMMyFmh9AQU', -33.8339383, 151.2188459, 'city', '1'),
('countries_australia_new_south_wales_nevertire', 'ChIJk4-Wp7G0BWsRUHRDkLQJBgQ', -31.8586216, 147.6559473, 'city', '1'),
('countries_australia_new_south_wales_neville', 'ChIJVVeJ9X2uEWsR8GhDkLQJBgQ', -33.7165578, 149.2140052, 'city', '1'),
('countries_australia_new_south_wales_newbridge', 'ChIJYX1lfLG4EWsRAGlDkLQJBgQ', -33.5900586, 149.3807296, 'city', '1'),
('countries_spain_castille_and_leon_chane', 'ChIJI97JXmgoRw0RQFDbHjmWmmw', 41.3393687, -4.4265407, 'city', '1'),
('countries_australia_new_south_wales_newee_creek', 'ChIJWwV8nzwvnGsRMJhDkLQJBgQ', -30.633056, 152.933611, 'city', '1'),
('countries_australia_new_south_wales_newington', 'ChIJ6S-r9aWkEmsRAD4zFmh9AQU', -33.839, 151.055, 'city', '1'),
('countries_australia_new_south_wales_newport', 'ChIJlS86XEVTDWsRQMMyFmh9AQU', -33.6564, 151.3137, 'city', '1'),
('countries_australia_new_south_wales_newrybar', 'ChIJgUJKnGuIkGsRcPpDkLQJBgQ', -28.72056, 153.52944, 'city', '1'),
('countries_australia_new_south_wales_newtown', 'ChIJf-kHYzawEmsRcMMyFmh9AQU', -33.8978149, 151.1785003, 'city', '1'),
('countries_australia_new_south_wales_new_berrima', 'ChIJvdDkUMuWE2sR0CREkLQJBgU', -34.5029, 150.3352, 'city', '1'),
('countries_australia_new_south_wales_new_brighton', 'ChIJSVk4WjH1kGsRwCpEkLQJBgU', -28.516667, 153.55, 'city', '1'),
('countries_australia_new_south_wales_new_buildings', 'ChIJ8zIWo_0RPGsRgA1EkLQJBgQ', -36.9625063, 149.5649571, 'city', '1'),
('countries_spain_castille_and_leon_carrion_de_los_condes', 'ChIJS7wim_jaRw0RYgTavLM1T7Q', 42.3307302, -4.6140481, 'city', '0'),
('countries_australia_new_south_wales_new_lambton', 'ChIJl73HWJEVc2sRIPIyFmh9AQU', -32.927778, 151.710833, 'city', '1'),
('countries_australia_new_south_wales_niagara_park', 'ChIJE6SL4TzLcmsRcNwyFmh9AQU', -33.382, 151.351, 'city', '1'),
('countries_australia_new_south_wales_niangala', 'ChIJzcmk_plIdWsRsKZDkLQJBgQ', -31.298333, 151.409444, 'city', '1'),
('countries_australia_new_south_wales_nimbin', 'ChIJG-fCREe9kGsRkPpDkLQJBgQ', -28.595833, 153.223056, 'city', '1'),
('countries_australia_new_south_wales_nimmitabel', 'ChIJw8m9WBxRPGsRYOFDkLQJBgQ', -36.5122976, 149.2843266, 'city', '1'),
('countries_australia_new_south_wales_nobbys_creek', 'ChIJS70rf_PvkGsRoPpDkLQJBgQ', -28.3, 153.333333, 'city', '1'),
('countries_australia_new_south_wales_norah', 'ChIJ8dmr3aDbcmsRcRkIq8moXXE', -33.2815439, 151.5791475, 'city', '1'),
('countries_australia_new_south_wales_noraville', 'ChIJf4fFB1jacmsRkNwyFmh9AQU', -33.268863, 151.5559438, 'city', '1'),
('countries_australia_new_south_wales_nords_wharf', 'ChIJ7aAMZtomc2sRoNwyFmh9AQU', -33.1350366, 151.6062932, 'city', '1'),
('countries_australia_new_south_wales_normanhurst', 'ChIJ2bsk-KOnEmsRgMMyFmh9AQU', -33.7245321, 151.0970108, 'city', '1'),
('countries_australia_new_south_wales_northbridge', 'ChIJ7xBwMgWvEmsRgMQyFmh9AQU', -33.811597, 151.2159446, 'city', '1'),
('countries_australia_new_south_wales_northmead', 'ChIJ61qh122iEmsRkMQyFmh9AQU', -33.789095, 150.9954125, 'city', '1'),
('countries_australia_new_south_wales_northwood', 'ChIJCRjlswSvEmsRoMQyFmh9AQU', -33.828225, 151.1774263, 'city', '1'),
('countries_australia_new_south_wales_north_arm_cove', 'ChIJH9Za4zV-c2sRMIhDkLQJBgQ', -32.625278, 152.044167, 'city', '1'),
('countries_australia_new_south_wales_north_avoca', 'ChIJX3Ehax62cmsRsNwyFmh9AQU', -33.457, 151.435, 'city', '1'),
('countries_australia_new_south_wales_north_balgowlah', 'ChIJ1QCnpcirEmsRkMMyFmh9AQU', -33.7870297, 151.2517112, 'city', '1'),
('countries_australia_new_south_wales_north_bondi', 'ChIJV_-kgJetEmsRoMMyFmh9AQU', -33.8857289, 151.280712, 'city', '1'),
('countries_australia_new_south_wales_north_casino', 'ChIJHcbyD0IImmsRwPpDkLQJBgQ', -28.8094669, 153.0698906, 'city', '1'),
('countries_australia_new_south_wales_north_curl_curl', 'ChIJZUfaFI6qEmsRsMMyFmh9AQU', -33.7626172, 151.2954913, 'city', '1'),
('countries_australia_new_south_wales_north_epping', 'ChIJqbtyGWCmEmsRwMMyFmh9AQU', -33.7592626, 151.0954593, 'city', '1'),
('countries_australia_new_south_wales_north_gosford', 'ChIJoY6ErJbKcmsRwNwyFmh9AQU', -33.4158641, 151.3491336, 'city', '1'),
('countries_australia_new_south_wales_north_haven', 'ChIJE3alStjidWsR0KZDkLQJBgQ', -31.6394784, 152.8193689, 'city', '1'),
('countries_australia_new_south_wales_north_lambton', 'ChIJ13w2lYEVc2sRkPIyFmh9AQU', -32.902924, 151.7044289, 'city', '1'),
('countries_australia_new_south_wales_north_lismore', 'ChIJ0fYS9m6ekGsRoCtEkLQJBgU', -28.7966957, 153.2710928, 'city', '1'),
('countries_australia_new_south_wales_north_macquarie', 'ChIJA2sCTj8NE2sR8OQyFmh9AQU', -34.5688567, 150.7468322, 'city', '1'),
('countries_australia_new_south_wales_north_manly', 'ChIJ6amn41aqEmsR0MMyFmh9AQU', -33.7746021, 151.2702888, 'city', '1'),
('countries_australia_new_south_wales_north_narooma', 'ChIJJep4GqIQPmsRQChEkLQJBgU', -36.2055416, 150.120091, 'city', '1'),
('countries_australia_new_south_wales_north_narrabeen', 'ChIJcWuPN-JUDWsR4MMyFmh9AQU', -33.7025574, 151.2945403, 'city', '1'),
('countries_australia_new_south_wales_north_rocks', 'ChIJ5_QOVvmjEmsRAMQyFmh9AQU', -33.7750537, 151.0238278, 'city', '1'),
('countries_australia_new_south_wales_north_rothbury', 'ChIJuxKQjVFLc2sRoPIyFmh9AQU', -32.680558, 151.349541, 'city', '1'),
('countries_australia_new_south_wales_north_ryde', 'ChIJ1XoNJ0uvEmsREMQyFmh9AQU', -33.7967571, 151.1243821, 'city', '1'),
('countries_australia_new_south_wales_north_star', 'ChIJz2QfQt2oo2sRALtDkLQJBgQ', -28.9325824, 150.3912342, 'city', '1'),
('countries_australia_new_south_wales_north_strathfield', 'ChIJ0fOJSyu7EmsRMMQyFmh9AQU', -33.8572406, 151.0881714, 'city', '1'),
('countries_australia_new_south_wales_north_st_marys', 'ChIJAeRDmsOaEmsRIMQyFmh9AQU', -33.7552311, 150.7867704, 'city', '1'),
('countries_australia_new_south_wales_north_tumbulgum', 'ChIJOd4omNv7kGsRADBEkLQJBgU', -28.2649575, 153.4509376, 'city', '1'),
('countries_australia_new_south_wales_north_wagga_wagga', 'ChIJN9jPaBaaGGsRJYL4o3khnak', -35.0953711, 147.377597, 'city', '1'),
('countries_australia_new_south_wales_north_wahroonga', 'ChIJpSdPPgVYDWsRYMQyFmh9AQU', -33.7026952, 151.1231695, 'city', '1'),
('countries_australia_new_south_wales_north_willoughby', 'ChIJi0mDyzOpEmsRcMQyFmh9AQU', -33.7946156, 151.2000202, 'city', '1'),
('countries_australia_new_south_wales_nowendoc', 'ChIJizSK7sBrdWsR4KZDkLQJBgQ', -31.5135574, 151.716806, 'city', '1'),
('countries_australia_new_south_wales_nowra', 'ChIJNyEAsAOAFGsRIOUyFmh9AQU', -34.8870504, 150.6005142, 'city', '1'),
('countries_australia_new_south_wales_nowra_hill', 'ChIJs9V7tN5_FGsRcEUzFmh9AQU', -34.9317451, 150.5532355, 'city', '1'),
('countries_australia_new_south_wales_nulkaba', 'ChIJ5TTB5hE1c2sRQEMzFmh9AQU', -32.8096421, 151.3496968, 'city', '1'),
('countries_australia_new_south_wales_nullo_mountain', 'ChIJyV3k1sdJDGsRQGlDkLQJBgQ', -32.6962902, 150.2253883, 'city', '1'),
('countries_australia_new_south_wales_numeralla', 'ChIJGcdljQW7PWsRgOFDkLQJBgQ', -36.1770262, 149.3448911, 'city', '1'),
('countries_australia_new_south_wales_numulgi', 'ChIJR0hrX3WckGsR4PpDkLQJBgQ', -28.7243109, 153.3302897, 'city', '1'),
('countries_australia_new_south_wales_nunderi', 'ChIJO6vaYBL6kGsR8PpDkLQJBgQ', -28.3243247, 153.4642874, 'city', '1'),
('countries_australia_new_south_wales_nundle', 'ChIJl0V8dhLGCmsRgMJDkLQJBgQ', -31.4607738, 151.1279037, 'city', '1'),
('countries_australia_new_south_wales_nymagee', 'ChIJQTm3lxjbAmsRcANEkLQJBgQ', -32.065279, 146.315469, 'city', '1'),
('countries_australia_new_south_wales_nymboida', 'ChIJefpFX4RRmWsRwBtEkLQJBgQ', -29.9361651, 152.7277824, 'city', '1'),
('countries_australia_new_south_wales_nyngan', 'ChIJ7WRCp5hwBGsRcHRDkLQJBgQ', -31.5592276, 147.188948, 'city', '1'),
('countries_australia_new_south_wales_oakdale', 'ChIJO17djAJXEmsRwDwzFmh9AQU', -34.081667, 150.501111, 'city', '1'),
('countries_australia_new_south_wales_oakhampton', 'ChIJ5cENRKxFc2sRwPIyFmh9AQU', -32.7030502, 151.5632449, 'city', '1'),
('countries_australia_new_south_wales_oakhurst', 'ChIJwXsvF4KZEmsRsMQyFmh9AQU', -33.7411625, 150.840584, 'city', '1'),
('countries_australia_new_south_wales_oaklands', 'ChIJ2-DsEwP_IGsR0M9DkLQJBgQ', -35.555745, 146.1878329, 'city', '1'),
('countries_australia_new_south_wales_oakville', 'ChIJX95COOxhDWsRwMQyFmh9AQU', -33.6222, 150.8669, 'city', '1'),
('countries_australia_new_south_wales_oakwood', 'ChIJqZR0ukoDomsRkMJDkLQJBgQ', -29.6604128, 151.0459074, 'city', '1'),
('countries_australia_new_south_wales_oak_flats', 'ChIJ-9Xo1QcTE2sRQOUyFmh9AQU', -34.561944, 150.818889, 'city', '1'),
('countries_australia_new_south_wales_oatlands', 'ChIJO5OynZajEmsR0MQyFmh9AQU', -33.7963384, 151.0263232, 'city', '1'),
('countries_australia_new_south_wales_oatley', 'ChIJKfFjP-e4EmsR4MQyFmh9AQU', -33.98118, 151.07479, 'city', '1'),
('countries_australia_new_south_wales_oberon', 'ChIJe-K_B5QfEmsRUGlDkLQJBgQ', -33.716667, 149.866667, 'city', '1'),
('countries_australia_new_south_wales_obley', 'ChIJsR6WhgXtD2sRcHxDkLQJBgQ', -32.6479254, 148.5492072, 'city', '1'),
('countries_australia_new_south_wales_old_bar', 'ChIJCYbtVBjPdWsRAKdDkLQJBgQ', -31.966667, 152.583333, 'city', '1'),
('countries_australia_new_south_wales_old_bonalbo', 'ChIJA_1IgsxZl2sRQLRDkLQJBgQ', -28.65, 152.6, 'city', '1'),
('countries_australia_new_south_wales_old_erowal_bay', 'ChIJoSK11yWJFGsRwNdDkLQJBgQ', -35.0873469, 150.6502836, 'city', '1'),
('countries_australia_new_south_wales_old_guildford', 'ChIJHSeNPw69EmsR8MQyFmh9AQU', -33.86577, 150.98346, 'city', '1'),
('countries_australia_new_south_wales_old_toongabbie', 'ChIJyz0GiYmiEmsRAMUyFmh9AQU', -33.787, 150.966, 'city', '1'),
('countries_australia_new_south_wales_ophir', 'ChIJkazhGCIpDmsRgGlDkLQJBgQ', -33.181041, 149.1772713, 'city', '1'),
('countries_australia_new_south_wales_opossum_creek', 'ChIJl4lRPb2IkGsRkPtDkLQJBgQ', -28.682564, 153.4921029, 'city', '1'),
('countries_australia_new_south_wales_orange', 'ChIJYUiM4tAsEGsR8CNEkLQJBgU', -33.283333, 149.1, 'city', '1'),
('countries_australia_new_south_wales_orangeville', 'ChIJYQQN5B73EmsRKRpMsPL4oTE', -34.0263733, 150.5936766, 'city', '1'),
('countries_australia_new_south_wales_oran_park', 'ChIJ1RO2bXzxEmsREMUyFmh9AQU', -34.003, 150.743, 'city', '1'),
('countries_australia_new_south_wales_orchard_hills', 'ChIJBRL8RK2PEmsRIMUyFmh9AQU', -33.7923295, 150.7330734, 'city', '1'),
('countries_australia_new_south_wales_orient_point', 'ChIJLxgaHqGCFGsRXogmkh7QHGM', -34.9108, 150.7497, 'city', '1'),
('countries_australia_new_south_wales_otford', 'ChIJt5quf1bcEmsRUOUyFmh9AQU', -34.216667, 151, 'city', '1'),
('countries_australia_new_south_wales_oura', 'ChIJfcDNzk6IGGsRcO1DkLQJBgQ', -35.1016576, 147.5430146, 'city', '1'),
('countries_australia_new_south_wales_ourimbah', 'ChIJYdLhV4zMcmsR0NwyFmh9AQU', -33.3561169, 151.3694311, 'city', '1'),
('countries_australia_new_south_wales_oxford_falls', 'ChIJJxNda_dVDWsRQMUyFmh9AQU', -33.7352, 151.2469, 'city', '1'),
('countries_australia_new_south_wales_oxley_island', 'ChIJ9_TX0qTIdWsREKdDkLQJBgQ', -31.9140556, 152.5737286, 'city', '1'),
('countries_australia_new_south_wales_oxley_park', 'ChIJO80IA5eaEmsRUMUyFmh9AQU', -33.7709, 150.7934, 'city', '1'),
('countries_australia_new_south_wales_oxley_vale', 'ChIJG_CXEqSeCmsRQClEkLQJBgU', -31.048611, 150.884722, 'city', '1'),
('countries_australia_new_south_wales_oyster_bay', 'ChIJI12f3pG4EmsRYMUyFmh9AQU', -34.00754, 151.07514, 'city', '1'),
('countries_australia_new_south_wales_o_connell', 'ChIJY-Sk5Nr2EWsRYGlDkLQJBgQ', -33.5670388, 149.7386311, 'city', '1'),
('countries_australia_new_south_wales_paddington', 'ChIJt4nzrAiuEmsRcMUyFmh9AQU', -33.8850215, 151.2262353, 'city', '1'),
('countries_australia_new_south_wales_padstow', 'ChIJCenglca-EmsRgMUyFmh9AQU', -33.9504502, 151.0309, 'city', '1'),
('countries_australia_new_south_wales_padstow_heights', 'ChIJt3YMQya_EmsRkMUyFmh9AQU', -33.973, 151.035, 'city', '1'),
('countries_australia_new_south_wales_pagewood', 'ChIJe-97c3SxEmsRoMUyFmh9AQU', -33.9406443, 151.2154524, 'city', '1'),
('countries_australia_new_south_wales_palmers_channel', 'ChIJ8-8VZH1JmmsR0BtEkLQJBgQ', -29.4649592, 153.2680351, 'city', '1'),
('countries_australia_new_south_wales_palmers_island', 'ChIJFwuLfPhLmmsR4BtEkLQJBgQ', -29.41629, 153.2916107, 'city', '1'),
('countries_australia_new_south_wales_palmwoods', 'ChIJhyar0yCNkGsRMPtDkLQJBgQ', -28.5158985, 153.4065773, 'city', '1'),
('countries_australia_new_south_wales_palm_beach', 'ChIJpekcWq1SDWsRsMUyFmh9AQU', -33.601111, 151.321667, 'city', '1'),
('countries_australia_new_south_wales_palm_grove', 'ChIJr-3dH0AzDWsRMEQzFmh9AQU', -33.324, 151.31, 'city', '1'),
('countries_australia_new_south_wales_pambula', 'ChIJ0cnu-JGgPmsRAA5EkLQJBgQ', -36.916667, 149.883333, 'city', '1'),
('countries_australia_new_south_wales_pambula_beach', 'ChIJQZwTNPKgPmsREA5EkLQJBgQ', -36.933333, 149.9, 'city', '1'),
('countries_australia_new_south_wales_pampoolah', 'ChIJYeJcuKXJdWsRIKdDkLQJBgQ', -31.9357602, 152.5091262, 'city', '1'),
('countries_australia_new_south_wales_panania', 'ChIJIzhejFS-EmsR4MUyFmh9AQU', -33.95793, 151.002, 'city', '1'),
('countries_australia_new_south_wales_pappinbarra', 'ChIJlcP0Pgv2dWsRMKdDkLQJBgQ', -31.3725782, 152.4951807, 'city', '1'),
('countries_australia_new_south_wales_parkes', 'ChIJV8Y2HrKpGmsRkHxDkLQJBgQ', -33.1372943, 148.1747161, 'city', '1'),
('countries_australia_new_south_wales_parklea', 'ChIJcWOcTS6fEmsR8MUyFmh9AQU', -33.7291, 150.919, 'city', '1'),
('countries_australia_new_south_wales_parkville', 'ChIJ3WbozloUC2sRkIhDkLQJBgQ', -31.9787436, 150.8671671, 'city', '1'),
('countries_australia_new_south_wales_parma', 'ChIJF3TPBBd9FGsR0NdDkLQJBgQ', -34.9691878, 150.5414435, 'city', '1'),
('countries_australia_new_south_wales_parramatta', 'ChIJT69n4RijEmsRAMYyFmh9AQU', -33.8135571, 151.003407, 'city', '1'),
('countries_australia_new_south_wales_paterson', 'ChIJAenoInlcc2sRoIhDkLQJBgQ', -32.583333, 151.6, 'city', '1'),
('countries_australia_new_south_wales_patonga', 'ChIJV-zW7zhMDWsRAN0yFmh9AQU', -33.549383, 151.2705745, 'city', '1'),
('countries_australia_new_south_wales_paxton', 'ChIJa_DkdXTNDGsREPMyFmh9AQU', -32.9027462, 151.283115, 'city', '1'),
('countries_australia_new_south_wales_peakhurst', 'ChIJuTz7Si-5EmsREMYyFmh9AQU', -33.9654, 151.0502, 'city', '1'),
('countries_australia_new_south_wales_peakhurst_heights', 'ChIJ48ZBFte4EmsR5azNYGdap6U', -33.981667, 151.051111, 'city', '1'),
('countries_australia_new_south_wales_peak_hill', 'ChIJ7WuhkitEBWsRsHRDkLQJBgQ', -32.7255779, 148.1915984, 'city', '1'),
('countries_australia_new_south_wales_pearl_beach', 'ChIJoylLIOBMDWsREN0yFmh9AQU', -33.542, 151.308, 'city', '1'),
('countries_australia_new_south_wales_peats_ridge', 'ChIJG9jwnxczDWsRIN0yFmh9AQU', -33.332, 151.235, 'city', '1'),
('countries_australia_new_south_wales_peel', 'ChIJb0xMvcYCDmsR4GlDkLQJBgQ', -33.3052318, 149.6368544, 'city', '1'),
('countries_australia_new_south_wales_peelwood', 'ChIJBRm1Z5ETEWsR8GlDkLQJBgQ', -34.1272289, 149.4123017, 'city', '1'),
('countries_australia_new_south_wales_pelaw_main', 'ChIJq_gx8c43c2sRIPMyFmh9AQU', -32.83, 151.481, 'city', '1'),
('countries_australia_new_south_wales_pelican', 'ChIJLaPcxskjc2sRMPMyFmh9AQU', -33.0710868, 151.6435782, 'city', '1'),
('countries_australia_new_south_wales_pelton', 'ChIJA_d3jNDMDGsR4DgzFmh9AQU', -32.879167, 151.311389, 'city', '1'),
('countries_australia_new_south_wales_pemulwuy', 'ChIJ5_7e_4uXEmsR8EMzFmh9AQU', -33.817, 150.926, 'city', '1'),
('countries_australia_new_south_wales_pendle_hill', 'ChIJZfdaLJmiEmsRIMYyFmh9AQU', -33.80739, 150.95518, 'city', '1'),
('countries_australia_new_south_wales_pennant_hills', 'ChIJN2CoQOKmEmsRMMYyFmh9AQU', -33.738881, 151.0723841, 'city', '1'),
('countries_australia_new_south_wales_penrith', 'ChIJe0LzS2KPEmsRQMYyFmh9AQU', -33.7506759, 150.687674, 'city', '1'),
('countries_australia_new_south_wales_penrose', 'ChIJyU4GF8abE2sREJFDkLQJBgQ', -34.675, 150.2125, 'city', '1'),
('countries_australia_new_south_wales_penshurst', 'ChIJr9U3Kwy5EmsRUMYyFmh9AQU', -33.963347, 151.0867644, 'city', '1'),
('countries_australia_new_south_wales_perisher_village', 'ChIJgdiHSblLI2sRBXoo-zQnLU0', -36.4058898, 148.4117257, 'city', '1'),
('countries_australia_new_south_wales_perthville', 'ChIJUeGlzyDpEWsRACNEkLQJBgU', -33.5104967, 149.5548753, 'city', '1'),
('countries_australia_new_south_wales_petersham', 'ChIJx5zkGROwEmsRYMYyFmh9AQU', -33.8962174, 151.1541497, 'city', '1'),
('countries_australia_new_south_wales_pheasants_nest', 'ChIJb47xkg0BE2sRIJFDkLQJBgQ', -34.25597, 150.6356, 'city', '1'),
('countries_australia_new_south_wales_phegans_bay', 'ChIJA8-Is0NLDWsRMN0yFmh9AQU', -33.488, 151.31, 'city', '1'),
('countries_australia_new_south_wales_phillip_bay', 'ChIJRUOMpau2EmsRcMYyFmh9AQU', -33.9781348, 151.2321019, 'city', '1'),
('countries_australia_new_south_wales_piallaway', 'ChIJm7s-hIaJCmsR8MJDkLQJBgQ', -31.1026277, 150.5113454, 'city', '1'),
('countries_australia_new_south_wales_piambong', 'ChIJqfttXafzDmsRAGpDkLQJBgQ', -32.5086474, 149.4008665, 'city', '1'),
('countries_australia_new_south_wales_picketts_valley', 'ChIJMeYBhfu1cmsRUN0yFmh9AQU', -33.457, 151.41, 'city', '1'),
('countries_australia_new_south_wales_picnic_point', 'ChIJn1H40w6_EmsRgMYyFmh9AQU', -33.96929, 151.00624, 'city', '1'),
('countries_australia_new_south_wales_picton', 'ChIJ7ekdnar_EmsRMJFDkLQJBgQ', -34.183333, 150.6, 'city', '1'),
('countries_australia_new_south_wales_piggabeen', 'ChIJaciY0wf9kGsREDBEkLQJBgU', -28.1972399, 153.4360653, 'city', '1'),
('countries_australia_new_south_wales_pimlico', 'ChIJdwRqbVh_mmsRYPtDkLQJBgQ', -28.9099236, 153.4783992, 'city', '1'),
('countries_australia_new_south_wales_pitt_town', 'ChIJdb0UBGZhDWsRkMYyFmh9AQU', -33.5816502, 150.8667511, 'city', '1'),
('countries_australia_new_south_wales_pleasure_point', 'ChIJ-_l3bLy_EmsRsMYyFmh9AQU', -33.96776, 150.978, 'city', '1'),
('countries_australia_new_south_wales_plumpton', 'ChIJuw_nRbWbEmsR0MYyFmh9AQU', -33.7514593, 150.8412545, 'city', '1'),
('countries_australia_new_south_wales_point_clare', 'ChIJERbrzbNKDWsRYN0yFmh9AQU', -33.44, 151.326, 'city', '1'),
('countries_australia_new_south_wales_point_frederick', 'ChIJWfU8sES1cmsRcN0yFmh9AQU', -33.4440645, 151.3399774, 'city', '1'),
('countries_australia_new_south_wales_point_piper', 'ChIJM90pe8mtEmsR4MYyFmh9AQU', -33.87045, 151.25097, 'city', '1'),
('countries_australia_new_south_wales_pokolbin', 'ChIJp-uTKua1DGsR8EIzFmh9AQU', -32.798333, 151.284444, 'city', '1'),
('countries_australia_new_south_wales_polo_flat', 'ChIJCeTnY4OoPWsRAOJDkLQJBgQ', -36.2315134, 149.1529768, 'city', '1'),
('countries_australia_new_south_wales_portland', 'ChIJjfAhzRj5DWsRMGpDkLQJBgQ', -33.3565537, 149.972988, 'city', '1'),
('countries_australia_new_south_wales_port_botany', 'ChIJy0BxDWixEmsR8MYyFmh9AQU', -33.976, 151.218, 'city', '1'),
('countries_australia_new_south_wales_port_hacking', 'ChIJC7CWn87HEmsRAMcyFmh9AQU', -34.069, 151.1227, 'city', '1'),
('countries_australia_new_south_wales_port_kembla', 'ChIJNc-aPNoZE2sRYOUyFmh9AQU', -34.485392, 150.8995794, 'city', '1'),
('countries_australia_new_south_wales_port_macquarie', 'ChIJwcnsNFz_nWsRQC5EkLQJBgU', -31.433333, 152.9, 'city', '1'),
('countries_australia_new_south_wales_port_stephens', 'ChIJy2_ngGN_c2sR8IhDkLQJBgQ', -32.7171397, 152.1048638, 'city', '1'),
('countries_australia_new_south_wales_possum_brush', 'ChIJVdMDO_BMdGsRcKdDkLQJBgQ', -32.0596908, 152.4408122, 'city', '1'),
('countries_australia_new_south_wales_potato_point', 'ChIJ3bz-ovUbPmsRUA5EkLQJBgQ', -36.102302, 150.1231803, 'city', '1'),
('countries_australia_new_south_wales_pottsville', 'ChIJ79Y_Zqn2kGsRoPtDkLQJBgQ', -28.3877489, 153.5580894, 'city', '1'),
('countries_australia_new_south_wales_potts_hill', 'ChIJc6tw_mS8EmsREMcyFmh9AQU', -33.89, 151.03, 'city', '1'),
('countries_australia_new_south_wales_potts_point', 'ChIJK6kIb3GuEmsRIMcyFmh9AQU', -33.86795, 151.22411, 'city', '1'),
('countries_australia_new_south_wales_prairiewood', 'ChIJbS94iJmWEmsRMMcyFmh9AQU', -33.861, 150.9048, 'city', '1'),
('countries_australia_new_south_wales_prestons', 'ChIJF02X-ZKUEmsRQMcyFmh9AQU', -33.9422412, 150.8673973, 'city', '1'),
('countries_australia_new_south_wales_pretty_beach', 'ChIJF1D2-0KzcmsRgN0yFmh9AQU', -33.528, 151.347, 'city', '1'),
('countries_australia_new_south_wales_pretty_pine', 'ChIJ4wBigp4h32oRINBDkLQJBgQ', -35.408837, 144.8724343, 'city', '1'),
('countries_australia_new_south_wales_primbee', 'ChIJHyZ38-cWE2sRkOUyFmh9AQU', -34.500833, 150.881667, 'city', '1'),
('countries_australia_new_south_wales_primrose_valley', 'ChIJCwtiiMI4FmsREOJDkLQJBgQ', -35.4758815, 149.3810254, 'city', '1'),
('countries_australia_new_south_wales_prospect', 'ChIJbxsER36XEmsRUMcyFmh9AQU', -33.7981153, 150.9176528, 'city', '1'),
('countries_australia_new_south_wales_pullabooka', 'ChIJc5Xg8idIGmsR8HRDkLQJBgQ', -33.7466806, 147.7658538, 'city', '1'),
('countries_australia_new_south_wales_punchbowl', 'ChIJcZnPdVW5EmsRYMcyFmh9AQU', -33.9324629, 151.049487, 'city', '1'),
('countries_australia_new_south_wales_putney', 'ChIJh1nL8SKlEmsRcMcyFmh9AQU', -33.827, 151.106, 'city', '1'),
('countries_australia_new_south_wales_putta_bucca', 'ChIJo9jRDRqJDmsRQGpDkLQJBgQ', -32.5793391, 149.5815218, 'city', '1'),
('countries_australia_new_south_wales_pymble', 'ChIJWaKKOb6oEmsRgMcyFmh9AQU', -33.7456508, 151.1431794, 'city', '1'),
('countries_australia_new_south_wales_pyree', 'ChIJ519CMteBFGsR66Nc9mJKnHU', -34.908056, 150.685556, 'city', '1'),
('countries_australia_new_south_wales_pyrmont', 'ChIJAWLZAzSuEmsRkMcyFmh9AQU', -33.8737167, 151.1956918, 'city', '1'),
('countries_australia_new_south_wales_quakers_hill', 'ChIJX5qfeTSZEmsRoMcyFmh9AQU', -33.7241591, 150.8889765, 'city', '1'),
('countries_australia_new_south_wales_quandialla', 'ChIJZ8a9fpIoGmsRwO1DkLQJBgQ', -34.0115381, 147.7406375, 'city', '1'),
('countries_australia_new_south_wales_queanbeyan', 'ChIJpyzMl-hOFmsRADFEkLQJBgU', -35.3530392, 149.230896, 'city', '1'),
('countries_australia_new_south_wales_queenscliff', 'ChIJtYwbZP6qEmsRwMcyFmh9AQU', -33.7825, 151.284722, 'city', '1'),
('countries_australia_new_south_wales_queens_park', 'ChIJgwEBp_qtEmsRsMcyFmh9AQU', -33.901, 151.248, 'city', '1'),
('countries_australia_new_south_wales_quipolly', 'ChIJk6mNOxr6CmsRMMNDkLQJBgQ', -31.4256656, 150.6829515, 'city', '1'),
('countries_australia_new_south_wales_quirindi', 'ChIJUewXbNj4CmsRQMNDkLQJBgQ', -31.508056, 150.68, 'city', '1'),
('countries_australia_new_south_wales_quorrobolong', 'ChIJ2TM3y2Qyc2sR4NEyFmh9AQU', -32.9285224, 151.3968598, 'city', '1'),
('countries_australia_new_south_wales_raby', 'ChIJd_UvGjPsEmsR0McyFmh9AQU', -34.0209207, 150.8173282, 'city', '1'),
('countries_australia_new_south_wales_raglan', 'ChIJdxyPBMrkEWsRECNEkLQJBgU', -33.4251502, 149.6506842, 'city', '1'),
('countries_australia_new_south_wales_rainbow_flat', 'ChIJOxXfMsHKdWsRkKdDkLQJBgQ', -32.0352464, 152.4856397, 'city', '1'),
('countries_australia_new_south_wales_raleigh', 'ChIJY8lX3bkjnGsRcJhDkLQJBgQ', -30.4738637, 152.9946611, 'city', '1'),
('countries_australia_new_south_wales_ramsgate', 'ChIJQ9Eacti5EmsR4McyFmh9AQU', -33.98194, 151.14007, 'city', '1'),
('countries_australia_new_south_wales_ramsgate_beach', 'ChIJ64NGkd25EmsR8McyFmh9AQU', -33.982, 151.148, 'city', '1'),
('countries_australia_new_south_wales_rand', 'ChIJdSPf4skKIWsRYNBDkLQJBgQ', -35.6014276, 146.6229825, 'city', '1'),
('countries_australia_new_south_wales_randwick', 'ChIJq-ZR9hyyEmsRAMgyFmh9AQU', -33.9131545, 151.2420352, 'city', '1'),
('countries_australia_new_south_wales_rankin_park', 'ChIJ3U_UfW0-c2sRgPMyFmh9AQU', -32.9252039, 151.6815673, 'city', '1'),
('countries_australia_new_south_wales_rappville', 'ChIJMXDLpYgYmmsRIBxEkLQJBgQ', -29.0580722, 152.9209512, 'city', '1'),
('countries_australia_new_south_wales_rathmines', 'ChIJ2WLt9l4kc2sRkPMyFmh9AQU', -33.0387657, 151.5807689, 'city', '1'),
('countries_australia_new_south_wales_ravensdale', 'ChIJLQxsumYrDWsRkN0yFmh9AQU', -33.1699044, 151.3015895, 'city', '1'),
('countries_australia_new_south_wales_raworth', 'ChIJIz6U54dDc2sRoPMyFmh9AQU', -32.7249192, 151.6099796, 'city', '1'),
('countries_australia_new_south_wales_raymond_terrace', 'ChIJca5Lcx5pc2sRsPMyFmh9AQU', -32.7544083, 151.7675123, 'city', '1'),
('countries_australia_new_south_wales_razorback', 'ChIJLdkVRqf-EmsRQJFDkLQJBgQ', -34.1462868, 150.6633499, 'city', '1'),
('countries_australia_new_south_wales_redbournberry', 'ChIJTeO8Ri-uDGsR4CBEkLQJBgU', -32.5586775, 151.1898463, 'city', '1'),
('countries_australia_new_south_wales_reddestone', 'ChIJAco4jx65mGsRALVDkLQJBgQ', -29.5563787, 151.670608, 'city', '1'),
('countries_australia_new_south_wales_redfern', 'ChIJZb8whd6xEmsREMgyFmh9AQU', -33.892963, 151.2053979, 'city', '1'),
('countries_australia_new_south_wales_redhead', 'ChIJy15W1uYXc2sRwPMyFmh9AQU', -33.009833, 151.7151801, 'city', '1'),
('countries_australia_new_south_wales_red_head', 'ChIJy15W1uYXc2sRwPMyFmh9AQU', -33.009833, 151.7151801, 'city', '1'),
('countries_australia_new_south_wales_red_range', 'ChIJC2DMS4nRmGsR8LRDkLQJBgQ', -29.8078404, 151.9684322, 'city', '1'),
('countries_australia_new_south_wales_red_rock', 'ChIJVdv6uK-Sm2sRkJhDkLQJBgQ', -29.9971955, 153.2120531, 'city', '1'),
('countries_australia_new_south_wales_regents_park', 'ChIJyXGkOoy8EmsRIMgyFmh9AQU', -33.88572, 151.02833, 'city', '1'),
('countries_australia_new_south_wales_regentville', 'ChIJ_U2cHMiIEmsRMMgyFmh9AQU', -33.7711622, 150.6604462, 'city', '1'),
('countries_australia_new_south_wales_renwick', 'ChIJcfprYemjE2sRLMFx6oZIWok', -34.4492755, 150.4747285, 'city', '1'),
('countries_australia_new_south_wales_repton', 'ChIJiQZ71ZgXnGsRoJhDkLQJBgQ', -30.4390312, 153.0353622, 'city', '1'),
('countries_australia_new_south_wales_revesby', 'ChIJSwctSqy-EmsRQMgyFmh9AQU', -33.9452471, 151.018035, 'city', '1'),
('countries_australia_new_south_wales_revesby_heights', 'ChIJ430dZRm_EmsRUMgyFmh9AQU', -33.96806, 151.01773, 'city', '1'),
('countries_australia_new_south_wales_rhodes', 'ChIJpyrNdOOkEmsRYMgyFmh9AQU', -33.82821, 151.08569, 'city', '1'),
('countries_australia_new_south_wales_richmond', 'ChIJpb4cx2mdEmsRcMgyFmh9AQU', -33.6, 150.75, 'city', '1'),
('countries_australia_new_south_wales_richmond_hill', 'ChIJd0vsAX-ckGsR4PtDkLQJBgQ', -28.7885974, 153.3417171, 'city', '1'),
('countries_australia_new_south_wales_rileys_hill', 'ChIJhyJNG_VvmmsRMBxEkLQJBgQ', -29.0252064, 153.3888863, 'city', '1'),
('countries_australia_new_south_wales_riverstone', 'ChIJcYu8UTmeEmsRgMgyFmh9AQU', -33.6819, 150.8594, 'city', '1'),
('countries_australia_new_south_wales_riverwood', 'ChIJs7dr4ku5EmsRoMgyFmh9AQU', -33.9508615, 151.0523782, 'city', '1'),
('countries_australia_new_south_wales_robertson', 'ChIJMU1j1bmdE2sRUJFDkLQJBgQ', -34.583333, 150.583333, 'city', '1'),
('countries_australia_new_south_wales_robin_hill', 'ChIJNU62cEbmEWsRICNEkLQJBgU', -33.4245676, 149.535434, 'city', '1'),
('countries_australia_new_south_wales_rockdale', 'ChIJ9WvJUFW3EmsRsMgyFmh9AQU', -33.9529076, 151.1375572, 'city', '1'),
('countries_australia_new_south_wales_rockley_mount', 'ChIJWwPbKVDpEWsR0GpDkLQJBgQ', -33.5452692, 149.5519949, 'city', '1'),
('countries_australia_new_south_wales_rocky_plain', 'ChIJSxJsMQPfPGsR0BNEkLQJBgQ', -36.267259, 148.7336827, 'city', '1'),
('countries_australia_new_south_wales_rocky_point', 'ChIJcfPpcyvQcmsRoN0yFmh9AQU', -33.2933617, 151.4705447, 'city', '1'),
('countries_australia_new_south_wales_rock_forest', 'ChIJeb3rHZ7bEWsRsGpDkLQJBgQ', -33.3657424, 149.437214, 'city', '1'),
('countries_australia_new_south_wales_rock_valley', 'ChIJL8EB98igkGsR8PtDkLQJBgQ', -28.7381514, 153.1678668, 'city', '1'),
('countries_australia_new_south_wales_rodd_point', 'ChIJA4NL2fuvEmsRwMgyFmh9AQU', -33.86607, 151.14366, 'city', '1'),
('countries_australia_new_south_wales_rookhurst', 'ChIJs6MAkGsddWsR8KdDkLQJBgQ', -31.9114973, 151.8383618, 'city', '1'),
('countries_australia_new_south_wales_rooty_hill', 'ChIJp5YYXDyaEmsR4MgyFmh9AQU', -33.7715246, 150.843841, 'city', '1'),
('countries_australia_new_south_wales_ropes_crossing', 'ChIJYUbvJCWbEmsRcEczFmh9AQU', -33.733, 150.791, 'city', '1'),
('countries_australia_new_south_wales_rosebank', 'ChIJ6S0037-akGsRAPxDkLQJBgQ', -28.6735163, 153.3977316, 'city', '1'),
('countries_australia_new_south_wales_rosebery', 'ChIJT83LdLyxEmsRAMkyFmh9AQU', -33.9221918, 151.201678, 'city', '1'),
('countries_australia_new_south_wales_rosedale', 'ChIJJ3iBCnLrFWsRwA5EkLQJBgQ', -35.816667, 150.216667, 'city', '1'),
('countries_australia_new_south_wales_rosehill', 'ChIJ4TD5tEOjEmsREMkyFmh9AQU', -33.8239653, 151.0212029, 'city', '1'),
('countries_australia_new_south_wales_roselands', 'ChIJSeQkxN67EmsRIMkyFmh9AQU', -33.9369131, 151.074461, 'city', '1'),
('countries_australia_new_south_wales_rosemeadow', 'ChIJMX7YpUflEmsRMMkyFmh9AQU', -34.107, 150.793, 'city', '1'),
('countries_australia_new_south_wales_roseville', 'ChIJZz61ed6oEmsRQMkyFmh9AQU', -33.7842176, 151.1894277, 'city', '1'),
('countries_australia_new_south_wales_roseville_chase', 'ChIJWfXp1RGpEmsRUMkyFmh9AQU', -33.7755896, 151.2000449, 'city', '1'),
('countries_australia_new_south_wales_rosewood', 'ChIJyXWs6_WSImsR8O1DkLQJBgQ', -35.674722, 147.863889, 'city', '1'),
('countries_australia_new_south_wales_rose_bay', 'ChIJ-y09wjCsEmsR8MgyFmh9AQU', -33.8754209, 151.265623, 'city', '1'),
('countries_australia_new_south_wales_rose_valley', 'ChIJ1xfXPvVuE2sRUD8zFmh9AQU', -34.7166387, 150.8086082, 'city', '1'),
('countries_australia_new_south_wales_rossglen', 'ChIJ-f_MSvbjdWsREKhDkLQJBgQ', -31.6685746, 152.7294491, 'city', '1'),
('countries_australia_new_south_wales_round_mountain', 'ChIJ2YCEUYj3kGsR8DFEkLQJBgU', -28.35, 153.55, 'city', '1'),
('countries_australia_new_south_wales_rous', 'ChIJr96aBxh4mmsRMPxDkLQJBgQ', -28.86833, 153.40306, 'city', '1'),
('countries_australia_new_south_wales_rouse_hill', 'ChIJuVCm-lqeEmsRgMkyFmh9AQU', -33.68162, 150.91552, 'city', '1'),
('countries_australia_new_south_wales_rous_mill', 'ChIJYyjQaYR3mmsRQPxDkLQJBgQ', -28.8762313, 153.3859379, 'city', '1'),
('countries_spain_castille_and_leon_berlanga_de_duero', 'ChIJjacVucyQRA0RwE71WgeHBQQ', 41.464153, -2.8623338, 'city', '0'),
('countries_australia_new_south_wales_rowena', 'ChIJgZXBohRRpmsRULtDkLQJBgQ', -29.6859974, 148.810462, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_australia_new_south_wales_royalla', 'ChIJ0_zc3Wo0FmsRMDFEkLQJBgU', -35.506944, 149.168056, 'city', '1'),
('countries_australia_new_south_wales_rozelle', 'ChIJbXNRDsavEmsRoMkyFmh9AQU', -33.8638543, 151.1701171, 'city', '1'),
('countries_australia_new_south_wales_running_stream', 'ChIJF0EHTPTgDWsRAGtDkLQJBgQ', -33.0477947, 149.865609, 'city', '1'),
('countries_australia_new_south_wales_run_o_waters', 'ChIJnRhUhM6xFmsR8CdEkLQJBgU', -34.7553429, 149.6737465, 'city', '1'),
('countries_australia_new_south_wales_ruse', 'ChIJl4OCNqLvEmsRsMkyFmh9AQU', -34.071, 150.8423, 'city', '1'),
('countries_australia_new_south_wales_rushcutters_bay', 'ChIJQxk9oQyuEmsRwMkyFmh9AQU', -33.8742991, 151.2284588, 'city', '1'),
('countries_australia_new_south_wales_russell_lea', 'ChIJLeEXZfivEmsR0MkyFmh9AQU', -33.859471, 151.14244, 'city', '1'),
('countries_australia_new_south_wales_russell_vale', 'ChIJmR3BBuYeE2sRwOUyFmh9AQU', -34.358, 150.901, 'city', '1'),
('countries_australia_new_south_wales_rutherford', 'ChIJvVpHd_VFc2sR8PMyFmh9AQU', -32.715278, 151.525, 'city', '1'),
('countries_australia_new_south_wales_rydalmere', 'ChIJKWEtfoKkEmsR4MkyFmh9AQU', -33.8123245, 151.0417591, 'city', '1'),
('countries_australia_new_south_wales_ryde', 'ChIJrRr8kL6lEmsR8MkyFmh9AQU', -33.8157466, 151.1030164, 'city', '1'),
('countries_australia_new_south_wales_rylstone', 'ChIJu6hGBlfNDWsRIGtDkLQJBgQ', -32.797121, 149.9692936, 'city', '1'),
('countries_australia_new_south_wales_sackville_north', 'ChIJR6L1zSpmDWsRAMoyFmh9AQU', -33.481667, 150.884722, 'city', '1'),
('countries_australia_new_south_wales_saddleback_mountain', 'ChIJl40NFlxuE2sREEEzFmh9AQU', -34.7, 150.8, 'city', '1'),
('countries_australia_new_south_wales_sadleir', 'ChIJvZ9QZUSUEmsREMoyFmh9AQU', -33.9164233, 150.8914686, 'city', '1'),
('countries_australia_new_south_wales_safety_beach', 'ChIJmfC7IK_0m2sRQB9EkLQJBgU', -30.0949948, 153.1943775, 'city', '1'),
('countries_australia_new_south_wales_saint_albans', 'ChIJKeAO8zM-DWsRarD7j4A9j7A', -33.2914651, 150.9709758, 'city', '1'),
('countries_australia_new_south_wales_saint_georges_basin', 'ChIJTXSe1viJFGsRUNhDkLQJBgQ', -35.0843898, 150.5917532, 'city', '1'),
('countries_australia_new_south_wales_saint_ives', 'ChIJH6iRpiSoEmsR4MsyFmh9AQU', -33.72136, 151.16844, 'city', '1'),
('countries_australia_new_south_wales_saint_marys', 'ChIJE2wj2OiaEmsRIMwyFmh9AQU', -33.769979, 150.7734575, 'city', '1'),
('countries_spain_castille_and_leon_benavides', 'ChIJ0xYqX4JlNw0RUK30WgeHBQQ', 42.5332128, -5.9621106, 'city', '0'),
('countries_australia_new_south_wales_salamander_bay', 'ChIJv3yPL2yCc2sRAPQyFmh9AQU', -32.729167, 152.089444, 'city', '1'),
('countries_australia_new_south_wales_salisbury', 'ChIJzSjmtnK4dGsRkIlDkLQJBgQ', -32.2188788, 151.5625148, 'city', '1'),
('countries_australia_new_south_wales_salisbury_plains', 'ChIJL-eGdImTn2sRQLVDkLQJBgQ', -30.764393, 151.5888013, 'city', '1'),
('countries_australia_new_south_wales_salt_ash', 'ChIJH5jCPlJwc2sREPQyFmh9AQU', -32.794444, 151.922222, 'city', '1'),
('countries_australia_new_south_wales_sancrox', 'ChIJc2qS9q7_dWsRMKhDkLQJBgQ', -31.449302, 152.7970637, 'city', '1'),
('countries_australia_new_south_wales_sanctuary_point', 'ChIJjzQu0p2JFGsRkDFEkLQJBgU', -35.103611, 150.626667, 'city', '1'),
('countries_australia_new_south_wales_sandgate', 'ChIJmfFVHhBAc2sRIPQyFmh9AQU', -32.867778, 151.706111, 'city', '1'),
('countries_australia_new_south_wales_sandringham', 'ChIJfSQbu4C3EmsRIMoyFmh9AQU', -33.9986108, 151.1395914, 'city', '1'),
('countries_australia_new_south_wales_sandy_beach', 'ChIJ1-dkPz71m2sRsJhDkLQJBgQ', -30.1412739, 153.1737578, 'city', '1'),
('countries_australia_new_south_wales_sandy_flat', 'ChIJZVmAqjz_mGsRYLVDkLQJBgQ', -29.2136531, 151.937138, 'city', '1'),
('countries_australia_new_south_wales_sandy_hill', 'ChIJqYZtrkC4mWsRcLVDkLQJBgQ', -28.9393799, 152.2326104, 'city', '1'),
('countries_australia_new_south_wales_sans_souci', 'ChIJQ7kWaSy4EmsRUMoyFmh9AQU', -33.98898, 151.1393, 'city', '1'),
('countries_australia_new_south_wales_san_isidore', 'ChIJ1U1iOPehGGsRoCZEkLQJBgU', -35.1243975, 147.2903334, 'city', '1'),
('countries_australia_new_south_wales_san_remo', 'ChIJE3yLTO_ZcmsRwN0yFmh9AQU', -33.2153793, 151.5223628, 'city', '1'),
('countries_australia_new_south_wales_sapphire_beach', 'ChIJqT-9TlYJnGsRQC1EkLQJBgU', -30.2263772, 153.1354693, 'city', '1'),
('countries_australia_new_south_wales_saratoga', 'ChIJn9MHSOC0cmsR0N0yFmh9AQU', -33.475, 151.348, 'city', '1'),
('countries_australia_new_south_wales_saumarez', 'ChIJK8LkHI-bn2sRgLVDkLQJBgQ', -30.5610718, 151.5801181, 'city', '1'),
('countries_australia_new_south_wales_sawtell', 'ChIJsThmV3YRnGsRgB9EkLQJBgU', -30.3720946, 153.0942431, 'city', '1'),
('countries_australia_new_south_wales_scarborough', 'ChIJBardVIbgEmsR0OUyFmh9AQU', -34.270556, 150.960278, 'city', '1'),
('countries_australia_new_south_wales_schofields', 'ChIJD1UvmryeEmsRcMoyFmh9AQU', -33.7, 150.8833, 'city', '1'),
('countries_australia_new_south_wales_scone', 'ChIJOalAj3tsC2sRwIlDkLQJBgQ', -32.0546144, 150.859482, 'city', '1'),
('countries_australia_new_south_wales_scotland_island', 'ChIJH0cbkQ1TDWsRgMoyFmh9AQU', -33.6395909, 151.290404, 'city', '1'),
('countries_australia_new_south_wales_scotts_head', 'ChIJ3w6le_ounGsR0JhDkLQJBgQ', -30.7492859, 152.9941554, 'city', '1'),
('countries_australia_new_south_wales_seaforth', 'ChIJK3E00VupEmsRsMoyFmh9AQU', -33.796, 151.238, 'city', '1'),
('countries_australia_new_south_wales_seaham', 'ChIJV0w_lgRoc2sR8IlDkLQJBgQ', -32.665, 151.717778, 'city', '1'),
('countries_australia_new_south_wales_seahampton', 'ChIJ9VfyMRY5c2sRMPQyFmh9AQU', -32.8854173, 151.5778481, 'city', '1'),
('countries_australia_new_south_wales_seal_rocks', 'ChIJE5X8160VdGsRUKhDkLQJBgQ', -32.4353409, 152.525707, 'city', '1'),
('countries_australia_new_south_wales_sedgefield', 'ChIJCY9FvgGuDGsRAIpDkLQJBgQ', -32.5425226, 151.2393885, 'city', '1'),
('countries_australia_new_south_wales_seelands', 'ChIJuT5Gk6bZm2sRYBxEkLQJBgQ', -29.6270567, 152.8794075, 'city', '1'),
('countries_australia_new_south_wales_sefton', 'ChIJaS4d3Qe9EmsRwMoyFmh9AQU', -33.88836, 151.00713, 'city', '1'),
('countries_australia_new_south_wales_seven_hills', 'ChIJ26epfYiYEmsR0MoyFmh9AQU', -33.7779167, 150.931946, 'city', '1'),
('countries_australia_new_south_wales_shalvey', 'ChIJ74V-agybEmsR4MoyFmh9AQU', -33.7270571, 150.8057017, 'city', '1'),
('countries_australia_new_south_wales_shannon_brook', 'ChIJE8O9_GQDmmsRoPxDkLQJBgQ', -28.90304, 152.9632555, 'city', '1'),
('countries_australia_new_south_wales_shannon_vale', 'ChIJzw3KYX7PmGsRoLVDkLQJBgQ', -29.7272292, 151.7950896, 'city', '1'),
('countries_australia_new_south_wales_shaw', 'ChIJlcitJEKwEmsRuKlm1cG4N6A', -33.7545424, 150.773315, 'city', '1'),
('countries_australia_new_south_wales_shellharbour', 'ChIJywgTha4TE2sR8OUyFmh9AQU', -34.583333, 150.866667, 'city', '1'),
('countries_spain_castille_and_leon_barruelo_de_santullan', 'ChIJRb_3YBzxSA0Rvp847gwNXZE', 42.8808075, -4.2948884, 'city', '0'),
('countries_australia_new_south_wales_shell_cove', 'ChIJswQF218TE2sR4OUyFmh9AQU', -34.59, 150.861667, 'city', '1'),
('countries_australia_new_south_wales_shoalhaven_heads', 'ChIJO0RnH3J8E2sRAOYyFmh9AQU', -34.8502272, 150.741554, 'city', '1'),
('countries_australia_new_south_wales_shoal_bay', 'ChIJnzVHv5mGc2sRUPQyFmh9AQU', -32.7257353, 152.175002, 'city', '1'),
('countries_australia_new_south_wales_shortland', 'ChIJhaqSp4Q_c2sRYPQyFmh9AQU', -32.882, 151.685, 'city', '1'),
('countries_australia_new_south_wales_silverdale', 'ChIJ1Vilp0PzEmsRwDszFmh9AQU', -33.9056974, 150.6144729, 'city', '1'),
('countries_australia_new_south_wales_silverwater', 'ChIJufk0l1ijEmsRAMsyFmh9AQU', -33.8339902, 151.0482995, 'city', '1'),
('countries_australia_new_south_wales_singleton', 'ChIJH-nW-yuwDGsRACFEkLQJBgU', -32.5694741, 151.1788155, 'city', '1'),
('countries_australia_new_south_wales_singleton_heights', 'ChIJj326g8KvDGsRECFEkLQJBgU', -32.5410449, 151.1607111, 'city', '1'),
('countries_australia_new_south_wales_skennars_head', 'ChIJY6-ToC9-kGsR8CtEkLQJBgU', -28.82639, 153.60528, 'city', '1'),
('countries_australia_new_south_wales_skinners_shoot', 'ChIJLWOBBohikGsR0PxDkLQJBgQ', -28.665278, 153.584722, 'city', '1'),
('countries_australia_new_south_wales_smeaton_grange', 'ChIJwY_PGoDxEmsREMsyFmh9AQU', -34.035, 150.757, 'city', '1'),
('countries_australia_new_south_wales_smithfield', 'ChIJzx-d3sSXEmsRIMsyFmh9AQU', -33.8535722, 150.9406861, 'city', '1'),
('countries_australia_new_south_wales_smiths_creek', 'ChIJJZEk3ca-kGsR8PxDkLQJBgQ', -28.4198335, 153.3741449, 'city', '1'),
('countries_australia_new_south_wales_smiths_lake', 'ChIJO0pJxNY_dGsRcKhDkLQJBgQ', -32.3805457, 152.5027074, 'city', '1'),
('countries_australia_new_south_wales_sofala', 'ChIJgx3N0lcMDmsRcGtDkLQJBgQ', -33.0808225, 149.6881768, 'city', '1'),
('countries_australia_new_south_wales_soldiers_point', 'ChIJo2o5VqV4c2sRgPQyFmh9AQU', -32.706667, 152.067778, 'city', '1'),
('countries_australia_new_south_wales_somersby', 'ChIJwVwlzFo0DWsRAN4yFmh9AQU', -33.3569025, 151.2904349, 'city', '1'),
('countries_australia_new_south_wales_somerton', 'ChIJM5idw8KBCmsR4MNDkLQJBgQ', -30.9656505, 150.639396, 'city', '1'),
('countries_australia_new_south_wales_southgate', 'ChIJxfJKaSPQm2sRwBxEkLQJBgQ', -29.6059549, 153.0029847, 'city', '1'),
('countries_australia_new_south_wales_south_bowenfels', 'ChIJ0VXE8OILEmsRECJEkLQJBgU', -33.5043842, 150.1253123, 'city', '1'),
('countries_australia_new_south_wales_south_coogee', 'ChIJN4r8nTeyEmsRMMsyFmh9AQU', -33.933, 151.259, 'city', '1'),
('countries_australia_new_south_wales_south_durras', 'ChIJyz36xR25FWsR8A5EkLQJBgQ', -35.662222, 150.292222, 'city', '1'),
('countries_australia_new_south_wales_south_golden_beach', 'ChIJJX8ywhD1kGsRoTkHRLbxyys', -28.4981216, 153.5470945, 'city', '1'),
('countries_australia_new_south_wales_south_grafton', 'ChIJGwUKqBzcm2sR4CxEkLQJBgU', -29.7256818, 152.9382447, 'city', '1'),
('countries_australia_new_south_wales_south_granville', 'ChIJeXY6RN28EmsRQMsyFmh9AQU', -33.8577224, 151.0107506, 'city', '1'),
('countries_spain_castille_and_leon_arroyo_de_la_encomienda', 'ChIJg0TLWcttRw0RIJD1WgeHBQQ', 41.626038, -4.795053, 'city', '0'),
('countries_australia_new_south_wales_south_hurstville', 'ChIJxeZEK7C5EmsRUMsyFmh9AQU', -33.98, 151.1035, 'city', '1'),
('countries_australia_new_south_wales_south_lismore', 'ChIJdbvO42B1mmsRsCtEkLQJBgU', -28.8163175, 153.2562482, 'city', '1'),
('countries_australia_new_south_wales_south_maroota', 'ChIJq7KWUVRdDWsR8L8yFmh9AQU', -33.5241, 150.9485, 'city', '1'),
('countries_australia_new_south_wales_south_murwillumbah', 'ChIJn4uQQDnwkGsRsCpEkLQJBgU', -28.3406514, 153.4095259, 'city', '1'),
('countries_australia_new_south_wales_south_penrith', 'ChIJmbRGdEGPEmsRADkzFmh9AQU', -33.7715054, 150.7011034, 'city', '1'),
('countries_australia_new_south_wales_south_wentworthville', 'ChIJSRHi5raiEmsRcMsyFmh9AQU', -33.8178167, 150.9692855, 'city', '1'),
('countries_australia_new_south_wales_south_west_rocks', 'ChIJ8Z_0n3rOnWsRQJlDkLQJBgQ', -30.884167, 153.040278, 'city', '1'),
('countries_australia_new_south_wales_south_windsor', 'ChIJ1fWWxZ-dEmsRgMsyFmh9AQU', -33.62535, 150.80437, 'city', '1'),
('countries_australia_new_south_wales_speers_point', 'ChIJaTxU3GE8c2sRoPQyFmh9AQU', -32.963333, 151.627778, 'city', '1'),
('countries_australia_new_south_wales_spencer', 'ChIJuYINPkNJDWsREN4yFmh9AQU', -33.457, 151.143, 'city', '1'),
('countries_australia_new_south_wales_spicers_creek', 'ChIJ98o_7zz9DmsR4HxDkLQJBgQ', -32.3108172, 149.1569248, 'city', '1'),
('countries_australia_new_south_wales_splitters_creek', 'ChIJyZQwNyJfIWsRcCdEkLQJBgU', -36.06, 146.84, 'city', '1'),
('countries_australia_new_south_wales_springdale', 'ChIJgVxHnOWjGWsRQO5DkLQJBgQ', -34.465101, 147.7435137, 'city', '1'),
('countries_australia_new_south_wales_springdale_heights', 'ChIJY3NxZsDeI2sRgCdEkLQJBgU', -36.033, 146.95, 'city', '1'),
('countries_australia_new_south_wales_springvale', 'ChIJQaafSQ6fGGsRsCZEkLQJBgU', -35.168617, 147.334258, 'city', '1'),
('countries_australia_new_south_wales_springwood', 'ChIJNchO2X19EmsRkNUyFmh9AQU', -33.7, 150.55, 'city', '1'),
('countries_australia_new_south_wales_spring_farm', 'ChIJUeLnuYTwEmsRoMsyFmh9AQU', -34.072, 150.718, 'city', '1'),
('countries_australia_new_south_wales_spring_field', 'ChIJBX48CIbKcmsRIN4yFmh9AQU', -33.424, 151.368, 'city', '1'),
('countries_australia_new_south_wales_spring_grove', 'ChIJIZ-wpDUKmmsRIP1DkLQJBgQ', -28.834059, 153.1024117, 'city', '1'),
('countries_australia_new_south_wales_spring_hill', 'ChIJPwaFW3HMEWsRkGtDkLQJBgQ', -33.398333, 149.152222, 'city', '1'),
('countries_australia_new_south_wales_spring_ridge', 'ChIJ26ce4G45CmsR8MNDkLQJBgQ', -31.3870615, 150.2469001, 'city', '1'),
('countries_australia_new_south_wales_stanford_merthyr', 'ChIJQbPFQ5k3c2sRsPQyFmh9AQU', -32.8247291, 151.4946272, 'city', '1'),
('countries_australia_new_south_wales_stanhope_gardens', 'ChIJ68k8khWfEmsRQMwyFmh9AQU', -33.723, 150.926, 'city', '1'),
('countries_australia_new_south_wales_stanmore', 'ChIJDcKDdj6wEmsRUMwyFmh9AQU', -33.8934542, 151.1643805, 'city', '1'),
('countries_australia_new_south_wales_stannum', 'ChIJu-zQthLymGsRALZDkLQJBgQ', -29.3243187, 151.7857155, 'city', '1'),
('countries_australia_new_south_wales_stanwell_park', 'ChIJJVl0KN3dEmsRIOYyFmh9AQU', -34.2286194, 150.9815057, 'city', '1'),
('countries_australia_new_south_wales_stanwell_tops', 'ChIJQe0bPuTdEmsRMOYyFmh9AQU', -34.2199, 150.99181, 'city', '1'),
('countries_spain_castille_and_leon_almazan', 'ChIJ2wN7xEaxRA0R0E31WgeHBQQ', 41.5128796, -2.5594214, 'city', '0'),
('countries_australia_new_south_wales_stockinbingal', 'ChIJJXasfiiWGWsRUO5DkLQJBgQ', -34.5, 147.883333, 'city', '1'),
('countries_australia_new_south_wales_stockrington', 'ChIJdwAdbKk5c2sRMEczFmh9AQU', -32.857083, 151.6030984, 'city', '1'),
('countries_australia_new_south_wales_stockton', 'ChIJYVmE76AUc2sR0PQyFmh9AQU', -32.915, 151.784444, 'city', '1'),
('countries_australia_new_south_wales_stokers_siding', 'ChIJiyN8GLbxkGsRMP1DkLQJBgQ', -28.4, 153.4, 'city', '1'),
('countries_australia_new_south_wales_stratford', 'ChIJtfRe--DwdGsRkKhDkLQJBgQ', -32.1156689, 151.9240697, 'city', '1'),
('countries_australia_new_south_wales_strathcedar', 'ChIJA6OynjK6dWsRoKhDkLQJBgQ', -31.7700987, 152.362383, 'city', '1'),
('countries_australia_new_south_wales_stratheden', 'ChIJLxqXHDeokGsRUP1DkLQJBgQ', -28.7451771, 152.952221, 'city', '1'),
('countries_australia_new_south_wales_strathfield_south', 'ChIJ5XGaLAi7EmsRcMwyFmh9AQU', -33.8943055, 151.0830083, 'city', '1'),
('countries_australia_new_south_wales_stroud', 'ChIJy5lC7JWLdGsRgIpDkLQJBgQ', -32.4033913, 151.9662649, 'city', '1'),
('countries_australia_new_south_wales_stroud_road', 'ChIJvch2RqqNdGsRoIpDkLQJBgQ', -32.3458136, 151.9439683, 'city', '1'),
('countries_australia_new_south_wales_stuarts_point', 'ChIJCRkeiR_TnWsRYJlDkLQJBgQ', -30.8107354, 152.9806092, 'city', '1'),
('countries_australia_new_south_wales_stuart_town', 'ChIJfyW1zqC1D2sR8GtDkLQJBgQ', -32.7992223, 149.0675878, 'city', '1'),
('countries_australia_new_south_wales_st_andrews', 'ChIJ50VUyDvsEmsRIPlBlBHpKkQ', -34.0197745, 150.8334745, 'city', '1'),
('countries_australia_new_south_wales_st_clair', 'ChIJBwShkBaQEmsRPsLgI-xTUhY', -33.7987, 150.7824, 'city', '1'),
('countries_australia_new_south_wales_st_helens_park', 'ChIJGT7N2IbvEmsR0MsyFmh9AQU', -34.1105, 150.8079, 'city', '1'),
('countries_australia_new_south_wales_st_huberts_island', 'ChIJCw94fcC0cmsRsN0yFmh9AQU', -33.499, 151.351, 'city', '1'),
('countries_australia_new_south_wales_st_ives_chase', 'ChIJ4X3pvsJXDWsR8MsyFmh9AQU', -33.711, 151.1595, 'city', '1'),
('countries_australia_new_south_wales_st_johns_park', 'ChIJ9SS_jZqWEmsRAMwyFmh9AQU', -33.8847, 150.907, 'city', '1'),
('countries_australia_new_south_wales_st_leonards', 'ChIJM_IDxN2uEmsREMwyFmh9AQU', -33.8227402, 151.1942171, 'city', '1'),
('countries_australia_new_south_wales_suffolk_park', 'ChIJrxpZgIBikGsRYP1DkLQJBgQ', -28.6877669, 153.6073888, 'city', '1'),
('countries_spain_cantabria_termino', 'ChIJKUy-vg6dTw0RAUq3bq9Tb7I', 42.7151216, -3.059498, 'city', '0'),
('countries_australia_new_south_wales_summerland_point', 'ChIJbRkku4HYcmsRMN4yFmh9AQU', -33.132, 151.568, 'city', '1'),
('countries_australia_new_south_wales_summer_hill', 'ChIJ36EKB5-6EmsRgMwyFmh9AQU', -33.891841, 151.1379367, 'city', '1'),
('countries_australia_new_south_wales_summer_hill_creek', 'ChIJp-JpRv_UEWsREGxDkLQJBgQ', -33.2063532, 149.1443634, 'city', '1'),
('countries_australia_new_south_wales_sunny_corner', 'ChIJXV7s7Lf_DWsRIGxDkLQJBgQ', -33.3846486, 149.8876755, 'city', '1'),
('countries_australia_new_south_wales_sunshine_bay', 'ChIJFaXVYrXqFWsR0ChEkLQJBgU', -35.7442199, 150.2067334, 'city', '1'),
('countries_australia_new_south_wales_sun_valley', 'ChIJ60AFUJKHEmsRYEczFmh9AQU', -33.7071152, 150.5907743, 'city', '1'),
('countries_australia_new_south_wales_surfside', 'ChIJWZPu3m_AFWsR8ChEkLQJBgU', -35.6954083, 150.196603, 'city', '1'),
('countries_australia_new_south_wales_surry_hills', 'ChIJW7w1-SGuEmsRkMwyFmh9AQU', -33.886111, 151.211111, 'city', '1'),
('countries_australia_new_south_wales_sussex_inlet', 'ChIJjwrFIbxhFGsRYNhDkLQJBgQ', -35.15, 150.566667, 'city', '1'),
('countries_australia_new_south_wales_sutherland', 'ChIJoV1LCC3BEmsRoMwyFmh9AQU', -34.0297415, 151.059275, 'city', '1'),
('countries_australia_new_south_wales_sutton', 'ChIJEVAiDAz2FmsR8OJDkLQJBgQ', -35.1645856, 149.2539109, 'city', '1'),
('countries_australia_new_south_wales_sutton_forest', 'ChIJFXFH95OaE2sRgJFDkLQJBgQ', -34.5667, 150.3167, 'city', '1'),
('countries_australia_new_south_wales_swanhaven', 'ChIJdSIULH5gFGsRcNhDkLQJBgQ', -35.186346, 150.5733615, 'city', '1'),
('countries_australia_new_south_wales_swansea', 'ChIJp6rkad8jc2sR8PQyFmh9AQU', -33.085, 151.635, 'city', '1'),
('countries_australia_new_south_wales_swansea_heads', 'ChIJ0Rtsqiwic2sRAPUyFmh9AQU', -33.093, 151.662, 'city', '1'),
('countries_australia_new_south_wales_swan_bay', 'ChIJa_ewUaZ7c2sRsEUzFmh9AQU', -32.6740762, 151.9228485, 'city', '1'),
('countries_australia_new_south_wales_sweetmans_creek', 'ChIJbxw-IgLPDGsR4IpDkLQJBgQ', -32.89012, 151.1811052, 'city', '1'),
('countries_australia_new_south_wales_sydenham', 'ChIJCbOw3l6wEmsRsMwyFmh9AQU', -33.9158055, 151.1679944, 'city', '1'),
('countries_australia_new_south_wales_sydney_olympic_park', 'ChIJhZxZzrikEmsRwLoyFmh9AQU', -33.8465088, 151.0722137, 'city', '1'),
('countries_australia_new_south_wales_sylvania', 'ChIJBQ6aAbC5EmsR0MwyFmh9AQU', -34.0080021, 151.1056919, 'city', '1'),
('countries_australia_new_south_wales_sylvania_waters', 'ChIJ7_Hslm24EmsR4MwyFmh9AQU', -34.02318, 151.11156, 'city', '1'),
('countries_australia_new_south_wales_table_top', 'ChIJ3fXg1sPbI2sRYO5DkLQJBgQ', -35.968169, 146.9970895, 'city', '1'),
('countries_australia_new_south_wales_tabulam', 'ChIJo8e2MBzvmWsRYLZDkLQJBgQ', -28.918188, 152.5517026, 'city', '1'),
('countries_australia_new_south_wales_tacoma', 'ChIJ42RdfBvQcmsRUN4yFmh9AQU', -33.299, 151.468, 'city', '1'),
('countries_australia_new_south_wales_tacoma_south', 'ChIJQfDH3NfRcmsRYN4yFmh9AQU', -33.296, 151.453, 'city', '1'),
('countries_australia_new_south_wales_tahmoor', 'ChIJYwcea9X_EmsRkJFDkLQJBgQ', -34.2288439, 150.5907563, 'city', '1'),
('countries_australia_new_south_wales_talarm', 'ChIJq3PwhIYpnGsRgJlDkLQJBgQ', -30.7009767, 152.8382315, 'city', '1'),
('countries_australia_new_south_wales_tallimba', 'ChIJUSUmsqBNGWsRYNFDkLQJBgQ', -34.0032692, 146.8869926, 'city', '1'),
('countries_australia_new_south_wales_tallong', 'ChIJo97e5Jb1E2sRoJFDkLQJBgQ', -34.716667, 150.083333, 'city', '1'),
('countries_australia_new_south_wales_tallwoods_village', 'ChIJW7CV0CfLdWsRwKhDkLQJBgQ', -32.0545486, 152.5120622, 'city', '1'),
('countries_australia_new_south_wales_talmalmo', 'ChIJC-eQcaG6I2sRgO5DkLQJBgQ', -36.0170734, 147.3447048, 'city', '1'),
('countries_australia_new_south_wales_taloumbi', 'ChIJf7D5XLa0m2sREB1EkLQJBgQ', -29.5396771, 153.2518266, 'city', '1'),
('countries_australia_new_south_wales_tamarama', 'ChIJKyE4yYWtEmsR8MwyFmh9AQU', -33.898, 151.268, 'city', '1'),
('countries_australia_new_south_wales_taminda', 'ChIJlZEiu8-YCmsRYClEkLQJBgU', -31.083333, 150.904167, 'city', '1'),
('countries_australia_new_south_wales_tamworth', 'ChIJH9ZCOLaYCmsRcClEkLQJBgU', -31.092748, 150.9320334, 'city', '1'),
('countries_australia_new_south_wales_tanilba_bay', 'ChIJvy0RlPR5c2sREPUyFmh9AQU', -32.737222, 151.998333, 'city', '1'),
('countries_australia_new_south_wales_tanja', 'ChIJrzTqAVaHPmsRMA9EkLQJBgQ', -36.620144, 149.9681453, 'city', '1'),
('countries_australia_new_south_wales_tantonan', 'ChIJw_xvVTcu2WoRcNFDkLQJBgQ', -35.7069505, 144.6278498, 'city', '1'),
('countries_australia_new_south_wales_tapitallee', 'ChIJqfNREWmAE2sRkNhDkLQJBgQ', -34.832052, 150.5182348, 'city', '1'),
('countries_australia_new_south_wales_tarago', 'ChIJ-a3UT96OFmsRAONDkLQJBgQ', -35.0876839, 149.6665391, 'city', '1'),
('countries_australia_new_south_wales_taralga', 'ChIJserzU95bEWsREONDkLQJBgQ', -34.3961343, 149.8192274, 'city', '1'),
('countries_australia_new_south_wales_tarana', 'ChIJfWEJGTkDEmsRcGxDkLQJBgQ', -33.5246029, 149.9082103, 'city', '1'),
('countries_australia_new_south_wales_tarbuck_bay', 'ChIJ_ZezC8M_dGsR0KhDkLQJBgQ', -32.3639071, 152.4797685, 'city', '1'),
('countries_australia_new_south_wales_tarcutta', 'ChIJi6thNBB_GGsRoO5DkLQJBgQ', -35.283333, 147.716667, 'city', '1'),
('countries_australia_new_south_wales_taree', 'ChIJJ5FSVh_IdWsRsC5EkLQJBgU', -31.8894897, 152.4444453, 'city', '1'),
('countries_australia_new_south_wales_taren_point', 'ChIJ-WXt5hO4EmsREM0yFmh9AQU', -34.01909, 151.12028, 'city', '1'),
('countries_australia_new_south_wales_tarraganda', 'ChIJyShHiumBPmsRUA9EkLQJBgQ', -36.6764344, 149.8699399, 'city', '1'),
('countries_australia_new_south_wales_tarrawanna', 'ChIJLzd64QYcE2sRQOYyFmh9AQU', -34.378333, 150.888333, 'city', '1'),
('countries_australia_new_south_wales_tarro', 'ChIJFw68hspBc2sRIPUyFmh9AQU', -32.808972, 151.656083, 'city', '1'),
('countries_australia_new_south_wales_tascott', 'ChIJ0Rytcs9KDWsRcN4yFmh9AQU', -33.454, 151.314, 'city', '1'),
('countries_australia_new_south_wales_tatham', 'ChIJH_BeSccNmmsRkP1DkLQJBgQ', -28.9305883, 153.1631521, 'city', '1'),
('countries_australia_new_south_wales_tathra', 'ChIJFfwhyWCDPmsRYA9EkLQJBgQ', -36.7360215, 149.9674229, 'city', '1'),
('countries_australia_new_south_wales_tatton', 'ChIJm4cSzJSeGGsRwCZEkLQJBgU', -35.157222, 147.362222, 'city', '1'),
('countries_australia_new_south_wales_taylors_arm', 'ChIJeZNG7jB-nmsRsJlDkLQJBgQ', -30.7633628, 152.7147533, 'city', '1'),
('countries_australia_new_south_wales_tea_gardens', 'ChIJJTnVqXiAc2sREItDkLQJBgQ', -32.659597, 152.1523926, 'city', '1'),
('countries_australia_new_south_wales_telarah', 'ChIJy9xHU-BFc2sRQPUyFmh9AQU', -32.724167, 151.531111, 'city', '1'),
('countries_australia_new_south_wales_telegraph_point', 'ChIJiY-2XakHnmsR8KhDkLQJBgQ', -31.333333, 152.8, 'city', '1'),
('countries_australia_new_south_wales_telopea', 'ChIJETMnvpGjEmsRIM0yFmh9AQU', -33.79417, 151.03802, 'city', '1'),
('countries_australia_new_south_wales_temagog', 'ChIJFYT5gA9ynmsRwJlDkLQJBgQ', -31.0003913, 152.6148504, 'city', '1'),
('countries_australia_new_south_wales_temora', 'ChIJlYqZiEAJGWsRsO5DkLQJBgQ', -34.4450316, 147.5360981, 'city', '1'),
('countries_australia_new_south_wales_tempe', 'ChIJL0ZQn4mwEmsRMM0yFmh9AQU', -33.925048, 151.1604169, 'city', '1'),
('countries_australia_new_south_wales_tenambit', 'ChIJe1Vutv1Dc2sRUPUyFmh9AQU', -32.742778, 151.606667, 'city', '1'),
('countries_australia_new_south_wales_tennyson_point', 'ChIJN7zWMg2lEmsRQM0yFmh9AQU', -33.832435, 151.116938, 'city', '1'),
('countries_australia_new_south_wales_tenterfield', 'ChIJn6sjcP9SmGsRkLZDkLQJBgQ', -29.0575678, 152.0189859, 'city', '1'),
('countries_australia_new_south_wales_teralba', 'ChIJ5WF_uGg8c2sRYPUyFmh9AQU', -32.965, 151.601, 'city', '1'),
('countries_australia_new_south_wales_terara', 'ChIJN5uh8L5_E2sRUOYyFmh9AQU', -34.8697737, 150.6227031, 'city', '1'),
('countries_australia_new_south_wales_terranora', 'ChIJwZRZXkT5kGsRMDBEkLQJBgU', -28.2411564, 153.5039021, 'city', '1'),
('countries_australia_new_south_wales_terrey_hills', 'ChIJ_263kmNWDWsRUM0yFmh9AQU', -33.683, 151.223, 'city', '1'),
('countries_australia_new_south_wales_terrigal', 'ChIJiVj8d4a1cmsRgN4yFmh9AQU', -33.448011, 151.444461, 'city', '1'),
('countries_australia_new_south_wales_teven', 'ChIJE7Zsc3eBkGsR0P1DkLQJBgQ', -28.816667, 153.5, 'city', '1'),
('countries_australia_new_south_wales_tewinga', 'ChIJf08c4dgunGsR0JlDkLQJBgQ', -30.6464105, 152.9029404, 'city', '1'),
('countries_australia_new_south_wales_thalgarrah', 'ChIJla74rqQLn2sRoLZDkLQJBgQ', -30.3897002, 151.9221168, 'city', '1'),
('countries_australia_new_south_wales_tharbogang', 'ChIJVXj16euzH2sRkNFDkLQJBgQ', -34.2631073, 145.9835473, 'city', '1'),
('countries_australia_new_south_wales_theresa_park', 'ChIJ-TTfFAH0EmsR4DszFmh9AQU', -33.9911807, 150.6343154, 'city', '1'),
('countries_australia_new_south_wales_the_angle', 'ChIJ-cXK5UctFmsRQONDkLQJBgQ', -35.6022361, 149.1070983, 'city', '1'),
('countries_australia_new_south_wales_the_channon', 'ChIJg1lIr-yZkGsR4P1DkLQJBgQ', -28.666667, 153.283333, 'city', '1'),
('countries_spain_cantabria_selaya', 'ChIJcedV5EcsSQ0RC1IGxC3CvfU', 43.1997485, -3.7739869, 'city', '0'),
('countries_spain_cantabria_suances', 'ChIJBefyVghASQ0REDjLc4L1BAQ', 43.4215088, -4.0593255, 'city', '0'),
('countries_australia_new_south_wales_the_hill', 'ChIJnznSSmkUc2sRcPUyFmh9AQU', -32.931667, 151.776111, 'city', '1'),
('countries_australia_new_south_wales_the_junction', 'ChIJczAfzDkUc2sRgPUyFmh9AQU', -32.940278, 151.758889, 'city', '1'),
('countries_australia_new_south_wales_the_lagoon', 'ChIJR_u4cmnvEWsRgGxDkLQJBgQ', -33.5283648, 149.6055722, 'city', '1'),
('countries_australia_new_south_wales_the_oaks', 'ChIJ0RH5eDJWEmsRoDwzFmh9AQU', -34.0768, 150.571, 'city', '1'),
('countries_australia_new_south_wales_the_pinnacles', 'ChIJO6Q4XjTXm2sRQB1EkLQJBgQ', -29.5409536, 152.9264759, 'city', '1'),
('countries_australia_new_south_wales_the_pocket', 'ChIJm4WEuF3zkGsR8P1DkLQJBgQ', -28.499167, 153.483889, 'city', '1'),
('countries_australia_new_south_wales_the_ponds', 'ChIJJRC0RR6fEmsRAEkzFmh9AQU', -33.703, 150.909, 'city', '1'),
('countries_australia_new_south_wales_the_rock', 'ChIJsx68L48PImsRsNFDkLQJBgQ', -35.2689758, 147.1217548, 'city', '1'),
('countries_australia_new_south_wales_the_rocks', 'ChIJs49dtkKuEmsRYM0yFmh9AQU', -33.85985, 151.20901, 'city', '1'),
('countries_australia_new_south_wales_the_whiteman', 'ChIJEcMiqtvZm2sRYB1EkLQJBgQ', -29.6030435, 152.8676421, 'city', '1'),
('countries_australia_new_south_wales_thirlmere', 'ChIJEaRNVxAAE2sRwJFDkLQJBgQ', -34.2051876, 150.5535117, 'city', '1'),
('countries_australia_new_south_wales_thirroul', 'ChIJ4xsAUyngEmsRYOYyFmh9AQU', -34.3147312, 150.9103729, 'city', '1'),
('countries_australia_new_south_wales_thora', 'ChIJjQ8CS3KfnmsR4JlDkLQJBgQ', -30.4194409, 152.7985338, 'city', '1'),
('countries_australia_new_south_wales_thornleigh', 'ChIJaShEiSOnEmsRgM0yFmh9AQU', -33.7261791, 151.0841467, 'city', '1'),
('countries_australia_new_south_wales_thornton', 'ChIJx0fNj2VBc2sRkPUyFmh9AQU', -32.783333, 151.641667, 'city', '1'),
('countries_australia_new_south_wales_thredbo', 'ChIJ0V9Wjq9LI2sRJvgsdf-EavQ', -36.5012959, 148.310377, 'city', '1'),
('countries_australia_new_south_wales_thrumster', 'ChIJK5Gsf0v-dWsRIKlDkLQJBgQ', -31.4573692, 152.8323499, 'city', '1'),
('countries_australia_new_south_wales_thumb_creek', 'ChIJ4RO_0_-RnmsR8JlDkLQJBgQ', -30.6882091, 152.6207087, 'city', '1'),
('countries_australia_new_south_wales_thurgoona', 'ChIJpdRzaJngI2sRkCdEkLQJBgU', -36.05, 146.983333, 'city', '1'),
('countries_australia_new_south_wales_tibbuc', 'ChIJH1sKAMcCdWsRMKlDkLQJBgQ', -31.8199686, 151.9109692, 'city', '1'),
('countries_australia_new_south_wales_tibooburra', 'ChIJe27QeAfj9moRIAFEkLQJBgQ', -29.4330519, 142.0107687, 'city', '1'),
('countries_australia_new_south_wales_tighes_hill', 'ChIJ96OtCfsUc2sRoPUyFmh9AQU', -32.9050024, 151.7575709, 'city', '1'),
('countries_australia_new_south_wales_tilba_tilba', 'ChIJC6r_e_4SPmsR4AdEkLQJBgQ', -36.3153297, 150.0804582, 'city', '1'),
('countries_spain_cantabria_potes', 'ChIJZyp0ANqzSQ0RjOlVRFiXpIs', 43.1535814, -4.6237858, 'city', '0'),
('countries_australia_new_south_wales_tingha', 'ChIJ48I5C_LjoWsRELdDkLQJBgQ', -29.9389655, 151.2488616, 'city', '1'),
('countries_australia_new_south_wales_tingira_heights', 'ChIJBxhN1zw9c2sRsPUyFmh9AQU', -32.996, 151.66, 'city', '1'),
('countries_australia_new_south_wales_tinonee', 'ChIJ2fY80xu0dWsRQKlDkLQJBgQ', -31.933333, 152.416667, 'city', '1'),
('countries_australia_new_south_wales_tintenbar', 'ChIJZ1P8sSGBkGsRIP5DkLQJBgQ', -28.8, 153.516667, 'city', '1'),
('countries_australia_new_south_wales_tintin_hull', 'ChIJDfv389WgCmsRYMRDkLQJBgQ', -31.071944, 151.003611, 'city', '1'),
('countries_australia_new_south_wales_tirrannaville', 'ChIJf-UfO-6kFmsRcONDkLQJBgQ', -34.8260165, 149.6982547, 'city', '1'),
('countries_australia_new_south_wales_tocumwal', 'ChIJe237SnZX32oR4NFDkLQJBgQ', -35.8103782, 145.5727903, 'city', '1'),
('countries_australia_new_south_wales_tolland', 'ChIJwUt607SeGGsR0CZEkLQJBgU', -35.145128, 147.352078, 'city', '1'),
('countries_australia_new_south_wales_tomago', 'ChIJd0OYW1hqc2sRwPUyFmh9AQU', -32.8278598, 151.7283347, 'city', '1'),
('countries_australia_new_south_wales_tomakin', 'ChIJGYY8tofsFWsRsA9EkLQJBgQ', -35.823239, 150.1908146, 'city', '1'),
('countries_australia_new_south_wales_tomerong', 'ChIJ25Zp6A5iFGsRwNhDkLQJBgQ', -35.066667, 150.583333, 'city', '1'),
('countries_australia_new_south_wales_tomki', 'ChIJP0voFYgMmmsRLOvz1P2SUgg', -28.866667, 153.133333, 'city', '1'),
('countries_australia_new_south_wales_toms_creek', 'ChIJScRODbGSdWsRoKlDkLQJBgQ', -31.5375725, 152.375952, 'city', '1'),
('countries_australia_new_south_wales_tongarra', 'ChIJYzyrRlQLE2sR0JFDkLQJBgQ', -34.5850204, 150.6923902, 'city', '1'),
('countries_australia_new_south_wales_tooleybuc', 'ChIJl1ELNjFj3GoR8NFDkLQJBgQ', -35.0211961, 143.3454071, 'city', '1'),
('countries_australia_new_south_wales_toolijooa', 'ChIJkxg496x6E2sRMIkzvFv3e34', -34.765278, 150.784722, 'city', '1'),
('countries_australia_new_south_wales_tooma', 'ChIJyw9ywu7dImsR0O5DkLQJBgQ', -35.9754374, 148.0843345, 'city', '1'),
('countries_australia_new_south_wales_toongabbie', 'ChIJDVe0oXCYEmsRkM0yFmh9AQU', -33.7841326, 150.95429, 'city', '1'),
('countries_australia_new_south_wales_toormina', 'ChIJ7bOthZcRnGsRkB9EkLQJBgU', -30.35, 153.083333, 'city', '1'),
('countries_australia_new_south_wales_toothdale', 'ChIJcaSbpoo8PGsR0A9EkLQJBgQ', -36.7897544, 149.7552179, 'city', '1'),
('countries_australia_new_south_wales_toowoon_bay', 'ChIJkfBa3GvPcmsRsN4yFmh9AQU', -33.362571, 151.4975465, 'city', '1'),
('countries_australia_new_south_wales_topi_topi', 'ChIJobSGjuRpdGsRsKlDkLQJBgQ', -32.3619995, 152.3389146, 'city', '1'),
('countries_australia_new_south_wales_toronto', 'ChIJV3NTP8Akc2sR0PUyFmh9AQU', -33.016194, 151.582583, 'city', '1'),
('countries_australia_new_south_wales_tottenham', 'ChIJW8bWwcbBBGsRoHVDkLQJBgQ', -32.2449766, 147.3554488, 'city', '1'),
('countries_australia_new_south_wales_toukley', 'ChIJTy-T1vXacmsRwN4yFmh9AQU', -33.2624548, 151.5457228, 'city', '1'),
('countries_spain_cantabria_miengo', 'ChIJHUcfO65ASQ0RgDXLc4L1BAQ', 43.4236634, -3.9980485, 'city', '0'),
('countries_australia_new_south_wales_towradgi', 'ChIJ0bXIudEeE2sRcOYyFmh9AQU', -34.383333, 150.9, 'city', '1'),
('countries_australia_new_south_wales_towrang', 'ChIJ-07b2vSqFmsRkONDkLQJBgQ', -34.6872847, 149.8594, 'city', '1'),
('countries_australia_new_south_wales_trangie', 'ChIJp6xzWKi8BWsRsHVDkLQJBgQ', -32.0333806, 147.9816442, 'city', '1'),
('countries_australia_new_south_wales_tregear', 'ChIJDzROlOCaEmsRoM0yFmh9AQU', -33.75, 150.7944, 'city', '1'),
('countries_australia_new_south_wales_trentham_cliffs', 'ChIJN3-UuAocw2oRrGBEpb6GZrI', -34.216667, 142.25, 'city', '1'),
('countries_australia_new_south_wales_trundle', 'ChIJk5KIBCjWGmsR0HVDkLQJBgQ', -32.9200516, 147.705512, 'city', '1'),
('countries_australia_new_south_wales_trungley_hall', 'ChIJ4-ZYdORzGWsR4O5DkLQJBgQ', -34.2917756, 147.5555951, 'city', '1'),
('countries_australia_new_south_wales_trunkey', 'ChIJfUjqiiikEWsR8GxDkLQJBgQ', -33.8223905, 149.3242915, 'city', '1'),
('countries_australia_new_south_wales_tubbul', 'ChIJH8EQR0yLGWsR8O5DkLQJBgQ', -34.1864716, 148.0068368, 'city', '1'),
('countries_australia_new_south_wales_tucabia', 'ChIJdyUz6zfGm2sRkB1EkLQJBgQ', -29.6582493, 153.1443045, 'city', '1'),
('countries_australia_new_south_wales_tucki', 'ChIJoaoYbsx2mmsRcAmiYwP0ans', -28.908813, 153.327739, 'city', '1'),
('countries_australia_new_south_wales_tuena', 'ChIJn-XWUPUQEWsRAG1DkLQJBgQ', -34.004231, 149.3127913, 'city', '1'),
('countries_australia_new_south_wales_tuggerah', 'ChIJM7COjczPcmsR0N4yFmh9AQU', -33.299, 151.435, 'city', '1'),
('countries_australia_new_south_wales_tuggerawong', 'ChIJAahG2TDQcmsR4N4yFmh9AQU', -33.2838797, 151.4712744, 'city', '1'),
('countries_australia_new_south_wales_tullera', 'ChIJ_zZ0X7mekGsRcP5DkLQJBgQ', -28.7482845, 153.2916107, 'city', '1'),
('countries_australia_new_south_wales_tullibigeal', 'ChIJA8V-NyFyHGsRMNJDkLQJBgQ', -33.4213674, 146.7264972, 'city', '1'),
('countries_australia_new_south_wales_tullimbar', 'ChIJ4w0uSrgSE2sRgOYyFmh9AQU', -34.5787244, 150.7359613, 'city', '1'),
('countries_australia_new_south_wales_tumbarumba', 'ChIJyw6uFkbAImsRAO9DkLQJBgQ', -35.7694861, 148.0057003, 'city', '1'),
('countries_australia_new_south_wales_tumut', 'ChIJXZbtt9MaGGsRQDJEkLQJBgU', -35.3207508, 148.2325033, 'city', '1'),
('countries_australia_new_south_wales_tuncurry', 'ChIJA2nOwVE2dGsR0KlDkLQJBgQ', -32.175, 152.498889, 'city', '1'),
('countries_australia_new_south_wales_tuntable_creek', 'ChIJT4X2_nmXkGsRoP5DkLQJBgQ', -28.6286535, 153.2621415, 'city', '1'),
('countries_australia_new_south_wales_tura_beach', 'ChIJufYMNwqfPmsR8A9EkLQJBgQ', -36.85, 149.925, 'city', '1'),
('countries_australia_new_south_wales_turill', 'ChIJL9yiRvMBDGsREG1DkLQJBgQ', -32.1692448, 149.836018, 'city', '1'),
('countries_australia_new_south_wales_turners_flat', 'ChIJkb0hAspznmsRIJpDkLQJBgQ', -31.0389522, 152.6677339, 'city', '1'),
('countries_australia_new_south_wales_tuross_head', 'ChIJ6xgNOuodPmsRIBBEkLQJBgQ', -36.051603, 150.1298607, 'city', '1'),
('countries_australia_new_south_wales_turramurra', 'ChIJa85SZTmoEmsRsM0yFmh9AQU', -33.733499, 151.1279841, 'city', '1'),
('countries_australia_new_south_wales_turrella', 'ChIJR7thB5-wEmsRwM0yFmh9AQU', -33.93297, 151.14079, 'city', '1'),
('countries_australia_new_south_wales_turvey_park', 'ChIJgYRGsxaZGGsR4CZEkLQJBgU', -35.126128, 147.357078, 'city', '1'),
('countries_spain_cantabria_mahono', 'ChIJj2QUS5eHlRIRP_V2V-CKz-k', 39.8873296, 4.2596195, 'city', '1'),
('countries_australia_new_south_wales_twelve_mile_creek', 'ChIJXxd17lV7c2sRcItDkLQJBgQ', -32.6533352, 151.8671786, 'city', '1'),
('countries_australia_new_south_wales_tyagarah', 'ChIJd0H3ry-CkGsRsP5DkLQJBgQ', -28.6065992, 153.5527761, 'city', '1'),
('countries_australia_new_south_wales_tyalgum', 'ChIJA4CCP97ukGsRwP5DkLQJBgQ', -28.366667, 153.216667, 'city', '1'),
('countries_australia_new_south_wales_tyalgum_creek', 'ChIJf_-UETbCkGsR0P5DkLQJBgQ', -28.3539136, 153.1862767, 'city', '1'),
('countries_australia_new_south_wales_uki', 'ChIJueXzcXXtkGsR8P5DkLQJBgQ', -28.416667, 153.333333, 'city', '1'),
('countries_spain_cantabria_luzmela', 'ChIJ7UVHLbcRSQ0RQsXVngYie0Q', 43.298653, -4.2077669, 'city', '0'),
('countries_australia_new_south_wales_ulmarra', 'ChIJVQLrr1HFm2sR4B1EkLQJBgQ', -29.633333, 153.033333, 'city', '1'),
('countries_australia_new_south_wales_ultimo', 'ChIJLV6IoE6uEmsR0M0yFmh9AQU', -33.88223, 151.19696, 'city', '1'),
('countries_australia_new_south_wales_umina_beach', 'ChIJr8KubsFMDWsRcTsXW7e5oiY', -33.528746, 151.307503, 'city', '1'),
('countries_australia_new_south_wales_unanderra', 'ChIJaRHNM6UQE2sRkOYyFmh9AQU', -34.453611, 150.844722, 'city', '1'),
('countries_australia_new_south_wales_ungarie', 'ChIJGWOcFrMOHGsR8HVDkLQJBgQ', -33.6415417, 146.9747274, 'city', '1'),
('countries_australia_new_south_wales_upper_corindi', 'ChIJOTylXN3zm2sRUJpDkLQJBgQ', -30.0171535, 153.1159905, 'city', '1'),
('countries_australia_new_south_wales_upper_eden_creek', 'ChIJIfMxwF-ykGsRQP9DkLQJBgQ', -28.5377309, 152.8772014, 'city', '1'),
('countries_australia_new_south_wales_upper_kangaroo_river', 'ChIJN-e6hkh4E2sRANlDkLQJBgQ', -34.695565, 150.5936766, 'city', '1'),
('countries_australia_new_south_wales_upper_lansdowne', 'ChIJXT-BLybAdWsR4KlDkLQJBgQ', -31.7145658, 152.4621561, 'city', '1'),
('countries_australia_new_south_wales_upper_main_arm', 'ChIJVY1nY2rtkGsRYP9DkLQJBgQ', -28.4944004, 153.3816338, 'city', '1'),
('countries_australia_new_south_wales_upper_orara', 'ChIJvx_0N-AanGsRYJpDkLQJBgQ', -30.2772291, 152.9912123, 'city', '1'),
('countries_australia_new_south_wales_upper_rouchel', 'ChIJ84JeKyVIC2sR4ItDkLQJBgQ', -32.0900926, 151.0991807, 'city', '1'),
('countries_australia_new_south_wales_upper_wilsons_creek', 'ChIJj0RqDgyNkGsRcP9DkLQJBgQ', -28.5196744, 153.3859379, 'city', '1'),
('countries_australia_new_south_wales_uralba', 'ChIJc2oLRlF_mmsRgP9DkLQJBgQ', -28.87294, 153.47145, 'city', '1'),
('countries_australia_new_south_wales_uralla', 'ChIJE0ZkPcSPn2sRoLdDkLQJBgQ', -30.6414818, 151.4915632, 'city', '1'),
('countries_australia_new_south_wales_urana', 'ChIJ0Vi6Q1iyIWsRUNJDkLQJBgQ', -35.3217553, 146.2702309, 'city', '1'),
('countries_australia_new_south_wales_urangeline_east', 'ChIJKcRGqTOaIWsRcNJDkLQJBgQ', -35.4632532, 146.6822613, 'city', '1'),
('countries_australia_new_south_wales_uranquinty', 'ChIJqcJX9AELImsRgNJDkLQJBgQ', -35.1885222, 147.2444739, 'city', '1'),
('countries_australia_new_south_wales_urbenville', 'ChIJw7KXBkxDl2sRsLdDkLQJBgQ', -28.4610555, 152.5183013, 'city', '1'),
('countries_australia_new_south_wales_urila', 'ChIJsUV_sgE6FmsRsONDkLQJBgQ', -35.5644615, 149.2994956, 'city', '1'),
('countries_australia_new_south_wales_urunga', 'ChIJpyoqIpQjnGsRgJpDkLQJBgQ', -30.5, 153.016667, 'city', '1'),
('countries_australia_new_south_wales_utungun', 'ChIJSYUncO0qnGsRkJpDkLQJBgQ', -30.7474711, 152.8323499, 'city', '1'),
('countries_australia_new_south_wales_vacy', 'ChIJ4Q3vPkJZc2sR8ItDkLQJBgQ', -32.531389, 151.568889, 'city', '1'),
('countries_australia_new_south_wales_valentine', 'ChIJYQLlZy4jc2sR4PUyFmh9AQU', -33.015, 151.635, 'city', '1'),
('countries_australia_new_south_wales_vale_of_clwydd', 'ChIJpUZ8GfAKEmsRQCJEkLQJBgU', -33.4868953, 150.1835794, 'city', '1'),
('countries_australia_new_south_wales_valla_beach', 'ChIJLQwtv9AknGsRwJpDkLQJBgQ', -30.5892461, 153.0077482, 'city', '1'),
('countries_australia_new_south_wales_valley_heights', 'ChIJG0XS5l59EmsRoNUyFmh9AQU', -33.7, 150.583333, 'city', '1'),
('countries_australia_new_south_wales_varroville', 'ChIJUQB9iPTtEmsR8M0yFmh9AQU', -34.00758, 150.8151, 'city', '1'),
('countries_australia_new_south_wales_vaucluse', 'ChIJlWSiaVesEmsRAM4yFmh9AQU', -33.85582, 151.2712, 'city', '1'),
('countries_australia_new_south_wales_verges_creek', 'ChIJ_xjGVJLenWsR0JpDkLQJBgQ', -31.089753, 152.8911736, 'city', '1'),
('countries_australia_new_south_wales_verona', 'ChIJBYsMXXt4PmsRQBBEkLQJBgQ', -36.4506326, 149.8414891, 'city', '1'),
('countries_australia_new_south_wales_villawood', 'ChIJibUXVby9EmsREM4yFmh9AQU', -33.881495, 150.9821162, 'city', '1'),
('countries_australia_new_south_wales_vincentia', 'ChIJxc7Ll6yJFGsRINlDkLQJBgQ', -35.076667, 150.673611, 'city', '1'),
('countries_australia_new_south_wales_vineyard', 'ChIJx1rYB3KeEmsRIM4yFmh9AQU', -33.65021, 150.85619, 'city', '1'),
('countries_australia_new_south_wales_voyager_point', 'ChIJpRqL88i_EmsRMM4yFmh9AQU', -33.959, 150.979, 'city', '1'),
('countries_australia_new_south_wales_wadalba', 'ChIJobU99LTRcmsRIN8yFmh9AQU', -33.273, 151.468, 'city', '1'),
('countries_australia_new_south_wales_wadeville', 'ChIJtZMbbLu9kGsRkP9DkLQJBgQ', -28.5537944, 153.1384143, 'city', '1'),
('countries_australia_new_south_wales_wagga_wagga', 'ChIJd7Z4Op2ZGGsR8CZEkLQJBgU', -35.1081689, 147.3598323, 'city', '1'),
('countries_australia_new_south_wales_wagstaffe', 'ChIJacFeP0WzcmsRMN8yFmh9AQU', -33.524, 151.343, 'city', '1'),
('countries_australia_new_south_wales_wahroonga', 'ChIJ88Scy6qpEmsRUM4yFmh9AQU', -33.7186308, 151.1103686, 'city', '1'),
('countries_australia_new_south_wales_waitara', 'ChIJuST4ApCnEmsRYM4yFmh9AQU', -33.7083472, 151.1068252, 'city', '1'),
('countries_australia_new_south_wales_wakeley', 'ChIJcV5qr2WWEmsRcM4yFmh9AQU', -33.8762, 150.9123, 'city', '1'),
('countries_australia_new_south_wales_wakool', 'ChIJiXdTLF203moRkNJDkLQJBgQ', -35.4689681, 144.3887437, 'city', '1'),
('countries_australia_new_south_wales_walang', 'ChIJM-rr_Wn5EWsR0G1DkLQJBgQ', -33.4521439, 149.7813222, 'city', '1'),
('countries_australia_new_south_wales_walbundrie', 'ChIJHX6BK7t3IWsRoNJDkLQJBgQ', -35.6942841, 146.741558, 'city', '1'),
('countries_australia_new_south_wales_walcha', 'ChIJlYoENmncn2sRwLdDkLQJBgQ', -30.9852458, 151.5932704, 'city', '1'),
('countries_australia_new_south_wales_walgett', 'ChIJ9S0VPodlqGsRoLtDkLQJBgQ', -30.0267969, 148.1231039, 'city', '1'),
('countries_australia_new_south_wales_wallabadah', 'ChIJ40y444nmCmsR0MRDkLQJBgQ', -31.5501711, 150.8267755, 'city', '1'),
('countries_australia_new_south_wales_wallabi_point', 'ChIJmWoddRnMdWsRUKpDkLQJBgQ', -31.9920486, 152.5590443, 'city', '1'),
('countries_australia_new_south_wales_wallacia', 'ChIJVVDgvzuLEmsRgM4yFmh9AQU', -33.865, 150.64, 'city', '1'),
('countries_australia_new_south_wales_wallaga_lake', 'ChIJ5fV2uRxyPmsRYBBEkLQJBgQ', -36.3859748, 150.0667836, 'city', '1'),
('countries_spain_cantabria_comillas', 'ChIJOWm55MMMSQ0RwkG2JL2yAoQ', 43.3856192, -4.2922535, 'city', '0'),
('countries_australia_new_south_wales_wallagoot', 'ChIJp6E_ldacPmsRcBBEkLQJBgQ', -36.7578618, 149.9399761, 'city', '1'),
('countries_australia_new_south_wales_wallalong', 'ChIJeUUko9FCc2sREPYyFmh9AQU', -32.698333, 151.651111, 'city', '1'),
('countries_australia_new_south_wales_wallarah', 'ChIJMe-oTibRcmsRoEIzFmh9AQU', -33.223, 151.465, 'city', '1'),
('countries_australia_new_south_wales_wallarobba', 'ChIJ3dbTu4WfdGsREIxDkLQJBgQ', -32.48838, 151.7021395, 'city', '1'),
('countries_australia_new_south_wales_walla_walla', 'ChIJV_eBPwB_IWsRsNJDkLQJBgQ', -35.7595533, 146.9021104, 'city', '1'),
('countries_australia_new_south_wales_wallendbeen', 'ChIJqS6ryTHoGWsRcO9DkLQJBgQ', -34.5229058, 148.1601074, 'city', '1'),
('countries_australia_new_south_wales_wallerawang', 'ChIJIX6LEe4HEmsR8G1DkLQJBgQ', -33.4107848, 150.0646998, 'city', '1'),
('countries_australia_new_south_wales_wallsend', 'ChIJCQp7E9w4c2sRIPYyFmh9AQU', -32.898, 151.668, 'city', '1'),
('countries_australia_new_south_wales_wamban', 'ChIJFS7sM-gCPmsRgBBEkLQJBgQ', -35.9490785, 150.0280161, 'city', '1'),
('countries_australia_new_south_wales_wambangalang', 'ChIJeQA92y2PD2sRsH1DkLQJBgQ', -32.5902423, 148.5319881, 'city', '1'),
('countries_australia_new_south_wales_wamberal', 'ChIJ5XQL8BTKcmsRQN8yFmh9AQU', -33.418, 151.443, 'city', '1'),
('countries_australia_new_south_wales_wamboin', 'ChIJW5DRFENaFmsR0ONDkLQJBgQ', -35.258333, 149.306944, 'city', '1'),
('countries_australia_new_south_wales_wandandian', 'ChIJc3dKDAhkFGsRMNlDkLQJBgQ', -35.083333, 150.5, 'city', '1'),
('countries_australia_new_south_wales_wanganella', 'ChIJ6YpXuxYa32oR4NJDkLQJBgQ', -35.2950052, 144.9057903, 'city', '1'),
('countries_australia_new_south_wales_wangi_wangi', 'ChIJcWCmX34mc2sRMPYyFmh9AQU', -33.065, 151.568, 'city', '1'),
('countries_australia_new_south_wales_wang_wauk', 'ChIJTw6DU8xRdGsRkKpDkLQJBgQ', -32.1388696, 152.2802565, 'city', '1'),
('countries_australia_new_south_wales_wantabadgery', 'ChIJJQhTGpNeGGsRgO9DkLQJBgQ', -35.0517968, 147.7234588, 'city', '1'),
('countries_australia_new_south_wales_warabrook', 'ChIJu9B1vGkVc2sRQPYyFmh9AQU', -32.881667, 151.717778, 'city', '1'),
('countries_australia_new_south_wales_waratah', 'ChIJTz7auQoVc2sRUPYyFmh9AQU', -32.905278, 151.725, 'city', '1'),
('countries_australia_new_south_wales_waratah_west', 'ChIJsW7pZncVc2sRYPYyFmh9AQU', -32.901, 151.715, 'city', '1'),
('countries_australia_new_south_wales_wardell', 'ChIJNbSJZLl7mmsRsP9DkLQJBgQ', -28.95, 153.466667, 'city', '1'),
('countries_australia_new_south_wales_wards_river', 'ChIJjxrXi8WMdGsRoKpDkLQJBgQ', -32.2078852, 151.9367506, 'city', '1'),
('countries_australia_new_south_wales_wareemba', 'ChIJ1TADPVulEmsRkM4yFmh9AQU', -33.8574937, 151.1323094, 'city', '1'),
('countries_australia_new_south_wales_warialda', 'ChIJkWKpQpsyomsREMVDkLQJBgQ', -29.5186316, 150.5537746, 'city', '1'),
('countries_australia_new_south_wales_warilla', 'ChIJUcJ37QoUE2sRoOYyFmh9AQU', -34.552778, 150.861667, 'city', '1'),
('countries_australia_new_south_wales_warners_bay', 'ChIJIUkeX4E8c2sRcPYyFmh9AQU', -32.982, 151.651, 'city', '1'),
('countries_australia_new_south_wales_warnervale', 'ChIJDWEY_1bQcmsRUN8yFmh9AQU', -33.249, 151.431, 'city', '1'),
('countries_australia_new_south_wales_warraderry', 'ChIJHekaA39wGmsRwH1DkLQJBgQ', -33.6532115, 148.3285577, 'city', '1'),
('countries_australia_new_south_wales_warragamba', 'ChIJax4NIraKEmsRsDszFmh9AQU', -33.891667, 150.603333, 'city', '1'),
('countries_australia_new_south_wales_warral', 'ChIJX8jQskuXCmsRcMVDkLQJBgQ', -31.1652, 150.8512, 'city', '1'),
('countries_australia_new_south_wales_warrawee', 'ChIJqdKcysanEmsRoM4yFmh9AQU', -33.7289366, 151.1218346, 'city', '1'),
('countries_australia_new_south_wales_warrawong', 'ChIJdwdQTj0XE2sRsOYyFmh9AQU', -34.484444, 150.8875, 'city', '1'),
('countries_australia_new_south_wales_warrell_creek', 'ChIJuxVXZnYsnGsR4JpDkLQJBgQ', -30.7739949, 152.9029404, 'city', '1'),
('countries_australia_new_south_wales_warren', 'ChIJv-v7_IXEBWsREHZDkLQJBgQ', -31.7026474, 147.8161713, 'city', '1'),
('countries_australia_new_south_wales_warriewood', 'ChIJBzvKfexUDWsRsM4yFmh9AQU', -33.69404, 151.30093, 'city', '1'),
('countries_australia_new_south_wales_warrimoo', 'ChIJSWP8jzSGEmsRsNUyFmh9AQU', -33.716667, 150.6, 'city', '1'),
('countries_australia_new_south_wales_warwick_farm', 'ChIJ0baH6OiVEmsRwM4yFmh9AQU', -33.911343, 150.9381637, 'city', '1'),
('countries_australia_new_south_wales_watanobbi', 'ChIJi3rPjPTRcmsRYN8yFmh9AQU', -33.269, 151.426, 'city', '1'),
('countries_australia_new_south_wales_waterfall', 'ChIJSW9MU-TCEmsREDkzFmh9AQU', -34.1424139, 150.9918338, 'city', '1'),
('countries_australia_new_south_wales_waterloo', 'ChIJG2TSH8OxEmsR0M4yFmh9AQU', -33.9002604, 151.2061803, 'city', '1'),
('countries_australia_new_south_wales_waterview_heights', 'ChIJCWxup9nYm2sRMB5EkLQJBgQ', -29.698286, 152.8382315, 'city', '1'),
('countries_australia_new_south_wales_watsons_bay', 'ChIJRbw1k4msEmsR4M4yFmh9AQU', -33.8398183, 151.2816573, 'city', '1'),
('countries_australia_new_south_wales_watsons_creek', 'ChIJPzlcLRY-oGsRgMVDkLQJBgQ', -30.7235404, 151.0509273, 'city', '1'),
('countries_australia_new_south_wales_wattamondara', 'ChIJyWJ5OA-XEGsR0H1DkLQJBgQ', -33.9408967, 148.5983143, 'city', '1'),
('countries_australia_new_south_wales_wattle_flat', 'ChIJz3RuiI4PDmsREG5DkLQJBgQ', -33.1523627, 149.6954884, 'city', '1'),
('countries_australia_new_south_wales_wattle_grove', 'ChIJtz1b7XOVEmsR8M4yFmh9AQU', -33.9492164, 150.9424079, 'city', '1'),
('countries_australia_new_south_wales_wattle_ponds', 'ChIJaUsQ2devDGsRICFEkLQJBgU', -32.5205427, 151.1927601, 'city', '1'),
('countries_spain_cantabria_barrio_de_la_iglesia', 'ChIJxeMnnGsNSQ0RMFVNCjGjQtE', 43.381759, -4.2510799, 'city', '0'),
('countries_australia_new_south_wales_waverton', 'ChIJ56WAAfquEmsRIM8yFmh9AQU', -33.84016, 151.19543, 'city', '1'),
('countries_australia_new_south_wales_wedderburn', 'ChIJEYBaZUbkEmsRMM8yFmh9AQU', -34.12612, 150.81789, 'city', '1'),
('countries_australia_new_south_wales_wee_jasper', 'ChIJ6Y6NtTGfF2sREORDkLQJBgQ', -35.1619847, 148.6862284, 'city', '1'),
('countries_australia_new_south_wales_wee_waa', 'ChIJeYhHEx93p2sRsLtDkLQJBgQ', -30.2265736, 149.4454667, 'city', '1'),
('countries_australia_new_south_wales_welaregang', 'ChIJH8FGJN_hImsRwO9DkLQJBgQ', -36.016667, 147.966667, 'city', '1'),
('countries_australia_new_south_wales_welby', 'ChIJ7cLCUxSjE2sRYCREkLQJBgU', -34.438543, 150.4341346, 'city', '1'),
('countries_spain_cantabria_adino', 'ChIJT70xk7nuTg0RZWbcZuddkio', 43.343137, -3.3275345, 'city', '0');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_australia_new_south_wales_wendoree_park', 'ChIJK4l1PbhIDWsRYEQzFmh9AQU', -33.4540773, 151.1607111, 'city', '1'),
('countries_australia_new_south_wales_wentworth', 'ChIJeRbQrdBbwmoRQAJEkLQJBgQ', -33.9563004, 141.9763143, 'city', '1'),
('countries_australia_new_south_wales_wentworthville', 'ChIJzTZ9DJaiEmsRQM8yFmh9AQU', -33.8059112, 150.9701895, 'city', '1'),
('countries_australia_new_south_wales_wentworth_falls', 'ChIJe-OwGm5vEmsRwNUyFmh9AQU', -33.7104501, 150.3756383, 'city', '1'),
('countries_australia_new_south_wales_wentworth_point', 'ChIJmzARUu6kEmsRfQ8bl8aaDY8', -33.828026, 151.0769775, 'city', '1'),
('countries_australia_new_south_wales_werombi', 'ChIJ6V298xz2EmsRcEkzFmh9AQU', -33.9818, 150.58459, 'city', '1'),
('countries_australia_new_south_wales_werrington', 'ChIJiaCo00KFEmsRUM8yFmh9AQU', -33.75943, 150.74708, 'city', '1'),
('countries_australia_new_south_wales_werrington_county', 'ChIJC3I-bT2FEmsRYM8yFmh9AQU', -33.7478023, 150.7475824, 'city', '1'),
('countries_australia_new_south_wales_werrington_downs', 'ChIJB49N_Q2FEmsRcM8yFmh9AQU', -33.7391, 150.7273, 'city', '1'),
('countries_australia_new_south_wales_werris_creek', 'ChIJiatCvDb0CmsRsMVDkLQJBgQ', -31.333333, 150.65, 'city', '1'),
('countries_australia_new_south_wales_werri_beach', 'ChIJ2SWjPRlvE2sRwOYyFmh9AQU', -34.7327699, 150.834043, 'city', '1'),
('countries_australia_new_south_wales_westdale', 'ChIJnRIQ1-abCmsRkClEkLQJBgU', -31.0967303, 150.8493059, 'city', '1'),
('countries_australia_new_south_wales_westleigh', 'ChIJsx3qlS-nEmsRwM8yFmh9AQU', -33.7204496, 151.0681715, 'city', '1'),
('countries_australia_new_south_wales_westmead', 'ChIJ4_dtJ0W9EmsR0M8yFmh9AQU', -33.8085661, 150.9869597, 'city', '1'),
('countries_australia_new_south_wales_weston', 'ChIJm7eqxP02c2sRkPYyFmh9AQU', -32.8148914, 151.4588056, 'city', '1'),
('countries_australia_new_south_wales_west_coraki', 'ChIJb3srZcUSmmsRUB5EkLQJBgQ', -29.0228833, 153.1999779, 'city', '1'),
('countries_australia_new_south_wales_west_gosford', 'ChIJA18wJVHKcmsRcN8yFmh9AQU', -33.415, 151.318, 'city', '1'),
('countries_australia_new_south_wales_west_haven', 'ChIJSd7FYN7idWsRAKtDkLQJBgQ', -31.6349527, 152.783833, 'city', '1'),
('countries_australia_new_south_wales_west_hoxton', 'ChIJWzcJehSTEmsRgM8yFmh9AQU', -33.93569, 150.8308, 'city', '1'),
('countries_australia_new_south_wales_west_kempsey', 'ChIJ5dBG3NYKnmsRIC5EkLQJBgU', -31.0572069, 152.8294091, 'city', '1'),
('countries_australia_new_south_wales_west_pennant_hills', 'ChIJrcXszj-hEmsRkM8yFmh9AQU', -33.7529959, 151.0257317, 'city', '1'),
('countries_australia_new_south_wales_west_ryde', 'ChIJR8wYJ1CkEmsRsM8yFmh9AQU', -33.8067672, 151.0824602, 'city', '1'),
('countries_australia_new_south_wales_west_wallsend', 'ChIJozyb0HY5c2sRgPYyFmh9AQU', -32.9062316, 151.5756575, 'city', '1'),
('countries_australia_new_south_wales_west_wyalong', 'ChIJeRDIzSvmG2sRUHZDkLQJBgQ', -33.9167698, 147.2043777, 'city', '1'),
('countries_australia_new_south_wales_wetherill_park', 'ChIJ13VruwWXEmsR4M8yFmh9AQU', -33.8488138, 150.8994889, 'city', '1'),
('countries_australia_new_south_wales_whalan', 'ChIJR2JHbfCaEmsR8M8yFmh9AQU', -33.7552075, 150.8056028, 'city', '1'),
('countries_australia_new_south_wales_whale_beach', 'ChIJo1bfNjatcmsRANAyFmh9AQU', -33.6117385, 151.3298927, 'city', '1'),
('countries_australia_new_south_wales_wheeler_heights', 'ChIJweMmm51VDWsRg7fMWmbjp80', -33.7267644, 151.2802762, 'city', '1'),
('countries_australia_new_south_wales_wherrol_flat', 'ChIJU6DQtD2udWsREKtDkLQJBgQ', -31.7802123, 152.228881, 'city', '1'),
('countries_australia_new_south_wales_whian_whian', 'ChIJ-zAVQfCQkGsR8P9DkLQJBgQ', -28.651426, 153.3134412, 'city', '1'),
('countries_australia_new_south_wales_whitebridge', 'ChIJNbY8lWs9c2sRoPYyFmh9AQU', -32.9812731, 151.7113419, 'city', '1'),
('countries_australia_new_south_wales_white_cliffs', 'ChIJ20l3dHdd-moRMAFEkLQJBgQ', -30.8523679, 143.0890939, 'city', '1'),
('countries_australia_new_south_wales_whittingham', 'ChIJJQQti6ixDGsRgIxDkLQJBgQ', -32.6043734, 151.2012782, 'city', '1'),
('countries_australia_new_south_wales_whitton', 'ChIJZejhS-ahH2sRUNNDkLQJBgQ', -34.51803, 146.1850104, 'city', '1'),
('countries_australia_new_south_wales_wiangaree', 'ChIJJRYjP_GwkGsRAABEkLQJBgQ', -28.5069127, 152.9673709, 'city', '1'),
('countries_australia_new_south_wales_wickham', 'ChIJh7VF01AUc2sRsPYyFmh9AQU', -32.9183844, 151.7570049, 'city', '1'),
('countries_australia_new_south_wales_wilberforce', 'ChIJMYlnEAdkDWsRsDkzFmh9AQU', -33.5530746, 150.8452821, 'city', '1'),
('countries_australia_new_south_wales_wilcannia', 'ChIJA5USFm0E-2oRQAFEkLQJBgQ', -31.5589892, 143.378448, 'city', '1'),
('countries_australia_new_south_wales_wildes_meadow', 'ChIJj1IOUb6CE2sRQJJDkLQJBgQ', -34.6152797, 150.5329572, 'city', '1'),
('countries_australia_new_south_wales_wiley_park', 'ChIJa9FRYOi7EmsRMNAyFmh9AQU', -33.9229004, 151.0683695, 'city', '1'),
('countries_australia_new_south_wales_willawarrin', 'ChIJ8yx4KZNxnmsREJtDkLQJBgQ', -30.9300986, 152.6277978, 'city', '1'),
('countries_australia_new_south_wales_williamtown', 'ChIJ4dfFC61rc2sRwPYyFmh9AQU', -32.8115041, 151.8442669, 'city', '1'),
('countries_australia_new_south_wales_willina', 'ChIJZ_TEAr9PdGsRMKtDkLQJBgQ', -32.1706341, 152.2807531, 'city', '1'),
('countries_australia_new_south_wales_willmot', 'ChIJBXiGBxabEmsRQNAyFmh9AQU', -33.7258747, 150.7926235, 'city', '1'),
('countries_australia_new_south_wales_willoughby', 'ChIJAcW4aeGuEmsRUNAyFmh9AQU', -33.8071041, 151.199349, 'city', '1'),
('countries_australia_new_south_wales_willoughby_east', 'ChIJ1ekaHDepEmsREEkzFmh9AQU', -33.7990165, 151.2050194, 'city', '1'),
('countries_australia_new_south_wales_willow_tree', 'ChIJte4oY1ICC2sR0MVDkLQJBgQ', -31.6486386, 150.7263152, 'city', '1'),
('countries_australia_new_south_wales_willow_vale', 'ChIJgdUWIOR0E2sRcCREkLQJBgU', -34.4323433, 150.4728553, 'city', '1'),
('countries_australia_new_south_wales_wilsons_creek', 'ChIJWV6YNPWMkGsREABEkLQJBgQ', -28.5725628, 153.4414987, 'city', '1'),
('countries_australia_new_south_wales_wilton', 'ChIJO9wRz5v9EmsRUJJDkLQJBgQ', -34.2373127, 150.6967284, 'city', '1'),
('countries_australia_new_south_wales_windale', 'ChIJp_OHOWw9c2sR4PYyFmh9AQU', -32.9925032, 151.6826758, 'city', '1'),
('countries_australia_new_south_wales_windang', 'ChIJ60uPZakWE2sRAOcyFmh9AQU', -34.5299746, 150.8692653, 'city', '1'),
('countries_australia_new_south_wales_windellama', 'ChIJaeLyySAZFGsRQORDkLQJBgQ', -35.0224538, 149.8731179, 'city', '1'),
('countries_spain_canary_islands_valverde', 'ChIJ1yopYR1cawwRcDJNvvNAAwQ', 27.793241, -17.9413323, 'city', '0'),
('countries_australia_new_south_wales_windermere_park', 'ChIJ78k9y8gnc2sRgN8yFmh9AQU', -33.11471, 151.5301344, 'city', '1'),
('countries_australia_new_south_wales_windeyer', 'ChIJZyaxxcdlDmsRwG5DkLQJBgQ', -32.7958045, 149.5569132, 'city', '1'),
('countries_australia_new_south_wales_windradyne', 'ChIJ21TR9ZnmEWsRcCNEkLQJBgU', -33.404005, 149.5445139, 'city', '1'),
('countries_australia_new_south_wales_windsor', 'ChIJYxAuDmRiDWsRYNAyFmh9AQU', -33.606782, 150.82046, 'city', '1'),
('countries_australia_new_south_wales_windsor_downs', 'ChIJY7ZnWoWcEmsRcNAyFmh9AQU', -33.6605388, 150.8097, 'city', '1'),
('countries_australia_new_south_wales_wingello', 'ChIJMfPxQp70E2sRYJJDkLQJBgQ', -34.6926735, 150.1577126, 'city', '1'),
('countries_australia_new_south_wales_wingen', 'ChIJ83NIfzkWC2sRsIxDkLQJBgQ', -31.8919043, 150.8780943, 'city', '1'),
('countries_australia_new_south_wales_wingham', 'ChIJwzWKgEy3dWsR4C5EkLQJBgU', -31.8686639, 152.3718898, 'city', '1'),
('countries_australia_new_south_wales_winmalee', 'ChIJnSVsQOqHEmsR0NUyFmh9AQU', -33.6721763, 150.6094298, 'city', '1'),
('countries_australia_new_south_wales_winston_hills', 'ChIJub0KahqiEmsRgNAyFmh9AQU', -33.7732056, 150.9695138, 'city', '1'),
('countries_australia_new_south_wales_winton', 'ChIJS1pwLLCFCmsRAMZDkLQJBgQ', -31.0880565, 150.7075769, 'city', '1'),
('countries_australia_new_south_wales_wirlinga', 'ChIJbfl4QJ7cI2sRMPBDkLQJBgQ', -36.065104, 147.0466424, 'city', '1'),
('countries_australia_new_south_wales_wirrimah', 'ChIJPQrg5CGpEGsRQPBDkLQJBgQ', -34.1232072, 148.4108387, 'city', '1'),
('countries_australia_new_south_wales_wisemans_creek', 'ChIJv4xzbFvzEWsR0G5DkLQJBgQ', -33.6249534, 149.7199074, 'city', '1'),
('countries_australia_new_south_wales_wisemans_ferry', 'ChIJS2b11L5BDWsR8EgzFmh9AQU', -33.3861683, 150.9852139, 'city', '1'),
('countries_australia_new_south_wales_wolgan_valley', 'ChIJZ3LsTXjtDWsR4G5DkLQJBgQ', -33.2454634, 150.1478008, 'city', '1'),
('countries_australia_new_south_wales_wolli_creek', 'ChIJXwFgMZewEmsRgEMzFmh9AQU', -33.9300999, 151.1542138, 'city', '1'),
('countries_australia_new_south_wales_wollombi', 'ChIJE2qeU4nYDGsR8IxDkLQJBgQ', -32.9385414, 151.1405936, 'city', '1'),
('countries_australia_new_south_wales_wollomombi', 'ChIJf-cyLcr8nmsRILhDkLQJBgQ', -30.5158683, 152.0643964, 'city', '1'),
('countries_australia_new_south_wales_wollongbar', 'ChIJD7P-Q9mCkGsRIABEkLQJBgQ', -28.8205831, 153.4218684, 'city', '1'),
('countries_australia_new_south_wales_wollongong', 'ChIJe1YLH6UZE2sRIOcyFmh9AQU', -34.4248336, 150.8931132, 'city', '1'),
('countries_australia_new_south_wales_wollstonecraft', 'ChIJ60rzHuWuEmsRkNAyFmh9AQU', -33.8313274, 151.1979642, 'city', '1'),
('countries_australia_new_south_wales_wolumla', 'ChIJaUfHUYqdPmsR0BBEkLQJBgQ', -36.8337556, 149.8094735, 'city', '1'),
('countries_australia_new_south_wales_wombarra', 'ChIJHbF4E0HgEmsRMOcyFmh9AQU', -34.275073, 150.9557889, 'city', '1'),
('countries_australia_new_south_wales_wonboyn', 'ChIJlf7CjrpUOWsR4BBEkLQJBgQ', -37.2502183, 149.9130675, 'city', '1'),
('countries_australia_new_south_wales_wongarbon', 'ChIJg7PxE6sND2sREH5DkLQJBgQ', -32.332261, 148.758751, 'city', '1'),
('countries_australia_new_south_wales_wongawilli', 'ChIJ0c0a7DAOE2sRQOcyFmh9AQU', -34.4776245, 150.7592335, 'city', '1'),
('countries_australia_new_south_wales_wongwibinda', 'ChIJx_RX-jjdnmsRQLhDkLQJBgQ', -30.2934705, 152.1842607, 'city', '1'),
('countries_australia_new_south_wales_woodberry', 'ChIJj77dfcBBc2sRIPcyFmh9AQU', -32.7939894, 151.6649033, 'city', '1'),
('countries_australia_new_south_wales_woodbine', 'ChIJTZFN5ojuEmsRoNAyFmh9AQU', -34.0494306, 150.8196652, 'city', '1'),
('countries_australia_new_south_wales_woodburn', 'ChIJYeHRoixvmmsRoB5EkLQJBgQ', -29.0718735, 153.3420454, 'city', '1'),
('countries_australia_new_south_wales_woodcroft', 'ChIJkw6kZ3KZEmsRsNAyFmh9AQU', -33.7550901, 150.8797629, 'city', '1'),
('countries_australia_new_south_wales_woodenbong', 'ChIJ2c14Y_ZGl2sRULhDkLQJBgQ', -28.3889243, 152.6125625, 'city', '1'),
('countries_australia_new_south_wales_woodford', 'ChIJ3Wq0l5hkEmsR4NUyFmh9AQU', -33.733786, 150.4752215, 'city', '1'),
('countries_australia_new_south_wales_woodford_island', 'ChIJfzNY7QrLm2sRrcAFESrxVjM', -29.5152778, 153.1347222, 'city', '1'),
('countries_australia_new_south_wales_woodhill', 'ChIJQWCZqxZ5E2sRcNlDkLQJBgQ', -34.7258671, 150.6887462, 'city', '1'),
('countries_australia_new_south_wales_woodpark', 'ChIJQQpgdVy9EmsRwNAyFmh9AQU', -33.8406169, 150.9618671, 'city', '1'),
('countries_australia_new_south_wales_woodrising', 'ChIJtboBT6Y8c2sRMPcyFmh9AQU', -32.9824821, 151.6052012, 'city', '1'),
('countries_australia_new_south_wales_woodstock', 'ChIJMZRK2NH5EGsRIG9DkLQJBgQ', -33.7436751, 148.8482017, 'city', '1'),
('countries_australia_new_south_wales_woodview', 'ChIJWW06Z68FmmsRQABEkLQJBgQ', -28.8609034, 152.9479654, 'city', '1'),
('countries_australia_new_south_wales_woodville', 'ChIJuyyI0cdcc2sRQPcyFmh9AQU', -32.6760965, 151.6099968, 'city', '1'),
('countries_australia_new_south_wales_woolgoolga', 'ChIJjWIXTI70m2sRUB9EkLQJBgU', -30.1132302, 153.1934013, 'city', '1'),
('countries_australia_new_south_wales_wooli', 'ChIJK1MEldG_m2sRYJtDkLQJBgQ', -29.8530666, 153.2631571, 'city', '1'),
('countries_australia_new_south_wales_woollamia', 'ChIJkWFrM26IFGsRgNlDkLQJBgQ', -35.0134659, 150.6539666, 'city', '1'),
('countries_australia_new_south_wales_woolloomooloo', 'ChIJZw_T5BKuEmsR4NAyFmh9AQU', -33.872648, 151.2185096, 'city', '1'),
('countries_australia_new_south_wales_woolomin', 'ChIJZ4Un2Vu3CmsRQMZDkLQJBgQ', -31.3035816, 151.1500142, 'city', '1'),
('countries_australia_new_south_wales_woolooware', 'ChIJxWRmLf3HEmsR8NAyFmh9AQU', -34.0483395, 151.1414317, 'city', '1'),
('countries_australia_new_south_wales_wooloweyah', 'ChIJ10bWG5RMmmsRQCxEkLQJBgU', -29.4795636, 153.3431693, 'city', '1'),
('countries_australia_new_south_wales_woolwich', 'ChIJ4SvZbAevEmsRANEyFmh9AQU', -33.8402886, 151.1706322, 'city', '1'),
('countries_australia_new_south_wales_woombah', 'ChIJV2m36x1GmmsR0B5EkLQJBgQ', -29.3587695, 153.2807024, 'city', '1'),
('countries_australia_new_south_wales_woongarrah', 'ChIJwaPw437QcmsRwEIzFmh9AQU', -33.2428518, 151.4863863, 'city', '1'),
('countries_australia_new_south_wales_woonona', 'ChIJ2cUq4eQeE2sRUOcyFmh9AQU', -34.3423802, 150.9052832, 'city', '1'),
('countries_australia_new_south_wales_wootton', 'ChIJ4a1sWutCdGsRYKtDkLQJBgQ', -32.2956583, 152.3038727, 'city', '1'),
('countries_australia_new_south_wales_woronora', 'ChIJV1_OIbTAEmsRENEyFmh9AQU', -34.0300455, 151.0398805, 'city', '1'),
('countries_australia_new_south_wales_woronora_heights', 'ChIJP7iMSMLAEmsRINEyFmh9AQU', -34.0344843, 151.028008, 'city', '1'),
('countries_australia_new_south_wales_worrigee', 'ChIJyflaXueBFGsRUEUzFmh9AQU', -34.9156868, 150.6360411, 'city', '1'),
('countries_australia_new_south_wales_worrowing_heights', 'ChIJw-OPtSOJFGsRoDFEkLQJBgU', -35.088154, 150.6402038, 'city', '1'),
('countries_australia_new_south_wales_woy_woy', 'ChIJQece815LDWsRoN8yFmh9AQU', -33.4887953, 151.3259426, 'city', '1'),
('countries_australia_new_south_wales_woy_woy_bay', 'ChIJK02hZh9LDWsRsN8yFmh9AQU', -33.4836276, 151.3130992, 'city', '1'),
('countries_australia_new_south_wales_wrights_beach', 'ChIJubt1wFGJFGsRoNlDkLQJBgQ', -35.1155831, 150.6619008, 'city', '1'),
('countries_australia_new_south_wales_wyalong', 'ChIJN_gnCJ7dG2sRkPBDkLQJBgQ', -33.9258841, 147.243011, 'city', '1'),
('countries_australia_new_south_wales_wyangala', 'ChIJ1SpZXuXlEGsRUG9DkLQJBgQ', -33.9626487, 148.9542551, 'city', '1'),
('countries_australia_new_south_wales_wyee', 'ChIJQwoDwPjWcmsR4N8yFmh9AQU', -33.1757535, 151.4870947, 'city', '1'),
('countries_australia_new_south_wales_wyee_point', 'ChIJZxE5F_zXcmsR8N8yFmh9AQU', -33.1458325, 151.520189, 'city', '1'),
('countries_australia_new_south_wales_wyndham', 'ChIJ7ySvikkaPGsRQBFEkLQJBgQ', -36.9289108, 149.6456842, 'city', '1'),
('countries_australia_new_south_wales_wyneden', 'ChIJfXoI_PWwkGsRcABEkLQJBgQ', -28.5474405, 152.9263836, 'city', '1'),
('countries_australia_new_south_wales_wyoming', 'ChIJg8kUVi3LcmsRAOAyFmh9AQU', -33.4038317, 151.350312, 'city', '1'),
('countries_australia_new_south_wales_wyong', 'ChIJTVIn5drPcmsREOAyFmh9AQU', -33.2843475, 151.4249427, 'city', '1'),
('countries_australia_new_south_wales_wyongah', 'ChIJKyNUTUPQcmsRQOAyFmh9AQU', -33.2748764, 151.4904069, 'city', '1'),
('countries_australia_new_south_wales_wyong_creek', 'ChIJEx4-KLfScmsRIOAyFmh9AQU', -33.2546939, 151.3264633, 'city', '1'),
('countries_australia_new_south_wales_wyrallah', 'ChIJewb8T9V1mmsRgABEkLQJBgQ', -28.8915054, 153.3098958, 'city', '1'),
('countries_australia_new_south_wales_yagoona', 'ChIJUV-Eoz-8EmsRMNEyFmh9AQU', -33.9073112, 151.0204821, 'city', '1'),
('countries_australia_new_south_wales_yallah', 'ChIJFRwA5T8SE2sRcOcyFmh9AQU', -34.5378958, 150.7791473, 'city', '1'),
('countries_australia_new_south_wales_yamba', 'ChIJ_zLEfCFMmmsRUCxEkLQJBgU', -29.4355601, 153.3602079, 'city', '1'),
('countries_australia_new_south_wales_yanco', 'ChIJGW3COC5tH2sRsNNDkLQJBgQ', -34.6033071, 146.4098305, 'city', '1'),
('countries_australia_new_south_wales_yanderra', 'ChIJre7dS_WpE2sRgJJDkLQJBgQ', -34.3215649, 150.5706459, 'city', '1'),
('countries_australia_new_south_wales_yaouk', 'ChIJzXnCarxoPWsRMBREkLQJBgQ', -35.8174411, 148.8160939, 'city', '1'),
('countries_australia_new_south_wales_yarra', 'ChIJL17pm2m6FmsRcORDkLQJBgQ', -34.7877992, 149.6099951, 'city', '1'),
('countries_australia_new_south_wales_yarragundry', 'ChIJFV3Grh2hGGsR0NNDkLQJBgQ', -35.1092393, 147.2250887, 'city', '1'),
('countries_australia_new_south_wales_yarrahapinni', 'ChIJ29CygBTTnWsRcJtDkLQJBgQ', -30.8161805, 152.9628116, 'city', '1'),
('countries_australia_new_south_wales_yarramalong', 'ChIJLY6Re8gtDWsRUOAyFmh9AQU', -33.2240368, 151.2785587, 'city', '1'),
('countries_australia_new_south_wales_yarramundi', 'ChIJlyOchuyDEmsR8NUyFmh9AQU', -33.6362859, 150.6666707, 'city', '1'),
('countries_australia_new_south_wales_yarravel', 'ChIJkQlaqw50nmsRkJtDkLQJBgQ', -31.0518629, 152.7840615, 'city', '1'),
('countries_australia_new_south_wales_yarrawarrah', 'ChIJk8iyiiPBEmsRUNEyFmh9AQU', -34.0566648, 151.0347768, 'city', '1'),
('countries_australia_new_south_wales_yarrawonga_park', 'ChIJk2-Ez08mc2sRYOAyFmh9AQU', -33.0994159, 151.5440159, 'city', '1'),
('countries_australia_new_south_wales_yarrowitch', 'ChIJB1vNDzYrnmsRoKtDkLQJBgQ', -31.2240579, 151.9274654, 'city', '1'),
('countries_australia_new_south_wales_yarrowyck', 'ChIJLbc2bnWAn2sRsLhDkLQJBgQ', -30.4595405, 151.3555334, 'city', '1'),
('countries_australia_new_south_wales_yass', 'ChIJ7wTOUlEZF2sRgORDkLQJBgQ', -34.8277755, 148.9083038, 'city', '1'),
('countries_australia_new_south_wales_yatte_yattah', 'ChIJHaM7IN5aFGsRwNlDkLQJBgQ', -35.2719858, 150.4240126, 'city', '1'),
('countries_australia_new_south_wales_yelgun', 'ChIJC_kLKXrzkGsRkABEkLQJBgQ', -28.484565, 153.5036212, 'city', '1'),
('countries_australia_new_south_wales_yellow_rock', 'ChIJF-SFkv2GEmsRANYyFmh9AQU', -33.6950536, 150.6240718, 'city', '1'),
('countries_australia_new_south_wales_yenda', 'ChIJg_ufyW7-HmsR4NNDkLQJBgQ', -34.2498949, 146.1948514, 'city', '1'),
('countries_australia_new_south_wales_yennora', 'ChIJizs073C9EmsRYNEyFmh9AQU', -33.8650266, 150.9709087, 'city', '1'),
('countries_australia_new_south_wales_yeoval', 'ChIJbVewvgDtD2sRUH5DkLQJBgQ', -32.7540464, 148.6479969, 'city', '1'),
('countries_australia_new_south_wales_yerrinbool', 'ChIJW00e1WQHE2sRoJJDkLQJBgQ', -34.3664263, 150.5426941, 'city', '1'),
('countries_australia_new_south_wales_yerriyong', 'ChIJ0zi9qBR8FGsR0NlDkLQJBgQ', -34.9920283, 150.4759992, 'city', '1'),
('countries_australia_new_south_wales_yetholme', 'ChIJv9Zdn2z_EWsRwG9DkLQJBgQ', -33.4458986, 149.8300312, 'city', '1'),
('countries_australia_new_south_wales_yetman', 'ChIJJ_-DIa73omsRkMZDkLQJBgQ', -28.9038776, 150.7784372, 'city', '1'),
('countries_australia_new_south_wales_yippin_creek', 'ChIJzbbZJcP4dWsR0B9EkLQJBgU', -31.4542664, 152.7127816, 'city', '1'),
('countries_australia_new_south_wales_yoogali', 'ChIJHX3NzEOpH2sRECVEkLQJBgU', -34.2975544, 146.0762768, 'city', '1'),
('countries_australia_new_south_wales_yorklea', 'ChIJKb8ADCAOmmsRoABEkLQJBgQ', -28.9451104, 153.0611059, 'city', '1'),
('countries_australia_new_south_wales_young', 'ChIJBXLQJSX-GWsRAPFDkLQJBgQ', -34.3134008, 148.2979356, 'city', '1'),
('countries_australia_new_south_wales_yowie_bay', 'ChIJ742Z2IvHEmsRcNEyFmh9AQU', -34.0515034, 151.1038367, 'city', '1'),
('countries_australia_new_south_wales_yowrie', 'ChIJr5Our9TePWsRkBFEkLQJBgQ', -36.3186603, 149.7331761, 'city', '1'),
('countries_spain_canary_islands_san_nicolas', 'ChIJFRDeVYFiQAwRJgdze8cKe2I', 27.97802, -15.78759, 'city', '0'),
('countries_australia_new_south_wales_zetland', 'ChIJG2DVVsCxEmsRgNEyFmh9AQU', -33.9072561, 151.2077058, 'city', '1'),
('countries_australia_northern_territory_adelaide_river', 'ChIJ1-PpdcwpvywRUIQkKqgXAgQ', -13.2394862, 131.1064307, 'city', '1'),
('countries_australia_northern_territory_alawa', 'ChIJdT8aNmGTwCwR4H0kKqgXAgU', -12.3811356, 130.8752979, 'city', '1'),
('countries_australia_northern_territory_alice_springs', 'ChIJMROPvkQZMisR0E8lKqgXAgU', -23.698042, 133.8807471, 'city', '1'),
('countries_australia_northern_territory_alyangula', 'ChIJiZOQaO6J5GkRwEAlKqgXAgQ', -13.8509101, 136.4195101, 'city', '1'),
('countries_australia_northern_territory_anula', 'ChIJVyJzM4iUwCwR8H0kKqgXAgU', -12.3902916, 130.8938724, 'city', '1'),
('countries_australia_northern_territory_bakewell', 'ChIJm8aeBdWiwCwREH4kKqgXAgU', -12.4946662, 130.9934338, 'city', '1'),
('countries_australia_northern_territory_batchelor', 'ChIJ_d7AM20kvywRwD8lKqgXAgQ', -13.0470342, 131.0276033, 'city', '1'),
('countries_australia_northern_territory_bayview', 'ChIJV0pJWGeRwCwR0D8lKqgXAgU', -12.4392815, 130.8540345, 'city', '1'),
('countries_australia_northern_territory_bees_creek', 'ChIJNxHhz96mwCwRIH4kKqgXAgU', -12.5841021, 131.0590943, 'city', '1'),
('countries_australia_northern_territory_bellamack', 'ChIJZSFSZ8aiwCwRMH4kKqgXAgU', -12.5148156, 130.9814006, 'city', '1'),
('countries_australia_northern_territory_berrimah', 'ChIJW3HL02-WwCwRQH4kKqgXAgU', -12.4398965, 130.9251438, 'city', '1'),
('countries_australia_northern_territory_berry_springs', 'ChIJ9a413yRcvywRUH4kKqgXAgU', -12.7308046, 131.0091481, 'city', '1'),
('countries_australia_northern_territory_borroloola', 'ChIJjzCoytwk-WkRcEAlKqgXAgQ', -16.070278, 136.307222, 'city', '1'),
('countries_australia_northern_territory_braitling', 'ChIJG4Nv7CsfMisR8E4lKqgXAgU', -23.6759868, 133.8657956, 'city', '1'),
('countries_australia_northern_territory_brinkin', 'ChIJd70a7E-TwCwRcH4kKqgXAgU', -12.3704053, 130.8698427, 'city', '1'),
('countries_australia_northern_territory_canteen_creek', 'ChIJGwjc60ZTCmoR4EolKqgXAgQ', -20.6440035, 135.587927, 'city', '1'),
('countries_australia_northern_territory_casuarina', 'ChIJ14m2wKGUwCwRgH4kKqgXAgU', -12.3725509, 130.8837751, 'city', '1'),
('countries_australia_northern_territory_ciccone', 'ChIJ5bzXO8seMisRAE8lKqgXAgU', -23.6898412, 133.86289, 'city', '1'),
('countries_australia_northern_territory_coconut_grove', 'ChIJq1DOW6aTwCwRoH4kKqgXAgU', -12.398889, 130.8525, 'city', '1'),
('countries_australia_northern_territory_coolalinga', 'ChIJdzg7fnikwCwRsH4kKqgXAgU', -12.5181123, 131.0413447, 'city', '1'),
('countries_spain_canary_islands_san_miguel_de_abona', 'ChIJH1ctpceeagwR_Uo_s_9d19s', 28.077186, -16.6173415, 'city', '0'),
('countries_australia_northern_territory_darwin_river', 'ChIJU8bXcIRCvywR8H4kKqgXAgU', -12.8010472, 130.95565, 'city', '1'),
('countries_australia_northern_territory_desert_springs', 'ChIJAT9O390bMisRQE8lKqgXAgU', -23.7095604, 133.8810988, 'city', '1'),
('countries_australia_northern_territory_driver', 'ChIJNVugvUu9wCwRAH8kKqgXAgU', -12.4851045, 130.9778773, 'city', '1'),
('countries_australia_northern_territory_dundee_forest', 'ChIJzQVGzt53wCwR8EwlKqgXAgQ', -12.81034, 130.4402974, 'city', '1'),
('countries_australia_northern_territory_durack', 'ChIJ40r0_UO9wCwREH8kKqgXAgU', -12.4716674, 130.9730477, 'city', '1'),
('countries_australia_northern_territory_east_arm', 'ChIJ5ehGGA6XwCwR8EElKqgXAgU', -12.471469, 130.9265518, 'city', '1'),
('countries_australia_northern_territory_east_side', 'ChIJiZlR5HAZMisRYE8lKqgXAgU', -23.6914942, 133.8978034, 'city', '1'),
('countries_australia_northern_territory_elliott', 'ChIJnRwprgqSVisRkIQkKqgXAgQ', -17.5527848, 133.5405437, 'city', '1'),
('countries_australia_northern_territory_fannie_bay', 'ChIJIUBYkjOSwCwRMH8kKqgXAgU', -12.4246673, 130.8355058, 'city', '1'),
('countries_australia_northern_territory_farrar', 'ChIJbU_nwyq9wCwRoEklKqgXAgU', -12.4777994, 130.993347, 'city', '1'),
('countries_spain_canary_islands_puntallana', 'ChIJc1sbwSbpawwRLEOwdIEbPtU', 28.7455339, -17.7517775, 'city', '0'),
('countries_australia_northern_territory_gillen', 'ChIJsTwyaaseMisRIE8lKqgXAgU', -23.7056979, 133.8674989, 'city', '1'),
('countries_australia_northern_territory_gray', 'ChIJJQlK1zS9wCwRcH8kKqgXAgU', -12.4899594, 130.9820387, 'city', '1'),
('countries_australia_northern_territory_gunn', 'ChIJNR3kRSS9wCwRgH8kKqgXAgU', -12.4886298, 130.9921968, 'city', '1'),
('countries_australia_northern_territory_holtze', 'ChIJHSi2OuG8wCwRsH8kKqgXAgU', -12.4392263, 130.9830522, 'city', '1'),
('countries_australia_northern_territory_howard_springs', 'ChIJ02thdVG7wCwRwH8kKqgXAgU', -12.4962701, 131.0253562, 'city', '1'),
('countries_australia_northern_territory_humpty_doo', 'ChIJ9z-uRmKowCwR4H8kKqgXAgU', -12.5728507, 131.1009574, 'city', '1'),
('countries_australia_northern_territory_jabiru', 'ChIJa2xW4h-StywRYIQkKqgXAgQ', -12.6744733, 132.8325431, 'city', '1'),
('countries_australia_northern_territory_jingili', 'ChIJlw3t7nuTwCwR8H8kKqgXAgU', -12.3863392, 130.8735044, 'city', '1'),
('countries_australia_northern_territory_johnston', 'ChIJtyVyUCSjwCwRoE8lKqgXAgU', -12.4919073, 131.0054669, 'city', '1'),
('countries_australia_northern_territory_karama', 'ChIJmSB9lrSVwCwRAIAkKqgXAgU', -12.401069, 130.916889, 'city', '1'),
('countries_australia_northern_territory_katherine', 'ChIJN4P8h86_uiwRwE8lKqgXAgU', -14.4519683, 132.2698623, 'city', '1'),
('countries_australia_northern_territory_katherine_east', 'ChIJ5ZIC0F6-uiwRcE8lKqgXAgU', -14.4625729, 132.2784105, 'city', '1'),
('countries_australia_northern_territory_katherine_south', 'ChIJaTcZyaO_uiwRgE8lKqgXAgU', -14.4698053, 132.2592403, 'city', '1'),
('countries_australia_northern_territory_larapinta', 'ChIJDWtoYgYfMisRQE4lKqgXAgU', -23.6958981, 133.8322092, 'city', '1'),
('countries_australia_northern_territory_larrakeyah', 'ChIJ_Xc9FJeRwCwRMIAkKqgXAgU', -12.4586064, 130.8303646, 'city', '1'),
('countries_australia_northern_territory_larrimah', 'ChIJp3z7s_PWriwRkEMlKqgXAgQ', -15.5757663, 133.2169365, 'city', '1'),
('countries_australia_northern_territory_leanyer', 'ChIJgZUZo-6UwCwRQIAkKqgXAgU', -12.3745895, 130.8966156, 'city', '1'),
('countries_australia_northern_territory_ludmilla', 'ChIJXVwChsiTwCwRgIAkKqgXAgU', -12.4101417, 130.8518684, 'city', '1'),
('countries_australia_northern_territory_lyons', 'ChIJa4R5BLKUwCwRAEIlKqgXAgU', -12.3601136, 130.8890729, 'city', '1'),
('countries_australia_northern_territory_malak', 'ChIJj5w04luUwCwRkIAkKqgXAgU', -12.3930193, 130.9042135, 'city', '1'),
('countries_australia_northern_territory_maningrida', 'ChIJ4226sbiItSwRMEIlKqgXAgQ', -12.0551674, 134.2313799, 'city', '1'),
('countries_australia_northern_territory_marlow_lagoon', 'ChIJU9Ezz1S9wCwRoIAkKqgXAgU', -12.4982124, 130.9645186, 'city', '1'),
('countries_australia_northern_territory_marrakai', 'ChIJNQ-3T2eluCwRkEglKqgXAgQ', -12.7680262, 131.5110702, 'city', '1'),
('countries_australia_northern_territory_marrara', 'ChIJd3x65UGUwCwRsIAkKqgXAgU', -12.3987143, 130.8801517, 'city', '1'),
('countries_australia_northern_territory_mataranka', 'ChIJJ9RFC-yzrywRsIQkKqgXAgQ', -14.9230049, 133.0667202, 'city', '1'),
('countries_australia_northern_territory_millner', 'ChIJpX1FJHeTwCwR0IAkKqgXAgU', -12.391111, 130.863208, 'city', '1'),
('countries_australia_northern_territory_moil', 'ChIJ9UEVjIGUwCwR8IAkKqgXAgU', -12.3868941, 130.8815452, 'city', '1'),
('countries_australia_northern_territory_moulden', 'ChIJfxz35ZWiwCwRAIEkKqgXAgU', -12.503895, 130.972144, 'city', '1'),
('countries_australia_northern_territory_muirhead', 'ChIJeZls9baUwCwREEIlKqgXAgU', -12.3587135, 130.8941695, 'city', '1'),
('countries_australia_northern_territory_nakara', 'ChIJveX_qaCUwCwREIEkKqgXAgU', -12.371528, 130.876179, 'city', '1'),
('countries_australia_northern_territory_newcastle_waters', 'ChIJc595DFZZVisRYEMlKqgXAgQ', -17.3701182, 133.4039876, 'city', '1'),
('countries_australia_northern_territory_nhulunbuy', 'ChIJLW7q8h9-52kR0EAlKqgXAgQ', -12.1835392, 136.7860989, 'city', '1'),
('countries_australia_northern_territory_nightcliff', 'ChIJK0v-MheTwCwRIIEkKqgXAgU', -12.3803137, 130.8471163, 'city', '1'),
('countries_australia_northern_territory_noonamah', 'ChIJQd0kmjVYvywRMIEkKqgXAgU', -12.6427232, 131.1034975, 'city', '1'),
('countries_australia_northern_territory_palmerston', 'ChIJx-rmXDG9wCwRcEklKqgXAgU', -12.4794449, 130.9845298, 'city', '1'),
('countries_australia_northern_territory_parap', 'ChIJv0sXgdCTwCwRUIEkKqgXAgU', -12.4322152, 130.8433184, 'city', '1'),
('countries_australia_northern_territory_pinelands', 'ChIJgZl1OCGWwCwRYIEkKqgXAgU', -12.459899, 130.9664193, 'city', '1'),
('countries_australia_northern_territory_pine_creek', 'ChIJ7RV67HHOuywRwIQkKqgXAgQ', -13.8226918, 131.8344229, 'city', '1'),
('countries_australia_northern_territory_rapid_creek', 'ChIJI3pOL2uTwCwRgIEkKqgXAgU', -12.3827088, 130.8599676, 'city', '1'),
('countries_australia_northern_territory_robin_falls', 'ChIJWxjqCJHPviwRAXoV-aYHdic', -13.3376641, 131.1398204, 'city', '1'),
('countries_australia_northern_territory_rosebery', 'ChIJt91yj82iwCwRkIEkKqgXAgU', -12.5085718, 130.9906963, 'city', '1'),
('countries_australia_northern_territory_sadadeen', 'ChIJzx8f7n0ZMisRUE8lKqgXAgU', -23.701022, 133.8997949, 'city', '1'),
('countries_australia_northern_territory_stuart_park', 'ChIJj5_7F3CRwCwRsIEkKqgXAgU', -12.4450925, 130.8424749, 'city', '1'),
('countries_australia_northern_territory_tennant_creek', 'ChIJSVS7TkNMTCsRIIQkKqgXAgQ', -19.64591, 134.1909565, 'city', '1'),
('countries_australia_northern_territory_the_gap', 'ChIJsYjIX5geMisRME8lKqgXAgU', -23.7141195, 133.8743016, 'city', '1'),
('countries_australia_northern_territory_the_gardens', 'ChIJC5T8fYORwCwRwIEkKqgXAgU', -12.4468114, 130.8330451, 'city', '1'),
('countries_australia_northern_territory_the_narrows', 'ChIJF6f-rOeTwCwR0IEkKqgXAgU', -12.4264231, 130.8598624, 'city', '1'),
('countries_australia_northern_territory_tindal', 'ChIJi3dThjaluiwRoEslKqgXAgQ', -14.4957534, 132.3959973, 'city', '1'),
('countries_australia_northern_territory_tivendale', 'ChIJA7kjGIC9wCwR0EElKqgXAgU', -12.4606428, 130.9442119, 'city', '1'),
('countries_australia_northern_territory_tiwi', 'ChIJ1YGMrNoawiwRL8pVSnyhv4c', -11.6968879, 130.8778586, 'city', '1'),
('countries_australia_northern_territory_wagait_beach', 'ChIJP1hjjjmMwCwREIIkKqgXAgQ', -12.4343563, 130.7420337, 'city', '1'),
('countries_australia_northern_territory_wagaman', 'ChIJoXW7BJuUwCwRIIIkKqgXAgU', -12.382591, 130.885141, 'city', '1'),
('countries_australia_northern_territory_wanguri', 'ChIJHRIAz6KUwCwRMIIkKqgXAgU', -12.3684975, 130.889558, 'city', '1'),
('countries_australia_northern_territory_winnellie', 'ChIJpSvj-v2TwCwRQIIkKqgXAgU', -12.4286212, 130.8706078, 'city', '1'),
('countries_australia_northern_territory_woodroffe', 'ChIJ4fqBwDW9wCwRUIIkKqgXAgU', -12.499539, 130.981, 'city', '1'),
('countries_australia_northern_territory_woolner', 'ChIJG1LwAmKRwCwR4D8lKqgXAgU', -12.4339379, 130.8507349, 'city', '1'),
('countries_australia_northern_territory_wulagi', 'ChIJa0ArHY2UwCwRYIIkKqgXAgU', -12.3851332, 130.8940933, 'city', '1'),
('countries_australia_northern_territory_wurrumiyanga', 'ChIJY70QOBaewSwRkEwlKqgXAgQ', -11.7619227, 130.6317972, 'city', '1'),
('countries_australia_northern_territory_yarrawonga', 'ChIJZUzdvTq9wCwRcIIkKqgXAgU', -12.472156, 130.989234, 'city', '1'),
('countries_australia_northern_territory_yuendumu', 'ChIJH84v1WGFOCsR8EIlKqgXAgQ', -22.2539566, 131.7953883, 'city', '1'),
('countries_australia_northern_territory_yulara', 'ChIJPz2rao9AIysRAIUkKqgXAgQ', -25.237979, 130.9856199, 'city', '1'),
('countries_australia_northern_territory_zuccoli', 'ChIJ3wV8bBqjwCwRWCk5fGFCMSc', -12.5056706, 131.0082063, 'city', '1'),
('countries_australia_queensland_acacia_ridge', 'ChIJDXuxiXtFkWsR4H3e81qjAgU', -27.5873761, 153.0270551, 'city', '1'),
('countries_australia_queensland_adare', 'ChIJLwxjae6SlmsRgOYgf_HuAAQ', -27.5052984, 152.320589, 'city', '1'),
('countries_australia_queensland_adelaide_park', 'ChIJy4c1kkHnwmsRUA0hf_HuAAU', -23.0865001, 150.6881028, 'city', '1'),
('countries_australia_queensland_advancetown', 'ChIJc5Mb75gekWsRoJ_e81qjAgU', -28.0376171, 153.2722419, 'city', '1'),
('countries_australia_queensland_aeroglen', 'ChIJG4_5kuJleGkRUAYhf_HuAAU', -16.8838179, 145.7453791, 'city', '1'),
('countries_australia_queensland_agnes_water', 'ChIJK2v-V2-F6WsRoMkgf_HuAAQ', -24.2125, 151.903333, 'city', '1'),
('countries_australia_queensland_airdmillan', 'ChIJXfD2iN0v1msR0Iggf_HuAAQ', -19.5338904, 147.4544397, 'city', '1'),
('countries_australia_queensland_airlie_beach', 'ChIJFa_KC0k12GsREAohf_HuAAU', -20.2677525, 148.7155626, 'city', '1'),
('countries_australia_queensland_aitkenvale', 'ChIJvf6rRCf61WsRwPogf_HuAAU', -19.2991072, 146.7684499, 'city', '1'),
('countries_australia_queensland_alabama_hill', 'ChIJ2Ua0SEte1GsRsAAhf_HuAAU', -20.0829214, 146.2495124, 'city', '1'),
('countries_australia_queensland_albany_creek', 'ChIJ7ZvWV539k2sR8H3e81qjAgU', -27.3455088, 152.9684103, 'city', '1'),
('countries_australia_queensland_albion', 'ChIJmf61ysxZkWsREH7e81qjAgU', -27.4321115, 153.0428584, 'city', '1'),
('countries_australia_queensland_alderley', 'ChIJj69FN3BXkWsRIH7e81qjAgU', -27.4253256, 153.0011531, 'city', '1'),
('countries_australia_queensland_aldershot', 'ChIJJ68KQHFm62sRUO4gf_HuAAQ', -25.4619592, 152.6613079, 'city', '1'),
('countries_australia_queensland_alexandra', 'ChIJiwAljNcs2msRIAMhf_HuAAU', -21.1632226, 149.1007486, 'city', '1'),
('countries_australia_queensland_alexandra_headland', 'ChIJPxi4bmx2k2sREKje81qjAgU', -26.6706454, 153.108003, 'city', '1'),
('countries_australia_queensland_alexandra_hills', 'ChIJ3x8kzGxnkWsRMH7e81qjAgU', -27.5234744, 153.2258271, 'city', '1'),
('countries_australia_queensland_algester', 'ChIJ2Qah-ZVFkWsRQH7e81qjAgU', -27.6116413, 153.0358129, 'city', '1'),
('countries_australia_queensland_alice_river', 'ChIJRxEsFwvy1WsR0Pogf_HuAAU', -19.3325345, 146.5974487, 'city', '1'),
('countries_australia_queensland_allan', 'ChIJaRXdyoSYl2sRMK8gf_HuAAQ', -28.1930429, 151.9542525, 'city', '1'),
('countries_australia_queensland_allenstown', 'ChIJC3ml2BGqw2sRMP8gf_HuAAU', -23.387849, 150.5020832, 'city', '1'),
('countries_australia_queensland_allenview', 'ChIJ5U6Vn9gtkWsRUH7e81qjAgU', -27.9101039, 152.9319242, 'city', '1'),
('countries_australia_queensland_alligator_creek', 'ChIJB2n1KdkH1msR4Pogf_HuAAU', -19.4226909, 146.9414285, 'city', '1'),
('countries_australia_queensland_allora', 'ChIJq2qykvyll2sRsKggf_HuAAQ', -28.0332296, 151.9807227, 'city', '1'),
('countries_australia_queensland_alloway', 'ChIJVXQ90Za862sRcAshf_HuAAU', -24.9488301, 152.377908, 'city', '1'),
('countries_australia_queensland_almaden', 'ChIJBTM6LoPRg2kRoHMgf_HuAAQ', -17.3399814, 144.6781842, 'city', '1'),
('countries_australia_queensland_aloomba', 'ChIJj4HILFzzeGkRYAYhf_HuAAU', -17.1100929, 145.8321749, 'city', '1'),
('countries_australia_queensland_alpha', 'ChIJfxYK_PHgy2sRoJkgf_HuAAQ', -23.6485211, 146.6379726, 'city', '1'),
('countries_australia_queensland_alton_downs', 'ChIJ24l-v4YIw2sR0Mkgf_HuAAQ', -23.302497, 150.355841, 'city', '1'),
('countries_australia_queensland_amamoor', 'ChIJVZ8OQYWZlGsRUOcgf_HuAAQ', -26.3468736, 152.6759411, 'city', '1'),
('countries_australia_queensland_amberley', 'ChIJr0S7yEa2lmsRcH7e81qjAgU', -27.6405547, 152.6843246, 'city', '1'),
('countries_australia_queensland_amiens', 'ChIJs37tKzwkmGsRAKogf_HuAAQ', -28.5976418, 151.8151806, 'city', '1'),
('countries_australia_queensland_amity_point', 'ChIJqzY6mpPWk2sRgH7e81qjAgU', -27.3978659, 153.439061, 'city', '1'),
('countries_australia_queensland_andergrove', 'ChIJcctb5C_U22sRMAMhf_HuAAU', -21.0974301, 149.1805766, 'city', '1'),
('countries_australia_queensland_anderleigh', 'ChIJH7dJdWOulGsR0PAgf_HuAAQ', -25.9887207, 152.6783244, 'city', '1'),
('countries_australia_queensland_andromache', 'ChIJMakZgu_g2WsR8Iggf_HuAAQ', -20.6148179, 148.4158008, 'city', '1'),
('countries_australia_queensland_anduramba', 'ChIJ210TutYqlGsRkMAgf_HuAAQ', -27.1487518, 152.0981706, 'city', '1'),
('countries_australia_queensland_annandale', 'ChIJDXlB9yn61WsR8Pogf_HuAAU', -19.3127863, 146.7874903, 'city', '1'),
('countries_australia_queensland_annerley', 'ChIJVeTdwYtakWsRkH7e81qjAgU', -27.5138962, 153.0309346, 'city', '1'),
('countries_australia_queensland_anstead', 'ChIJjTIRN3NNkWsRoH7e81qjAgU', -27.5411939, 152.8623716, 'city', '1'),
('countries_australia_queensland_antigua', 'ChIJk9iCUn9D62sR4PAgf_HuAAQ', -25.6335789, 152.5845509, 'city', '1'),
('countries_australia_queensland_applethorpe', 'ChIJzzE3L9kumGsRIKogf_HuAAQ', -28.6178152, 151.9567092, 'city', '1'),
('countries_australia_queensland_apple_tree_creek', 'ChIJw6PJOqwF62sR8Mkgf_HuAAQ', -25.2268472, 152.2310965, 'city', '1'),
('countries_australia_queensland_araluen', 'ChIJLTQZCL2klGsRoBAhf_HuAAU', -26.1517936, 152.6590531, 'city', '1'),
('countries_australia_queensland_aramac', 'ChIJgxxDgwKnNGoRQJUgf_HuAAQ', -22.9715957, 145.2429416, 'city', '1'),
('countries_australia_queensland_arana_hills', 'ChIJGbm1TkVWkWsRsH7e81qjAgU', -27.3913093, 152.9555735, 'city', '1'),
('countries_australia_queensland_aratula', 'ChIJP-wVbbQgl2sRsNwgf_HuAAQ', -27.981389, 152.548611, 'city', '1'),
('countries_spain_canary_islands_playa_del_ingles', 'ChIJu10CzbhiPwwRwcsBvPRAAyY', 27.7607003, -15.5694703, 'city', '0'),
('countries_australia_queensland_archerfield', 'ChIJKeIHJ_NPkWsRwH7e81qjAgU', -27.5670122, 153.0151652, 'city', '1'),
('countries_australia_queensland_armstrong_beach', 'ChIJfaOITJe322sRUIMgf_HuAAQ', -21.4464621, 149.2891301, 'city', '1'),
('countries_australia_queensland_armstrong_creek', 'ChIJTfuAmBcHlGsRkAnf81qjAgU', -27.2196027, 152.8323372, 'city', '1'),
('countries_australia_queensland_aroona', 'ChIJQ_kg96yek2sRIKje81qjAgU', -26.7820437, 153.1170146, 'city', '1'),
('countries_australia_queensland_arundel', 'ChIJR8zJxUYQkWsR0J_e81qjAgU', -27.9361398, 153.3603181, 'city', '1'),
('countries_australia_queensland_ascot', 'ChIJNR3RQQBZkWsR0H7e81qjAgU', -27.4306893, 153.0621285, 'city', '1'),
('countries_australia_queensland_ashgrove', 'ChIJTQGu4mtXkWsR4H7e81qjAgU', -27.4455875, 152.9922137, 'city', '1'),
('countries_australia_queensland_ashmore', 'ChIJaYHf5bMakWsR4J_e81qjAgU', -27.9861642, 153.3803431, 'city', '1'),
('countries_australia_queensland_ashwell', 'ChIJIYsEK1jHlmsREMTe81qjAgU', -27.6284295, 152.5601505, 'city', '1'),
('countries_australia_queensland_aspley', 'ChIJJewiWQZYkWsR8H7e81qjAgU', -27.3639, 153.0157, 'city', '1'),
('countries_australia_queensland_atherton', 'ChIJwbSeC4sKgmkRoHEgf_HuAAQ', -17.2666843, 145.4768687, 'city', '1'),
('countries_australia_queensland_atkinsons_dam', 'ChIJZQxOKjSYlmsR8MEgf_HuAAQ', -27.4137245, 152.4309485, 'city', '1'),
('countries_australia_queensland_aubigny', 'ChIJXQ6dVj0_lmsR8Kkgf_HuAAQ', -27.5216168, 151.6424703, 'city', '1'),
('countries_australia_queensland_auchenflower', 'ChIJR81gpa9QkWsRAH_e81qjAgU', -27.4755182, 152.9934343, 'city', '1'),
('countries_australia_queensland_augathella', 'ChIJRw6DKIMLtGsRgKEgf_HuAAQ', -25.7952481, 146.5847126, 'city', '1'),
('countries_australia_queensland_augustine_heights', 'ChIJlV0VkQhLkWsRMNve81qjAgU', -27.6569153, 152.8869289, 'city', '1'),
('countries_australia_queensland_austinville', 'ChIJD9AFsyTikGsR8J_e81qjAgU', -28.136167, 153.3173518, 'city', '1'),
('countries_australia_queensland_avenell_heights', 'ChIJH1TYU6S-62sRkAshf_HuAAU', -24.8916192, 152.3598188, 'city', '1'),
('countries_australia_queensland_avoca', 'ChIJL5JIiSq662sRoAshf_HuAAU', -24.88139, 152.3128456, 'city', '1'),
('countries_australia_queensland_avondale', 'ChIJ6S3OQ_-162sRAMogf_HuAAQ', -24.7638088, 152.153117, 'city', '1'),
('countries_australia_queensland_ayr', 'ChIJafDne6U71msRkAEhf_HuAAU', -19.5744451, 147.4066109, 'city', '1'),
('countries_australia_queensland_babinda', 'ChIJe-u5LtTreGkRAHIgf_HuAAQ', -17.3436894, 145.9197089, 'city', '1'),
('countries_australia_queensland_baffle_creek', 'ChIJ98_f_cQu6msRgM0gf_HuAAQ', -24.4571204, 151.8984888, 'city', '1'),
('countries_australia_queensland_bahrs_scrub', 'ChIJCbOZokBAkWsREH_e81qjAgU', -27.7307469, 153.1632203, 'city', '1'),
('countries_australia_queensland_bajool', 'ChIJFRQgoSJMwmsREMogf_HuAAQ', -23.652183, 150.6440299, 'city', '1'),
('countries_australia_queensland_bakers_creek', 'ChIJUYKSnnDS22sRQAMhf_HuAAU', -21.2073015, 149.1465598, 'city', '1'),
('countries_australia_queensland_balberra', 'ChIJi6ibReHM22sRwIggf_HuAAQ', -21.2737453, 149.1423009, 'city', '1'),
('countries_australia_queensland_bald_hills', 'ChIJoQ-AC7X9k2sRIH_e81qjAgU', -27.3175935, 153.010807, 'city', '1'),
('countries_australia_queensland_bald_knob', 'ChIJKYImb3eGk2sRMKje81qjAgU', -26.7783491, 152.9074386, 'city', '1'),
('countries_australia_queensland_balgal_beach', 'ChIJ_a9fj8clfmkRwHkgf_HuAAQ', -19.041637, 146.4192796, 'city', '1'),
('countries_australia_queensland_ballandean', 'ChIJp3GyMU9HmGsRMKogf_HuAAQ', -28.801, 151.843, 'city', '1'),
('countries_australia_queensland_balmoral', 'ChIJaznF4QdZkWsRMH_e81qjAgU', -27.4554701, 153.0667054, 'city', '1'),
('countries_australia_queensland_balmoral_ridge', 'ChIJXeMMvcyGk2sREMLe81qjAgU', -26.7640852, 152.8861893, 'city', '1'),
('countries_australia_queensland_balnagowan', 'ChIJhx21Hasu2msRIIkgf_HuAAQ', -21.1236595, 149.0289827, 'city', '1'),
('countries_australia_queensland_bamaga', 'ChIJefHa1gGiumkRENggf_HuAAQ', -10.892344, 142.3871554, 'city', '1'),
('countries_australia_queensland_banana', 'ChIJD6ZYn1g9wWsRwMwgf_HuAAQ', -24.4714475, 150.1283063, 'city', '1'),
('countries_australia_queensland_bangalee', 'ChIJU-pIQ0rdwmsREA4hf_HuAAU', -23.0754186, 150.7633845, 'city', '1'),
('countries_australia_queensland_banksia_beach', 'ChIJu3iQGc6Uk2sRQH_e81qjAgU', -27.0448804, 153.1362212, 'city', '1'),
('countries_australia_queensland_banks_pocket', 'ChIJzwxTr3yjlGsR8PAgf_HuAAQ', -26.1526515, 152.6697715, 'city', '1'),
('countries_australia_queensland_bannockburn', 'ChIJHY1kF_g_kWsRUH_e81qjAgU', -27.7642268, 153.189448, 'city', '1'),
('countries_australia_queensland_banyo', 'ChIJD1bcEHLik2sRcH_e81qjAgU', -27.3759739, 153.0806722, 'city', '1'),
('countries_australia_queensland_baralaba', 'ChIJ8WhefwRJwWsRgMkgf_HuAAQ', -24.3305908, 149.9807723, 'city', '1'),
('countries_australia_queensland_barambah', 'ChIJjY9xus3ilGsR8Oggf_HuAAQ', -26.3140708, 152.1158021, 'city', '1'),
('countries_australia_queensland_barcaldine', 'ChIJs0p-u3bVNGoRAJUgf_HuAAQ', -23.5559218, 145.2882741, 'city', '1'),
('countries_australia_queensland_bardon', 'ChIJCQHsTUpXkWsRgH_e81qjAgU', -27.4579508, 152.9858218, 'city', '1'),
('countries_australia_queensland_barellan_point', 'ChIJRcku98NMkWsRkH_e81qjAgU', -27.5704909, 152.8416638, 'city', '1'),
('countries_australia_queensland_bargara', 'ChIJMdxLIPy_62sREMkgf_HuAAQ', -24.8193603, 152.4552931, 'city', '1'),
('countries_australia_queensland_barlows_hill', 'ChIJ7znQCZXnwmsRYA0hf_HuAAU', -23.1076583, 150.7439033, 'city', '1'),
('countries_australia_queensland_barmaryee', 'ChIJ6w6VV7_mwmsRcA0hf_HuAAU', -23.1325554, 150.7153796, 'city', '1'),
('countries_australia_queensland_barney_point', 'ChIJaS9Tovd0wmsRIA4hf_HuAAU', -23.8522633, 151.2731818, 'city', '1'),
('countries_australia_queensland_barney_view', 'ChIJ9Uv5nKozl2sR8N0gf_HuAAQ', -28.2358764, 152.763996, 'city', '1'),
('countries_australia_queensland_barrine', 'ChIJZRL2eQebeGkRUHQgf_HuAAQ', -17.2174978, 145.607653, 'city', '1'),
('countries_australia_queensland_barron', 'ChIJD1PiOXhleGkRcAYhf_HuAAU', -16.8794434, 145.7083586, 'city', '1'),
('countries_australia_queensland_basin_pocket', 'ChIJtTKnH2e0lmsRoH_e81qjAgU', -27.600775, 152.7708042, 'city', '1'),
('countries_australia_queensland_battery_hill', 'ChIJ27JIereek2sRQKje81qjAgU', -26.7776594, 153.1301484, 'city', '1'),
('countries_australia_queensland_bauple', 'ChIJ-1RVfgpO62sRcO4gf_HuAAQ', -25.8119385, 152.6190981, 'city', '1'),
('countries_australia_queensland_bayview_heights', 'ChIJ1TdaXb1jeGkRgAYhf_HuAAU', -16.9586265, 145.730255, 'city', '1'),
('countries_australia_queensland_beachmere', 'ChIJ5aXkwtvtk2sRsH_e81qjAgU', -27.1290743, 153.0523223, 'city', '1'),
('countries_australia_queensland_beach_holm', 'ChIJ5bkExuP11WsRAPsgf_HuAAU', -19.1815255, 146.6568148, 'city', '1'),
('countries_australia_queensland_beaconsfield', 'ChIJuXind7TV22sRUAMhf_HuAAU', -21.0918733, 149.1716353, 'city', '1'),
('countries_australia_queensland_beaudesert', 'ChIJM2XN7bQokWsRwH_e81qjAgU', -27.9882528, 152.9959338, 'city', '1'),
('countries_australia_queensland_bedourie', 'ChIJ04t3eKAmamoRQJggf_HuAAQ', -24.5351117, 139.5677302, 'city', '1'),
('countries_australia_queensland_beecher', 'ChIJRyjT3e8MwmsREA8hf_HuAAU', -23.9100462, 151.197719, 'city', '1'),
('countries_australia_queensland_beechmont', 'ChIJuWqHx-ffkGsREKDe81qjAgU', -28.1204705, 153.1828197, 'city', '1'),
('countries_australia_queensland_beelbi_creek', 'ChIJWXFM0f5562sRIPEgf_HuAAQ', -25.2991918, 152.6409605, 'city', '1'),
('countries_australia_queensland_beenleigh', 'ChIJS0D7BrpqkWsR0H_e81qjAgU', -27.7150151, 153.1939492, 'city', '1'),
('countries_australia_queensland_beerburrum', 'ChIJB-ms3HyOk2sRUKje81qjAgU', -26.9612832, 152.9543358, 'city', '1'),
('countries_australia_queensland_beeron', 'ChIJj8qHPgXhv2sRsOwgf_HuAAQ', -25.8300403, 151.2642501, 'city', '1'),
('countries_australia_queensland_beerwah', 'ChIJrdfwZHGPk2sRYKje81qjAgU', -26.8570086, 152.9577573, 'city', '1'),
('countries_australia_queensland_belgian_gardens', 'ChIJFzd3Gvr41WsREPsgf_HuAAU', -19.2495307, 146.7907569, 'city', '1'),
('countries_australia_queensland_belivah', 'ChIJSRqERoo_kWsR4H_e81qjAgU', -27.758034, 153.181436, 'city', '1'),
('countries_australia_queensland_bell', 'ChIJObDYatf6lWsRMKggf_HuAAQ', -26.9321042, 151.4498312, 'city', '1'),
('countries_australia_queensland_bellara', 'ChIJo1_utS_rk2sR8H_e81qjAgU', -27.0635587, 153.1479261, 'city', '1'),
('countries_australia_queensland_bella_creek', 'ChIJKR9juKOOlGsRIOkgf_HuAAQ', -26.4716315, 152.5614596, 'city', '1'),
('countries_australia_queensland_bellbird_park', 'ChIJWU2XL6dLkWsRAIDe81qjAgU', -27.6413164, 152.884729, 'city', '1'),
('countries_australia_queensland_bellbowrie', 'ChIJhYk6e65NkWsREIDe81qjAgU', -27.5619404, 152.8868313, 'city', '1'),
('countries_australia_queensland_bellenden_ker', 'ChIJN6Fh5NDteGkR0HIgf_HuAAQ', -17.2603155, 145.9249065, 'city', '1'),
('countries_australia_queensland_belli_park', 'ChIJjdeqPIeClGsRAMPe81qjAgU', -26.5115333, 152.8232493, 'city', '1'),
('countries_australia_queensland_bellmere', 'ChIJO8lVMmD0k2sRIIDe81qjAgU', -27.089167, 152.926667, 'city', '1'),
('countries_australia_queensland_bells_bridge', 'ChIJ-bHG61-5lGsRgO4gf_HuAAQ', -26.1150715, 152.5489476, 'city', '1'),
('countries_australia_queensland_bells_creek', 'ChIJ7Ww0FgCbk2sRcKje81qjAgU', -26.7870664, 153.0650872, 'city', '1'),
('countries_australia_queensland_bellthorpe', 'ChIJXdCHXDZxlGsRsMHe81qjAgU', -26.8524054, 152.7272799, 'city', '1'),
('countries_australia_queensland_belmont', 'ChIJRThdCuZbkWsRMIDe81qjAgU', -27.4889135, 153.1273047, 'city', '1'),
('countries_australia_queensland_benaraby', 'ChIJ5a28VEAIwmsRQMggf_HuAAQ', -24.0066664, 151.3263139, 'city', '1'),
('countries_australia_queensland_benarkin', 'ChIJoRGFs0o0lGsRoMAgf_HuAAQ', -26.886944, 152.137778, 'city', '1'),
('countries_australia_queensland_benowa', 'ChIJj2X6UNQakWsRMKDe81qjAgU', -28.0099412, 153.3910447, 'city', '1'),
('countries_australia_queensland_bentley_park', 'ChIJdWiyhE1ieGkRkAYhf_HuAAU', -17.004, 145.738, 'city', '1'),
('countries_australia_queensland_berat', 'ChIJ39mHc-Wnl2sRALAgf_HuAAQ', -28.0446572, 152.0469231, 'city', '1'),
('countries_australia_queensland_berrinba', 'ChIJM9b9d6BGkWsRUIDe81qjAgU', -27.6584619, 153.080652, 'city', '1'),
('countries_australia_queensland_berserker', 'ChIJXVe-JfAAw2sRQP8gf_HuAAU', -23.3628085, 150.5227976, 'city', '1'),
('countries_australia_queensland_biddaddaba', 'ChIJ5zN0RvAjkWsRoNfe81qjAgU', -27.9902304, 153.1112046, 'city', '1'),
('countries_australia_queensland_biddeston', 'ChIJaeJXVxdHlmsRMK4gf_HuAAQ', -27.5560291, 151.7182317, 'city', '1'),
('countries_australia_queensland_bidwill', 'ChIJg5Q8jsdd62sRcBEhf_HuAAU', -25.5896101, 152.7165621, 'city', '1'),
('countries_australia_queensland_biggenden', 'ChIJPSAMf9rY6msR8O0gf_HuAAQ', -25.5100942, 152.043019, 'city', '1'),
('countries_australia_queensland_biggera_waters', 'ChIJf0UzACoQkWsRUKDe81qjAgU', -27.9322251, 153.3994829, 'city', '1'),
('countries_australia_queensland_bilinga', 'ChIJy-UagOcBkWsRgKDe81qjAgU', -28.16, 153.51, 'city', '1'),
('countries_australia_queensland_billa_billa', 'ChIJ3YqlozYso2sRELAgf_HuAAQ', -28.1813019, 150.2806851, 'city', '1'),
('countries_australia_queensland_biloela', 'ChIJIT6zne90wWsRYAIhf_HuAAU', -24.4025351, 150.5124322, 'city', '1'),
('countries_australia_queensland_bilyana', 'ChIJaXtEowkUf2kRkHsgf_HuAAQ', -18.1159394, 145.908723, 'city', '1'),
('countries_australia_queensland_bingil_bay', 'ChIJy3RGgjksf2kRIHkgf_HuAAQ', -17.8303328, 146.0951366, 'city', '1'),
('countries_australia_queensland_birdsville', 'ChIJ_daSu8ZzaGoR4Jcgf_HuAAQ', -25.8982126, 139.353513, 'city', '1');
INSERT INTO `{db_prefix}geo_mapping` (`Format_key`, `Place_ID`, `Lat`, `Lng`, `Target`, `Verified`) VALUES
('countries_australia_queensland_birkdale', 'ChIJPfmE7VRnkWsRgIDe81qjAgU', -27.4935931, 153.2137869, 'city', '1'),
('countries_australia_queensland_birnam', 'ChIJF0J-rKolkWsRcLje81qjAgU', -27.9499903, 153.0720636, 'city', '1'),
('countries_australia_queensland_birtinya', 'ChIJn7PBxW-ek2sRgKje81qjAgU', -26.7466819, 153.1189741, 'city', '1'),
('countries_australia_queensland_blackall', 'ChIJuff3D_5KtWsRIJUgf_HuAAQ', -24.4250565, 145.4643163, 'city', '1'),
('countries_australia_queensland_blackbutt', 'ChIJxdUk0eI0lGsR4L8gf_HuAAQ', -26.8851834, 152.1011318, 'city', '1'),
('countries_australia_queensland_blacksoil', 'ChIJtdP6x8m2lmsRoIDe81qjAgU', -27.5768771, 152.7068029, 'city', '1'),
('countries_australia_queensland_blackstone', 'ChIJ326-kNq0lmsRsIDe81qjAgU', -27.6259862, 152.8077665, 'city', '1'),
('countries_australia_queensland_blacks_beach', 'ChIJR8QI6PrV22sRYAMhf_HuAAU', -21.059181, 149.185798, 'city', '1'),
('countries_australia_queensland_blackwater', 'ChIJ-zE_G6DExWsRUJogf_HuAAQ', -23.5745988, 148.887168, 'city', '1'),
('countries_australia_queensland_black_mountain', 'ChIJ3dmNUlxik2sRIMPe81qjAgU', -26.3975158, 152.8766207, 'city', '1'),
('countries_australia_queensland_black_river', 'ChIJ2-XK7YX01WsRIPsgf_HuAAU', -19.243634, 146.629318, 'city', '1'),
('countries_australia_queensland_black_snake', 'ChIJ7-8-ZLnClGsRMOkgf_HuAAQ', -26.2203939, 152.2741929, 'city', '1'),
('countries_australia_queensland_blenheim', 'ChIJFyzs-tjtlmsRQOMgf_HuAAQ', -27.653889, 152.313056, 'city', '1'),
('countries_australia_queensland_bli_bli', 'ChIJ6cwBbQlwk2sRkKje81qjAgU', -26.6167293, 153.036215, 'city', '1'),
('countries_australia_queensland_bloomsbury', 'ChIJs1ueWUvu2WsRsIIgf_HuAAQ', -20.7045744, 148.5956795, 'city', '1'),
('countries_australia_queensland_bluewater', 'ChIJpXoHIp2K1WsRQPsgf_HuAAU', -19.1744543, 146.5501801, 'city', '1'),
('countries_australia_queensland_blue_mountain_heights', 'ChIJpba_mItdlmsR8PUgf_HuAAU', -27.505239, 151.9558841, 'city', '1'),
('countries_australia_queensland_bogie', 'ChIJGSqO7EgO12sRAIcgf_HuAAQ', -20.3068512, 147.9330949, 'city', '1'),
('countries_australia_queensland_bohle', 'ChIJ4wgH3uT21WsRYPsgf_HuAAU', -19.253574, 146.7193377, 'city', '1'),
('countries_australia_queensland_bohle_plains', 'ChIJk9ti1tfw1WsRcPsgf_HuAAU', -19.3079742, 146.6908651, 'city', '1'),
('countries_australia_queensland_bokarina', 'ChIJiWe5AGeek2sRoKje81qjAgU', -26.7361859, 153.1319105, 'city', '1'),
('countries_australia_queensland_bollier', 'ChIJ4Xmh-leDlGsR8MPe81qjAgU', -26.4594019, 152.7316844, 'city', '1'),
('countries_australia_queensland_bondoola', 'ChIJMcMowBfkwmsRgIkgf_HuAAQ', -23.1745537, 150.689001, 'city', '1'),
('countries_australia_queensland_bongaree', 'ChIJo-xjU93qk2sRwIDe81qjAgU', -27.0762065, 153.1644052, 'city', '1'),
('countries_australia_queensland_bongeen', 'ChIJF2UBgowllmsRUKogf_HuAAQ', -27.5812298, 151.4452886, 'city', '1'),
('countries_australia_queensland_bonogin', 'ChIJgweL3eAckWsRsKDe81qjAgU', -28.1296914, 153.3470204, 'city', '1'),
('countries_australia_queensland_bony_mountain', 'ChIJf6OIKo28l2sRQLAgf_HuAAQ', -28.1332337, 151.8339051, 'city', '1'),
('countries_australia_queensland_booie', 'ChIJb1C5UwOmlWsR8Pcgf_HuAAU', -26.5433568, 151.9405735, 'city', '1'),
('countries_australia_queensland_boolboonda', 'ChIJU3pDCduK6msRoM0gf_HuAAQ', -25.0690006, 151.6896712, 'city', '1'),
('countries_australia_queensland_boonah', 'ChIJa471Q9PXlmsRIN0gf_HuAAQ', -27.9988823, 152.6819874, 'city', '1'),
('countries_australia_queensland_boonarga', 'ChIJeTU8zF93vmsRYKogf_HuAAQ', -26.7971677, 150.7193664, 'city', '1'),
('countries_australia_queensland_boondall', 'ChIJ_6OVSoTik2sR0IDe81qjAgU', -27.3533586, 153.0606302, 'city', '1'),
('countries_australia_queensland_boonooroo', 'ChIJMV-xOFWg7GsRkO4gf_HuAAQ', -25.6675589, 152.8951616, 'city', '1'),
('countries_australia_queensland_booral', 'ChIJDc44eduD7GsRQPggf_HuAAU', -25.3610544, 152.907736, 'city', '1'),
('countries_australia_queensland_booval', 'ChIJ20EoNJO0lmsR4IDe81qjAgU', -27.614358, 152.788861, 'city', '1'),
('countries_australia_queensland_booyal', 'ChIJU_8uhB0C62sRUMogf_HuAAQ', -25.215462, 152.0409679, 'city', '1'),
('countries_australia_queensland_boronia_heights', 'ChIJkaOpPtdHkWsRAIHe81qjAgU', -27.6851293, 153.0152629, 'city', '1'),
('countries_australia_queensland_bororen', 'ChIJGW_UrTH46WsRUMggf_HuAAQ', -24.2416955, 151.4954993, 'city', '1'),
('countries_australia_queensland_bouldercombe', 'ChIJTduySM2vw2sRIMggf_HuAAQ', -23.5700902, 150.4693446, 'city', '1'),
('countries_australia_queensland_boulia', 'ChIJC0hqrQimamoRwJcgf_HuAAQ', -22.9110493, 139.9118532, 'city', '1'),
('countries_australia_queensland_bowen', 'ChIJn3O84QSD12sR8IEgf_HuAAQ', -20.0121024, 148.246279, 'city', '1'),
('countries_australia_queensland_bowenville', 'ChIJj6EiPBEalmsRcKogf_HuAAQ', -27.3046484, 151.4919516, 'city', '1'),
('countries_australia_queensland_bowen_hills', 'ChIJQ-uZO8BZkWsRIIHe81qjAgU', -27.4476872, 153.03764, 'city', '1'),
('countries_australia_queensland_boyland', 'ChIJdR1cFGoYkWsRsNfe81qjAgU', -27.9509696, 153.1503717, 'city', '1'),
('countries_australia_queensland_boyne_island', 'ChIJt4WS7_sKwmsRAMkgf_HuAAQ', -23.9477001, 151.3550741, 'city', '1'),
('countries_australia_queensland_bracken_ridge', 'ChIJMykIpODik2sRQIHe81qjAgU', -27.3237467, 153.0266071, 'city', '1'),
('countries_australia_queensland_braemore', 'ChIJM0s3e-48lGsRcMIgf_HuAAQ', -27.0434385, 152.3847318, 'city', '1'),
('countries_australia_queensland_bramston_beach', 'ChIJ2xIzbproeGkREHsgf_HuAAQ', -17.3551701, 146.024547, 'city', '1'),
('countries_australia_queensland_brandon', 'ChIJ6RAnoK481msR0IMgf_HuAAQ', -19.5544034, 147.3532532, 'city', '1'),
('countries_australia_queensland_branyan', 'ChIJLWR9pGK662sRsAshf_HuAAU', -24.9159533, 152.2604658, 'city', '1'),
('countries_australia_queensland_brassall', 'ChIJlXPUzB20lmsRUIHe81qjAgU', -27.5887681, 152.7362081, 'city', '1'),
('countries_australia_queensland_bray_park', 'ChIJ7RSi_In8k2sRYIHe81qjAgU', -27.2970689, 152.9677896, 'city', '1'),
('countries_australia_queensland_brendale', 'ChIJb5WWheL8k2sRgIHe81qjAgU', -27.3264861, 152.9796004, 'city', '1'),
('countries_australia_queensland_bridgeman_downs', 'ChIJoVCpaPxXkWsRoIHe81qjAgU', -27.355, 152.9942, 'city', '1'),
('countries_spain_canary_islands_playa_blanca', 'ChIJCX-kHUY3RgwRgDDZzodRc0c', 28.8669999, -13.8390162, 'city', '1'),
('countries_australia_queensland_brighton', 'ChIJs2Sh3hfjk2sRsIHe81qjAgU', -27.2944002, 153.0509868, 'city', '1'),
('countries_australia_queensland_brightview', 'ChIJwc_2EUu8lmsRwIHe81qjAgU', -27.5136093, 152.4965271, 'city', '1'),
('countries_australia_queensland_brinsmead', 'ChIJOdqgI1VkeGkRoAYhf_HuAAU', -16.9023248, 145.7146228, 'city', '1'),
('countries_spain_canary_islands_mogan', 'ChIJbzuC9uWGQAwRdv2APt6z6js', 27.8839292, -15.723279, 'city', '1'),
('countries_australia_queensland_broadbeach', 'ChIJdRngDcMEkWsR4KDe81qjAgU', -28.0293438, 153.4311592, 'city', '1'),
('countries_australia_queensland_broadbeach_waters', 'ChIJJUXpZsIEkWsR8KDe81qjAgU', -28.0293767, 153.4100467, 'city', '1'),
('countries_australia_queensland_brookfield', 'ChIJd-sfgC5SkWsREILe81qjAgU', -27.4946276, 152.9088908, 'city', '1'),
('countries_australia_queensland_brookhill', 'ChIJo3u_aVbj1WsRgPsgf_HuAAU', -19.4132313, 146.8500675, 'city', '1'),
('countries_australia_queensland_brookstead', 'ChIJlzk6tSYtlmsRgKogf_HuAAQ', -27.7587529, 151.4482185, 'city', '1'),
('countries_australia_queensland_brookwater', 'ChIJ19LwaaRLkWsRUNve81qjAgU', -27.6554921, 152.8951796, 'city', '1'),
('countries_australia_queensland_brooloo', 'ChIJM1jcjD2ElGsRYOcgf_HuAAQ', -26.4887573, 152.7021914, 'city', '1'),
('countries_australia_queensland_brooweena', 'ChIJEcsfnG8762sRoO4gf_HuAAQ', -25.6036965, 152.2639342, 'city', '1'),
('countries_australia_queensland_browns_plains', 'ChIJMYXRz4tGkWsRIILe81qjAgU', -27.6624358, 153.0527734, 'city', '1'),
('countries_australia_queensland_broxburn', 'ChIJDeCgUQpKlmsRoLAgf_HuAAQ', -27.7160868, 151.6923846, 'city', '1'),
('countries_australia_queensland_buaraba', 'ChIJX30ApZSalmsRsMAgf_HuAAQ', -27.3710034, 152.3015509, 'city', '1'),
('countries_australia_queensland_bucasia', 'ChIJN_MXIi1-2WsRcAMhf_HuAAU', -21.0353655, 149.1589657, 'city', '1'),
('countries_australia_queensland_bucca', 'ChIJw5DgERSz62sRYMogf_HuAAQ', -24.8636783, 152.0966646, 'city', '1'),
('countries_australia_queensland_buccan', 'ChIJZz3R6ZlAkWsRMILe81qjAgU', -27.7406561, 153.145422, 'city', '1'),
('countries_australia_queensland_buddina', 'ChIJFZyA__J1k2sRwKje81qjAgU', -26.6991396, 153.1348338, 'city', '1'),
('countries_australia_queensland_buderim', 'ChIJb3GRd893k2sR0Kje81qjAgU', -26.6856968, 153.0506602, 'city', '1'),
('countries_australia_queensland_bulgun', 'ChIJkSd79_g5f2kRoBMhf_HuAAU', -17.897509, 145.9286525, 'city', '1'),
('countries_australia_queensland_bulimba', 'ChIJXTV7959ZkWsRQILe81qjAgU', -27.4481394, 153.0586203, 'city', '1'),
('countries_australia_queensland_bullyard', 'ChIJFcDTUeNS6msRAM4gf_HuAAQ', -24.9509441, 152.0610284, 'city', '1'),
('countries_australia_queensland_bunburra', 'ChIJ_dMcfx4pl2sRAN4gf_HuAAQ', -28.0381153, 152.6755125, 'city', '1'),
('countries_australia_queensland_bundaberg', 'ChIJU1lsDkq562sRwAshf_HuAAU', -24.8661024, 152.3488923, 'city', '1'),
('countries_australia_queensland_bundall', 'ChIJc8AUbEwFkWsRAKHe81qjAgU', -28.0116997, 153.4040074, 'city', '1'),
('countries_australia_queensland_bundamba', 'ChIJzT1XNOq0lmsRYILe81qjAgU', -27.6035857, 152.8095691, 'city', '1'),
('countries_australia_queensland_bungadoo', 'ChIJ_41yAr-s62sRcMogf_HuAAQ', -24.9902468, 152.0778022, 'city', '1'),
('countries_australia_queensland_bungalow', 'ChIJyWd-SB1keGkRsAYhf_HuAAU', -16.9365753, 145.7568157, 'city', '1'),
('countries_australia_queensland_bungundarra', 'ChIJgUNQlsvfwmsREIQgf_HuAAQ', -23.0459382, 150.6502543, 'city', '1'),
('countries_australia_queensland_bunjurgen', 'ChIJXcTQPzoml2sREN4gf_HuAAQ', -28.0415707, 152.6243044, 'city', '1'),
('countries_australia_queensland_bunya', 'ChIJVcbc9iFWkWsRcILe81qjAgU', -27.3741845, 152.9304003, 'city', '1'),
('countries_australia_queensland_burbank', 'ChIJlwgpkZxckWsRkILe81qjAgU', -27.5546939, 153.1449947, 'city', '1'),
('countries_australia_queensland_burdell', 'ChIJoQHzOwL31WsRkPsgf_HuAAU', -19.2432404, 146.6974958, 'city', '1'),
('countries_australia_queensland_burketown', 'ChIJ1VtafALHH2oREG0gf_HuAAQ', -17.7422259, 139.5479392, 'city', '1'),
('countries_australia_queensland_burleigh_heads', 'ChIJPTfdv_UEkWsRIKHe81qjAgU', -28.1033061, 153.4235791, 'city', '1'),
('countries_australia_queensland_burleigh_waters', 'ChIJz0bUTXEDkWsRMKHe81qjAgU', -28.0807211, 153.4333922, 'city', '1'),
('countries_australia_queensland_burnett_heads', 'ChIJt5R-xFbA62sRQMkgf_HuAAQ', -24.7636899, 152.4055588, 'city', '1'),
('countries_australia_queensland_burnside', 'ChIJI1E5NMV4k2sR4Kje81qjAgU', -26.6357331, 152.946156, 'city', '1'),
('countries_australia_queensland_burpengary', 'ChIJhR_tkHfwk2sRoILe81qjAgU', -27.1615373, 152.958072, 'city', '1'),
('countries_australia_queensland_burpengary_east', 'ChIJP7UQoL3xk2sRXiDFfA_uM3g', -27.1415653, 152.9997861, 'city', '1'),
('countries_australia_queensland_burrum_heads', 'ChIJaXcuDsl362sRIO4gf_HuAAQ', -25.1842574, 152.6141651, 'city', '1'),
('countries_australia_queensland_burua', 'ChIJxxw_c2QMwmsREM4gf_HuAAQ', -23.9358155, 151.219052, 'city', '1'),
('countries_australia_queensland_bushland_beach', 'ChIJM91Skif21WsRoPsgf_HuAAU', -19.2007673, 146.6738386, 'city', '1'),
('countries_australia_queensland_buxton', 'ChIJRZEF1WR162sRcNYgf_HuAAQ', -25.1960738, 152.5395372, 'city', '1'),
('countries_australia_queensland_byfield', 'ChIJcRZxPxvXwmsRUIYgf_HuAAQ', -22.8299488, 150.6382045, 'city', '1'),
('countries_australia_queensland_byrnestown', 'ChIJ8cYxJmjG6msRgMogf_HuAAQ', -25.5231305, 151.7622168, 'city', '1'),
('countries_australia_queensland_cabarlah', 'ChIJI3PNUnZhlmsRsKogf_HuAAQ', -27.4283142, 151.9918223, 'city', '1'),
('countries_australia_queensland_caboolture', 'ChIJS31kU6yNk2sRwILe81qjAgU', -27.0849748, 152.9515862, 'city', '1'),
('countries_australia_queensland_caboolture_south', 'ChIJv8YO2WPxk2sRcA_f81qjAgU', -27.0942835, 152.9496905, 'city', '1'),
('countries_spain_canary_islands_los_llanos_de_aridane', 'ChIJF_CHhTXyawwRozp80m3jG4c', 28.6183515, -17.8998566, 'city', '0'),
('countries_australia_queensland_calamvale', 'ChIJ92RYpF1EkWsR0ILe81qjAgU', -27.6235502, 153.04836, 'city', '1'),
('countries_australia_queensland_calcium', 'ChIJ_4krQmzb1WsRYIYgf_HuAAQ', -19.6736239, 146.8122969, 'city', '1'),
('countries_australia_queensland_calen', 'ChIJr09eNyWL2WsRkIIgf_HuAAQ', -20.8980013, 148.7728669, 'city', '1'),
('countries_australia_queensland_calgoa', 'ChIJH_6sQlvSlGsR8Owgf_HuAAQ', -25.8664009, 152.2544435, 'city', '1'),
('countries_australia_queensland_callemondah', 'ChIJOUFxHApzwmsRQA4hf_HuAAU', -23.8603817, 151.2228185, 'city', '1'),
('countries_australia_queensland_calliope', 'ChIJfSNZz-IOwmsR8Mggf_HuAAQ', -24.0062017, 151.2011287, 'city', '1'),
('countries_australia_queensland_caloundra', 'ChIJA9NEJ0mZk2sR8Kje81qjAgU', -26.8043999, 153.1254643, 'city', '1'),
('countries_australia_queensland_calvert', 'ChIJfQyiqxnBlmsR0Nwgf_HuAAQ', -27.6642547, 152.5157255, 'city', '1'),
('countries_australia_queensland_cambooya', 'ChIJpzld5tBNlmsR0Kkgf_HuAAQ', -27.7068072, 151.8651022, 'city', '1'),
('countries_australia_queensland_cambroon', 'ChIJ3ar-plt-lGsR4MLe81qjAgU', -26.6398046, 152.685423, 'city', '1'),
('countries_australia_queensland_camira', 'ChIJl5lgZP1LkWsR8ILe81qjAgU', -27.6325619, 152.9157778, 'city', '1'),
('countries_australia_queensland_campwin_beach', 'ChIJj0c3hzXG22sRz1fO7-QU8Rc', -21.3776899, 149.314171, 'city', '1'),
('countries_australia_queensland_camp_hill', 'ChIJ9ztgirRbkWsRAIPe81qjAgU', -27.4982559, 153.076164, 'city', '1'),
('countries_australia_queensland_camp_mountain', 'ChIJIaN7tWZWkWsREIPe81qjAgU', -27.3972994, 152.8703231, 'city', '1'),
('countries_australia_queensland_canina', 'ChIJKUkid1ymlGsRcPEgf_HuAAQ', -26.1386835, 152.7443527, 'city', '1'),
('countries_australia_queensland_cannonvale', 'ChIJfRARNijL2WsRMAohf_HuAAU', -20.2771336, 148.6964349, 'city', '1'),
('countries_australia_queensland_cannon_hill', 'ChIJr_jaVmJZkWsRMIPe81qjAgU', -27.4711751, 153.0960423, 'city', '1'),
('countries_australia_queensland_cannon_valley', 'ChIJBWBHbFDM2WsRIAohf_HuAAU', -20.3084591, 148.6598511, 'city', '1'),
('countries_australia_queensland_canoona', 'ChIJpQg6llZqw2sRcJMgf_HuAAQ', -23.0542528, 150.1845779, 'city', '1'),
('countries_australia_queensland_canungra', 'ChIJDeoxfBchkWsRQKHe81qjAgU', -28.0171604, 153.1647202, 'city', '1'),
('countries_australia_queensland_capalaba', 'ChIJdYBNKH5nkWsRQIPe81qjAgU', -27.5354669, 153.1971252, 'city', '1'),
('countries_australia_queensland_capella', 'ChIJr-QTWLlsz2sR0Jkgf_HuAAQ', -23.0866484, 148.0232995, 'city', '1'),
('countries_australia_queensland_cape_tribulation', 'ChIJEXX4lYNenWkR8HIgf_HuAAQ', -16.0888584, 145.4622284, 'city', '1'),
('countries_australia_queensland_caravonica', 'ChIJDSLGy0RleGkR4AYhf_HuAAU', -16.869141, 145.681001, 'city', '1'),
('countries_australia_queensland_carbrook', 'ChIJZ3x-JXhpkWsRYIPe81qjAgU', -27.687366, 153.2638788, 'city', '1'),
('countries_australia_queensland_cardwell', 'ChIJI46CCGsGf2kRsHggf_HuAAQ', -18.2628086, 146.0244344, 'city', '1'),
('countries_australia_queensland_carina', 'ChIJ_dZkDftbkWsRcIPe81qjAgU', -27.4833383, 153.0970062, 'city', '1'),
('countries_australia_queensland_carina_heights', 'ChIJf01ladRbkWsRgIPe81qjAgU', -27.5041819, 153.0928368, 'city', '1'),
('countries_australia_queensland_carindale', 'ChIJjZye3t1bkWsRkIPe81qjAgU', -27.5198367, 153.1125044, 'city', '1'),
('countries_australia_queensland_carmila', 'ChIJVdajkIcO22sRMIIgf_HuAAQ', -21.8059987, 149.3703629, 'city', '1'),
('countries_australia_queensland_carole_park', 'ChIJB34pVFpJkWsRoIPe81qjAgU', -27.6208346, 152.9346327, 'city', '1'),
('countries_australia_queensland_carpendale', 'ChIJj-i6x4_zlmsRcOMgf_HuAAQ', -27.5875912, 152.1423951, 'city', '1'),
('countries_australia_queensland_carrara', 'ChIJk1rll9UEkWsRYKHe81qjAgU', -28.0211196, 153.3618544, 'city', '1'),
('countries_australia_queensland_carseldine', 'ChIJZx9xakr9k2sRsIPe81qjAgU', -27.3461724, 153.0138992, 'city', '1'),
('countries_australia_queensland_carters_ridge', 'ChIJ1THrHdSclGsRgMPe81qjAgU', -26.4554819, 152.7744837, 'city', '1'),
('countries_australia_queensland_cashmere', 'ChIJs1iniJH-k2sRwIPe81qjAgU', -27.3013588, 152.9272871, 'city', '1'),
('countries_australia_queensland_castaways_beach', 'ChIJsxUxW01pk2sREKne81qjAgU', -26.4300002, 153.1049618, 'city', '1'),
('countries_australia_queensland_castle_hill', 'ChIJ40rwXeL41WsRsPsgf_HuAAU', -19.2516378, 146.7986436, 'city', '1'),
('countries_australia_queensland_cawarral', 'ChIJT7L7fljjwmsRIIQgf_HuAAQ', -23.2543478, 150.675998, 'city', '1'),
('countries_australia_queensland_cawdor', 'ChIJVxk5rMFnlmsRkBIhf_HuAAU', -27.4659008, 151.9216596, 'city', '1'),
('countries_australia_queensland_cecil_plains', 'ChIJW_uSYP6EvWsRsKkgf_HuAAQ', -27.532555, 151.1935034, 'city', '1'),
('countries_australia_queensland_cedar_creek', 'ChIJZXnnx11PkWsRgNfe81qjAgU', -27.8267636, 153.180295, 'city', '1'),
('countries_australia_queensland_cedar_grove', 'ChIJl9_MZ0kwkWsR8IPe81qjAgU', -27.860591, 152.9787792, 'city', '1'),
('countries_australia_queensland_cedar_pocket', 'ChIJiRnYtcSglGsRgPEgf_HuAAQ', -26.1977947, 152.7468741, 'city', '1'),
('countries_australia_queensland_cedar_vale', 'ChIJC5s-IKc6kWsRyLSiOdP_o44', -27.870036, 153.0176656, 'city', '1'),
('countries_australia_queensland_cement_mills', 'ChIJU6d6Hsj2l2sRwKogf_HuAAQ', -28.3399193, 151.5072545, 'city', '1'),
('countries_australia_queensland_centenary_heights', 'ChIJa0L5RPRblmsRAPYgf_HuAAU', -27.586653, 151.9622965, 'city', '1'),
('countries_australia_queensland_chambers_flat', 'ChIJnZYAx2JHkWsRIITe81qjAgU', -27.7495701, 153.0769229, 'city', '1'),
('countries_australia_queensland_chandler', 'ChIJl0X5v7VdkWsRMITe81qjAgU', -27.5139929, 153.1563624, 'city', '1'),
('countries_australia_queensland_chapel_hill', 'ChIJ2-4-OvZQkWsRQITe81qjAgU', -27.494799, 152.9519831, 'city', '1'),
('countries_australia_queensland_charleville', 'ChIJvX-q3rS5s2sRQKEgf_HuAAQ', -26.4012956, 146.2397636, 'city', '1'),
('countries_australia_queensland_charlton', 'ChIJ5UA_YAJDlmsREPYgf_HuAAU', -27.520045, 151.8487076, 'city', '1'),
('countries_australia_queensland_charlwood', 'ChIJxah8Axsnl2sRUN4gf_HuAAQ', -28.0037363, 152.5734845, 'city', '1'),
('countries_australia_queensland_chatsworth', 'ChIJUyM_3Pu6lGsRwO4gf_HuAAQ', -26.1420115, 152.6158016, 'city', '1'),
('countries_australia_queensland_chelmer', 'ChIJpxT_cUlQkWsRYITe81qjAgU', -27.5137668, 152.979572, 'city', '1'),
('countries_australia_queensland_cherbourg', 'ChIJ5w_aTi0blWsRIOcgf_HuAAQ', -26.290015, 151.9538432, 'city', '1'),
('countries_australia_queensland_chermside', 'ChIJX9-EMbDik2sRcITe81qjAgU', -27.3858322, 153.0310009, 'city', '1'),
('countries_australia_queensland_chermside_west', 'ChIJY_veKvhXkWsRgITe81qjAgU', -27.3841107, 153.0125936, 'city', '1'),
('countries_australia_queensland_chevallum', 'ChIJT301yBJ4k2sRIKne81qjAgU', -26.6961374, 152.989817, 'city', '1'),
('countries_australia_queensland_childers', 'ChIJQe0ztGYP62sRoAIhf_HuAAU', -25.2364948, 152.2772276, 'city', '1'),
('countries_australia_queensland_chinchilla', 'ChIJyQQLczd8vmsR8Kcgf_HuAAQ', -26.7458787, 150.6271468, 'city', '1'),
('countries_australia_queensland_christmas_creek', 'ChIJsU8zTpPQkGsRgOMgf_HuAAQ', -28.1684028, 152.9818325, 'city', '1'),
('countries_australia_queensland_churchable', 'ChIJhdY6aUOXlmsR4MIgf_HuAAQ', -27.4253667, 152.3751245, 'city', '1'),
('countries_australia_queensland_churchill', 'ChIJLe4ecMa1lmsRoITe81qjAgU', -27.6425788, 152.7504168, 'city', '1'),
('countries_australia_queensland_chuwar', 'ChIJFRXHiROzlmsRsITe81qjAgU', -27.560072, 152.7948188, 'city', '1'),
('countries_australia_queensland_clagiraba', 'ChIJj_rdc_wYkWsRoKHe81qjAgU', -27.9886155, 153.2429915, 'city', '1'),
('countries_australia_queensland_clare', 'ChIJx4pygIJm1msRQIQgf_HuAAQ', -19.7829507, 147.2264734, 'city', '1'),
('countries_australia_queensland_clarendon', 'ChIJvUO2xkajlmsR8MIgf_HuAAQ', -27.434458, 152.5080917, 'city', '1'),
('countries_australia_queensland_clayfield', 'ChIJwe9U3VBYkWsR8ITe81qjAgU', -27.4159369, 153.0583828, 'city', '1'),
('countries_australia_queensland_clear_island_waters', 'ChIJ9eVAZsoEkWsRsKHe81qjAgU', -28.0392653, 153.4016523, 'city', '1'),
('countries_australia_queensland_clear_mountain', 'ChIJlTx1fET-k2sRAIXe81qjAgU', -27.3307187, 152.9097643, 'city', '1'),
('countries_australia_queensland_clermont', 'ChIJ-RYWHg9lzmsRwJkgf_HuAAQ', -22.8283465, 147.6352382, 'city', '1'),
('countries_australia_queensland_cleveland', 'ChIJ55X7VrhmkWsREIXe81qjAgU', -27.5251556, 153.2792833, 'city', '1'),
('countries_australia_queensland_clifton', 'ChIJCf5ieBOul2sRoKkgf_HuAAQ', -27.9328143, 151.906675, 'city', '1'),
('countries_australia_queensland_clifton_beach', 'ChIJA9NiIAFueGkR8AYhf_HuAAU', -16.7639878, 145.668131, 'city', '1'),
('countries_australia_queensland_clinton', 'ChIJo2HMGJAMwmsRUA4hf_HuAAU', -23.8773781, 151.219881, 'city', '1'),
('countries_australia_queensland_clintonvale', 'ChIJvf6HWqgJl2sR0Kogf_HuAAQ', -28.1007639, 152.1191496, 'city', '1'),
('countries_australia_queensland_cloncurry', 'ChIJyXsHpoEhPWoRYGwgf_HuAAQ', -20.7068535, 140.5053246, 'city', '1'),
('countries_australia_queensland_clontarf', 'ChIJhd4ao7rlk2sRIIXe81qjAgU', -27.2472803, 153.0827328, 'city', '1'),
('countries_australia_queensland_closeburn', 'ChIJ29UasM7_k2sRMIXe81qjAgU', -27.3300498, 152.8671278, 'city', '1'),
('countries_australia_queensland_cluden', 'ChIJRYMVo6r-1WsRwPsgf_HuAAU', -19.315525, 146.830259, 'city', '1'),
('countries_australia_queensland_coalfalls', 'ChIJD4GyFju0lmsRQIXe81qjAgU', -27.6068285, 152.7433994, 'city', '1'),
('countries_australia_queensland_coalstoun_lakes', 'ChIJU8S3HCzQ6msRoOcgf_HuAAQ', -25.6153248, 151.8899519, 'city', '1'),
('countries_australia_queensland_cobraball', 'ChIJi9owuo_hwmsRYIogf_HuAAQ', -23.1628694, 150.6440236, 'city', '1'),
('countries_australia_queensland_coconuts', 'ChIJ84T0iH7beGkR4Hsgf_HuAAQ', -17.5058558, 146.0643624, 'city', '1'),
('countries_australia_queensland_coes_creek', 'ChIJ87F88714k2sRMKne81qjAgU', -26.6481922, 152.9454675, 'city', '1'),
('countries_australia_queensland_colinton', 'ChIJL3fI_8cwlGsRAMMgf_HuAAQ', -26.9299298, 152.3231228, 'city', '1'),
('countries_australia_queensland_collingwood_park', 'ChIJGZCmxBFLkWsRUIXe81qjAgU', -27.6234189, 152.8542416, 'city', '1'),
('countries_australia_queensland_collinsville', 'ChIJ2bVaEDkl12sRAIIgf_HuAAQ', -20.5530632, 147.8442539, 'city', '1'),
('countries_australia_queensland_comet', 'ChIJxVNaU0QGxmsRQJogf_HuAAQ', -23.6052548, 148.5450351, 'city', '1'),
('countries_australia_queensland_condamine', 'ChIJE7c3nicOvGsRsKcgf_HuAAQ', -26.9270865, 150.1364566, 'city', '1'),
('countries_australia_queensland_condon', 'ChIJPYRXMfXw1WsR0Psgf_HuAAU', -19.331591, 146.714754, 'city', '1'),
('countries_australia_queensland_conondale', 'ChIJc-kb2A57lGsRYMLe81qjAgU', -26.7295857, 152.7185567, 'city', '1'),
('countries_australia_queensland_coochiemudlo_island', 'ChIJ8bGtx0xkkWsRgP0g11ujAg8', -27.5692306, 153.3314001, 'city', '1'),
('countries_australia_queensland_coochin', 'ChIJ_xVpdaovl2sRkN4gf_HuAAQ', -28.0995834, 152.6429984, 'city', '1'),
('countries_australia_queensland_cooee_bay', 'ChIJQZg9mi_mwmsRgA0hf_HuAAU', -23.1427436, 150.7592578, 'city', '1'),
('countries_australia_queensland_cooktown', 'ChIJLdKrig_LnWkRUHIgf_HuAAQ', -15.4758164, 145.2470981, 'city', '1'),
('countries_australia_queensland_coolabine', 'ChIJIWJvcViAlGsR0MLe81qjAgU', -26.6078779, 152.7798626, 'city', '1'),
('countries_australia_queensland_coolana', 'ChIJexfo8o27lmsRgIXe81qjAgU', -27.5179402, 152.5523461, 'city', '1'),
('countries_australia_queensland_coolangatta', 'ChIJ74xDH9MBkWsR4KHe81qjAgU', -28.1703145, 153.5304729, 'city', '1'),
('countries_australia_queensland_cooloolabin', 'ChIJaxsa4Al8k2sRQKne81qjAgU', -26.5590387, 152.9174669, 'city', '1'),
('countries_australia_queensland_cooloola_cove', 'ChIJCZ5Yw4BNk2sREO4gf_HuAAQ', -25.9703262, 152.9869213, 'city', '1'),
('countries_australia_queensland_coolum_beach', 'ChIJm_UzT8lxk2sRUKne81qjAgU', -26.5291461, 153.0909772, 'city', '1'),
('countries_australia_queensland_coombabah', 'ChIJUyCt6bgRkWsR8KHe81qjAgU', -27.9000392, 153.3862846, 'city', '1'),
('countries_australia_queensland_coomera', 'ChIJ5R8xFKkWkWsRUNfe81qjAgU', -27.846439, 153.343953, 'city', '1'),
('countries_australia_queensland_coominya', 'ChIJL4zhJLWYlmsRYMAgf_HuAAQ', -27.391275, 152.5020772, 'city', '1'),
('countries_australia_queensland_coondoo', 'ChIJxe1zYWVZk2sR4O4gf_HuAAQ', -26.1970436, 152.8771704, 'city', '1'),
('countries_australia_queensland_coopers_plains', 'ChIJJRIsCkdFkWsRoIXe81qjAgU', -27.5704325, 153.0381708, 'city', '1'),
('countries_australia_queensland_cooran', 'ChIJf715WjGelGsRcMPe81qjAgU', -26.3354035, 152.8236306, 'city', '1'),
('countries_australia_queensland_cooroibah', 'ChIJVb37y9pnk2sRYKne81qjAgU', -26.3581567, 152.9903404, 'city', '1'),
('countries_australia_queensland_cooroy_mountain', 'ChIJUZ3bmkZkk2sRgKne81qjAgU', -26.4288365, 152.9371828, 'city', '1'),
('countries_australia_queensland_coorparoo', 'ChIJKWUQX0takWsRsIXe81qjAgU', -27.4945318, 153.0592549, 'city', '1'),
('countries_australia_queensland_cootharaba', 'ChIJM2JSP65dk2sRUMPe81qjAgU', -26.2922326, 152.9476505, 'city', '1'),
('countries_australia_queensland_cooya', 'ChIJZd1yV8mogmkRlGx2KfSL3v0', -16.443196, 145.4069174, 'city', '1'),
('countries_australia_queensland_cooyar', 'ChIJ4xhIPDPblWsRAMAgf_HuAAQ', -26.9821712, 151.831441, 'city', '1'),
('countries_australia_queensland_coral_cove', 'ChIJqZjWubyV62sRMBIhf_HuAAU', -24.885664, 152.4825092, 'city', '1'),
('countries_australia_queensland_corinda', 'ChIJoSQO0y9QkWsRwIXe81qjAgU', -27.5436211, 152.9809401, 'city', '1'),
('countries_australia_queensland_cornubia', 'ChIJyde4gARCkWsR0IXe81qjAgU', -27.670333, 153.2023867, 'city', '1'),
('countries_australia_queensland_cotswold_hills', 'ChIJUdAJiCVdlmsRIPYgf_HuAAU', -27.5241085, 151.8993547, 'city', '1'),
('countries_spain_canary_islands_los_llanos', 'ChIJF_CHhTXyawwRozp80m3jG4c', 28.6183515, -17.8998566, 'city', '0'),
('countries_australia_queensland_coulson', 'ChIJL-G6czLUlmsRoN4gf_HuAAQ', -27.9504666, 152.7228468, 'city', '1'),
('countries_australia_queensland_coverty', 'ChIJpaPfvPZ5lWsR4Okgf_HuAAQ', -26.2444046, 151.483791, 'city', '1'),
('countries_australia_queensland_cow_bay', 'ChIJszI1qJ5WnWkRwHQgf_HuAAQ', -16.2289293, 145.4566171, 'city', '1'),
('countries_australia_queensland_craiglie', 'ChIJrdbwyg6ngmkRcBAhf_HuAAU', -16.535421, 145.4676021, 'city', '1'),
('countries_australia_queensland_craignish', 'ChIJS4ByHC5562sRUPggf_HuAAU', -25.2823184, 152.7261103, 'city', '1'),
('countries_australia_queensland_cranbrook', 'ChIJB44CYAX61WsR4Psgf_HuAAU', -19.3021504, 146.7538672, 'city', '1'),
('countries_australia_queensland_cranley', 'ChIJ76jK_AxdlmsRMPYgf_HuAAU', -27.5158376, 151.9240063, 'city', '1'),
('countries_australia_queensland_cremorne', 'ChIJNTKs3QPU22sRgAMhf_HuAAU', -21.1337962, 149.1879404, 'city', '1'),
('countries_australia_queensland_crestmead', 'ChIJSWLymPNGkWsR8IXe81qjAgU', -27.6883904, 153.0874279, 'city', '1'),
('countries_australia_queensland_crossdale', 'ChIJ34lCv8UblGsRQMMgf_HuAAQ', -27.1876328, 152.5268367, 'city', '1'),
('countries_australia_queensland_crowley_vale', 'ChIJ64JOT4-UlmsRoOMgf_HuAAQ', -27.5436712, 152.3778426, 'city', '1'),
('countries_australia_queensland_crownthorpe', 'ChIJ1bBNd4IYlWsRsOcgf_HuAAQ', -26.0900497, 151.9576371, 'city', '1'),
('countries_australia_queensland_crows_nest', 'ChIJp9RnJ_59lmsREMAgf_HuAAQ', -27.2608989, 152.0545681, 'city', '1'),
('countries_australia_queensland_croydon', 'ChIJ65ZhfakliGkRgG0gf_HuAAQ', -18.2033248, 142.2422697, 'city', '1'),
('countries_australia_queensland_cullinane', 'ChIJw2JzQLXEeGkR8Pkgf_HuAAU', -17.5139315, 146.0300753, 'city', '1'),
('countries_australia_queensland_cungulla', 'ChIJv8wTDjAb1msRsIMgf_HuAAQ', -19.4019253, 147.1106511, 'city', '1'),
('countries_australia_queensland_cunnamulla', 'ChIJ23xTO6K3rGsRMKEgf_HuAAQ', -28.0709948, 145.6882115, 'city', '1'),
('countries_australia_queensland_curra', 'ChIJh19Ey3iwlGsRAO8gf_HuAAQ', -26.0841804, 152.5817098, 'city', '1'),
('countries_australia_queensland_currajong', 'ChIJrarAvpr51WsR8Psgf_HuAAU', -19.2774518, 146.7826264, 'city', '1'),
('countries_australia_queensland_curramore', 'ChIJkeyhlfJ-lGsRcMLe81qjAgU', -26.686891, 152.7954896, 'city', '1'),
('countries_australia_queensland_currimundi', 'ChIJL3qxqaKek2sRkKne81qjAgU', -26.7690271, 153.1186422, 'city', '1'),
('countries_australia_queensland_currumbin', 'ChIJn5o_6SYCkWsRMKLe81qjAgU', -28.1374671, 153.4755579, 'city', '1'),
('countries_australia_queensland_cushnie', 'ChIJJ9Zi26MLlWsRwOcgf_HuAAQ', -26.3617569, 151.7376843, 'city', '1'),
('countries_australia_queensland_dagun', 'ChIJMc-rOZaZlGsRoOggf_HuAAQ', -26.3216376, 152.6760975, 'city', '1'),
('countries_australia_queensland_daisy_hill', 'ChIJyQEhJ1NCkWsRMIbe81qjAgU', -27.6361016, 153.1548339, 'city', '1'),
('countries_australia_queensland_dakabin', 'ChIJR-F8te76k2sRQIbe81qjAgU', -27.2267702, 152.9825314, 'city', '1'),
('countries_australia_queensland_dalby', 'ChIJA3n0fLz5vWsRIKggf_HuAAQ', -27.182006, 151.2620588, 'city', '1'),
('countries_spain_canary_islands_lomo_de_arico', 'ChIJ9Vu5v78nQAwRwC9NvvNAAwQ', 28.1925961, -16.5112712, 'city', '0'),
('countries_australia_queensland_dalrymple_creek', 'ChIJyURFjNWof2kRgHwgf_HuAAQ', -18.5034647, 146.0416691, 'city', '1'),
('countries_australia_queensland_dalveen', 'ChIJaSE5E1eEl2sRIKsgf_HuAAQ', -28.4888743, 151.9706348, 'city', '1'),
('countries_australia_queensland_dangore', 'ChIJKfqRHXqQlWsREO0gf_HuAAQ', -26.469217, 151.5758123, 'city', '1'),
('countries_australia_queensland_darling_heights', 'ChIJHfIr7w5blmsRQPYgf_HuAAU', -27.593641, 151.9289033, 'city', '1'),
('countries_australia_queensland_darra', 'ChIJKbA1c1tOkWsRUIbe81qjAgU', -27.5613337, 152.9568256, 'city', '1'),
('countries_australia_queensland_dayboro', 'ChIJZSqhM474k2sRYIbe81qjAgU', -27.1970919, 152.8226676, 'city', '1'),
('countries_australia_queensland_deagon', 'ChIJZdmK1h7jk2sRQOXe81qjAgU', -27.3270681, 153.061884, 'city', '1'),
('countries_australia_queensland_deception_bay', 'ChIJJbZ2Cx7wk2sRgIbe81qjAgU', -27.1900809, 153.0172028, 'city', '1'),
('countries_australia_queensland_deebing_heights', 'ChIJP3X2LGrKlmsRQMTe81qjAgU', -27.6802195, 152.7588479, 'city', '1'),
('countries_australia_queensland_deeragun', 'ChIJ5xmZMZX21WsRAPwgf_HuAAU', -19.2493047, 146.676513, 'city', '1'),
('countries_australia_queensland_degarra', 'ChIJQUEjixJnnWkRAHUgf_HuAAQ', -15.9454952, 145.3407289, 'city', '1'),
('countries_australia_queensland_delan', 'ChIJEUQ3lKZU6msRUM8gf_HuAAQ', -25.0111162, 152.0469752, 'city', '1'),
('countries_australia_queensland_delaneys_creek', 'ChIJQdCHLagLlGsRkIbe81qjAgU', -27.0014912, 152.7882161, 'city', '1'),
('countries_australia_queensland_depot_hill', 'ChIJ81SG8naqw2sRUP8gf_HuAAU', -23.3910464, 150.5211908, 'city', '1'),
('countries_australia_queensland_derri_derra', 'ChIJpdUbxaH-v2sRYM8gf_HuAAQ', -25.7224678, 151.2196578, 'city', '1'),
('countries_australia_queensland_derrymore', 'ChIJ31eVT0JflmsR0N4gf_HuAAQ', -27.5875686, 152.0608169, 'city', '1'),
('countries_australia_queensland_deuchar', 'ChIJP6I3M3mkl2sRILIgf_HuAAQ', -28.1049698, 151.9619946, 'city', '1'),
('countries_australia_queensland_devereux_creek', 'ChIJH-Z9Hfgl2msRQIsgf_HuAAQ', -21.1163707, 148.884684, 'city', '1'),
('countries_australia_queensland_diamond_valley', 'ChIJfQvJRgSEk2sRoKne81qjAgU', -26.7540033, 152.9270716, 'city', '1'),
('countries_australia_queensland_dicky_beach', 'ChIJWQQXXciek2sRsKne81qjAgU', -26.7827257, 153.1328609, 'city', '1'),
('countries_australia_queensland_diddillibah', 'ChIJNakVfHl3k2sRwKne81qjAgU', -26.6434505, 153.0360853, 'city', '1'),
('countries_australia_queensland_dimbulah', 'ChIJ7S-uE4RqgmkRsHIgf_HuAAQ', -17.1490975, 145.1111032, 'city', '1'),
('countries_australia_queensland_dingo', 'ChIJu0In4SUuxGsRIJogf_HuAAQ', -23.6448633, 149.3310946, 'city', '1'),
('countries_australia_queensland_dingo_beach', 'ChIJS67azvAu2GsRgIQgf_HuAAQ', -20.091472, 148.4993021, 'city', '1'),
('countries_australia_queensland_dinmore', 'ChIJzw76JlJLkWsRoIbe81qjAgU', -27.5965008, 152.8320785, 'city', '1'),
('countries_australia_queensland_dirranbandi', 'ChIJvaZb6IoWr2sRYKEgf_HuAAQ', -28.5835611, 148.2282544, 'city', '1'),
('countries_australia_queensland_diwan', 'ChIJ967mEiRXnWkREHUgf_HuAAQ', -16.2060748, 145.4082296, 'city', '1'),
('countries_australia_queensland_djuan', 'ChIJwUoGvM15lmsR4MAgf_HuAAQ', -27.1813764, 151.9240408, 'city', '1'),
('countries_australia_queensland_dolphin_heads', 'ChIJKZDsxBF-2WsRkAMhf_HuAAU', -21.0349412, 149.1847256, 'city', '1'),
('countries_australia_queensland_donnybrook', 'ChIJgbbnI_2Sk2sRsIbe81qjAgU', -27.0044024, 153.0682668, 'city', '1'),
('countries_australia_queensland_doolandella', 'ChIJa9FM0ztPkWsRwIbe81qjAgU', -27.6130263, 152.9866773, 'city', '1'),
('countries_australia_queensland_doomadgee', 'ChIJY6Bu0pF7HmoRU0yOxCfiDyk', -17.9399667, 138.8292283, 'city', '1'),
('countries_australia_queensland_doonan', 'ChIJbeXpwnxvk2sR0Kne81qjAgU', -26.4552116, 153.0098384, 'city', '1'),
('countries_australia_queensland_doongul', 'ChIJ_d5bLBA_62sRoPEgf_HuAAQ', -25.4998768, 152.3683445, 'city', '1'),
('countries_australia_queensland_douglas', 'ChIJ6yZFD7ingmkRgBAhf_HuAAU', -16.4839732, 145.4622522, 'city', '1'),
('countries_australia_queensland_dows_creek', 'ChIJe0o2Hxsj2msRcIsgf_HuAAQ', -21.0972593, 148.7631284, 'city', '1'),
('countries_australia_queensland_draper', 'ChIJR-re1vBVkWsR8Ibe81qjAgU', -27.3481547, 152.901911, 'city', '1'),
('countries_australia_queensland_drayton', 'ChIJc20GKRRblmsRUPYgf_HuAAU', -27.5932624, 151.91274, 'city', '1'),
('countries_australia_queensland_drewvale', 'ChIJM7iCN3lGkWsRAIfe81qjAgU', -27.6535958, 153.0519489, 'city', '1'),
('countries_australia_queensland_drillham', 'ChIJ9aMzMNaovmsRkKcgf_HuAAQ', -26.641412, 149.982317, 'city', '1'),
('countries_australia_queensland_duaringa', 'ChIJefdiF94OxGsRMJogf_HuAAQ', -23.7195892, 149.6690262, 'city', '1'),
('countries_australia_queensland_dugandan', 'ChIJ_6fORjYol2sR4N4gf_HuAAQ', -28.0098985, 152.6813939, 'city', '1'),
('countries_australia_queensland_dulacca', 'ChIJtdYY59eqvmsRgKcgf_HuAAQ', -26.6435833, 149.7608349, 'city', '1'),
('countries_australia_queensland_dulong', 'ChIJGbheYF1_k2sR4Kne81qjAgU', -26.6378084, 152.8954425, 'city', '1'),
('countries_australia_queensland_dululu', 'ChIJD7GQujjDw2sRAMggf_HuAAQ', -23.8457432, 150.2618859, 'city', '1'),
('countries_australia_queensland_dumbleton', 'ChIJlQtFxtMs2msRgIsgf_HuAAQ', -21.1291927, 149.0759308, 'city', '1'),
('countries_australia_queensland_dundathu', 'ChIJ6cICKAxk62sRoPAgf_HuAAQ', -25.462957, 152.733981, 'city', '1'),
('countries_australia_queensland_dundowran_beach', 'ChIJFd6EAgR_62sRcPggf_HuAAU', -25.2754903, 152.7693852, 'city', '1'),
('countries_australia_queensland_dunnrock', 'ChIJeQxbZjLM22sR8AQhf_HuAAU', -21.2724837, 149.1832421, 'city', '1'),
('countries_australia_queensland_dunwich', 'ChIJ22BSASVjkWsREIfe81qjAgU', -27.4991711, 153.4037831, 'city', '1'),
('countries_australia_queensland_durack', 'ChIJFVgClwdPkWsRIIfe81qjAgU', -27.5882131, 152.9852619, 'city', '1'),
('countries_australia_queensland_durong', 'ChIJaWTHqtMrvmsRsOggf_HuAAQ', -26.3951879, 151.2435782, 'city', '1'),
('countries_australia_queensland_dutton_park', 'ChIJsUte0G9akWsRMIfe81qjAgU', -27.4954043, 153.025192, 'city', '1'),
('countries_australia_queensland_dysart', 'ChIJgaJo9l71z2sR0IIgf_HuAAQ', -22.5881385, 148.34863, 'city', '1'),
('countries_australia_queensland_d_aguilar', 'ChIJq8gpBrUKlGsRIIbe81qjAgU', -26.9871972, 152.7978703, 'city', '1'),
('countries_australia_queensland_eagleby', 'ChIJiZFbJ3VqkWsRYIfe81qjAgU', -27.7025667, 153.2130659, 'city', '1'),
('countries_australia_queensland_eagle_farm', 'ChIJ78-n1LVYkWsRQIfe81qjAgU', -27.4326992, 153.0941952, 'city', '1'),
('countries_spain_canary_islands_la_playa_de_arguineguin', 'ChIJ_QGHoft9PwwReJnKqhPQl4U', 27.7619672, -15.6833181, 'city', '0'),
('countries_australia_queensland_earlville', 'ChIJVe0wwpVjeGkRAAchf_HuAAU', -16.9428366, 145.7388074, 'city', '1'),
('countries_australia_queensland_eastern_heights', 'ChIJjYKpQ6u1lmsRkIfe81qjAgU', -27.6273989, 152.7713184, 'city', '1'),
('countries_australia_queensland_ea